/*
 * Decompiled with CFR 0.152.
 */
package xslt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import xslt.TrAX;

class XSLTSheetInfo {
    public Transformer transformer = null;
    public long lastModified = Long.MIN_VALUE;

    public XSLTSheetInfo(Source source) {
        String string = source.getSystemId();
        try {
            this.lastModified = this.getLastModified(string);
            this.transformer = TrAX.tFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
    }

    long getLastModified(String string) {
        long l = Long.MIN_VALUE;
        URL uRL = null;
        try {
            uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                File file = new File(uRL.getFile());
                l = file.lastModified();
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                l = uRLConnection.getLastModified();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Invalid URL " + uRL + ": " + malformedURLException.toString());
        }
        catch (IOException iOException) {
            System.err.println("Cannot access " + uRL + ": " + iOException.toString());
        }
        return l;
    }

    public Transformer getTransformer(Source source) {
        String string = source.getSystemId();
        long l = Long.MIN_VALUE;
        l = this.getLastModified(string);
        if (l <= this.lastModified && this.transformer != null) {
            return this.transformer;
        }
        try {
            this.transformer = TrAX.tFactory.newTransformer(source);
            this.lastModified = l;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("Could not create transformer for: " + string);
        }
        return this.transformer;
    }
}

