// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// libGLESv2_autogen.cpp: Implements the exported OpenGL ES functions.

#include "angle_gl.h"

#include "libGLESv2/entry_points_gles_1_0_autogen.h"
#include "libGLESv2/entry_points_gles_2_0_autogen.h"
#include "libGLESv2/entry_points_gles_3_0_autogen.h"
#include "libGLESv2/entry_points_gles_3_1_autogen.h"
#include "libGLESv2/entry_points_gles_3_2_autogen.h"
#include "libGLESv2/entry_points_gles_ext_autogen.h"

#if defined(ANGLE_ENABLE_GL_DESKTOP_FRONTEND)
#    include "libGLESv2/entry_points_gl_1_autogen.h"
#    include "libGLESv2/entry_points_gl_2_autogen.h"
#    include "libGLESv2/entry_points_gl_3_autogen.h"
#    include "libGLESv2/entry_points_gl_4_autogen.h"
#endif

#include "common/event_tracer.h"

extern "C" {

// OpenGL ES 2.0
void GL_APIENTRY glActiveTexture(GLenum texture)
{
    return GL_ActiveTexture(texture);
}

void GL_APIENTRY glAttachShader(GLuint program, GLuint shader)
{
    return GL_AttachShader(program, shader);
}

void GL_APIENTRY glBindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    return GL_BindAttribLocation(program, index, name);
}

void GL_APIENTRY glBindBuffer(GLenum target, GLuint buffer)
{
    return GL_BindBuffer(target, buffer);
}

void GL_APIENTRY glBindFramebuffer(GLenum target, GLuint framebuffer)
{
    return GL_BindFramebuffer(target, framebuffer);
}

void GL_APIENTRY glBindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    return GL_BindRenderbuffer(target, renderbuffer);
}

void GL_APIENTRY glBindTexture(GLenum target, GLuint texture)
{
    return GL_BindTexture(target, texture);
}

void GL_APIENTRY glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    return GL_BlendColor(red, green, blue, alpha);
}

void GL_APIENTRY glBlendEquation(GLenum mode)
{
    return GL_BlendEquation(mode);
}

void GL_APIENTRY glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    return GL_BlendEquationSeparate(modeRGB, modeAlpha);
}

void GL_APIENTRY glBlendFunc(GLenum sfactor, GLenum dfactor)
{
    return GL_BlendFunc(sfactor, dfactor);
}

void GL_APIENTRY glBlendFuncSeparate(GLenum sfactorRGB,
                                     GLenum dfactorRGB,
                                     GLenum sfactorAlpha,
                                     GLenum dfactorAlpha)
{
    return GL_BlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}

void GL_APIENTRY glBufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    return GL_BufferData(target, size, data, usage);
}

void GL_APIENTRY glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    return GL_BufferSubData(target, offset, size, data);
}

GLenum GL_APIENTRY glCheckFramebufferStatus(GLenum target)
{
    return GL_CheckFramebufferStatus(target);
}

void GL_APIENTRY glClear(GLbitfield mask)
{
    return GL_Clear(mask);
}

void GL_APIENTRY glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    return GL_ClearColor(red, green, blue, alpha);
}

void GL_APIENTRY glClearDepthf(GLfloat d)
{
    return GL_ClearDepthf(d);
}

void GL_APIENTRY glClearStencil(GLint s)
{
    return GL_ClearStencil(s);
}

void GL_APIENTRY glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    return GL_ColorMask(red, green, blue, alpha);
}

void GL_APIENTRY glCompileShader(GLuint shader)
{
    return GL_CompileShader(shader);
}

void GL_APIENTRY glCompressedTexImage2D(GLenum target,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    return GL_CompressedTexImage2D(target, level, internalformat, width, height, border, imageSize,
                                   data);
}

void GL_APIENTRY glCompressedTexSubImage2D(GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    return GL_CompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format,
                                      imageSize, data);
}

void GL_APIENTRY glCopyTexImage2D(GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLint border)
{
    return GL_CopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}

void GL_APIENTRY glCopyTexSubImage2D(GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    return GL_CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

GLuint GL_APIENTRY glCreateProgram()
{
    return GL_CreateProgram();
}

GLuint GL_APIENTRY glCreateShader(GLenum type)
{
    return GL_CreateShader(type);
}

void GL_APIENTRY glCullFace(GLenum mode)
{
    return GL_CullFace(mode);
}

void GL_APIENTRY glDeleteBuffers(GLsizei n, const GLuint *buffers)
{
    return GL_DeleteBuffers(n, buffers);
}

void GL_APIENTRY glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    return GL_DeleteFramebuffers(n, framebuffers);
}

void GL_APIENTRY glDeleteProgram(GLuint program)
{
    return GL_DeleteProgram(program);
}

void GL_APIENTRY glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    return GL_DeleteRenderbuffers(n, renderbuffers);
}

void GL_APIENTRY glDeleteShader(GLuint shader)
{
    return GL_DeleteShader(shader);
}

void GL_APIENTRY glDeleteTextures(GLsizei n, const GLuint *textures)
{
    return GL_DeleteTextures(n, textures);
}

void GL_APIENTRY glDepthFunc(GLenum func)
{
    return GL_DepthFunc(func);
}

void GL_APIENTRY glDepthMask(GLboolean flag)
{
    return GL_DepthMask(flag);
}

void GL_APIENTRY glDepthRangef(GLfloat n, GLfloat f)
{
    return GL_DepthRangef(n, f);
}

void GL_APIENTRY glDetachShader(GLuint program, GLuint shader)
{
    return GL_DetachShader(program, shader);
}

void GL_APIENTRY glDisable(GLenum cap)
{
    return GL_Disable(cap);
}

void GL_APIENTRY glDisableVertexAttribArray(GLuint index)
{
    return GL_DisableVertexAttribArray(index);
}

void GL_APIENTRY glDrawArrays(GLenum mode, GLint first, GLsizei count)
{
    return GL_DrawArrays(mode, first, count);
}

void GL_APIENTRY glDrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices)
{
    return GL_DrawElements(mode, count, type, indices);
}

void GL_APIENTRY glEnable(GLenum cap)
{
    return GL_Enable(cap);
}

void GL_APIENTRY glEnableVertexAttribArray(GLuint index)
{
    return GL_EnableVertexAttribArray(index);
}

void GL_APIENTRY glFinish()
{
    return GL_Finish();
}

void GL_APIENTRY glFlush()
{
    return GL_Flush();
}

void GL_APIENTRY glFramebufferRenderbuffer(GLenum target,
                                           GLenum attachment,
                                           GLenum renderbuffertarget,
                                           GLuint renderbuffer)
{
    return GL_FramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}

void GL_APIENTRY glFramebufferTexture2D(GLenum target,
                                        GLenum attachment,
                                        GLenum textarget,
                                        GLuint texture,
                                        GLint level)
{
    return GL_FramebufferTexture2D(target, attachment, textarget, texture, level);
}

void GL_APIENTRY glFrontFace(GLenum mode)
{
    return GL_FrontFace(mode);
}

void GL_APIENTRY glGenBuffers(GLsizei n, GLuint *buffers)
{
    return GL_GenBuffers(n, buffers);
}

void GL_APIENTRY glGenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    return GL_GenFramebuffers(n, framebuffers);
}

void GL_APIENTRY glGenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    return GL_GenRenderbuffers(n, renderbuffers);
}

void GL_APIENTRY glGenTextures(GLsizei n, GLuint *textures)
{
    return GL_GenTextures(n, textures);
}

void GL_APIENTRY glGenerateMipmap(GLenum target)
{
    return GL_GenerateMipmap(target);
}

void GL_APIENTRY glGetActiveAttrib(GLuint program,
                                   GLuint index,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLint *size,
                                   GLenum *type,
                                   GLchar *name)
{
    return GL_GetActiveAttrib(program, index, bufSize, length, size, type, name);
}

void GL_APIENTRY glGetActiveUniform(GLuint program,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    return GL_GetActiveUniform(program, index, bufSize, length, size, type, name);
}

void GL_APIENTRY glGetAttachedShaders(GLuint program,
                                      GLsizei maxCount,
                                      GLsizei *count,
                                      GLuint *shaders)
{
    return GL_GetAttachedShaders(program, maxCount, count, shaders);
}

GLint GL_APIENTRY glGetAttribLocation(GLuint program, const GLchar *name)
{
    return GL_GetAttribLocation(program, name);
}

void GL_APIENTRY glGetBooleanv(GLenum pname, GLboolean *data)
{
    return GL_GetBooleanv(pname, data);
}

void GL_APIENTRY glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetBufferParameteriv(target, pname, params);
}

GLenum GL_APIENTRY glGetError()
{
    return GL_GetError();
}

void GL_APIENTRY glGetFloatv(GLenum pname, GLfloat *data)
{
    return GL_GetFloatv(pname, data);
}

void GL_APIENTRY glGetFramebufferAttachmentParameteriv(GLenum target,
                                                       GLenum attachment,
                                                       GLenum pname,
                                                       GLint *params)
{
    return GL_GetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}

void GL_APIENTRY glGetIntegerv(GLenum pname, GLint *data)
{
    return GL_GetIntegerv(pname, data);
}

void GL_APIENTRY glGetProgramInfoLog(GLuint program,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    return GL_GetProgramInfoLog(program, bufSize, length, infoLog);
}

void GL_APIENTRY glGetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    return GL_GetProgramiv(program, pname, params);
}

void GL_APIENTRY glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetRenderbufferParameteriv(target, pname, params);
}

void GL_APIENTRY glGetShaderInfoLog(GLuint shader,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLchar *infoLog)
{
    return GL_GetShaderInfoLog(shader, bufSize, length, infoLog);
}

void GL_APIENTRY glGetShaderPrecisionFormat(GLenum shadertype,
                                            GLenum precisiontype,
                                            GLint *range,
                                            GLint *precision)
{
    return GL_GetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}

void GL_APIENTRY glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    return GL_GetShaderSource(shader, bufSize, length, source);
}

void GL_APIENTRY glGetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    return GL_GetShaderiv(shader, pname, params);
}

const GLubyte *GL_APIENTRY glGetString(GLenum name)
{
    return GL_GetString(name);
}

void GL_APIENTRY glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    return GL_GetTexParameterfv(target, pname, params);
}

void GL_APIENTRY glGetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetTexParameteriv(target, pname, params);
}

GLint GL_APIENTRY glGetUniformLocation(GLuint program, const GLchar *name)
{
    return GL_GetUniformLocation(program, name);
}

void GL_APIENTRY glGetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    return GL_GetUniformfv(program, location, params);
}

void GL_APIENTRY glGetUniformiv(GLuint program, GLint location, GLint *params)
{
    return GL_GetUniformiv(program, location, params);
}

void GL_APIENTRY glGetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    return GL_GetVertexAttribPointerv(index, pname, pointer);
}

void GL_APIENTRY glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    return GL_GetVertexAttribfv(index, pname, params);
}

void GL_APIENTRY glGetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    return GL_GetVertexAttribiv(index, pname, params);
}

void GL_APIENTRY glHint(GLenum target, GLenum mode)
{
    return GL_Hint(target, mode);
}

GLboolean GL_APIENTRY glIsBuffer(GLuint buffer)
{
    return GL_IsBuffer(buffer);
}

GLboolean GL_APIENTRY glIsEnabled(GLenum cap)
{
    return GL_IsEnabled(cap);
}

GLboolean GL_APIENTRY glIsFramebuffer(GLuint framebuffer)
{
    return GL_IsFramebuffer(framebuffer);
}

GLboolean GL_APIENTRY glIsProgram(GLuint program)
{
    return GL_IsProgram(program);
}

GLboolean GL_APIENTRY glIsRenderbuffer(GLuint renderbuffer)
{
    return GL_IsRenderbuffer(renderbuffer);
}

GLboolean GL_APIENTRY glIsShader(GLuint shader)
{
    return GL_IsShader(shader);
}

GLboolean GL_APIENTRY glIsTexture(GLuint texture)
{
    return GL_IsTexture(texture);
}

void GL_APIENTRY glLineWidth(GLfloat width)
{
    return GL_LineWidth(width);
}

void GL_APIENTRY glLinkProgram(GLuint program)
{
    return GL_LinkProgram(program);
}

void GL_APIENTRY glPixelStorei(GLenum pname, GLint param)
{
    return GL_PixelStorei(pname, param);
}

void GL_APIENTRY glPolygonOffset(GLfloat factor, GLfloat units)
{
    return GL_PolygonOffset(factor, units);
}

void GL_APIENTRY glReadPixels(GLint x,
                              GLint y,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              void *pixels)
{
    return GL_ReadPixels(x, y, width, height, format, type, pixels);
}

void GL_APIENTRY glReleaseShaderCompiler()
{
    return GL_ReleaseShaderCompiler();
}

void GL_APIENTRY glRenderbufferStorage(GLenum target,
                                       GLenum internalformat,
                                       GLsizei width,
                                       GLsizei height)
{
    return GL_RenderbufferStorage(target, internalformat, width, height);
}

void GL_APIENTRY glSampleCoverage(GLfloat value, GLboolean invert)
{
    return GL_SampleCoverage(value, invert);
}

void GL_APIENTRY glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    return GL_Scissor(x, y, width, height);
}

void GL_APIENTRY glShaderBinary(GLsizei count,
                                const GLuint *shaders,
                                GLenum binaryFormat,
                                const void *binary,
                                GLsizei length)
{
    return GL_ShaderBinary(count, shaders, binaryFormat, binary, length);
}

void GL_APIENTRY glShaderSource(GLuint shader,
                                GLsizei count,
                                const GLchar *const *string,
                                const GLint *length)
{
    return GL_ShaderSource(shader, count, string, length);
}

void GL_APIENTRY glStencilFunc(GLenum func, GLint ref, GLuint mask)
{
    return GL_StencilFunc(func, ref, mask);
}

void GL_APIENTRY glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    return GL_StencilFuncSeparate(face, func, ref, mask);
}

void GL_APIENTRY glStencilMask(GLuint mask)
{
    return GL_StencilMask(mask);
}

void GL_APIENTRY glStencilMaskSeparate(GLenum face, GLuint mask)
{
    return GL_StencilMaskSeparate(face, mask);
}

void GL_APIENTRY glStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    return GL_StencilOp(fail, zfail, zpass);
}

void GL_APIENTRY glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    return GL_StencilOpSeparate(face, sfail, dpfail, dppass);
}

void GL_APIENTRY glTexImage2D(GLenum target,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    return GL_TexImage2D(target, level, internalformat, width, height, border, format, type,
                         pixels);
}

void GL_APIENTRY glTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    return GL_TexParameterf(target, pname, param);
}

void GL_APIENTRY glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    return GL_TexParameterfv(target, pname, params);
}

void GL_APIENTRY glTexParameteri(GLenum target, GLenum pname, GLint param)
{
    return GL_TexParameteri(target, pname, param);
}

void GL_APIENTRY glTexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    return GL_TexParameteriv(target, pname, params);
}

void GL_APIENTRY glTexSubImage2D(GLenum target,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    return GL_TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

void GL_APIENTRY glUniform1f(GLint location, GLfloat v0)
{
    return GL_Uniform1f(location, v0);
}

void GL_APIENTRY glUniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    return GL_Uniform1fv(location, count, value);
}

void GL_APIENTRY glUniform1i(GLint location, GLint v0)
{
    return GL_Uniform1i(location, v0);
}

void GL_APIENTRY glUniform1iv(GLint location, GLsizei count, const GLint *value)
{
    return GL_Uniform1iv(location, count, value);
}

void GL_APIENTRY glUniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    return GL_Uniform2f(location, v0, v1);
}

void GL_APIENTRY glUniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    return GL_Uniform2fv(location, count, value);
}

void GL_APIENTRY glUniform2i(GLint location, GLint v0, GLint v1)
{
    return GL_Uniform2i(location, v0, v1);
}

void GL_APIENTRY glUniform2iv(GLint location, GLsizei count, const GLint *value)
{
    return GL_Uniform2iv(location, count, value);
}

void GL_APIENTRY glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    return GL_Uniform3f(location, v0, v1, v2);
}

void GL_APIENTRY glUniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    return GL_Uniform3fv(location, count, value);
}

void GL_APIENTRY glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    return GL_Uniform3i(location, v0, v1, v2);
}

void GL_APIENTRY glUniform3iv(GLint location, GLsizei count, const GLint *value)
{
    return GL_Uniform3iv(location, count, value);
}

void GL_APIENTRY glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    return GL_Uniform4f(location, v0, v1, v2, v3);
}

void GL_APIENTRY glUniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    return GL_Uniform4fv(location, count, value);
}

void GL_APIENTRY glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    return GL_Uniform4i(location, v0, v1, v2, v3);
}

void GL_APIENTRY glUniform4iv(GLint location, GLsizei count, const GLint *value)
{
    return GL_Uniform4iv(location, count, value);
}

void GL_APIENTRY glUniformMatrix2fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    return GL_UniformMatrix2fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    return GL_UniformMatrix3fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    return GL_UniformMatrix4fv(location, count, transpose, value);
}

void GL_APIENTRY glUseProgram(GLuint program)
{
    return GL_UseProgram(program);
}

void GL_APIENTRY glValidateProgram(GLuint program)
{
    return GL_ValidateProgram(program);
}

void GL_APIENTRY glVertexAttrib1f(GLuint index, GLfloat x)
{
    return GL_VertexAttrib1f(index, x);
}

void GL_APIENTRY glVertexAttrib1fv(GLuint index, const GLfloat *v)
{
    return GL_VertexAttrib1fv(index, v);
}

void GL_APIENTRY glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    return GL_VertexAttrib2f(index, x, y);
}

void GL_APIENTRY glVertexAttrib2fv(GLuint index, const GLfloat *v)
{
    return GL_VertexAttrib2fv(index, v);
}

void GL_APIENTRY glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    return GL_VertexAttrib3f(index, x, y, z);
}

void GL_APIENTRY glVertexAttrib3fv(GLuint index, const GLfloat *v)
{
    return GL_VertexAttrib3fv(index, v);
}

void GL_APIENTRY glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    return GL_VertexAttrib4f(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttrib4fv(GLuint index, const GLfloat *v)
{
    return GL_VertexAttrib4fv(index, v);
}

void GL_APIENTRY glVertexAttribPointer(GLuint index,
                                       GLint size,
                                       GLenum type,
                                       GLboolean normalized,
                                       GLsizei stride,
                                       const void *pointer)
{
    return GL_VertexAttribPointer(index, size, type, normalized, stride, pointer);
}

void GL_APIENTRY glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    return GL_Viewport(x, y, width, height);
}

// OpenGL ES 3.0
void GL_APIENTRY glBeginQuery(GLenum target, GLuint id)
{
    return GL_BeginQuery(target, id);
}

void GL_APIENTRY glBeginTransformFeedback(GLenum primitiveMode)
{
    return GL_BeginTransformFeedback(primitiveMode);
}

void GL_APIENTRY glBindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
    return GL_BindBufferBase(target, index, buffer);
}

void GL_APIENTRY
glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    return GL_BindBufferRange(target, index, buffer, offset, size);
}

void GL_APIENTRY glBindSampler(GLuint unit, GLuint sampler)
{
    return GL_BindSampler(unit, sampler);
}

void GL_APIENTRY glBindTransformFeedback(GLenum target, GLuint id)
{
    return GL_BindTransformFeedback(target, id);
}

void GL_APIENTRY glBindVertexArray(GLuint array)
{
    return GL_BindVertexArray(array);
}

void GL_APIENTRY glBlitFramebuffer(GLint srcX0,
                                   GLint srcY0,
                                   GLint srcX1,
                                   GLint srcY1,
                                   GLint dstX0,
                                   GLint dstY0,
                                   GLint dstX1,
                                   GLint dstY1,
                                   GLbitfield mask,
                                   GLenum filter)
{
    return GL_BlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

void GL_APIENTRY glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
    return GL_ClearBufferfi(buffer, drawbuffer, depth, stencil);
}

void GL_APIENTRY glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
    return GL_ClearBufferfv(buffer, drawbuffer, value);
}

void GL_APIENTRY glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
    return GL_ClearBufferiv(buffer, drawbuffer, value);
}

void GL_APIENTRY glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
    return GL_ClearBufferuiv(buffer, drawbuffer, value);
}

GLenum GL_APIENTRY glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    return GL_ClientWaitSync(sync, flags, timeout);
}

void GL_APIENTRY glCompressedTexImage3D(GLenum target,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    return GL_CompressedTexImage3D(target, level, internalformat, width, height, depth, border,
                                   imageSize, data);
}

void GL_APIENTRY glCompressedTexSubImage3D(GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint zoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    return GL_CompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height,
                                      depth, format, imageSize, data);
}

void GL_APIENTRY glCopyBufferSubData(GLenum readTarget,
                                     GLenum writeTarget,
                                     GLintptr readOffset,
                                     GLintptr writeOffset,
                                     GLsizeiptr size)
{
    return GL_CopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
}

void GL_APIENTRY glCopyTexSubImage3D(GLenum target,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    return GL_CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

void GL_APIENTRY glDeleteQueries(GLsizei n, const GLuint *ids)
{
    return GL_DeleteQueries(n, ids);
}

void GL_APIENTRY glDeleteSamplers(GLsizei count, const GLuint *samplers)
{
    return GL_DeleteSamplers(count, samplers);
}

void GL_APIENTRY glDeleteSync(GLsync sync)
{
    return GL_DeleteSync(sync);
}

void GL_APIENTRY glDeleteTransformFeedbacks(GLsizei n, const GLuint *ids)
{
    return GL_DeleteTransformFeedbacks(n, ids);
}

void GL_APIENTRY glDeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    return GL_DeleteVertexArrays(n, arrays);
}

void GL_APIENTRY glDrawArraysInstanced(GLenum mode,
                                       GLint first,
                                       GLsizei count,
                                       GLsizei instancecount)
{
    return GL_DrawArraysInstanced(mode, first, count, instancecount);
}

void GL_APIENTRY glDrawBuffers(GLsizei n, const GLenum *bufs)
{
    return GL_DrawBuffers(n, bufs);
}

void GL_APIENTRY glDrawElementsInstanced(GLenum mode,
                                         GLsizei count,
                                         GLenum type,
                                         const void *indices,
                                         GLsizei instancecount)
{
    return GL_DrawElementsInstanced(mode, count, type, indices, instancecount);
}

void GL_APIENTRY glDrawRangeElements(GLenum mode,
                                     GLuint start,
                                     GLuint end,
                                     GLsizei count,
                                     GLenum type,
                                     const void *indices)
{
    return GL_DrawRangeElements(mode, start, end, count, type, indices);
}

void GL_APIENTRY glEndQuery(GLenum target)
{
    return GL_EndQuery(target);
}

void GL_APIENTRY glEndTransformFeedback()
{
    return GL_EndTransformFeedback();
}

GLsync GL_APIENTRY glFenceSync(GLenum condition, GLbitfield flags)
{
    return GL_FenceSync(condition, flags);
}

void GL_APIENTRY glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    return GL_FlushMappedBufferRange(target, offset, length);
}

void GL_APIENTRY glFramebufferTextureLayer(GLenum target,
                                           GLenum attachment,
                                           GLuint texture,
                                           GLint level,
                                           GLint layer)
{
    return GL_FramebufferTextureLayer(target, attachment, texture, level, layer);
}

void GL_APIENTRY glGenQueries(GLsizei n, GLuint *ids)
{
    return GL_GenQueries(n, ids);
}

void GL_APIENTRY glGenSamplers(GLsizei count, GLuint *samplers)
{
    return GL_GenSamplers(count, samplers);
}

void GL_APIENTRY glGenTransformFeedbacks(GLsizei n, GLuint *ids)
{
    return GL_GenTransformFeedbacks(n, ids);
}

void GL_APIENTRY glGenVertexArrays(GLsizei n, GLuint *arrays)
{
    return GL_GenVertexArrays(n, arrays);
}

void GL_APIENTRY glGetActiveUniformBlockName(GLuint program,
                                             GLuint uniformBlockIndex,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *uniformBlockName)
{
    return GL_GetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length,
                                        uniformBlockName);
}

void GL_APIENTRY glGetActiveUniformBlockiv(GLuint program,
                                           GLuint uniformBlockIndex,
                                           GLenum pname,
                                           GLint *params)
{
    return GL_GetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
}

void GL_APIENTRY glGetActiveUniformsiv(GLuint program,
                                       GLsizei uniformCount,
                                       const GLuint *uniformIndices,
                                       GLenum pname,
                                       GLint *params)
{
    return GL_GetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
}

void GL_APIENTRY glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params)
{
    return GL_GetBufferParameteri64v(target, pname, params);
}

void GL_APIENTRY glGetBufferPointerv(GLenum target, GLenum pname, void **params)
{
    return GL_GetBufferPointerv(target, pname, params);
}

GLint GL_APIENTRY glGetFragDataLocation(GLuint program, const GLchar *name)
{
    return GL_GetFragDataLocation(program, name);
}

void GL_APIENTRY glGetInteger64i_v(GLenum target, GLuint index, GLint64 *data)
{
    return GL_GetInteger64i_v(target, index, data);
}

void GL_APIENTRY glGetInteger64v(GLenum pname, GLint64 *data)
{
    return GL_GetInteger64v(pname, data);
}

void GL_APIENTRY glGetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
    return GL_GetIntegeri_v(target, index, data);
}

void GL_APIENTRY glGetInternalformativ(GLenum target,
                                       GLenum internalformat,
                                       GLenum pname,
                                       GLsizei count,
                                       GLint *params)
{
    return GL_GetInternalformativ(target, internalformat, pname, count, params);
}

void GL_APIENTRY glGetProgramBinary(GLuint program,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLenum *binaryFormat,
                                    void *binary)
{
    return GL_GetProgramBinary(program, bufSize, length, binaryFormat, binary);
}

void GL_APIENTRY glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    return GL_GetQueryObjectuiv(id, pname, params);
}

void GL_APIENTRY glGetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetQueryiv(target, pname, params);
}

void GL_APIENTRY glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    return GL_GetSamplerParameterfv(sampler, pname, params);
}

void GL_APIENTRY glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    return GL_GetSamplerParameteriv(sampler, pname, params);
}

const GLubyte *GL_APIENTRY glGetStringi(GLenum name, GLuint index)
{
    return GL_GetStringi(name, index);
}

void GL_APIENTRY
glGetSynciv(GLsync sync, GLenum pname, GLsizei count, GLsizei *length, GLint *values)
{
    return GL_GetSynciv(sync, pname, count, length, values);
}

void GL_APIENTRY glGetTransformFeedbackVarying(GLuint program,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLsizei *size,
                                               GLenum *type,
                                               GLchar *name)
{
    return GL_GetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
}

GLuint GL_APIENTRY glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
    return GL_GetUniformBlockIndex(program, uniformBlockName);
}

void GL_APIENTRY glGetUniformIndices(GLuint program,
                                     GLsizei uniformCount,
                                     const GLchar *const *uniformNames,
                                     GLuint *uniformIndices)
{
    return GL_GetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
}

void GL_APIENTRY glGetUniformuiv(GLuint program, GLint location, GLuint *params)
{
    return GL_GetUniformuiv(program, location, params);
}

void GL_APIENTRY glGetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
    return GL_GetVertexAttribIiv(index, pname, params);
}

void GL_APIENTRY glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
    return GL_GetVertexAttribIuiv(index, pname, params);
}

void GL_APIENTRY glInvalidateFramebuffer(GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    return GL_InvalidateFramebuffer(target, numAttachments, attachments);
}

void GL_APIENTRY glInvalidateSubFramebuffer(GLenum target,
                                            GLsizei numAttachments,
                                            const GLenum *attachments,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height)
{
    return GL_InvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height);
}

GLboolean GL_APIENTRY glIsQuery(GLuint id)
{
    return GL_IsQuery(id);
}

GLboolean GL_APIENTRY glIsSampler(GLuint sampler)
{
    return GL_IsSampler(sampler);
}

GLboolean GL_APIENTRY glIsSync(GLsync sync)
{
    return GL_IsSync(sync);
}

GLboolean GL_APIENTRY glIsTransformFeedback(GLuint id)
{
    return GL_IsTransformFeedback(id);
}

GLboolean GL_APIENTRY glIsVertexArray(GLuint array)
{
    return GL_IsVertexArray(array);
}

void *GL_APIENTRY glMapBufferRange(GLenum target,
                                   GLintptr offset,
                                   GLsizeiptr length,
                                   GLbitfield access)
{
    return GL_MapBufferRange(target, offset, length, access);
}

void GL_APIENTRY glPauseTransformFeedback()
{
    return GL_PauseTransformFeedback();
}

void GL_APIENTRY glProgramBinary(GLuint program,
                                 GLenum binaryFormat,
                                 const void *binary,
                                 GLsizei length)
{
    return GL_ProgramBinary(program, binaryFormat, binary, length);
}

void GL_APIENTRY glProgramParameteri(GLuint program, GLenum pname, GLint value)
{
    return GL_ProgramParameteri(program, pname, value);
}

void GL_APIENTRY glReadBuffer(GLenum src)
{
    return GL_ReadBuffer(src);
}

void GL_APIENTRY glRenderbufferStorageMultisample(GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height)
{
    return GL_RenderbufferStorageMultisample(target, samples, internalformat, width, height);
}

void GL_APIENTRY glResumeTransformFeedback()
{
    return GL_ResumeTransformFeedback();
}

void GL_APIENTRY glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    return GL_SamplerParameterf(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    return GL_SamplerParameterfv(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    return GL_SamplerParameteri(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    return GL_SamplerParameteriv(sampler, pname, param);
}

void GL_APIENTRY glTexImage3D(GLenum target,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLsizei depth,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    return GL_TexImage3D(target, level, internalformat, width, height, depth, border, format, type,
                         pixels);
}

void GL_APIENTRY
glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    return GL_TexStorage2D(target, levels, internalformat, width, height);
}

void GL_APIENTRY glTexStorage3D(GLenum target,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width,
                                GLsizei height,
                                GLsizei depth)
{
    return GL_TexStorage3D(target, levels, internalformat, width, height, depth);
}

void GL_APIENTRY glTexSubImage3D(GLenum target,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLint zoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    return GL_TexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format,
                            type, pixels);
}

void GL_APIENTRY glTransformFeedbackVaryings(GLuint program,
                                             GLsizei count,
                                             const GLchar *const *varyings,
                                             GLenum bufferMode)
{
    return GL_TransformFeedbackVaryings(program, count, varyings, bufferMode);
}

void GL_APIENTRY glUniform1ui(GLint location, GLuint v0)
{
    return GL_Uniform1ui(location, v0);
}

void GL_APIENTRY glUniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
    return GL_Uniform1uiv(location, count, value);
}

void GL_APIENTRY glUniform2ui(GLint location, GLuint v0, GLuint v1)
{
    return GL_Uniform2ui(location, v0, v1);
}

void GL_APIENTRY glUniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
    return GL_Uniform2uiv(location, count, value);
}

void GL_APIENTRY glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    return GL_Uniform3ui(location, v0, v1, v2);
}

void GL_APIENTRY glUniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
    return GL_Uniform3uiv(location, count, value);
}

void GL_APIENTRY glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    return GL_Uniform4ui(location, v0, v1, v2, v3);
}

void GL_APIENTRY glUniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
    return GL_Uniform4uiv(location, count, value);
}

void GL_APIENTRY glUniformBlockBinding(GLuint program,
                                       GLuint uniformBlockIndex,
                                       GLuint uniformBlockBinding)
{
    return GL_UniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}

void GL_APIENTRY glUniformMatrix2x3fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix2x3fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix2x4fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix2x4fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3x2fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix3x2fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3x4fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix3x4fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4x2fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix4x2fv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4x3fv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    return GL_UniformMatrix4x3fv(location, count, transpose, value);
}

GLboolean GL_APIENTRY glUnmapBuffer(GLenum target)
{
    return GL_UnmapBuffer(target);
}

void GL_APIENTRY glVertexAttribDivisor(GLuint index, GLuint divisor)
{
    return GL_VertexAttribDivisor(index, divisor);
}

void GL_APIENTRY glVertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    return GL_VertexAttribI4i(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttribI4iv(GLuint index, const GLint *v)
{
    return GL_VertexAttribI4iv(index, v);
}

void GL_APIENTRY glVertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    return GL_VertexAttribI4ui(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttribI4uiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttribI4uiv(index, v);
}

void GL_APIENTRY
glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_VertexAttribIPointer(index, size, type, stride, pointer);
}

void GL_APIENTRY glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    return GL_WaitSync(sync, flags, timeout);
}

// OpenGL ES 3.1
void GL_APIENTRY glActiveShaderProgram(GLuint pipeline, GLuint program)
{
    return GL_ActiveShaderProgram(pipeline, program);
}

void GL_APIENTRY glBindImageTexture(GLuint unit,
                                    GLuint texture,
                                    GLint level,
                                    GLboolean layered,
                                    GLint layer,
                                    GLenum access,
                                    GLenum format)
{
    return GL_BindImageTexture(unit, texture, level, layered, layer, access, format);
}

void GL_APIENTRY glBindProgramPipeline(GLuint pipeline)
{
    return GL_BindProgramPipeline(pipeline);
}

void GL_APIENTRY glBindVertexBuffer(GLuint bindingindex,
                                    GLuint buffer,
                                    GLintptr offset,
                                    GLsizei stride)
{
    return GL_BindVertexBuffer(bindingindex, buffer, offset, stride);
}

GLuint GL_APIENTRY glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const *strings)
{
    return GL_CreateShaderProgramv(type, count, strings);
}

void GL_APIENTRY glDeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
    return GL_DeleteProgramPipelines(n, pipelines);
}

void GL_APIENTRY glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
    return GL_DispatchCompute(num_groups_x, num_groups_y, num_groups_z);
}

void GL_APIENTRY glDispatchComputeIndirect(GLintptr indirect)
{
    return GL_DispatchComputeIndirect(indirect);
}

void GL_APIENTRY glDrawArraysIndirect(GLenum mode, const void *indirect)
{
    return GL_DrawArraysIndirect(mode, indirect);
}

void GL_APIENTRY glDrawElementsIndirect(GLenum mode, GLenum type, const void *indirect)
{
    return GL_DrawElementsIndirect(mode, type, indirect);
}

void GL_APIENTRY glFramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
    return GL_FramebufferParameteri(target, pname, param);
}

void GL_APIENTRY glGenProgramPipelines(GLsizei n, GLuint *pipelines)
{
    return GL_GenProgramPipelines(n, pipelines);
}

void GL_APIENTRY glGetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    return GL_GetBooleani_v(target, index, data);
}

void GL_APIENTRY glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetFramebufferParameteriv(target, pname, params);
}

void GL_APIENTRY glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
    return GL_GetMultisamplefv(pname, index, val);
}

void GL_APIENTRY glGetProgramInterfaceiv(GLuint program,
                                         GLenum programInterface,
                                         GLenum pname,
                                         GLint *params)
{
    return GL_GetProgramInterfaceiv(program, programInterface, pname, params);
}

void GL_APIENTRY glGetProgramPipelineInfoLog(GLuint pipeline,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *infoLog)
{
    return GL_GetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
}

void GL_APIENTRY glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
    return GL_GetProgramPipelineiv(pipeline, pname, params);
}

GLuint GL_APIENTRY glGetProgramResourceIndex(GLuint program,
                                             GLenum programInterface,
                                             const GLchar *name)
{
    return GL_GetProgramResourceIndex(program, programInterface, name);
}

GLint GL_APIENTRY glGetProgramResourceLocation(GLuint program,
                                               GLenum programInterface,
                                               const GLchar *name)
{
    return GL_GetProgramResourceLocation(program, programInterface, name);
}

void GL_APIENTRY glGetProgramResourceName(GLuint program,
                                          GLenum programInterface,
                                          GLuint index,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLchar *name)
{
    return GL_GetProgramResourceName(program, programInterface, index, bufSize, length, name);
}

void GL_APIENTRY glGetProgramResourceiv(GLuint program,
                                        GLenum programInterface,
                                        GLuint index,
                                        GLsizei propCount,
                                        const GLenum *props,
                                        GLsizei count,
                                        GLsizei *length,
                                        GLint *params)
{
    return GL_GetProgramResourceiv(program, programInterface, index, propCount, props, count,
                                   length, params);
}

void GL_APIENTRY glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    return GL_GetTexLevelParameterfv(target, level, pname, params);
}

void GL_APIENTRY glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    return GL_GetTexLevelParameteriv(target, level, pname, params);
}

GLboolean GL_APIENTRY glIsProgramPipeline(GLuint pipeline)
{
    return GL_IsProgramPipeline(pipeline);
}

void GL_APIENTRY glMemoryBarrier(GLbitfield barriers)
{
    return GL_MemoryBarrier(barriers);
}

void GL_APIENTRY glMemoryBarrierByRegion(GLbitfield barriers)
{
    return GL_MemoryBarrierByRegion(barriers);
}

void GL_APIENTRY glProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
    return GL_ProgramUniform1f(program, location, v0);
}

void GL_APIENTRY glProgramUniform1fv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    return GL_ProgramUniform1fv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform1i(GLuint program, GLint location, GLint v0)
{
    return GL_ProgramUniform1i(program, location, v0);
}

void GL_APIENTRY glProgramUniform1iv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    return GL_ProgramUniform1iv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
    return GL_ProgramUniform1ui(program, location, v0);
}

void GL_APIENTRY glProgramUniform1uiv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    return GL_ProgramUniform1uiv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    return GL_ProgramUniform2f(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2fv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    return GL_ProgramUniform2fv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
    return GL_ProgramUniform2i(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2iv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    return GL_ProgramUniform2iv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    return GL_ProgramUniform2ui(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2uiv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    return GL_ProgramUniform2uiv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    return GL_ProgramUniform3f(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3fv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    return GL_ProgramUniform3fv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    return GL_ProgramUniform3i(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3iv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    return GL_ProgramUniform3iv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    return GL_ProgramUniform3ui(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3uiv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    return GL_ProgramUniform3uiv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    return GL_ProgramUniform4f(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4fv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLfloat *value)
{
    return GL_ProgramUniform4fv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    return GL_ProgramUniform4i(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4iv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLint *value)
{
    return GL_ProgramUniform4iv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    return GL_ProgramUniform4ui(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4uiv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLuint *value)
{
    return GL_ProgramUniform4uiv(program, location, count, value);
}

void GL_APIENTRY glProgramUniformMatrix2fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    return GL_ProgramUniformMatrix2fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x3fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix2x3fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x4fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix2x4fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    return GL_ProgramUniformMatrix3fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x2fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix3x2fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x4fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix3x4fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    return GL_ProgramUniformMatrix4fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x2fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix4x2fv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x3fv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    return GL_ProgramUniformMatrix4x3fv(program, location, count, transpose, value);
}

void GL_APIENTRY glSampleMaski(GLuint maskNumber, GLbitfield mask)
{
    return GL_SampleMaski(maskNumber, mask);
}

void GL_APIENTRY glTexStorage2DMultisample(GLenum target,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLboolean fixedsamplelocations)
{
    return GL_TexStorage2DMultisample(target, samples, internalformat, width, height,
                                      fixedsamplelocations);
}

void GL_APIENTRY glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
    return GL_UseProgramStages(pipeline, stages, program);
}

void GL_APIENTRY glValidateProgramPipeline(GLuint pipeline)
{
    return GL_ValidateProgramPipeline(pipeline);
}

void GL_APIENTRY glVertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
    return GL_VertexAttribBinding(attribindex, bindingindex);
}

void GL_APIENTRY glVertexAttribFormat(GLuint attribindex,
                                      GLint size,
                                      GLenum type,
                                      GLboolean normalized,
                                      GLuint relativeoffset)
{
    return GL_VertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
}

void GL_APIENTRY glVertexAttribIFormat(GLuint attribindex,
                                       GLint size,
                                       GLenum type,
                                       GLuint relativeoffset)
{
    return GL_VertexAttribIFormat(attribindex, size, type, relativeoffset);
}

void GL_APIENTRY glVertexBindingDivisor(GLuint bindingindex, GLuint divisor)
{
    return GL_VertexBindingDivisor(bindingindex, divisor);
}

// OpenGL ES 3.2
void GL_APIENTRY glBlendBarrier()
{
    return GL_BlendBarrier();
}

void GL_APIENTRY glBlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    return GL_BlendEquationSeparatei(buf, modeRGB, modeAlpha);
}

void GL_APIENTRY glBlendEquationi(GLuint buf, GLenum mode)
{
    return GL_BlendEquationi(buf, mode);
}

void GL_APIENTRY
glBlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    return GL_BlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

void GL_APIENTRY glBlendFunci(GLuint buf, GLenum src, GLenum dst)
{
    return GL_BlendFunci(buf, src, dst);
}

void GL_APIENTRY glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    return GL_ColorMaski(index, r, g, b, a);
}

void GL_APIENTRY glCopyImageSubData(GLuint srcName,
                                    GLenum srcTarget,
                                    GLint srcLevel,
                                    GLint srcX,
                                    GLint srcY,
                                    GLint srcZ,
                                    GLuint dstName,
                                    GLenum dstTarget,
                                    GLint dstLevel,
                                    GLint dstX,
                                    GLint dstY,
                                    GLint dstZ,
                                    GLsizei srcWidth,
                                    GLsizei srcHeight,
                                    GLsizei srcDepth)
{
    return GL_CopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget,
                               dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
}

void GL_APIENTRY glDebugMessageCallback(GLDEBUGPROC callback, const void *userParam)
{
    return GL_DebugMessageCallback(callback, userParam);
}

void GL_APIENTRY glDebugMessageControl(GLenum source,
                                       GLenum type,
                                       GLenum severity,
                                       GLsizei count,
                                       const GLuint *ids,
                                       GLboolean enabled)
{
    return GL_DebugMessageControl(source, type, severity, count, ids, enabled);
}

void GL_APIENTRY glDebugMessageInsert(GLenum source,
                                      GLenum type,
                                      GLuint id,
                                      GLenum severity,
                                      GLsizei length,
                                      const GLchar *buf)
{
    return GL_DebugMessageInsert(source, type, id, severity, length, buf);
}

void GL_APIENTRY glDisablei(GLenum target, GLuint index)
{
    return GL_Disablei(target, index);
}

void GL_APIENTRY glDrawElementsBaseVertex(GLenum mode,
                                          GLsizei count,
                                          GLenum type,
                                          const void *indices,
                                          GLint basevertex)
{
    return GL_DrawElementsBaseVertex(mode, count, type, indices, basevertex);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertex(GLenum mode,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLsizei instancecount,
                                                   GLint basevertex)
{
    return GL_DrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount,
                                              basevertex);
}

void GL_APIENTRY glDrawRangeElementsBaseVertex(GLenum mode,
                                               GLuint start,
                                               GLuint end,
                                               GLsizei count,
                                               GLenum type,
                                               const void *indices,
                                               GLint basevertex)
{
    return GL_DrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
}

void GL_APIENTRY glEnablei(GLenum target, GLuint index)
{
    return GL_Enablei(target, index);
}

void GL_APIENTRY glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
    return GL_FramebufferTexture(target, attachment, texture, level);
}

GLuint GL_APIENTRY glGetDebugMessageLog(GLuint count,
                                        GLsizei bufSize,
                                        GLenum *sources,
                                        GLenum *types,
                                        GLuint *ids,
                                        GLenum *severities,
                                        GLsizei *lengths,
                                        GLchar *messageLog)
{
    return GL_GetDebugMessageLog(count, bufSize, sources, types, ids, severities, lengths,
                                 messageLog);
}

GLenum GL_APIENTRY glGetGraphicsResetStatus()
{
    return GL_GetGraphicsResetStatus();
}

void GL_APIENTRY
glGetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    return GL_GetObjectLabel(identifier, name, bufSize, length, label);
}

void GL_APIENTRY glGetObjectPtrLabel(const void *ptr,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    return GL_GetObjectPtrLabel(ptr, bufSize, length, label);
}

void GL_APIENTRY glGetPointerv(GLenum pname, void **params)
{
    return GL_GetPointerv(pname, params);
}

void GL_APIENTRY glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    return GL_GetSamplerParameterIiv(sampler, pname, params);
}

void GL_APIENTRY glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    return GL_GetSamplerParameterIuiv(sampler, pname, params);
}

void GL_APIENTRY glGetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetTexParameterIiv(target, pname, params);
}

void GL_APIENTRY glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    return GL_GetTexParameterIuiv(target, pname, params);
}

void GL_APIENTRY glGetnUniformfv(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    return GL_GetnUniformfv(program, location, bufSize, params);
}

void GL_APIENTRY glGetnUniformiv(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    return GL_GetnUniformiv(program, location, bufSize, params);
}

void GL_APIENTRY glGetnUniformuiv(GLuint program, GLint location, GLsizei bufSize, GLuint *params)
{
    return GL_GetnUniformuiv(program, location, bufSize, params);
}

GLboolean GL_APIENTRY glIsEnabledi(GLenum target, GLuint index)
{
    return GL_IsEnabledi(target, index);
}

void GL_APIENTRY glMinSampleShading(GLfloat value)
{
    return GL_MinSampleShading(value);
}

void GL_APIENTRY glObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    return GL_ObjectLabel(identifier, name, length, label);
}

void GL_APIENTRY glObjectPtrLabel(const void *ptr, GLsizei length, const GLchar *label)
{
    return GL_ObjectPtrLabel(ptr, length, label);
}

void GL_APIENTRY glPatchParameteri(GLenum pname, GLint value)
{
    return GL_PatchParameteri(pname, value);
}

void GL_APIENTRY glPopDebugGroup()
{
    return GL_PopDebugGroup();
}

void GL_APIENTRY glPrimitiveBoundingBox(GLfloat minX,
                                        GLfloat minY,
                                        GLfloat minZ,
                                        GLfloat minW,
                                        GLfloat maxX,
                                        GLfloat maxY,
                                        GLfloat maxZ,
                                        GLfloat maxW)
{
    return GL_PrimitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
}

void GL_APIENTRY glPushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    return GL_PushDebugGroup(source, id, length, message);
}

void GL_APIENTRY glReadnPixels(GLint x,
                               GLint y,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               GLsizei bufSize,
                               void *data)
{
    return GL_ReadnPixels(x, y, width, height, format, type, bufSize, data);
}

void GL_APIENTRY glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    return GL_SamplerParameterIiv(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    return GL_SamplerParameterIuiv(sampler, pname, param);
}

void GL_APIENTRY glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer)
{
    return GL_TexBuffer(target, internalformat, buffer);
}

void GL_APIENTRY glTexBufferRange(GLenum target,
                                  GLenum internalformat,
                                  GLuint buffer,
                                  GLintptr offset,
                                  GLsizeiptr size)
{
    return GL_TexBufferRange(target, internalformat, buffer, offset, size);
}

void GL_APIENTRY glTexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    return GL_TexParameterIiv(target, pname, params);
}

void GL_APIENTRY glTexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    return GL_TexParameterIuiv(target, pname, params);
}

void GL_APIENTRY glTexStorage3DMultisample(GLenum target,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLboolean fixedsamplelocations)
{
    return GL_TexStorage3DMultisample(target, samples, internalformat, width, height, depth,
                                      fixedsamplelocations);
}

// OpenGL ES 1.0
void GL_APIENTRY glAlphaFunc(GLenum func, GLfloat ref)
{
    return GL_AlphaFunc(func, ref);
}

void GL_APIENTRY glAlphaFuncx(GLenum func, GLfixed ref)
{
    return GL_AlphaFuncx(func, ref);
}

void GL_APIENTRY glClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    return GL_ClearColorx(red, green, blue, alpha);
}

void GL_APIENTRY glClearDepthx(GLfixed depth)
{
    return GL_ClearDepthx(depth);
}

void GL_APIENTRY glClientActiveTexture(GLenum texture)
{
    return GL_ClientActiveTexture(texture);
}

void GL_APIENTRY glClipPlanef(GLenum p, const GLfloat *eqn)
{
    return GL_ClipPlanef(p, eqn);
}

void GL_APIENTRY glClipPlanex(GLenum plane, const GLfixed *equation)
{
    return GL_ClipPlanex(plane, equation);
}

void GL_APIENTRY glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    return GL_Color4f(red, green, blue, alpha);
}

void GL_APIENTRY glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    return GL_Color4ub(red, green, blue, alpha);
}

void GL_APIENTRY glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    return GL_Color4x(red, green, blue, alpha);
}

void GL_APIENTRY glColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_ColorPointer(size, type, stride, pointer);
}

void GL_APIENTRY glDepthRangex(GLfixed n, GLfixed f)
{
    return GL_DepthRangex(n, f);
}

void GL_APIENTRY glDisableClientState(GLenum array)
{
    return GL_DisableClientState(array);
}

void GL_APIENTRY glEnableClientState(GLenum array)
{
    return GL_EnableClientState(array);
}

void GL_APIENTRY glFogf(GLenum pname, GLfloat param)
{
    return GL_Fogf(pname, param);
}

void GL_APIENTRY glFogfv(GLenum pname, const GLfloat *params)
{
    return GL_Fogfv(pname, params);
}

void GL_APIENTRY glFogx(GLenum pname, GLfixed param)
{
    return GL_Fogx(pname, param);
}

void GL_APIENTRY glFogxv(GLenum pname, const GLfixed *param)
{
    return GL_Fogxv(pname, param);
}

void GL_APIENTRY glFrustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    return GL_Frustumf(l, r, b, t, n, f);
}

void GL_APIENTRY glFrustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    return GL_Frustumx(l, r, b, t, n, f);
}

void GL_APIENTRY glGetClipPlanef(GLenum plane, GLfloat *equation)
{
    return GL_GetClipPlanef(plane, equation);
}

void GL_APIENTRY glGetClipPlanex(GLenum plane, GLfixed *equation)
{
    return GL_GetClipPlanex(plane, equation);
}

void GL_APIENTRY glGetFixedv(GLenum pname, GLfixed *params)
{
    return GL_GetFixedv(pname, params);
}

void GL_APIENTRY glGetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    return GL_GetLightfv(light, pname, params);
}

void GL_APIENTRY glGetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    return GL_GetLightxv(light, pname, params);
}

void GL_APIENTRY glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    return GL_GetMaterialfv(face, pname, params);
}

void GL_APIENTRY glGetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    return GL_GetMaterialxv(face, pname, params);
}

void GL_APIENTRY glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    return GL_GetTexEnvfv(target, pname, params);
}

void GL_APIENTRY glGetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetTexEnviv(target, pname, params);
}

void GL_APIENTRY glGetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    return GL_GetTexEnvxv(target, pname, params);
}

void GL_APIENTRY glGetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    return GL_GetTexParameterxv(target, pname, params);
}

void GL_APIENTRY glLightModelf(GLenum pname, GLfloat param)
{
    return GL_LightModelf(pname, param);
}

void GL_APIENTRY glLightModelfv(GLenum pname, const GLfloat *params)
{
    return GL_LightModelfv(pname, params);
}

void GL_APIENTRY glLightModelx(GLenum pname, GLfixed param)
{
    return GL_LightModelx(pname, param);
}

void GL_APIENTRY glLightModelxv(GLenum pname, const GLfixed *param)
{
    return GL_LightModelxv(pname, param);
}

void GL_APIENTRY glLightf(GLenum light, GLenum pname, GLfloat param)
{
    return GL_Lightf(light, pname, param);
}

void GL_APIENTRY glLightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    return GL_Lightfv(light, pname, params);
}

void GL_APIENTRY glLightx(GLenum light, GLenum pname, GLfixed param)
{
    return GL_Lightx(light, pname, param);
}

void GL_APIENTRY glLightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    return GL_Lightxv(light, pname, params);
}

void GL_APIENTRY glLineWidthx(GLfixed width)
{
    return GL_LineWidthx(width);
}

void GL_APIENTRY glLoadIdentity()
{
    return GL_LoadIdentity();
}

void GL_APIENTRY glLoadMatrixf(const GLfloat *m)
{
    return GL_LoadMatrixf(m);
}

void GL_APIENTRY glLoadMatrixx(const GLfixed *m)
{
    return GL_LoadMatrixx(m);
}

void GL_APIENTRY glLogicOp(GLenum opcode)
{
    return GL_LogicOp(opcode);
}

void GL_APIENTRY glMaterialf(GLenum face, GLenum pname, GLfloat param)
{
    return GL_Materialf(face, pname, param);
}

void GL_APIENTRY glMaterialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    return GL_Materialfv(face, pname, params);
}

void GL_APIENTRY glMaterialx(GLenum face, GLenum pname, GLfixed param)
{
    return GL_Materialx(face, pname, param);
}

void GL_APIENTRY glMaterialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    return GL_Materialxv(face, pname, param);
}

void GL_APIENTRY glMatrixMode(GLenum mode)
{
    return GL_MatrixMode(mode);
}

void GL_APIENTRY glMultMatrixf(const GLfloat *m)
{
    return GL_MultMatrixf(m);
}

void GL_APIENTRY glMultMatrixx(const GLfixed *m)
{
    return GL_MultMatrixx(m);
}

void GL_APIENTRY glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    return GL_MultiTexCoord4f(target, s, t, r, q);
}

void GL_APIENTRY glMultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    return GL_MultiTexCoord4x(texture, s, t, r, q);
}

void GL_APIENTRY glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    return GL_Normal3f(nx, ny, nz);
}

void GL_APIENTRY glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    return GL_Normal3x(nx, ny, nz);
}

void GL_APIENTRY glNormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    return GL_NormalPointer(type, stride, pointer);
}

void GL_APIENTRY glOrthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    return GL_Orthof(l, r, b, t, n, f);
}

void GL_APIENTRY glOrthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    return GL_Orthox(l, r, b, t, n, f);
}

void GL_APIENTRY glPointParameterf(GLenum pname, GLfloat param)
{
    return GL_PointParameterf(pname, param);
}

void GL_APIENTRY glPointParameterfv(GLenum pname, const GLfloat *params)
{
    return GL_PointParameterfv(pname, params);
}

void GL_APIENTRY glPointParameterx(GLenum pname, GLfixed param)
{
    return GL_PointParameterx(pname, param);
}

void GL_APIENTRY glPointParameterxv(GLenum pname, const GLfixed *params)
{
    return GL_PointParameterxv(pname, params);
}

void GL_APIENTRY glPointSize(GLfloat size)
{
    return GL_PointSize(size);
}

void GL_APIENTRY glPointSizex(GLfixed size)
{
    return GL_PointSizex(size);
}

void GL_APIENTRY glPolygonOffsetx(GLfixed factor, GLfixed units)
{
    return GL_PolygonOffsetx(factor, units);
}

void GL_APIENTRY glPopMatrix()
{
    return GL_PopMatrix();
}

void GL_APIENTRY glPushMatrix()
{
    return GL_PushMatrix();
}

void GL_APIENTRY glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    return GL_Rotatef(angle, x, y, z);
}

void GL_APIENTRY glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    return GL_Rotatex(angle, x, y, z);
}

void GL_APIENTRY glSampleCoveragex(GLclampx value, GLboolean invert)
{
    return GL_SampleCoveragex(value, invert);
}

void GL_APIENTRY glScalef(GLfloat x, GLfloat y, GLfloat z)
{
    return GL_Scalef(x, y, z);
}

void GL_APIENTRY glScalex(GLfixed x, GLfixed y, GLfixed z)
{
    return GL_Scalex(x, y, z);
}

void GL_APIENTRY glShadeModel(GLenum mode)
{
    return GL_ShadeModel(mode);
}

void GL_APIENTRY glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_TexCoordPointer(size, type, stride, pointer);
}

void GL_APIENTRY glTexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    return GL_TexEnvf(target, pname, param);
}

void GL_APIENTRY glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    return GL_TexEnvfv(target, pname, params);
}

void GL_APIENTRY glTexEnvi(GLenum target, GLenum pname, GLint param)
{
    return GL_TexEnvi(target, pname, param);
}

void GL_APIENTRY glTexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    return GL_TexEnviv(target, pname, params);
}

void GL_APIENTRY glTexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    return GL_TexEnvx(target, pname, param);
}

void GL_APIENTRY glTexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    return GL_TexEnvxv(target, pname, params);
}

void GL_APIENTRY glTexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    return GL_TexParameterx(target, pname, param);
}

void GL_APIENTRY glTexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    return GL_TexParameterxv(target, pname, params);
}

void GL_APIENTRY glTranslatef(GLfloat x, GLfloat y, GLfloat z)
{
    return GL_Translatef(x, y, z);
}

void GL_APIENTRY glTranslatex(GLfixed x, GLfixed y, GLfixed z)
{
    return GL_Translatex(x, y, z);
}

void GL_APIENTRY glVertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_VertexPointer(size, type, stride, pointer);
}

// GL_AMD_performance_monitor
void GL_APIENTRY glBeginPerfMonitorAMD(GLuint monitor)
{
    return GL_BeginPerfMonitorAMD(monitor);
}

void GL_APIENTRY glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    return GL_DeletePerfMonitorsAMD(n, monitors);
}

void GL_APIENTRY glEndPerfMonitorAMD(GLuint monitor)
{
    return GL_EndPerfMonitorAMD(monitor);
}

void GL_APIENTRY glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors)
{
    return GL_GenPerfMonitorsAMD(n, monitors);
}

void GL_APIENTRY glGetPerfMonitorCounterDataAMD(GLuint monitor,
                                                GLenum pname,
                                                GLsizei dataSize,
                                                GLuint *data,
                                                GLint *bytesWritten)
{
    return GL_GetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
}

void GL_APIENTRY glGetPerfMonitorCounterInfoAMD(GLuint group,
                                                GLuint counter,
                                                GLenum pname,
                                                void *data)
{
    return GL_GetPerfMonitorCounterInfoAMD(group, counter, pname, data);
}

void GL_APIENTRY glGetPerfMonitorCounterStringAMD(GLuint group,
                                                  GLuint counter,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *counterString)
{
    return GL_GetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
}

void GL_APIENTRY glGetPerfMonitorCountersAMD(GLuint group,
                                             GLint *numCounters,
                                             GLint *maxActiveCounters,
                                             GLsizei counterSize,
                                             GLuint *counters)
{
    return GL_GetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize,
                                        counters);
}

void GL_APIENTRY glGetPerfMonitorGroupStringAMD(GLuint group,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLchar *groupString)
{
    return GL_GetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
}

void GL_APIENTRY glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups)
{
    return GL_GetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
}

void GL_APIENTRY glSelectPerfMonitorCountersAMD(GLuint monitor,
                                                GLboolean enable,
                                                GLuint group,
                                                GLint numCounters,
                                                GLuint *counterList)
{
    return GL_SelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
}

// GL_ANDROID_extension_pack_es31a

// GL_ANGLE_base_vertex_base_instance
void GL_APIENTRY glDrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                        GLint first,
                                                        GLsizei count,
                                                        GLsizei instanceCount,
                                                        GLuint baseInstance)
{
    return GL_DrawArraysInstancedBaseInstanceANGLE(mode, first, count, instanceCount, baseInstance);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                                    GLsizei count,
                                                                    GLenum type,
                                                                    const void *indices,
                                                                    GLsizei instanceCount,
                                                                    GLint baseVertex,
                                                                    GLuint baseInstance)
{
    return GL_DrawElementsInstancedBaseVertexBaseInstanceANGLE(
        mode, count, type, indices, instanceCount, baseVertex, baseInstance);
}

void GL_APIENTRY glMultiDrawArraysInstancedBaseInstanceANGLE(GLenum mode,
                                                             const GLint *firsts,
                                                             const GLsizei *counts,
                                                             const GLsizei *instanceCounts,
                                                             const GLuint *baseInstances,
                                                             GLsizei drawcount)
{
    return GL_MultiDrawArraysInstancedBaseInstanceANGLE(mode, firsts, counts, instanceCounts,
                                                        baseInstances, drawcount);
}

void GL_APIENTRY
glMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(GLenum mode,
                                                        const GLsizei *counts,
                                                        GLenum type,
                                                        const void *const *indices,
                                                        const GLsizei *instanceCounts,
                                                        const GLint *baseVertices,
                                                        const GLuint *baseInstances,
                                                        GLsizei drawcount)
{
    return GL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
        mode, counts, type, indices, instanceCounts, baseVertices, baseInstances, drawcount);
}

// GL_ANGLE_clip_cull_distance

// GL_ANGLE_copy_texture_3d
void GL_APIENTRY glCopyTexture3DANGLE(GLuint sourceId,
                                      GLint sourceLevel,
                                      GLenum destTarget,
                                      GLuint destId,
                                      GLint destLevel,
                                      GLint internalFormat,
                                      GLenum destType,
                                      GLboolean unpackFlipY,
                                      GLboolean unpackPremultiplyAlpha,
                                      GLboolean unpackUnmultiplyAlpha)
{
    return GL_CopyTexture3DANGLE(sourceId, sourceLevel, destTarget, destId, destLevel,
                                 internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                 unpackUnmultiplyAlpha);
}

void GL_APIENTRY glCopySubTexture3DANGLE(GLuint sourceId,
                                         GLint sourceLevel,
                                         GLenum destTarget,
                                         GLuint destId,
                                         GLint destLevel,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLint z,
                                         GLint width,
                                         GLint height,
                                         GLint depth,
                                         GLboolean unpackFlipY,
                                         GLboolean unpackPremultiplyAlpha,
                                         GLboolean unpackUnmultiplyAlpha)
{
    return GL_CopySubTexture3DANGLE(sourceId, sourceLevel, destTarget, destId, destLevel, xoffset,
                                    yoffset, zoffset, x, y, z, width, height, depth, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
}

// GL_ANGLE_depth_texture

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY glBlitFramebufferANGLE(GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    return GL_BlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                   filter);
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY glRenderbufferStorageMultisampleANGLE(GLenum target,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    return GL_RenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
}

// GL_ANGLE_get_image
void GL_APIENTRY
glGetTexImageANGLE(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    return GL_GetTexImageANGLE(target, level, format, type, pixels);
}

void GL_APIENTRY glGetCompressedTexImageANGLE(GLenum target, GLint level, void *pixels)
{
    return GL_GetCompressedTexImageANGLE(target, level, pixels);
}

void GL_APIENTRY glGetRenderbufferImageANGLE(GLenum target,
                                             GLenum format,
                                             GLenum type,
                                             void *pixels)
{
    return GL_GetRenderbufferImageANGLE(target, format, type, pixels);
}

// GL_ANGLE_get_tex_level_parameter
void GL_APIENTRY glGetTexLevelParameterivANGLE(GLenum target,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    return GL_GetTexLevelParameterivANGLE(target, level, pname, params);
}

void GL_APIENTRY glGetTexLevelParameterfvANGLE(GLenum target,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    return GL_GetTexLevelParameterfvANGLE(target, level, pname, params);
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY glDrawArraysInstancedANGLE(GLenum mode,
                                            GLint first,
                                            GLsizei count,
                                            GLsizei primcount)
{
    return GL_DrawArraysInstancedANGLE(mode, first, count, primcount);
}

void GL_APIENTRY glDrawElementsInstancedANGLE(GLenum mode,
                                              GLsizei count,
                                              GLenum type,
                                              const void *indices,
                                              GLsizei primcount)
{
    return GL_DrawElementsInstancedANGLE(mode, count, type, indices, primcount);
}

void GL_APIENTRY glVertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    return GL_VertexAttribDivisorANGLE(index, divisor);
}

// GL_ANGLE_logic_op
void GL_APIENTRY glLogicOpANGLE(GLenum opcode)
{
    return GL_LogicOpANGLE(opcode);
}

// GL_ANGLE_memory_object_flags
void GL_APIENTRY glTexStorageMemFlags2DANGLE(GLenum target,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLuint memory,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags,
                                             const void *imageCreateInfoPNext)
{
    return GL_TexStorageMemFlags2DANGLE(target, levels, internalFormat, width, height, memory,
                                        offset, createFlags, usageFlags, imageCreateInfoPNext);
}

void GL_APIENTRY glTexStorageMemFlags2DMultisampleANGLE(GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLboolean fixedSampleLocations,
                                                        GLuint memory,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags,
                                                        const void *imageCreateInfoPNext)
{
    return GL_TexStorageMemFlags2DMultisampleANGLE(target, samples, internalFormat, width, height,
                                                   fixedSampleLocations, memory, offset,
                                                   createFlags, usageFlags, imageCreateInfoPNext);
}

void GL_APIENTRY glTexStorageMemFlags3DANGLE(GLenum target,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLuint memory,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags,
                                             const void *imageCreateInfoPNext)
{
    return GL_TexStorageMemFlags3DANGLE(target, levels, internalFormat, width, height, depth,
                                        memory, offset, createFlags, usageFlags,
                                        imageCreateInfoPNext);
}

void GL_APIENTRY glTexStorageMemFlags3DMultisampleANGLE(GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLboolean fixedSampleLocations,
                                                        GLuint memory,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags,
                                                        const void *imageCreateInfoPNext)
{
    return GL_TexStorageMemFlags3DMultisampleANGLE(target, samples, internalFormat, width, height,
                                                   depth, fixedSampleLocations, memory, offset,
                                                   createFlags, usageFlags, imageCreateInfoPNext);
}

// GL_ANGLE_memory_object_fuchsia
void GL_APIENTRY glImportMemoryZirconHandleANGLE(GLuint memory,
                                                 GLuint64 size,
                                                 GLenum handleType,
                                                 GLuint handle)
{
    return GL_ImportMemoryZirconHandleANGLE(memory, size, handleType, handle);
}

// GL_ANGLE_multi_draw
void GL_APIENTRY glMultiDrawArraysANGLE(GLenum mode,
                                        const GLint *firsts,
                                        const GLsizei *counts,
                                        GLsizei drawcount)
{
    return GL_MultiDrawArraysANGLE(mode, firsts, counts, drawcount);
}

void GL_APIENTRY glMultiDrawArraysInstancedANGLE(GLenum mode,
                                                 const GLint *firsts,
                                                 const GLsizei *counts,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    return GL_MultiDrawArraysInstancedANGLE(mode, firsts, counts, instanceCounts, drawcount);
}

void GL_APIENTRY glMultiDrawElementsANGLE(GLenum mode,
                                          const GLsizei *counts,
                                          GLenum type,
                                          const void *const *indices,
                                          GLsizei drawcount)
{
    return GL_MultiDrawElementsANGLE(mode, counts, type, indices, drawcount);
}

void GL_APIENTRY glMultiDrawElementsInstancedANGLE(GLenum mode,
                                                   const GLsizei *counts,
                                                   GLenum type,
                                                   const void *const *indices,
                                                   const GLsizei *instanceCounts,
                                                   GLsizei drawcount)
{
    return GL_MultiDrawElementsInstancedANGLE(mode, counts, type, indices, instanceCounts,
                                              drawcount);
}

// GL_ANGLE_pack_reverse_row_order

// GL_ANGLE_polygon_mode
void GL_APIENTRY glPolygonModeANGLE(GLenum face, GLenum mode)
{
    return GL_PolygonModeANGLE(face, mode);
}

// GL_ANGLE_program_binary

// GL_ANGLE_provoking_vertex
void GL_APIENTRY glProvokingVertexANGLE(GLenum provokeMode)
{
    return GL_ProvokingVertexANGLE(provokeMode);
}

// GL_ANGLE_renderability_validation

// GL_ANGLE_request_extension
void GL_APIENTRY glRequestExtensionANGLE(const GLchar *name)
{
    return GL_RequestExtensionANGLE(name);
}

void GL_APIENTRY glDisableExtensionANGLE(const GLchar *name)
{
    return GL_DisableExtensionANGLE(name);
}

// GL_ANGLE_robust_client_memory
void GL_APIENTRY glGetBooleanvRobustANGLE(GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *params)
{
    return GL_GetBooleanvRobustANGLE(pname, bufSize, length, params);
}

void GL_APIENTRY glGetBufferParameterivRobustANGLE(GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    return GL_GetBufferParameterivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetFloatvRobustANGLE(GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLfloat *params)
{
    return GL_GetFloatvRobustANGLE(pname, bufSize, length, params);
}

void GL_APIENTRY glGetFramebufferAttachmentParameterivRobustANGLE(GLenum target,
                                                                  GLenum attachment,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    return GL_GetFramebufferAttachmentParameterivRobustANGLE(target, attachment, pname, bufSize,
                                                             length, params);
}

void GL_APIENTRY glGetIntegervRobustANGLE(GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *data)
{
    return GL_GetIntegervRobustANGLE(pname, bufSize, length, data);
}

void GL_APIENTRY glGetProgramivRobustANGLE(GLuint program,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    return GL_GetProgramivRobustANGLE(program, pname, bufSize, length, params);
}

void GL_APIENTRY glGetRenderbufferParameterivRobustANGLE(GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    return GL_GetRenderbufferParameterivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetShaderivRobustANGLE(GLuint shader,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    return GL_GetShaderivRobustANGLE(shader, pname, bufSize, length, params);
}

void GL_APIENTRY glGetTexParameterfvRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    return GL_GetTexParameterfvRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetTexParameterivRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    return GL_GetTexParameterivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetUniformfvRobustANGLE(GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLfloat *params)
{
    return GL_GetUniformfvRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glGetUniformivRobustANGLE(GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    return GL_GetUniformivRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glGetVertexAttribfvRobustANGLE(GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    return GL_GetVertexAttribfvRobustANGLE(index, pname, bufSize, length, params);
}

void GL_APIENTRY glGetVertexAttribivRobustANGLE(GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    return GL_GetVertexAttribivRobustANGLE(index, pname, bufSize, length, params);
}

void GL_APIENTRY glGetVertexAttribPointervRobustANGLE(GLuint index,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **pointer)
{
    return GL_GetVertexAttribPointervRobustANGLE(index, pname, bufSize, length, pointer);
}

void GL_APIENTRY glReadPixelsRobustANGLE(GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLsizei *columns,
                                         GLsizei *rows,
                                         void *pixels)
{
    return GL_ReadPixelsRobustANGLE(x, y, width, height, format, type, bufSize, length, columns,
                                    rows, pixels);
}

void GL_APIENTRY glTexImage2DRobustANGLE(GLenum target,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    return GL_TexImage2DRobustANGLE(target, level, internalformat, width, height, border, format,
                                    type, bufSize, pixels);
}

void GL_APIENTRY glTexParameterfvRobustANGLE(GLenum target,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLfloat *params)
{
    return GL_TexParameterfvRobustANGLE(target, pname, bufSize, params);
}

void GL_APIENTRY glTexParameterivRobustANGLE(GLenum target,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLint *params)
{
    return GL_TexParameterivRobustANGLE(target, pname, bufSize, params);
}

void GL_APIENTRY glTexSubImage2DRobustANGLE(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    return GL_TexSubImage2DRobustANGLE(target, level, xoffset, yoffset, width, height, format, type,
                                       bufSize, pixels);
}

void GL_APIENTRY glTexImage3DRobustANGLE(GLenum target,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    return GL_TexImage3DRobustANGLE(target, level, internalformat, width, height, depth, border,
                                    format, type, bufSize, pixels);
}

void GL_APIENTRY glTexSubImage3DRobustANGLE(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    return GL_TexSubImage3DRobustANGLE(target, level, xoffset, yoffset, zoffset, width, height,
                                       depth, format, type, bufSize, pixels);
}

void GL_APIENTRY glCompressedTexImage2DRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const void *data)
{
    return GL_CompressedTexImage2DRobustANGLE(target, level, internalformat, width, height, border,
                                              imageSize, dataSize, data);
}

void GL_APIENTRY glCompressedTexSubImage2DRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLsizei xoffset,
                                                      GLsizei yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const void *data)
{
    return GL_CompressedTexSubImage2DRobustANGLE(target, level, xoffset, yoffset, width, height,
                                                 format, imageSize, dataSize, data);
}

void GL_APIENTRY glCompressedTexImage3DRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const void *data)
{
    return GL_CompressedTexImage3DRobustANGLE(target, level, internalformat, width, height, depth,
                                              border, imageSize, dataSize, data);
}

void GL_APIENTRY glCompressedTexSubImage3DRobustANGLE(GLenum target,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const void *data)
{
    return GL_CompressedTexSubImage3DRobustANGLE(target, level, xoffset, yoffset, zoffset, width,
                                                 height, depth, format, imageSize, dataSize, data);
}

void GL_APIENTRY glGetQueryivRobustANGLE(GLenum target,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    return GL_GetQueryivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetQueryObjectuivRobustANGLE(GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    return GL_GetQueryObjectuivRobustANGLE(id, pname, bufSize, length, params);
}

void GL_APIENTRY glGetBufferPointervRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **params)
{
    return GL_GetBufferPointervRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetIntegeri_vRobustANGLE(GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *data)
{
    return GL_GetIntegeri_vRobustANGLE(target, index, bufSize, length, data);
}

void GL_APIENTRY glGetInternalformativRobustANGLE(GLenum target,
                                                  GLenum internalformat,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    return GL_GetInternalformativRobustANGLE(target, internalformat, pname, bufSize, length,
                                             params);
}

void GL_APIENTRY glGetVertexAttribIivRobustANGLE(GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    return GL_GetVertexAttribIivRobustANGLE(index, pname, bufSize, length, params);
}

void GL_APIENTRY glGetVertexAttribIuivRobustANGLE(GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    return GL_GetVertexAttribIuivRobustANGLE(index, pname, bufSize, length, params);
}

void GL_APIENTRY glGetUniformuivRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params)
{
    return GL_GetUniformuivRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glGetActiveUniformBlockivRobustANGLE(GLuint program,
                                                      GLuint uniformBlockIndex,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    return GL_GetActiveUniformBlockivRobustANGLE(program, uniformBlockIndex, pname, bufSize, length,
                                                 params);
}

void GL_APIENTRY glGetInteger64vRobustANGLE(GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    return GL_GetInteger64vRobustANGLE(pname, bufSize, length, data);
}

void GL_APIENTRY glGetInteger64i_vRobustANGLE(GLenum target,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint64 *data)
{
    return GL_GetInteger64i_vRobustANGLE(target, index, bufSize, length, data);
}

void GL_APIENTRY glGetBufferParameteri64vRobustANGLE(GLenum target,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint64 *params)
{
    return GL_GetBufferParameteri64vRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glSamplerParameterivRobustANGLE(GLuint sampler,
                                                 GLuint pname,
                                                 GLsizei bufSize,
                                                 const GLint *param)
{
    return GL_SamplerParameterivRobustANGLE(sampler, pname, bufSize, param);
}

void GL_APIENTRY glSamplerParameterfvRobustANGLE(GLuint sampler,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLfloat *param)
{
    return GL_SamplerParameterfvRobustANGLE(sampler, pname, bufSize, param);
}

void GL_APIENTRY glGetSamplerParameterivRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    return GL_GetSamplerParameterivRobustANGLE(sampler, pname, bufSize, length, params);
}

void GL_APIENTRY glGetSamplerParameterfvRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLfloat *params)
{
    return GL_GetSamplerParameterfvRobustANGLE(sampler, pname, bufSize, length, params);
}

void GL_APIENTRY glGetFramebufferParameterivRobustANGLE(GLenum target,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint *params)
{
    return GL_GetFramebufferParameterivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetProgramInterfaceivRobustANGLE(GLuint program,
                                                    GLenum programInterface,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    return GL_GetProgramInterfaceivRobustANGLE(program, programInterface, pname, bufSize, length,
                                               params);
}

void GL_APIENTRY glGetBooleani_vRobustANGLE(GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLboolean *data)
{
    return GL_GetBooleani_vRobustANGLE(target, index, bufSize, length, data);
}

void GL_APIENTRY glGetMultisamplefvRobustANGLE(GLenum pname,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *val)
{
    return GL_GetMultisamplefvRobustANGLE(pname, index, bufSize, length, val);
}

void GL_APIENTRY glGetTexLevelParameterivRobustANGLE(GLenum target,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    return GL_GetTexLevelParameterivRobustANGLE(target, level, pname, bufSize, length, params);
}

void GL_APIENTRY glGetTexLevelParameterfvRobustANGLE(GLenum target,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    return GL_GetTexLevelParameterfvRobustANGLE(target, level, pname, bufSize, length, params);
}

void GL_APIENTRY glGetPointervRobustANGLERobustANGLE(GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     void **params)
{
    return GL_GetPointervRobustANGLERobustANGLE(pname, bufSize, length, params);
}

void GL_APIENTRY glReadnPixelsRobustANGLE(GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *data)
{
    return GL_ReadnPixelsRobustANGLE(x, y, width, height, format, type, bufSize, length, columns,
                                     rows, data);
}

void GL_APIENTRY glGetnUniformfvRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    return GL_GetnUniformfvRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glGetnUniformivRobustANGLE(GLuint program,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    return GL_GetnUniformivRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glGetnUniformuivRobustANGLE(GLuint program,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    return GL_GetnUniformuivRobustANGLE(program, location, bufSize, length, params);
}

void GL_APIENTRY glTexParameterIivRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    return GL_TexParameterIivRobustANGLE(target, pname, bufSize, params);
}

void GL_APIENTRY glTexParameterIuivRobustANGLE(GLenum target,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLuint *params)
{
    return GL_TexParameterIuivRobustANGLE(target, pname, bufSize, params);
}

void GL_APIENTRY glGetTexParameterIivRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    return GL_GetTexParameterIivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glGetTexParameterIuivRobustANGLE(GLenum target,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    return GL_GetTexParameterIuivRobustANGLE(target, pname, bufSize, length, params);
}

void GL_APIENTRY glSamplerParameterIivRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    return GL_SamplerParameterIivRobustANGLE(sampler, pname, bufSize, param);
}

void GL_APIENTRY glSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLuint *param)
{
    return GL_SamplerParameterIuivRobustANGLE(sampler, pname, bufSize, param);
}

void GL_APIENTRY glGetSamplerParameterIivRobustANGLE(GLuint sampler,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    return GL_GetSamplerParameterIivRobustANGLE(sampler, pname, bufSize, length, params);
}

void GL_APIENTRY glGetSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    return GL_GetSamplerParameterIuivRobustANGLE(sampler, pname, bufSize, length, params);
}

void GL_APIENTRY glGetQueryObjectivRobustANGLE(GLuint id,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    return GL_GetQueryObjectivRobustANGLE(id, pname, bufSize, length, params);
}

void GL_APIENTRY glGetQueryObjecti64vRobustANGLE(GLuint id,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint64 *params)
{
    return GL_GetQueryObjecti64vRobustANGLE(id, pname, bufSize, length, params);
}

void GL_APIENTRY glGetQueryObjectui64vRobustANGLE(GLuint id,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint64 *params)
{
    return GL_GetQueryObjectui64vRobustANGLE(id, pname, bufSize, length, params);
}

// GL_ANGLE_robust_resource_initialization

// GL_ANGLE_semaphore_fuchsia
void GL_APIENTRY glImportSemaphoreZirconHandleANGLE(GLuint semaphore,
                                                    GLenum handleType,
                                                    GLuint handle)
{
    return GL_ImportSemaphoreZirconHandleANGLE(semaphore, handleType, handle);
}

// GL_ANGLE_shader_pixel_local_storage
void GL_APIENTRY glFramebufferMemorylessPixelLocalStorageANGLE(GLint plane, GLenum internalformat)
{
    return GL_FramebufferMemorylessPixelLocalStorageANGLE(plane, internalformat);
}

void GL_APIENTRY glFramebufferTexturePixelLocalStorageANGLE(GLint plane,
                                                            GLuint backingtexture,
                                                            GLint level,
                                                            GLint layer)
{
    return GL_FramebufferTexturePixelLocalStorageANGLE(plane, backingtexture, level, layer);
}

void GL_APIENTRY glFramebufferPixelLocalClearValuefvANGLE(GLint plane, const GLfloat *value)
{
    return GL_FramebufferPixelLocalClearValuefvANGLE(plane, value);
}

void GL_APIENTRY glFramebufferPixelLocalClearValueivANGLE(GLint plane, const GLint *value)
{
    return GL_FramebufferPixelLocalClearValueivANGLE(plane, value);
}

void GL_APIENTRY glFramebufferPixelLocalClearValueuivANGLE(GLint plane, const GLuint *value)
{
    return GL_FramebufferPixelLocalClearValueuivANGLE(plane, value);
}

void GL_APIENTRY glBeginPixelLocalStorageANGLE(GLsizei n, const GLenum *loadops)
{
    return GL_BeginPixelLocalStorageANGLE(n, loadops);
}

void GL_APIENTRY glEndPixelLocalStorageANGLE(GLsizei n, const GLenum *storeops)
{
    return GL_EndPixelLocalStorageANGLE(n, storeops);
}

void GL_APIENTRY glPixelLocalStorageBarrierANGLE()
{
    return GL_PixelLocalStorageBarrierANGLE();
}

void GL_APIENTRY glFramebufferPixelLocalStorageInterruptANGLE()
{
    return GL_FramebufferPixelLocalStorageInterruptANGLE();
}

void GL_APIENTRY glFramebufferPixelLocalStorageRestoreANGLE()
{
    return GL_FramebufferPixelLocalStorageRestoreANGLE();
}

void GL_APIENTRY glGetFramebufferPixelLocalStorageParameterfvANGLE(GLint plane,
                                                                   GLenum pname,
                                                                   GLfloat *params)
{
    return GL_GetFramebufferPixelLocalStorageParameterfvANGLE(plane, pname, params);
}

void GL_APIENTRY glGetFramebufferPixelLocalStorageParameterivANGLE(GLint plane,
                                                                   GLenum pname,
                                                                   GLint *params)
{
    return GL_GetFramebufferPixelLocalStorageParameterivANGLE(plane, pname, params);
}

void GL_APIENTRY glGetFramebufferPixelLocalStorageParameterfvRobustANGLE(GLint plane,
                                                                         GLenum pname,
                                                                         GLsizei bufSize,
                                                                         GLsizei *length,
                                                                         GLfloat *params)
{
    return GL_GetFramebufferPixelLocalStorageParameterfvRobustANGLE(plane, pname, bufSize, length,
                                                                    params);
}

void GL_APIENTRY glGetFramebufferPixelLocalStorageParameterivRobustANGLE(GLint plane,
                                                                         GLenum pname,
                                                                         GLsizei bufSize,
                                                                         GLsizei *length,
                                                                         GLint *params)
{
    return GL_GetFramebufferPixelLocalStorageParameterivRobustANGLE(plane, pname, bufSize, length,
                                                                    params);
}

// GL_ANGLE_stencil_texturing

// GL_ANGLE_texture_compression_dxt3

// GL_ANGLE_texture_compression_dxt5

// GL_ANGLE_texture_external_update
void GL_APIENTRY glTexImage2DExternalANGLE(GLenum target,
                                           GLint level,
                                           GLint internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLint border,
                                           GLenum format,
                                           GLenum type)
{
    return GL_TexImage2DExternalANGLE(target, level, internalformat, width, height, border, format,
                                      type);
}

void GL_APIENTRY glInvalidateTextureANGLE(GLenum target)
{
    return GL_InvalidateTextureANGLE(target);
}

// GL_ANGLE_texture_multisample
void GL_APIENTRY glTexStorage2DMultisampleANGLE(GLenum target,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    return GL_TexStorage2DMultisampleANGLE(target, samples, internalformat, width, height,
                                           fixedsamplelocations);
}

void GL_APIENTRY glGetMultisamplefvANGLE(GLenum pname, GLuint index, GLfloat *val)
{
    return GL_GetMultisamplefvANGLE(pname, index, val);
}

void GL_APIENTRY glSampleMaskiANGLE(GLuint maskNumber, GLbitfield mask)
{
    return GL_SampleMaskiANGLE(maskNumber, mask);
}

// GL_ANGLE_texture_usage

// GL_ANGLE_translated_shader_source
void GL_APIENTRY glGetTranslatedShaderSourceANGLE(GLuint shader,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *source)
{
    return GL_GetTranslatedShaderSourceANGLE(shader, bufSize, length, source);
}

// GL_ANGLE_vulkan_image
void GL_APIENTRY glAcquireTexturesANGLE(GLuint numTextures,
                                        const GLuint *textures,
                                        const GLenum *layouts)
{
    return GL_AcquireTexturesANGLE(numTextures, textures, layouts);
}

void GL_APIENTRY glReleaseTexturesANGLE(GLuint numTextures, const GLuint *textures, GLenum *layouts)
{
    return GL_ReleaseTexturesANGLE(numTextures, textures, layouts);
}

// GL_APPLE_clip_distance

// GL_ARB_sync

// GL_ARM_shader_framebuffer_fetch

// GL_CHROMIUM_bind_uniform_location
void GL_APIENTRY glBindUniformLocationCHROMIUM(GLuint program, GLint location, const GLchar *name)
{
    return GL_BindUniformLocationCHROMIUM(program, location, name);
}

// GL_CHROMIUM_copy_compressed_texture
void GL_APIENTRY glCompressedCopyTextureCHROMIUM(GLuint sourceId, GLuint destId)
{
    return GL_CompressedCopyTextureCHROMIUM(sourceId, destId);
}

// GL_CHROMIUM_copy_texture
void GL_APIENTRY glCopyTextureCHROMIUM(GLuint sourceId,
                                       GLint sourceLevel,
                                       GLenum destTarget,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    return GL_CopyTextureCHROMIUM(sourceId, sourceLevel, destTarget, destId, destLevel,
                                  internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                  unpackUnmultiplyAlpha);
}

void GL_APIENTRY glCopySubTextureCHROMIUM(GLuint sourceId,
                                          GLint sourceLevel,
                                          GLenum destTarget,
                                          GLuint destId,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLint width,
                                          GLint height,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    return GL_CopySubTextureCHROMIUM(sourceId, sourceLevel, destTarget, destId, destLevel, xoffset,
                                     yoffset, x, y, width, height, unpackFlipY,
                                     unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
}

// GL_CHROMIUM_framebuffer_mixed_samples
void GL_APIENTRY glCoverageModulationCHROMIUM(GLenum components)
{
    return GL_CoverageModulationCHROMIUM(components);
}

// GL_CHROMIUM_lose_context
void GL_APIENTRY glLoseContextCHROMIUM(GLenum current, GLenum other)
{
    return GL_LoseContextCHROMIUM(current, other);
}

// GL_EXT_EGL_image_array

// GL_EXT_EGL_image_storage
void GL_APIENTRY glEGLImageTargetTexStorageEXT(GLenum target,
                                               GLeglImageOES image,
                                               const GLint *attrib_list)
{
    return GL_EGLImageTargetTexStorageEXT(target, image, attrib_list);
}

void GL_APIENTRY glEGLImageTargetTextureStorageEXT(GLuint texture,
                                                   GLeglImageOES image,
                                                   const GLint *attrib_list)
{
    return GL_EGLImageTargetTextureStorageEXT(texture, image, attrib_list);
}

// GL_EXT_YUV_target

// GL_EXT_base_instance
void GL_APIENTRY glDrawArraysInstancedBaseInstanceEXT(GLenum mode,
                                                      GLint first,
                                                      GLsizei count,
                                                      GLsizei instancecount,
                                                      GLuint baseinstance)
{
    return GL_DrawArraysInstancedBaseInstanceEXT(mode, first, count, instancecount, baseinstance);
}

void GL_APIENTRY glDrawElementsInstancedBaseInstanceEXT(GLenum mode,
                                                        GLsizei count,
                                                        GLenum type,
                                                        const void *indices,
                                                        GLsizei instancecount,
                                                        GLuint baseinstance)
{
    return GL_DrawElementsInstancedBaseInstanceEXT(mode, count, type, indices, instancecount,
                                                   baseinstance);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertexBaseInstanceEXT(GLenum mode,
                                                                  GLsizei count,
                                                                  GLenum type,
                                                                  const void *indices,
                                                                  GLsizei instancecount,
                                                                  GLint basevertex,
                                                                  GLuint baseinstance)
{
    return GL_DrawElementsInstancedBaseVertexBaseInstanceEXT(
        mode, count, type, indices, instancecount, basevertex, baseinstance);
}

// GL_EXT_blend_func_extended
void GL_APIENTRY glBindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    return GL_BindFragDataLocationEXT(program, color, name);
}

void GL_APIENTRY glBindFragDataLocationIndexedEXT(GLuint program,
                                                  GLuint colorNumber,
                                                  GLuint index,
                                                  const GLchar *name)
{
    return GL_BindFragDataLocationIndexedEXT(program, colorNumber, index, name);
}

GLint GL_APIENTRY glGetFragDataIndexEXT(GLuint program, const GLchar *name)
{
    return GL_GetFragDataIndexEXT(program, name);
}

GLint GL_APIENTRY glGetProgramResourceLocationIndexEXT(GLuint program,
                                                       GLenum programInterface,
                                                       const GLchar *name)
{
    return GL_GetProgramResourceLocationIndexEXT(program, programInterface, name);
}

// GL_EXT_blend_minmax

// GL_EXT_buffer_storage
void GL_APIENTRY glBufferStorageEXT(GLenum target,
                                    GLsizeiptr size,
                                    const void *data,
                                    GLbitfield flags)
{
    return GL_BufferStorageEXT(target, size, data, flags);
}

// GL_EXT_clip_control
void GL_APIENTRY glClipControlEXT(GLenum origin, GLenum depth)
{
    return GL_ClipControlEXT(origin, depth);
}

// GL_EXT_clip_cull_distance

// GL_EXT_color_buffer_float

// GL_EXT_color_buffer_half_float

// GL_EXT_conservative_depth

// GL_EXT_copy_image
void GL_APIENTRY glCopyImageSubDataEXT(GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    return GL_CopyImageSubDataEXT(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                  dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                  srcDepth);
}

// GL_EXT_debug_label
void GL_APIENTRY
glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    return GL_GetObjectLabelEXT(type, object, bufSize, length, label);
}

void GL_APIENTRY glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label)
{
    return GL_LabelObjectEXT(type, object, length, label);
}

// GL_EXT_debug_marker
void GL_APIENTRY glInsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    return GL_InsertEventMarkerEXT(length, marker);
}

void GL_APIENTRY glPopGroupMarkerEXT()
{
    return GL_PopGroupMarkerEXT();
}

void GL_APIENTRY glPushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    return GL_PushGroupMarkerEXT(length, marker);
}

// GL_EXT_depth_clamp

// GL_EXT_discard_framebuffer
void GL_APIENTRY glDiscardFramebufferEXT(GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    return GL_DiscardFramebufferEXT(target, numAttachments, attachments);
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY glBeginQueryEXT(GLenum target, GLuint id)
{
    return GL_BeginQueryEXT(target, id);
}

void GL_APIENTRY glDeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    return GL_DeleteQueriesEXT(n, ids);
}

void GL_APIENTRY glEndQueryEXT(GLenum target)
{
    return GL_EndQueryEXT(target);
}

void GL_APIENTRY glGenQueriesEXT(GLsizei n, GLuint *ids)
{
    return GL_GenQueriesEXT(n, ids);
}

void GL_APIENTRY glGetInteger64vEXT(GLenum pname, GLint64 *data)
{
    return GL_GetInteger64vEXT(pname, data);
}

void GL_APIENTRY glGetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    return GL_GetQueryObjecti64vEXT(id, pname, params);
}

void GL_APIENTRY glGetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    return GL_GetQueryObjectivEXT(id, pname, params);
}

void GL_APIENTRY glGetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    return GL_GetQueryObjectui64vEXT(id, pname, params);
}

void GL_APIENTRY glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    return GL_GetQueryObjectuivEXT(id, pname, params);
}

void GL_APIENTRY glGetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetQueryivEXT(target, pname, params);
}

GLboolean GL_APIENTRY glIsQueryEXT(GLuint id)
{
    return GL_IsQueryEXT(id);
}

void GL_APIENTRY glQueryCounterEXT(GLuint id, GLenum target)
{
    return GL_QueryCounterEXT(id, target);
}

// GL_EXT_draw_buffers
void GL_APIENTRY glDrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    return GL_DrawBuffersEXT(n, bufs);
}

// GL_EXT_draw_buffers_indexed
void GL_APIENTRY glBlendEquationSeparateiEXT(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    return GL_BlendEquationSeparateiEXT(buf, modeRGB, modeAlpha);
}

void GL_APIENTRY glBlendEquationiEXT(GLuint buf, GLenum mode)
{
    return GL_BlendEquationiEXT(buf, mode);
}

void GL_APIENTRY
glBlendFuncSeparateiEXT(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    return GL_BlendFuncSeparateiEXT(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

void GL_APIENTRY glBlendFunciEXT(GLuint buf, GLenum src, GLenum dst)
{
    return GL_BlendFunciEXT(buf, src, dst);
}

void GL_APIENTRY glColorMaskiEXT(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    return GL_ColorMaskiEXT(index, r, g, b, a);
}

void GL_APIENTRY glDisableiEXT(GLenum target, GLuint index)
{
    return GL_DisableiEXT(target, index);
}

void GL_APIENTRY glEnableiEXT(GLenum target, GLuint index)
{
    return GL_EnableiEXT(target, index);
}

GLboolean GL_APIENTRY glIsEnablediEXT(GLenum target, GLuint index)
{
    return GL_IsEnablediEXT(target, index);
}

// GL_EXT_draw_elements_base_vertex
void GL_APIENTRY glDrawElementsBaseVertexEXT(GLenum mode,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices,
                                             GLint basevertex)
{
    return GL_DrawElementsBaseVertexEXT(mode, count, type, indices, basevertex);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertexEXT(GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    return GL_DrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount,
                                                 basevertex);
}

void GL_APIENTRY glDrawRangeElementsBaseVertexEXT(GLenum mode,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  GLenum type,
                                                  const void *indices,
                                                  GLint basevertex)
{
    return GL_DrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex);
}

void GL_APIENTRY glMultiDrawElementsBaseVertexEXT(GLenum mode,
                                                  const GLsizei *count,
                                                  GLenum type,
                                                  const void *const *indices,
                                                  GLsizei drawcount,
                                                  const GLint *basevertex)
{
    return GL_MultiDrawElementsBaseVertexEXT(mode, count, type, indices, drawcount, basevertex);
}

// GL_EXT_external_buffer
void GL_APIENTRY glBufferStorageExternalEXT(GLenum target,
                                            GLintptr offset,
                                            GLsizeiptr size,
                                            GLeglClientBufferEXT clientBuffer,
                                            GLbitfield flags)
{
    return GL_BufferStorageExternalEXT(target, offset, size, clientBuffer, flags);
}

void GL_APIENTRY glNamedBufferStorageExternalEXT(GLuint buffer,
                                                 GLintptr offset,
                                                 GLsizeiptr size,
                                                 GLeglClientBufferEXT clientBuffer,
                                                 GLbitfield flags)
{
    return GL_NamedBufferStorageExternalEXT(buffer, offset, size, clientBuffer, flags);
}

// GL_EXT_float_blend

// GL_EXT_geometry_shader
void GL_APIENTRY glFramebufferTextureEXT(GLenum target,
                                         GLenum attachment,
                                         GLuint texture,
                                         GLint level)
{
    return GL_FramebufferTextureEXT(target, attachment, texture, level);
}

// GL_EXT_gpu_shader5

// GL_EXT_instanced_arrays
void GL_APIENTRY glDrawArraysInstancedEXT(GLenum mode,
                                          GLint start,
                                          GLsizei count,
                                          GLsizei primcount)
{
    return GL_DrawArraysInstancedEXT(mode, start, count, primcount);
}

void GL_APIENTRY glDrawElementsInstancedEXT(GLenum mode,
                                            GLsizei count,
                                            GLenum type,
                                            const void *indices,
                                            GLsizei primcount)
{
    return GL_DrawElementsInstancedEXT(mode, count, type, indices, primcount);
}

void GL_APIENTRY glVertexAttribDivisorEXT(GLuint index, GLuint divisor)
{
    return GL_VertexAttribDivisorEXT(index, divisor);
}

// GL_EXT_map_buffer_range
void GL_APIENTRY glFlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    return GL_FlushMappedBufferRangeEXT(target, offset, length);
}

void *GL_APIENTRY glMapBufferRangeEXT(GLenum target,
                                      GLintptr offset,
                                      GLsizeiptr length,
                                      GLbitfield access)
{
    return GL_MapBufferRangeEXT(target, offset, length, access);
}

// GL_EXT_memory_object
void GL_APIENTRY glBufferStorageMemEXT(GLenum target,
                                       GLsizeiptr size,
                                       GLuint memory,
                                       GLuint64 offset)
{
    return GL_BufferStorageMemEXT(target, size, memory, offset);
}

void GL_APIENTRY glCreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects)
{
    return GL_CreateMemoryObjectsEXT(n, memoryObjects);
}

void GL_APIENTRY glDeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects)
{
    return GL_DeleteMemoryObjectsEXT(n, memoryObjects);
}

void GL_APIENTRY glGetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params)
{
    return GL_GetMemoryObjectParameterivEXT(memoryObject, pname, params);
}

void GL_APIENTRY glGetUnsignedBytevEXT(GLenum pname, GLubyte *data)
{
    return GL_GetUnsignedBytevEXT(pname, data);
}

void GL_APIENTRY glGetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data)
{
    return GL_GetUnsignedBytei_vEXT(target, index, data);
}

GLboolean GL_APIENTRY glIsMemoryObjectEXT(GLuint memoryObject)
{
    return GL_IsMemoryObjectEXT(memoryObject);
}

void GL_APIENTRY glMemoryObjectParameterivEXT(GLuint memoryObject,
                                              GLenum pname,
                                              const GLint *params)
{
    return GL_MemoryObjectParameterivEXT(memoryObject, pname, params);
}

void GL_APIENTRY glTexStorageMem2DEXT(GLenum target,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLuint memory,
                                      GLuint64 offset)
{
    return GL_TexStorageMem2DEXT(target, levels, internalFormat, width, height, memory, offset);
}

void GL_APIENTRY glTexStorageMem2DMultisampleEXT(GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedSampleLocations,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    return GL_TexStorageMem2DMultisampleEXT(target, samples, internalFormat, width, height,
                                            fixedSampleLocations, memory, offset);
}

void GL_APIENTRY glTexStorageMem3DEXT(GLenum target,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLuint memory,
                                      GLuint64 offset)
{
    return GL_TexStorageMem3DEXT(target, levels, internalFormat, width, height, depth, memory,
                                 offset);
}

void GL_APIENTRY glTexStorageMem3DMultisampleEXT(GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLboolean fixedSampleLocations,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    return GL_TexStorageMem3DMultisampleEXT(target, samples, internalFormat, width, height, depth,
                                            fixedSampleLocations, memory, offset);
}

// GL_EXT_memory_object_fd
void GL_APIENTRY glImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
    return GL_ImportMemoryFdEXT(memory, size, handleType, fd);
}

// GL_EXT_multi_draw_indirect
void GL_APIENTRY glMultiDrawArraysIndirectEXT(GLenum mode,
                                              const void *indirect,
                                              GLsizei drawcount,
                                              GLsizei stride)
{
    return GL_MultiDrawArraysIndirectEXT(mode, indirect, drawcount, stride);
}

void GL_APIENTRY glMultiDrawElementsIndirectEXT(GLenum mode,
                                                GLenum type,
                                                const void *indirect,
                                                GLsizei drawcount,
                                                GLsizei stride)
{
    return GL_MultiDrawElementsIndirectEXT(mode, type, indirect, drawcount, stride);
}

// GL_EXT_multisampled_render_to_texture
void GL_APIENTRY glFramebufferTexture2DMultisampleEXT(GLenum target,
                                                      GLenum attachment,
                                                      GLenum textarget,
                                                      GLuint texture,
                                                      GLint level,
                                                      GLsizei samples)
{
    return GL_FramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level,
                                                 samples);
}

void GL_APIENTRY glRenderbufferStorageMultisampleEXT(GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    return GL_RenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
}

// GL_EXT_multisampled_render_to_texture2

// GL_EXT_occlusion_query_boolean

// GL_EXT_polygon_offset_clamp
void GL_APIENTRY glPolygonOffsetClampEXT(GLfloat factor, GLfloat units, GLfloat clamp)
{
    return GL_PolygonOffsetClampEXT(factor, units, clamp);
}

// GL_EXT_primitive_bounding_box
void GL_APIENTRY glPrimitiveBoundingBoxEXT(GLfloat minX,
                                           GLfloat minY,
                                           GLfloat minZ,
                                           GLfloat minW,
                                           GLfloat maxX,
                                           GLfloat maxY,
                                           GLfloat maxZ,
                                           GLfloat maxW)
{
    return GL_PrimitiveBoundingBoxEXT(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
}

// GL_EXT_protected_textures

// GL_EXT_pvrtc_sRGB

// GL_EXT_read_format_bgra

// GL_EXT_render_snorm

// GL_EXT_robustness
GLenum GL_APIENTRY glGetGraphicsResetStatusEXT()
{
    return GL_GetGraphicsResetStatusEXT();
}

void GL_APIENTRY glGetnUniformfvEXT(GLuint program,
                                    GLint location,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    return GL_GetnUniformfvEXT(program, location, bufSize, params);
}

void GL_APIENTRY glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    return GL_GetnUniformivEXT(program, location, bufSize, params);
}

void GL_APIENTRY glReadnPixelsEXT(GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    return GL_ReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
}

// GL_EXT_sRGB

// GL_EXT_sRGB_write_control

// GL_EXT_semaphore
void GL_APIENTRY glDeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores)
{
    return GL_DeleteSemaphoresEXT(n, semaphores);
}

void GL_APIENTRY glGenSemaphoresEXT(GLsizei n, GLuint *semaphores)
{
    return GL_GenSemaphoresEXT(n, semaphores);
}

void GL_APIENTRY glGetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params)
{
    return GL_GetSemaphoreParameterui64vEXT(semaphore, pname, params);
}

GLboolean GL_APIENTRY glIsSemaphoreEXT(GLuint semaphore)
{
    return GL_IsSemaphoreEXT(semaphore);
}

void GL_APIENTRY glSemaphoreParameterui64vEXT(GLuint semaphore,
                                              GLenum pname,
                                              const GLuint64 *params)
{
    return GL_SemaphoreParameterui64vEXT(semaphore, pname, params);
}

void GL_APIENTRY glSignalSemaphoreEXT(GLuint semaphore,
                                      GLuint numBufferBarriers,
                                      const GLuint *buffers,
                                      GLuint numTextureBarriers,
                                      const GLuint *textures,
                                      const GLenum *dstLayouts)
{
    return GL_SignalSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers,
                                 textures, dstLayouts);
}

void GL_APIENTRY glWaitSemaphoreEXT(GLuint semaphore,
                                    GLuint numBufferBarriers,
                                    const GLuint *buffers,
                                    GLuint numTextureBarriers,
                                    const GLuint *textures,
                                    const GLenum *srcLayouts)
{
    return GL_WaitSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures,
                               srcLayouts);
}

// GL_EXT_semaphore_fd
void GL_APIENTRY glImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
    return GL_ImportSemaphoreFdEXT(semaphore, handleType, fd);
}

// GL_EXT_separate_shader_objects
void GL_APIENTRY glActiveShaderProgramEXT(GLuint pipeline, GLuint program)
{
    return GL_ActiveShaderProgramEXT(pipeline, program);
}

void GL_APIENTRY glBindProgramPipelineEXT(GLuint pipeline)
{
    return GL_BindProgramPipelineEXT(pipeline);
}

GLuint GL_APIENTRY glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar **strings)
{
    return GL_CreateShaderProgramvEXT(type, count, strings);
}

void GL_APIENTRY glDeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines)
{
    return GL_DeleteProgramPipelinesEXT(n, pipelines);
}

void GL_APIENTRY glGenProgramPipelinesEXT(GLsizei n, GLuint *pipelines)
{
    return GL_GenProgramPipelinesEXT(n, pipelines);
}

void GL_APIENTRY glGetProgramPipelineInfoLogEXT(GLuint pipeline,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLchar *infoLog)
{
    return GL_GetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog);
}

void GL_APIENTRY glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params)
{
    return GL_GetProgramPipelineivEXT(pipeline, pname, params);
}

GLboolean GL_APIENTRY glIsProgramPipelineEXT(GLuint pipeline)
{
    return GL_IsProgramPipelineEXT(pipeline);
}

void GL_APIENTRY glProgramParameteriEXT(GLuint program, GLenum pname, GLint value)
{
    return GL_ProgramParameteriEXT(program, pname, value);
}

void GL_APIENTRY glProgramUniform1fEXT(GLuint program, GLint location, GLfloat v0)
{
    return GL_ProgramUniform1fEXT(program, location, v0);
}

void GL_APIENTRY glProgramUniform1fvEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    return GL_ProgramUniform1fvEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform1iEXT(GLuint program, GLint location, GLint v0)
{
    return GL_ProgramUniform1iEXT(program, location, v0);
}

void GL_APIENTRY glProgramUniform1ivEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    return GL_ProgramUniform1ivEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform1uiEXT(GLuint program, GLint location, GLuint v0)
{
    return GL_ProgramUniform1uiEXT(program, location, v0);
}

void GL_APIENTRY glProgramUniform1uivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    return GL_ProgramUniform1uivEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    return GL_ProgramUniform2fEXT(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2fvEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    return GL_ProgramUniform2fvEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2iEXT(GLuint program, GLint location, GLint v0, GLint v1)
{
    return GL_ProgramUniform2iEXT(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2ivEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    return GL_ProgramUniform2ivEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    return GL_ProgramUniform2uiEXT(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2uivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    return GL_ProgramUniform2uivEXT(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform3fEXT(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    return GL_ProgramUniform3fEXT(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3fvEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    return GL_ProgramUniform3fvEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform3iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    return GL_ProgramUniform3iEXT(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3ivEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    return GL_ProgramUniform3ivEXT(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform3uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    return GL_ProgramUniform3uiEXT(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3uivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    return GL_ProgramUniform3uivEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniform4fEXT(GLuint program,
                                       GLint location,
                                       GLfloat v0,
                                       GLfloat v1,
                                       GLfloat v2,
                                       GLfloat v3)
{
    return GL_ProgramUniform4fEXT(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4fvEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    return GL_ProgramUniform4fvEXT(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform4iEXT(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    return GL_ProgramUniform4iEXT(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4ivEXT(GLuint program,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    return GL_ProgramUniform4ivEXT(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform4uiEXT(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    return GL_ProgramUniform4uiEXT(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4uivEXT(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    return GL_ProgramUniform4uivEXT(program, location, count, value);
}

void GL_APIENTRY glProgramUniformMatrix2fvEXT(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    return GL_ProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x3fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x4fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3fvEXT(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    return GL_ProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x2fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x4fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4fvEXT(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    return GL_ProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x2fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x3fvEXT(GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    return GL_ProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);
}

void GL_APIENTRY glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program)
{
    return GL_UseProgramStagesEXT(pipeline, stages, program);
}

void GL_APIENTRY glValidateProgramPipelineEXT(GLuint pipeline)
{
    return GL_ValidateProgramPipelineEXT(pipeline);
}

// GL_EXT_shader_framebuffer_fetch

// GL_EXT_shader_framebuffer_fetch_non_coherent
void GL_APIENTRY glFramebufferFetchBarrierEXT()
{
    return GL_FramebufferFetchBarrierEXT();
}

// GL_EXT_shader_io_blocks

// GL_EXT_shader_non_constant_global_initializers

// GL_EXT_shader_texture_lod

// GL_EXT_shadow_samplers

// GL_EXT_tessellation_shader
void GL_APIENTRY glPatchParameteriEXT(GLenum pname, GLint value)
{
    return GL_PatchParameteriEXT(pname, value);
}

// GL_EXT_texture_border_clamp
void GL_APIENTRY glGetSamplerParameterIivEXT(GLuint sampler, GLenum pname, GLint *params)
{
    return GL_GetSamplerParameterIivEXT(sampler, pname, params);
}

void GL_APIENTRY glGetSamplerParameterIuivEXT(GLuint sampler, GLenum pname, GLuint *params)
{
    return GL_GetSamplerParameterIuivEXT(sampler, pname, params);
}

void GL_APIENTRY glGetTexParameterIivEXT(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetTexParameterIivEXT(target, pname, params);
}

void GL_APIENTRY glGetTexParameterIuivEXT(GLenum target, GLenum pname, GLuint *params)
{
    return GL_GetTexParameterIuivEXT(target, pname, params);
}

void GL_APIENTRY glSamplerParameterIivEXT(GLuint sampler, GLenum pname, const GLint *param)
{
    return GL_SamplerParameterIivEXT(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameterIuivEXT(GLuint sampler, GLenum pname, const GLuint *param)
{
    return GL_SamplerParameterIuivEXT(sampler, pname, param);
}

void GL_APIENTRY glTexParameterIivEXT(GLenum target, GLenum pname, const GLint *params)
{
    return GL_TexParameterIivEXT(target, pname, params);
}

void GL_APIENTRY glTexParameterIuivEXT(GLenum target, GLenum pname, const GLuint *params)
{
    return GL_TexParameterIuivEXT(target, pname, params);
}

// GL_EXT_texture_buffer
void GL_APIENTRY glTexBufferEXT(GLenum target, GLenum internalformat, GLuint buffer)
{
    return GL_TexBufferEXT(target, internalformat, buffer);
}

void GL_APIENTRY glTexBufferRangeEXT(GLenum target,
                                     GLenum internalformat,
                                     GLuint buffer,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    return GL_TexBufferRangeEXT(target, internalformat, buffer, offset, size);
}

// GL_EXT_texture_compression_astc_decode_mode

// GL_EXT_texture_compression_bptc

// GL_EXT_texture_compression_dxt1

// GL_EXT_texture_compression_rgtc

// GL_EXT_texture_compression_s3tc

// GL_EXT_texture_compression_s3tc_srgb

// GL_EXT_texture_cube_map_array

// GL_EXT_texture_filter_anisotropic

// GL_EXT_texture_filter_minmax

// GL_EXT_texture_format_BGRA8888

// GL_EXT_texture_format_sRGB_override

// GL_EXT_texture_mirror_clamp_to_edge

// GL_EXT_texture_norm16

// GL_EXT_texture_rg

// GL_EXT_texture_sRGB_R8

// GL_EXT_texture_sRGB_RG8

// GL_EXT_texture_sRGB_decode

// GL_EXT_texture_storage
void GL_APIENTRY glTexStorage1DEXT(GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width)
{
    return GL_TexStorage1DEXT(target, levels, internalformat, width);
}

void GL_APIENTRY glTexStorage2DEXT(GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height)
{
    return GL_TexStorage2DEXT(target, levels, internalformat, width, height);
}

void GL_APIENTRY glTexStorage3DEXT(GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth)
{
    return GL_TexStorage3DEXT(target, levels, internalformat, width, height, depth);
}

// GL_EXT_texture_type_2_10_10_10_REV

// GL_EXT_unpack_subimage

// GL_IMG_texture_compression_pvrtc

// GL_IMG_texture_compression_pvrtc2

// GL_KHR_blend_equation_advanced
void GL_APIENTRY glBlendBarrierKHR()
{
    return GL_BlendBarrierKHR();
}

// GL_KHR_debug
void GL_APIENTRY glDebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    return GL_DebugMessageCallbackKHR(callback, userParam);
}

void GL_APIENTRY glDebugMessageControlKHR(GLenum source,
                                          GLenum type,
                                          GLenum severity,
                                          GLsizei count,
                                          const GLuint *ids,
                                          GLboolean enabled)
{
    return GL_DebugMessageControlKHR(source, type, severity, count, ids, enabled);
}

void GL_APIENTRY glDebugMessageInsertKHR(GLenum source,
                                         GLenum type,
                                         GLuint id,
                                         GLenum severity,
                                         GLsizei length,
                                         const GLchar *buf)
{
    return GL_DebugMessageInsertKHR(source, type, id, severity, length, buf);
}

GLuint GL_APIENTRY glGetDebugMessageLogKHR(GLuint count,
                                           GLsizei bufSize,
                                           GLenum *sources,
                                           GLenum *types,
                                           GLuint *ids,
                                           GLenum *severities,
                                           GLsizei *lengths,
                                           GLchar *messageLog)
{
    return GL_GetDebugMessageLogKHR(count, bufSize, sources, types, ids, severities, lengths,
                                    messageLog);
}

void GL_APIENTRY
glGetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    return GL_GetObjectLabelKHR(identifier, name, bufSize, length, label);
}

void GL_APIENTRY glGetObjectPtrLabelKHR(const void *ptr,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *label)
{
    return GL_GetObjectPtrLabelKHR(ptr, bufSize, length, label);
}

void GL_APIENTRY glGetPointervKHR(GLenum pname, void **params)
{
    return GL_GetPointervKHR(pname, params);
}

void GL_APIENTRY glObjectLabelKHR(GLenum identifier,
                                  GLuint name,
                                  GLsizei length,
                                  const GLchar *label)
{
    return GL_ObjectLabelKHR(identifier, name, length, label);
}

void GL_APIENTRY glObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    return GL_ObjectPtrLabelKHR(ptr, length, label);
}

void GL_APIENTRY glPopDebugGroupKHR()
{
    return GL_PopDebugGroupKHR();
}

void GL_APIENTRY glPushDebugGroupKHR(GLenum source,
                                     GLuint id,
                                     GLsizei length,
                                     const GLchar *message)
{
    return GL_PushDebugGroupKHR(source, id, length, message);
}

// GL_KHR_no_error

// GL_KHR_parallel_shader_compile
void GL_APIENTRY glMaxShaderCompilerThreadsKHR(GLuint count)
{
    return GL_MaxShaderCompilerThreadsKHR(count);
}

// GL_KHR_robust_buffer_access_behavior

// GL_KHR_texture_compression_astc_hdr

// GL_KHR_texture_compression_astc_ldr

// GL_KHR_texture_compression_astc_sliced_3d

// GL_MESA_framebuffer_flip_y
void GL_APIENTRY glFramebufferParameteriMESA(GLenum target, GLenum pname, GLint param)
{
    return GL_FramebufferParameteriMESA(target, pname, param);
}

void GL_APIENTRY glGetFramebufferParameterivMESA(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetFramebufferParameterivMESA(target, pname, params);
}

// GL_NV_fence
void GL_APIENTRY glDeleteFencesNV(GLsizei n, const GLuint *fences)
{
    return GL_DeleteFencesNV(n, fences);
}

void GL_APIENTRY glFinishFenceNV(GLuint fence)
{
    return GL_FinishFenceNV(fence);
}

void GL_APIENTRY glGenFencesNV(GLsizei n, GLuint *fences)
{
    return GL_GenFencesNV(n, fences);
}

void GL_APIENTRY glGetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    return GL_GetFenceivNV(fence, pname, params);
}

GLboolean GL_APIENTRY glIsFenceNV(GLuint fence)
{
    return GL_IsFenceNV(fence);
}

void GL_APIENTRY glSetFenceNV(GLuint fence, GLenum condition)
{
    return GL_SetFenceNV(fence, condition);
}

GLboolean GL_APIENTRY glTestFenceNV(GLuint fence)
{
    return GL_TestFenceNV(fence);
}

// GL_NV_framebuffer_blit
void GL_APIENTRY glBlitFramebufferNV(GLint srcX0,
                                     GLint srcY0,
                                     GLint srcX1,
                                     GLint srcY1,
                                     GLint dstX0,
                                     GLint dstY0,
                                     GLint dstX1,
                                     GLint dstY1,
                                     GLbitfield mask,
                                     GLenum filter)
{
    return GL_BlitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                filter);
}

// GL_NV_pixel_buffer_object

// GL_NV_polygon_mode
void GL_APIENTRY glPolygonModeNV(GLenum face, GLenum mode)
{
    return GL_PolygonModeNV(face, mode);
}

// GL_NV_read_depth

// GL_NV_read_depth_stencil

// GL_NV_read_stencil

// GL_NV_robustness_video_memory_purge

// GL_NV_shader_noperspective_interpolation

// GL_OES_EGL_image
void GL_APIENTRY glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    return GL_EGLImageTargetRenderbufferStorageOES(target, image);
}

void GL_APIENTRY glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    return GL_EGLImageTargetTexture2DOES(target, image);
}

// GL_OES_EGL_image_external

// GL_OES_EGL_image_external_essl3

// GL_OES_compressed_ETC1_RGB8_texture

// GL_OES_compressed_paletted_texture

// GL_OES_copy_image
void GL_APIENTRY glCopyImageSubDataOES(GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    return GL_CopyImageSubDataOES(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName,
                                  dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight,
                                  srcDepth);
}

// GL_OES_depth24

// GL_OES_depth32

// GL_OES_depth_texture

// GL_OES_draw_buffers_indexed
void GL_APIENTRY glBlendEquationSeparateiOES(GLuint buf, GLenum modeRGB, GLenum modeAlpha)
{
    return GL_BlendEquationSeparateiOES(buf, modeRGB, modeAlpha);
}

void GL_APIENTRY glBlendEquationiOES(GLuint buf, GLenum mode)
{
    return GL_BlendEquationiOES(buf, mode);
}

void GL_APIENTRY
glBlendFuncSeparateiOES(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    return GL_BlendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

void GL_APIENTRY glBlendFunciOES(GLuint buf, GLenum src, GLenum dst)
{
    return GL_BlendFunciOES(buf, src, dst);
}

void GL_APIENTRY glColorMaskiOES(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    return GL_ColorMaskiOES(index, r, g, b, a);
}

void GL_APIENTRY glDisableiOES(GLenum target, GLuint index)
{
    return GL_DisableiOES(target, index);
}

void GL_APIENTRY glEnableiOES(GLenum target, GLuint index)
{
    return GL_EnableiOES(target, index);
}

GLboolean GL_APIENTRY glIsEnablediOES(GLenum target, GLuint index)
{
    return GL_IsEnablediOES(target, index);
}

// GL_OES_draw_elements_base_vertex
void GL_APIENTRY glDrawElementsBaseVertexOES(GLenum mode,
                                             GLsizei count,
                                             GLenum type,
                                             const void *indices,
                                             GLint basevertex)
{
    return GL_DrawElementsBaseVertexOES(mode, count, type, indices, basevertex);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertexOES(GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    return GL_DrawElementsInstancedBaseVertexOES(mode, count, type, indices, instancecount,
                                                 basevertex);
}

void GL_APIENTRY glDrawRangeElementsBaseVertexOES(GLenum mode,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  GLenum type,
                                                  const void *indices,
                                                  GLint basevertex)
{
    return GL_DrawRangeElementsBaseVertexOES(mode, start, end, count, type, indices, basevertex);
}

// GL_OES_draw_texture
void GL_APIENTRY glDrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    return GL_DrawTexfOES(x, y, z, width, height);
}

void GL_APIENTRY glDrawTexfvOES(const GLfloat *coords)
{
    return GL_DrawTexfvOES(coords);
}

void GL_APIENTRY glDrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    return GL_DrawTexiOES(x, y, z, width, height);
}

void GL_APIENTRY glDrawTexivOES(const GLint *coords)
{
    return GL_DrawTexivOES(coords);
}

void GL_APIENTRY glDrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    return GL_DrawTexsOES(x, y, z, width, height);
}

void GL_APIENTRY glDrawTexsvOES(const GLshort *coords)
{
    return GL_DrawTexsvOES(coords);
}

void GL_APIENTRY glDrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    return GL_DrawTexxOES(x, y, z, width, height);
}

void GL_APIENTRY glDrawTexxvOES(const GLfixed *coords)
{
    return GL_DrawTexxvOES(coords);
}

// GL_OES_element_index_uint

// GL_OES_fbo_render_mipmap

// GL_OES_framebuffer_object
void GL_APIENTRY glBindFramebufferOES(GLenum target, GLuint framebuffer)
{
    return GL_BindFramebufferOES(target, framebuffer);
}

void GL_APIENTRY glBindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    return GL_BindRenderbufferOES(target, renderbuffer);
}

GLenum GL_APIENTRY glCheckFramebufferStatusOES(GLenum target)
{
    return GL_CheckFramebufferStatusOES(target);
}

void GL_APIENTRY glDeleteFramebuffersOES(GLsizei n, const GLuint *framebuffers)
{
    return GL_DeleteFramebuffersOES(n, framebuffers);
}

void GL_APIENTRY glDeleteRenderbuffersOES(GLsizei n, const GLuint *renderbuffers)
{
    return GL_DeleteRenderbuffersOES(n, renderbuffers);
}

void GL_APIENTRY glFramebufferRenderbufferOES(GLenum target,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              GLuint renderbuffer)
{
    return GL_FramebufferRenderbufferOES(target, attachment, renderbuffertarget, renderbuffer);
}

void GL_APIENTRY glFramebufferTexture2DOES(GLenum target,
                                           GLenum attachment,
                                           GLenum textarget,
                                           GLuint texture,
                                           GLint level)
{
    return GL_FramebufferTexture2DOES(target, attachment, textarget, texture, level);
}

void GL_APIENTRY glGenFramebuffersOES(GLsizei n, GLuint *framebuffers)
{
    return GL_GenFramebuffersOES(n, framebuffers);
}

void GL_APIENTRY glGenRenderbuffersOES(GLsizei n, GLuint *renderbuffers)
{
    return GL_GenRenderbuffersOES(n, renderbuffers);
}

void GL_APIENTRY glGenerateMipmapOES(GLenum target)
{
    return GL_GenerateMipmapOES(target);
}

void GL_APIENTRY glGetFramebufferAttachmentParameterivOES(GLenum target,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    return GL_GetFramebufferAttachmentParameterivOES(target, attachment, pname, params);
}

void GL_APIENTRY glGetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetRenderbufferParameterivOES(target, pname, params);
}

GLboolean GL_APIENTRY glIsFramebufferOES(GLuint framebuffer)
{
    return GL_IsFramebufferOES(framebuffer);
}

GLboolean GL_APIENTRY glIsRenderbufferOES(GLuint renderbuffer)
{
    return GL_IsRenderbufferOES(renderbuffer);
}

void GL_APIENTRY glRenderbufferStorageOES(GLenum target,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    return GL_RenderbufferStorageOES(target, internalformat, width, height);
}

// GL_OES_geometry_shader
void GL_APIENTRY glFramebufferTextureOES(GLenum target,
                                         GLenum attachment,
                                         GLuint texture,
                                         GLint level)
{
    return GL_FramebufferTextureOES(target, attachment, texture, level);
}

// GL_OES_get_program_binary
void GL_APIENTRY glGetProgramBinaryOES(GLuint program,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLenum *binaryFormat,
                                       void *binary)
{
    return GL_GetProgramBinaryOES(program, bufSize, length, binaryFormat, binary);
}

void GL_APIENTRY glProgramBinaryOES(GLuint program,
                                    GLenum binaryFormat,
                                    const void *binary,
                                    GLint length)
{
    return GL_ProgramBinaryOES(program, binaryFormat, binary, length);
}

// GL_OES_mapbuffer
void GL_APIENTRY glGetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    return GL_GetBufferPointervOES(target, pname, params);
}

void *GL_APIENTRY glMapBufferOES(GLenum target, GLenum access)
{
    return GL_MapBufferOES(target, access);
}

GLboolean GL_APIENTRY glUnmapBufferOES(GLenum target)
{
    return GL_UnmapBufferOES(target);
}

// GL_OES_matrix_palette
void GL_APIENTRY glCurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    return GL_CurrentPaletteMatrixOES(matrixpaletteindex);
}

void GL_APIENTRY glLoadPaletteFromModelViewMatrixOES()
{
    return GL_LoadPaletteFromModelViewMatrixOES();
}

void GL_APIENTRY glMatrixIndexPointerOES(GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    return GL_MatrixIndexPointerOES(size, type, stride, pointer);
}

void GL_APIENTRY glWeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_WeightPointerOES(size, type, stride, pointer);
}

// GL_OES_packed_depth_stencil

// GL_OES_point_size_array
void GL_APIENTRY glPointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    return GL_PointSizePointerOES(type, stride, pointer);
}

// GL_OES_point_sprite

// GL_OES_primitive_bounding_box
void GL_APIENTRY glPrimitiveBoundingBoxOES(GLfloat minX,
                                           GLfloat minY,
                                           GLfloat minZ,
                                           GLfloat minW,
                                           GLfloat maxX,
                                           GLfloat maxY,
                                           GLfloat maxZ,
                                           GLfloat maxW)
{
    return GL_PrimitiveBoundingBoxOES(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY glQueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    return GL_QueryMatrixxOES(mantissa, exponent);
}

// GL_OES_rgb8_rgba8

// GL_OES_sample_shading
void GL_APIENTRY glMinSampleShadingOES(GLfloat value)
{
    return GL_MinSampleShadingOES(value);
}

// GL_OES_sample_variables

// GL_OES_shader_image_atomic

// GL_OES_shader_io_blocks

// GL_OES_shader_multisample_interpolation

// GL_OES_standard_derivatives

// GL_OES_surfaceless_context

// GL_OES_texture_3D
void GL_APIENTRY glCompressedTexImage3DOES(GLenum target,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLsizei imageSize,
                                           const void *data)
{
    return GL_CompressedTexImage3DOES(target, level, internalformat, width, height, depth, border,
                                      imageSize, data);
}

void GL_APIENTRY glCompressedTexSubImage3DOES(GLenum target,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLsizei imageSize,
                                              const void *data)
{
    return GL_CompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height,
                                         depth, format, imageSize, data);
}

void GL_APIENTRY glCopyTexSubImage3DOES(GLenum target,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height)
{
    return GL_CopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

void GL_APIENTRY glFramebufferTexture3DOES(GLenum target,
                                           GLenum attachment,
                                           GLenum textarget,
                                           GLuint texture,
                                           GLint level,
                                           GLint zoffset)
{
    return GL_FramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset);
}

void GL_APIENTRY glTexImage3DOES(GLenum target,
                                 GLint level,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLint border,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    return GL_TexImage3DOES(target, level, internalformat, width, height, depth, border, format,
                            type, pixels);
}

void GL_APIENTRY glTexSubImage3DOES(GLenum target,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *pixels)
{
    return GL_TexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth,
                               format, type, pixels);
}

// GL_OES_texture_border_clamp
void GL_APIENTRY glGetSamplerParameterIivOES(GLuint sampler, GLenum pname, GLint *params)
{
    return GL_GetSamplerParameterIivOES(sampler, pname, params);
}

void GL_APIENTRY glGetSamplerParameterIuivOES(GLuint sampler, GLenum pname, GLuint *params)
{
    return GL_GetSamplerParameterIuivOES(sampler, pname, params);
}

void GL_APIENTRY glGetTexParameterIivOES(GLenum target, GLenum pname, GLint *params)
{
    return GL_GetTexParameterIivOES(target, pname, params);
}

void GL_APIENTRY glGetTexParameterIuivOES(GLenum target, GLenum pname, GLuint *params)
{
    return GL_GetTexParameterIuivOES(target, pname, params);
}

void GL_APIENTRY glSamplerParameterIivOES(GLuint sampler, GLenum pname, const GLint *param)
{
    return GL_SamplerParameterIivOES(sampler, pname, param);
}

void GL_APIENTRY glSamplerParameterIuivOES(GLuint sampler, GLenum pname, const GLuint *param)
{
    return GL_SamplerParameterIuivOES(sampler, pname, param);
}

void GL_APIENTRY glTexParameterIivOES(GLenum target, GLenum pname, const GLint *params)
{
    return GL_TexParameterIivOES(target, pname, params);
}

void GL_APIENTRY glTexParameterIuivOES(GLenum target, GLenum pname, const GLuint *params)
{
    return GL_TexParameterIuivOES(target, pname, params);
}

// GL_OES_texture_buffer
void GL_APIENTRY glTexBufferOES(GLenum target, GLenum internalformat, GLuint buffer)
{
    return GL_TexBufferOES(target, internalformat, buffer);
}

void GL_APIENTRY glTexBufferRangeOES(GLenum target,
                                     GLenum internalformat,
                                     GLuint buffer,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    return GL_TexBufferRangeOES(target, internalformat, buffer, offset, size);
}

// GL_OES_texture_compression_astc

// GL_OES_texture_cube_map
void GL_APIENTRY glGetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params)
{
    return GL_GetTexGenfvOES(coord, pname, params);
}

void GL_APIENTRY glGetTexGenivOES(GLenum coord, GLenum pname, GLint *params)
{
    return GL_GetTexGenivOES(coord, pname, params);
}

void GL_APIENTRY glGetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
    return GL_GetTexGenxvOES(coord, pname, params);
}

void GL_APIENTRY glTexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    return GL_TexGenfOES(coord, pname, param);
}

void GL_APIENTRY glTexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params)
{
    return GL_TexGenfvOES(coord, pname, params);
}

void GL_APIENTRY glTexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    return GL_TexGeniOES(coord, pname, param);
}

void GL_APIENTRY glTexGenivOES(GLenum coord, GLenum pname, const GLint *params)
{
    return GL_TexGenivOES(coord, pname, params);
}

void GL_APIENTRY glTexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    return GL_TexGenxOES(coord, pname, param);
}

void GL_APIENTRY glTexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
    return GL_TexGenxvOES(coord, pname, params);
}

// GL_OES_texture_cube_map_array

// GL_OES_texture_float

// GL_OES_texture_float_linear

// GL_OES_texture_half_float

// GL_OES_texture_half_float_linear

// GL_OES_texture_npot

// GL_OES_texture_stencil8

// GL_OES_texture_storage_multisample_2d_array
void GL_APIENTRY glTexStorage3DMultisampleOES(GLenum target,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLboolean fixedsamplelocations)
{
    return GL_TexStorage3DMultisampleOES(target, samples, internalformat, width, height, depth,
                                         fixedsamplelocations);
}

// GL_OES_vertex_array_object
void GL_APIENTRY glBindVertexArrayOES(GLuint array)
{
    return GL_BindVertexArrayOES(array);
}

void GL_APIENTRY glDeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    return GL_DeleteVertexArraysOES(n, arrays);
}

void GL_APIENTRY glGenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    return GL_GenVertexArraysOES(n, arrays);
}

GLboolean GL_APIENTRY glIsVertexArrayOES(GLuint array)
{
    return GL_IsVertexArrayOES(array);
}

// GL_OES_vertex_half_float

// GL_OES_vertex_type_10_10_10_2

// GL_OVR_multiview
void GL_APIENTRY glFramebufferTextureMultiviewOVR(GLenum target,
                                                  GLenum attachment,
                                                  GLuint texture,
                                                  GLint level,
                                                  GLint baseViewIndex,
                                                  GLsizei numViews)
{
    return GL_FramebufferTextureMultiviewOVR(target, attachment, texture, level, baseViewIndex,
                                             numViews);
}

// GL_OVR_multiview2

// GL_QCOM_render_shared_exponent

// GL_QCOM_shading_rate
void GL_APIENTRY glShadingRateQCOM(GLenum rate)
{
    return GL_ShadingRateQCOM(rate);
}

#if defined(ANGLE_ENABLE_GL_DESKTOP_FRONTEND)

// GL 1.0
void GL_APIENTRY glAccum(GLenum op, GLfloat value)
{
    return GL_Accum(op, value);
}

void GL_APIENTRY glBegin(GLenum mode)
{
    return GL_Begin(mode);
}

void GL_APIENTRY glBitmap(GLsizei width,
                          GLsizei height,
                          GLfloat xorig,
                          GLfloat yorig,
                          GLfloat xmove,
                          GLfloat ymove,
                          const GLubyte *bitmap)
{
    return GL_Bitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
}

void GL_APIENTRY glCallList(GLuint list)
{
    return GL_CallList(list);
}

void GL_APIENTRY glCallLists(GLsizei n, GLenum type, const void *lists)
{
    return GL_CallLists(n, type, lists);
}

void GL_APIENTRY glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    return GL_ClearAccum(red, green, blue, alpha);
}

void GL_APIENTRY glClearDepth(GLdouble depth)
{
    return GL_ClearDepth(depth);
}

void GL_APIENTRY glClearIndex(GLfloat c)
{
    return GL_ClearIndex(c);
}

void GL_APIENTRY glClipPlane(GLenum plane, const GLdouble *equation)
{
    return GL_ClipPlane(plane, equation);
}

void GL_APIENTRY glColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
    return GL_Color3b(red, green, blue);
}

void GL_APIENTRY glColor3bv(const GLbyte *v)
{
    return GL_Color3bv(v);
}

void GL_APIENTRY glColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
    return GL_Color3d(red, green, blue);
}

void GL_APIENTRY glColor3dv(const GLdouble *v)
{
    return GL_Color3dv(v);
}

void GL_APIENTRY glColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
    return GL_Color3f(red, green, blue);
}

void GL_APIENTRY glColor3fv(const GLfloat *v)
{
    return GL_Color3fv(v);
}

void GL_APIENTRY glColor3i(GLint red, GLint green, GLint blue)
{
    return GL_Color3i(red, green, blue);
}

void GL_APIENTRY glColor3iv(const GLint *v)
{
    return GL_Color3iv(v);
}

void GL_APIENTRY glColor3s(GLshort red, GLshort green, GLshort blue)
{
    return GL_Color3s(red, green, blue);
}

void GL_APIENTRY glColor3sv(const GLshort *v)
{
    return GL_Color3sv(v);
}

void GL_APIENTRY glColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    return GL_Color3ub(red, green, blue);
}

void GL_APIENTRY glColor3ubv(const GLubyte *v)
{
    return GL_Color3ubv(v);
}

void GL_APIENTRY glColor3ui(GLuint red, GLuint green, GLuint blue)
{
    return GL_Color3ui(red, green, blue);
}

void GL_APIENTRY glColor3uiv(const GLuint *v)
{
    return GL_Color3uiv(v);
}

void GL_APIENTRY glColor3us(GLushort red, GLushort green, GLushort blue)
{
    return GL_Color3us(red, green, blue);
}

void GL_APIENTRY glColor3usv(const GLushort *v)
{
    return GL_Color3usv(v);
}

void GL_APIENTRY glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
    return GL_Color4b(red, green, blue, alpha);
}

void GL_APIENTRY glColor4bv(const GLbyte *v)
{
    return GL_Color4bv(v);
}

void GL_APIENTRY glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
    return GL_Color4d(red, green, blue, alpha);
}

void GL_APIENTRY glColor4dv(const GLdouble *v)
{
    return GL_Color4dv(v);
}

void GL_APIENTRY glColor4fv(const GLfloat *v)
{
    return GL_Color4fv(v);
}

void GL_APIENTRY glColor4i(GLint red, GLint green, GLint blue, GLint alpha)
{
    return GL_Color4i(red, green, blue, alpha);
}

void GL_APIENTRY glColor4iv(const GLint *v)
{
    return GL_Color4iv(v);
}

void GL_APIENTRY glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
    return GL_Color4s(red, green, blue, alpha);
}

void GL_APIENTRY glColor4sv(const GLshort *v)
{
    return GL_Color4sv(v);
}

void GL_APIENTRY glColor4ubv(const GLubyte *v)
{
    return GL_Color4ubv(v);
}

void GL_APIENTRY glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
    return GL_Color4ui(red, green, blue, alpha);
}

void GL_APIENTRY glColor4uiv(const GLuint *v)
{
    return GL_Color4uiv(v);
}

void GL_APIENTRY glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
    return GL_Color4us(red, green, blue, alpha);
}

void GL_APIENTRY glColor4usv(const GLushort *v)
{
    return GL_Color4usv(v);
}

void GL_APIENTRY glColorMaterial(GLenum face, GLenum mode)
{
    return GL_ColorMaterial(face, mode);
}

void GL_APIENTRY glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
    return GL_CopyPixels(x, y, width, height, type);
}

void GL_APIENTRY glDeleteLists(GLuint list, GLsizei range)
{
    return GL_DeleteLists(list, range);
}

void GL_APIENTRY glDepthRange(GLdouble n, GLdouble f)
{
    return GL_DepthRange(n, f);
}

void GL_APIENTRY glDrawBuffer(GLenum buf)
{
    return GL_DrawBuffer(buf);
}

void GL_APIENTRY
glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)
{
    return GL_DrawPixels(width, height, format, type, pixels);
}

void GL_APIENTRY glEdgeFlag(GLboolean flag)
{
    return GL_EdgeFlag(flag);
}

void GL_APIENTRY glEdgeFlagv(const GLboolean *flag)
{
    return GL_EdgeFlagv(flag);
}

void GL_APIENTRY glEnd()
{
    return GL_End();
}

void GL_APIENTRY glEndList()
{
    return GL_EndList();
}

void GL_APIENTRY glEvalCoord1d(GLdouble u)
{
    return GL_EvalCoord1d(u);
}

void GL_APIENTRY glEvalCoord1dv(const GLdouble *u)
{
    return GL_EvalCoord1dv(u);
}

void GL_APIENTRY glEvalCoord1f(GLfloat u)
{
    return GL_EvalCoord1f(u);
}

void GL_APIENTRY glEvalCoord1fv(const GLfloat *u)
{
    return GL_EvalCoord1fv(u);
}

void GL_APIENTRY glEvalCoord2d(GLdouble u, GLdouble v)
{
    return GL_EvalCoord2d(u, v);
}

void GL_APIENTRY glEvalCoord2dv(const GLdouble *u)
{
    return GL_EvalCoord2dv(u);
}

void GL_APIENTRY glEvalCoord2f(GLfloat u, GLfloat v)
{
    return GL_EvalCoord2f(u, v);
}

void GL_APIENTRY glEvalCoord2fv(const GLfloat *u)
{
    return GL_EvalCoord2fv(u);
}

void GL_APIENTRY glEvalMesh1(GLenum mode, GLint i1, GLint i2)
{
    return GL_EvalMesh1(mode, i1, i2);
}

void GL_APIENTRY glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
    return GL_EvalMesh2(mode, i1, i2, j1, j2);
}

void GL_APIENTRY glEvalPoint1(GLint i)
{
    return GL_EvalPoint1(i);
}

void GL_APIENTRY glEvalPoint2(GLint i, GLint j)
{
    return GL_EvalPoint2(i, j);
}

void GL_APIENTRY glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer)
{
    return GL_FeedbackBuffer(size, type, buffer);
}

void GL_APIENTRY glFogi(GLenum pname, GLint param)
{
    return GL_Fogi(pname, param);
}

void GL_APIENTRY glFogiv(GLenum pname, const GLint *params)
{
    return GL_Fogiv(pname, params);
}

void GL_APIENTRY glFrustum(GLdouble left,
                           GLdouble right,
                           GLdouble bottom,
                           GLdouble top,
                           GLdouble zNear,
                           GLdouble zFar)
{
    return GL_Frustum(left, right, bottom, top, zNear, zFar);
}

GLuint GL_APIENTRY glGenLists(GLsizei range)
{
    return GL_GenLists(range);
}

void GL_APIENTRY glGetClipPlane(GLenum plane, GLdouble *equation)
{
    return GL_GetClipPlane(plane, equation);
}

void GL_APIENTRY glGetDoublev(GLenum pname, GLdouble *data)
{
    return GL_GetDoublev(pname, data);
}

void GL_APIENTRY glGetLightiv(GLenum light, GLenum pname, GLint *params)
{
    return GL_GetLightiv(light, pname, params);
}

void GL_APIENTRY glGetMapdv(GLenum target, GLenum query, GLdouble *v)
{
    return GL_GetMapdv(target, query, v);
}

void GL_APIENTRY glGetMapfv(GLenum target, GLenum query, GLfloat *v)
{
    return GL_GetMapfv(target, query, v);
}

void GL_APIENTRY glGetMapiv(GLenum target, GLenum query, GLint *v)
{
    return GL_GetMapiv(target, query, v);
}

void GL_APIENTRY glGetMaterialiv(GLenum face, GLenum pname, GLint *params)
{
    return GL_GetMaterialiv(face, pname, params);
}

void GL_APIENTRY glGetPixelMapfv(GLenum map, GLfloat *values)
{
    return GL_GetPixelMapfv(map, values);
}

void GL_APIENTRY glGetPixelMapuiv(GLenum map, GLuint *values)
{
    return GL_GetPixelMapuiv(map, values);
}

void GL_APIENTRY glGetPixelMapusv(GLenum map, GLushort *values)
{
    return GL_GetPixelMapusv(map, values);
}

void GL_APIENTRY glGetPolygonStipple(GLubyte *mask)
{
    return GL_GetPolygonStipple(mask);
}

void GL_APIENTRY glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params)
{
    return GL_GetTexGendv(coord, pname, params);
}

void GL_APIENTRY glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params)
{
    return GL_GetTexGenfv(coord, pname, params);
}

void GL_APIENTRY glGetTexGeniv(GLenum coord, GLenum pname, GLint *params)
{
    return GL_GetTexGeniv(coord, pname, params);
}

void GL_APIENTRY glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, void *pixels)
{
    return GL_GetTexImage(target, level, format, type, pixels);
}

void GL_APIENTRY glIndexMask(GLuint mask)
{
    return GL_IndexMask(mask);
}

void GL_APIENTRY glIndexd(GLdouble c)
{
    return GL_Indexd(c);
}

void GL_APIENTRY glIndexdv(const GLdouble *c)
{
    return GL_Indexdv(c);
}

void GL_APIENTRY glIndexf(GLfloat c)
{
    return GL_Indexf(c);
}

void GL_APIENTRY glIndexfv(const GLfloat *c)
{
    return GL_Indexfv(c);
}

void GL_APIENTRY glIndexi(GLint c)
{
    return GL_Indexi(c);
}

void GL_APIENTRY glIndexiv(const GLint *c)
{
    return GL_Indexiv(c);
}

void GL_APIENTRY glIndexs(GLshort c)
{
    return GL_Indexs(c);
}

void GL_APIENTRY glIndexsv(const GLshort *c)
{
    return GL_Indexsv(c);
}

void GL_APIENTRY glInitNames()
{
    return GL_InitNames();
}

GLboolean GL_APIENTRY glIsList(GLuint list)
{
    return GL_IsList(list);
}

void GL_APIENTRY glLightModeli(GLenum pname, GLint param)
{
    return GL_LightModeli(pname, param);
}

void GL_APIENTRY glLightModeliv(GLenum pname, const GLint *params)
{
    return GL_LightModeliv(pname, params);
}

void GL_APIENTRY glLighti(GLenum light, GLenum pname, GLint param)
{
    return GL_Lighti(light, pname, param);
}

void GL_APIENTRY glLightiv(GLenum light, GLenum pname, const GLint *params)
{
    return GL_Lightiv(light, pname, params);
}

void GL_APIENTRY glLineStipple(GLint factor, GLushort pattern)
{
    return GL_LineStipple(factor, pattern);
}

void GL_APIENTRY glListBase(GLuint base)
{
    return GL_ListBase(base);
}

void GL_APIENTRY glLoadMatrixd(const GLdouble *m)
{
    return GL_LoadMatrixd(m);
}

void GL_APIENTRY glLoadName(GLuint name)
{
    return GL_LoadName(name);
}

void GL_APIENTRY
glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
    return GL_Map1d(target, u1, u2, stride, order, points);
}

void GL_APIENTRY
glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
    return GL_Map1f(target, u1, u2, stride, order, points);
}

void GL_APIENTRY glMap2d(GLenum target,
                         GLdouble u1,
                         GLdouble u2,
                         GLint ustride,
                         GLint uorder,
                         GLdouble v1,
                         GLdouble v2,
                         GLint vstride,
                         GLint vorder,
                         const GLdouble *points)
{
    return GL_Map2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

void GL_APIENTRY glMap2f(GLenum target,
                         GLfloat u1,
                         GLfloat u2,
                         GLint ustride,
                         GLint uorder,
                         GLfloat v1,
                         GLfloat v2,
                         GLint vstride,
                         GLint vorder,
                         const GLfloat *points)
{
    return GL_Map2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

void GL_APIENTRY glMapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
    return GL_MapGrid1d(un, u1, u2);
}

void GL_APIENTRY glMapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
    return GL_MapGrid1f(un, u1, u2);
}

void GL_APIENTRY glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
    return GL_MapGrid2d(un, u1, u2, vn, v1, v2);
}

void GL_APIENTRY glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
    return GL_MapGrid2f(un, u1, u2, vn, v1, v2);
}

void GL_APIENTRY glMateriali(GLenum face, GLenum pname, GLint param)
{
    return GL_Materiali(face, pname, param);
}

void GL_APIENTRY glMaterialiv(GLenum face, GLenum pname, const GLint *params)
{
    return GL_Materialiv(face, pname, params);
}

void GL_APIENTRY glMultMatrixd(const GLdouble *m)
{
    return GL_MultMatrixd(m);
}

void GL_APIENTRY glNewList(GLuint list, GLenum mode)
{
    return GL_NewList(list, mode);
}

void GL_APIENTRY glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
    return GL_Normal3b(nx, ny, nz);
}

void GL_APIENTRY glNormal3bv(const GLbyte *v)
{
    return GL_Normal3bv(v);
}

void GL_APIENTRY glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
    return GL_Normal3d(nx, ny, nz);
}

void GL_APIENTRY glNormal3dv(const GLdouble *v)
{
    return GL_Normal3dv(v);
}

void GL_APIENTRY glNormal3fv(const GLfloat *v)
{
    return GL_Normal3fv(v);
}

void GL_APIENTRY glNormal3i(GLint nx, GLint ny, GLint nz)
{
    return GL_Normal3i(nx, ny, nz);
}

void GL_APIENTRY glNormal3iv(const GLint *v)
{
    return GL_Normal3iv(v);
}

void GL_APIENTRY glNormal3s(GLshort nx, GLshort ny, GLshort nz)
{
    return GL_Normal3s(nx, ny, nz);
}

void GL_APIENTRY glNormal3sv(const GLshort *v)
{
    return GL_Normal3sv(v);
}

void GL_APIENTRY
glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    return GL_Ortho(left, right, bottom, top, zNear, zFar);
}

void GL_APIENTRY glPassThrough(GLfloat token)
{
    return GL_PassThrough(token);
}

void GL_APIENTRY glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values)
{
    return GL_PixelMapfv(map, mapsize, values);
}

void GL_APIENTRY glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values)
{
    return GL_PixelMapuiv(map, mapsize, values);
}

void GL_APIENTRY glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values)
{
    return GL_PixelMapusv(map, mapsize, values);
}

void GL_APIENTRY glPixelStoref(GLenum pname, GLfloat param)
{
    return GL_PixelStoref(pname, param);
}

void GL_APIENTRY glPixelTransferf(GLenum pname, GLfloat param)
{
    return GL_PixelTransferf(pname, param);
}

void GL_APIENTRY glPixelTransferi(GLenum pname, GLint param)
{
    return GL_PixelTransferi(pname, param);
}

void GL_APIENTRY glPixelZoom(GLfloat xfactor, GLfloat yfactor)
{
    return GL_PixelZoom(xfactor, yfactor);
}

void GL_APIENTRY glPolygonMode(GLenum face, GLenum mode)
{
    return GL_PolygonMode(face, mode);
}

void GL_APIENTRY glPolygonStipple(const GLubyte *mask)
{
    return GL_PolygonStipple(mask);
}

void GL_APIENTRY glPopAttrib()
{
    return GL_PopAttrib();
}

void GL_APIENTRY glPopName()
{
    return GL_PopName();
}

void GL_APIENTRY glPushAttrib(GLbitfield mask)
{
    return GL_PushAttrib(mask);
}

void GL_APIENTRY glPushName(GLuint name)
{
    return GL_PushName(name);
}

void GL_APIENTRY glRasterPos2d(GLdouble x, GLdouble y)
{
    return GL_RasterPos2d(x, y);
}

void GL_APIENTRY glRasterPos2dv(const GLdouble *v)
{
    return GL_RasterPos2dv(v);
}

void GL_APIENTRY glRasterPos2f(GLfloat x, GLfloat y)
{
    return GL_RasterPos2f(x, y);
}

void GL_APIENTRY glRasterPos2fv(const GLfloat *v)
{
    return GL_RasterPos2fv(v);
}

void GL_APIENTRY glRasterPos2i(GLint x, GLint y)
{
    return GL_RasterPos2i(x, y);
}

void GL_APIENTRY glRasterPos2iv(const GLint *v)
{
    return GL_RasterPos2iv(v);
}

void GL_APIENTRY glRasterPos2s(GLshort x, GLshort y)
{
    return GL_RasterPos2s(x, y);
}

void GL_APIENTRY glRasterPos2sv(const GLshort *v)
{
    return GL_RasterPos2sv(v);
}

void GL_APIENTRY glRasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    return GL_RasterPos3d(x, y, z);
}

void GL_APIENTRY glRasterPos3dv(const GLdouble *v)
{
    return GL_RasterPos3dv(v);
}

void GL_APIENTRY glRasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    return GL_RasterPos3f(x, y, z);
}

void GL_APIENTRY glRasterPos3fv(const GLfloat *v)
{
    return GL_RasterPos3fv(v);
}

void GL_APIENTRY glRasterPos3i(GLint x, GLint y, GLint z)
{
    return GL_RasterPos3i(x, y, z);
}

void GL_APIENTRY glRasterPos3iv(const GLint *v)
{
    return GL_RasterPos3iv(v);
}

void GL_APIENTRY glRasterPos3s(GLshort x, GLshort y, GLshort z)
{
    return GL_RasterPos3s(x, y, z);
}

void GL_APIENTRY glRasterPos3sv(const GLshort *v)
{
    return GL_RasterPos3sv(v);
}

void GL_APIENTRY glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return GL_RasterPos4d(x, y, z, w);
}

void GL_APIENTRY glRasterPos4dv(const GLdouble *v)
{
    return GL_RasterPos4dv(v);
}

void GL_APIENTRY glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    return GL_RasterPos4f(x, y, z, w);
}

void GL_APIENTRY glRasterPos4fv(const GLfloat *v)
{
    return GL_RasterPos4fv(v);
}

void GL_APIENTRY glRasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
    return GL_RasterPos4i(x, y, z, w);
}

void GL_APIENTRY glRasterPos4iv(const GLint *v)
{
    return GL_RasterPos4iv(v);
}

void GL_APIENTRY glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    return GL_RasterPos4s(x, y, z, w);
}

void GL_APIENTRY glRasterPos4sv(const GLshort *v)
{
    return GL_RasterPos4sv(v);
}

void GL_APIENTRY glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
    return GL_Rectd(x1, y1, x2, y2);
}

void GL_APIENTRY glRectdv(const GLdouble *v1, const GLdouble *v2)
{
    return GL_Rectdv(v1, v2);
}

void GL_APIENTRY glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
    return GL_Rectf(x1, y1, x2, y2);
}

void GL_APIENTRY glRectfv(const GLfloat *v1, const GLfloat *v2)
{
    return GL_Rectfv(v1, v2);
}

void GL_APIENTRY glRecti(GLint x1, GLint y1, GLint x2, GLint y2)
{
    return GL_Recti(x1, y1, x2, y2);
}

void GL_APIENTRY glRectiv(const GLint *v1, const GLint *v2)
{
    return GL_Rectiv(v1, v2);
}

void GL_APIENTRY glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
    return GL_Rects(x1, y1, x2, y2);
}

void GL_APIENTRY glRectsv(const GLshort *v1, const GLshort *v2)
{
    return GL_Rectsv(v1, v2);
}

GLint GL_APIENTRY glRenderMode(GLenum mode)
{
    return GL_RenderMode(mode);
}

void GL_APIENTRY glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
    return GL_Rotated(angle, x, y, z);
}

void GL_APIENTRY glScaled(GLdouble x, GLdouble y, GLdouble z)
{
    return GL_Scaled(x, y, z);
}

void GL_APIENTRY glSelectBuffer(GLsizei size, GLuint *buffer)
{
    return GL_SelectBuffer(size, buffer);
}

void GL_APIENTRY glTexCoord1d(GLdouble s)
{
    return GL_TexCoord1d(s);
}

void GL_APIENTRY glTexCoord1dv(const GLdouble *v)
{
    return GL_TexCoord1dv(v);
}

void GL_APIENTRY glTexCoord1f(GLfloat s)
{
    return GL_TexCoord1f(s);
}

void GL_APIENTRY glTexCoord1fv(const GLfloat *v)
{
    return GL_TexCoord1fv(v);
}

void GL_APIENTRY glTexCoord1i(GLint s)
{
    return GL_TexCoord1i(s);
}

void GL_APIENTRY glTexCoord1iv(const GLint *v)
{
    return GL_TexCoord1iv(v);
}

void GL_APIENTRY glTexCoord1s(GLshort s)
{
    return GL_TexCoord1s(s);
}

void GL_APIENTRY glTexCoord1sv(const GLshort *v)
{
    return GL_TexCoord1sv(v);
}

void GL_APIENTRY glTexCoord2d(GLdouble s, GLdouble t)
{
    return GL_TexCoord2d(s, t);
}

void GL_APIENTRY glTexCoord2dv(const GLdouble *v)
{
    return GL_TexCoord2dv(v);
}

void GL_APIENTRY glTexCoord2f(GLfloat s, GLfloat t)
{
    return GL_TexCoord2f(s, t);
}

void GL_APIENTRY glTexCoord2fv(const GLfloat *v)
{
    return GL_TexCoord2fv(v);
}

void GL_APIENTRY glTexCoord2i(GLint s, GLint t)
{
    return GL_TexCoord2i(s, t);
}

void GL_APIENTRY glTexCoord2iv(const GLint *v)
{
    return GL_TexCoord2iv(v);
}

void GL_APIENTRY glTexCoord2s(GLshort s, GLshort t)
{
    return GL_TexCoord2s(s, t);
}

void GL_APIENTRY glTexCoord2sv(const GLshort *v)
{
    return GL_TexCoord2sv(v);
}

void GL_APIENTRY glTexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
    return GL_TexCoord3d(s, t, r);
}

void GL_APIENTRY glTexCoord3dv(const GLdouble *v)
{
    return GL_TexCoord3dv(v);
}

void GL_APIENTRY glTexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
    return GL_TexCoord3f(s, t, r);
}

void GL_APIENTRY glTexCoord3fv(const GLfloat *v)
{
    return GL_TexCoord3fv(v);
}

void GL_APIENTRY glTexCoord3i(GLint s, GLint t, GLint r)
{
    return GL_TexCoord3i(s, t, r);
}

void GL_APIENTRY glTexCoord3iv(const GLint *v)
{
    return GL_TexCoord3iv(v);
}

void GL_APIENTRY glTexCoord3s(GLshort s, GLshort t, GLshort r)
{
    return GL_TexCoord3s(s, t, r);
}

void GL_APIENTRY glTexCoord3sv(const GLshort *v)
{
    return GL_TexCoord3sv(v);
}

void GL_APIENTRY glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    return GL_TexCoord4d(s, t, r, q);
}

void GL_APIENTRY glTexCoord4dv(const GLdouble *v)
{
    return GL_TexCoord4dv(v);
}

void GL_APIENTRY glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    return GL_TexCoord4f(s, t, r, q);
}

void GL_APIENTRY glTexCoord4fv(const GLfloat *v)
{
    return GL_TexCoord4fv(v);
}

void GL_APIENTRY glTexCoord4i(GLint s, GLint t, GLint r, GLint q)
{
    return GL_TexCoord4i(s, t, r, q);
}

void GL_APIENTRY glTexCoord4iv(const GLint *v)
{
    return GL_TexCoord4iv(v);
}

void GL_APIENTRY glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q)
{
    return GL_TexCoord4s(s, t, r, q);
}

void GL_APIENTRY glTexCoord4sv(const GLshort *v)
{
    return GL_TexCoord4sv(v);
}

void GL_APIENTRY glTexGend(GLenum coord, GLenum pname, GLdouble param)
{
    return GL_TexGend(coord, pname, param);
}

void GL_APIENTRY glTexGendv(GLenum coord, GLenum pname, const GLdouble *params)
{
    return GL_TexGendv(coord, pname, params);
}

void GL_APIENTRY glTexGenf(GLenum coord, GLenum pname, GLfloat param)
{
    return GL_TexGenf(coord, pname, param);
}

void GL_APIENTRY glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params)
{
    return GL_TexGenfv(coord, pname, params);
}

void GL_APIENTRY glTexGeni(GLenum coord, GLenum pname, GLint param)
{
    return GL_TexGeni(coord, pname, param);
}

void GL_APIENTRY glTexGeniv(GLenum coord, GLenum pname, const GLint *params)
{
    return GL_TexGeniv(coord, pname, params);
}

void GL_APIENTRY glTexImage1D(GLenum target,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    return GL_TexImage1D(target, level, internalformat, width, border, format, type, pixels);
}

void GL_APIENTRY glTranslated(GLdouble x, GLdouble y, GLdouble z)
{
    return GL_Translated(x, y, z);
}

void GL_APIENTRY glVertex2d(GLdouble x, GLdouble y)
{
    return GL_Vertex2d(x, y);
}

void GL_APIENTRY glVertex2dv(const GLdouble *v)
{
    return GL_Vertex2dv(v);
}

void GL_APIENTRY glVertex2f(GLfloat x, GLfloat y)
{
    return GL_Vertex2f(x, y);
}

void GL_APIENTRY glVertex2fv(const GLfloat *v)
{
    return GL_Vertex2fv(v);
}

void GL_APIENTRY glVertex2i(GLint x, GLint y)
{
    return GL_Vertex2i(x, y);
}

void GL_APIENTRY glVertex2iv(const GLint *v)
{
    return GL_Vertex2iv(v);
}

void GL_APIENTRY glVertex2s(GLshort x, GLshort y)
{
    return GL_Vertex2s(x, y);
}

void GL_APIENTRY glVertex2sv(const GLshort *v)
{
    return GL_Vertex2sv(v);
}

void GL_APIENTRY glVertex3d(GLdouble x, GLdouble y, GLdouble z)
{
    return GL_Vertex3d(x, y, z);
}

void GL_APIENTRY glVertex3dv(const GLdouble *v)
{
    return GL_Vertex3dv(v);
}

void GL_APIENTRY glVertex3f(GLfloat x, GLfloat y, GLfloat z)
{
    return GL_Vertex3f(x, y, z);
}

void GL_APIENTRY glVertex3fv(const GLfloat *v)
{
    return GL_Vertex3fv(v);
}

void GL_APIENTRY glVertex3i(GLint x, GLint y, GLint z)
{
    return GL_Vertex3i(x, y, z);
}

void GL_APIENTRY glVertex3iv(const GLint *v)
{
    return GL_Vertex3iv(v);
}

void GL_APIENTRY glVertex3s(GLshort x, GLshort y, GLshort z)
{
    return GL_Vertex3s(x, y, z);
}

void GL_APIENTRY glVertex3sv(const GLshort *v)
{
    return GL_Vertex3sv(v);
}

void GL_APIENTRY glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return GL_Vertex4d(x, y, z, w);
}

void GL_APIENTRY glVertex4dv(const GLdouble *v)
{
    return GL_Vertex4dv(v);
}

void GL_APIENTRY glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    return GL_Vertex4f(x, y, z, w);
}

void GL_APIENTRY glVertex4fv(const GLfloat *v)
{
    return GL_Vertex4fv(v);
}

void GL_APIENTRY glVertex4i(GLint x, GLint y, GLint z, GLint w)
{
    return GL_Vertex4i(x, y, z, w);
}

void GL_APIENTRY glVertex4iv(const GLint *v)
{
    return GL_Vertex4iv(v);
}

void GL_APIENTRY glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
    return GL_Vertex4s(x, y, z, w);
}

void GL_APIENTRY glVertex4sv(const GLshort *v)
{
    return GL_Vertex4sv(v);
}

// GL 1.1
GLboolean GL_APIENTRY glAreTexturesResident(GLsizei n,
                                            const GLuint *textures,
                                            GLboolean *residences)
{
    return GL_AreTexturesResident(n, textures, residences);
}

void GL_APIENTRY glArrayElement(GLint i)
{
    return GL_ArrayElement(i);
}

void GL_APIENTRY glCopyTexImage1D(GLenum target,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLint border)
{
    return GL_CopyTexImage1D(target, level, internalformat, x, y, width, border);
}

void GL_APIENTRY
glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    return GL_CopyTexSubImage1D(target, level, xoffset, x, y, width);
}

void GL_APIENTRY glEdgeFlagPointer(GLsizei stride, const void *pointer)
{
    return GL_EdgeFlagPointer(stride, pointer);
}

void GL_APIENTRY glIndexPointer(GLenum type, GLsizei stride, const void *pointer)
{
    return GL_IndexPointer(type, stride, pointer);
}

void GL_APIENTRY glIndexub(GLubyte c)
{
    return GL_Indexub(c);
}

void GL_APIENTRY glIndexubv(const GLubyte *c)
{
    return GL_Indexubv(c);
}

void GL_APIENTRY glInterleavedArrays(GLenum format, GLsizei stride, const void *pointer)
{
    return GL_InterleavedArrays(format, stride, pointer);
}

void GL_APIENTRY glPopClientAttrib()
{
    return GL_PopClientAttrib();
}

void GL_APIENTRY glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLfloat *priorities)
{
    return GL_PrioritizeTextures(n, textures, priorities);
}

void GL_APIENTRY glPushClientAttrib(GLbitfield mask)
{
    return GL_PushClientAttrib(mask);
}

void GL_APIENTRY glTexSubImage1D(GLenum target,
                                 GLint level,
                                 GLint xoffset,
                                 GLsizei width,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    return GL_TexSubImage1D(target, level, xoffset, width, format, type, pixels);
}

// GL 1.2

// GL 1.3
void GL_APIENTRY glCompressedTexImage1D(GLenum target,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    return GL_CompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
}

void GL_APIENTRY glCompressedTexSubImage1D(GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLsizei width,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    return GL_CompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
}

void GL_APIENTRY glGetCompressedTexImage(GLenum target, GLint level, void *img)
{
    return GL_GetCompressedTexImage(target, level, img);
}

void GL_APIENTRY glLoadTransposeMatrixd(const GLdouble *m)
{
    return GL_LoadTransposeMatrixd(m);
}

void GL_APIENTRY glLoadTransposeMatrixf(const GLfloat *m)
{
    return GL_LoadTransposeMatrixf(m);
}

void GL_APIENTRY glMultTransposeMatrixd(const GLdouble *m)
{
    return GL_MultTransposeMatrixd(m);
}

void GL_APIENTRY glMultTransposeMatrixf(const GLfloat *m)
{
    return GL_MultTransposeMatrixf(m);
}

void GL_APIENTRY glMultiTexCoord1d(GLenum target, GLdouble s)
{
    return GL_MultiTexCoord1d(target, s);
}

void GL_APIENTRY glMultiTexCoord1dv(GLenum target, const GLdouble *v)
{
    return GL_MultiTexCoord1dv(target, v);
}

void GL_APIENTRY glMultiTexCoord1f(GLenum target, GLfloat s)
{
    return GL_MultiTexCoord1f(target, s);
}

void GL_APIENTRY glMultiTexCoord1fv(GLenum target, const GLfloat *v)
{
    return GL_MultiTexCoord1fv(target, v);
}

void GL_APIENTRY glMultiTexCoord1i(GLenum target, GLint s)
{
    return GL_MultiTexCoord1i(target, s);
}

void GL_APIENTRY glMultiTexCoord1iv(GLenum target, const GLint *v)
{
    return GL_MultiTexCoord1iv(target, v);
}

void GL_APIENTRY glMultiTexCoord1s(GLenum target, GLshort s)
{
    return GL_MultiTexCoord1s(target, s);
}

void GL_APIENTRY glMultiTexCoord1sv(GLenum target, const GLshort *v)
{
    return GL_MultiTexCoord1sv(target, v);
}

void GL_APIENTRY glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)
{
    return GL_MultiTexCoord2d(target, s, t);
}

void GL_APIENTRY glMultiTexCoord2dv(GLenum target, const GLdouble *v)
{
    return GL_MultiTexCoord2dv(target, v);
}

void GL_APIENTRY glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t)
{
    return GL_MultiTexCoord2f(target, s, t);
}

void GL_APIENTRY glMultiTexCoord2fv(GLenum target, const GLfloat *v)
{
    return GL_MultiTexCoord2fv(target, v);
}

void GL_APIENTRY glMultiTexCoord2i(GLenum target, GLint s, GLint t)
{
    return GL_MultiTexCoord2i(target, s, t);
}

void GL_APIENTRY glMultiTexCoord2iv(GLenum target, const GLint *v)
{
    return GL_MultiTexCoord2iv(target, v);
}

void GL_APIENTRY glMultiTexCoord2s(GLenum target, GLshort s, GLshort t)
{
    return GL_MultiTexCoord2s(target, s, t);
}

void GL_APIENTRY glMultiTexCoord2sv(GLenum target, const GLshort *v)
{
    return GL_MultiTexCoord2sv(target, v);
}

void GL_APIENTRY glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
    return GL_MultiTexCoord3d(target, s, t, r);
}

void GL_APIENTRY glMultiTexCoord3dv(GLenum target, const GLdouble *v)
{
    return GL_MultiTexCoord3dv(target, v);
}

void GL_APIENTRY glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
    return GL_MultiTexCoord3f(target, s, t, r);
}

void GL_APIENTRY glMultiTexCoord3fv(GLenum target, const GLfloat *v)
{
    return GL_MultiTexCoord3fv(target, v);
}

void GL_APIENTRY glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)
{
    return GL_MultiTexCoord3i(target, s, t, r);
}

void GL_APIENTRY glMultiTexCoord3iv(GLenum target, const GLint *v)
{
    return GL_MultiTexCoord3iv(target, v);
}

void GL_APIENTRY glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r)
{
    return GL_MultiTexCoord3s(target, s, t, r);
}

void GL_APIENTRY glMultiTexCoord3sv(GLenum target, const GLshort *v)
{
    return GL_MultiTexCoord3sv(target, v);
}

void GL_APIENTRY glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
    return GL_MultiTexCoord4d(target, s, t, r, q);
}

void GL_APIENTRY glMultiTexCoord4dv(GLenum target, const GLdouble *v)
{
    return GL_MultiTexCoord4dv(target, v);
}

void GL_APIENTRY glMultiTexCoord4fv(GLenum target, const GLfloat *v)
{
    return GL_MultiTexCoord4fv(target, v);
}

void GL_APIENTRY glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
    return GL_MultiTexCoord4i(target, s, t, r, q);
}

void GL_APIENTRY glMultiTexCoord4iv(GLenum target, const GLint *v)
{
    return GL_MultiTexCoord4iv(target, v);
}

void GL_APIENTRY glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
    return GL_MultiTexCoord4s(target, s, t, r, q);
}

void GL_APIENTRY glMultiTexCoord4sv(GLenum target, const GLshort *v)
{
    return GL_MultiTexCoord4sv(target, v);
}

// GL 1.4
void GL_APIENTRY glFogCoordPointer(GLenum type, GLsizei stride, const void *pointer)
{
    return GL_FogCoordPointer(type, stride, pointer);
}

void GL_APIENTRY glFogCoordd(GLdouble coord)
{
    return GL_FogCoordd(coord);
}

void GL_APIENTRY glFogCoorddv(const GLdouble *coord)
{
    return GL_FogCoorddv(coord);
}

void GL_APIENTRY glFogCoordf(GLfloat coord)
{
    return GL_FogCoordf(coord);
}

void GL_APIENTRY glFogCoordfv(const GLfloat *coord)
{
    return GL_FogCoordfv(coord);
}

void GL_APIENTRY glMultiDrawArrays(GLenum mode,
                                   const GLint *first,
                                   const GLsizei *count,
                                   GLsizei drawcount)
{
    return GL_MultiDrawArrays(mode, first, count, drawcount);
}

void GL_APIENTRY glMultiDrawElements(GLenum mode,
                                     const GLsizei *count,
                                     GLenum type,
                                     const void *const *indices,
                                     GLsizei drawcount)
{
    return GL_MultiDrawElements(mode, count, type, indices, drawcount);
}

void GL_APIENTRY glPointParameteri(GLenum pname, GLint param)
{
    return GL_PointParameteri(pname, param);
}

void GL_APIENTRY glPointParameteriv(GLenum pname, const GLint *params)
{
    return GL_PointParameteriv(pname, params);
}

void GL_APIENTRY glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
    return GL_SecondaryColor3b(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3bv(const GLbyte *v)
{
    return GL_SecondaryColor3bv(v);
}

void GL_APIENTRY glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
    return GL_SecondaryColor3d(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3dv(const GLdouble *v)
{
    return GL_SecondaryColor3dv(v);
}

void GL_APIENTRY glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue)
{
    return GL_SecondaryColor3f(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3fv(const GLfloat *v)
{
    return GL_SecondaryColor3fv(v);
}

void GL_APIENTRY glSecondaryColor3i(GLint red, GLint green, GLint blue)
{
    return GL_SecondaryColor3i(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3iv(const GLint *v)
{
    return GL_SecondaryColor3iv(v);
}

void GL_APIENTRY glSecondaryColor3s(GLshort red, GLshort green, GLshort blue)
{
    return GL_SecondaryColor3s(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3sv(const GLshort *v)
{
    return GL_SecondaryColor3sv(v);
}

void GL_APIENTRY glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
    return GL_SecondaryColor3ub(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3ubv(const GLubyte *v)
{
    return GL_SecondaryColor3ubv(v);
}

void GL_APIENTRY glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue)
{
    return GL_SecondaryColor3ui(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3uiv(const GLuint *v)
{
    return GL_SecondaryColor3uiv(v);
}

void GL_APIENTRY glSecondaryColor3us(GLushort red, GLushort green, GLushort blue)
{
    return GL_SecondaryColor3us(red, green, blue);
}

void GL_APIENTRY glSecondaryColor3usv(const GLushort *v)
{
    return GL_SecondaryColor3usv(v);
}

void GL_APIENTRY glSecondaryColorPointer(GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    return GL_SecondaryColorPointer(size, type, stride, pointer);
}

void GL_APIENTRY glWindowPos2d(GLdouble x, GLdouble y)
{
    return GL_WindowPos2d(x, y);
}

void GL_APIENTRY glWindowPos2dv(const GLdouble *v)
{
    return GL_WindowPos2dv(v);
}

void GL_APIENTRY glWindowPos2f(GLfloat x, GLfloat y)
{
    return GL_WindowPos2f(x, y);
}

void GL_APIENTRY glWindowPos2fv(const GLfloat *v)
{
    return GL_WindowPos2fv(v);
}

void GL_APIENTRY glWindowPos2i(GLint x, GLint y)
{
    return GL_WindowPos2i(x, y);
}

void GL_APIENTRY glWindowPos2iv(const GLint *v)
{
    return GL_WindowPos2iv(v);
}

void GL_APIENTRY glWindowPos2s(GLshort x, GLshort y)
{
    return GL_WindowPos2s(x, y);
}

void GL_APIENTRY glWindowPos2sv(const GLshort *v)
{
    return GL_WindowPos2sv(v);
}

void GL_APIENTRY glWindowPos3d(GLdouble x, GLdouble y, GLdouble z)
{
    return GL_WindowPos3d(x, y, z);
}

void GL_APIENTRY glWindowPos3dv(const GLdouble *v)
{
    return GL_WindowPos3dv(v);
}

void GL_APIENTRY glWindowPos3f(GLfloat x, GLfloat y, GLfloat z)
{
    return GL_WindowPos3f(x, y, z);
}

void GL_APIENTRY glWindowPos3fv(const GLfloat *v)
{
    return GL_WindowPos3fv(v);
}

void GL_APIENTRY glWindowPos3i(GLint x, GLint y, GLint z)
{
    return GL_WindowPos3i(x, y, z);
}

void GL_APIENTRY glWindowPos3iv(const GLint *v)
{
    return GL_WindowPos3iv(v);
}

void GL_APIENTRY glWindowPos3s(GLshort x, GLshort y, GLshort z)
{
    return GL_WindowPos3s(x, y, z);
}

void GL_APIENTRY glWindowPos3sv(const GLshort *v)
{
    return GL_WindowPos3sv(v);
}

// GL 1.5
void GL_APIENTRY glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, void *data)
{
    return GL_GetBufferSubData(target, offset, size, data);
}

void GL_APIENTRY glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
    return GL_GetQueryObjectiv(id, pname, params);
}

void *GL_APIENTRY glMapBuffer(GLenum target, GLenum access)
{
    return GL_MapBuffer(target, access);
}

// GL 2.0
void GL_APIENTRY glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
    return GL_GetVertexAttribdv(index, pname, params);
}

void GL_APIENTRY glVertexAttrib1d(GLuint index, GLdouble x)
{
    return GL_VertexAttrib1d(index, x);
}

void GL_APIENTRY glVertexAttrib1dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttrib1dv(index, v);
}

void GL_APIENTRY glVertexAttrib1s(GLuint index, GLshort x)
{
    return GL_VertexAttrib1s(index, x);
}

void GL_APIENTRY glVertexAttrib1sv(GLuint index, const GLshort *v)
{
    return GL_VertexAttrib1sv(index, v);
}

void GL_APIENTRY glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
    return GL_VertexAttrib2d(index, x, y);
}

void GL_APIENTRY glVertexAttrib2dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttrib2dv(index, v);
}

void GL_APIENTRY glVertexAttrib2s(GLuint index, GLshort x, GLshort y)
{
    return GL_VertexAttrib2s(index, x, y);
}

void GL_APIENTRY glVertexAttrib2sv(GLuint index, const GLshort *v)
{
    return GL_VertexAttrib2sv(index, v);
}

void GL_APIENTRY glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    return GL_VertexAttrib3d(index, x, y, z);
}

void GL_APIENTRY glVertexAttrib3dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttrib3dv(index, v);
}

void GL_APIENTRY glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)
{
    return GL_VertexAttrib3s(index, x, y, z);
}

void GL_APIENTRY glVertexAttrib3sv(GLuint index, const GLshort *v)
{
    return GL_VertexAttrib3sv(index, v);
}

void GL_APIENTRY glVertexAttrib4Nbv(GLuint index, const GLbyte *v)
{
    return GL_VertexAttrib4Nbv(index, v);
}

void GL_APIENTRY glVertexAttrib4Niv(GLuint index, const GLint *v)
{
    return GL_VertexAttrib4Niv(index, v);
}

void GL_APIENTRY glVertexAttrib4Nsv(GLuint index, const GLshort *v)
{
    return GL_VertexAttrib4Nsv(index, v);
}

void GL_APIENTRY glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    return GL_VertexAttrib4Nub(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttrib4Nubv(GLuint index, const GLubyte *v)
{
    return GL_VertexAttrib4Nubv(index, v);
}

void GL_APIENTRY glVertexAttrib4Nuiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttrib4Nuiv(index, v);
}

void GL_APIENTRY glVertexAttrib4Nusv(GLuint index, const GLushort *v)
{
    return GL_VertexAttrib4Nusv(index, v);
}

void GL_APIENTRY glVertexAttrib4bv(GLuint index, const GLbyte *v)
{
    return GL_VertexAttrib4bv(index, v);
}

void GL_APIENTRY glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return GL_VertexAttrib4d(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttrib4dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttrib4dv(index, v);
}

void GL_APIENTRY glVertexAttrib4iv(GLuint index, const GLint *v)
{
    return GL_VertexAttrib4iv(index, v);
}

void GL_APIENTRY glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    return GL_VertexAttrib4s(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttrib4sv(GLuint index, const GLshort *v)
{
    return GL_VertexAttrib4sv(index, v);
}

void GL_APIENTRY glVertexAttrib4ubv(GLuint index, const GLubyte *v)
{
    return GL_VertexAttrib4ubv(index, v);
}

void GL_APIENTRY glVertexAttrib4uiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttrib4uiv(index, v);
}

void GL_APIENTRY glVertexAttrib4usv(GLuint index, const GLushort *v)
{
    return GL_VertexAttrib4usv(index, v);
}

// GL 2.1

// GL 3.0
void GL_APIENTRY glBeginConditionalRender(GLuint id, GLenum mode)
{
    return GL_BeginConditionalRender(id, mode);
}

void GL_APIENTRY glBindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
    return GL_BindFragDataLocation(program, color, name);
}

void GL_APIENTRY glClampColor(GLenum target, GLenum clamp)
{
    return GL_ClampColor(target, clamp);
}

void GL_APIENTRY glEndConditionalRender()
{
    return GL_EndConditionalRender();
}

void GL_APIENTRY glFramebufferTexture1D(GLenum target,
                                        GLenum attachment,
                                        GLenum textarget,
                                        GLuint texture,
                                        GLint level)
{
    return GL_FramebufferTexture1D(target, attachment, textarget, texture, level);
}

void GL_APIENTRY glFramebufferTexture3D(GLenum target,
                                        GLenum attachment,
                                        GLenum textarget,
                                        GLuint texture,
                                        GLint level,
                                        GLint zoffset)
{
    return GL_FramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);
}

void GL_APIENTRY glVertexAttribI1i(GLuint index, GLint x)
{
    return GL_VertexAttribI1i(index, x);
}

void GL_APIENTRY glVertexAttribI1iv(GLuint index, const GLint *v)
{
    return GL_VertexAttribI1iv(index, v);
}

void GL_APIENTRY glVertexAttribI1ui(GLuint index, GLuint x)
{
    return GL_VertexAttribI1ui(index, x);
}

void GL_APIENTRY glVertexAttribI1uiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttribI1uiv(index, v);
}

void GL_APIENTRY glVertexAttribI2i(GLuint index, GLint x, GLint y)
{
    return GL_VertexAttribI2i(index, x, y);
}

void GL_APIENTRY glVertexAttribI2iv(GLuint index, const GLint *v)
{
    return GL_VertexAttribI2iv(index, v);
}

void GL_APIENTRY glVertexAttribI2ui(GLuint index, GLuint x, GLuint y)
{
    return GL_VertexAttribI2ui(index, x, y);
}

void GL_APIENTRY glVertexAttribI2uiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttribI2uiv(index, v);
}

void GL_APIENTRY glVertexAttribI3i(GLuint index, GLint x, GLint y, GLint z)
{
    return GL_VertexAttribI3i(index, x, y, z);
}

void GL_APIENTRY glVertexAttribI3iv(GLuint index, const GLint *v)
{
    return GL_VertexAttribI3iv(index, v);
}

void GL_APIENTRY glVertexAttribI3ui(GLuint index, GLuint x, GLuint y, GLuint z)
{
    return GL_VertexAttribI3ui(index, x, y, z);
}

void GL_APIENTRY glVertexAttribI3uiv(GLuint index, const GLuint *v)
{
    return GL_VertexAttribI3uiv(index, v);
}

void GL_APIENTRY glVertexAttribI4bv(GLuint index, const GLbyte *v)
{
    return GL_VertexAttribI4bv(index, v);
}

void GL_APIENTRY glVertexAttribI4sv(GLuint index, const GLshort *v)
{
    return GL_VertexAttribI4sv(index, v);
}

void GL_APIENTRY glVertexAttribI4ubv(GLuint index, const GLubyte *v)
{
    return GL_VertexAttribI4ubv(index, v);
}

void GL_APIENTRY glVertexAttribI4usv(GLuint index, const GLushort *v)
{
    return GL_VertexAttribI4usv(index, v);
}

// GL 3.1
void GL_APIENTRY glGetActiveUniformName(GLuint program,
                                        GLuint uniformIndex,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *uniformName)
{
    return GL_GetActiveUniformName(program, uniformIndex, bufSize, length, uniformName);
}

void GL_APIENTRY glPrimitiveRestartIndex(GLuint index)
{
    return GL_PrimitiveRestartIndex(index);
}

// GL 3.2
void GL_APIENTRY glMultiDrawElementsBaseVertex(GLenum mode,
                                               const GLsizei *count,
                                               GLenum type,
                                               const void *const *indices,
                                               GLsizei drawcount,
                                               const GLint *basevertex)
{
    return GL_MultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex);
}

void GL_APIENTRY glProvokingVertex(GLenum mode)
{
    return GL_ProvokingVertex(mode);
}

void GL_APIENTRY glTexImage2DMultisample(GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLboolean fixedsamplelocations)
{
    return GL_TexImage2DMultisample(target, samples, internalformat, width, height,
                                    fixedsamplelocations);
}

void GL_APIENTRY glTexImage3DMultisample(GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLboolean fixedsamplelocations)
{
    return GL_TexImage3DMultisample(target, samples, internalformat, width, height, depth,
                                    fixedsamplelocations);
}

// GL 3.3
void GL_APIENTRY glBindFragDataLocationIndexed(GLuint program,
                                               GLuint colorNumber,
                                               GLuint index,
                                               const GLchar *name)
{
    return GL_BindFragDataLocationIndexed(program, colorNumber, index, name);
}

void GL_APIENTRY glColorP3ui(GLenum type, GLuint color)
{
    return GL_ColorP3ui(type, color);
}

void GL_APIENTRY glColorP3uiv(GLenum type, const GLuint *color)
{
    return GL_ColorP3uiv(type, color);
}

void GL_APIENTRY glColorP4ui(GLenum type, GLuint color)
{
    return GL_ColorP4ui(type, color);
}

void GL_APIENTRY glColorP4uiv(GLenum type, const GLuint *color)
{
    return GL_ColorP4uiv(type, color);
}

GLint GL_APIENTRY glGetFragDataIndex(GLuint program, const GLchar *name)
{
    return GL_GetFragDataIndex(program, name);
}

void GL_APIENTRY glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    return GL_GetQueryObjecti64v(id, pname, params);
}

void GL_APIENTRY glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    return GL_GetQueryObjectui64v(id, pname, params);
}

void GL_APIENTRY glMultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
    return GL_MultiTexCoordP1ui(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    return GL_MultiTexCoordP1uiv(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
    return GL_MultiTexCoordP2ui(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    return GL_MultiTexCoordP2uiv(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
    return GL_MultiTexCoordP3ui(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    return GL_MultiTexCoordP3uiv(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords)
{
    return GL_MultiTexCoordP4ui(texture, type, coords);
}

void GL_APIENTRY glMultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint *coords)
{
    return GL_MultiTexCoordP4uiv(texture, type, coords);
}

void GL_APIENTRY glNormalP3ui(GLenum type, GLuint coords)
{
    return GL_NormalP3ui(type, coords);
}

void GL_APIENTRY glNormalP3uiv(GLenum type, const GLuint *coords)
{
    return GL_NormalP3uiv(type, coords);
}

void GL_APIENTRY glQueryCounter(GLuint id, GLenum target)
{
    return GL_QueryCounter(id, target);
}

void GL_APIENTRY glSecondaryColorP3ui(GLenum type, GLuint color)
{
    return GL_SecondaryColorP3ui(type, color);
}

void GL_APIENTRY glSecondaryColorP3uiv(GLenum type, const GLuint *color)
{
    return GL_SecondaryColorP3uiv(type, color);
}

void GL_APIENTRY glTexCoordP1ui(GLenum type, GLuint coords)
{
    return GL_TexCoordP1ui(type, coords);
}

void GL_APIENTRY glTexCoordP1uiv(GLenum type, const GLuint *coords)
{
    return GL_TexCoordP1uiv(type, coords);
}

void GL_APIENTRY glTexCoordP2ui(GLenum type, GLuint coords)
{
    return GL_TexCoordP2ui(type, coords);
}

void GL_APIENTRY glTexCoordP2uiv(GLenum type, const GLuint *coords)
{
    return GL_TexCoordP2uiv(type, coords);
}

void GL_APIENTRY glTexCoordP3ui(GLenum type, GLuint coords)
{
    return GL_TexCoordP3ui(type, coords);
}

void GL_APIENTRY glTexCoordP3uiv(GLenum type, const GLuint *coords)
{
    return GL_TexCoordP3uiv(type, coords);
}

void GL_APIENTRY glTexCoordP4ui(GLenum type, GLuint coords)
{
    return GL_TexCoordP4ui(type, coords);
}

void GL_APIENTRY glTexCoordP4uiv(GLenum type, const GLuint *coords)
{
    return GL_TexCoordP4uiv(type, coords);
}

void GL_APIENTRY glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    return GL_VertexAttribP1ui(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP1uiv(GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    return GL_VertexAttribP1uiv(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    return GL_VertexAttribP2ui(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP2uiv(GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    return GL_VertexAttribP2uiv(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    return GL_VertexAttribP3ui(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP3uiv(GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    return GL_VertexAttribP3uiv(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    return GL_VertexAttribP4ui(index, type, normalized, value);
}

void GL_APIENTRY glVertexAttribP4uiv(GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    return GL_VertexAttribP4uiv(index, type, normalized, value);
}

void GL_APIENTRY glVertexP2ui(GLenum type, GLuint value)
{
    return GL_VertexP2ui(type, value);
}

void GL_APIENTRY glVertexP2uiv(GLenum type, const GLuint *value)
{
    return GL_VertexP2uiv(type, value);
}

void GL_APIENTRY glVertexP3ui(GLenum type, GLuint value)
{
    return GL_VertexP3ui(type, value);
}

void GL_APIENTRY glVertexP3uiv(GLenum type, const GLuint *value)
{
    return GL_VertexP3uiv(type, value);
}

void GL_APIENTRY glVertexP4ui(GLenum type, GLuint value)
{
    return GL_VertexP4ui(type, value);
}

void GL_APIENTRY glVertexP4uiv(GLenum type, const GLuint *value)
{
    return GL_VertexP4uiv(type, value);
}

// GL 4.0
void GL_APIENTRY glBeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
    return GL_BeginQueryIndexed(target, index, id);
}

void GL_APIENTRY glDrawTransformFeedback(GLenum mode, GLuint id)
{
    return GL_DrawTransformFeedback(mode, id);
}

void GL_APIENTRY glDrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream)
{
    return GL_DrawTransformFeedbackStream(mode, id, stream);
}

void GL_APIENTRY glEndQueryIndexed(GLenum target, GLuint index)
{
    return GL_EndQueryIndexed(target, index);
}

void GL_APIENTRY glGetActiveSubroutineName(GLuint program,
                                           GLenum shadertype,
                                           GLuint index,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *name)
{
    return GL_GetActiveSubroutineName(program, shadertype, index, bufSize, length, name);
}

void GL_APIENTRY glGetActiveSubroutineUniformName(GLuint program,
                                                  GLenum shadertype,
                                                  GLuint index,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *name)
{
    return GL_GetActiveSubroutineUniformName(program, shadertype, index, bufSize, length, name);
}

void GL_APIENTRY glGetActiveSubroutineUniformiv(GLuint program,
                                                GLenum shadertype,
                                                GLuint index,
                                                GLenum pname,
                                                GLint *values)
{
    return GL_GetActiveSubroutineUniformiv(program, shadertype, index, pname, values);
}

void GL_APIENTRY glGetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint *values)
{
    return GL_GetProgramStageiv(program, shadertype, pname, values);
}

void GL_APIENTRY glGetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint *params)
{
    return GL_GetQueryIndexediv(target, index, pname, params);
}

GLuint GL_APIENTRY glGetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar *name)
{
    return GL_GetSubroutineIndex(program, shadertype, name);
}

GLint GL_APIENTRY glGetSubroutineUniformLocation(GLuint program,
                                                 GLenum shadertype,
                                                 const GLchar *name)
{
    return GL_GetSubroutineUniformLocation(program, shadertype, name);
}

void GL_APIENTRY glGetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint *params)
{
    return GL_GetUniformSubroutineuiv(shadertype, location, params);
}

void GL_APIENTRY glGetUniformdv(GLuint program, GLint location, GLdouble *params)
{
    return GL_GetUniformdv(program, location, params);
}

void GL_APIENTRY glPatchParameterfv(GLenum pname, const GLfloat *values)
{
    return GL_PatchParameterfv(pname, values);
}

void GL_APIENTRY glUniform1d(GLint location, GLdouble x)
{
    return GL_Uniform1d(location, x);
}

void GL_APIENTRY glUniform1dv(GLint location, GLsizei count, const GLdouble *value)
{
    return GL_Uniform1dv(location, count, value);
}

void GL_APIENTRY glUniform2d(GLint location, GLdouble x, GLdouble y)
{
    return GL_Uniform2d(location, x, y);
}

void GL_APIENTRY glUniform2dv(GLint location, GLsizei count, const GLdouble *value)
{
    return GL_Uniform2dv(location, count, value);
}

void GL_APIENTRY glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    return GL_Uniform3d(location, x, y, z);
}

void GL_APIENTRY glUniform3dv(GLint location, GLsizei count, const GLdouble *value)
{
    return GL_Uniform3dv(location, count, value);
}

void GL_APIENTRY glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return GL_Uniform4d(location, x, y, z, w);
}

void GL_APIENTRY glUniform4dv(GLint location, GLsizei count, const GLdouble *value)
{
    return GL_Uniform4dv(location, count, value);
}

void GL_APIENTRY glUniformMatrix2dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    return GL_UniformMatrix2dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix2x3dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix2x3dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix2x4dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix2x4dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    return GL_UniformMatrix3dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3x2dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix3x2dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix3x4dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix3x4dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4dv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLdouble *value)
{
    return GL_UniformMatrix4dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4x2dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix4x2dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformMatrix4x3dv(GLint location,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLdouble *value)
{
    return GL_UniformMatrix4x3dv(location, count, transpose, value);
}

void GL_APIENTRY glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint *indices)
{
    return GL_UniformSubroutinesuiv(shadertype, count, indices);
}

// GL 4.1
void GL_APIENTRY glDepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v)
{
    return GL_DepthRangeArrayv(first, count, v);
}

void GL_APIENTRY glDepthRangeIndexed(GLuint index, GLdouble n, GLdouble f)
{
    return GL_DepthRangeIndexed(index, n, f);
}

void GL_APIENTRY glGetDoublei_v(GLenum target, GLuint index, GLdouble *data)
{
    return GL_GetDoublei_v(target, index, data);
}

void GL_APIENTRY glGetFloati_v(GLenum target, GLuint index, GLfloat *data)
{
    return GL_GetFloati_v(target, index, data);
}

void GL_APIENTRY glGetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params)
{
    return GL_GetVertexAttribLdv(index, pname, params);
}

void GL_APIENTRY glProgramUniform1d(GLuint program, GLint location, GLdouble v0)
{
    return GL_ProgramUniform1d(program, location, v0);
}

void GL_APIENTRY glProgramUniform1dv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLdouble *value)
{
    return GL_ProgramUniform1dv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
    return GL_ProgramUniform2d(program, location, v0, v1);
}

void GL_APIENTRY glProgramUniform2dv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLdouble *value)
{
    return GL_ProgramUniform2dv(program, location, count, value);
}

void GL_APIENTRY
glProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
    return GL_ProgramUniform3d(program, location, v0, v1, v2);
}

void GL_APIENTRY glProgramUniform3dv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLdouble *value)
{
    return GL_ProgramUniform3dv(program, location, count, value);
}

void GL_APIENTRY glProgramUniform4d(GLuint program,
                                    GLint location,
                                    GLdouble v0,
                                    GLdouble v1,
                                    GLdouble v2,
                                    GLdouble v3)
{
    return GL_ProgramUniform4d(program, location, v0, v1, v2, v3);
}

void GL_APIENTRY glProgramUniform4dv(GLuint program,
                                     GLint location,
                                     GLsizei count,
                                     const GLdouble *value)
{
    return GL_ProgramUniform4dv(program, location, count, value);
}

void GL_APIENTRY glProgramUniformMatrix2dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    return GL_ProgramUniformMatrix2dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x3dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix2x3dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix2x4dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix2x4dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    return GL_ProgramUniformMatrix3dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x2dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix3x2dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix3x4dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix3x4dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    return GL_ProgramUniformMatrix4dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x2dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix4x2dv(program, location, count, transpose, value);
}

void GL_APIENTRY glProgramUniformMatrix4x3dv(GLuint program,
                                             GLint location,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLdouble *value)
{
    return GL_ProgramUniformMatrix4x3dv(program, location, count, transpose, value);
}

void GL_APIENTRY glScissorArrayv(GLuint first, GLsizei count, const GLint *v)
{
    return GL_ScissorArrayv(first, count, v);
}

void GL_APIENTRY
glScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
    return GL_ScissorIndexed(index, left, bottom, width, height);
}

void GL_APIENTRY glScissorIndexedv(GLuint index, const GLint *v)
{
    return GL_ScissorIndexedv(index, v);
}

void GL_APIENTRY glVertexAttribL1d(GLuint index, GLdouble x)
{
    return GL_VertexAttribL1d(index, x);
}

void GL_APIENTRY glVertexAttribL1dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttribL1dv(index, v);
}

void GL_APIENTRY glVertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
    return GL_VertexAttribL2d(index, x, y);
}

void GL_APIENTRY glVertexAttribL2dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttribL2dv(index, v);
}

void GL_APIENTRY glVertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    return GL_VertexAttribL3d(index, x, y, z);
}

void GL_APIENTRY glVertexAttribL3dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttribL3dv(index, v);
}

void GL_APIENTRY glVertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return GL_VertexAttribL4d(index, x, y, z, w);
}

void GL_APIENTRY glVertexAttribL4dv(GLuint index, const GLdouble *v)
{
    return GL_VertexAttribL4dv(index, v);
}

void GL_APIENTRY
glVertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    return GL_VertexAttribLPointer(index, size, type, stride, pointer);
}

void GL_APIENTRY glViewportArrayv(GLuint first, GLsizei count, const GLfloat *v)
{
    return GL_ViewportArrayv(first, count, v);
}

void GL_APIENTRY glViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
    return GL_ViewportIndexedf(index, x, y, w, h);
}

void GL_APIENTRY glViewportIndexedfv(GLuint index, const GLfloat *v)
{
    return GL_ViewportIndexedfv(index, v);
}

// GL 4.2
void GL_APIENTRY glDrawArraysInstancedBaseInstance(GLenum mode,
                                                   GLint first,
                                                   GLsizei count,
                                                   GLsizei instancecount,
                                                   GLuint baseinstance)
{
    return GL_DrawArraysInstancedBaseInstance(mode, first, count, instancecount, baseinstance);
}

void GL_APIENTRY glDrawElementsInstancedBaseInstance(GLenum mode,
                                                     GLsizei count,
                                                     GLenum type,
                                                     const void *indices,
                                                     GLsizei instancecount,
                                                     GLuint baseinstance)
{
    return GL_DrawElementsInstancedBaseInstance(mode, count, type, indices, instancecount,
                                                baseinstance);
}

void GL_APIENTRY glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode,
                                                               GLsizei count,
                                                               GLenum type,
                                                               const void *indices,
                                                               GLsizei instancecount,
                                                               GLint basevertex,
                                                               GLuint baseinstance)
{
    return GL_DrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, instancecount,
                                                          basevertex, baseinstance);
}

void GL_APIENTRY glDrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei instancecount)
{
    return GL_DrawTransformFeedbackInstanced(mode, id, instancecount);
}

void GL_APIENTRY glDrawTransformFeedbackStreamInstanced(GLenum mode,
                                                        GLuint id,
                                                        GLuint stream,
                                                        GLsizei instancecount)
{
    return GL_DrawTransformFeedbackStreamInstanced(mode, id, stream, instancecount);
}

void GL_APIENTRY glGetActiveAtomicCounterBufferiv(GLuint program,
                                                  GLuint bufferIndex,
                                                  GLenum pname,
                                                  GLint *params)
{
    return GL_GetActiveAtomicCounterBufferiv(program, bufferIndex, pname, params);
}

void GL_APIENTRY glTexStorage1D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)
{
    return GL_TexStorage1D(target, levels, internalformat, width);
}

// GL 4.3
void GL_APIENTRY glClearBufferData(GLenum target,
                                   GLenum internalformat,
                                   GLenum format,
                                   GLenum type,
                                   const void *data)
{
    return GL_ClearBufferData(target, internalformat, format, type, data);
}

void GL_APIENTRY glClearBufferSubData(GLenum target,
                                      GLenum internalformat,
                                      GLintptr offset,
                                      GLsizeiptr size,
                                      GLenum format,
                                      GLenum type,
                                      const void *data)
{
    return GL_ClearBufferSubData(target, internalformat, offset, size, format, type, data);
}

void GL_APIENTRY glGetInternalformati64v(GLenum target,
                                         GLenum internalformat,
                                         GLenum pname,
                                         GLsizei count,
                                         GLint64 *params)
{
    return GL_GetInternalformati64v(target, internalformat, pname, count, params);
}

GLint GL_APIENTRY glGetProgramResourceLocationIndex(GLuint program,
                                                    GLenum programInterface,
                                                    const GLchar *name)
{
    return GL_GetProgramResourceLocationIndex(program, programInterface, name);
}

void GL_APIENTRY glInvalidateBufferData(GLuint buffer)
{
    return GL_InvalidateBufferData(buffer);
}

void GL_APIENTRY glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    return GL_InvalidateBufferSubData(buffer, offset, length);
}

void GL_APIENTRY glInvalidateTexImage(GLuint texture, GLint level)
{
    return GL_InvalidateTexImage(texture, level);
}

void GL_APIENTRY glInvalidateTexSubImage(GLuint texture,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth)
{
    return GL_InvalidateTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height,
                                    depth);
}

void GL_APIENTRY glMultiDrawArraysIndirect(GLenum mode,
                                           const void *indirect,
                                           GLsizei drawcount,
                                           GLsizei stride)
{
    return GL_MultiDrawArraysIndirect(mode, indirect, drawcount, stride);
}

void GL_APIENTRY glMultiDrawElementsIndirect(GLenum mode,
                                             GLenum type,
                                             const void *indirect,
                                             GLsizei drawcount,
                                             GLsizei stride)
{
    return GL_MultiDrawElementsIndirect(mode, type, indirect, drawcount, stride);
}

void GL_APIENTRY glShaderStorageBlockBinding(GLuint program,
                                             GLuint storageBlockIndex,
                                             GLuint storageBlockBinding)
{
    return GL_ShaderStorageBlockBinding(program, storageBlockIndex, storageBlockBinding);
}

void GL_APIENTRY glTextureView(GLuint texture,
                               GLenum target,
                               GLuint origtexture,
                               GLenum internalformat,
                               GLuint minlevel,
                               GLuint numlevels,
                               GLuint minlayer,
                               GLuint numlayers)
{
    return GL_TextureView(texture, target, origtexture, internalformat, minlevel, numlevels,
                          minlayer, numlayers);
}

void GL_APIENTRY glVertexAttribLFormat(GLuint attribindex,
                                       GLint size,
                                       GLenum type,
                                       GLuint relativeoffset)
{
    return GL_VertexAttribLFormat(attribindex, size, type, relativeoffset);
}

// GL 4.4
void GL_APIENTRY glBindBuffersBase(GLenum target,
                                   GLuint first,
                                   GLsizei count,
                                   const GLuint *buffers)
{
    return GL_BindBuffersBase(target, first, count, buffers);
}

void GL_APIENTRY glBindBuffersRange(GLenum target,
                                    GLuint first,
                                    GLsizei count,
                                    const GLuint *buffers,
                                    const GLintptr *offsets,
                                    const GLsizeiptr *sizes)
{
    return GL_BindBuffersRange(target, first, count, buffers, offsets, sizes);
}

void GL_APIENTRY glBindImageTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    return GL_BindImageTextures(first, count, textures);
}

void GL_APIENTRY glBindSamplers(GLuint first, GLsizei count, const GLuint *samplers)
{
    return GL_BindSamplers(first, count, samplers);
}

void GL_APIENTRY glBindTextures(GLuint first, GLsizei count, const GLuint *textures)
{
    return GL_BindTextures(first, count, textures);
}

void GL_APIENTRY glBindVertexBuffers(GLuint first,
                                     GLsizei count,
                                     const GLuint *buffers,
                                     const GLintptr *offsets,
                                     const GLsizei *strides)
{
    return GL_BindVertexBuffers(first, count, buffers, offsets, strides);
}

void GL_APIENTRY glBufferStorage(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags)
{
    return GL_BufferStorage(target, size, data, flags);
}

void GL_APIENTRY
glClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)
{
    return GL_ClearTexImage(texture, level, format, type, data);
}

void GL_APIENTRY glClearTexSubImage(GLuint texture,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *data)
{
    return GL_ClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth,
                               format, type, data);
}

// GL 4.5
void GL_APIENTRY glBindTextureUnit(GLuint unit, GLuint texture)
{
    return GL_BindTextureUnit(unit, texture);
}

void GL_APIENTRY glBlitNamedFramebuffer(GLuint readFramebuffer,
                                        GLuint drawFramebuffer,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    return GL_BlitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1,
                                   dstX0, dstY0, dstX1, dstY1, mask, filter);
}

GLenum GL_APIENTRY glCheckNamedFramebufferStatus(GLuint framebuffer, GLenum target)
{
    return GL_CheckNamedFramebufferStatus(framebuffer, target);
}

void GL_APIENTRY glClearNamedBufferData(GLuint buffer,
                                        GLenum internalformat,
                                        GLenum format,
                                        GLenum type,
                                        const void *data)
{
    return GL_ClearNamedBufferData(buffer, internalformat, format, type, data);
}

void GL_APIENTRY glClearNamedBufferSubData(GLuint buffer,
                                           GLenum internalformat,
                                           GLintptr offset,
                                           GLsizeiptr size,
                                           GLenum format,
                                           GLenum type,
                                           const void *data)
{
    return GL_ClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, data);
}

void GL_APIENTRY glClearNamedFramebufferfi(GLuint framebuffer,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           GLfloat depth,
                                           GLint stencil)
{
    return GL_ClearNamedFramebufferfi(framebuffer, buffer, drawbuffer, depth, stencil);
}

void GL_APIENTRY glClearNamedFramebufferfv(GLuint framebuffer,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLfloat *value)
{
    return GL_ClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, value);
}

void GL_APIENTRY glClearNamedFramebufferiv(GLuint framebuffer,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLint *value)
{
    return GL_ClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, value);
}

void GL_APIENTRY glClearNamedFramebufferuiv(GLuint framebuffer,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLuint *value)
{
    return GL_ClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, value);
}

void GL_APIENTRY glClipControl(GLenum origin, GLenum depth)
{
    return GL_ClipControl(origin, depth);
}

void GL_APIENTRY glCompressedTextureSubImage1D(GLuint texture,
                                               GLint level,
                                               GLint xoffset,
                                               GLsizei width,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    return GL_CompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data);
}

void GL_APIENTRY glCompressedTextureSubImage2D(GLuint texture,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    return GL_CompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format,
                                          imageSize, data);
}

void GL_APIENTRY glCompressedTextureSubImage3D(GLuint texture,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLenum format,
                                               GLsizei imageSize,
                                               const void *data)
{
    return GL_CompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height,
                                          depth, format, imageSize, data);
}

void GL_APIENTRY glCopyNamedBufferSubData(GLuint readBuffer,
                                          GLuint writeBuffer,
                                          GLintptr readOffset,
                                          GLintptr writeOffset,
                                          GLsizeiptr size)
{
    return GL_CopyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size);
}

void GL_APIENTRY
glCopyTextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    return GL_CopyTextureSubImage1D(texture, level, xoffset, x, y, width);
}

void GL_APIENTRY glCopyTextureSubImage2D(GLuint texture,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    return GL_CopyTextureSubImage2D(texture, level, xoffset, yoffset, x, y, width, height);
}

void GL_APIENTRY glCopyTextureSubImage3D(GLuint texture,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height)
{
    return GL_CopyTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, x, y, width, height);
}

void GL_APIENTRY glCreateBuffers(GLsizei n, GLuint *buffers)
{
    return GL_CreateBuffers(n, buffers);
}

void GL_APIENTRY glCreateFramebuffers(GLsizei n, GLuint *framebuffers)
{
    return GL_CreateFramebuffers(n, framebuffers);
}

void GL_APIENTRY glCreateProgramPipelines(GLsizei n, GLuint *pipelines)
{
    return GL_CreateProgramPipelines(n, pipelines);
}

void GL_APIENTRY glCreateQueries(GLenum target, GLsizei n, GLuint *ids)
{
    return GL_CreateQueries(target, n, ids);
}

void GL_APIENTRY glCreateRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    return GL_CreateRenderbuffers(n, renderbuffers);
}

void GL_APIENTRY glCreateSamplers(GLsizei n, GLuint *samplers)
{
    return GL_CreateSamplers(n, samplers);
}

void GL_APIENTRY glCreateTextures(GLenum target, GLsizei n, GLuint *textures)
{
    return GL_CreateTextures(target, n, textures);
}

void GL_APIENTRY glCreateTransformFeedbacks(GLsizei n, GLuint *ids)
{
    return GL_CreateTransformFeedbacks(n, ids);
}

void GL_APIENTRY glCreateVertexArrays(GLsizei n, GLuint *arrays)
{
    return GL_CreateVertexArrays(n, arrays);
}

void GL_APIENTRY glDisableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    return GL_DisableVertexArrayAttrib(vaobj, index);
}

void GL_APIENTRY glEnableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
    return GL_EnableVertexArrayAttrib(vaobj, index);
}

void GL_APIENTRY glFlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
    return GL_FlushMappedNamedBufferRange(buffer, offset, length);
}

void GL_APIENTRY glGenerateTextureMipmap(GLuint texture)
{
    return GL_GenerateTextureMipmap(texture);
}

void GL_APIENTRY glGetCompressedTextureImage(GLuint texture,
                                             GLint level,
                                             GLsizei bufSize,
                                             void *pixels)
{
    return GL_GetCompressedTextureImage(texture, level, bufSize, pixels);
}

void GL_APIENTRY glGetCompressedTextureSubImage(GLuint texture,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLint zoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLsizei bufSize,
                                                void *pixels)
{
    return GL_GetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height,
                                           depth, bufSize, pixels);
}

void GL_APIENTRY glGetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 *params)
{
    return GL_GetNamedBufferParameteri64v(buffer, pname, params);
}

void GL_APIENTRY glGetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint *params)
{
    return GL_GetNamedBufferParameteriv(buffer, pname, params);
}

void GL_APIENTRY glGetNamedBufferPointerv(GLuint buffer, GLenum pname, void **params)
{
    return GL_GetNamedBufferPointerv(buffer, pname, params);
}

void GL_APIENTRY glGetNamedBufferSubData(GLuint buffer,
                                         GLintptr offset,
                                         GLsizeiptr size,
                                         void *data)
{
    return GL_GetNamedBufferSubData(buffer, offset, size, data);
}

void GL_APIENTRY glGetNamedFramebufferAttachmentParameteriv(GLuint framebuffer,
                                                            GLenum attachment,
                                                            GLenum pname,
                                                            GLint *params)
{
    return GL_GetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, params);
}

void GL_APIENTRY glGetNamedFramebufferParameteriv(GLuint framebuffer, GLenum pname, GLint *param)
{
    return GL_GetNamedFramebufferParameteriv(framebuffer, pname, param);
}

void GL_APIENTRY glGetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint *params)
{
    return GL_GetNamedRenderbufferParameteriv(renderbuffer, pname, params);
}

void GL_APIENTRY glGetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    return GL_GetQueryBufferObjecti64v(id, buffer, pname, offset);
}

void GL_APIENTRY glGetQueryBufferObjectiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    return GL_GetQueryBufferObjectiv(id, buffer, pname, offset);
}

void GL_APIENTRY glGetQueryBufferObjectui64v(GLuint id,
                                             GLuint buffer,
                                             GLenum pname,
                                             GLintptr offset)
{
    return GL_GetQueryBufferObjectui64v(id, buffer, pname, offset);
}

void GL_APIENTRY glGetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
    return GL_GetQueryBufferObjectuiv(id, buffer, pname, offset);
}

void GL_APIENTRY glGetTextureImage(GLuint texture,
                                   GLint level,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   void *pixels)
{
    return GL_GetTextureImage(texture, level, format, type, bufSize, pixels);
}

void GL_APIENTRY glGetTextureLevelParameterfv(GLuint texture,
                                              GLint level,
                                              GLenum pname,
                                              GLfloat *params)
{
    return GL_GetTextureLevelParameterfv(texture, level, pname, params);
}

void GL_APIENTRY glGetTextureLevelParameteriv(GLuint texture,
                                              GLint level,
                                              GLenum pname,
                                              GLint *params)
{
    return GL_GetTextureLevelParameteriv(texture, level, pname, params);
}

void GL_APIENTRY glGetTextureParameterIiv(GLuint texture, GLenum pname, GLint *params)
{
    return GL_GetTextureParameterIiv(texture, pname, params);
}

void GL_APIENTRY glGetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint *params)
{
    return GL_GetTextureParameterIuiv(texture, pname, params);
}

void GL_APIENTRY glGetTextureParameterfv(GLuint texture, GLenum pname, GLfloat *params)
{
    return GL_GetTextureParameterfv(texture, pname, params);
}

void GL_APIENTRY glGetTextureParameteriv(GLuint texture, GLenum pname, GLint *params)
{
    return GL_GetTextureParameteriv(texture, pname, params);
}

void GL_APIENTRY glGetTextureSubImage(GLuint texture,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      void *pixels)
{
    return GL_GetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth,
                                 format, type, bufSize, pixels);
}

void GL_APIENTRY glGetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 *param)
{
    return GL_GetTransformFeedbacki64_v(xfb, pname, index, param);
}

void GL_APIENTRY glGetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint *param)
{
    return GL_GetTransformFeedbacki_v(xfb, pname, index, param);
}

void GL_APIENTRY glGetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint *param)
{
    return GL_GetTransformFeedbackiv(xfb, pname, param);
}

void GL_APIENTRY glGetVertexArrayIndexed64iv(GLuint vaobj,
                                             GLuint index,
                                             GLenum pname,
                                             GLint64 *param)
{
    return GL_GetVertexArrayIndexed64iv(vaobj, index, pname, param);
}

void GL_APIENTRY glGetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint *param)
{
    return GL_GetVertexArrayIndexediv(vaobj, index, pname, param);
}

void GL_APIENTRY glGetVertexArrayiv(GLuint vaobj, GLenum pname, GLint *param)
{
    return GL_GetVertexArrayiv(vaobj, pname, param);
}

void GL_APIENTRY
glGetnColorTable(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)
{
    return GL_GetnColorTable(target, format, type, bufSize, table);
}

void GL_APIENTRY glGetnCompressedTexImage(GLenum target, GLint lod, GLsizei bufSize, void *pixels)
{
    return GL_GetnCompressedTexImage(target, lod, bufSize, pixels);
}

void GL_APIENTRY
glGetnConvolutionFilter(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)
{
    return GL_GetnConvolutionFilter(target, format, type, bufSize, image);
}

void GL_APIENTRY glGetnHistogram(GLenum target,
                                 GLboolean reset,
                                 GLenum format,
                                 GLenum type,
                                 GLsizei bufSize,
                                 void *values)
{
    return GL_GetnHistogram(target, reset, format, type, bufSize, values);
}

void GL_APIENTRY glGetnMapdv(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)
{
    return GL_GetnMapdv(target, query, bufSize, v);
}

void GL_APIENTRY glGetnMapfv(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)
{
    return GL_GetnMapfv(target, query, bufSize, v);
}

void GL_APIENTRY glGetnMapiv(GLenum target, GLenum query, GLsizei bufSize, GLint *v)
{
    return GL_GetnMapiv(target, query, bufSize, v);
}

void GL_APIENTRY glGetnMinmax(GLenum target,
                              GLboolean reset,
                              GLenum format,
                              GLenum type,
                              GLsizei bufSize,
                              void *values)
{
    return GL_GetnMinmax(target, reset, format, type, bufSize, values);
}

void GL_APIENTRY glGetnPixelMapfv(GLenum map, GLsizei bufSize, GLfloat *values)
{
    return GL_GetnPixelMapfv(map, bufSize, values);
}

void GL_APIENTRY glGetnPixelMapuiv(GLenum map, GLsizei bufSize, GLuint *values)
{
    return GL_GetnPixelMapuiv(map, bufSize, values);
}

void GL_APIENTRY glGetnPixelMapusv(GLenum map, GLsizei bufSize, GLushort *values)
{
    return GL_GetnPixelMapusv(map, bufSize, values);
}

void GL_APIENTRY glGetnPolygonStipple(GLsizei bufSize, GLubyte *pattern)
{
    return GL_GetnPolygonStipple(bufSize, pattern);
}

void GL_APIENTRY glGetnSeparableFilter(GLenum target,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei rowBufSize,
                                       void *row,
                                       GLsizei columnBufSize,
                                       void *column,
                                       void *span)
{
    return GL_GetnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize, column,
                                  span);
}

void GL_APIENTRY glGetnTexImage(GLenum target,
                                GLint level,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *pixels)
{
    return GL_GetnTexImage(target, level, format, type, bufSize, pixels);
}

void GL_APIENTRY glGetnUniformdv(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)
{
    return GL_GetnUniformdv(program, location, bufSize, params);
}

void GL_APIENTRY glInvalidateNamedFramebufferData(GLuint framebuffer,
                                                  GLsizei numAttachments,
                                                  const GLenum *attachments)
{
    return GL_InvalidateNamedFramebufferData(framebuffer, numAttachments, attachments);
}

void GL_APIENTRY glInvalidateNamedFramebufferSubData(GLuint framebuffer,
                                                     GLsizei numAttachments,
                                                     const GLenum *attachments,
                                                     GLint x,
                                                     GLint y,
                                                     GLsizei width,
                                                     GLsizei height)
{
    return GL_InvalidateNamedFramebufferSubData(framebuffer, numAttachments, attachments, x, y,
                                                width, height);
}

void *GL_APIENTRY glMapNamedBuffer(GLuint buffer, GLenum access)
{
    return GL_MapNamedBuffer(buffer, access);
}

void *GL_APIENTRY glMapNamedBufferRange(GLuint buffer,
                                        GLintptr offset,
                                        GLsizeiptr length,
                                        GLbitfield access)
{
    return GL_MapNamedBufferRange(buffer, offset, length, access);
}

void GL_APIENTRY glNamedBufferData(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)
{
    return GL_NamedBufferData(buffer, size, data, usage);
}

void GL_APIENTRY glNamedBufferStorage(GLuint buffer,
                                      GLsizeiptr size,
                                      const void *data,
                                      GLbitfield flags)
{
    return GL_NamedBufferStorage(buffer, size, data, flags);
}

void GL_APIENTRY glNamedBufferSubData(GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size,
                                      const void *data)
{
    return GL_NamedBufferSubData(buffer, offset, size, data);
}

void GL_APIENTRY glNamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf)
{
    return GL_NamedFramebufferDrawBuffer(framebuffer, buf);
}

void GL_APIENTRY glNamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum *bufs)
{
    return GL_NamedFramebufferDrawBuffers(framebuffer, n, bufs);
}

void GL_APIENTRY glNamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param)
{
    return GL_NamedFramebufferParameteri(framebuffer, pname, param);
}

void GL_APIENTRY glNamedFramebufferReadBuffer(GLuint framebuffer, GLenum src)
{
    return GL_NamedFramebufferReadBuffer(framebuffer, src);
}

void GL_APIENTRY glNamedFramebufferRenderbuffer(GLuint framebuffer,
                                                GLenum attachment,
                                                GLenum renderbuffertarget,
                                                GLuint renderbuffer)
{
    return GL_NamedFramebufferRenderbuffer(framebuffer, attachment, renderbuffertarget,
                                           renderbuffer);
}

void GL_APIENTRY glNamedFramebufferTexture(GLuint framebuffer,
                                           GLenum attachment,
                                           GLuint texture,
                                           GLint level)
{
    return GL_NamedFramebufferTexture(framebuffer, attachment, texture, level);
}

void GL_APIENTRY glNamedFramebufferTextureLayer(GLuint framebuffer,
                                                GLenum attachment,
                                                GLuint texture,
                                                GLint level,
                                                GLint layer)
{
    return GL_NamedFramebufferTextureLayer(framebuffer, attachment, texture, level, layer);
}

void GL_APIENTRY glNamedRenderbufferStorage(GLuint renderbuffer,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height)
{
    return GL_NamedRenderbufferStorage(renderbuffer, internalformat, width, height);
}

void GL_APIENTRY glNamedRenderbufferStorageMultisample(GLuint renderbuffer,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    return GL_NamedRenderbufferStorageMultisample(renderbuffer, samples, internalformat, width,
                                                  height);
}

void GL_APIENTRY glTextureBarrier()
{
    return GL_TextureBarrier();
}

void GL_APIENTRY glTextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer)
{
    return GL_TextureBuffer(texture, internalformat, buffer);
}

void GL_APIENTRY glTextureBufferRange(GLuint texture,
                                      GLenum internalformat,
                                      GLuint buffer,
                                      GLintptr offset,
                                      GLsizeiptr size)
{
    return GL_TextureBufferRange(texture, internalformat, buffer, offset, size);
}

void GL_APIENTRY glTextureParameterIiv(GLuint texture, GLenum pname, const GLint *params)
{
    return GL_TextureParameterIiv(texture, pname, params);
}

void GL_APIENTRY glTextureParameterIuiv(GLuint texture, GLenum pname, const GLuint *params)
{
    return GL_TextureParameterIuiv(texture, pname, params);
}

void GL_APIENTRY glTextureParameterf(GLuint texture, GLenum pname, GLfloat param)
{
    return GL_TextureParameterf(texture, pname, param);
}

void GL_APIENTRY glTextureParameterfv(GLuint texture, GLenum pname, const GLfloat *param)
{
    return GL_TextureParameterfv(texture, pname, param);
}

void GL_APIENTRY glTextureParameteri(GLuint texture, GLenum pname, GLint param)
{
    return GL_TextureParameteri(texture, pname, param);
}

void GL_APIENTRY glTextureParameteriv(GLuint texture, GLenum pname, const GLint *param)
{
    return GL_TextureParameteriv(texture, pname, param);
}

void GL_APIENTRY glTextureStorage1D(GLuint texture,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width)
{
    return GL_TextureStorage1D(texture, levels, internalformat, width);
}

void GL_APIENTRY glTextureStorage2D(GLuint texture,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height)
{
    return GL_TextureStorage2D(texture, levels, internalformat, width, height);
}

void GL_APIENTRY glTextureStorage2DMultisample(GLuint texture,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLboolean fixedsamplelocations)
{
    return GL_TextureStorage2DMultisample(texture, samples, internalformat, width, height,
                                          fixedsamplelocations);
}

void GL_APIENTRY glTextureStorage3D(GLuint texture,
                                    GLsizei levels,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth)
{
    return GL_TextureStorage3D(texture, levels, internalformat, width, height, depth);
}

void GL_APIENTRY glTextureStorage3DMultisample(GLuint texture,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedsamplelocations)
{
    return GL_TextureStorage3DMultisample(texture, samples, internalformat, width, height, depth,
                                          fixedsamplelocations);
}

void GL_APIENTRY glTextureSubImage1D(GLuint texture,
                                     GLint level,
                                     GLint xoffset,
                                     GLsizei width,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    return GL_TextureSubImage1D(texture, level, xoffset, width, format, type, pixels);
}

void GL_APIENTRY glTextureSubImage2D(GLuint texture,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    return GL_TextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type,
                                pixels);
}

void GL_APIENTRY glTextureSubImage3D(GLuint texture,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLenum format,
                                     GLenum type,
                                     const void *pixels)
{
    return GL_TextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth,
                                format, type, pixels);
}

void GL_APIENTRY glTransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer)
{
    return GL_TransformFeedbackBufferBase(xfb, index, buffer);
}

void GL_APIENTRY glTransformFeedbackBufferRange(GLuint xfb,
                                                GLuint index,
                                                GLuint buffer,
                                                GLintptr offset,
                                                GLsizeiptr size)
{
    return GL_TransformFeedbackBufferRange(xfb, index, buffer, offset, size);
}

GLboolean GL_APIENTRY glUnmapNamedBuffer(GLuint buffer)
{
    return GL_UnmapNamedBuffer(buffer);
}

void GL_APIENTRY glVertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
    return GL_VertexArrayAttribBinding(vaobj, attribindex, bindingindex);
}

void GL_APIENTRY glVertexArrayAttribFormat(GLuint vaobj,
                                           GLuint attribindex,
                                           GLint size,
                                           GLenum type,
                                           GLboolean normalized,
                                           GLuint relativeoffset)
{
    return GL_VertexArrayAttribFormat(vaobj, attribindex, size, type, normalized, relativeoffset);
}

void GL_APIENTRY glVertexArrayAttribIFormat(GLuint vaobj,
                                            GLuint attribindex,
                                            GLint size,
                                            GLenum type,
                                            GLuint relativeoffset)
{
    return GL_VertexArrayAttribIFormat(vaobj, attribindex, size, type, relativeoffset);
}

void GL_APIENTRY glVertexArrayAttribLFormat(GLuint vaobj,
                                            GLuint attribindex,
                                            GLint size,
                                            GLenum type,
                                            GLuint relativeoffset)
{
    return GL_VertexArrayAttribLFormat(vaobj, attribindex, size, type, relativeoffset);
}

void GL_APIENTRY glVertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
    return GL_VertexArrayBindingDivisor(vaobj, bindingindex, divisor);
}

void GL_APIENTRY glVertexArrayElementBuffer(GLuint vaobj, GLuint buffer)
{
    return GL_VertexArrayElementBuffer(vaobj, buffer);
}

void GL_APIENTRY glVertexArrayVertexBuffer(GLuint vaobj,
                                           GLuint bindingindex,
                                           GLuint buffer,
                                           GLintptr offset,
                                           GLsizei stride)
{
    return GL_VertexArrayVertexBuffer(vaobj, bindingindex, buffer, offset, stride);
}

void GL_APIENTRY glVertexArrayVertexBuffers(GLuint vaobj,
                                            GLuint first,
                                            GLsizei count,
                                            const GLuint *buffers,
                                            const GLintptr *offsets,
                                            const GLsizei *strides)
{
    return GL_VertexArrayVertexBuffers(vaobj, first, count, buffers, offsets, strides);
}

// GL 4.6
void GL_APIENTRY glMultiDrawArraysIndirectCount(GLenum mode,
                                                const void *indirect,
                                                GLintptr drawcount,
                                                GLsizei maxdrawcount,
                                                GLsizei stride)
{
    return GL_MultiDrawArraysIndirectCount(mode, indirect, drawcount, maxdrawcount, stride);
}

void GL_APIENTRY glMultiDrawElementsIndirectCount(GLenum mode,
                                                  GLenum type,
                                                  const void *indirect,
                                                  GLintptr drawcount,
                                                  GLsizei maxdrawcount,
                                                  GLsizei stride)
{
    return GL_MultiDrawElementsIndirectCount(mode, type, indirect, drawcount, maxdrawcount, stride);
}

void GL_APIENTRY glPolygonOffsetClamp(GLfloat factor, GLfloat units, GLfloat clamp)
{
    return GL_PolygonOffsetClamp(factor, units, clamp);
}

void GL_APIENTRY glSpecializeShader(GLuint shader,
                                    const GLchar *pEntryPoint,
                                    GLuint numSpecializationConstants,
                                    const GLuint *pConstantIndex,
                                    const GLuint *pConstantValue)
{
    return GL_SpecializeShader(shader, pEntryPoint, numSpecializationConstants, pConstantIndex,
                               pConstantValue);
}

#endif  // defined(ANGLE_ENABLE_GL_DESKTOP_FRONTEND)
}  // extern "C"
