const char TEST_DESCRIPTORS[] =
  "@uploaded-at 2020-10-13 13:27:09\n"
  "@source \"127.0.0.1\"\n"
  "router test001a 127.0.0.1 5001 0 7001\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAaaOTHiF5TNABkcl/U1x6qvlb8dyNBjuezXxF2wFLgrRAQAgBAD/a0Xx\n"
  "SqkjrxcXc1h00vvkSqjNuGb4xYg1BZUoZnwegCQmxELY6fQ3m3EzYfSSl1tbP2u8\n"
  "sN4SBJCsV7aRdoYebs80CnrsPiUecVdTwruODb+wAKqKSl3u7+qx8dd1yAI=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 /2tF8UqpI68XF3NYdNL75Eqozbhm+MWINQWVKGZ8HoA\n"
  "or-address [::]:5001\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:09\n"
  "fingerprint 2403 20EC F589 C1F4 DC0B 864B 28AF 8113 59CE FD86\n"
  "uptime 324426\n"
  "bandwidth 1073741824 1073741824 640416\n"
  "extra-info-digest FD0FEB6B7F99C2E9A3C98968F6FB2C61B1688760 FDt9yIgtRYfaANh+E7NV6MUAvOR7DcJIjjBkhGMN6Vs\n"
  "caches-extra-info\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOrByE3R1SqUkYLMDDB408uliYrBj860aKU0sbS9F9xmxFONB4xHP6uA\n"
  "MyBgHQGL91N30yZxWKkdRiuKpCZafxLrflx20U/JTijJugNWPBcLXG7pTaJsL7LQ\n"
  "61WRwo7md8X5zRhSGd8Pisq2Ru2yDrd0DNfoxy2CSLJX0DN9aw4xAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALb83qDqIq7U75NuDnzZL/A1YvxMp/YqoxtKd2GuCOMRpu+DLpEJfAkB\n"
  "0o9IP+CeCkT3JPP2irY+WEw8gLU9bx2VfdK4sm59Q7G0gWcfYsvn3wb3q43e0LOf\n"
  "KQ/HMkZ+sJwQ5sCteAhGqbr9XNBfRE0bT5pyEZGKNg3ufCd1c7MLAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "Mr8P5CTgWB/J84yzF/zY4tnQixbFyNBXi+KXBVvRmFRKBKtRRf7NYKDlXpTWA+yv\n"
  "lyVzzKyVlSreRIZbmS/VZrS0adj8EL8VAGVg3l/7ZumKFRB0JSiVpidd2yu0K8/2\n"
  "qENpmGQbFco+6tj8dsxr4HrPaV7UBDxwjDR/2HADiiI=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAf9rRfFKqSOvFxdzWHTS++RKqM24ZvjFiDUFlShmfB6AAFr/gG3LV3nx\n"
  "pFWmVimT3w4a9RX4sihTdCQKtYIO2JTSUaBnBBCGWNKL/pgMq13Y+fUnrrltFprb\n"
  "ts9KP+yi/QU=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "contact auth1@test.test\n"
  "ntor-onion-key rrw3paBStz7xhguZJDdjl/Tcpqwgv4u37Zi1zJcVNFk\n"
  "reject *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 pVC4W6LarfI5xgQIjwoizvHiU6HXf0P9t7M4nWQfYduzNuIk3KPDVxZWfm+r3QDMBVDSBc9yAmFVmxFi4PfeAg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "KHkPXBETKq3xyIckAS8BfL5Numjx2f3wLxkkDbDtsJt4nhXuL3CyWwtQGGQOqo10\n"
  "HJfxeV2FktxHjlW08BGp8/EwnOcHsJkKg2yOlJodYXln8ATsHaMDS6inllyACIfC\n"
  "680xs6LMJlUh/7qjPK3if7ayD+vPDCh+5IXq4n4Rn3k=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:10\n"
  "@source \"127.0.0.1\"\n"
  "router test002a 127.0.0.1 5002 0 7002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAW2RVTJizfLKok8vZjvtdSQfTkjJbwuBJJah89MpjJJ1AQAgBAD7AE/p\n"
  "ZVnOoor55N3BTseFvzTESbjQVJkMEw2jNMmkMUeolbJlRtsklLCMGjY9H79EFdY1\n"
  "QamhpTz5AR4IyKdruX5SD+h8ovvWQK/pvVD20rI7Em6Qbg8OVvEPaZwxQwo=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 +wBP6WVZzqKK+eTdwU7Hhb80xEm40FSZDBMNozTJpDE\n"
  "or-address [::]:5002\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:10\n"
  "fingerprint 1849 2918 5A95 1CF2 DDA7 C3B0 1ACB 32D7 360C C4BF\n"
  "uptime 324427\n"
  "bandwidth 1073741824 1073741824 776649\n"
  "extra-info-digest 8CB745E0CD4FD3E7E22739124F8FE88840CAFF05 f+jRe7cLSC7bCBEQfHhVxWYZbu5MXsdqQbFRAFhUFNo\n"
  "caches-extra-info\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALkdaGnfYPMk4Gb6tEM0VkAHvf52ETyxn/yz876JzmbBqhMRz7BGMUKX\n"
  "et6pLXZRrL0TbYbDkESCkWvOj9nq6pyxwoYcBTNBo/w3kdDk/RlVlc0egrvXQPgO\n"
  "O0XJ3qjfW88aCyW4pr1XPpiLedj7GAMkHLXKSjHptKvkMH8UBIWrAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANf2NRv0Si2EBM/Bt055XgLdUAHJhAu+kI9/EOfZbHf/hXeV/NAA8QJB\n"
  "TsqoN/v1krBFTUUZmushA7SAYJk69SipJDzYEOg3ZaaPVGanrLh7hiMTemgKh5j1\n"
  "6ABIbUfZz4GufalIUzyVxF7qUNF7xZgKBzmxR7eW3jSabrEFdrPFAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "Q8rGB57opO5DQrRdIO4EoUphDbRNhIIYzs43UeZk+BDxYkMdMSMcmj7JqemH2AC1\n"
  "yjOKbjy14w1cVmGvlXzvOKAA3ylpF7c3UkLhaVurKBmiZKXtZaWLns744QSGUbog\n"
  "erN+WT0syXaXXEZGr6pPDtK9NJld/nMBw8TBGwNL8nc=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAfsAT+llWc6iivnk3cFOx4W/NMRJuNBUmQwTDaM0yaQxANuEvTxfukyO\n"
  "lPKM02Lzm0hIvhFmbEqmekfwrqYG+avRmAeDc8eStlm8CQBw7LRJE++MJgAHWh9r\n"
  "1tB3DcJxiQU=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "contact auth2@test.test\n"
  "ntor-onion-key /vAbEzRKRi0j/0mrhyKBdNMxR56xnzl6fQvtHT/QcAE\n"
  "reject *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 yo7QljYNLR1qIYtRUO4j769qUiDAOk4ueL1XQWFWi+TIenwiBc55fgUFQZAg3wgEwPM37CUdMkAMWKA2CQgSCw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "hYDgjk0GH3xiBOgAccLQntNTYWGmzEvjozZIfqh6IzJtAfZkqpg9O7xaEiMRmkwj\n"
  "+BHuMHiLj9BIHrMAP89pW9SoK+UfQdzKEI6VLFz/Z3c7H9F2OHse5HVc01X0Z6w7\n"
  "eCPEOYUid7JJuVcABnJjs5PDo81LLOzY3089xRepC+c=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:12\n"
  "@source \"127.0.0.1\"\n"
  "router test000a 127.0.0.1 5000 0 7000\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAX4HwKEhOktiFqMiJKxeCjj6o9/7Q/2+ssa3coYnhbYaAQAgBAAaycSq\n"
  "2pbQLnRy2Yn8wiUhsge+cD6Yq3e/Bgq8hgYgJzhFP3znXvYpZJ9dT1J+4G3ykeVE\n"
  "RK0wTU8Utb/+2XfYbXoECmBlb0Hyb87gTsB20O/d1gBssxpIcrjXwyzh/wI=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 GsnEqtqW0C50ctmJ/MIlIbIHvnA+mKt3vwYKvIYGICc\n"
  "or-address [::]:5000\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:12\n"
  "fingerprint F003 9DE0 BFF7 FCB9 F2AB BC3E 6936 9DC6 83B2 D429\n"
  "uptime 324429\n"
  "bandwidth 1073741824 1073741824 780830\n"
  "extra-info-digest 6233C6BC8DAEE31AFBCD71C01C74B3EC7429F77F tEmOGBsYCTolEuqcAL6f4wpaVNn98Y/ONFyZUKxsRUY\n"
  "caches-extra-info\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANLNgThrQ1xGSi/aV/pWQUwOe0uy/ITcU/MSng6orKp0yzzzXc8Ntjfi\n"
  "EFXuD3aEk1lUgwOvRlO2xuiOoHAZNAmim6+h4OfBcFgTeRWbfSMOdaG6Fjvc62C8\n"
  "JJ7kvQIsJoWyCN9QF9366dM8RWLGbzkJ1Ayq6FBcgx59zh6Du2w3AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMR2w3ESy+Nifvpvzx0ZlIaHzVa/prZIonYdGS95ZsCL8ImDUvPFswAq\n"
  "Xf0DLF8bYMfaXQhnNsDsdyH4hlfEVrTua8ww06LPQaEw1qhC9gYfUxoHQ6s4f9yC\n"
  "23KPMsw3MWnwdNspsVDjRgJlCH3JTWStNSB0TgHoRy3LYnKjzvldAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "A3PiP6XlMo9KAO+3Y9+znbqxSujOWNBJlgtQumqbTOCsnUp4tcZiqJx1Tnmd1pN5\n"
  "ZPpiHl9Q4gJ7OcsgyRvNKHE1t0q+CSie5U5n70Zr6ygymcsfLGoV5E/wonmbRRyW\n"
  "roEkTHQGXUtjZ6nWRGd6nhVcLCq/mfv2w7RWvkkEMyA=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OARrJxKraltAudHLZifzCJSGyB75wPpird78GCryGBiAnADqu/a1EDc8r\n"
  "SVN5RI6gC4nZRjPEg2kV4kPDTILGxTEDBfo8zwogr1gKWlclqFD4AVk/4W10hi+V\n"
  "SRNLYyQfzgk=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "contact auth0@test.test\n"
  "ntor-onion-key VLJF0ibPKRzAq/Qc9nCN9Eyv1JBk4EMBN9jQSQtxfGM\n"
  "reject *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 +wqG2xtPPfF3Qg/xEvjxOXLjMr5NCX7muDM+sVUEXiPYpPkxxN39Y6XcSMYJf6KgmO5AmlU+7csL5OdQeENlAQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "q23Fmc55TMJhJW5bFN4BZKt5spInNdBtXIOj78WCpHheEY3LXs0LRiU5pOMQPIhR\n"
  "BZ8lhToo72hZr0BErZqP0AAR+7yrKdvNKFp49opwfBCQAdw+a5UxvmCxyy2zebaW\n"
  "UWHVtAUrohyct9Bd2Ji8mwohjRz/kxLAufUMtJVw1oE=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:14\n"
  "@source \"127.0.0.1\"\n"
  "router test007r 127.0.0.1 5007 0 7007\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAYJYgXIkzMMOaM6v7/IOs5NUaPdVHwPgYWDTZ/3ju2vnAQAgBAAHB+2c\n"
  "K3h4v+X4dzLh1Cl8U1hwUKBSmgE6KSE+oWeM6iZ8lEFJlMPA90v9hc1xnTe9zjjS\n"
  "LkFWFIJcR3W54CJw56uTGcd0AcrCcJKph1tebIv+7y1Kz9i6SsZBpoWxcQI=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 BwftnCt4eL/l+Hcy4dQpfFNYcFCgUpoBOikhPqFnjOo\n"
  "or-address [::]:5007\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:14\n"
  "fingerprint 53F5 0783 5270 D39A 1E47 62C6 8F5E D21F C5F7 F7E9\n"
  "uptime 324431\n"
  "bandwidth 1073741824 1073741824 777802\n"
  "extra-info-digest CC5F5C9F98FEE42D36C186052C88F4AF08ABCE19 q9AA03Hu526wTSvrdqNdWIzjCr+OzUREXfO6HKF6/9s\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKHxn6yov5enz1uNzpMOtk74kEpwLvlcSmEGd0gwi3VPs6V64a9X15Ku\n"
  "OD9TXWY4pcjXTGAUZ0IDEfLziAVpUUByVL7uMXD5Lm/5CoLEGgyBqsvAynK0JymR\n"
  "uLJKkdKosR589jGyQpgb9yEk6n/VtlJUsTutsOgYgO/KFh/dmP/5AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL5sykSg1TVaP0WNbydIhdC2fwBNkIlPv+wR9DbZ7+4b18vGmrQz8sgJ\n"
  "ZpSyRmfe6jkZBOvPDPOLBCtU8+QptmPX6+w2AZhPXr8kpUfYRRrrnaWtMTzYKgmj\n"
  "R/1lC29PWzDAl98TXid08H36jCUZwcbqrOmOBBQi6hzBOPz9syb7AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "CVKyWa+nJnimA22PG9+NMklfgCwWF8EUIhgbLNZAlnC16RHvwQsnAUeEs6frstin\n"
  "UCZ84MXSntqn/Tore0Vs102BrSjv8uIFXaXEH8jRaLcDPeYJKyBXAOINtlVtc3Ze\n"
  "faMUiR7X3cxZsoGJPeAYjLEKghIbEj2sMfWDqfTUeYk=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAQcH7ZwreHi/5fh3MuHUKXxTWHBQoFKaATopIT6hZ4zqACWhqDvK437I\n"
  "OLfulZGKeyPcWCaMHjdYp9HByRW1xZhCV98maaTkpTCy7kGa0oaHGYl1hETMeIXN\n"
  "1I8YTDv4pQM=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "ntor-onion-key vCYC3rCCj+emJh8uNnK3OcX2mRrgPWGgeka617QnGFM\n"
  "accept *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 PnDFvJl9otq2sXsDkm023L9+VAftkADmn8ocYVU8z5UcpwQ/2ZrZOUBthWOgt+j7SuiOb6rDw4KT5zWNwSusDw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "H+/0VaNq9cX7GGj8s1ZWaaoLEuocakqcvZOUB4XoL5qmN3TCPfLMUDGM56EMkrvx\n"
  "bzR6/iUm8RAK5bVoPMynYm3iJW7xwvXg6W4qTSIxaTX9SnZh03+UfnyPE3uykkSa\n"
  "8+JZ6F9kqabWhi4yKsZtHt64A0/F+jyR5CvXl1kdt40=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:14\n"
  "@source \"127.0.0.1\"\n"
  "router test006r 127.0.0.1 5006 0 7006\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAaRBmBZIcRzdZXo2qSBLNy9nZXvSyCmVMTbs+SLH8ozAAQAgBAANeGA+\n"
  "qbvQAb9cMCjnGewaWlVp3xFaV2EWHV/IVnRmJodgXot9/W1v/eyGjzJ5mxTLLzDQ\n"
  "a68Ry1NrLeDBX3ERX9XjiZ8YUrQlqWz8HsSZYdMoH7fDpaBG7SONxuCVqAo=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 DXhgPqm70AG/XDAo5xnsGlpVad8RWldhFh1fyFZ0ZiY\n"
  "or-address [::]:5006\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:14\n"
  "fingerprint A0E2 FA39 D23F BB97 0B56 0C53 3BD8 B16D 0E63 548B\n"
  "uptime 324431\n"
  "bandwidth 1073741824 1073741824 347136\n"
  "extra-info-digest BF56A5D6A1DB3090F4FE6AA37D0C4F97732AE49C B92bY5UKX7LVqvxvI4KZDlST1VQ+gy9IOO4SYIKdMnY\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALyNFEPoUDXHUprDPXMIKWoCeWDo4ztVh6yHJQE8v88tc3WiuBt7ExBP\n"
  "3Hjrh10/julakjsQWqB/8neJc7lJqdnQqFp0G8KhViwRaWgxiMAAfgq9kRB8UDPD\n"
  "GpgVGrvBB4mY9REnLlAeDjPK+rJ2ww5TSDe7GP5SYJh/5jBIAmShAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANnUmF9BJ77e1Vc+sIN+gXO4FGb+NYeEkzg8yTjlUCu/8eQCmNLjwO2A\n"
  "S9cnfeK8vD0l7EgiYQWRUZRR5aK06VLDDbLZ6O5Kbey4gibgRCkXj85SGBsV0upr\n"
  "rmozECBg3RshdvD1nRrubUYIbDQd5rH+XTYn7O42QVRodHuBJP2DAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "MsINH4fEw+GMWeLSxxmHfpSas1KEaX1RD0oo5GdyJjRs5Q2+ieDiW0T0VVN0auAp\n"
  "niJoPf8er4oDjuJPuUTzsfiZUxBjCiMgLigdwI7FLFhbL/7dgZFzF+2a/JoFKbGv\n"
  "2LKrEl0B8DsyG5aoF5T45eY5cx6fFXOkQjvYDEJ8cyM=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAQ14YD6pu9ABv1wwKOcZ7BpaVWnfEVpXYRYdX8hWdGYmANmc1AEsD0I4\n"
  "+PKxTbE3RgpP0aUxiRBaQ3GGIvWyNZsix1bE1As/Y4N1/Vtn57b0eMd2xLokeEvG\n"
  "JTGrTHoELA0=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "ntor-onion-key 2OKE+7fTI/CKOZ4bzzfSuNaSBzsBNlyjg7PJhWaMMmw\n"
  "accept *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 Ez2DIieIvjFe8tZt5P4yOGuNH5Nw2PO6dD0hLylGhnk/elmG4hxf+qBj6LHybos88TP2fAh0mwceomGoUQQZDg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "dxOuYd7waHjZjfWMQwKWhJxrFA/z1dKwkAZSVwglSHCCD8EmAcuerxhTiEzmKJm1\n"
  "areR0g1oNigVyQd8Y5gYam9lgLLM4vEyHVkRhgluzKBcWnwS1PAF4oYOvMxTqBuw\n"
  "5dfhm58uU6h8/jeKL4J4VSNnYDwY6G4+YzOcQkU25sY=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:14\n"
  "@source \"127.0.0.1\"\n"
  "router test004r 127.0.0.1 5004 0 7004\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eATTDPEX+F/fXy60oU+qlU3kFPYm11GLFpGIkXJ3+ULD1AQAgBADBcugt\n"
  "WlMsFJtdBOshhXHYNabLhZgnsHmlCrw6MR/qpwNL7TqsdPpsEvYKAuHSozOaof4V\n"
  "4sy9Zd1NFvwOJLyp1QkErf4TXWDoMQUCir1AcPsj/AGDIGq48DFpZUZyego=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 wXLoLVpTLBSbXQTrIYVx2DWmy4WYJ7B5pQq8OjEf6qc\n"
  "or-address [::]:5004\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:14\n"
  "fingerprint C763 47FA 498E 3929 F2AC 563C B958 1249 137F F656\n"
  "uptime 324431\n"
  "bandwidth 1073741824 1073741824 640261\n"
  "extra-info-digest 93E7E827FA057EEACE951B7D3F26A1E8FCCBC12B sHuKfKSpRmXKocb79/PgbMfM7z6UcGbbgW3aQvQIuRE\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMFoSwvDavnsMuT8v5D9vcWATYziPOe6erYE1cWAKMLL6BIrqUhCKEIi\n"
  "g2hKE7XeGypQURhtV/mkvx43N1NwMTzPlbkEtL1LdDmb1kKKxsQ0kSpX75yc6g8y\n"
  "5aKLVjPBMRDk5+eszo0qHs/lOO+Pn0M5zBurWv6Jk12iN9ETMT6XAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOLXEVTTTkEqg47/I/JqORoqg/2r1bCa4LjPMThE6HoyvNIJRhGIsS18\n"
  "37PZ3YGdkVY6bMdJWed4r4DGoqGu4I5p0hjv7CeONbGjIa19R4shkSKxGw8Prrr7\n"
  "jHHg4eaK2i6p2bRPpn6V5Z/dAmfKz70682uKakZSsCA5hUoBMVr5AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "ZO/f8nN9QYAm0O2SgaH5Zb9T6o5ibiKVC3N8nwzPzEA7xxli/OR81tCobHYoTDQt\n"
  "ZYKZXLvH0LAmjdHVVOGYAyfQKR7Ig2djVQuB4VVf8ix31jpL8guUIG14IKI/XSnz\n"
  "ZgHnGkAkhZC+Q+FHAc341DeSHBy9iZbwooXyuK+rfnM=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAcFy6C1aUywUm10E6yGFcdg1psuFmCeweaUKvDoxH+qnAJDQqV067Kgn\n"
  "q56Hsi6zUgK87nX3ENuQuKtjl86uWq1QmpmMt259vMa/rouA61sglMDGsZ1YVgEC\n"
  "yoUVkFxVkQM=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "ntor-onion-key XBpzf4GSuvJZ/PP0PM4ECNotP/VOtHcFimQ2COb+NGA\n"
  "accept *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 fUGEaiokY5dyMBtQ7x6BWBKwsJC6MQVYfewSMiWagE+T8H2EY2Lww0yowQo0+40FIKSG4g6GNpSMvs1g0cYIAg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "h/nND9oB+dIiHzm93xm2Fi9pemP4B5B5qJkyEJg/CcpitaXvugBIw1EOWMwqrsr2\n"
  "x7ZyDz8gUp7WcXwhqbXlsLgSFT96RC4cBG6Qjvly0t+gvvcxG7RHV2ytJ7VlakyP\n"
  "uENuwPYre230OfOjm5Jg+wFdlF6OMLphj2Yd7o48Xcw=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:27:34\n"
  "@source \"127.0.0.1\"\n"
  "router test005r 127.0.0.1 5005 0 7005\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAfTuBhu6ypB5/9avDiY3qBzulkCvfYqbFN/ABk/o4xFcAQAgBAAnmWRG\n"
  "rIvqpb4Kk3cThEiWAll4uDCO2Y46uNm9WG7AtPt4LG+XfktG3GAxv6aVQimwlyHc\n"
  "1x2Lfm9KG3mWWj+hxnum4Z7873OE0B9l2Hg0YQZCW/PuHSWN0rspTvY5SgA=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 J5lkRqyL6qW+CpN3E4RIlgJZeLgwjtmOOrjZvVhuwLQ\n"
  "or-address [::]:5005\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:27:34\n"
  "fingerprint D219 590A C951 3BCD EBBA 9AB7 2100 7A4C C01B BAE3\n"
  "uptime 324451\n"
  "bandwidth 1073741824 1073741824 637796\n"
  "extra-info-digest 78E6D382BC826B95B4111554EEE7D541A32AAAA3 c61Onjpq+1S0TrdvoaOvGAxew6yfO+uHNhipbemQmgA\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMvEJ/JVNK7I38PPWhQMuCgkET/ki4WIas4tj5Kmqfb9kHqxMR+EunRD\n"
  "83k4pel1yB7QdV+iTd/4SZOI8RpZP+BO1KnOTWfpztAU1lDGr19/PwdwcHaILpBD\n"
  "nNzm6otk4/bKUQ0vqpOfJljtg0DfAm4uMAQ6BMFy6uEAF7+JupuPAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANBzejGAwyPTPq2Gm03wpg3qICo0uDQau8opude2mW3eyxAqOqHzC8De\n"
  "gRgbmn040vqe9gwvH4iaHpVeTxyDwQefbfULdq6bETmX3aSUj6LKBCqqcyuOJFQu\n"
  "7M2QfNSfHtldUABpIaqFvEA3AV8qjOoUtauoFNJKMy7Wj2//S70VAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "pD3Nkkunt8zP6PO6H3uHT0t7xnorC7cY/KfF75mFB+90pHCD9f0Xdu3Pjrur/q23\n"
  "PIKV3hdtdsODoJuoh8LPGNAjS5rO6HMCtHNDNunNOs69bvfaO0jThnurXmOpY0sW\n"
  "eRfBeYN2KNgrN0B1eDejfPSr03dkFY48yoUDROv9EJQ=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OASeZZEasi+qlvgqTdxOESJYCWXi4MI7Zjjq42b1YbsC0AKc5y5qYUYvw\n"
  "VATtWkV9DVIZbZSb9mQP5pmNaqmX+DbmINCYt8j7l+U7g3ftUyh0Wlrgevx0pFUI\n"
  "RcIU0HKHZQA=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "ntor-onion-key FChIfm77vrWB7JsxQ+jMbN6VSSp1P0DYbw/2aqey4iA\n"
  "accept *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 Xm56dYbo/hCHWyzcdUPmfTeZ4qly2TYf1/2Q1lXKQDMJyBti8ZE8R2TTYsYimr+UtAapbzBItccZLze505nhBw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "bbeN0lq6nCfJQXGcKa1M9TQ6b2upig7clrlVXuzKeR0JhGwnDCXUAFxDtrw3vkVo\n"
  "ExBXXvJeBPyustFOQkdiAEWHHSW5CwEgeVCBYZeEnaiySIgDVKuu+9B53ezFdC0Y\n"
  "iFJkKxxDx7ksxX0zdl7aPT4ORFEuRhCYS6el7YJmoyg=\n"
  "-----END SIGNATURE-----\n"
  "@uploaded-at 2020-10-13 13:28:13\n"
  "@source \"127.0.0.1\"\n"
  "router test003r 127.0.0.1 5003 0 7003\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABs1eAUC9IBXmVO3yeYhG6VI5o6+uyPI8tNFBR38n8RDxW91MAQAgBAD6reoi\n"
  "ucfyRvLfC++3TyajT1IHbggd8/D5Gp9DlzbDf4vRNbII2iCDxilKG60yNurDcDWA\n"
  "W9H2JRwrZpiQgQvEzGQJRISaGHQIVlEKpER7RvjDZvQG9KtHyDdH0txcdgo=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 +q3qIrnH8kby3wvvt08mo09SB24IHfPw+RqfQ5c2w38\n"
  "or-address [::]:5003\n"
  "platform Tor 0.4.5.0-alpha-dev on Linux\n"
  "proto Cons=1-2 Desc=1-2 DirCache=1-2 FlowCtrl=1 HSDir=1-2 HSIntro=3-5 HSRend=1-2 Link=1-5 LinkAuth=1,3 Microdesc=1-2 Padding=2 Relay=1-3\n"
  "published 2020-10-13 13:28:13\n"
  "fingerprint 09C5 1D0C D3F4 F3D5 8C73 D219 9BF3 F0FC 55F5 2965\n"
  "uptime 324490\n"
  "bandwidth 1073741824 1073741824 640359\n"
  "extra-info-digest 64AD921120758875124DEBC83808AE282BEA76F6 6xEyhjSnACEk+bScEqhoTI43p4+bcnFh8E+9fvBdeow\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANQMTqT/mcGSnwA7MsqKrtmK0re+XsJesFNeRwozZLKLgsB0ARoHvlAp\n"
  "iBb/9kU++GhRBUs3EsMaU7rHN+yahDzwrVlWgRm3YV17aj1guQnHm8RaTbDtKCii\n"
  "G0aBo2quU1LqXot/XVOE2BCFO0DO+4tZE5mCChpnALy0AYs2Dj4HAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAJ2yCCvgp0/HYyvW+DIX+nMEZ8Q1Sjzke9oEVcx1UQKFDmCCRJA4cJA5\n"
  "xx5hVedkIXug7DJ/2xkMR+QT+Cwqxij1K0jlJlOmnixsT/TnwyyhP6eIxNef0HuG\n"
  "MAgptAEMltR9OqDEESvfGv0cz+U4fru6xHpfH9c/P4S3aeihUbSnAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "UaR88eoWRuFJjYqns3RP92bgZv5AKYjxNrcm0SpZIOgDeayq/1mDA/jdVbDPa4de\n"
  "KRJ9ezXCo+2O2zl6rhvsRsMgVwrZEr5Hz4+Zf1H6hpvk8NoOEBCb5g3jef6nMmGr\n"
  "1p+NV/OULow266pKnWidPQCWLjc+ladBLQU8EJxT65Q=\n"
  "-----END CROSSCERT-----\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABs2OAfqt6iK5x/JG8t8L77dPJqNPUgduCB3z8Pkan0OXNsN/AGVx0xPqhPuo\n"
  "n9nnmtt+48y9Wkcdo43Si3Nrl96TxAiOMB0NKoTIk7++puAreR364CBPM8LM0TrT\n"
  "AxIjl/GuMQE=\n"
  "-----END ED25519 CERT-----\n"
  "hidden-service-dir\n"
  "ntor-onion-key bLeD2EdnozYyTnxk9PeRykzjPEw65lVLmlBhWk5+ATI\n"
  "accept *:*\n"
  "tunnelled-dir-server\n"
  "router-sig-ed25519 wGsA4xlKdM0rzborPOil8cvAzUS2ImXvsm9PgTQDiosGf8ve3ucdDUjKLNOTd6iFVDIl4ESG2Y3eOsqAgQddBA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "k8ndhNl9lCng7IfgeoYGWKnvmxgfo41M9Sq3754HUAVRJcVZ1RJm4OGI/Z/fw38I\n"
  "ievnndu81y/L2cuHnSr+MTXY7B2pLXueOo8YpKlx799Wugn5dnfOhz9WHkFNhWQL\n"
  "8iOty3iG3VIJVi0pU3qgj5Xc1zKVa3pZ/QQfs4k/g44=\n"
  "-----END SIGNATURE-----\n";
