---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices
---

# Comment changer la police de tout un paragraphe ?

Pour changer la fonte de tout un paragraphe, plusieurs commandes sont disponibles :
`\rmfamily`, `\sffamily`, `\ttfamily`, `\bfseries`, `\mdseries`, `\itshape`, 
`\slshape`, `\upshape` et `\scshape`. Ces commandes étant des "bascules" modifiant
le comportement dans toute la suite du groupe où elles sont 
(par exemple écrire en italique avec `\itshape` à partir de l'endroit où cette 
commande est placée), il faut les placer avec le texte qu'elles modifient 
dans des accolades pour délimiter leur effet (les accolades servant à créer le groupe).

Si vous souhaitez utiliser ces commandes sur un seul mot ou sur un groupe de mots 
dans un paragraphe, alors l'espace suivant une telle déclaration ne sera pas géré. 
Il vaut mieux dans ce cas utiliser les commandes `\text`xx`{}`, évoquées à la question
"[](changer_la_forme_d_une_fonte)"

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
{\scshape Voici un exemple}
et
\begin{itshape}
encore un autre exemple.
\end{itshape}
\end{document}
```

:::{todo} Améliorer l'exemple
:::