".ds n) tardy",
".TH Tardy 1",
".SH NAME",
"tardy \\- a tar post-processor",
".XX \"tardy(1)\" \"a tar(1) post-processor\"",
".SH SYNOPSIS",
".B \\*(n)",
"[",
".IR option \\&...",
"][",
".IR infile",
"[",
".IR outfile",
"]]",
".br",
".B \\*(n)",
".B \\-Help",
".br",
".B \\*(n)",
".B \\-VERSion",
".SH DESCRIPTION",
"The \\fI\\*(n)\\fP program is used to manipulate the file headers within",
"archive files.  Supported archive formats include \\f[I]tar\\fP(1),",
"\\f[I]cpio\\fP(1) and \\f[I]ar\\fP(1).",
".PP",
"This is useful when preparing sources for Internet archive sites,",
"and you don't want to included details of your development environment",
"in the \\f[I]tar\\fP(1) file.",
".PP",
"One of the most useful features is the ability to add a prefix to the",
"names of the files within the \\f[I]tar\\fP(1) file.  An example is adding",
"the prefix \\[lq].\\[rq], for when you have a \\f[I]tar\\fP(1) file with absolute",
"paths in it, and need to extract the file with relative paths.",
".PP",
"The GNU tar format headers are understood,",
"including extended names.",
".PP",
"If no input file is named,",
"or the special name \\[lq]\\-\\[rq] is used,",
"input will be read from the standard input.",
"Similarly,",
"if no output file is named,",
"or the special name \\[lq]-\\[rq] is used,",
"output will be written to the standard output.",
"Note that \\fI\\*(n)\\fP will refuse to read from or write to a terminal,",
"as this indicates that the user has made a mistake.",
".PP",
"If the input is in \\f[I]gzip\\fP(1) format, it will be automatically",
"\\f[I]gunzip\\fP(1)ed before processing.  Similarly, if the output file",
"name indicates that \\f[I]gzip\\fP(1) should be used, this will be done",
"automatically on output.",
".SH OPTIONS",
"The following options are understood:",
".TP 8n",
"\\fB\\-Block_Size\\fP \\f[I]number\\fP",
"This option many be used to specify the block size, as a multiple of",
"512 bytes.  The default is \\f[CW]\\-bs=20\\fP resulting in a 10kB block size.",
".TP 8n",
".B \\-Clean_Meta",
".br",
"This option may be used to",
"ensure that file names do not contain shell meta characters.",
"If any are found, they are replaced by a hyphen (\\-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B -Clean_Print",
".br",
"This option may be used to",
"ensure that file names only contain printable ASCII characters.",
"If any non-printable characters are found,",
"they are replaced by a hyphen (\\-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B \\-Clean_Space",
".br",
"This option may be used to",
"ensure that file names contain no white space characters.",
"If any are found, they are replaced by a hyphen (\\-) character.",
"Warning: duplicate file names may result.",
".TP 8n",
".B \\-Clean",
".br",
"This option is a terse way of specifying all of the above 3 options.",
".TP 8n",
".B \\-DownCase",
".br",
"This option may be used to",
"force file names to be all lower case.",
"Warning: duplicate file names may result.",
".TP 8n",
"\\fB\\-EXclude\\fP \\f[I]pattern\\fP",
"This option may be used to completely remove files from the archive.",
"All files that have a filename patching the given shell filename pattern",
"will be removed.",
"Be careful with wild cards, they match everything, including slash (/)",
"characters.",
"The exclude pattern is applied before all file-name manipulating patterns.",
".TP 8n",
"\\fB\\-eXtract\\fP",
"This option may be used to extract the contents of an archive.",
".TP 8n",
"\\fB\\-Group\\fP \\f[I]arg\\fP",
".br",
"This option may be used to set both",
"the group name and group number fields",
"in the header of every file in the archive file.",
"The argument may be either a string or a number.",
"It is an error if a corresponding entry cannot be found in the",
".I /etc/group",
"file.",
".TP 8n",
"\\fB-Group_NAme\\fP \\f[I]string\\fP",
".br",
"This option is used to",
"set the group name field in the header",
"of every file in the archive file.",
"The string may be any arbitrary string,",
"it is not restricted to a known group.",
".TP 8n",
"\\fB\\-Group_NAme\\fP \\f[I]number\\fP",
".br",
"This option is used to",
"set the group name field in the header",
"of every file in the archive file.",
"The number is mapped to a group name through the",
".I /etc/group",
"file.",
"It is an error if a corresponding group cannot be found.",
".TP 8n",
"\\fB\\-Group_NUmber\\fP \\f[I]string\\fP",
".br",
"This option is used to",
"set the group number field in the header",
"of every file in the archive file.",
"The string is mapped to a group number through the",
".I /etc/group",
"file.",
"It is an error if a corresponding group cannot be found.",
".TP 8n",
"\\fB\\-Group_NUmber\\fP \\f[I]number\\fP",
".br",
"This option is used to",
"set the group number field in the header",
"of every file in the archive file.",
"The number may be any arbitrary number,",
"it is not restricted to a known group.",
".so man/man1/o_help.so",
".TP 8n",
"\\fB\\-Input_ForMaT\\fP \\f[I]name\\fP",
".RS",
"By default, the input file is examined to automatically detect the input",
"archive file's format.",
"This option may be used to specify the input format to be used.",
"The input format \\f[I]name\\fPs are",
".TP 8n",
"tar",
"This format understands all of the various \\f[I]tar\\fP(1) formats.",
"This is the default.",
".TP 8n",
"tar\\[hy]bsd",
"This format expects BSD \\f[I]tar\\fP(1) archives.",
".TP 8n",
"ustar",
"This format expects \\f[I]ustar\\fP(1) format archives.",
".TP 8n",
"list",
"The input is a text file which contains one file name per line.",
"The named files are read as if they were the input.",
"It is common for \\f[I]find\\fP(1) to be used to form the list of file names.",
".TP 8n",
"directory",
"The input is a text file which contains one file name per line.",
"The named files are read as if they were an archive input.",
"If any directories are found, they will be descended recursively.",
".TP 8n",
"cpio",
"The file is expected to be in one of the \\f[I]cpio\\fP(5) formats,",
"and will be examined to figure out which.",
".TP 8n",
"cpio\\[hy]bin",
"This format expects \\f[I]cpio\\fP(5) \\[lq]old binary\\[rq] format archives.",
".TP 8n",
"cpio\\[hy]crc",
"This format expects \\f[I]cpio\\fP(5) \\[lq]crc\\[rq] format archives.",
".TP 8n",
"cpio\\[hy]new\\[hy]ascii",
"This format expects \\f[I]cpio\\fP(5) \\[lq]new ascii\\[rq] format archives.",
".TP 8n",
"cpio\\[hy]old\\[hy]ascii",
"This format expects \\f[I]cpio\\fP(5) \\[lq]old ascii\\[rq] format archives.",
".TP 8n",
"ar",
"The file is expected to be in one of the \\f[I]ar\\fP(1) formats,",
"and will be examined to figure out which.",
".TP 8n",
"ar\\[hy]bsd",
"This format expects \\f[I]ar\\fP(1) \\[lq]BSD\\[rq] format archives.",
".TP 8n",
"ar\\[hy]pdp11",
"This format expects \\f[I]ar\\fP(1) archives, in the ancient pre\\[hy]V7 format.",
".TP 8n",
"ar\\[hy]v7",
"This format expects \\f[I]ar\\fP(1) \\[lq]Unix Version 7\\[rq] format archives.",
".PP",
"Any other format name will produce an error.",
".RE",
".TP 8n",
".B \\-List",
".br",
"Give a terse listing of the file headers on the standard error",
"as they are written to the output.",
".TP 8n",
"\\fB\\-Mode_Clear\\fP \\f[I]bits\\fP",
".br",
"This option may be used to",
"set the mode of each file in the archive file.",
"The",
".I bits",
"specified are cleared in the mode.",
"You should use an octal number with a leading zero as the argument;",
"if you omit the leading zero it will be interpreted as decimal.",
"The",
".B \\-Mode_Set",
"option is applied first,",
"the",
".B \\-Mode_Clear",
"option is applied second;",
"if neither is specified the mode of each file is unaltered.",
".TP 8n",
"\\fB\\-Mode_Set\\fP \\f[I]bits\\fP",
".br",
"This option may be used to set the",
"mode of each file in the archive file.",
"The",
".I bits",
"specified are set in the mode.",
"You should use an octal number with a leading zero as the argument;",
"if you omit the leading zero it will be interpreted as decimal.",
".TP 8n",
".B \\-No_Directories",
".br",
"This option may be used to suppress directories",
"from the output.",
"This can be useful when the archive has been created with",
"directories in useless modes.",
".TP 8n",
".B \\-Now",
".br",
"Set the last\\[hy]time\\[hy]modified field of the headers to the current time,",
"all files will be given the same time.",
".TP 8n",
".B \\-Old_Type",
".br",
"By default,",
"\\*(n) corrects the old normal file",
"type into the modern normal file type.",
"This option requests that old normal file",
"type indicators remain unaltered.",
".TP 8n",
"\\fB\\-Output_ForMaT\\fP \\f[I]name\\fP",
".RS",
"By default, \\f[I]\\*(n)\\fP tries to write the same format on output as",
"it sees on input.",
"This option may be used to specify the output format to be used.",
"The output format \\f[I]name\\fPs are",
".TP 8n",
"ar",
"The archive will be written using the \\f[I]ar\\fP(1) format, BSD variant.",
"Note that this format only supports simple files; it silently discards",
"directories, and even discards directory portions of file names.",
".TP 8n",
"ar\\[hy]bsd",
"The archive will be written using the \\f[I]ar\\fP(1) format, BSD variant.",
"Long file names are handled by a special file at the start of the",
"archive full of file names.",
".TP 8n",
"ar\\[hy]bsd\\[hy]l2",
"The archive will be written using the \\f[I]ar\\fP(1) format, BSD variant.",
"Long file names are handled by special file name mangling in the",
"archive, with the actual file name transparently injected into the start",
"of the file data.",
".TP 8n",
"ar\\[hy]pdp11",
"The archive will be written using the \\f[I]ar\\fP(1) format, in the most",
"ancient pre\\[hy]V7 variant.  (There are also \\f[I]ar\\[hy]pdp11\\[hy]le\\fP",
"and \\f[I]ar\\[hy]pdp11\\[hy]le\\fP names, if you need to select the byte order.)",
".TP 8n",
"ar\\[hy]port5",
"The archive will be written using the \\f[I]ar\\fP(1) format, in the",
"PORT5 variant.  (There are also \\f[I]ar\\[hy]port5\\[hy]le\\fP and",
"\\f[I]ar\\[hy]port5\\[hy]le\\fP names, if you need to select the byte order.)",
".TP 8n",
"ar\\[hy]v7",
"The archive will be written using the \\f[I]ar\\fP(1) format, ancient",
"Unix Version 7 variant.  (There are also \\f[I]ar\\[hy]v7\\[hy]le\\fP and",
".TP 8n",
"posix",
"The format that GNU tar uses.",
".TP 8n",
"tar\\[hy]bsd",
"The format that BSD \\f[I]tar\\fP(1) uses.",
".TP 8n",
"cpio",
"The new \\f[I]cpio\\fP(5) ASCII format.",
".TP 8n",
"cpio\\[hy]bin",
"The \\f[I]cpio\\fP(5) \"old binary\" format, using host byte order.",
".TP 8n",
"cpio\\[hy]bin\\[hy]le",
"The \\f[I]cpio\\fP(5) \"old binary\" format, using littl\\[hy]-endian byte order.",
".TP 8n",
"cpio\\[hy]bin\\[hy]be",
"The \\f[I]cpio\\fP(5) \"old binary\" format, using big\\[hy]endian byte order.",
".TP 8n",
"cpio\\[hy]crc",
"The \\f[I]cpio\\fP(5) \"crc ascii\" format.",
".TP 8n",
"cpio\\[hy]old\\[hy]ascii",
"The old \\f[I]cpio\\fP(5) ASCII format.",
".TP 8n",
"ustar",
"This is the format that Joerg Schilling's \\f[I]ustar\\fP(1) uses.",
".TP 8n",
"v7",
"The ancient UNIX V7 \\f[I]tar\\fP(1) format.",
".PP",
"Any other format name will produce an error.",
".RE",
".TP 8n",
"\\fB\\-Prefix\\fP \\f[I]string\\fP",
".br",
"This option is used to add a prefix directory name to the",
"name of every file in the archive file.",
".TP 8n",
"\\fB\\-PROgress\\fP",
"This option is used to obtain a progress indicator.",
"Only works in combination with the \\f[I]\\-ifmt=list\\fP option.",
".TP 8n",
"\\fB\\-Remove_Prefix\\fP \\f[I]number\\fP",
".br",
"This option is used to remove a number of leading directories from",
"the name of every file in the archive file,",
"if present.",
"The prefixes will be removed before any prefix specified by the",
".B \\-Prefix",
"option is prepended.",
".TP 8n",
"\\fB\\-Remove_Prefix\\fP \\f[I]string\\fP",
".RS",
"This option is used to remove a prefix directory name from",
"the name of every file in the archive file,",
"if present.",
"This option may be given more than once,",
"and as many of the prefixes as appear will be removed.",
"The prefixes will be removed before any prefix specified by the",
".B \\-Prefix",
"option is prepended.",
".PP",
"This option is potentially ambiguous with the preceding option, if you",
"wish to remove a leading prefix which looks like a number.  If this is",
"the case, add a slash (\"/\") to the end of the prefix to stop it looking",
"like a number.",
".RE",
".TP 8n",
".B \\-UpCase",
".br",
"This option may be used to",
"force file names to be all upper case.",
"Warning: duplicate file names may result.",
".TP 8n",
"\\fB\\-User\\fP \\f[I]arg\\fP",
".br",
"This option may be used to set both",
"the user name and user number fields",
"in the header of every file in the archive file.",
"The argument may be either a string or a number.",
"It is an error if a corresponding entry cannot be found in the",
".I /etc/passwd",
"file.",
".TP 8n",
"\\fB\\-User_NAme\\fP \\f[I]string\\fP",
".br",
"This option is used to",
"set the user name field in the header of every file in the archive file.",
"The string may be any arbitrary string,",
"it is not restricted to a known user.",
".TP 8n",
"\\fB\\-User_NAme\\fP \\f[I]number\\fP",
".br",
"This option is used to",
"set the user name field in the header of every file in the archive file.",
"The number is mapped to a user name through the",
".I /etc/passwd",
"file.",
"It is an error if a corresponding user cannot be found.",
".TP 8n",
"\\fB\\-User_NUmber\\fP \\f[I]string\\fP",
".br",
"This option is used to",
"set the user number field in the header of",
"every file in the archive file.",
"The string is mapped to a user number through the",
".I /etc/passwd",
"file.",
"It is an error if a corresponding user cannot be found.",
".TP 8n",
"\\fB\\-User_NUmber\\fP \\f[I]number\\fP",
".br",
"This option is used to",
"set the user number field in the header",
"of every file in the archive file.",
"The number may be any arbitrary number,",
"it is not restricted to a known user.",
".TP 8n",
".B \\-VERSion",
".br",
"Print the version of the",
".I \\*(n)",
"program being executed.",
".so man/man1/o__rules.so",
".so man/man1/z_exit.so",
".SH SEE ALSO",
".TP 8n",
"\\f[I]ar\\fP(1)",
"Create, modify, and extract from archives",
".TP 8n",
"\\f[I]ar\\fP(5)",
"Format of \\f[I]ar\\fP(1) archive files (not all systems have this man page).",
".TP 8n",
"\\f[I]cpio\\fP(1)",
"Copy files to and from archives",
".TP 8n",
"\\f[I]cpio\\fP(5)",
"Format of \\f[I]cpio\\fP(1) archive files",
".TP 8n",
"\\f[I]find\\fP(1)",
"Search for files in a directory hierarchy",
".TP 8n",
"\\f[I]tar\\fP(1)",
"Store and extract files from a tape or disk archive",
".TP 8n",
"\\f[I]tar\\fP(5)",
"Format of \\f[I]tar\\fP(1) archive files",
".so man/man1/z_cr.so",
