use core:net;
use core:io;
use http;
use core:lang;
use lang:bs:macro;

private Str baseSite() {
	str {
		<!DOCTYPE html>
		<html>
		<body>
			<h1>Hello</h1>
			<p>Example page</p>
		</body>
		</html>
	};
}

private Str picturesSite() {
	str {
		<!DOCTYPE html>
		<html>
		<body>
			<h1>Pictures</h1>
			<p>Pictures page</p>
		</body>
		</html>
	};
}

/**
 * Example usage of the webserver API.
 */
void server() {
	named{http}.compile;

	RoutingServer server;

	spawn (() => { sleep(20 s); server.close; }).call();

	// Add a handler.
	server.route(["pictures", "*"], (request) => Response(picturesSite));
	server.default((request) => Response(baseSite));

	server.run(1234);
}
