/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_50 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 25832, "epsg", 25832,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"25832\"]]");
    p = add_epsg_def_ex (filter, first, last, 25833, "epsg", 25833,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25833\"]]");
    p = add_epsg_def_ex (filter, first, last, 25834, "epsg", 25834,
        "ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",21],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25834\"]]");
    p = add_epsg_def_ex (filter, first, last, 25835, "epsg", 25835,
        "ETRS89 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",27],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25835\"]]");
    p = add_epsg_def_ex (filter, first, last, 25836, "epsg", 25836,
        "ETRS89 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",33],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25836\"]]");
    p = add_epsg_def_ex (filter, first, last, 25837, "epsg", 25837,
        "ETRS89 / UTM zone 37N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 37N\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",39],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25837\"]]");
    p = add_epsg_def_ex (filter, first, last, 25838, "epsg", 25838,
        "ETRS89 / UTM zone 38N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 38N (deprecated)\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "TRS89\",DATUM[\"European_Terrestrial_Reference_System_19");
    add_srs_wkt (p, 2,
        "89\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",45],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"25838\"]]");
    p = add_epsg_def_ex (filter, first, last, 25884, "epsg", 25884,
        "ETRS89 / TM Baltic93", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM Baltic93\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",24],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"25884\"]]");
    p = add_epsg_def_ex (filter, first, last, 25932, "epsg", 25932,
        "Malongo 1987 / UTM zone 32S", 0, 0,
        "International 1924", "Greenwich",
        "Malongo_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-254.1,-5");
    add_proj4text (p, 1,
        ".36,-100.29,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Malongo 1987 / UTM zone 32S\",GEOGCS[\"Malongo ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Malongo_1987\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6259\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4259\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2593");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 26191, "epsg", 26191,
        "Merchich / Nord Maroc", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +");
    add_proj4text (p, 2,
        "towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Nord Maroc\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",33.3],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-5.4],PARAMETER[\"scale_factor\",0.999625769],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"26191\"]]");
    p = add_epsg_def_ex (filter, first, last, 26192, "epsg", 26192,
        "Merchich / Sud Maroc", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.7 +lat_0=29.7 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6155960000001 +x_0=500000 +y_0=300000 +a=6378249.2 +b=63");
    add_proj4text (p, 2,
        "56515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sud Maroc\",GEOGCS[\"Merchich\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,");
    add_srs_wkt (p, 2,
        "293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",29.7],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-5.4],PARAMETER[\"scale_factor\",0.999615596],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"26192\"]]");
    p = add_epsg_def_ex (filter, first, last, 26193, "epsg", 26193,
        "Merchich / Sahara Nord", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "6 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Nord\",GEOGCS[\"Merchich\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",26.1],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-5.4],PARAMETER[\"scale_factor\",0.999616304],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",1200000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26194\"]]");
    p = add_epsg_def_ex (filter, first, last, 26194, "epsg", 26194,
        "Merchich / Sahara Nord", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616304 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Nord\",GEOGCS[\"Merchich\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",26.1],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-5.4],PARAMETER[\"scale_factor\",0.999616304],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",1200000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"26194\"]]");
    p = add_epsg_def_ex (filter, first, last, 26195, "epsg", 26195,
        "Merchich / Sahara Sud", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.5 +lat_0=22.5 +lon_0=-5.4 +k_0=0.999");
    add_proj4text (p, 1,
        "616437 +x_0=1500000 +y_0=400000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=31,146,47,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Merchich / Sahara Sud\",GEOGCS[\"Merchich\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Merchich\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6261\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4261\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",22.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-5.4],PARAMETER[\"scale_factor\",0.999616437],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",1500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"26195\"]]");
    p = add_epsg_def_ex (filter, first, last, 26237, "epsg", 26237,
        "Massawa / UTM zone 37N", 0, 0,
        "Bessel 1841", "Greenwich",
        "Massawa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=bessel +towgs84=639,405,60,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Massawa / UTM zone 37N\",GEOGCS[\"Massawa\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Massawa\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6262\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4262\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26237\"]]");
    p = add_epsg_def_ex (filter, first, last, 26331, "epsg", 26331,
        "Minna / UTM zone 31N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 31N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "63\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",3],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 8,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26331\"]]");
    p = add_epsg_def_ex (filter, first, last, 26332, "epsg", 26332,
        "Minna / UTM zone 32N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=clrk80 +towgs84=-92,-93,122,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / UTM zone 32N\",GEOGCS[\"Minna\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "63\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 8,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26332\"]]");
    p = add_epsg_def_ex (filter, first, last, 26391, "epsg", 26391,
        "Minna / Nigeria West Belt", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=4.5 +k=0.99975 +x_0=230738.2");
    add_proj4text (p, 1,
        "6 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria West Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6263\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",4],PARAMETER[\"central_meridian\",4.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.99975],PARAMETER[\"false_easting\",2307");
    add_srs_wkt (p, 9,
        "38.26],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26391\"]]");
    p = add_epsg_def_ex (filter, first, last, 26392, "epsg", 26392,
        "Minna / Nigeria Mid Belt", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=8.5 +k=0.99975 +x_0=670553.9");
    add_proj4text (p, 1,
        "8 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria Mid Belt\",GEOGCS[\"Minna\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6263\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",4],PARAMETER[\"central_meridian\",8.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.99975],PARAMETER[\"false_easting\",6705");
    add_srs_wkt (p, 9,
        "53.98],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26392\"]]");
    p = add_epsg_def_ex (filter, first, last, 26393, "epsg", 26393,
        "Minna / Nigeria East Belt", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=12.5 +k=0.99975 +x_0=1110369");
    add_proj4text (p, 1,
        ".7 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Minna / Nigeria East Belt\",GEOGCS[\"Minna\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Minna\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145");
    add_srs_wkt (p, 2,
        ",293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6263\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4263\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",4],PARAMETER[\"central_meridian\",12.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.99975],PARAMETER[\"false_easting\",1110");
    add_srs_wkt (p, 9,
        "369.7],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26393\"]]");
    p = add_epsg_def_ex (filter, first, last, 26432, "epsg", 26432,
        "Mhast / UTM zone 32S (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "Mhast", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=intl +towgs84=-252.95,-");
    add_proj4text (p, 1,
        "4.11,-96.38,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mhast / UTM zone 32S (deprecated)\",GEOGCS[\"Mh");
    add_srs_wkt (p, 1,
        "ast (deprecated)\",DATUM[\"Mhast\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6264\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "64\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26432\"]]");
    p = add_epsg_def_ex (filter, first, last, 26591, "epsg", 26591,
        "Monte Mario / Italy zone 1", 0, 0,
        "International 1924", "Greenwich",
        "Monte_Mario", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-3.45233333333333 +k=0.9996 ");
    add_proj4text (p, 1,
        "+x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9");
    add_proj4text (p, 2,
        ".9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario / Italy zone 1\",GEOGCS[\"Monte Mar");
    add_srs_wkt (p, 1,
        "io\",DATUM[\"Monte_Mario\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4265\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",9],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3003\"]]");
    p = add_epsg_def_ex (filter, first, last, 26592, "epsg", 26592,
        "Monte Mario / Italy zone 2", 0, 0,
        "International 1924", "Greenwich",
        "Monte_Mario", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=2.54766666666666 +k=0.9996 +");
    add_proj4text (p, 1,
        "x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.");
    add_proj4text (p, 2,
        "9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Monte Mario / Italy zone 2\",GEOGCS[\"Monte Mar");
    add_srs_wkt (p, 1,
        "io\",DATUM[\"Monte_Mario\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6265\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4265\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "2520000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3004\"]]");
    p = add_epsg_def_ex (filter, first, last, 26632, "epsg", 26632,
        "M'poraloko / UTM zone 32N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "M_poraloko", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-74,");
    add_proj4text (p, 1,
        "-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32N\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6266\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4266\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"266");
    add_srs_wkt (p, 12,
        "32\"]]");
    p = add_epsg_def_ex (filter, first, last, 26692, "epsg", 26692,
        "M'poraloko / UTM zone 32S", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "M_poraloko", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-74,-130,42,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"M'poraloko / UTM zone 32S\",GEOGCS[\"M'poraloko");
    add_srs_wkt (p, 1,
        "\",DATUM[\"M_poraloko\",SPHEROID[\"Clarke 1880 (IGN)\",6");
    add_srs_wkt (p, 2,
        "378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6266\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4266\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"26692\"]]");
    p = add_epsg_def_ex (filter, first, last, 26701, "epsg", 26701,
        "NAD27 / UTM zone 1N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 1N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26701\"]]");
    p = add_epsg_def_ex (filter, first, last, 26702, "epsg", 26702,
        "NAD27 / UTM zone 2N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 2N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26702\"]]");
    p = add_epsg_def_ex (filter, first, last, 26703, "epsg", 26703,
        "NAD27 / UTM zone 3N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 3N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26703\"]]");
    p = add_epsg_def_ex (filter, first, last, 26704, "epsg", 26704,
        "NAD27 / UTM zone 4N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 4N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26704\"]]");
    p = add_epsg_def_ex (filter, first, last, 26705, "epsg", 26705,
        "NAD27 / UTM zone 5N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 5N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26705\"]]");
    p = add_epsg_def_ex (filter, first, last, 26706, "epsg", 26706,
        "NAD27 / UTM zone 6N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 6N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26706\"]]");
    p = add_epsg_def_ex (filter, first, last, 26707, "epsg", 26707,
        "NAD27 / UTM zone 7N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 7N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26707\"]]");
    p = add_epsg_def_ex (filter, first, last, 26708, "epsg", 26708,
        "NAD27 / UTM zone 8N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 8N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26708\"]]");
    p = add_epsg_def_ex (filter, first, last, 26709, "epsg", 26709,
        "NAD27 / UTM zone 9N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 9N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26709\"]]");
    p = add_epsg_def_ex (filter, first, last, 26710, "epsg", 26710,
        "NAD27 / UTM zone 10N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 10N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26710\"]]");
    p = add_epsg_def_ex (filter, first, last, 26711, "epsg", 26711,
        "NAD27 / UTM zone 11N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 11N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26711\"]]");
    p = add_epsg_def_ex (filter, first, last, 26712, "epsg", 26712,
        "NAD27 / UTM zone 12N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 12N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26712\"]]");
    p = add_epsg_def_ex (filter, first, last, 26713, "epsg", 26713,
        "NAD27 / UTM zone 13N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 13N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "26713\"]]");
    p = add_epsg_def_ex (filter, first, last, 26714, "epsg", 26714,
        "NAD27 / UTM zone 14N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 14N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6714\"]]");
    p = add_epsg_def_ex (filter, first, last, 26715, "epsg", 26715,
        "NAD27 / UTM zone 15N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 15N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6715\"]]");
    p = add_epsg_def_ex (filter, first, last, 26716, "epsg", 26716,
        "NAD27 / UTM zone 16N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 16N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6716\"]]");
    p = add_epsg_def_ex (filter, first, last, 26717, "epsg", 26717,
        "NAD27 / UTM zone 17N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 17N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6717\"]]");
    p = add_epsg_def_ex (filter, first, last, 26718, "epsg", 26718,
        "NAD27 / UTM zone 18N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 18N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6718\"]]");
    p = add_epsg_def_ex (filter, first, last, 26719, "epsg", 26719,
        "NAD27 / UTM zone 19N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 19N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6719\"]]");
    p = add_epsg_def_ex (filter, first, last, 26720, "epsg", 26720,
        "NAD27 / UTM zone 20N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 20N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6720\"]]");
    p = add_epsg_def_ex (filter, first, last, 26721, "epsg", 26721,
        "NAD27 / UTM zone 21N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 21N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6721\"]]");
    p = add_epsg_def_ex (filter, first, last, 26722, "epsg", 26722,
        "NAD27 / UTM zone 22N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / UTM zone 22N\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "6722\"]]");
    p = add_epsg_def_ex (filter, first, last, 26729, "epsg", 26729,
        "NAD27 / Alabama East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.8333333333333],PARAMETER[\"scale_factor\",0.99996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26729\"]]");
    p = add_epsg_def_ex (filter, first, last, 26730, "epsg", 26730,
        "NAD27 / Alabama West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=1");
    add_proj4text (p, 1,
        "52400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alabama West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-87.5],PARAMETER[\"scale_factor\",0.999933333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26730\"]]");
    p = add_epsg_def_ex (filter, first, last, 26731, "epsg", 26731,
        "NAD27 / Alaska zone 1", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Hotine_Oblique_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000.001016002 +y_0=-5");
    add_proj4text (p, 2,
        "000000.001016002 +no_uoff +gamma=323.1301023611111 +datu");
    add_proj4text (p, 3,
        "m=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 1\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_center\",57],PARAMETER[\"longitude_of_c");
    add_srs_wkt (p, 8,
        "enter\",-133.666666666667],PARAMETER[\"azimuth\",323.130");
    add_srs_wkt (p, 9,
        "102361111],PARAMETER[\"rectified_grid_angle\",323.130102");
    add_srs_wkt (p, 10,
        "361111],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",16404166.67],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",-16404166.67],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26731\"]]");
    p = add_epsg_def_ex (filter, first, last, 26732, "epsg", 26732,
        "NAD27 / Alaska zone 2", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 2\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-142],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26732\"]]");
    p = add_epsg_def_ex (filter, first, last, 26733, "epsg", 26733,
        "NAD27 / Alaska zone 3", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 3\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-146],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26733\"]]");
    p = add_epsg_def_ex (filter, first, last, 26734, "epsg", 26734,
        "NAD27 / Alaska zone 4", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 4\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-150],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26734\"]]");
    p = add_epsg_def_ex (filter, first, last, 26735, "epsg", 26735,
        "NAD27 / Alaska zone 5", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 5\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-154],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26735\"]]");
    p = add_epsg_def_ex (filter, first, last, 26736, "epsg", 26736,
        "NAD27 / Alaska zone 6", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 6\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-158],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26736\"]]");
    p = add_epsg_def_ex (filter, first, last, 26737, "epsg", 26737,
        "NAD27 / Alaska zone 7", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=213360.");
    add_proj4text (p, 1,
        "4267208534 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 7\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-162],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",700000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26737\"]]");
    p = add_epsg_def_ex (filter, first, last, 26738, "epsg", 26738,
        "NAD27 / Alaska zone 8", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=152400.");
    add_proj4text (p, 1,
        "3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 8\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-166],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26738\"]]");
    p = add_epsg_def_ex (filter, first, last, 26739, "epsg", 26739,
        "NAD27 / Alaska zone 9", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.");
    add_proj4text (p, 1,
        "3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 9\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-170],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",600000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26739\"]]");
    p = add_epsg_def_ex (filter, first, last, 26740, "epsg", 26740,
        "NAD27 / Alaska zone 10", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 10\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",51],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-176],PARAMETER[\"standard_parallel_1\",53.83");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"standard_parallel_2\",51.833333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"false_easting\",3000000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26740");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 26741, "epsg", 26741,
        "NAD27 / California zone I", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone I\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",39.3333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-122],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",41.6666666666667],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",40],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2674");
    add_srs_wkt (p, 14,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 26742, "epsg", 26742,
        "NAD27 / California zone II", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone II\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-122],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",39.8333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",38.3333333333333],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"26742\"]]");
    p = add_epsg_def_ex (filter, first, last, 26743, "epsg", 26743,
        "NAD27 / California zone III", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone III\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-120.5],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "1\",38.4333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "37.0666666666667],PARAMETER[\"false_easting\",2000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26743\"]]");
    p = add_epsg_def_ex (filter, first, last, 26744, "epsg", 26744,
        "NAD27 / California zone IV", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +datum=NAD27");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone IV\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",35.3333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-119],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",37.25],PARAMETER[\"standard_parallel_2\",36]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26744\"]]");
    p = add_epsg_def_ex (filter, first, last, 26745, "epsg", 26745,
        "NAD27 / California zone V", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone V\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",33.5],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-118],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 9,
        ".4666666666667],PARAMETER[\"standard_parallel_2\",34.033");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 14,
        "45\"]]");
    p = add_epsg_def_ex (filter, first, last, 26746, "epsg", 26746,
        "NAD27 / California zone VI", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.");
    add_proj4text (p, 2,
        "2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VI\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",32.1666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-116.25],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",33.8833333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",32.7833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"26746\"]]");
    p = add_epsg_def_ex (filter, first, last, 26747, "epsg", 26747,
        "NAD27 / California zone VII", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=127079.524511049 +datum=NAD27");
    add_proj4text (p, 3,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",34.1333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-118.333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",34.4166666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",33.8666666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",4186692.58],PARAMETER[\"false_northing\",416");
    add_srs_wkt (p, 12,
        "0926.74],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26799\"]]");
    p = add_epsg_def_ex (filter, first, last, 26748, "epsg", 26748,
        "NAD27 / Arizona East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-110.166666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26748\"]]");
    p = add_epsg_def_ex (filter, first, last, 26749, "epsg", 26749,
        "NAD27 / Arizona Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-111.916666666667],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26749\"]]");
    p = add_epsg_def_ex (filter, first, last, 26750, "epsg", 26750,
        "NAD27 / Arizona West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26750\"]]");
    p = add_epsg_def_ex (filter, first, last, 26751, "epsg", 26751,
        "NAD27 / Arkansas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",34.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-92],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",36.2333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",34.9333333333333],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"26751\"]]");
    p = add_epsg_def_ex (filter, first, last, 26752, "epsg", 26752,
        "NAD27 / Arkansas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",32.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-92],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",34.7666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",33.3],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2675");
    add_srs_wkt (p, 14,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 26753, "epsg", 26753,
        "NAD27 / Colorado North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",39.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",39.7166666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",40.7833333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26753\"]]");
    p = add_epsg_def_ex (filter, first, last, 26754, "epsg", 26754,
        "NAD27 / Colorado Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=");
    add_proj4text (p, 2,
        "NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",37.8333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-105.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",39.75],PARAMETER[\"standard_parallel_2\",38.");
    add_srs_wkt (p, 10,
        "45],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26754\"]]");
    p = add_epsg_def_ex (filter, first, last, 26755, "epsg", 26755,
        "NAD27 / Colorado South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",36.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",38.4333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",37.2333333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26755\"]]");
    p = add_epsg_def_ex (filter, first, last, 26756, "epsg", 26756,
        "NAD27 / Connecticut", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Connecticut\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",40.8333333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-72.75],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",41.8666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",41.2],PARAMETER[\"false_easting\",600000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26756");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 26757, "epsg", 26757,
        "NAD27 / Delaware", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Delaware\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",38],PARAMETER[\"central_meridian\",-75");
    add_srs_wkt (p, 8,
        ".4166666666667],PARAMETER[\"scale_factor\",0.999995],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26757\"]]");
    p = add_epsg_def_ex (filter, first, last, 26758, "epsg", 26758,
        "NAD27 / Florida East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-81],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26758\"]]");
    p = add_epsg_def_ex (filter, first, last, 26759, "epsg", 26759,
        "NAD27 / Florida West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-82],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26759\"]]");
    p = add_epsg_def_ex (filter, first, last, 26760, "epsg", 26760,
        "NAD27 / Florida North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",29],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-84.5],PARAMETER[\"standard_parallel_1\",30.75]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",29.5833333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26760\"]]");
    p = add_epsg_def_ex (filter, first, last, 26766, "epsg", 26766,
        "NAD27 / Georgia East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-82.1666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26766\"]]");
    p = add_epsg_def_ex (filter, first, last, 26767, "epsg", 26767,
        "NAD27 / Georgia West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-84.1666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26767\"]]");
    p = add_epsg_def_ex (filter, first, last, 26768, "epsg", 26768,
        "NAD27 / Idaho East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",41.6666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-112.166666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999947368],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26768\"]]");
    p = add_epsg_def_ex (filter, first, last, 26769, "epsg", 26769,
        "NAD27 / Idaho Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-114],PARAMETER[\"scale_factor\",0.9999473");
    add_srs_wkt (p, 9,
        "68],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26769\"]]");
    p = add_epsg_def_ex (filter, first, last, 26770, "epsg", 26770,
        "NAD27 / Idaho West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",41.6666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-115.75],PARAMETER[\"scale_factor\",0.99993");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26770\"]]");
    p = add_epsg_def_ex (filter, first, last, 26771, "epsg", 26771,
        "NAD27 / Illinois East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-88.3333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999975],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 11,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "6771\"]]");
    p = add_epsg_def_ex (filter, first, last, 26772, "epsg", 26772,
        "NAD27 / Illinois West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-90.1666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999941177],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"26772\"]]");
    p = add_epsg_def_ex (filter, first, last, 26773, "epsg", 26773,
        "NAD27 / Indiana East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.6666666666667],PARAMETER[\"scale_factor\",0.9999666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26773\"]]");
    p = add_epsg_def_ex (filter, first, last, 26774, "epsg", 26774,
        "NAD27 / Indiana West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87.0833333333333],PARAMETER[\"scale_factor\",0.9999666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26774\"]]");
    p = add_epsg_def_ex (filter, first, last, 26775, "epsg", 26775,
        "NAD27 / Iowa North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",41.5],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-93.5],PARAMETER[\"standard_parallel_1\",43.266");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",42.0666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26775\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26776, "epsg", 26776,
        "NAD27 / Iowa South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",40],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-93.5],PARAMETER[\"standard_parallel_1\",41.78333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"standard_parallel_2\",40.616666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 12,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26776\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26777, "epsg", 26777,
        "NAD27 / Kansas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38.3333333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-98],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",39.7833333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",38.7166666666667],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"26777\"]]");
    p = add_epsg_def_ex (filter, first, last, 26778, "epsg", 26778,
        "NAD27 / Kansas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",36.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-98.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",38.5666666666667],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",37.2666666666667],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"26778\"]]");
    p = add_epsg_def_ex (filter, first, last, 26779, "epsg", 26779,
        "NAD27 / Kentucky North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-84.25],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "7.9666666666667],PARAMETER[\"standard_parallel_2\",38.96");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6779\"]]");
    p = add_epsg_def_ex (filter, first, last, 26780, "epsg", 26780,
        "NAD27 / Kentucky South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",36.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-85.75],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",36.7333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",37.9333333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26780\"]]");
    p = add_epsg_def_ex (filter, first, last, 26781, "epsg", 26781,
        "NAD27 / Louisiana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",30.6666666666667],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-92.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",31.1666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",32.6666666666667],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26781\"]]");
    p = add_epsg_def_ex (filter, first, last, 26782, "epsg", 26782,
        "NAD27 / Louisiana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.666666666666");
    add_proj4text (p, 1,
        "67 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",28.6666666666667],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-91.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",29.3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",30.7],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 14,
        "82\"]]");
    p = add_epsg_def_ex (filter, first, last, 26783, "epsg", 26783,
        "NAD27 / Maine East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",43.8333333333333],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26783\"]]");
    p = add_epsg_def_ex (filter, first, last, 26784, "epsg", 26784,
        "NAD27 / Maine West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",42.8333333333333],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-70.1666666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999966667],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26784\"]]");
    p = add_epsg_def_ex (filter, first, last, 26785, "epsg", 26785,
        "NAD27 / Maryland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maryland\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_origin\",37.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-77],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",38.3],PARAMETER[\"standard_parallel_2\",39.45],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",800000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26785\"]]");
    p = add_epsg_def_ex (filter, first, last, 26786, "epsg", 26786,
        "NAD27 / Massachusetts Mainland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Mainland\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-71.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",41.7166666666667],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 10,
        "2.6833333333333],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26786\"]]");
    p = add_epsg_def_ex (filter, first, last, 26787, "epsg", 26787,
        "NAD27 / Massachusetts Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-70.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",41.2833333333333],PARAMETER[\"standard_parallel_2\",41.");
    add_srs_wkt (p, 10,
        "4833333333333],PARAMETER[\"false_easting\",200000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26787\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

