/*
 * wav-formats.h: Values for WAV headers' "subtype" field (bytes 21-22)
 * adapted from mingw32's mmreg.h header included in MXE http://mxe.cc
 */

/*
 This Software is provided under the Zope Public License (ZPL) Version 2.1.

 Copyright (c) 2009, 2010 by the mingw-w64 project

 See the AUTHORS file for the list of contributors to the mingw-w64 project.

 This license has been certified as open source. It has also been designated
 as GPL compatible by the Free Software Foundation (FSF).

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

   1. Redistributions in source code must retain the accompanying copyright
      notice, this list of conditions, and the following disclaimer.
   2. Redistributions in binary form must reproduce the accompanying
      copyright notice, this list of conditions, and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
   3. Names of the copyright holders must not be used to endorse or promote
      products derived from this software without prior written permission
      from the copyright holders.
   4. The right to distribute this software or to use it for any purpose does
      not give you the right to use Servicemarks (sm) or Trademarks (tm) of
      the copyright holders.  Use of them is covered by separate agreement
      with the copyright holders.
   5. If any files are modified, you must cause the modified files to carry
      prominent notices stating that you changed the files and the date of
      any change.

 Disclaimer

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESSED
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define WAVE_FORMAT_UNKNOWN (0x0000U)
#define WAVE_FORMAT_PCM (0x0001U)
#define WAVE_FORMAT_ADPCM (0x0002U)
#define WAVE_FORMAT_IEEE_FLOAT (0x0003U)
#define WAVE_FORMAT_VSELP (0x0004U)
#define WAVE_FORMAT_IBM_CVSD (0x0005U)
#define WAVE_FORMAT_ALAW (0x0006U)
#define WAVE_FORMAT_MULAW (0x0007U)
#define WAVE_FORMAT_DTS (0x0008U)
#define WAVE_FORMAT_DRM (0x0009U)
#define WAVE_FORMAT_WMAVOICE9 (0x000aU)
#define WAVE_FORMAT_WMAVOICE10 (0x000bU)
#define WAVE_FORMAT_OKI_ADPCM (0x0010U)
#define WAVE_FORMAT_IMA_ADPCM (0x0011U)
#define WAVE_FORMAT_MEDIASPACE_ADPCM (0x0012U)
#define WAVE_FORMAT_SIERRA_ADPCM (0x0013U)
#define WAVE_FORMAT_G723_ADPCM (0x0014U)
#define WAVE_FORMAT_DIGISTD (0x0015U)
#define WAVE_FORMAT_DIGIFIX (0x0016U)
#define WAVE_FORMAT_DIALOGIC_OKI_ADPCM (0x0017U)
#define WAVE_FORMAT_MEDIAVISION_ADPCM (0x0018U)
#define WAVE_FORMAT_CU_CODEC (0x0019U)
#define WAVE_FORMAT_HP_DYN_VOICE (0x001aU)
#define WAVE_FORMAT_YAMAHA_ADPCM (0x0020U)
#define WAVE_FORMAT_SONARC (0x0021U)
#define WAVE_FORMAT_DSPGROUP_TRUESPEECH (0x0022U)
#define WAVE_FORMAT_ECHOSC1 (0x0023U)
#define WAVE_FORMAT_AUDIOFILE_AF36 (0x0024U)
#define WAVE_FORMAT_APTX (0x0025U)
#define WAVE_FORMAT_AUDIOFILE_AF10 (0x0026U)
#define WAVE_FORMAT_PROSODY_1612 (0x0027U)
#define WAVE_FORMAT_LRC (0x0028U)
#define WAVE_FORMAT_DOLBY_AC2 (0x0030U)
#define WAVE_FORMAT_GSM610 (0x0031U)
#define WAVE_FORMAT_MSNAUDIO (0x0032U)
#define WAVE_FORMAT_ANTEX_ADPCME (0x0033U)
#define WAVE_FORMAT_CONTROL_RES_VQLPC (0x0034U)
#define WAVE_FORMAT_DIGIREAL (0x0035U)
#define WAVE_FORMAT_DIGIADPCM (0x0036U)
#define WAVE_FORMAT_CONTROL_RES_CR10 (0x0037U)
#define WAVE_FORMAT_NMS_VBXADPCM (0x0038U)
#define WAVE_FORMAT_CS_IMAADPCM (0x0039U)
#define WAVE_FORMAT_ECHOSC3 (0x003aU)
#define WAVE_FORMAT_ROCKWELL_ADPCM (0x003bU)
#define WAVE_FORMAT_ROCKWELL_DIGITALK (0x003cU)
#define WAVE_FORMAT_XEBEC (0x003dU)
#define WAVE_FORMAT_G721_ADPCM (0x0040U)
#define WAVE_FORMAT_G728_CELP (0x0041U)
#define WAVE_FORMAT_MSG723 (0x0042U)
#define WAVE_FORMAT_INTEL_G723_1 (0x0043U)
#define WAVE_FORMAT_INTEL_G729 (0x0044U)
#define WAVE_FORMAT_SHARP_G726 (0x0045U)
#define WAVE_FORMAT_MPEG (0x0050U)

/* From www.recordingblogs.com/wiki/format-chunk-of-a-wave-file */
#define WAVE_FORMAT_RT23 (0x0051U)

#define WAVE_FORMAT_RT24 (0x0052U)
#define WAVE_FORMAT_PAC (0x0053U)
#define WAVE_FORMAT_MPEGLAYER3 (0x0055U)
#define WAVE_FORMAT_LUCENT_G723 (0x0059U)
#define WAVE_FORMAT_CIRRUS (0x0060U)
#define WAVE_FORMAT_ESPCM (0x0061U)
#define WAVE_FORMAT_VOXWARE (0x0062U)
#define WAVE_FORMAT_CANOPUS_ATRAC (0x0063U)
#define WAVE_FORMAT_G726_ADPCM (0x0064U)
#define WAVE_FORMAT_G722_ADPCM (0x0065U)
#define WAVE_FORMAT_DSAT (0x0066U)
#define WAVE_FORMAT_DSAT_DISPLAY (0x0067U)
#define WAVE_FORMAT_VOXWARE_BYTE_ALIGNED (0x0069U)
#define WAVE_FORMAT_VOXWARE_AC8 (0x0070U)
#define WAVE_FORMAT_VOXWARE_AC10 (0x0071U)
#define WAVE_FORMAT_VOXWARE_AC16 (0x0072U)
#define WAVE_FORMAT_VOXWARE_AC20 (0x0073U)
#define WAVE_FORMAT_VOXWARE_RT24 (0x0074U)
#define WAVE_FORMAT_VOXWARE_RT29 (0x0075U)
#define WAVE_FORMAT_VOXWARE_RT29HW (0x0076U)
#define WAVE_FORMAT_VOXWARE_VR12 (0x0077U)
#define WAVE_FORMAT_VOXWARE_VR18 (0x0078U)
#define WAVE_FORMAT_VOXWARE_TQ40 (0x0079U)
#define WAVE_FORMAT_VOXWARE_SC3 (0x007aU)
#define WAVE_FORMAT_VOXWARE_SC3_1 (0x007bU)
#define WAVE_FORMAT_SOFTSOUND (0x0080U)
#define WAVE_FORMAT_VOXWARE_TQ60 (0x0081U)
#define WAVE_FORMAT_MSRT24 (0x0082U)
#define WAVE_FORMAT_G729A (0x0083U)
#define WAVE_FORMAT_MVI_MVI2 (0x0084U)
#define WAVE_FORMAT_DF_G726 (0x0085U)
#define WAVE_FORMAT_DF_GSM610 (0x0086U)
#define WAVE_FORMAT_ISIAUDIO (0x0088U)
#define WAVE_FORMAT_ONLIVE (0x0089U)
#define WAVE_FORMAT_MULTITUDE_FT_SX20 (0x008aU)
#define WAVE_FORMAT_INFOCOM_ITS_G721_ADPCM (0x008bU)
#define WAVE_FORMAT_CONVEDIA_G729 (0x008cU)
#define WAVE_FORMAT_CONGRUENCY (0x008dU)
#define WAVE_FORMAT_SBC24 (0x0091U)
#define WAVE_FORMAT_DOLBY_AC3_SPDIF (0x0092U)
#define WAVE_FORMAT_MEDIASONIC_G723 (0x0093U)
#define WAVE_FORMAT_PROSODY_8KBPS (0x0094U)
#define WAVE_FORMAT_ZYXEL_ADPCM (0x0097U)
#define WAVE_FORMAT_PHILIPS_LPCBB (0x0098U)
#define WAVE_FORMAT_PACKED (0x0099U)
#define WAVE_FORMAT_MALDEN_PHONYTALK (0x00a0U)
#define WAVE_FORMAT_RACAL_RECORDER_GSM (0x00a1U)
#define WAVE_FORMAT_RACAL_RECORDER_G720_A (0x00a2U)
#define WAVE_FORMAT_RACAL_RECORDER_G723_1 (0x00a3U)
#define WAVE_FORMAT_RACAL_RECORDER_TETRA_ACELP (0x00a4U)
#define WAVE_FORMAT_NEC_AAC (0x00b0U)
#define WAVE_FORMAT_RAW_AAC1 (0x00ffU)
#define WAVE_FORMAT_RHETOREX_ADPCM (0x0100U)
#define WAVE_FORMAT_IRAT (0x0101U)
#define WAVE_FORMAT_VIVO_G723 (0x0111U)
#define WAVE_FORMAT_VIVO_SIREN (0x0112U)
#define WAVE_FORMAT_PHILIPS_CELP (0x0120U)
#define WAVE_FORMAT_PHILIPS_GRUNDIG (0x0121U)
#define WAVE_FORMAT_DIGITAL_G723 (0x0123U)
#define WAVE_FORMAT_SANYO_LD_ADPCM (0x0125U)
#define WAVE_FORMAT_SIPROLAB_ACEPLNET (0x0130U)
#define WAVE_FORMAT_SIPROLAB_ACELP4800 (0x0131U)
#define WAVE_FORMAT_SIPROLAB_ACELP8V3 (0x0132U)
#define WAVE_FORMAT_SIPROLAB_G729 (0x0133U)
#define WAVE_FORMAT_SIPROLAB_G729A (0x0134U)
#define WAVE_FORMAT_SIPROLAB_KELVIN (0x0135U)
#define WAVE_FORMAT_VOICEAGE_AMR (0x0136U)
#define WAVE_FORMAT_G726ADPCM (0x0140U)
#define WAVE_FORMAT_DICTAPHONE_CELP68 (0x0141U)
#define WAVE_FORMAT_DICTAPHONE_CELP54 (0x0142U)
#define WAVE_FORMAT_QUALCOMM_PUREVOICE (0x0150U)
#define WAVE_FORMAT_QUALCOMM_HALFRATE (0x0151U)
#define WAVE_FORMAT_TUBGSM (0x0155U)
#define WAVE_FORMAT_MSAUDIO1 (0x0160U)
#define WAVE_FORMAT_WMAUDIO2 (0x0161U)
#define WAVE_FORMAT_WMAUDIO3 (0x0162U)
#define WAVE_FORMAT_WMAUDIO_LOSSLESS (0x0163U)
#define WAVE_FORMAT_WMASPDIF (0x0164U)
#define WAVE_FORMAT_UNISYS_NAP_ADPCM (0x0170U)
#define WAVE_FORMAT_UNISYS_NAP_ULAW (0x0171U)
#define WAVE_FORMAT_UNISYS_NAP_ALAW (0x0172U)
#define WAVE_FORMAT_UNISYS_NAP_16K (0x0173U)
#define WAVE_FORMAT_SYCOM_ACM_SYC008 (0x0174U)
#define WAVE_FORMAT_SYCOM_ACM_SYC701_G726L (0x0175U)
#define WAVE_FORMAT_SYCOM_ACM_SYC701_CELP54 (0x0176U)
#define WAVE_FORMAT_SYCOM_ACM_SYC701_CELP68 (0x0177U)
#define WAVE_FORMAT_KNOWLEDGE_ADVENTURE_ADPCM (0x0178U)
#define WAVE_FORMAT_FRAUNHOFER_IIS_MPEG2_AAC (0x0180U)
#define WAVE_FORMAT_DTS_DS (0x0190U)
#define WAVE_FORMAT_CREATIVE_ADPCM (0x0200U)
#define WAVE_FORMAT_CREATIVE_FASTSPEECH8 (0x0202U)
#define WAVE_FORMAT_CREATIVE_FASTSPEECH10 (0x0203U)
#define WAVE_FORMAT_UHER_ADPCM (0x0210U)
#define WAVE_FORMAT_ULEAD_DV_AUDIO (0x0215U)
#define WAVE_FORMAT_ULEAD_DV_AUDIO_1 (0x0216U)
#define WAVE_FORMAT_QUARTERDECK (0x0220U)
#define WAVE_FORMAT_ILINK_VC (0x0230U)
#define WAVE_FORMAT_RAW_SPORT (0x0240U)
#define WAVE_FORMAT_ESST_AC3 (0x0241U)
#define WAVE_FORMAT_GENERIC_PASSTHRU (0x0249U)
#define WAVE_FORMAT_IPI_HSX (0x0250U)
#define WAVE_FORMAT_IPI_RPELP (0x0251U)
#define WAVE_FORMAT_CS2 (0x0260U)
#define WAVE_FORMAT_SONY_SCX (0x0270U)
#define WAVE_FORMAT_SONY_SCY (0x0271U)
#define WAVE_FORMAT_SONY_ATRAC3 (0x0272U)
#define WAVE_FORMAT_SONY_SPC (0x0273U)
#define WAVE_FORMAT_TELUM_AUDIO (0x0280U)
#define WAVE_FORMAT_TELUM_IA_AUDIO (0x0281U)
#define WAVE_FORMAT_NORCOM_VOICE_SYSTEMS_ADPCM (0x0285U)
#define WAVE_FORMAT_FM_TOWNS_SND (0x0300U)
#define WAVE_FORMAT_MICRONAS (0x0350U)
#define WAVE_FORMAT_MICRONAS_CELP833 (0x0351U)
#define WAVE_FORMAT_BTV_DIGITAL (0x0400U)
#define WAVE_FORMAT_INTEL_MUSIC_CODER (0x0401U)
#define WAVE_FORMAT_INDEO_AUDIO (0x0402U)
#define WAVE_FORMAT_QDESIGN_MUSIC (0x0450U)
#define WAVE_FORMAT_ON2_VP7_AUDIO (0x0500U)
#define WAVE_FORMAT_ON2_VP6_AUDIO (0x0501U)
#define WAVE_FORMAT_VME_VMPCM (0x0680U)
#define WAVE_FORMAT_TPC (0x0681U)

/* From https://codec.kyiv.ua/audio.html */
#define WAVE_FORMAT_YMPEG (0x0700U)

#define WAVE_FORMAT_LIGHTWAVE_LOSSLESS (0x08aeU)
#define WAVE_FORMAT_OLIGSM (0x1000U)
#define WAVE_FORMAT_OLIADPCM (0x1001U)
#define WAVE_FORMAT_OLICELP (0x1002U)
#define WAVE_FORMAT_OLISBC (0x1003U)
#define WAVE_FORMAT_OLIOPR (0x1004U)
#define WAVE_FORMAT_LH_CODEC (0x1100U)
#define WAVE_FORMAT_LH_CODEC_CELP (0x1101U)
#define WAVE_FORMAT_LH_CODEC_SBC8 (0x1102U)
#define WAVE_FORMAT_LH_CODEC_SBC12 (0x1103U)
#define WAVE_FORMAT_LH_CODEC_SBC16 (0x1104U)
#define WAVE_FORMAT_NORRIS (0x1400U)
#define WAVE_FORMAT_ISIAUDIO_2 (0x1401U)
#define WAVE_FORMAT_SOUNDSPACE_MUSICOMPRESS (0x1500U)
#define WAVE_FORMAT_MPEG_ADTS_AAC (0x1600U)
#define WAVE_FORMAT_MPEG_RAW_AAC (0x1601U)
#define WAVE_FORMAT_MPEG_LOAS (0x1602U)
#define WAVE_FORMAT_NOKIA_MPEG_ADTS_AAC (0x1608U)
#define WAVE_FORMAT_NOKIA_MPEG_RAW_AAC (0x1609U)
#define WAVE_FORMAT_VODAFONE_MPEG_ADTS_AAC (0x160aU)
#define WAVE_FORMAT_VODAFONE_MPEG_RAW_AAC (0x160bU)
#define WAVE_FORMAT_MPEG_HEAAC (0x1610U)
#define WAVE_FORMAT_VOXWARE_RT24_SPEECH (0x181cU)

/* From https://codec.kyiv.ua/audio.html */
#define WAVE_FORMAT_LUCENT_AX24000P (0x181eU)

#define WAVE_FORMAT_SONICFOUNDRY_LOSSLESS (0x1971U)
#define WAVE_FORMAT_INNINGS_TELECOM_ADPCM (0x1979U)
#define WAVE_FORMAT_LUCENT_SX8300P (0x1c07U)
#define WAVE_FORMAT_LUCENT_SX5363S (0x1c0cU)
#define WAVE_FORMAT_CUSEEME (0x1f03U)
#define WAVE_FORMAT_NTCSOFT_ALF2CM_ACM (0x1fc4U)
#define WAVE_FORMAT_DVM (0x2000U)
#define WAVE_FORMAT_DTS2 (0x2001U)

/* From www.recordingblogs.com/wiki/format-chunk-of-a-wave-file */
/* (The symbol names are invented here) */
#define WAVE_FORMAT_RA_14 (0x02002U)
#define WAVE_FORMAT_RA_28 (0x02003U)
#define WAVE_FORMAT_RA_G2 (0x2004U)
#define WAVE_FORMAT_RA_DNET (0x2005U)
#define WAVE_FORMAT_RA_RAAC (0x2006U)
#define WAVE_FORMAT_RA_RACP (0x2007U)

/* From https://codec.kyiv.ua/audio.html */
#define WAVE_FORMAT_FFMPEG_SONIC (0x2048U)

#define WAVE_FORMAT_MAKEAVIS (0x3313U)
#define WAVE_FORMAT_DIVIO_MPEG4_AAC (0x4143U)
#define WAVE_FORMAT_NOKIA_ADAPTIVE_MULTIRATE (0x4201U)
#define WAVE_FORMAT_DIVIO_G726 (0x4243U)
#define WAVE_FORMAT_LEAD_SPEECH (0x434cU)

/* From https://codec.kyiv.ua/audio.html */
#define WAVE_FORMAT_FFMPEG_ADPCM (0x5346U)

#define WAVE_FORMAT_LEAD_VORBIS (0x564cU)
#define WAVE_FORMAT_WAVPACK_AUDIO (0x5756U)
#define WAVE_FORMAT_OGG_VORBIS_MODE_1 (0x674fU)
#define WAVE_FORMAT_OGG_VORBIS_MODE_2 (0x6750U)
#define WAVE_FORMAT_OGG_VORBIS_MODE_3 (0x6751U)
#define WAVE_FORMAT_OGG_VORBIS_MODE_1_PLUS (0x676fU)
#define WAVE_FORMAT_OGG_VORBIS_MODE_2_PLUS (0x6770U)
#define WAVE_FORMAT_OGG_VORBIS_MODE_3_PLUS (0x6771U)
#define WAVE_FORMAT_ALAC (0x6c61U)
#define WAVE_FORMAT_3COM_NBX (0x7000U)
#define WAVE_FORMAT_OPUS (0x704fU)
#define WAVE_FORMAT_FAAD_AAC (0x706dU)
#define WAVE_FORMAT_AMR_NB (0x7361U)
#define WAVE_FORMAT_AMR_WB (0x7362U)
#define WAVE_FORMAT_AMR_WP (0x7363U)
#define WAVE_FORMAT_GSM_AMR_CBR (0x7a21U)
#define WAVE_FORMAT_GSM_AMR_VBR_SID (0x7a22U)
#define WAVE_FORMAT_COMVERSE_INFOSYS_G723_1 (0xa100U)
#define WAVE_FORMAT_COMVERSE_INFOSYS_AVQSBC (0xa101U)
#define WAVE_FORMAT_COMVERSE_INFOSYS_SBC (0xa102U)
#define WAVE_FORMAT_SYMBOL_G729_A (0xa103U)
#define WAVE_FORMAT_VOICEAGE_AMR_WB (0xa104U)
#define WAVE_FORMAT_INGENIENT_G726 (0xa105U)
#define WAVE_FORMAT_MPEG4_AAC (0xa106U)
#define WAVE_FORMAT_ENCORE_G726 (0xa107U)
#define WAVE_FORMAT_ZOLL_ASAO (0xa108U)
#define WAVE_FORMAT_SPEEX_VOICE (0xa109U)
#define WAVE_FORMAT_VIANIX_MASC (0xa10aU)
#define WAVE_FORMAT_WM9_SPECTRUM_ANALYZER (0xa10bU)
#define WAVE_FORMAT_WMF_SPECTRUM_ANAYZER (0xa10cU)
#define WAVE_FORMAT_GSM_610 (0xa10dU)
#define WAVE_FORMAT_GSM_620 (0xa10eU)
#define WAVE_FORMAT_GSM_660 (0xa10fU)
#define WAVE_FORMAT_GSM_690 (0xa110U)
#define WAVE_FORMAT_GSM_ADAPTIVE_MULTIRATE_WB (0xa111U)
#define WAVE_FORMAT_POLYCOM_G722 (0xa112U)
#define WAVE_FORMAT_POLYCOM_G728 (0xa113U)
#define WAVE_FORMAT_POLYCOM_G729_A (0xa114U)
#define WAVE_FORMAT_POLYCOM_SIREN (0xa115U)
#define WAVE_FORMAT_GLOBAL_IP_ILBC (0xa116U)
#define WAVE_FORMAT_RADIOTIME_TIME_SHIFT_RADIO (0xa117U)
#define WAVE_FORMAT_NICE_ACA (0xa118U)
#define WAVE_FORMAT_NICE_ADPCM (0xa119U)
#define WAVE_FORMAT_VOCORD_G721 (0xa11aU)
#define WAVE_FORMAT_VOCORD_G726 (0xa11bU)
#define WAVE_FORMAT_VOCORD_G722_1 (0xa11cU)
#define WAVE_FORMAT_VOCORD_G728 (0xa11dU)
#define WAVE_FORMAT_VOCORD_G729 (0xa11eU)
#define WAVE_FORMAT_VOCORD_G729_A (0xa11fU)
#define WAVE_FORMAT_VOCORD_G723_1 (0xa120U)
#define WAVE_FORMAT_VOCORD_LBC (0xa121U)
#define WAVE_FORMAT_NICE_G728 (0xa122U)
#define WAVE_FORMAT_FRACE_TELECOM_G729 (0xa123U)
#define WAVE_FORMAT_CODIAN (0xa124U)
#define WAVE_FORMAT_DOLBY_AC4 (0xac40U)

/* From https://www.recordingblogs.com/wiki/format-chunk-of-a-wave-file */
#define WAVE_FORMAT_DFAC (0xdfacU)

#define WAVE_FORMAT_FLAC (0xf1acU)
#define WAVE_FORMAT_EXTENSIBLE (0xfffeU)
