#include "soap_snp.h"

double Call_win::normal_value(double z) {
	if (z>6.0 || z<-6.0) {
		return 0.0;
	}
	else {
		double b1 = 0.31938153;
		double b2 = -0.356563782;
		double b3 = 1.781477937;
		double b4 = -1.821255978;
		double b5 = 1.330274429;
		double p = 0.2316419;
		double c2 = 0.39894228;

		double a = fabs(z);
		double t = 1.0/(1.0+a*p);
		double b = c2*exp((-z)*(z/2.0));
		double n = ((((b5*t+b4)*t+b3)*t+b2)*t+b1)*t;
		n = 1.0 - b*n;
		if (z < 0.0) n = 1.0 - n;
		return n>0.5?1-n:n;
	}
}
