.\" Copyright © 2005-2010  Roger Leigh <rleigh@debian.org>
.\"
.\" schroot is free software: you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" schroot is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.\"
.so config.man
.ds PROGRAM csbuild
.TH CSBUILD 1 "\*[RELEASE_DATE]" "Version \*[VERSION]" "Debian sbuild"
.SH NAME
csbuild \- build debian packages from source
.SH SYNOPSIS
.B csbuild
.RB [ \-h \[or] \-\-help " \[or] " \-V \[or] \-\-version
.RB " \[or] " \-l \[or] \-\-list " \[or] " \-i \[or] \-\-info
.RB " \[or] " \-\-config " \[or] " \-\-location ]
.RB [ "\-\-directory=\fIdirectory\fP" ]
.RB [ \-d \[or] \-\-preserve\-environment ]
.RB [ \-q \[or] \-\-quiet " \[or] " \-v \[or] \-\-verbose ]
.RB [ "\-c \fIchroot\fP" \[or] "\-\-chroot=\fIchroot\fP"
.RB " \[or] " \-\-all ]
.RB [ COMMAND " [ " ARG1 " [ " ARG2 " [ " ARGn ]]]]
.SH DESCRIPTION
\fBcsbuild\fP allows the user to run a command or a login shell in a chroot
environment.  If no command is specified, a login shell will be started in the
user's home directory inside the chroot.
.PP
The command is one or more arguments which will be run in the user's default
shell using its \fI\-c\fP option.  As a result, shell code may be embedded
in this argument.  If multiple command options are used, they are concatenated
together, separated by spaces.  Users should be aware of the shell quoting
issues this presents, and should use \fBschroot\fP if necessary, which does not
have any quoting issues.
.PP
The directory the command or login shell is run in depends upon the context.
See \fI\-\-directory\fP option below for a complete description.
.PP
This version of csbuild is a compatibility wrapper around the
.BR schroot (1)
program.  It is provided for backward compatibility with the csbuild
command-line options, but schroot is recommended for future use.  See the
section \[lq]\fIMigration\fP\[rq] below for help migrating an existing csbuild
configuration to schroot.  See the section \[lq]\fIIncompatibilities\fP\[rq]
below for known incompatibilities with older versions of csbuild.
.PP
If no chroot is specified, the chroot name or alias \[oq]default\[cq] will be
used as a fallback.  If using the configuration in \fI\*[CSBUILD_CONF]\fP, the
first chroot in the file is the default.
.SH OPTIONS
\fBcsbuild\fP accepts the following options:
.SS Basic options
.TP
.BR \-h ", " \-\-help
Show help summary.
.TP
.BR \-a ", " \-\-all
Select all chroots.
.TP
.BR \-c ", " \-\-chroot=\fIchroot\fP
Specify a chroot to use.  This option may be used multiple times to specify
more than one chroot, in which case its effect is similar to \fI\-\-all\fP.
.TP
.BR \-l ", " \-\-list
List all available chroots.
.TP
.BR \-i ", " \-\-info
Print detailed information about the specified chroots.  Note that earlier
versions of csbuild did not include this option.
.TP
.BR \-p ", " \-\-path
Print location (path) of the specified chroots.
.TP
.BR \-\-config
Print configuration of the specified chroots.  This is useful for testing that
the configuration in use is the same as the configuration file.  Any comments
in the original file will be missing.  Note that earlier versions of csbuild
did not include this option.
.TP
.BR \-d ", " \-\-directory=\fIdirectory\fP
Change to \fIdirectory\fP inside the chroot before running the command or login
shell.  If \fIdirectory\fP is not available, csbuild will exit with an error
status.
.IP
The default behaviour is as follows (all directory paths are inside the
chroot).  Unless the \fI\-\-preserve\-environment\fP option is used to preserve
the environment, the login shell or command will run in the user's home
directory, or \fI/\fP if the home directory is not available.  When the
\fI\-\-preserve\-environment\fP option is used, it will attempt to use the
current working directory, again falling back to \fI/\fP if it is not
accessible.  If none of the directories are available, csbuild will exit with
an error status.
.TP
.BR \-d ", " \-\-preserve\-environment
Preserve the user's environment inside the chroot environment.  The default is
to use a clean environment; this option copies the entire user environment and
sets it in the session.
.TP
.BR \-q ", " \-\-quiet
Print only essential messages.
.TP
.BR \-v ", " \-\-verbose
Print all messages.  Note that earlier versions of csbuild did not include this
option.
.TP
.BR \-V ", " \-\-version
Print version information.
.PP
Note that earlier versions of csbuild did not provide long options.
.SH CONFIGURATION
The csbuild configuration file, \fI\*[CSBUILD_CONF]\fP, used by earlier versions
of csbuild, has the following format:
.IP \[bu]
\[oq]#\[cq] starts a comment line.
.IP \[bu]
Blank lines are ignored.
.IP \[bu]
Chroot definitions are a single line containing an \f[CBI]identifier\fP,
\f[CBI]path\fP, and an optional \f[CBI]personality\fP separated by whitespace.
.IP \[bu]
The first chroot is also the default chroot.
.PP
An example file:
.PP
.RS
.EX
# Example comment

sarge /srv/chroot/sarge
sid /srv/chroot/sid linux32
.EE
.RE
.PP
This file defines a chroot called \[oq]sarge\[cq], located at
\fI/srv/chroot/sarge\fP, and a second chroot called \[oq]sid\[cq], located at
\fI/srv/chroot/sid\fP.  The second chroot uses the \[oq]linux32\[cq]
personality, which allows a 32-bit chroot to be used on a 64-bit system.
\[oq]sarge\[cq] is the default chroot, because it was listed first, which means
if the \fI\-c\fP option is omitted this chroot will be used.
.SH INCOMPATIBILITIES
.SS Debian csbuild prior to version 0.99.0
.IP \[bu]
Log messages are worded and formatted differently.
.IP \[bu]
The parsing of \fI\*[CSBUILD_CONF]\fP uses a smaller list of allowed whitespace
characters (space and tab), which may cause a parse error during tokenising if
the file contains odd characters as separators, such as carriage returns,
vertical tabs and form feeds.
.IP \[bu]
.BR su (1)
is no longer used to run commands in the chroot; this is done by csbuild
internally.  This change may cause subtle differences.  If you find an
incompatibility, please report it so it may be corrected.
.IP \[bu]
csbuild provides a restricted subset of the functionality implemented by
\fBschroot\fP, but is still schroot underneath.  Thus csbuild is still subject
to schroot security checking, including PAM authentication and authorisation,
and session management, for example, and hence may behave slightly differently
to older csbuild versions in some circumstances.
.SS DSA csbuild
Machines run by the Debian System Administrators for the Debian Project have a
\fBcsbuild-dsa\fP package which provides an alternate csbuild implementation.
.IP \[bu]
All the above incompatibilities apply.
.IP \[bu]
This version of csbuild has incompatible command-line options, and while some
of those options are supported or have equivalent options by a different name,
the \fI\-c\fP option is not required to specify a chroot, and this version of
csbuild cannot implement this behaviour in a backward-compatible manner
(because if \fI\-c\fP is omitted, the default chroot is used).  DSA csbuild
uses the first non-option as the chroot to use, only allowing one chroot to be
used at once.
.IP \[bu]
This version of csbuild has an incompatible format for \fIcsbuild.conf\fP.
While the first two fields are the same, the remaining fields are an optional
\f[CBI]users\fP, a list of users permitted to access the chroot, instead of the
\f[CI]personality\fP field allowed by this version.  If access restrictions are
needed, please use \fI\*[SCHROOT_CONF]\fP and add the allowed users there, as
shown in \[lq]\fIMigration\fP\[rq] below.
.SH MIGRATION
To migrate an existing \fBcsbuild\fP configuration to \fBschroot\fP, perform
the following steps:
.IP 1
Dump the csbuild configuration in schroot keyfile format to
\fI\*[SCHROOT_CONF]\fP.
.PP
.RS
.EX
# \f[CB]csbuild --config >> \*[SCHROOT_CONF]\fP\[CR]
.EE
.RE
.PP
.IP 2
Edit \fI\*[SCHROOT_CONF]\fP to add access to the users and/or groups which are to
be allowed to access the chroots, and make any other desired changes to the
configuration.  See
.BR schroot.conf (5).
.IP 3
Remove \fI\*[CSBUILD_CONF]\fP, so that csbuild will subsequently use
\fI\*[SCHROOT_CONF]\fP for its configuration.
.SH EXAMPLES
.EX
$ \f[CB]csbuild \-l\fP\[CR]
Available chroots: sarge [default], sid

$ \f[CB]csbuild \-p sid\fP\[CR]
/srv/chroot/sid

$ \f[CB]csbuild \-q \-c sid \-\- uname \-smr\fP\[CR]
Linux 2.6.16.17 ppc
$ \f[CB]csbuild \-q \-c sid \-\- "uname \-smr"\fP\[CR]
Linux 2.6.16.17 ppc

$ \f[CB]csbuild -q -c sid "ls -1 / | tac | head -n 4"\fP\[CR]
var
usr
tmp
sys

$ \f[CB]csbuild \-c sid\fP\[CR]
I: [sid chroot] Running login shell: \[lq]/bin/bash\[rq]
$
.EE
.LP
Use \fI\-\-\fP to allow options beginning with \[oq]\-\[cq] or \[oq]\-\-\[cq]
in the command to run in the chroot.  This prevents them being interpreted as
options for csbuild itself.  Note that the top line was echoed to standard
error, and the remaining lines to standard output.  This is intentional, so
that program output from commands run in the chroot may be piped and redirected
as required; the data will be the same as if the command was run directly on
the host system.
.SH TROUBLESHOOTING
If something is not working, and it's not clear from the error messages what is
wrong, try using the \fB\-\-debug=\fP\fIlevel\fP option to turn on debugging
messages.  This gives a great deal more information.  Valid debug levels are
\[oq]none\[cq], and \[oq]notice\[cq], \[oq]info\[cq], \[oq]warning\[cq] and
\[oq]critical\[cq] in order of increasing severity.  The lower the severity
level, the more output.
.PP
If you are still having trouble, the developers may be contacted on the mailing
list:
.br
\f[CR]Debian\ buildd-tools\ Developers
.br
<buildd-tools-devel@lists.alioth.debian.org>\fP
.SH BUGS
On the \fBmips\fP and \fBmipsel\fP architectures, Linux kernels up to and
including at least version 2.6.17 have broken
.BR personality (2)
support, which results in a failure to set the personality.  This will be seen
as an \[lq]Operation not permitted\[rq] (EPERM) error.  To work around this
problem, set \f[CI]personality\fP to \[oq]undefined\[cq], or upgrade to a more
recent kernel.
.SH FILES
.TP
\f[BI]\*[CSBUILD_CONF]\fP
The system-wide \fBcsbuild\fP chroot definition file.  This file must be owned
by the root user, and not be writable by other.  If present, this file will be
used in preference to \fI\*[SCHROOT_CONF]\fP.
.TP
\f[BI]\*[SCHROOT_CONF]\fP
The system-wide \fBschroot\fP definition file.  This file must be owned by the
root user, and not be writable by other.  It is recommended that this file be
used in preference to \fI\*[CSBUILD_CONF]\fP, because the chroots can be used
interchangeably with schroot, and the user and group security policies provided
by schroot are also enforced.
.so authors.man
.PP
This implementation of csbuild uses the same command-line options as the
original \fBsbuild\fP by David Kimdon \f[CR]<dwhedon@debian.org>\fP, but is an
independent implementation.
.so copyright.man
.SH SEE ALSO
.BR schroot (1),
.BR sbuild (1),
.BR chroot (2),
.BR schroot-setup (5),
.BR schroot.conf (5).
.\"#
.\"# The following sets edit modes for GNU EMACS
.\"# Local Variables:
.\"# mode:nroff
.\"# fill-column:79
.\"# End:
