/*
 * Copyright (c) 2008-2018 the MRtrix3 contributors.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, you can obtain one at http://mozilla.org/MPL/2.0/
 *
 * MRtrix3 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * For more details, see http://www.mrtrix.org/
 */


#include "dwi/directions/predefined.h"


namespace MR {
  namespace DWI {
    namespace Directions {



      const default_type electrostatic_repulsion_60_data[] = {
        2.101909835, 0.5787523099, 
        1.329393935, 0.9997406558, 
        -0.9818393321, 1.566527183, 
        -0.008572418695, 0.9932141444, 
        -1.697423952, 0.8808080323, 
        -1.612259217, 1.488559733, 
        -1.944012558, 1.546949162, 
        -1.413792554, 0.6136673474, 
        -0.3500285434, 0.3931897044, 
        0.5746505822, 0.3699881693, 
        0.4974595156, 1.513375352, 
        -1.335147142, 1.746155342, 
        -0.8341090422, 0.6297120318, 
        1.448015923, 1.324021461, 
        3.139743251, 1.199997504, 
        -0.3680832461, 0.783911654, 
        2.650390571, 0.3452096904, 
        0.6405372558, 0.6961177246, 
        -0.7167404798, 1.337146131, 
        2.582314431, 0.7213189578, 
        1.526483155, 0.3752569121, 
        0.105609169, 0.6608843361, 
        1.084244656, 1.265979298, 
        -2.797539484, 1.255033283, 
        1.137579423, 0.03530793264, 
        0.6736675246, 1.226553283, 
        -2.154387207, 1.260810667, 
        0.2617156765, 1.263202533, 
        1.649834905, 0.7564493943, 
        2.125757158, 1.240334407, 
        2.990683077, 1.494847905, 
        -2.473159616, 1.347972648, 
        1.160097607, 0.6638900702, 
        2.451407412, 1.416501749, 
        -2.578728633, 0.3330080419, 
        -0.74292082, 0.9770693758, 
        -2.920672276, 0.9140469309, 
        2.909783572, 0.9349319181, 
        -2.560385193, 0.6800290607, 
        -1.450128672, 1.143470666, 
        -2.278352201, 1.621522753, 
        0.416073851, 0.9701659329, 
        -1.036075278, 1.204814766, 
        -1.374371476, 0.2946487169, 
        3.138329865, 0.6077840455, 
        -0.433062949, 1.493507272, 
        -1.28443167, 1.429320293, 
        2.755876271, 1.256119752, 
        -0.09223092737, 1.320849927, 
        -2.01346052, 0.5794601756, 
        -1.815925781, 1.205973284, 
        -0.3954539555, 1.137818144, 
        2.467363107, 1.055406946, 
        -2.507095825, 1.014600356, 
        1.737830117, 1.081360474, 
        -1.177142012, 0.8978753703, 
        0.1721021102, 1.594505986, 
        2.101365828, 0.9100453678, 
        -2.123030872, 0.9187342946, 
        0.9058338032, 0.9691593867 
      };




      const default_type electrostatic_repulsion_300_data[] = {
        2.832910411, 1.21211455, 
        -2.74511538, 1.363952022, 
        -2.204084013, 1.425059005, 
        -2.148346504, 1.004302434, 
        2.251025375, 0.6174449251, 
        -1.786980409, 1.024014087, 
        2.481189158, 0.6889487595, 
        -3.026542367, 0.6217626872, 
        -0.1563077565, 1.002601793, 
        -0.4647931006, 1.301328499, 
        1.069159292, 0.2467513039, 
        1.490547947, 1.313067057, 
        -1.609622922, 1.084310198, 
        -0.0004986942567, 0.9284414331, 
        0.6780965978, 0.6321788036, 
        0.2064533907, 1.440152241, 
        -0.1005703034, 0.3273867762, 
        1.890696276, 1.510135764, 
        -0.9020555768, 0.810401083, 
        -1.037187785, 1.276317725, 
        2.510108617, 1.130408667, 
        -3.019306162, 1.230113421, 
        -1.478787467, 0.8400208601, 
        2.961926464, 1.107880087, 
        1.004868663, 1.298490352, 
        0.7383696941, 1.170000081, 
        1.238613461, 1.713432069, 
        1.592726689, 0.7241099974, 
        3.045189314, 1.574862216, 
        -3.120725891, 1.483623564, 
        -2.724138463, 1.216574225, 
        -0.6488243793, 0.5468382434, 
        -2.304077619, 0.604577541, 
        3.116144069, 1.171023784, 
        0.5200311385, 0.5074509463, 
        -0.1776445613, 1.326926147, 
        1.722052153, 0.8318688419, 
        -0.7708479928, 1.354721326, 
        3.013127399, 1.421374167, 
        -1.994898461, 0.3406173931, 
        -2.879022586, 1.293394538, 
        1.554943994, 0.3202461057, 
        -0.3720471332, 1.535812283, 
        2.079096701, 0.3193853107, 
        -1.137598729, 1.013421277, 
        2.305937572, 0.9223543757, 
        0.568358547, 1.578181919, 
        -1.642685525, 0.9302839417, 
        2.501254221, 0.8473314642, 
        -1.971637726, 1.288389796, 
        1.328209573, 1.306525472, 
        1.408565095, 0.6144164165, 
        -2.049098408, 0.8688347278, 
        -0.05969996249, 1.413143868, 
        -1.844636682, 0.8829552164, 
        -1.304360476, 1.072348115, 
        1.662334937, 1.33491501, 
        -2.156525364, 0.7335925293, 
        0.4607724913, 1.477721271, 
        -0.01442374758, 0.7753128409, 
        0.05482592601, 1.501835338, 
        -2.842599666, 0.9937532989, 
        0.6782082395, 1.305091242, 
        -1.530444363, 0.5420175914, 
        2.861469444, 1.364292405, 
        0.7067737669, 0.3690864835, 
        2.337695953, 1.085975307, 
        2.706124032, 1.312128011, 
        -1.839264222, 0.4869958516, 
        1.681673207, 0.5769940073, 
        2.67207084, 0.7760403202, 
        -0.01059485785, 1.090313816, 
        0.4215118976, 0.6561689907, 
        -0.8421832358, 1.077942855, 
        1.085448462, 1.165126191, 
        1.191306788, 0.709828936, 
        0.7193991674, 1.572807371, 
        -1.210876423, 1.479084373, 
        0.4466357116, 1.076916227, 
        0.8528047789, 0.5016712981, 
        -2.025469163, 0.6036329164, 
        2.752250827, 0.9040064257, 
        -2.6085475, 0.7815756692, 
        0.6239088671, 1.047542499, 
        -2.79749403, 0.6913676339, 
        0.9445314904, 0.6396550135, 
        1.458240988, 0.4660430908, 
        -2.811322004, 0.8466080623, 
        -1.064787582, 1.432682632, 
        0.2379422876, 1.279081318, 
        1.389657788, 0.7658180314, 
        -1.474407133, 1.282913028, 
        -1.465773555, 1.425868537, 
        -0.6511385683, 1.471768729, 
        -0.2993375131, 1.077105211, 
        -0.03630640307, 0.6255265495, 
        2.423365383, 1.378968033, 
        1.558507571, 1.447470351, 
        -1.462844011, 1.141840835, 
        -1.239721608, 0.4772513637, 
        -0.6773458919, 0.7804795558, 
        -2.287459848, 1.28638671, 
        0.569910669, 0.777236151, 
        -1.900837718, 1.152842986, 
        -0.7748140099, 0.9240593031, 
        -0.9187001443, 1.39079111, 
        -1.621609685, 0.2381382959, 
        2.58089914, 1.416290038, 
        -1.106661168, 0.8599239828, 
        1.243305801, 1.437687916, 
        1.180727888, 1.033460785, 
        0.3181295082, 0.9668715249, 
        -0.06310447498, 0.4765729285, 
        1.837084154, 0.7003090114, 
        -2.130229143, 1.284494385, 
        -1.563297858, 0.3903004688, 
        1.092263032, 0.90440959, 
        0.7876927647, 0.7663029724, 
        2.547380636, 1.273576138, 
        2.577018549, 0.2384208894, 
        2.850058144, 0.09955760825, 
        0.2776141307, 1.1229415, 
        0.5116196487, 1.332459251, 
        1.015919787, 1.574789947, 
        -0.4042572656, 1.681896261, 
        -2.44544071, 1.295991185, 
        0.3626128999, 0.8103410101, 
        1.007613126, 0.779002203, 
        -2.515530393, 0.4804682132, 
        -0.5187651881, 0.6705736361, 
        1.834622232, 1.369508879, 
        -0.8437098778, 0.4337077459, 
        1.978669178, 0.5751224243, 
        -1.424701953, 0.06917390096, 
        -1.463090842, 0.9895237278, 
        -2.860260824, 1.456311155, 
        -0.7388212471, 1.20212028, 
        -1.285830779, 0.7709172196, 
        -1.688873575, 0.7817859985, 
        -0.5935019503, 0.314154943, 
        2.106573129, 1.29755113, 
        -2.303284614, 0.1873976217, 
        -0.8893622886, 1.235669114, 
        2.495674418, 0.5374548213, 
        -2.698672249, 1.49816587, 
        2.725985273, 0.6359006202, 
        2.887062397, 0.7808329911, 
        -1.546827231, 1.942372946, 
        0.3514024933, 1.37731788, 
        1.641689698, 0.958130962, 
        1.317058595, 1.575223377, 
        -0.3373381026, 1.390232552, 
        2.612637864, 1.55837929, 
        -0.672506152, 1.046671362, 
        -2.865989146, 1.141513944, 
        1.818620348, 0.181910502, 
        1.16272067, 0.5491598367, 
        1.888452529, 1.115921467, 
        -0.1585830655, 1.164810295, 
        -2.560759144, 1.181570618, 
        2.892220217, 1.514660665, 
        2.383454269, 1.233520288, 
        -1.610114573, 1.406304316, 
        2.21872195, 1.190267314, 
        -3.134630214, 0.4817619796, 
        -2.993655476, 0.7786292516, 
        2.193004223, 0.4660824923, 
        -0.4947538648, 1.028850845, 
        -2.803442977, 0.5348464929, 
        -2.183980289, 0.4676591963, 
        -1.807531345, 1.296157179, 
        0.09011459489, 1.34529017, 
        0.2168012355, 0.552225771, 
        2.673610191, 1.162048539, 
        0.189036651, 0.7060285858, 
        -0.03041700312, 1.25365758, 
        -0.6200889758, 1.325368762, 
        2.295732283, 0.7732012654, 
        -0.9615514424, 0.9629977396, 
        1.724236704, 1.472115801, 
        2.056894646, 1.146662488, 
        0.9119715726, 1.165347221, 
        2.00452577, 0.9946875306, 
        -1.163569752, 1.168112177, 
        1.401122748, 1.443695427, 
        3.104779566, 1.018113979, 
        -2.456180444, 0.3325861891, 
        -1.9763898, 1.56717627, 
        1.390681112, 1.714067423, 
        1.775619215, 1.23136107, 
        -0.215043731, 1.477494271, 
        0.5005650593, 0.9270638765, 
        0.1676854336, 1.593049538, 
        2.305766378, 1.487497239, 
        0.6227146792, 1.440968844, 
        -0.3136084408, 0.5765043079, 
        -2.253308928, 0.8708885791, 
        1.4186025, 1.175389703, 
        -1.50191445, 0.6914910009, 
        0.118425973, 1.183144662, 
        -1.750899093, 0.6346324164, 
        0.9935954328, 1.034089034, 
        1.930783106, 0.8422226779, 
        -2.819530622, 1.602796121, 
        2.968898396, 0.6055606566, 
        -2.510781235, 1.436621153, 
        -0.2440180225, 0.7146578925, 
        2.962216197, 0.3485001896, 
        1.481485574, 0.8938483896, 
        -2.355476857, 1.427779336, 
        -1.326157252, 1.373285803, 
        -1.099116768, 1.586150528, 
        0.276940008, 0.4000588264, 
        -3.016952487, 1.077196632, 
        0.8068446545, 1.036033042, 
        -1.967446472, 1.008602606, 
        0.9340550343, 1.435050644, 
        -2.604152821, 1.330192986, 
        -2.857751492, 0.3854054916, 
        1.088335949, 1.434972021, 
        -0.353620567, 0.935265291, 
        -1.005484813, 1.119053813, 
        -0.5754532629, 0.9022833725, 
        2.125626026, 0.8743942664, 
        0.8551725856, 0.09946507294, 
        2.466658736, 0.9861454111, 
        -1.065040368, 0.7092429288, 
        2.932065366, 0.9461806989, 
        1.712085819, 1.094846898, 
        -2.454818321, 0.8914308479, 
        1.129606523, 0.3965596366, 
        -0.8014930137, 1.505035935, 
        -2.511528461, 1.036822988, 
        2.794908881, 0.4831137974, 
        3.135588276, 1.327359699, 
        0.6923309363, 0.9057827073, 
        2.985972513, 1.26620029, 
        -1.35847526, 1.530259933, 
        -0.9930820929, 0.5636921299, 
        -2.392478663, 1.154152808, 
        1.522201845, 1.060647972, 
        2.153099327, 1.447106597, 
        1.355855539, 1.020889178, 
        -0.4294951078, 1.16043297, 
        -0.8112917019, 0.6660442728, 
        -2.69114299, 1.073167031, 
        -0.9604950696, 0.2027712467, 
        3.083999858, 0.7279084433, 
        -3.002227432, 1.389472551, 
        -2.22653226, 1.144698717, 
        2.075010695, 0.7231111118, 
        2.175485406, 1.032920384, 
        0.8422612475, 1.299027344, 
        1.826448715, 0.9713631715, 
        -1.272827977, 0.6229774124, 
        -2.062682237, 1.144821661, 
        1.944715153, 1.260164652, 
        -2.743962874, 1.915140215, 
        -2.388935599, 0.7466681265, 
        -2.361888158, 1.706759535, 
        0.8889768777, 0.9038757515, 
        -3.008254805, 0.9275289509, 
        -1.317745192, 1.224116549, 
        1.823504987, 0.4400858514, 
        -2.565795661, 0.6308614059, 
        -1.626896793, 1.259954901, 
        -0.6831984006, 1.61734329, 
        -0.9502034716, 1.54358224, 
        1.257063922, 1.165787745, 
        0.867601728, 1.574827054, 
        -0.1815315567, 0.1766637885, 
        -1.5224926, 1.558299787, 
        -1.920673206, 0.7427644488, 
        -2.05383815, 1.425724978, 
        -1.293269388, 0.9205186701, 
        1.998216504, 1.405230931, 
        2.51071955, 0.384770373, 
        0.1476508105, 1.022508571, 
        1.271921602, 0.8816492104, 
        1.167386076, 1.299387241, 
        -0.4974579947, 1.441891468, 
        -0.4167658657, 0.4419641864, 
        0.4240045867, 0.2507420401, 
        0.1718848515, 0.8622683095, 
        -1.148908852, 0.3379573252, 
        -2.976449663, 0.2375465318, 
        -1.182483732, 1.322966996, 
        -0.3004018302, 1.242825303, 
        -0.5856199546, 1.17685907, 
        -0.1922746014, 0.8558516864, 
        0.5653267258, 1.189673224, 
        2.632998793, 1.006878133, 
        -1.740965097, 1.166705435, 
        3.092569002, 0.8700702716, 
        -2.329885664, 1.011896463, 
        -0.4253251876, 0.8005358047, 
        2.265511385, 1.339200324, 
        1.47106441, 1.582903696, 
        2.802135393, 1.057963848, 
        -2.649071, 0.930030914 
      };


      const default_type electrostatic_repulsion_5000_data[] = {
        0.524175467449244, 2.238539642669756,
        -2.72884985185667, 0.7120315527111524,
        -2.40311066905232, 1.358498999858158,
        1.37112915617893, 1.544792250379456,
        -1.8935884268471, 2.059528981889526,
        -1.54660001284101, 1.281825089029425,
        1.02020605960177, 1.638215303750972,
        -2.24010114798159, 1.813668512789725,
        0.55350145981975, 1.444443429069571,
        -0.688458876175647, 1.568548205889883,
        -0.580020336092012, 1.734553326094047,
        -1.5093308497381, 2.630097538023533,
        -0.525258196282174, 0.9980536155372287,
        -3.11510134550952, 0.3282173524796793,
        1.12597102337648, 1.940318938248304,
        -2.31851441872365, 1.467779933985425,
        2.21973764871671, 0.6949059693859256,
        2.53380361247678, 2.372353839370859,
        2.37577303333450, 2.40147237297371,
        -2.31194948817940, 0.823812774741998,
        -1.64433104614531, 2.628175847102613,
        -1.14244790502415, 1.357219753113384,
        2.15461998609426, 1.522680461026802,
        -3.13879582919430, 1.921153885630481,
        -2.4481374228519, 1.161716650196414,
        2.60351667877881, 2.493648573008138,
        1.56578326958684, 0.5304046904475053,
        2.22328340613110, 1.091723565677557,
        1.85347307027088, 2.501553900243714,
        -2.07055555447873, 1.802906149104795,
        3.11535959092602, 2.777826100220957,
        -0.565374464620566, 1.015032532649162,
        2.49112497598798, 2.348647591570767,
        -2.17046403064688, 0.9287367054837119,
        -1.79218461397616, 1.398716983638474,
        -1.75182791179377, 2.334318307782654,
        2.78842285286153, 0.5806542011879384,
        -1.2129154578804, 1.506542400591993,
        2.56787405427069, 1.967837537864612,
        1.74486675492538, 1.309013127079351,
        -2.79261929650595, 2.353278539409791,
        -2.2374536570332, 0.7345396217316073,
        1.16569795195570, 1.241231397450529,
        2.26588910688387, 2.120088943952898,
        2.02051645750888, 3.038458701037132,
        2.85674838943727, 0.2966178862324854,
        -2.10571954952059, 2.518703247992468,
        2.27323177749267, 0.5776465340991583,
        1.69096700898446, 1.434343186601274,
        -0.0526072390444674, 1.673552542667662,
        2.99952239843552, 0.9837514998054121,
        2.28904690670853, 0.4465073467650362,
        -1.39325385545166, 0.8975480102071707,
        -2.58543815781853, 1.763966578598115,
        -2.51456933822133, 0.4711947231386517,
        -1.80797056879428, 0.8046664750414195,
        2.88453270385950, 0.8846173909877487,
        2.88831493616556, 1.964854978863743,
        0.734122915210, 0.8142892512194566,
        -2.42213660108085, 1.893335551765173,
        1.70913171447181, 1.566560395135253,
        -1.64284893459158, 2.165541780255592,
        1.00552099636247, 1.326723584256712,
        -2.83307134743982, 2.858566190489154,
        -0.424493353994995, 2.614352489785644,
        -1.10646630304297, 2.792785586212713,
        -1.45865114905199, 1.805185738339691,
        1.58951681231408, 0.905466271045437,
        0.674439653432553, 2.525838107416437,
        2.24955302802358, 2.351843001345913,
        -1.37214798718789, 1.38409256692613,
        -0.290665895972052, 1.715853459930126,
        -1.12936307865940, 1.222373297747191,
        0.258983817149794, 1.53982146616509,
        -2.64402583041204, 1.730301882355694,
        -1.84813699769941, 1.967102408364858,
        2.79729354109029, 0.7713700884323603,
        -2.43893419575469, 1.373465243290325,
        -0.963512578043893, 2.419914445556275,
        -1.94724235397511, 0.7038859380990768,
        0.0227506527666563, 0.734452680464851,
        -2.44080376781804, 1.927428324209896,
        0.7674226709787, 2.226309807839974,
        -2.64752958956384, 1.464659938286318,
        1.06253530748924, 1.684728791214778,
        1.9193986351530, 1.324138711337949,
        -2.9360495607679, 1.439607995132813,
        -0.219021130289748, 2.199254465579926,
        -1.80404174887997, 0.4179229684471249,
        2.58639598656805, 0.886074956242632,
        -2.84078678791968, 1.471243423810118,
        -3.10266120072787, 1.622668407125225,
        -0.641301472402185, 1.166378280818268,
        1.81095106700158, 1.383396792678352,
        2.12867420086562, 1.810378847690254,
        -0.989100780069530, 0.8847896532109918,
        -0.452924838245537, 1.706591023671066,
        1.61958782237633, 1.526953530999325,
        3.03992013786979, 1.188067893830935,
        1.51637294127246, 1.168068723893394,
        0.966530398541571, 1.513386891508304,
        0.707936808553942, 1.451172357702536,
        2.86202615503912, 1.995011518127568,
        -1.43176887528696, 2.684749137877945,
        -2.18128095110892, 1.453568558101556,
        -2.00800583113777, 0.5169932892401276,
        -1.76299478831180, 1.495818779159271,
        -1.06364021531445, 2.660860745229887,
        -2.74316488387794, 1.630815234506507,
        1.53238150290137, 1.956763026553431,
        -2.30626495971355, 1.646399383685965,
        0.223891014558196, 1.669217245984938,
        -2.41191703432092, 2.721292891295708,
        1.09866949932768, 2.102946311591855,
        -1.45423269996228, 2.305470016745757,
        2.32725207129938, 1.367155209359525,
        -0.954701166247831, 1.458137041980707,
        0.917689904527517, 1.426823082854743,
        -1.89606828651310, 0.4295953421589023,
        -3.10185083148857, 2.444886546841542,
        0.262471274456554, 1.669199229696265,
        2.01027286761057, 1.231842241793486,
        -2.34676217687514, 2.387751124176276,
        2.97942974918534, 1.90903568778511,
        -1.64975529647769, 2.228487861033519,
        -3.04687056510402, 2.086264966347033,
        2.32032880356778, 1.016378774293505,
        -3.11599198517207, 0.5626086138549763,
        1.26241467838106, 0.7119200924566571,
        1.89647205300148, 0.9505847229242433,
        -1.92166617965636, 2.79663790339276,
        1.87201363676729, 2.279765077537069,
        -2.33184845108434, 0.7220620732167153,
        -1.87289764968582, 1.795477150247132,
        2.70136135179857, 1.535835206833684,
        -2.91436495714287, 1.295611506206135,
        1.96842454500302, 1.277911878306913,
        -1.67877373825644, 0.2124923127647189,
        -1.91692497743647, 0.2488664077398333,
        1.41839569729922, 2.077774109142212,
        0.647674043398416, 2.63452454473104,
        -0.714677015122601, 1.318820162598354,
        -2.62831060611576, 1.630550657180993,
        -0.372144785314916, 0.6578117134126942,
        0.396149915140633, 2.594368951499989,
        -2.22780565534440, 0.3838416138558138,
        1.30841744318455, 0.5487140500748786,
        1.38138436814378, 0.7699911054083426,
        0.920474766779674, 2.025286350858444,
        1.48795558831437, 2.086816027077828,
        2.74069625622956, 0.107733450843783,
        -2.30370635482757, 1.568686479975355,
        -1.57486866326300, 2.203214524459922,
        -1.57499275371852, 0.5996441019198371,
        1.26180828742554, 2.075292999155429,
        2.51182831684618, 0.5282060342369165,
        -1.3444692026439, 2.133565377800464,
        -2.11013509723419, 0.7810977195443601,
        0.134522628516554, 2.103443971904516,
        -1.23389712616556, 1.036127529848782,
        0.159807512713114, 2.495339656560403,
        1.7596442152872, 1.17435887661629,
        -0.371355031957204, 0.6950990331200863,
        -2.51773727672274, 2.062399033160361,
        -1.05242683702741, 0.7216766735685038,
        -2.0272658991585, 2.21070042830977,
        0.618296845805271, 1.947157918151482,
        -1.72076189603784, 0.7847065186850261,
        2.03306021078794, 2.420335652359686,
        -2.89442511247096, 2.628362095465852,
        -0.127744880956909, 1.164020668468469,
        2.74090702113718, 1.086614198191883,
        -1.55746457271000, 0.1835545396994642,
        -2.93817665809216, 1.504701638471791,
        -1.15998471705409, 1.013984149844915,
        -1.30417037882810, 0.6768360091121581,
        -2.24352786754356, 1.228528028893773,
        -0.0344055947804715, 1.357961584817017,
        1.1769447125730, 1.341647856461803,
        0.183734756496609, 2.265370522538497,
        -2.68604663435260, 1.597799062056354,
        1.47129771945991, 2.165310827406283,
        -2.70397301592631, 0.185854352218253,
        -1.25633974873320, 1.804647678093383,
        1.47982936121993, 1.386380801163316,
        0.512648725348547, 1.970239054011118,
        0.125954060630191, 1.639865806269531,
        -2.18964956309218, 1.142182875201618,
        -2.42012715551281, 2.193419298513239,
        2.09817463944947, 2.840931240675951,
        -1.29645722575681, 1.582960014627728,
        -1.15177785976692, 1.319125028281626,
        -1.348579430563, 1.058729860139194,
        -2.46607756461557, 1.828198047459791,
        0.880847836960774, 2.013058868663713,
        2.83338550517410, 1.664599255355071,
        2.84490791990213, 0.7510784056221255,
        0.841213616892325, 1.787462896596559,
        0.3123643199014, 0.6443117825803055,
        -2.23878213667599, 0.8753442624313919,
        1.01314116591137, 1.289058254130308,
        -1.17653881349828, 1.693326793023757,
        -2.81705450444362, 1.982950406122239,
        1.6371532392273, 2.601071961388729,
        -0.44834705093379, 2.441161493155814,
        -1.79578522948597, 2.112754485346097,
        0.306035883442350, 1.193343443862499,
        3.09934299822596, 0.8848744342677841,
        -2.60594698997001, 1.730520888195396,
        -1.47841225809971, 1.512218403263869,
        -0.555505216159613, 2.603537168571307,
        0.465501047468329, 0.9838061554670871,
        2.20787869489517, 1.437048039213865,
        -0.20288702231764, 1.236607167435692,
        -1.50511711003340, 1.413917188542724,
        -0.533368709721682, 1.647327232036494,
        0.0385312519914157, 1.997686732422582,
        2.70940935932571, 2.538463395872665,
        1.98476179854138, 2.226666540756066,
        2.74344032418576, 1.974915674471005,
        -1.37529896705521, 2.034811365478346,
        -2.09916386852857, 1.827820918174413,
        -0.0729109843028408, 2.4944800432492,
        2.03802229915894, 2.583682856752742,
        -1.95281092181689, 1.351318476522452,
        -2.31670665957833, 2.421014160562729,
        0.878281288104923, 2.330537765615967,
        1.66228718082483, 2.089632902284907,
        0.824035264077585, 1.392847827006081,
        2.87249499240028, 1.29052419330614,
        1.555227641259, 1.100962881107292,
        -2.16722183434913, 0.6889207553298379,
        1.4848972708261, 1.320477564963726,
        0.930730962694179, 1.713469981196699,
        -2.39799684319636, 1.572564927021805,
        2.02605042749905, 2.119048191404718,
        1.33327084136116, 2.095904301512531,
        1.28983929643000, 1.073148159941357,
        2.53720717166247, 1.653583640956186,
        -1.54510361636194, 1.747524556898643,
        0.896784014506468, 2.088629831950893,
        -2.68916124089922, 2.653980145226879,
        -0.72444395762258, 0.6112366439500501,
        -2.81199791793474, 1.08146149407032,
        1.02634090787691, 0.6887613878503873,
        0.202573029374187, 2.626743224290976,
        1.68109157768784, 1.498339883698532,
        0.482218427576226, 2.141584107651831,
        -1.91889995415077, 0.7992972786020385,
        -0.249213672401471, 1.625133069023547,
        -0.0623178379983421, 0.9571918621921716,
        -1.09189364502108, 2.466408969797153,
        2.87868841124253, 2.02830499848945,
        -2.98742773699703, 1.300477716903697,
        2.00838453162626, 2.550002157293002,
        2.426175064544, 2.052032821890527,
        2.0473291247663, 1.908286363808526,
        -0.91339600402582, 0.7558218454359509,
        -2.80862444247348, 1.922651355140369,
        3.02010536345162, 1.91253795653785,
        1.44323999721907, 1.184535663976915,
        -2.74436069250165, 1.566176127722978,
        1.87638446747530, 2.176123524731335,
        1.45261240471854, 0.9816543106213274,
        0.663449161325689, 2.450353349252803,
        1.19395096193671, 1.26745030020693,
        2.1428266571966, 1.066872423530292,
        -0.529186346841820, 0.6858658716762057,
        2.78917125655825, 1.181023414917811,
        2.16693660735288, 0.5443160404326677,
        -2.53410441869576, 1.308916421346968,
        0.959069550988647, 2.175548987590898,
        -1.19917545299261, 2.185019487713007,
        -1.8552082073262, 1.829754264862353,
        0.915483798058933, 2.835989011282448,
        -3.02861201740000, 1.401863892647849,
        1.62536009498850, 0.739216938844598,
        -1.72963236862931, 2.680382202281405,
        -2.71916675619980, 2.689518967710323,
        -2.43534336534799, 0.7517154039360399,
        0.198866061133425, 1.008926660822235,
        0.907607818475381, 1.775868647346969,
        1.98228786081886, 2.515791746517044,
        0.934214801897473, 1.532926002115789,
        1.46962473164786, 1.685613116094274,
        -0.146498439895980, 2.120828454056307,
        -2.32300600090260, 2.484730995072264,
        -1.16707548448175, 0.7243346625705431,
        -2.40567715055516, 0.5587640639226243,
        -1.16897320471702, 2.214297448444384,
        2.80610887365289, 2.277357636506365,
        -2.36985307422568, 2.421464372360127,
        -2.77210897009172, 1.326978656025209,
        -1.89893331511230, 1.207202654002997,
        2.93674796436573, 0.7906007472176725,
        -1.40546043846879, 2.796556568344681,
        0.720245197792597, 0.6733427421595484,
        -0.754031369791437, 2.592012315064051,
        1.77213474643325, 0.1975583140491434,
        -0.705935512892122, 2.7199798588366,
        1.30766254381860, 2.55622813988615,
        0.358084196029573, 1.638980774295804,
        -0.41789164228488, 1.710327897258552,
        -3.00274658422014, 2.089903537215996,
        2.08117967701500, 1.546839480967113,
        -1.59095990459496, 2.104782344599016,
        -2.02901892789023, 1.371424124160331,
        -1.90580399042109, 0.9967884189830624,
        -2.92841933523108, 0.3515138380455241,
        2.17815830444014, 0.9004745651001271,
        -0.425398638654989, 0.67811826526166,
        -0.51234677399657, 1.305815549883362,
        -1.11484613637647, 1.330918188017121,
        -2.57976614667456, 0.7235612256577444,
        -1.09381529855254, 1.755034710663157,
        -0.308151319208550, 0.9229375668206391,
        -2.49740848702413, 2.028957083471815,
        1.04218172545961, 2.057752710972248,
        1.08404396309705, 2.067434247731562,
        0.367457845721652, 2.043033261321735,
        0.684625827114249, 0.7388681928480546,
        2.3054516603236, 2.347436546685938,
        -1.68490838951796, 1.991555672065694,
        1.2709359059728, 2.617319074308287,
        1.99746389303089, 0.3849861877870877,
        -2.54021569627352, 2.809591004875598,
        0.915238385241663, 1.08916751639961,
        2.80922745827563, 1.042381274679121,
        1.67075414781836, 2.707002333576824,
        1.13166633004780, 1.670716514281917,
        0.132556474309560, 2.72091971819783,
        -0.240346133315686, 1.909657807300072,
        -0.203435416485626, 1.07219882505125,
        0.92346229473906, 2.643360446493708,
        0.507528843083060, 0.4589425433339915,
        2.96986895965921, 0.8875349768182557,
        -2.74088832027697, 1.69599280439046,
        1.78157044275700, 1.950734041951321,
        1.35834175750734, 0.8663248050944999,
        -2.10463326787304, 2.847965949002047,
        1.15988710885431, 0.933786384769595,
        2.24775861483202, 1.983169758257786,
        -2.88628937393416, 0.8355142749770568,
        1.20670350365455, 1.439428848889067,
        -3.02065146924932, 2.822293417392962,
        -2.03951003574797, 2.091530920827141,
        0.095911948727249, 2.488916219641736,
        0.320966233075414, 2.596485215951222,
        -2.59183307456140, 1.496315511747266,
        1.80366954029254, 0.9416459224967849,
        0.549865692792697, 1.988400843596001,
        -0.00715568771869003, 2.914723980304625,
        -0.333488034980013, 1.808482747107519,
        2.18918688340509, 2.110443710033941,
        1.82357015422209, 0.3681686646349486,
        2.53545246153197, 1.988114012024395,
        0.759046621167389, 2.715914106179373,
        1.37578082701345, 2.086953323265823,
        2.9732303410036, 0.2784553965736906,
        -2.63985492239919, 2.581472758572382,
        0.0110249812345534, 1.827895641164717,
        2.81648853732155, 0.182213164458995,
        2.68666502549165, 1.884292027422552,
        -2.90203420415017, 0.7717465817810146,
        -0.355493874614250, 1.390894416853165,
        3.02886284303476, 0.7972084082135269,
        0.657218695776967, 1.279290996645337,
        -2.26900615929582, 2.353073692201595,
        1.87896965929620, 0.5667071122411679,
        2.48002398716810, 1.068432997928294,
        -1.9977756632656, 2.822707912215149,
        0.530209328467839, 0.7363888500296926,
        -1.40862913535729, 0.663100102951518,
        1.86354742226192, 2.635727707369401,
        1.97316735540219, 1.028718768989626,
        2.33994853063946, 2.163445037143338,
        1.28824312047136, 1.605551342121691,
        -2.44998181339828, 1.449665007380973,
        -1.15452087665205, 1.632009297111144,
        0.804327445108462, 2.931332056989675,
        -0.944235933279111, 2.342610613269777,
        0.0590566631571340, 1.122450334069232,
        -3.01176675045343, 2.156284784359345,
        -2.5147018970910, 1.56381283363595,
        2.74847345474118, 2.227431454259294,
        1.40345726139251, 0.1154700173862162,
        -0.782101262415084, 1.611990838003026,
        1.65672246324824, 1.201927342772052,
        -2.14381903160285, 0.4407128361561859,
        0.295638909946014, 1.963522748220651,
        2.11545518053297, 2.232479699194951,
        1.57410624867596, 0.7198890002872578,
        -2.33541059867758, 1.846861015541978,
        -2.58991666665062, 2.609044912654444,
        -1.73625479370146, 2.154965658734648,
        1.33673836448258, 2.198375335859635,
        2.441385433773, 1.473078889051031,
        2.9842624042635, 0.5262255375807237,
        1.02015322353033, 1.426782374321866,
        -1.68154240630563, 2.493233091803212,
        -0.671984887897203, 1.935176937804606,
        -1.48211611783511, 1.446355498643309,
        0.514202860678641, 1.047190790828909,
        -1.09694350597933, 1.582424166362011,
        -0.893349516516876, 0.1310395699829167,
        -0.665479074600924, 2.450310044139229,
        -0.825449246197385, 2.451568831504424,
        2.53788947341899, 1.794249001161544,
        1.90001017660666, 0.7831673439946977,
        -1.35846229081176, 1.828942470900103,
        3.07944992563414, 1.24273352318609,
        -0.514920041444119, 1.723121651147854,
        2.98917493531220, 2.008266813902893,
        -0.395351023299596, 2.015926709634738,
        0.124334857432494, 2.622093747823503,
        2.64883389520790, 0.9775715452190208,
        2.68408671463604, 1.749435568951984,
        -1.42264843801202, 1.218968804397457,
        -1.4792678382813, 3.054355096849724,
        2.7526853746192, 1.411459609219438,
        0.00383734488055268, 2.2686231844487,
        -2.32847459072417, 2.021260764793479,
        0.361284804135521, 2.62779128022139,
        -2.68839290747090, 1.403570191525715,
        -1.6373888418628, 0.04787441975905251,
        1.01191632269395, 1.46264145570235,
        -2.56289913226679, 1.864062333280214,
        2.41291706630195, 1.446559721509121,
        -1.04710593942087, 2.594936672249403,
        -1.76749557804491, 0.1785687924530826,
        2.06092952852063, 2.010169287568353,
        2.66251832173447, 1.055048603362117,
        0.218741498615091, 1.476145794071756,
        2.3991397452892, 1.045760136621783,
        1.93759980968853, 2.234778943542306,
        -0.3111482419583, 0.3336172388820167,
        0.61086720501979, 2.434203184399378,
        -3.12174182623840, 1.820213008310148,
        0.0927949144300742, 0.1533687208948577,
        -0.320278056253756, 0.7521570986828632,
        -1.85747372597613, 2.826855489245968,
        0.158987910377732, 2.235659761433912,
        -2.30944330080924, 1.609281690349107,
        1.66102949100790, 1.134646345440885,
        -1.75918935626720, 0.6749886812339865,
        -0.141008476640027, 2.442925088445799,
        -2.82284258128531, 2.047743869974562,
        -2.37714396880132, 0.05637097352010936,
        1.08144204161103, 2.717961089703669,
        0.331433180144044, 1.984656950160971,
        -2.46980745074618, 1.761192275614575,
        1.77812521115483, 0.4798043785384647,
        -0.805822089773910, 0.9408753533920876,
        2.53589649212071, 2.905887058421612,
        2.96425215823336, 1.550056325676531,
        0.0536206055481432, 2.102999456717104,
        -0.470452912666840, 2.265091421461805,
        2.25325041007932, 1.944695065861372,
        -0.134197903589044, 2.977490039139983,
        -0.350072151636071, 1.429238440328802,
        3.01379172142285, 1.320628449973529,
        0.920884947330533, 0.8998899011005441,
        -2.90803885900061, 0.1840493287075007,
        0.403123702821778, 2.177767504866719,
        0.335060683574103, 0.4482702477543246,
        0.219452601277922, 1.539363066507102,
        3.04304179523278, 0.5490475636188352,
        -2.12689712863323, 0.7162037952466065,
        -2.28432795360491, 2.013423862850895,
        2.5198740440590, 1.079407569281079,
        0.00195078172519594, 2.407105397416686,
        -1.09558702596544, 0.9604979548925356,
        1.97291478227739, 1.129107782985478,
        2.76918056814687, 2.085763705150668,
        -3.13192073526648, 1.718764533479951,
        2.97440229389450, 2.434859525318511,
        2.102859439831, 2.268582909892535,
        -2.28794849476755, 1.278823844892993,
        -2.10051052085174, 1.567619740317861,
        0.474379141728867, 1.914073626277727,
        1.71374681921615, 2.612631567948168,
        1.80773110066928, 1.110099703546838,
        2.45151429911245, 2.308007088411792,
        -2.2060475337766, 1.999125845868313,
        -2.14245068032155, 1.951474206433352,
        0.959076246847844, 1.862747727110057,
        2.15894968326763, 1.348289372416912,
        -0.670133621816738, 2.355882565684716,
        0.186183244505167, 1.974678559492004,
        -0.898402340884003, 2.663290576320499,
        -2.16353926219117, 2.012147359463093,
        0.0833569821904658, 1.578910300840098,
        0.570351010902237, 0.4316333772809344,
        -0.831245328576136, 1.700803719779821,
        -0.350522701169847, 2.52311469546049,
        2.398865286845, 0.6457641620464121,
        1.4613086661384, 1.58439028198618,
        2.03750941852165, 0.8700208136194749,
        -2.13320400580207, 1.988399269993985,
        -1.48391258814899, 1.612114281036924,
        -1.19585874683387, 1.98227242174572,
        -2.39198949004202, 0.7749898849971616,
        -1.79124581994050, 0.9803347813661789,
        0.846578047201520, 0.6883670867414183,
        -1.18274735771753, 0.6604222382373823,
        -1.48233348711628, 1.774718067809082,
        -2.92770355419420, 2.529944408890472,
        -1.05234408956549, 1.631771987244853,
        2.12513279358196, 2.327174530997543,
        2.52822102551625, 0.8365357471351215,
        1.67222620783161, 0.7230367537579118,
        2.0563610868574, 1.349398038787294,
        2.33520815630262, 0.8053033155212886,
        -2.54777173755109, 1.059000149577398,
        -0.0599155777041877, 1.257527365565275,
        2.56580538910117, 0.6365769807239761,
        2.41764083133998, 2.205914559316864,
        -0.796615745234551, 2.26117237379159,
        1.719619049752, 3.020304520642772,
        1.62491494834869, 0.7742821235330719,
        -2.8907686697854, 2.072521554052979,
        -2.73779237650876, 1.339311567922511,
        -0.844639245054391, 0.9625450309237057,
        2.4868466136728, 1.426661620162757,
        0.602885752868289, 2.7066532677042,
        -0.896250020178344, 0.6261382357346003,
        -1.5291140868369, 1.71370733850675,
        0.364432631693374, 2.15688604044611,
        2.88666328307583, 0.8465047915211037,
        -2.02852730201559, 0.9042582360171318,
        -2.91557017471521, 1.257851339519067,
        1.82353756295179, 0.7476915621232537,
        -1.84073700359718, 0.3145820616672177,
        -1.95178828805381, 0.08083397723151031,
        1.03578537456630, 2.460931502840431,
        -1.4398082008649, 1.119579281212278,
        -1.52468640947742, 1.118158586059025,
        -1.84874651845544, 1.270828900175907,
        -0.101252670296378, 0.6545176601013397,
        0.157211075433734, 2.198987416027,
        1.01195885313369, 1.011528257630051,
        2.2309598896303, 0.9507068644925172,
        1.09855958387943, 1.227275762071812,
        -0.157556314621426, 1.468984020764491,
        2.69951989330789, 0.4531000596653924,
        1.40294430337611, 2.697552392694863,
        1.53487225749379, 0.8468811710373576,
        1.36249643452687, 0.6958418326733603,
        0.571214396673299, 1.477753507684447,
        2.38436051092365, 1.419981754783366,
        0.435981385818486, 1.57624966582404,
        0.986051851481249, 1.045709835053633,
        2.48995989768730, 0.4924719992380019,
        1.78550979258145, 1.684663688526289,
        -1.22320640133317, 1.953721918842191,
        -1.56708466831096, 1.119433890352514,
        -2.32284788239206, 2.354823161815784,
        -0.240448570992630, 1.551398351772882,
        -0.765605520188988, 1.68497444469037,
        -3.06086118025225, 1.232714580965816,
        -2.40543986335995, 0.852583964017545,
        -2.34179079477355, 0.760501868217931,
        3.1146483930665, 0.5367024151661944,
        2.68406077569292, 0.9535487306777971,
        3.03271909489057, 1.040648754138687,
        -0.025402977501080, 0.2268805645344636,
        -1.21981360328016, 0.9711066662361159,
        -2.18785156919705, 1.490795787179877,
        2.26529001091722, 0.6740216927575221,
        -1.20491877811936, 2.384072008999067,
        -0.554700325411000, 0.8617432342057598,
        3.05379314446716, 1.746440869638524,
        1.51224354926250, 2.405077624690592,
        -0.599599407758604, 0.8807173114383345,
        -2.36397425778609, 1.559799562615567,
        0.38592843322729, 2.822571009465686,
        -2.07534026037763, 0.1173437142589381,
        1.0821894419787, 0.3933223018617715,
        1.9392596155941, 0.8551740844148431,
        -2.20410768059358, 0.9018554088865833,
        -2.88712710114482, 1.086117619953586,
        2.94349530795034, 2.17518294764954,
        -1.1781058710947, 1.247843153265066,
        0.493270883481974, 1.610154752334781,
        0.720161081892198, 0.3825425488421263,
        1.28632179840005, 0.9710731525227023,
        -2.58168454233457, 1.000200317487808,
        -1.3889105936730, 2.980740248712574,
        -2.98747124182904, 1.33610348764118,
        1.347001188468, 1.129819920311053,
        -1.9166177671442, 1.511334760559024,
        2.6277942285837, 0.6481859923728462,
        -2.82151636496811, 0.9284911908055093,
        0.247269271720471, 1.232531895709733,
        0.233154230201199, 1.104575238514993,
        2.94632165169693, 2.863188479858866,
        -1.57396607465092, 2.573273542259381,
        -2.07660304209120, 0.6077879436015586,
        0.365514622598551, 0.3170348806464925,
        -2.42489182282185, 1.260012165380553,
        1.94001733800659, 1.734805104079815,
        -2.49329452158682, 0.885880200139976,
        -2.04269971420948, 1.778119577780056,
        -3.08303344060131, 2.24785124849124,
        2.81695207967932, 1.409077717109167,
        -0.741302183452067, 1.485585954596502,
        1.8693169070589, 0.8145639118271739,
        2.67605515135274, 0.3791039904436348,
        -1.72338063246338, 2.433171856687765,
        -0.0953559637846383, 2.419746903716679,
        -1.00340472749509, 1.545041824210132,
        -1.48463158176758, 0.7902826247357417,
        2.1428913777077, 1.733973484569989,
        -2.50458408508253, 1.002957327048536,
        -0.267250946622811, 0.6983906276168356,
        2.46240730289977, 0.7482167172822116,
        -2.62211571574602, 1.897466701029635,
        2.83575802497062, 2.654326403804779,
        0.299385736946047, 1.604780373130125,
        -2.64794074738220, 1.597398888852414,
        -0.895471989865775, 2.329505605615426,
        1.81046732978866, 2.048289896959006,
        -2.11886167499416, 1.158004921267201,
        -1.11867100239840, 2.308129638934175,
        2.6076817791324, 2.703756183478151,
        -2.5323453465250, 1.663548963398706,
        -1.4491804581866, 0.8468607792520232,
        1.94464636712413, 1.057776089620081,
        1.61923757766898, 2.089240113902462,
        0.793961814615208, 1.36937690710213,
        -0.345525321061325, 0.1448800868335947,
        1.68677552618880, 0.9037372910381827,
        0.435200910062593, 1.180196302966993,
        -1.67851577706641, 0.6336332765439452,
        1.74728276398666, 0.592360619030404,
        2.33627367701833, 1.330120798634025,
        2.92889496662245, 2.241458200054244,
        -0.309155413732959, 0.5254806244457586,
        -0.951352967783493, 0.4915656609386023,
        -3.09993830568345, 1.787826719564733,
        -0.935211620589739, 2.30464294061409,
        2.49779679478161, 2.314647559265059,
        -0.1273243837314, 0.9966826838176452,
        1.06727275283650, 1.022979047295559,
        -2.98245535063210, 1.632436755769534,
        -1.05839716111737, 1.244781755909777,
        -1.84936713108329, 0.6224182068473213,
        -0.136952573486119, 0.164701199123038,
        -2.69196432301399, 2.059231176308183,
        0.707260554914061, 1.559345530117817,
        2.6395299187437, 1.933114687146008,
        -1.19023584359799, 1.042146281378668,
        -2.20212942685397, 0.5714739281653815,
        -2.0614981109790, 0.9754433926498191,
        -1.20434979242622, 0.6953331275955071,
        0.677286008675356, 1.543595036011906,
        1.94145704337781, 1.255229837567387,
        -3.03188436123182, 1.959282421696646,
        -0.17955226967779, 0.5295393291574375,
        -2.39898851703766, 0.8136834110213043,
        0.601762756523153, 1.11200034965717,
        -1.09529927656245, 2.133049053655948,
        -0.82154016227620, 0.830689371419337,
        2.93664208742594, 2.825946250355885,
        0.323055668331269, 2.725433587979993,
        -0.0394506794394426, 1.223057126752347,
        1.80628337839948, 2.527977932467738,
        -2.12337130237391, 1.330105182307697,
        -0.710366715399116, 2.227144046416116,
        0.576544553578524, 1.344278454198697,
        0.931807586739813, 1.352233858250391,
        -1.8164878821375, 1.832438774360164,
        -0.116092005215499, 1.533239204113069,
        -0.681729471768218, 2.487218454615167,
        -2.70963226455046, 2.955680445163373,
        -1.38580404614144, 0.9903271380882334,
        2.71348749473444, 2.002350742761167,
        -2.5866074125265, 1.076981624655266,
        1.73519795836012, 1.825491318783839,
        -1.27432941884193, 1.374603194276667,
        -1.85598856591719, 1.764659912670775,
        -1.35334752635788, 2.487854696472637,
        -2.95002357460530, 1.310459994978773,
        1.13863949578165, 2.010556409718025,
        2.37430728474239, 0.7090074573680472,
        -2.97514958868151, 1.901954380120471,
        -2.90974717024349, 1.733685616906978,
        -1.08321406488501, 0.9963541093687227,
        2.51971328904639, 0.1350501511893672,
        -1.32543799007567, 1.431130202312257,
        -1.97198276741300, 1.700554158336075,
        1.52542318132459, 0.7754630455805167,
        1.67940781414990, 1.989722543296908,
        1.6985711443849, 2.577222417062866,
        1.50564880512801, 1.040493623188712,
        0.393187471029426, 2.465223690853452,
        -1.40320934605819, 1.252646093679578,
        -1.42029609166216, 3.017580018865011,
        2.77775967125702, 1.878640427998939,
        -2.85729214797591, 1.371421543552255,
        -2.73812633040263, 3.056957036818232,
        -2.93543271811461, 2.268310375706918,
        -2.46657783897185, 2.194521643095665,
        -0.822733613574156, 1.14981481673228,
        -2.28894117471202, 1.724204663521736,
        1.02138438252897, 1.251732337086499,
        -1.23352513483916, 1.570293337228269,
        -0.806766979215247, 1.263995471185737,
        -3.04583905673166, 0.7519456136529343,
        -1.08402797172854, 0.6878039268829382,
        -1.2906764033681, 1.442403162891555,
        -2.51600854825824, 1.118216914716414,
        -2.79967357130276, 0.1505433770588635,
        -0.20701304527528, 1.93014560792117,
        2.77608933288254, 1.35480187829941,
        1.14952096286316, 1.609583676915752,
        0.711955393204500, 1.843775354234698,
        -3.0401685331846, 1.759556780118467,
        1.89061675258368, 1.795699375624864,
        -3.12517076692579, 2.017527460230453,
        0.133208046319520, 0.7167789952946211,
        -1.55871648756204, 1.449568312350006,
        3.04728584789966, 1.813993238431664,
        -2.05542486955873, 1.518714988126451,
        -3.04855158773182, 0.9864060405689907,
        1.44399884276995, 1.080780850206509,
        2.65093180980039, 1.899162561224369,
        -1.95505060551816, 0.5731943001331754,
        -0.0333013959423188, 0.08845499030884151,
        0.550391382601136, 1.577960898035143,
        -0.880560333039501, 1.307462111665444,
        2.98609296989372, 0.7742879639949358,
        -0.522253514679180, 0.9597317742914161,
        -1.68868819286365, 2.530657013774927,
        -2.90142429429735, 1.97311390012,
        -1.29855033477964, 0.8943937325582303,
        0.963909408138606, 2.314694697688219,
        -1.31959344066543, 1.194935406330962,
        -2.3298628722457, 2.667140302888887,
        3.02196365582847, 1.676605953912034,
        2.35576539073579, 1.393610752497394,
        2.7336734073077, 2.152509755701841,
        0.580988874765952, 1.013286925368253,
        -1.12809088782763, 2.49291289383166,
        -1.17824320923998, 1.178585334599709,
        -2.07556172088958, 0.4969354902287364,
        0.447291555053888, 2.524562017817886,
        -2.80252758634911, 1.470570385401822,
        0.865144264875654, 1.34163015464085,
        0.575167288590285, 2.743292695426914,
        2.41975522513611, 2.167432358436429,
        1.64213469332778, 1.66161370432312,
        0.796848134217233, 1.948636688832929,
        -1.52708123225988, 2.331769665176031,
        -2.62612181339838, 1.69705896044945,
        -1.80346297106402, 1.665703569516815,
        2.78204291143991, 1.983284644348835,
        0.552424820419553, 2.026452680795797,
        -3.10933835435771, 1.686824953691699,
        0.0603256011151497, 0.7621951433814589,
        0.779918754299282, 1.835376444725099,
        -2.59308959354892, 0.2592575717679281,
        -1.16438436143665, 1.4200095039698,
        1.14763559793392, 0.6960350083436135,
        -0.194390893469453, 1.30164254612799,
        -0.2919312160938, 2.580834600502494,
        -2.28285607976441, 0.5200446221624955,
        2.18993603498956, 1.896906453346914,
        1.08571302864770, 1.126046883835981,
        -1.64702690808353, 1.253440412351288,
        2.13558848656266, 1.772200705967542,
        0.340975019922958, 2.37099245090864,
        -1.2437678599263, 1.705151077937306,
        0.93850569748510, 0.6540403191325024,
        2.8853700774692, 2.129754917920846,
        1.59880766708099, 1.726273226587789,
        1.23257738852207, 2.507724449895075,
        -1.18889989933591, 0.9427491358096827,
        1.92090669696789, 1.496589565665698,
        -1.67501842133070, 2.742834400259423,
        -0.118500966860723, 1.063666006769242,
        -1.05565019190960, 1.457824437287899,
        -2.45731459811949, 0.2707956181826414,
        1.44761487040267, 1.717634991628628,
        1.66356686583279, 2.225970320211195,
        2.84486087851846, 2.254646606107064,
        -3.09620564890996, 1.254939708039509,
        1.06624459687978, 0.9210042701357146,
        0.0980676841782895, 0.7891345695282509,
        0.151215192057132, 0.7817087333900297,
        1.40756385035213, 0.2874647014974775,
        0.578374020408957, 1.891964967520926,
        -1.22819492592420, 2.155353039644296,
        2.52827234195986, 1.832179784815636,
        1.36134539749636, 2.262256888999028,
        2.31812613343536, 1.267509921560001,
        0.880739241354093, 0.7214807570450267,
        -2.48724397033811, 0.8068113902618167,
        -1.95568383708465, 1.974766025431705,
        -2.88657396631499, 0.6102359730100196,
        0.618020866448090, 1.278192746881587,
        2.6606091286706, 0.800772882782972,
        1.87970669684454, 2.075078050216728,
        -0.446335667722978, 0.4903545364183088,
        0.604293101530769, 0.980280398883707,
        -2.16149029422852, 1.030151084558957,
        1.88448967417237, 1.973249142730516,
        -2.78556499530561, 0.5781085157017758,
        2.20208736567379, 1.15562233143972,
        0.944045081594553, 1.962213100953581,
        -0.701921820080347, 2.08341774964323,
        -0.560184786705883, 2.468871284532173,
        -3.11869379886293, 2.95165903564297,
        -2.63254997032190, 0.119873042955241,
        1.88053554363983, 1.905517675511364,
        3.13006462777371, 2.676592264792579,
        -1.16450939166961, 0.4638992784199664,
        3.11747400928978, 1.297159760051741,
        2.05507874739382, 1.836013692900025,
        -3.13529462828287, 1.386924504430167,
        -1.36395354953968, 2.168394511673428,
        -1.07635241153331, 1.520302482874401,
        -2.88129893914963, 2.370909504633218,
        -0.909520360797910, 1.506996917145879,
        2.63025770756848, 2.629127215038409,
        -0.643562208769514, 1.615297348109658,
        2.32610401735405, 0.7280331091498043,
        -2.71646464167940, 2.090185689707416,
        2.42363258546880, 2.63084795828208,
        2.6678930830975, 1.824611614073917,
        1.22795754309227, 1.897980573869346,
        -0.807395743107676, 2.0472794684862,
        -1.25455966505701, 0.8042485682830592,
        0.377627906335470, 1.672334353288814,
        0.256527412391666, 0.86586737078334,
        -0.496481147875490, 1.094257104665328,
        2.70937766871551, 1.3602228528234,
        1.95515129656972, 0.7915573873690561,
        2.98322432580266, 1.378918605745525,
        1.78032714152792, 1.719564738843654,
        0.18514662822240, 1.669902946147377,
        1.85291952614608, 2.044286898918097,
        2.94081996289181, 2.279037529611513,
        1.97237094789485, 1.233654423657606,
        -0.437724603417144, 2.364435726972113,
        2.25964603185093, 2.157709309317035,
        0.30656614645572, 1.346927699665431,
        -2.57447627549146, 0.8441492923196632,
        -0.119528858077752, 2.727073817720148,
        0.153895936246040, 1.177485569469979,
        -3.01819036835995, 2.656181592699565,
        -0.638458669468858, 2.515057589923229,
        1.06335575923597, 1.06328777908811,
        0.405672060124736, 1.085317368306656,
        2.076180995607, 1.228862888505661,
        -0.591690150482885, 2.810295283662535,
        0.53712681372640, 1.07935694414092,
        -0.696662348511065, 1.531837850021037,
        0.478494900921666, 0.5236039930640851,
        2.01599657207905, 1.534358476326045,
        -0.181883105277618, 0.9281744483083836,
        1.36805207796639, 0.8994682380532815,
        -0.317906840169434, 0.2596192133848153,
        0.319692939215872, 1.510018173329984,
        0.170549457432683, 0.9784962028261844,
        2.46477353091752, 0.4569555896244568,
        0.020230352155770, 2.166746582886336,
        2.08317951020355, 0.7420693816095348,
        1.90169346661281, 1.052022462727509,
        2.4159911755966, 1.85819135441348,
        -1.08608795325836, 1.994215474503111,
        -0.0988903393885288, 1.915892091512011,
        -0.855505861788761, 0.1966974881636941,
        -2.99944825898945, 2.225980219871866,
        0.765226252924213, 2.44342340119932,
        0.396101018229687, 1.769027705850029,
        -0.863479629499879, 1.8619827000883,
        -0.188187620931999, 2.786798048945857,
        -2.70873572863941, 2.38743884924906,
        -0.422233489539179, 1.954625913819709,
        2.39004991053724, 2.033788947596448,
        -3.01915394762797, 1.727868579186416,
        0.252373583672198, 2.890480792953461,
        -1.03239137967239, 2.188101283859429,
        2.06049993615819, 1.485081418874797,
        -1.04632984467818, 1.984536803306801,
        1.57192346569223, 0.6818750209114456,
        -2.80021795765606, 1.860243732557069,
        -1.04941182093717, 1.318376887706446,
        1.78032617319512, 2.453863700512888,
        1.52836064988027, 1.488334170085517,
        -2.81230687532218, 2.148895115967004,
        0.262214387345266, 1.869258392123325,
        -2.01571969977570, 2.027266298640306,
        -0.357507674770772, 2.996303646120566,
        -1.97615488749832, 0.7357245719327825,
        0.39897083927418, 1.246721263716448,
        0.0147850583024108, 2.306354400840133,
        2.70990087103577, 1.398689907645899,
        0.534165892522604, 0.9488022876695162,
        -0.785092429468872, 1.165074421775109,
        1.46085698695503, 1.045191485405681,
        0.146654692452030, 1.671261744911884,
        0.848642881143856, 2.037990210956316,
        -0.931828870738803, 1.144302424676004,
        1.56109129491188, 1.724551984682458,
        -0.599787411488119, 1.950063903536829,
        -2.13618560647228, 0.1550275805692061,
        0.282895444193735, 2.190332908350418,
        0.435131470686377, 2.787500968498681,
        -2.30645264545992, 1.391893511412969,
        0.268214664054222, 1.03309561868863,
        -0.224801790645470, 0.4302462453347246,
        3.05846379928228, 2.148560468164886,
        2.48134493119461, 1.599870937354381,
        2.62838121749631, 1.696259539659208,
        2.93824122269394, 1.249122840561128,
        -0.287144174915734, 1.346092007132418,
        0.633120653630580, 1.378860646800494,
        0.118543466493133, 2.524020727867779,
        0.628506128309635, 0.9471050781026831,
        -0.880583538632461, 1.789591397578994,
        -1.22453298927869, 2.053914181385267,
        1.55974765410759, 0.4541229790621055,
        0.747513429679002, 1.606649588014637,
        -1.0325985954426, 2.326761696210842,
        -1.43377403821138, 2.138723488141995,
        2.30577777757425, 0.9030315978561648,
        -2.10210429497070, 1.652337536433831,
        -0.870098944197577, 1.059166593763205,
        3.06155454204787, 0.8591331608937889,
        -2.3971015949786, 1.684718384712156,
        -1.49149263782379, 1.873391796708116,
        -1.52249885120113, 2.074461933072948,
        -2.10278092398277, 1.964312531605532,
        -0.865102163468059, 1.096927163397665,
        0.40087365159592, 0.7871906914065455,
        -2.22383597581379, 0.4220026261712339,
        -0.745564231896225, 1.21588591534069,
        -0.124006624873360, 0.7316868272245635,
        -1.39808143978087, 1.447669425349866,
        1.17836833030679, 2.274698251869518,
        -2.35055026997220, 1.230730592152547,
        0.868061778191201, 0.5281329669978189,
        1.52449236742127, 0.7387207247115871,
        -1.9422524280322, 1.582982976399335,
        0.567542525375966, 1.77705332627356,
        -0.868198067355333, 1.689991507956338,
        1.44945827736350, 2.099675261756312,
        -1.18387872190803, 1.656669717146449,
        0.301192516087605, 0.9614063529201934,
        0.0746967593340571, 1.741094848982971,
        0.488611911876218, 0.7576963725118656,
        1.14321508887041, 0.4268065582481159,
        -3.14142391056148, 2.472564931644464,
        -1.34349428076778, 1.29132120004702,
        0.476381516203779, 2.752058013771712,
        -3.08366534106776, 0.05138722883371263,
        2.41126188279055, 1.308451445766301,
        2.2812535136618, 0.7507666255059383,
        0.179486677338074, 2.050221912204717,
        -0.420502198656150, 1.102545734132683,
        1.63734193926080, 1.990564204636611,
        2.48373855083852, 0.9651853479592896,
        -0.729468449938642, 2.556851621881709,
        2.51317006388337, 1.317734836221112,
        0.587506630405117, 2.006137328716604,
        -1.02093658676572, 2.150525405304682,
        2.26292467763679, 1.104331939424953,
        0.436434801532189, 2.490490582364652,
        0.67761105821540, 2.155626251910972,
        0.707369756782514, 1.806001455345011,
        1.32068354449240, 0.897063508516573,
        -0.543096522888660, 2.037201437459673,
        -2.59995842136163, 0.4607714826304755,
        2.83134910595665, 1.235955193947152,
        -1.41104518191300, 0.8660174244950439,
        1.61162123267012, 1.593003665714626,
        -0.852511824697716, 1.930346863561543,
        2.92208285807230, 2.420277078978708,
        0.825287604786553, 0.8862928036329125,
        1.74606776537552, 1.72832089738463,
        -1.45900542911853, 0.6399805413349439,
        0.866945727878007, 2.292316960620798,
        -1.07394610722610, 1.956215003627056,
        -1.34172795068852, 2.525415364745899,
        -0.283192721187483, 2.806643890982485,
        -1.91593317340362, 1.98494902577355,
        -0.0690605672632235, 2.098519317233535,
        -2.80126629645075, 1.402875335040636,
        -0.338693470874991, 1.085120076368723,
        -3.09471205339433, 2.215145494824473,
        3.01622009914694, 1.743705443571672,
        -2.9288401413530, 2.169823941562053,
        2.76494135666155, 2.672603628976556,
        2.37611266633751, 0.1670790677900145,
        1.82310534026779, 0.9766174453340215,
        -0.891365825982067, 2.795536843388049,
        1.55094319790083, 1.456624696115119,
        1.85843436700533, 1.874049047230476,
        0.615081247738031, 1.344956608280693,
        0.698197568085717, 1.73026190401904,
        2.81931923611215, 2.351797202903752,
        1.86812141380805, 1.253772864319647,
        1.59303296154477, 1.232216413530025,
        -3.06512957128438, 1.159109471206356,
        -1.98537059289337, 2.001224277932826,
        1.66420143635644, 2.387747178196293,
        -2.51045604994932, 2.327747186340683,
        -0.0780096634293043, 1.528520798254312,
        -1.65257535722891, 0.8757021308631956,
        -0.373749903568292, 0.5826270695823621,
        3.03699005702296, 0.759490558246886,
        -1.46682170036598, 0.3661061744550053,
        -0.794611525913392, 1.403419130528039,
        -3.11476144092418, 1.525452880520027,
        0.540133133389088, 1.835590950732569,
        1.37803735491302, 0.5601472265020624,
        2.65710943309774, 2.159667803685696,
        2.48398420880618, 1.738937592663315,
        -1.77777706313541, 1.12255776390564,
        2.85528577473668, 2.157624941177014,
        2.51499295707409, 2.582200170399567,
        -1.34866263877234, 1.355765956836591,
        0.660868394981977, 2.909019058915583,
        -3.10772036142981, 2.051100775891344,
        0.0841093531692661, 0.2543508754142295,
        0.332292207605814, 1.909650372220134,
        -0.108585472394032, 0.5149398631188729,
        1.52119461332258, 1.554511118791438,
        0.443187018504759, 2.121677127572304,
        -2.411441224389, 0.8916474479080596,
        1.15488852546347, 2.465641640398135,
        -2.38300223563203, 1.632573462237116,
        1.3023547202995, 1.639742924523142,
        3.0216781221183, 0.8348967031985853,
        0.374254819008306, 2.402608128177199,
        -1.42998318057402, 2.271201117982738,
        1.25044085184978, 1.601666369241649,
        -2.74302231164985, 0.887270850862741,
        1.00109569635335, 2.047576078105444,
        1.01401273921010, 2.323824258798566,
        -0.315074248512877, 1.621287640169017,
        2.93261130220958, 0.8285678438456415,
        -2.52993568887432, 1.730090480072114,
        -2.81072511799898, 0.2175690682928534,
        -2.85713773371833, 2.59578874989062,
        -2.77971441896856, 2.052237284891002,
        -1.52307794925002, 0.7345966413172401,
        0.73355265122845, 1.745208516724036,
        1.40152614320859, 1.380454215865039,
        2.9800534009193, 0.8121141474463854,
        -1.97353287903835, 1.424987478989248,
        2.9568727926202, 1.039200373881625,
        -3.00548930585096, 1.931653992664063,
        0.374070063828624, 0.9891603677288269,
        -2.04187293953962, 2.788612776798902,
        2.46484497122196, 1.673849268010539,
        -0.104066528931813, 0.8310702337426311,
        -2.20175058398150, 2.109218406665599,
        -1.66027418807693, 0.8375986264179918,
        0.0656142677411274, 1.612566877677163,
        0.14379157449382, 2.558562191871561,
        -3.08701656510223, 1.889699179120118,
        -1.14173292399731, 2.450089180258946,
        2.17350089814895, 1.040495158728258,
        -1.95760329786425, 1.667105870716456,
        -1.11616410204185, 2.691331107055046,
        2.1029092761725, 2.134707276058922,
        -1.15405619986221, 2.076667574282908,
        -1.40366140315921, 0.4560005829809108,
        -0.708407959761100, 2.818392052545702,
        0.751807695980625, 0.5720154702371829,
        -1.08905552164651, 1.619541613303958,
        -2.19620777231639, 1.864157894647027,
        -1.197915995092, 1.5825345254602,
        -0.97049457252534, 1.692814636702788,
        2.49667724632719, 2.482788150143257,
        2.60337945169681, 0.2674582614354571,
        1.36298908832199, 1.310049238235663,
        -0.529385866567946, 0.1698783146282623,
        1.38847892308019, 1.123134360376031,
        -1.19057804301814, 1.791873689332812,
        -0.651943009567008, 1.578548013107572,
        -1.63512744963929, 1.853225715053422,
        -2.27784102579240, 0.7085654187582076,
        -2.33534818579009, 2.629947453113296,
        -2.68217905490859, 1.729896543587921,
        -0.183581287921806, 2.141127267595348,
        -1.71116276937437, 1.626211717736657,
        1.10404362518343, 0.4602125112263916,
        2.76706139207611, 1.279172445679056,
        1.64324112400381, 2.672981175827199,
        -0.249871938774882, 2.371328282101304,
        -2.82996051595393, 2.113520164807556,
        -0.178289807582613, 2.824846680732593,
        -2.45004605678251, 0.8686433162211553,
        -0.978808947216064, 0.9208340581644592,
        2.53262323776899, 1.379310296049499,
        -1.42437618700391, 2.722343137416603,
        0.81661923297627, 1.849325716964009,
        0.49991601395321, 1.27753676420045,
        -0.442542579369476, 2.402797997711789,
        3.07927502482267, 1.949455421776747,
        0.0801385709685606, 1.350697053876574,
        -1.8865356134286, 0.560222646247305,
        -0.960976984986194, 1.91457420695599,
        1.9949894510369, 2.091954090312815,
        -1.94030676704971, 1.315596537969423,
        -0.974585668891996, 1.831847481110762,
        -1.40100328071776, 1.187655671477426,
        0.960550396694028, 2.036782445825784,
        2.66249609190906, 1.270306549936232,
        -0.471255330594353, 0.8641325453391334,
        0.346620611422225, 0.9576573035409571,
        -2.55305903047517, 1.630433901224107,
        -0.800980999256420, 0.7673767052713962,
        0.740895826958054, 0.9823161245387403,
        -0.814950210215031, 0.5666356289557333,
        0.78222651600883, 2.303924650476787,
        -1.66194972692651, 2.130791272811817,
        1.04487172801336, 0.988045953661306,
        2.42477445219254, 1.546256522252558,
        0.789068119674966, 2.124979671348657,
        -2.03962842758947, 0.350034984877681,
        0.0532421294107457, 2.140248622749019,
        0.19596232273528, 1.405335639760686,
        0.888044756067709, 1.6634011366502,
        2.39426564927988, 2.466116951857248,
        1.45407039365865, 1.651065902618805,
        -2.85100634971567, 0.76986563420321,
        2.48861453973849, 1.284911312073442,
        -1.21915142994742, 1.071464396212057,
        -2.62906022031703, 1.563997681657548,
        1.02076537372074, 1.075594822697662,
        0.668499450120700, 2.078426098165246,
        1.37031263121289, 1.256151877181898,
        0.996020750234765, 2.388927800347489,
        -1.38467064319333, 2.202920680906574,
        2.63732813901405, 1.118215463740309,
        -0.465869080548899, 2.008658628837463,
        2.23832469175774, 0.7740571022951221,
        -2.27520213053970, 1.590109590915709,
        0.800671618266827, 0.2488731137737207,
        1.22762253588351, 1.979042216303345,
        -1.4586517748935, 2.039649964016026,
        0.876144733789959, 0.9904838743507887,
        -0.239011097061964, 1.405207127087469,
        -2.32820117966964, 0.3257941786455295,
        0.090801635688365, 1.2490838532405,
        2.61091881293622, 1.772178364085901,
        2.95320320632467, 1.437183167010087,
        -0.67943240343190, 1.070056026710843,
        0.992210576585415, 0.7809965197651837,
        -0.59529883650833, 2.909843509259632,
        -0.886996115483155, 2.075544357597684,
        3.00931751152793, 0.6610148120775473,
        -1.75837564046361, 1.795913597772309,
        2.11945871032594, 1.884960682993419,
        2.46894761043535, 0.8908539317918196,
        -0.98432837501055, 0.1663410712194416,
        -1.07154855771749, 1.032453750018709,
        -2.84097012742504, 1.858794149304029,
        0.973746691722222, 1.762707608681312,
        -1.42239035114231, 1.63993301592334,
        0.895389780075980, 1.156626522322828,
        -3.07294493512986, 1.465240789944546,
        -2.08649870519491, 2.648209371701653,
        2.82498848572574, 2.502214514722115,
        -0.876522757573232, 1.346159293644026,
        2.04298266289734, 1.110164294260801,
        1.37477078968915, 1.877454334227759,
        -1.09800499417861, 1.891611353607946,
        0.538992563622456, 0.2583555507399207,
        0.247898463011500, 2.130780531360047,
        0.928987395255467, 2.062880872481839,
        -2.69890061986571, 0.9432672024734947,
        -0.140578672678576, 1.433251276075245,
        1.02696138782918, 1.389071124753083,
        2.49784260895384, 2.279671607437707,
        2.39615456928986, 2.566911681542717,
        -0.831291669188138, 0.6314308728173942,
        -2.72464848775967, 1.402066796961315,
        -1.59000614880843, 1.911823963632324,
        1.0894643974236, 1.264465616414119,
        -0.713611509064538, 2.336883001028855,
        0.835039959958416, 1.962339172815514,
        -2.99275349110269, 1.152121710298265,
        -0.138778596938798, 1.970684367503434,
        -1.97844039272491, 2.610076565553568,
        2.40600378713086, 2.323679004890315,
        -0.764079256349623, 2.691100504874171,
        -0.413449911404469, 1.581303096892711,
        -1.71679352607750, 2.642897407431644,
        3.07408172389964, 1.166925325419587,
        -1.5734386297406, 0.830325899043912,
        0.860125785614247, 1.900323012531333,
        1.48204898852161, 0.7996011787146821,
        0.050696067467985, 2.279479404190921,
        2.12603305905242, 1.497701406567522,
        2.85073410366818, 0.2580789984156255,
        -0.720231060923456, 1.731653674859587,
        -2.80808557698314, 1.305336758752681,
        1.15004919529212, 1.780709973012457,
        -0.297613836082208, 2.352263347252036,
        -1.6819449187876, 2.921879971676146,
        1.02984402297983, 1.214500623321237,
        -2.8109251098362, 1.119235146660026,
        -1.21430279021238, 2.784646016795945,
        -0.495815407229870, 1.52078669720582,
        2.52760105920174, 0.4298636447659535,
        -2.96473042390705, 1.768535253338474,
        -1.89971566333771, 0.5967999050163414,
        -1.67807796806173, 0.7645213139096001,
        -1.31106031874511, 1.506234322947686,
        0.28479893805773, 1.313877697076597,
        -2.18926545059256, 2.269646412323473,
        2.77632852537929, 2.168337147871837,
        -3.02769300514121, 1.174730252560808,
        1.78210156438843, 2.759806701280768,
        -0.653998297406335, 2.035731024028102,
        -2.97437074772260, 1.372955876450132,
        2.00249547816503, 1.000025287846091,
        -1.96565922010002, 1.125362139849813,
        0.358369887729300, 1.704518115982752,
        2.31562658854681, 0.9780901842738355,
        -2.70228379799278, 1.896128601575539,
        -2.06664681004701, 2.550172986043494,
        1.71237186325475, 0.8017806691439617,
        -1.95757981848497, 2.676294588633944,
        -2.31599110549237, 1.987279462038321,
        -0.642931398526534, 0.9361746108831557,
        0.186192990825091, 2.529138798873596,
        -2.78799017006461, 0.704212739998737,
        0.326261683779404, 2.857015870007263,
        -2.9536947984784, 1.203856203683733,
        -2.81542750182029, 1.005643841036318,
        -1.94512987812579, 1.63302462634798,
        -2.61029403391849, 1.530405456764785,
        0.267761777684860, 1.344485062357133,
        -1.01868026022246, 1.080334242020186,
        1.91131268411459, 1.836580962215208,
        2.37181113483354, 1.62891724273199,
        2.11620230555129, 2.385678028095079,
        2.43302444774036, 1.50968533764539,
        0.0752978073395099, 1.284771635930722,
        1.97531030158397, 0.1439131769860883,
        2.19741791079366, 0.3784921810318141,
        -2.90263730679869, 2.240265375793814,
        -0.521093351924362, 1.267041419318696,
        -0.597700599743976, 0.8435774215120606,
        1.76822838929408, 1.277312378858715,
        -2.68655266369940, 1.53224998209228,
        -3.07696996760030, 2.584407248121477,
        1.07730227287040, 1.163977541022348,
        -1.28496035262072, 1.694260617380558,
        -2.75760671904212, 1.795292631664387,
        -1.39881099491233, 2.00248852163391,
        -2.39957659778909, 0.3873142242223669,
        1.5187347598909, 2.576098188194503,
        -2.86147618100363, 2.402789681219514,
        -2.3334614568094, 2.817020829597793,
        -2.96840526482066, 0.710005797296685,
        0.847347605168376, 1.825150421560235,
        0.990685830986600, 1.401930167730188,
        -0.017369106041193, 0.9516430150665265,
        -1.85294791678296, 2.355565555343245,
        -1.5075099220239, 1.580499195769038,
        -1.75948966176146, 0.9526187131859455,
        -2.06979790603492, 1.111201906233679,
        -0.2906946158255, 2.041962892689915,
        -2.52314545020042, 0.3347633005102897,
        0.367273179596085, 2.691952217290701,
        -0.446957722717162, 1.005123425183888,
        2.30140277981877, 1.783640909881898,
        0.402837049419488, 2.889062118134286,
        -0.0256551240530393, 1.881779410540375,
        2.66005712028368, 0.3420202296129903,
        -1.38405240321210, 1.28646757586334,
        2.56505581300348, 1.821734985296248,
        1.62831160418233, 0.5873374927359032,
        -1.88212306837751, 1.605664624876426,
        2.01889721618451, 0.9350162045629813,
        -0.549356155401640, 1.434282884695603,
        2.01369937710681, 1.709031642366144,
        0.052136454666986, 1.776643449827466,
        -2.24931299067355, 0.5931217622491667,
        1.30579885048188, 1.13766881219512,
        -2.98538386879359, 2.460955035039665,
        -1.19712362481522, 0.1786188234537329,
        0.0575629813630325, 2.417207528711048,
        -1.53165759602014, 1.875919588114574,
        -1.67716914550524, 1.084511671028792,
        -2.17472343478860, 1.416254009150109,
        -2.02933656501809, 0.2192236117867009,
        0.613484366909044, 0.6810153161624004,
        -1.77780954558983, 1.017785431193044,
        -2.66072107067355, 2.718814359557123,
        1.37834680530128, 0.1828714615278015,
        -0.20022111342558, 2.388984139171002,
        0.206647250513466, 1.236155880611602,
        3.04025966365025, 2.113104784574147,
        -1.90152438483117, 1.309423696254722,
        1.92061734222307, 0.8192537127718827,
        0.746054158055597, 1.15010475238321,
        -2.4612442966504, 2.622036304014619,
        -0.540015022458501, 1.331701367762334,
        -2.40462930869411, 1.1081185425099,
        2.37428159408897, 1.107291120542796,
        -1.36528808007653, 1.557232797120932,
        0.404294597918147, 0.8547084279540207,
        1.39791535277257, 3.028814238411109,
        1.8894528604748, 0.8496181893784958,
        -1.30649677845365, 2.465029192768522,
        -1.56913386919166, 0.7170906037240031,
        -0.417696541218416, 0.7865716948025108,
        -0.620430367384327, 2.342135545874385,
        0.225223992591442, 1.039098987629664,
        -0.118972995413252, 1.63408907108553,
        2.49814549306338, 0.7233603422950979,
        -2.68588998225005, 2.552963961286769,
        3.04910850275293, 1.337445751478379,
        -1.03173705880618, 2.464310601587204,
        -0.350403282654507, 1.325388259668954,
        2.27844790898887, 2.286569655015156,
        2.26565582109134, 1.86903172486319,
        0.651600201210890, 1.925801144861903,
        -0.387474556388816, 0.3919714518104565,
        2.61338417173043, 2.10549589974228,
        -3.04350675620557, 1.058796724509624,
        -0.226262536161818, 1.758734371065752,
        3.02274076529312, 1.470553712232054,
        -2.97245163152116, 2.625927750372838,
        2.42854136244621, 1.683403685019802,
        -2.98331677961711, 0.2191630266279216,
        -0.79016596144908, 0.602642843693535,
        -1.71797460316377, 1.791260936742184,
        1.68691740280521, 2.18972115178286,
        -0.369475543590643, 1.824760748786536,
        -0.0640967652377272, 3.052769957308416,
        1.5348604716248, 1.197942713280286,
        -1.38672171201319, 0.5884327997307631,
        -0.0594324245041717, 2.531520822394509,
        1.26298273947905, 1.404777412182889,
        -0.452754371116905, 2.725485590940093,
        3.13704390785233, 2.331861904298123,
        -1.00403118479558, 2.86629733407908,
        -0.345519174943749, 0.9002680895142389,
        -0.138325592027204, 0.9318474292983218,
        -2.96687072080548, 1.835529667866852,
        2.46404722095250, 1.994178714709749,
        -1.62437675153483, 2.477504219165625,
        -0.463944729759251, 2.517035600149788,
        0.727817897721177, 1.707137066059849,
        2.358588233679, 1.939365034898666,
        -2.44574751950066, 2.833650939993203,
        -2.00116965755698, 1.397856153765313,
        0.498666434818698, 1.211250309992801,
        3.11650471866145, 1.37119906714756,
        -0.940194991330068, 2.834293752646408,
        -2.35096443659302, 0.7990264550414925,
        2.45859090878326, 2.187452580295256,
        0.841656691551290, 2.00011408077137,
        1.79626551636224, 2.247011467731855,
        -0.96803341391696, 1.958262284275867,
        -1.86327450621735, 1.471739175439923,
        0.404310736676509, 1.987886433207236,
        3.12987849833876, 1.522226742271205,
        0.517847702145812, 1.377695982507744,
        -1.41595837195292, 2.759648598205337,
        -2.81620185380034, 2.627828686322871,
        -1.12002937363536, 2.590989315883726,
        2.05129420111448, 0.9067553066401152,
        1.34626753617272, 1.229800147075164,
        -0.00148483445468687, 1.157255453615454,
        0.416075846901586, 1.672893423081313,
        0.251716694886864, 2.093078870014871,
        0.53221277009177, 1.751640188539222,
        0.118687202549665, 1.512655864362315,
        0.0842300530802741, 1.153063253588646,
        1.50856169553507, 0.5888694537109762,
        2.73027604156567, 1.263338929430418,
        1.55258047592544, 1.989796892574695,
        -2.98510482583001, 2.261272009755172,
        0.626089580011457, 0.7172095534658669,
        0.315293610828158, 2.252889960311989,
        -2.82357922806203, 2.562540425047537,
        -0.373898424342243, 1.196111405040299,
        2.1075164406749, 1.262073586999871,
        -2.94344328357929, 0.8371276676335472,
        -2.38854146414447, 1.496387556796858,
        1.50902227565006, 2.640690121650379,
        -0.662680472017453, 2.31893234944806,
        0.671471270935966, 1.790581253451489,
        1.50596920828589, 0.2603838018022365,
        3.08751035997066, 2.321656660228302,
        -2.67171567360413, 1.373200005227589,
        0.0785817698218500, 1.515885527890192,
        -2.28944761414295, 1.491866247771588,
        1.24689233255752, 0.6752634813488467,
        -0.780838728632189, 2.79020028577937,
        2.36611725650460, 1.069736463483386,
        -0.199830040926236, 1.854926224810595,
        -1.07714990953154, 2.197900441050143,
        -2.48592310815744, 1.177783226605408,
        -0.815604200477433, 1.912121290176292,
        -1.620042973544, 0.813218473828221,
        2.11663135062278, 2.453615242224663,
        2.08678363117765, 2.350006938728237,
        2.26912457236438, 1.623286656405938,
        3.03294304959748, 2.17972138780129,
        2.43271425124631, 1.931728871909823,
        -1.71584342099554, 1.392096965899357,
        2.86231177994184, 2.32877070579335,
        -3.06941221512414, 2.685496624371845,
        -0.152059020881618, 1.649376396158294,
        2.92744469285530, 1.533025720373027,
        -1.59718048393846, 2.764813270287182,
        1.84773753890512, 2.144783879892237,
        -2.00182408479692, 0.7694130899194206,
        1.75199707458237, 1.242027606600939,
        -1.03266358588595, 0.4912994176493098,
        -1.81673647562690, 1.764789809087287,
        -1.05213233076027, 2.123424740696552,
        1.4355339204660, 0.5361109958176122,
        2.85248953110761, 2.056689377967139,
        -0.236477987428813, 1.472301220870843,
        2.80728743024745, 1.953173786291319,
        -2.18727106258770, 2.170690721496619,
        0.905195177248246, 1.950376453358709,
        -2.20293485580638, 1.826679609546684,
        2.4943085536547, 1.001009837660822,
        -0.48691148692660, 2.379089383607702,
        -2.06286722424076, 1.659260142721906,
        -2.53798159406114, 2.360714313302175,
        -0.642301894280063, 1.089929009020794,
        -1.67861942114077, 1.789079897383664,
        1.59866805390731, 2.122176078296742,
        -3.05637646977517, 1.72420340327432,
        -2.3738984161718, 2.191459916009571,
        1.47425277497968, 1.451888833099673,
        -1.41495658995669, 2.436102550482788,
        -2.93334544357766, 1.374598049351631,
        1.78341485586388, 1.142029617798292,
        -0.065913250900623, 1.427749645068899,
        -0.322402183205993, 1.6555522892549,
        -1.78663497749488, 1.631414655729725,
        0.614745922825134, 1.909094284868583,
        -3.02471756759003, 0.9192184994305045,
        -2.227196667860, 1.328246219357339,
        1.31602850270103, 1.00026557067275,
        -0.748691256569998, 1.758421895760978,
        -0.098972806618026, 1.497651009731829,
        1.93921462104457, 1.931344422667254,
        -2.70227017870011, 1.209365424546617,
        -2.05854255106547, 1.701782895982998,
        -1.93460721906061, 2.049218189824912,
        -0.0343716081696451, 0.5024251002391485,
        0.499521896854358, 1.344362411551892,
        -1.58367770319995, 1.975822296548468,
        2.15846587199778, 1.658570493642756,
        -2.61841552671218, 0.9418870833117281,
        0.100359029854661, 2.685779198386621,
        -0.785717385655376, 2.185252509598273,
        -2.55501007558193, 0.2968570141265955,
        1.10095845413644, 0.6262271446360113,
        -2.20425248687499, 1.390778403690974,
        0.907315352275930, 0.9630747960382688,
        2.85746372356845, 0.3728936914292525,
        -2.34687865847942, 1.812622727237585,
        -2.57676456443557, 0.7635437771740334,
        0.183699721851886, 2.01220455269069,
        1.19586082865312, 2.375636155901219,
        0.605764621354955, 1.544875074312509,
        -2.23075544185095, 1.538778305087475,
        -1.38481012818031, 1.634326243340516,
        -2.88051755474412, 0.6723891470575681,
        -0.378792287731153, 2.785651528207559,
        2.0767456516243, 1.411187772786761,
        -2.27834324105895, 2.084479831978879,
        -1.92416048774118, 0.9607162456718799,
        -2.49805368224798, 1.291674254886775,
        -1.03996775904043, 1.532772213216716,
        -1.55219863844055, 1.682552613384594,
        -1.13418451163922, 2.344491014693133,
        0.0704505958478488, 1.452173337131724,
        -1.16515467719959, 1.215207414125343,
        -0.57812094405, 2.190723176447745,
        0.891842475113179, 1.023618579824423,
        -0.0269859828152397, 0.8845965406622437,
        1.82315402368785, 2.564042554250148,
        -2.62328203751364, 1.963549783300483,
        -2.23585385953900, 2.085519738014676,
        -0.601080578642174, 1.800006607796747,
        2.45931074116414, 2.69528813669021,
        -0.297106685161713, 1.380610990632813,
        -0.273062599915606, 1.311503337476204,
        -0.21131251800419, 1.172258556295358,
        -1.33650991081272, 0.4797597020958871,
        1.06513232777161, 1.859182906041926,
        3.01791229913191, 2.588463439320647,
        2.45698508116849, 0.25988287235499,
        0.411365228682132, 1.149194009727489,
        0.190075933360563, 3.024207623508446,
        1.14562108891801, 1.040009753503125,
        -1.22050611725545, 1.241506087694892,
        2.49122128618757, 1.842644948230933,
        0.380834552755530, 1.054830343256352,
        0.57032631016996, 0.5699162145097393,
        -2.51753530494576, 1.495631762469586,
        2.42399909905499, 2.090600371236602,
        2.40875094394699, 0.4853677037540395,
        2.08501464091013, 1.860578696757442,
        -2.2034777885399, 1.041121523882146,
        -0.838583070531866, 2.023070960875938,
        2.34315596122609, 1.602302366161468,
        -2.14635883975112, 0.4778520715607776,
        -1.07398440990785, 2.434209879642824,
        -1.27321873924686, 2.16062177719057,
        1.32101549901551, 1.442128734953727,
        1.73548556862569, 2.184952331701431,
        -0.0841333913455321, 2.629509465207968,
        -1.51349735240029, 0.6580443739858722,
        0.756626621336207, 0.848707762627708,
        2.79412269358740, 1.916365174181387,
        3.03846083724566, 0.3771966144427875,
        -0.42855985080446, 0.6406881341200509,
        -2.3646930372481, 2.25837190346538,
        0.0368155568945075, 1.286853514506263,
        -2.20125156919371, 2.552475195797522,
        1.05152155285614, 0.8861553107682439,
        2.16338524412433, 1.002304687409209,
        -1.06446233338426, 2.160753898730728,
        -1.06354792825668, 0.5891652334784963,
        -1.68175947199074, 0.2758044267658104,
        -1.42267868119472, 1.474773094340281,
        1.84761806398167, 0.780161688066685,
        -1.8308436733305, 0.7709421086343891,
        2.38854713615835, 0.8971688319668195,
        -1.7810893968440, 2.047744740594446,
        0.884228231634505, 1.838206577626069,
        -1.03188398999317, 1.569916909534997,
        -1.45561719200227, 1.019491685170607,
        0.360354701546797, 1.774304209078236,
        -1.51306628096673, 0.6178775040271202,
        0.222844875831696, 2.336113239542349,
        -2.48535110626822, 2.294441245960212,
        2.32301300834792, 2.777517980246329,
        -0.905530072094327, 0.8695211805796154,
        1.24379874087482, 1.220848951053988,
        2.71466028740575, 2.822018282945955,
        -1.22445290925053, 0.631785805783195,
        -2.79845706758464, 2.01762581978786,
        2.54024642115520, 2.681193986183189,
        2.83951577973722, 2.731700636703025,
        -0.931590854343982, 1.948142101584697,
        1.68025296167293, 1.663840758733984,
        2.65002565671583, 2.084403299947382,
        1.67952709211377, 1.169294075403311,
        -0.0562392773934075, 1.325154275724579,
        3.02917557878418, 0.1265433464924787,
        -0.692538958548497, 1.841701657821061,
        -0.378674925212203, 1.454381577309659,
        0.711783568262001, 1.593603972652551,
        2.89964562706679, 2.16697528588847,
        -1.82822446424079, 0.4534847387847175,
        -1.37509653218927, 0.9289721557161366,
        3.10147183380712, 0.7089091581284868,
        -2.62518736877397, 2.029130924495926,
        -1.38027907405643, 0.7615520012732804,
        -2.53323317782079, 0.8645771403659266,
        2.814604462309, 1.782740511057501,
        3.07207947255930, 1.127579746523667,
        -2.99795799104272, 0.3207818261901821,
        -0.631009698050902, 1.925946880719337,
        1.93264499401735, 1.770457425633046,
        1.75178886820574, 2.982636503341856,
        2.05927186871989, 1.045539371709406,
        -0.385847004734392, 1.555660897993587,
        1.22640453328086, 2.676152612042623,
        1.63555106624543, 2.920559107560795,
        1.8163532271376, 0.8093944347341431,
        -0.027973845108663, 1.919219431704379,
        2.37477129081199, 1.766413137575738,
        0.0722890967299304, 2.650383047280068,
        3.12129159175166, 1.951571222362823,
        -2.21251350490548, 0.2670283218152026,
        1.8377469230500, 1.596129499388086,
        -1.43236466478379, 0.7745977136805093,
        1.193122721663, 2.212771144846148,
        0.241670169422199, 1.002454079364915,
        1.36367989491613, 1.611317845248103,
        -2.13571552363278, 1.230672949287567,
        2.10938495487388, 0.6117459943727519,
        -1.94236265858477, 2.150431908256089,
        0.392674609559237, 0.9547505039625827,
        2.50029553258651, 1.940338491255621,
        1.9907810539091, 1.992574596481254,
        0.22703063031668, 1.807461879282616,
        -2.28194299140763, 2.185003688321793,
        -1.70848246081741, 0.8234844142274969,
        -0.848450161207135, 2.314485729222227,
        -0.532325513792387, 1.230480986022569,
        -0.177129333418420, 1.43449897277784,
        1.03531062368415, 2.158035762630804,
        0.0834195937638197, 1.837480835814181,
        0.779790789287159, 1.219245717731618,
        -1.52957868422212, 0.3997848821705655,
        -2.07884606356290, 2.48450451064425,
        0.121334302456259, 0.05124714067979994,
        -0.680645244349538, 1.031355287697693,
        1.78553247731392, 2.626124067500649,
        1.05989896714318, 1.239304339968536,
        0.320757290902225, 1.703944956334188,
        -0.136904002295283, 0.5913811719311137,
        0.396157444209506, 2.292134547414218,
        1.22637258167335, 1.403772085553115,
        -0.678212710360721, 1.973021415133409,
        -0.221330888522745, 2.160989288652238,
        -2.86235783453075, 2.466028005682074,
        2.16762880462613, 0.6823924709488759,
        1.80259140655094, 2.147263289832656,
        0.177495741384557, 1.476525632747997,
        1.15225397050155, 1.411328709993873,
        1.75324249636556, 1.792188874147067,
        -0.618639560764320, 0.4220108315789147,
        1.42892620548684, 2.635685208781631,
        1.7792436301087, 1.885189573069565,
        2.72506258594291, 1.225129968990607,
        1.36911858701090, 2.225911551116992,
        -1.1333054314841, 1.569994947653345,
        -2.05366675376026, 2.152257061899175,
        -2.21459095416143, 2.872130339062087,
        -2.86731990716009, 0.8730953669542613,
        -0.0877988268217686, 0.3010188290224582,
        -1.67659820277802, 0.3707319555941058,
        -2.66056536202740, 0.8451330714051618,
        2.61579523233382, 2.795677093479484,
        -0.42990412577598, 2.28809797551476,
        -0.550992356918650, 1.573243474164898,
        -1.79521212555, 0.7447228107598385,
        0.997922991361899, 1.364231476176495,
        0.37115132666653, 0.4824898317685652,
        0.471739681380269, 0.7239159753837511,
        1.37141876972340, 1.71164068663866,
        -2.72287337066533, 1.663386978702581,
        2.4361200109590, 0.5204129538853652,
        -1.90039811366443, 2.226971173937481,
        3.09942811606455, 2.499456466999214,
        -0.87143796149968, 0.821236566225649,
        0.519621736644972, 0.358561254595855,
        -0.747205117836794, 1.181236104197819,
        -2.16239592272078, 0.7896370000949932,
        -1.86244572423527, 1.637462756035715,
        1.95690943162152, 2.740809746767785,
        -1.50637583680675, 2.744020470326794,
        0.426007638682527, 2.560458597370441,
        -3.08891165272709, 0.6252351881008131,
        -0.818492350817635, 1.948934389637154,
        -0.909309738222800, 1.81689875864495,
        2.73671862566337, 0.2799524237281765,
        1.56676552690132, 1.657706672088559,
        2.64364023089992, 1.156682668664035,
        1.5417495074789, 2.213229406426579,
        -1.24978143742953, 0.3737071082873136,
        -1.84100638296354, 1.864304156972003,
        -1.8870332774701, 1.957351905746431,
        -2.98458660182978, 1.799947229576904,
        0.942462668108545, 2.379442304662514,
        -0.773889176466064, 1.648442249058715,
        1.28313003332666, 1.212492710167421,
        -1.36268716791657, 2.448799615869016,
        -2.53571604662413, 2.227233159915394,
        -2.05673454848704, 2.283868117595918,
        2.84479205184011, 1.021026061907143,
        1.88782910463037, 1.29377965222543,
        -1.70262932409287, 2.322721050490797,
        -1.16194408351943, 1.594907444711127,
        -1.20143885520019, 2.684118094386723,
        1.99081648011700, 0.7609443577297511,
        0.660196118957026, 2.412367585260197,
        -1.9953212465685, 1.032143807035555,
        -0.494067938888479, 2.417500516173693,
        0.240988015758003, 2.205062964455184,
        -1.7329223689678, 1.19235573542999,
        -0.0111953180737378, 2.506451122472507,
        -2.52900100035097, 0.6336039467505701,
        1.04960971668709, 1.453818775387852,
        0.385914583842403, 2.330601315881247,
        1.66359903996286, 0.8017327407911725,
        1.04914812463401, 2.194453413108162,
        -2.85434755654253, 2.24580859214123,
        -1.62265285217717, 3.09047615660282,
        1.27801678714432, 2.139585072909393,
        2.49898589594415, 2.090541189328897,
        1.5751385574961, 1.067817908558257,
        -0.762923675896525, 3.041146337780308,
        0.129804952146712, 1.776361946476684,
        1.8443854330278, 1.978001726785479,
        0.320163906966333, 1.769737932950904,
        -1.77727986442230, 2.618383528083758,
        1.61060868835425, 2.370656779746399,
        -1.69421452304733, 0.5684913608746665,
        2.01518621298802, 0.1065651156937833,
        -1.44172477570752, 1.509932713167895,
        -2.0727130475548, 1.939562833343639,
        -0.914120274407186, 1.258246964390813,
        -0.897666143473014, 1.408455708528938,
        -1.65336848922724, 1.888550020729012,
        2.76240973399397, 0.9465791620569692,
        -1.77635983245174, 1.363712194853829,
        1.66911816854181, 2.425789884234939,
        2.87666075966977, 1.328150558912667,
        -2.76446026391856, 1.404001591991118,
        -2.47831967078878, 1.631358841410748,
        -2.11874743572613, 1.020139396079944,
        1.30529303968733, 1.967244091245697,
        -1.73903283343963, 2.054082686777243,
        2.09366558359173, 1.646169568410881,
        -1.22632899396804, 1.77951235229277,
        -0.75511036740361, 2.282937670829591,
        -0.938154496712309, 1.842742090584251,
        -0.459865465861515, 1.970153994523604,
        0.280813782180341, 1.636895431737345,
        -2.61946529898867, 0.7844611893762595,
        0.459182438283312, 2.853200832027412,
        -3.01868073464296, 1.566019706515545,
        -1.31217146845204, 1.893395829968072,
        0.485944980661524, 0.3224545554037843,
        1.12490631845241, 0.9685462651323578,
        -1.87328746421645, 2.665308482907635,
        3.09116669158040, 1.513431919738415,
        1.47604078319228, 2.128750769128666,
        -1.79452671536502, 1.082961914723954,
        2.89717226542058, 1.19408039713793,
        1.84938530910541, 0.6403938516777337,
        -0.73482044916321, 2.058344431641962,
        1.97256830796767, 0.8266584588802791,
        -2.01619202896972, 2.480688625583547,
        -1.77078094879231, 1.201054098165705,
        -0.831649761966133, 1.394371764013638,
        1.95208790963310, 2.382512844204412,
        -0.385460862436335, 1.233116144356319,
        -1.07304655098879, 1.69344941506202,
        -1.95614381533752, 2.373040276835371,
        1.43235269481568, 0.7824446604858971,
        1.54987582651288, 2.674214832191867,
        2.71847544267875, 1.466395207488926,
        2.65698766196808, 0.5502910313339864,
        -0.099325038538748, 1.260393286233236,
        -2.8564425655454, 2.144509589746717,
        0.557370500258528, 0.8502374409718279,
        1.59873103227838, 1.166219215400413,
        0.503329955452818, 2.512040299447003,
        -1.9770024128261, 0.1821359409817337,
        0.260460393195252, 1.604107548254227,
        1.67751243012470, 1.924610704133183,
        0.701027184391915, 2.351215225541615,
        -2.3380961676717, 0.9394964650896529,
        1.63476382471042, 0.3603654488029935,
        -0.903127337058784, 2.152715491019682,
        -2.7549163755355, 2.022421134106755,
        -1.92279152797862, 0.6711504830994438,
        -1.29507057030096, 1.858616558531021,
        -1.83006748693308, 1.899274896515225,
        -1.9937865670687, 0.8350364718339026,
        -0.806616747202340, 1.503020610944935,
        1.06863317219967, 1.721803296889624,
        0.675599357625075, 1.828272772360248,
        -2.40239676966312, 2.646146360574953,
        2.60093637630448, 1.393699876186989,
        -1.97090536242524, 0.9617860946281941,
        -1.69551438092006, 1.591721277424771,
        -2.32572943983954, 1.079080768844209,
        -0.798492053700541, 2.009103951726712,
        -1.14879035608659, 1.494959201767071,
        1.26059768152331, 1.283609540262981,
        -1.05773582666318, 2.021725026379834,
        -1.89794825860876, 1.031435493396392,
        -1.02780306004295, 1.91360654702907,
        -1.78465452150452, 0.61062413862789,
        0.969989735182058, 2.07417489177368,
        -1.64992707879155, 1.488154893530434,
        -2.20532075495465, 2.420324751595639,
        -2.81712416755939, 1.827313153912175,
        -1.16822420069036, 2.521272813786017,
        0.432525873284188, 0.8872356171121254,
        -0.171179616082911, 1.000076559109008,
        1.40051105489572, 0.6342587793979707,
        -1.03717965349034, 1.9472413929387,
        1.58162982868696, 1.524658711127366,
        0.0281762948654806, 2.204959701327035,
        -2.25104774149344, 2.723596967310577,
        -1.06032348777847, 2.829344889653,
        0.748328008207601, 2.110159174803412,
        1.63943838247444, 0.9689938849993331,
        -2.92805987148577, 1.839212641661974,
        3.03126613264861, 2.011869723138035,
        2.28763758846655, 1.245046711265251,
        -1.88822247476978, 1.274182650932409,
        -2.22900578192416, 1.153826313663547,
        -2.5316989591490, 0.8247292178360172,
        3.11427165554465, 0.4017330962336643,
        1.7792654700217, 0.2346531849075774,
        -0.543751402603557, 2.737696000370436,
        1.69206162459673, 1.762627242829571,
        -3.02597041474425, 0.8164157721618773,
        -1.62779570142221, 1.025562959405079,
        0.655616820078658, 0.4433936522030987,
        -2.82451179201234, 2.215203036070176,
        0.245675691885758, 0.3818567933754214,
        3.04843254964257, 0.9341261050744538,
        -1.45201583610941, 0.3001181291284742,
        2.79762534649450, 1.539289431094286,
        -2.21317687868063, 1.962123400230525,
        0.759020758505814, 1.934326797093031,
        -0.681763850046658, 2.585808329615328,
        -0.44376392419038, 1.290667428707837,
        1.65593282037278, 1.892894683988622,
        -2.91429741080889, 0.4166543255248341,
        -0.246862115128634, 1.587692528127615,
        -0.720987677472418, 2.457831644627569,
        -2.35778546708745, 1.697091775481195,
        -0.299063195053249, 1.020786649427494,
        -2.92632437052246, 1.06991971680586,
        2.96843354767265, 1.191180706577704,
        2.88532704093933, 1.078959818349586,
        2.08523676473207, 0.8789638560191073,
        -0.182660998049327, 2.502730648348438,
        2.72769817826481, 1.936448272010568,
        -1.50665434699458, 1.281059777612859,
        -0.0554372083896725, 1.557477632579977,
        -0.259980199971073, 2.180272703931629,
        -2.95029304682727, 1.870793102762629,
        0.961425183799388, 1.377127231383233,
        1.12230640307059, 2.549485655002752,
        -0.788820862091612, 1.970902747646854,
        -0.0208313407722517, 1.254950301322006,
        -1.54538771621777, 1.085290195736485,
        -0.603012291415325, 2.128172118428819,
        2.14613943318127, 1.207662266243024,
        0.349764346064956, 2.306059470488235,
        3.07678492033944, 1.205093833913097,
        1.92406810894872, 1.968125545263536,
        -1.79029853463220, 1.234266664216908,
        -2.02655306148903, 1.236805845389841,
        2.9662956334016, 2.396031652016706,
        2.72047932616327, 0.9301995681783758,
        -2.04308006351446, 1.446048135380728,
        1.24327298528914, 1.438365195779304,
        -2.32807801140746, 2.18856350956288,
        -2.81478829163134, 0.6719126535240917,
        -1.31727408008716, 2.427867216541128,
        -1.53698559821609, 1.648646894420457,
        -0.550726580628508, 2.075975662981826,
        -1.71469059120451, 0.9638379535768234,
        -2.4585511839329, 1.961394438591052,
        1.31781721554575, 0.7214884942863986,
        -1.13826692258586, 1.875851767983155,
        1.00041513232523, 2.738183294603283,
        2.03542538430590, 2.353220603596032,
        1.21002726381849, 0.2479703137440725,
        2.67332863403680, 1.509610750475321,
        0.596978473078872, 2.121047670508864,
        -2.764168150571, 1.534513107623588,
        -0.319763854137534, 1.982091835920211,
        1.10017919785534, 0.8941583650932835,
        0.988861221409956, 1.837223428666031,
        -3.12828701239058, 1.013231659830112,
        2.34768793500893, 2.088498713833644,
        0.756123934870522, 1.421846827805678,
        -0.502026508984323, 1.7638330488299,
        0.983270742397992, 1.973290903144711,
        2.28683475207678, 1.041118976649132,
        1.13227414899114, 0.7612914869070544,
        0.383704037790922, 0.8887896480389826,
        2.00924804536044, 2.387532188607182,
        -2.23591367420555, 1.01509696341771,
        -0.289441682839464, 2.656005384818714,
        -2.78266175540348, 2.422397621299322,
        -3.05060348720963, 1.434264601273658,
        -2.86399411548274, 0.4483595035245913,
        -1.27760431625015, 1.03155154887564,
        -1.13891622313796, 1.185072176656953,
        -0.131877480478297, 2.231738124002342,
        -1.58779268274246, 1.217145837397387,
        -0.704931285399831, 1.908860869036727,
        -2.06338424474987, 1.554913578023815,
        1.19561211982176, 2.113102838014095,
        -1.44503847212792, 1.937457622634637,
        3.13016008114584, 0.7715519391036615,
        1.36680081713341, 0.2489955796221266,
        0.665694196850642, 2.599163846415129,
        0.192058565073161, 2.855939880617863,
        -0.295734431342634, 2.428758066434199,
        3.13522328145752, 0.9106380208841774,
        -0.29849349702600, 2.314027032835111,
        0.585408261668411, 0.1577184050228388,
        1.31136149889359, 1.738798914660734,
        1.24047810731502, 1.502173451166792,
        -2.66626318174287, 1.63061236704954,
        1.83272326545466, 1.078451580875722,
        0.358672893247837, 2.233389295849695,
        -0.576753762370282, 1.461149888297852,
        -1.44295391994806, 1.77102963891898,
        -0.35509674828983, 1.670927259360341,
        -1.16347069501750, 1.282238448476007,
        1.78499638057193, 1.475467982574251,
        1.37458837012015, 1.05793622456829,
        -0.518900721850569, 0.9209139704418291,
        2.47092518196555, 0.3585461529735737,
        0.414588400856252, 0.719874341417452,
        -0.342713415878862, 2.293625372122567,
        2.04343338295772, 0.7678219439847392,
        1.13397275823263, 1.70592380058881,
        -0.432670910597894, 2.899640283708043,
        -1.9552230370088, 2.114174462753715,
        -1.46827254439455, 1.905178536335071,
        2.02741909203014, 1.325497894893126,
        -0.860903262285672, 2.629606173379918,
        -2.59041724442825, 2.366273321247672,
        -0.370437346442436, 0.7320654491940183,
        -0.696691134816917, 0.5478004475474817,
        -2.50032354617631, 2.735468837485688,
        1.33737052944848, 0.3481578735287474,
        -2.70138355809781, 0.8664128073675277,
        0.292824554208232, 2.438587240136727,
        1.03033269857648, 1.041170619714747,
        2.88162074335847, 1.000321129976629,
        1.05686992382102, 1.648112813462667,
        -1.27112582795870, 1.728944670290599,
        1.17300959236981, 1.851199510234576,
        1.55744462321078, 1.79164168574108,
        -0.400512706249034, 1.618642859641623,
        1.76663524025884, 0.5172421072425852,
        2.77192578498895, 1.649373295954055,
        3.02841409471870, 2.448593741569473,
        2.43866993181709, 0.6179363077777345,
        -1.2486475383179, 1.920016566742906,
        -1.00981793364325, 1.117751722180863,
        1.06211425038544, 1.993157151407226,
        -1.22070473238388, 0.435350599856133,
        2.94712555482181, 2.003848221509617,
        -2.21656530071235, 0.5361539869770754,
        -1.77841779825069, 1.763581948577685,
        -0.0988950414219694, 2.171044149497126,
        -2.01545634488810, 0.5541855291980864,
        1.37569619300027, 0.9575685863526961,
        2.15315735444456, 0.9643532712298934,
        0.418185127411891, 2.722486121214116,
        2.69103372702437, 2.099458162972969,
        3.09938268448971, 2.220735436052947,
        1.63343122496405, 1.234189301214334,
        -0.307962988065715, 1.116125178199497,
        -2.06132739751428, 1.840145014037097,
        -0.553351951790517, 0.8231835307302903,
        1.4425771173910, 0.8543810082971164,
        -2.89161315407740, 1.765952815976638,
        -2.62497452059549, 1.095444949471721,
        2.34378604027215, 0.5798412908182177,
        -0.733152866641286, 1.522196486832627,
        -0.0431467183980291, 0.7827725966288838,
        -2.08514501522715, 0.6455110673871459,
        1.45748150599430, 2.410558469447469,
        1.51861316612624, 1.388714212915617,
        -2.18151070365200, 1.938455088973067,
        0.187790598783166, 0.8104593840406878,
        2.20035922909089, 0.4450396061795922,
        -2.07777628932563, 1.76411873497128,
        1.95166316068200, 1.832111037609052,
        -0.988169757210114, 2.036391535351854,
        2.21341565865350, 2.910841318398372,
        0.853140521991622, 0.02014191731386838,
        2.72241857057866, 2.320893958605767,
        -2.83528525313899, 1.728640367442827,
        1.37333282661132, 0.3854630172568623,
        -1.2875890187501, 1.33588336193136,
        -2.70376801760531, 1.285071133216275,
        -0.410458078805259, 2.539603513475922,
        3.05565105919590, 1.980640187389108,
        1.07511164819039, 1.895351812107756,
        0.246274832423376, 2.595774488912589,
        -2.90012950420167, 2.337492946894252,
        -2.27657373316649, 1.41622859253353,
        -1.96637033700682, 1.557523879189969,
        2.53813125283037, 2.147158706905353,
        -1.26277302374253, 0.703820308699008,
        0.0411956253106320, 1.155690396842512,
        -0.375460554338102, 0.5069874567794898,
        0.726109036049974, 2.61972844959988,
        -2.9907646835765, 1.18973433952536,
        2.0412588643720, 1.946581312126135,
        2.79978863954582, 2.108621894333728,
        -1.94509729823394, 0.5371273993463241,
        -0.814847535834620, 1.466791325454849,
        0.991083414101364, 1.227291110603394,
        -1.36363118893155, 0.861321472540764,
        -1.3344032262578, 1.860988667777252,
        1.1824886264896, 1.981512650605119,
        2.47137640016677, 1.030261238976262,
        -0.379355030022894, 0.430690657900167,
        -2.10825534810323, 2.190513568937025,
        1.5059405126405, 1.520214867864172,
        -2.89375023241870, 2.498395934261679,
        2.71089746112435, 1.500987998822262,
        -1.37098352580415, 0.2388836190072059,
        -2.02517481270682, 1.989827446915669,
        0.709744816369426, 2.656371189041073,
        3.08167905171325, 1.280132480724454,
        2.09884024034344, 2.781557143174159,
        -2.36076559561259, 0.62091835653789,
        -2.28262360046121, 1.973402374242694,
        2.85784598061272, 1.894022685565314,
        -2.82262010630714, 0.7356214714941748,
        -1.4355807156194, 1.673777976684003,
        -1.52179310650350, 2.008303185224802,
        -1.31989331033828, 1.468781586310426,
        -0.9693936146968, 0.9573154679108109,
        2.97386755159042, 2.650438247897814,
        1.45776815519023, 1.417856221323831,
        -0.236784075216378, 1.142590762388652,
        0.669641774328034, 2.7309100707714,
        0.98283999557987, 0.4031749902971671,
        -2.66288781166742, 1.114379311673219,
        -2.24286586866349, 1.608660607739775,
        1.92500069460329, 1.804323210350767,
        -1.42875623024414, 1.902546819645451,
        -1.14467292952822, 2.655659307497347,
        1.12979240125407, 2.434486165908085,
        0.796068180885911, 2.163495462414503,
        2.61819272651832, 1.594660019666134,
        -1.07084787063106, 1.168783900371966,
        0.895291484585602, 1.365556254747077,
        -2.01572733724251, 1.753745155720895,
        -0.471679155393074, 1.187919825973862,
        3.11504303013325, 0.6718672684135842,
        3.11859732890131, 0.8091217613485749,
        -1.55292246161319, 1.516329300016388,
        -2.12403688208000, 2.812424456015417,
        -1.44559657845073, 1.609232249897187,
        -1.96012414396650, 2.269200805252704,
        -2.33406150022546, 3.083265565837728,
        -2.81684395459342, 2.386313227209031,
        2.9205686601521, 1.05878864282518,
        1.27727736765238, 1.109774377338937,
        2.18433648148547, 1.934594585002605,
        -1.66678149408920, 0.6965929950844708,
        0.53931040895607, 1.277320319787587,
        -1.83802667528999, 1.732568956414645,
        1.46119156484480, 2.670132439183971,
        0.0767742053127502, 1.088948325815438,
        -2.70003416240387, 0.904804532853778,
        -1.13918717200033, 1.705582516759663,
        -1.48404340399281, 1.183975075319389,
        2.95561259856958, 1.474831356618145,
        -1.24431956672174, 2.611391208876417,
        -2.32144422429431, 0.8623094007410002,
        0.364328426212201, 0.923093673553788,
        -0.195048741967673, 2.426970579211661,
        -1.96457243331302, 1.387391815508495,
        -0.32272974644235, 1.693481824940341,
        0.143964391089209, 0.218808167254203,
        2.76781886366343, 2.130210570543684,
        -0.393885437444335, 1.379295952727288,
        1.33296377116649, 1.708010333533029,
        -0.857530328536228, 0.7601196435408611,
        -0.0806936277721237, 1.22590346645695,
        -0.196600519797935, 1.817291307149903,
        -2.99467085436144, 2.526159553057821,
        0.863975714421678, 2.114026173719668,
        -2.21352007154794, 0.7996993642355992,
        1.52942603355696, 0.8129466564446961,
        2.59294321427899, 1.280770734628002,
        -3.04432455656927, 1.825884235618552,
        -2.83573948393363, 2.281168724953925,
        -0.0633409128721645, 2.839510480907274,
        -1.89163433762033, 0.8307161548283928,
        2.3847683286996, 0.8227922661651575,
        -2.66106833050752, 1.830469576150496,
        -0.0965787074302278, 1.562592520468418,
        0.422521023811293, 1.345527946727958,
        0.0772590239066442, 0.7249233919097049,
        -0.273323103303471, 1.533308019219251,
        -0.917653352580741, 1.007208115675264,
        1.5339551076756, 2.251288513145996,
        2.6573728840457, 1.860601701492617,
        -1.79022657231151, 2.482684813394052,
        1.57580792450616, 1.82588578620393,
        -2.65857418051021, 0.9229789420472307,
        -2.05618840871765, 1.210376254525596,
        0.84286196260586, 2.699167643535668,
        -0.672344845973118, 1.224780854028323,
        -1.43619948190472, 2.072159904769767,
        -1.12851039255595, 0.9866971860005866,
        -1.37891932613363, 1.156104227934291,
        1.77035528358286, 2.944060387570018,
        1.53586790732527, 1.134254586275434,
        2.61830269914525, 0.8248957563497954,
        0.268535494648875, 1.411465507295464,
        2.68961365738694, 3.073358011228508,
        3.08402962684537, 1.317585861780658,
        2.75612037703375, 1.725429621143924,
        -1.32613551520216, 2.098466886468219,
        -2.62714802320651, 1.429740656917296,
        -0.071915913934842, 2.32015281742551,
        0.017495353035015, 1.252982883663484,
        2.55559524557591, 2.470027445138108,
        0.242090788691266, 1.636481855633722,
        -1.02732145893676, 0.62150604113623,
        -2.25980933639904, 0.9513389751448139,
        2.51108304116401, 1.040883936779035,
        -1.31408777795363, 1.128209030888386,
        -0.926663324788259, 2.266542992697802,
        -1.73137085020312, 1.889075289803137,
        -0.976896107167147, 1.344215762400024,
        1.53996874366752, 1.757131769186053,
        0.292925727250213, 2.039038081873036,
        -0.328624199655766, 2.059908135009238,
        1.64057827581752, 0.2533631520624248,
        -1.70018007269758, 2.225632964679631,
        2.13469804724999, 1.170014688816322,
        0.427548206711208, 2.39150294993114,
        -0.243382632077706, 1.241436615749405,
        -0.068153052460156, 1.127070134099246,
        2.84835049150445, 1.387408047274803,
        -0.561519237120821, 1.936750361462254,
        2.99459680391712, 1.532318365659871,
        -0.0758564040277875, 1.060540432607806,
        -2.806146338212, 2.250058294585966,
        -1.25609622419853, 2.12515056612724,
        -0.716735774070134, 0.03158442147280149,
        2.56658176215178, 2.432449070551561,
        -1.0192034978284, 1.293483688087882,
        0.348143678851318, 0.3826449388879023,
        -1.56364513847577, 1.38255780686425,
        0.83620735998550, 2.535722081143662,
        1.11867529698836, 1.28992870656128,
        0.727056146506211, 1.488491865348075,
        -1.34598186988880, 0.2768809295565415,
        -3.11446729676273, 0.7977169996502635,
        0.750477878138164, 0.5351030628370734,
        -1.95678693944663, 1.256286691665983,
        -2.11513168522657, 1.467186317256058,
        -0.0725694266940718, 0.4388193011904791,
        2.30716629994706, 2.104556757667218,
        -2.91841879152142, 2.303153349761582,
        2.90146742840726, 0.6559553112271357,
        -1.72616665168924, 1.260414354753552,
        2.6319805216436, 2.338924787912809,
        0.639359198049760, 1.245354196752012,
        -1.64780156871674, 0.4375088385703451,
        -2.82228600278288, 1.503750555469397,
        -2.77380513875793, 1.249798626867032,
        0.308144482216306, 0.7095006139827006,
        0.934051635809043, 0.8356938356137892,
        3.0054167367797, 1.642333389242837,
        1.41720301341350, 1.051133805889503,
        0.0255405170874331, 0.9558740037485997,
        -3.14113455198079, 1.12622398638398,
        -2.99726568487956, 1.695651394296208,
        -2.13847614212774, 1.404559249362189,
        0.285705714594488, 2.152385875706361,
        0.611177945020938, 1.870961138358718,
        -0.258821395219926, 2.218762636422969,
        1.27449932061977, 1.570856991023779,
        -3.11458150855012, 1.460131899292508,
        -0.480684119491154, 0.6631278547166419,
        0.798185950528344, 2.564046241411406,
        -0.24861612365066, 1.985512057121629,
        -2.25816842652587, 2.648989810441503,
        0.480064559860308, 2.065182019258693,
        -2.32446205955856, 1.710938890286835,
        -2.62980229218038, 2.159573296030686,
        2.84776221193060, 0.6365220515314431,
        0.279214196276127, 1.57215769896346,
        -0.505451445470549, 1.620866238659965,
        -0.364759113566613, 1.356591041342896,
        -2.25124712924111, 2.684308955861983,
        -2.42974285055868, 0.7133620005453715,
        -2.99270728677974, 1.403833056790243,
        2.87116244561982, 2.405133715270966,
        -0.0638230307205621, 0.8564220306708737,
        2.38367770376384, 1.729444734694564,
        2.31841569669790, 1.711003016038661,
        -0.839481147402853, 1.664160128240519,
        -2.91546458679896, 1.407537154629309,
        -1.62567733660046, 1.285387393180153,
        -1.74468754691463, 2.216723940544106,
        -0.654279612556858, 2.282642949643247,
        0.210274737667093, 0.5467158790595812,
        0.417091077836093, 1.54338508749316,
        1.71492347425209, 1.404857430307519,
        -0.308276017472071, 1.21788278816061,
        0.416881105922324, 1.213443368521228,
        -2.92864474750270, 1.700204246498705,
        2.39039773078525, 1.180722329825877,
        -2.78350894779149, 1.56717942593589,
        0.621902512568957, 1.985231619247714,
        2.39192384099229, 1.246287899264933,
        -1.41710387885677, 0.7007387055658696,
        -1.91897619180151, 2.401629402830859,
        2.00771890350938, 2.056168357567433,
        2.29667127710414, 1.891408540583365,
        -0.00740261691480340, 2.64124793353212,
        2.92695070004328, 1.703359282532587,
        2.20180303409560, 0.2385942334057455,
        3.13559542244272, 1.684570981386635,
        1.0357935925040, 1.885109560779021,
        2.2033624350179, 0.5775161875180261,
        -2.73875655915509, 2.624318702993803,
        -0.0502285670994181, 1.392850265566933,
        -0.0441956055057562, 2.568325483497978,
        1.61713654832186, 1.001778866755461,
        1.17279167448062, 2.497497319678975,
        -1.86279564224182, 1.305284546752735,
        2.55103465206015, 1.05273432227806,
        0.00347806761442846, 1.355956195782664,
        2.80595002316231, 1.003013377637919,
        1.48552847078394, 1.720194980825701,
        -0.748033541720170, 2.205894170190505,
        -1.41651389861011, 1.087478930463984,
        -2.14205144772408, 2.164922465633058,
        -1.47885546524244, 2.139813112218922,
        1.26725624701517, 1.902232826786745,
        1.79123041705199, 1.511214258503475,
        -1.9452050161862, 1.092212161665975,
        2.05843335369061, 0.8049117060933226,
        -3.03357432823045, 1.692248998584461,
        2.1249706219074, 0.5121399193143693,
        -0.522028541701783, 1.407534802214779,
        -2.38440679468478, 0.7365013685471218,
        0.321954589227084, 2.660794204741178,
        -0.174901958723195, 1.505380341190534,
        0.943180901284766, 0.2315516335058549,
        2.34134175791032, 0.4157983847038003,
        -1.41751513954187, 0.4902464953266485,
        -1.17409537244087, 0.9783986782395969,
        0.13185320964319, 2.361350070970561,
        0.997173679838281, 1.53307359944033,
        1.90463051242222, 1.153101668259305,
        -1.28741045375460, 1.924370629031581,
        2.25600173166260, 2.580869214324501,
        -2.57180085706357, 2.433823251995803,
        0.474308803272163, 1.642764541976813,
        0.877654764264701, 1.800650800259202,
        2.14677459988810, 1.947766775362537,
        -3.12713831255823, 2.713682350126578,
        0.597365527533527, 1.311161665467996,
        2.65571953980103, 1.232947231051418,
        -1.45685378550866, 2.106306994589462,
        -2.92635370158804, 2.0024067562835,
        0.00484689137135701, 1.585708641498944,
        1.62665562873026, 1.299315313077921,
        -2.58377721220096, 0.68437490377351,
        -1.39764550611718, 1.121666454716733,
        -1.09520787164723, 1.268649981072888,
        0.362004458823795, 2.195194998799732,
        -0.517269722566839, 1.884796257204795,
        2.13004801890814, 1.633686500160085,
        0.733103259342940, 1.532925164514129,
        -2.38787880178581, 1.245089377389737,
        -1.4983991270890, 1.808521529059813,
        2.29791877014174, 1.648795307875808,
        -0.815389188664972, 2.660917998070817,
        0.991635339750020, 2.486864336004914,
        -2.84258644124007, 1.600589293317916,
        -0.773685626250750, 2.526301003591355,
        -1.89107654975199, 0.7691156835275491,
        -1.7930930970688, 0.5137747095118586,
        2.03132714483384, 1.983832907447909,
        3.02851381770752, 2.275474091338527,
        -0.273214622194916, 1.888866972323881,
        -1.40543998120814, 1.934824082517853,
        -0.491463385447598, 3.071354784779393,
        0.298041760160108, 1.849482998847643,
        0.645730208548480, 2.768808993397307,
        0.101086394972453, 1.545629182702626,
        -1.24466730801354, 0.6673630477638662,
        -2.92667922454600, 0.5791225595307185,
        -0.599527164104169, 0.8060687781927596,
        3.11070988832384, 1.025398464044657,
        -1.51766992721786, 2.440572305820155,
        -0.705473719010404, 2.30055246683952,
        2.54358769948991, 2.507557275427001,
        0.339905180618375, 0.679364352307277,
        2.40146771972691, 1.214238956626538,
        0.296445148400470, 1.925735667879574,
        -0.464312906039405, 2.226928764823646,
        0.120301422833503, 0.651153151452968,
        -1.2011740741557, 2.449759765412352,
        -0.347403401732812, 1.922233936149028,
        0.684389534887359, 1.903944744756566,
        1.62540124556064, 0.6632538443808386,
        -2.45398226094343, 1.660509624958732,
        -0.455200406587990, 1.078561303979943,
        0.804973467230322, 1.555372525584866,
        0.636849335619508, 0.5821119095315931,
        0.567586669697035, 2.64537160754961,
        0.983226767347754, 1.264569178923068,
        -2.50518706962139, 1.829526784959583,
        2.01404790163040, 2.711962739570137,
        -1.86532059352175, 2.392712758647766,
        -1.97390949340874, 2.409624379729332,
        2.81716977138105, 1.120774236819105,
        0.0456305878424953, 0.7994431723501351,
        1.36072019588099, 1.19371677823823,
        0.858669726397533, 1.687586917348089,
        -0.521765839318361, 0.4751477678744873,
        -1.14229288217284, 0.9509080985491075,
        -1.73555497485239, 1.824211493661628,
        -0.993915355140446, 0.7843193009770283,
        -2.26862695624344, 1.663633715848295,
        -1.89862849460621, 0.929664867728675,
        1.87726136527121, 1.726464097724019,
        1.09482620638231, 1.08863401937548,
        1.04722566300718, 1.7855078015744,
        0.809303176771940, 0.5887860540571611,
        1.72856755951129, 1.037105391923703,
        2.2774204900055, 1.586878324399746,
        -0.880008439704513, 0.7254497429537583,
        0.135977503687251, 2.460652024625556,
        2.60023268726782, 0.1707705578816932,
        2.1582797909219, 0.8250968411439306,
        0.28774596445481, 1.379142664128269,
        -0.946443628242743, 1.495216522783051,
        1.30741013307958, 1.343610776296078,
        -0.880870514603168, 2.25305295847513,
        -1.06842287049587, 1.557610148094772,
        2.53835631815042, 0.6979726482518249,
        0.438419949472392, 1.894472206277912,
        -0.154866306535243, 0.4526544403625958,
        -2.70387747956025, 1.323741756934803,
        -2.30685071914086, 1.823394440147831,
        3.12580357049032, 2.29434466237688,
        -2.49420795859895, 1.663799836333712,
        2.10700708556773, 1.746910137406804,
        -2.2855432361652, 1.065630561827439,
        0.961391330142061, 0.4398376206802301,
        2.98801564622397, 1.454280260672288,
        -0.954278035836672, 2.203390526012966,
        2.237045025530, 2.681789785022167,
        2.2503478298226, 1.248305706413586,
        1.05083104842272, 2.396921620747572,
        2.64483666901480, 0.5134714535323858,
        -2.27034346092074, 1.378566463518719,
        -3.09759945246564, 1.55927669769239,
        0.107949747688865, 2.043001569991272,
        -0.856462681628788, 1.172999773491624,
        2.63892801276898, 1.798653052077212,
        1.20767150870890, 1.950868436997553,
        -2.53576687614092, 2.294983267439766,
        -1.20529132497698, 1.544764991137044,
        3.13314917311403, 2.05016488800894,
        -0.0896931044848089, 0.9274636579024198,
        1.31703563154012, 1.507057387494028,
        -1.01113863994542, 1.818329605688351,
        -1.47932913742635, 2.205716914454006,
        -0.0697052632869531, 2.055793871506788,
        1.99394348859321, 2.613794590536323,
        -1.1125980091330, 1.507696063096337,
        -1.99084695187072, 2.343626483874382,
        -2.91596441813129, 0.6423450273877545,
        0.111474318229504, 2.004641261210284,
        1.04927895626609, 1.611330621670103,
        1.4069122599648, 2.252572753616606,
        1.8410389061543, 1.910622338509007,
        -1.98458104117246, 1.862399668980528,
        -0.459691236037191, 1.668691061390462,
        0.471190579981588, 1.802770890459498,
        0.506223283457712, 0.8526418154246919,
        0.60309581887659, 2.198549802455512,
        -2.75396614172034, 2.559165272064411,
        -1.57986281626577, 0.2966302872526178,
        -2.65314539676734, 0.4896273796492304,
        2.87017459927062, 2.092570291996404,
        -2.4347671700946, 2.293632586503202,
        -1.57844266504282, 2.266604712454315,
        1.67536049154154, 1.860353368047478,
        2.02159620285468, 2.485431384137278,
        -1.92726973994134, 1.128478717757964,
        -2.36227179783873, 0.09478359551601701,
        0.270058726720825, 1.263353244980659,
        -2.5307360378780, 0.7456498397337687,
        0.1987008276839, 2.221557329275526,
        -1.68953431095457, 0.9004955017332875,
        1.69530050321232, 2.251451420929099,
        2.64154520254213, 0.9388134648328988,
        2.9500860745848, 2.317731774591045,
        -1.17712229578922, 1.519737774195645,
        -0.229182071155234, 1.796531212656751,
        -1.1139759394691, 1.967525531235975,
        3.11571183339753, 2.016312402574001,
        0.611453507797502, 2.471287817891362,
        -0.951937188968212, 0.8581232779780786,
        0.535719195203944, 1.013993388761164,
        -0.904780313869136, 0.6908036084874422,
        -2.45098510397914, 2.094247982473449,
        -2.99560132331185, 2.026167301711099,
        0.258064395157274, 1.134018887152307,
        1.33270335370601, 1.99854848278194,
        2.37849430404587, 2.184865170169596,
        -0.786184925868431, 1.439870380954287,
        -2.88144412227394, 1.198718140289014,
        -1.62254638603820, 1.352034143907171,
        -1.08299778728464, 2.726842065773217,
        2.23607798507723, 1.770626224793674,
        -1.22976936114950, 1.428609539009863,
        -0.179786811649970, 2.025796553482468,
        -0.785063589533444, 2.149270706956421,
        -0.156103509076371, 1.725159719322054,
        2.35719626782770, 2.336823745199633,
        0.129030665874946, 1.70486422554228,
        2.33237616812438, 0.765693613258147,
        1.61593076988954, 1.760608624733,
        2.45277684186094, 2.456792403573438,
        1.98598471961820, 1.164358864787693,
        -0.712084700483260, 2.420867466950312,
        2.09648790119861, 0.7780752174248616,
        -0.372307510904830, 2.748109537847112,
        1.21239605499235, 1.594888019526792,
        1.63581496924753, 1.39725692318208,
        0.145801807893917, 2.027583014208376,
        -1.92625526501253, 1.805595754562978,
        1.1158663715081, 2.508736519243082,
        -0.104306225881081, 2.135413709472609,
        0.328157547778755, 2.336965105683931,
        -1.56988485748351, 2.347199588252133,
        -0.921540163636485, 1.60542527376981,
        2.25233509948699, 1.696295375873603,
        -0.631362676639720, 0.6959784451751369,
        -1.94499900662069, 1.223085075515097,
        0.777392341679298, 1.051071550036612,
        0.991270604066908, 2.148623817502304,
        1.56330256122569, 0.4923713350236009,
        -2.75335221763722, 2.724521161477826,
        -2.0137013987556, 1.888616917155086,
        -2.51344446112027, 1.439222872439805,
        -1.861994374476, 0.7403521850438695,
        0.821891366491245, 2.776340520029993,
        2.31235677701941, 1.156067127301186,
        1.7447165074331, 2.310062637548925,
        -1.38777639217811, 0.7970529095370132,
        2.57834075955782, 2.164817291873651,
        1.57818740284678, 1.132811918134908,
        2.85287383216612, 1.463474048837727,
        0.0609394251719846, 2.850018912460508,
        -1.97909917787500, 2.856877722219461,
        -2.26907087560034, 0.9894472275288134,
        -1.15870894880633, 0.786123220376818,
        -0.231681025158534, 2.561397754572915,
        2.92798898114652, 2.137456716759775,
        -1.93761151659033, 1.770633635010181,
        -1.24936915724895, 0.4714428277471691,
        -2.90398674440459, 0.4812541036383287,
        -0.663370493644747, 1.678407633743344,
        -1.46466148491719, 0.6786652493324449,
        1.63740464764694, 0.9029148460800095,
        1.37707773181709, 2.566281299773886,
        1.56315767423963, 1.326038669518705,
        2.57152854743358, 1.505207872051185,
        2.98995675564102, 1.608764147028406,
        -2.97004089039763, 2.296322336877791,
        -1.58413010197107, 1.75033169556709,
        -2.34004577540817, 3.044977431966158,
        -0.745306118270598, 1.621971671399612,
        2.90514920325081, 1.269669855792584,
        1.33949307355277, 1.274719337479239,
        -1.27992268935736, 1.199621011744535,
        2.96386585983227, 2.03884713603916,
        1.14411370058481, 1.877878692319896,
        1.01036776681495, 1.774294714861048,
        1.24692241775216, 1.319215366895679,
        2.15112888357070, 2.683366113726436,
        -2.33799830149358, 2.854796666759936,
        -1.74467270312556, 0.851045418200459,
        -2.8804035600321, 1.235776166036467,
        1.09699538626722, 1.522372690507968,
        2.19469789426686, 1.822470696717866,
        1.44941535582743, 1.251749514010523,
        2.6051877040501, 2.029347333800513,
        -1.16336997337710, 1.113273386650175,
        2.3556367789296, 2.438155595182333,
        1.68980224653859, 1.270912481410505,
        -0.5919142767679, 2.675787495053164,
        2.97174320338963, 1.228804626619147,
        -0.721944588082334, 1.870930959640468,
        -2.94036873403407, 0.9574219607614144,
        1.71966330366893, 1.17161190933836,
        -1.52367380101641, 0.8876845981275863,
        -2.35618484053385, 1.268469147950761,
        -3.09572617081665, 1.328082555108382,
        2.90899024013861, 1.30729880180849,
        -2.19350454854796, 1.003537284554994,
        -1.79918268923126, 1.731202527369539,
        0.0629967215615919, 2.17982663398509,
        0.115838334228993, 1.929274847920952,
        -3.06234093228913, 2.786612137541794,
        2.3737582267270, 1.319860926208031,
        3.00870763859618, 1.246024637290923,
        2.39207798222075, 1.692674100483497,
        -2.47080391425909, 2.127967655146277,
        -0.661974303593730, 0.7582761323190974,
        1.93855074131588, 2.337932181980597,
        2.9478898746320, 1.361985536439461,
        -2.10675227932581, 1.789813422788799,
        0.832635151519467, 2.737597927906355,
        -1.33276205935053, 1.571768828071914,
        1.90823164762974, 0.8850326333115189,
        2.44806755665563, 2.737126756228734,
        2.98319714607950, 2.473439779383947,
        -1.81192742864920, 2.691862763817729,
        -0.425766161548138, 2.249908178935673,
        -1.14023951753189, 2.040398968762288,
        -2.46380961778370, 2.871250277883669,
        -1.38078455257255, 2.269274990013178,
        -2.74484303836469, 1.501596513061551,
        -1.56376501868749, 0.6391917499715305,
        -2.45513821275780, 2.02776169804956,
        -1.91317638252788, 2.262395433967553,
        1.84161983549334, 2.600256841828871,
        1.01282380640350, 1.602346725073853,
        -2.95923447276151, 2.095793089845419,
        1.70200187863396, 1.136612395881632,
        -3.08224849217918, 2.482392778673,
        -2.71139297934872, 2.025765796630033,
        2.81428045462974, 2.314151584589755,
        2.92419699660906, 1.495656625958897,
        1.35955405683093, 1.444309192380088,
        -2.24700059518445, 1.440738487945673,
        1.21483803954846, 0.4076142313692075,
        2.5541576184047, 1.579153257504699,
        -0.54189833585733, 0.3096602256993306,
        1.01696994185152, 0.815579166960085,
        -1.26328224194669, 1.769427052425357,
        1.07767586338250, 0.7552135632916948,
        0.421182879733949, 1.412250194015735,
        -2.26392146250550, 2.487436331196134,
        -1.9238843194467, 2.08675483383891,
        -3.09497043754630, 1.291618993634441,
        0.293868838885796, 2.500047804549758,
        0.403110232721180, 1.838567322467775,
        2.65703855701897, 2.93403233118935,
        0.623028709320710, 0.3689459068688488,
        1.63029952425972, 0.5494340296394702,
        2.49801695672801, 2.619451702609538,
        -1.20214011292544, 0.5965801273105507,
        0.7188252056722, 2.171942486740706,
        -1.82069655145287, 1.009303491246323,
        -1.74028184459893, 1.527584375329465,
        2.23210277389279, 1.130364247276643,
        1.45013808500284, 1.951269960042852,
        0.275964057469145, 0.8299725470535695,
        -2.57482413085768, 0.8039758881888316,
        -2.43245745419545, 2.362868086145119,
        -1.35338148418265, 2.300561224229798,
        -1.62955815277610, 0.1475020724572871,
        -1.39751513088190, 0.626090324114481,
        -2.12992146849750, 1.056892303326691,
        -0.782897852181310, 2.626544081474502,
        -1.41113313044213, 1.378956150855453,
        2.2073776499396, 1.745851736700776,
        1.17796759944658, 2.532229070667633,
        -1.38209190700210, 1.481337961536299,
        -2.50221740805983, 1.329474949723814,
        -2.25056340127065, 1.265912708949705,
        -0.0306823433636170, 1.956927549066101,
        0.496291424715216, 0.6617822352913139,
        -1.62900131461194, 1.687298543216294,
        -1.70411321734347, 1.291314847311705,
        1.32697831384456, 1.77415984720723,
        0.933715492775305, 2.485342538629597,
        -2.80667195272562, 1.340336266407528,
        -0.22511922377485, 0.7599872417486855,
        -1.59526098151300, 0.9635034339065982,
        3.12335866805605, 1.818507795803328,
        -0.516607416222290, 2.279272685934593,
        -2.64524967782482, 1.995983326806935,
        -1.91978748266651, 1.609402181089135,
        -2.62438560611808, 0.7437904849332965,
        1.57767675516656, 2.233036535455258,
        2.48057480867080, 1.87996338745832,
        2.62714273505049, 1.557504006405433,
        2.829254340042, 1.703026582659406,
        -0.766136432880219, 0.9187792556573792,
        -2.02441982759505, 0.8044575085891001,
        -1.42887633711186, 1.346255568287775,
        -1.34545061954575, 0.8260702302113049,
        2.8180536231974, 1.887487138422185,
        -1.22538614322322, 0.2176494531850191,
        0.547344964225473, 1.950403953789721,
        2.49894934960704, 2.129055629839168,
        -2.61971088607099, 0.9805389272785965,
        -2.31287938874983, 1.216942873078289,
        -0.941564128413245, 0.7901139138491563,
        -0.899024079431991, 1.12026583924924,
        -2.38204923663615, 2.124941669525914,
        1.28977052258633, 0.5123215971058483,
        -0.0488983142747882, 2.703107220379588,
        -1.12441342888147, 1.292969182326337,
        -2.9527136944741, 2.791636335933651,
        -2.68110289053135, 1.8634905271295,
        1.04469352703650, 0.5564788478006943,
        -2.92993817433772, 1.032284312836151,
        0.0613229132407852, 1.54895754181409,
        2.43598819057821, 2.493661807420418,
        -2.36953220124626, 1.599113473491347,
        -0.923282924820043, 1.914068133683803,
        2.60147049697976, 0.5745554167743434,
        2.68742948509367, 1.209771125616864,
        1.342126500599, 1.809179171771386,
        -0.342556494546089, 1.465709558650275,
        0.720924687478132, 0.7100326844903427,
        1.38700039784168, 1.221735846533269,
        1.45989398365219, 2.203464730487067,
        -1.14777651696043, 0.8192746929482331,
        -1.7225369596452, 0.7052978813736659,
        -1.80097335727077, 1.498743730746848,
        -3.01396682504338, 1.89770740370442,
        -0.0916097739156187, 0.4768039466548175,
        -2.74572571975245, 2.456377376214196,
        -1.74386021040281, 1.694945608699837,
        0.375028016728794, 2.756946146041957,
        2.40097484229192, 2.668459379676514,
        -3.12472794008204, 0.6976661563875731,
        -0.986043028090127, 2.970544240194597,
        -0.556554503100973, 0.7845730629271221,
        0.630813278774410, 1.737372421773105,
        1.34897287487823, 1.576721814846308,
        -1.70945408812639, 1.224254986397511,
        -2.43165169513434, 2.796321705097994,
        2.97469385044282, 0.8498852199031046,
        0.440855672078825, 2.623196339567306,
        -2.37138033217542, 1.131376450433139,
        2.47668532656131, 1.324316759167447,
        2.75408077293772, 0.8311517087214005,
        -1.47472124109363, 1.677060083298143,
        -2.12973356318879, 2.984942068790508,
        -0.485870489072617, 2.125320056399306,
        -0.14750305425437, 1.365064120340343,
        0.402693314409408, 1.312599641532406,
        2.63257980388861, 1.293690083443006,
        -1.60221623914594, 2.234414626038736,
        0.59452663866670, 1.377873618417087,
        -1.52213565078971, 0.9232115552129312,
        1.83080404192655, 1.420436566361171,
        -0.680198254768802, 1.605202935780808,
        -1.89064712371898, 2.327081740334036,
        -0.936309410379014, 2.127102095828312,
        -0.641375060303153, 1.128948363651576,
        0.443175906284548, 2.159948674121662,
        0.811472873411200, 2.240712969409548,
        -3.04341905429566, 0.8515290875709313,
        -2.14516117208048, 1.441746669203124,
        -2.95426489382239, 1.406066263189051,
        -1.12173127976376, 1.121408260264114,
        1.68220014779502, 2.055820914823093,
        2.55611174049441, 2.643665031520803,
        -0.217886735592399, 0.3915012180791542,
        -0.989747852534335, 2.729550475046405,
        2.60426721058519, 0.7487324873682089,
        -1.06049073694628, 2.497977324346654,
        2.24624433486725, 0.412570115198936,
        2.22337400751676, 0.9129199648567828,
        -2.23998316883288, 2.760567701964925,
        -1.04049490386379, 1.842353823678542,
        -0.314952720586747, 1.9437246174717,
        -2.92012743493439, 1.145316434096677,
        0.435318289249130, 1.70541791574896,
        1.95815911068700, 0.9925912339358764,
        1.06950511312361, 1.550814628190615,
        -1.50360746110590, 2.301690940753886,
        -0.0510213856495690, 0.4011086757677431,
        -2.02400960900832, 2.314109255643164,
        -0.494089773090635, 0.5874354020443668,
        1.42182105940961, 2.832993162417515,
        -2.73776760639633, 1.191347929539644,
        1.20854280319182, 0.9478889764896663,
        2.7665400488802, 1.842055440663055,
        -0.713638815964334, 0.3686498058205683,
        2.80679831007687, 1.636623167368373,
        -0.279598404965884, 1.567023694823374,
        -2.7012830021384, 1.171634192770879,
        -0.176380017368162, 1.98813354595258,
        -2.30155155590820, 0.7853845932173368,
        2.58163535827585, 1.886485123702362,
        -0.950013207036691, 1.281419396731507,
        3.10214089061224, 1.851490471208481,
        1.5681399865899, 2.775652286242333,
        2.76209564319739, 1.241194792597007,
        1.60321347071866, 1.329771524038836,
        -1.97492811757968, 1.193954614922596,
        3.10848072350984, 0.8469051656933165,
        2.92703706530074, 1.135781363533633,
        1.67170764210162, 1.563637862255719,
        1.97447996150248, 3.001027673312569,
        -1.94039439887433, 2.336052813920075,
        -1.47885083914711, 2.270417150124106,
        -2.9695580582491, 2.857309101746255,
        -1.31061971086830, 0.9623416182490092,
        -1.97114741580077, 1.602560681069045,
        0.653424186955404, 1.34614300326004,
        2.27383055663685, 0.2709637530246474,
        -2.88278931685672, 1.161324027329971,
        1.38955774636299, 2.798071199778957,
        0.724323279018401, 2.793154848717435,
        0.0346471392686156, 2.072555905436043,
        0.431021322207379, 0.5526473660489939,
        2.5144322773993, 0.2951251634057765,
        3.00061278849189, 2.72738686449184,
        1.92803031954175, 1.460321378909439,
        -2.46216012194935, 2.260967983878339,
        2.48317370899197, 0.590442141683282,
        1.08778366811267, 0.6908504398826877,
        1.17174479452176, 2.733998699446464,
        -0.768643276237414, 0.5381541050327837,
        1.66466180755542, 2.15585004343954,
        2.09850238102785, 0.06963984561841038,
        -3.08324782894780, 1.822293664034904,
        2.59371203435738, 2.531359106495577,
        1.74932568771098, 2.086073812888376,
        -1.52311141442519, 0.9834678159557686,
        1.46815306679594, 1.517836082089528,
        2.62707934053676, 2.259669558502553,
        -1.84218837189418, 1.668936848061498,
        -2.35914002849226, 1.055007480971663,
        0.952687032453061, 1.240326185144571,
        2.33400251695815, 2.474359756433567,
        2.88323718725632, 1.86518105787264,
        -0.890737062523573, 1.934035039209559,
        -2.79622295623843, 1.794639338043728,
        1.16590191802450, 0.6316788613036483,
        -0.966183406534863, 1.871226961482311,
        0.0475416437135738, 1.420393789771477,
        -0.927809618027169, 0.3619421395916014,
        -2.73861558872698, 1.76232006635926,
        -1.04838060026678, 1.804958820517818,
        -2.00685555801586, 2.065131683338453,
        -0.589120123860783, 2.405966283740785,
        2.20369248577684, 2.420133556218277,
        -0.138939048856653, 1.263527296843981,
        -1.24883926132413, 0.5683931724900255,
        1.23704967358795, 1.729313313839802,
        -1.28418359905367, 2.674213312887307,
        -1.01678525029105, 2.428724303513108,
        -0.477323958474227, 2.936233665990983,
        1.73701816008574, 0.8377112050617103,
        -0.668498420626661, 1.504791067205694,
        -0.41403318911721, 1.442202911750232,
        -2.4843756338798, 0.767741541754795,
        0.589246810581490, 0.4686897017096877,
        -0.713565538232156, 1.128287950068877,
        1.99697171982851, 0.5853961491137795,
        -0.438188281698641, 1.818017045098445,
        2.31441297591080, 1.57620613817211,
        -0.388426826336889, 1.129176583756563,
        -2.33080891671668, 1.329994014338644,
        0.11487296497406, 2.425318128857608,
        1.10898203456253, 1.326521873993812,
        -1.13728913169718, 2.243022905540839,
        -2.03537885930183, 0.7402639070244902,
        -0.342533478394542, 1.884178323633921,
        1.39660945220006, 0.4235873216287674,
        -1.24851148320957, 1.49364512116092,
        2.55769493809691, 1.265166364200877,
        -0.25060108419189, 1.43823278507179,
        -1.30119400139609, 2.637261737859248,
        -2.45272470769469, 1.199720431461267,
        3.0708160103532, 1.551949300234347,
        -1.56491850778816, 2.956713188992466,
        1.43050211355988, 2.733122386082888,
        2.56995886035220, 0.8120949221928028,
        2.84155274015355, 1.629285384101289,
        -0.366947862547972, 2.077331932789405,
        0.555319735401793, 0.6707713597343192,
        0.223384298287845, 1.958664558832818,
        -2.17519485733347, 1.589070622851626,
        -3.04382165453656, 0.554418006428568,
        -0.112905341032811, 1.594671882806966,
        0.363678287034014, 1.313519379485383,
        -0.285927667014479, 2.731027122441894,
        -0.0565487496137216, 2.179046379977018,
        -1.26953467458592, 0.6040982721606695,
        3.05456126793780, 0.8968452803284264,
        1.28401453548383, 1.935168354554859,
        2.16022201966082, 0.478284896926253,
        2.42078888723288, 0.7668689525823902,
        -2.27015516583779, 2.552948712281422,
        1.88577097031866, 1.686698648050107,
        0.0337645990776421, 2.480326808998802,
        2.71862796569750, 1.900916424943817,
        1.41902913001126, 1.414888079338442,
        -1.75814376340677, 1.159986679309172,
        -1.42348458987944, 2.400613731123975,
        -2.96741424690110, 2.198306324299027,
        -2.65123932163612, 2.126208446798694,
        2.91241090637302, 2.100065968943273,
        -1.65797970625030, 1.589352336733988,
        -2.68848068505019, 2.353321301480109,
        -2.58346428366891, 2.160722307106127,
        0.99828871270496, 2.28695364620954,
        0.519428327495830, 1.310758320825886,
        -0.0216240327119837, 2.153660290695954,
        2.53700537431748, 2.108811476750303,
        -0.853330732258483, 2.353075100569038,
        -2.68056688631896, 1.796744429916031,
        -0.607408985986410, 1.986882828797121,
        -1.56653722606618, 2.384339983120622,
        1.82126894106941, 1.490743758429795,
        0.277916175003538, 2.229305581941852,
        -2.16618235401836, 1.20497042798696,
        1.15658252394752, 2.697484715370057,
        -2.90917993123590, 0.7054699839815983,
        2.7189329888234, 1.597564443402878,
        1.08461145271341, 2.366680951836311,
        0.0147927356423997, 2.677457516045636,
        2.37392004739882, 2.502712496090913,
        2.54334626000115, 1.479423837769753,
        -0.843008315159544, 1.800467887674913,
        -2.94279637607400, 1.634199260145887,
        -1.6342334102291, 1.453628443216522,
        2.74898213048184, 0.7545288423960391,
        1.50340549479287, 2.190117477953526,
        -0.91982470087928, 1.220751963720058,
        -1.58343009856687, 0.5311959504414647,
        0.786531373013734, 0.8172010648818085,
        0.00642114362115784, 1.939739794257497,
        -1.11003133899305, 1.681152159159144,
        -2.56264140163803, 2.329068114539428,
        -0.166207469224071, 0.8893394145695516,
        -0.17620673897502, 1.556225057802405,
        0.222479637369393, 1.202358720353496,
        -0.210718819804870, 1.967937778304498,
        -1.81560342675744, 1.533074272734749,
        2.2369760972570, 2.059229379145024,
        -0.0877124360141107, 1.72873916637969,
        -1.19096876885652, 1.619907111432651,
        0.968563637802530, 1.339496216287425,
        -0.791767775978662, 2.222839439727068,
        0.113921621123777, 1.280238009179228,
        -0.301411965606974, 1.829923064699284,
        -1.28663586501163, 1.659535890449787,
        2.704078204838, 2.858810449040587,
        1.50291704211968, 2.807605683437366,
        -1.95461364590295, 2.474374389814683,
        -2.80888228326615, 1.268986904279567,
        0.233869901611841, 2.242932298537903,
        -2.68443629733354, 1.66359255195295,
        2.67327486893661, 1.646880366770665,
        -0.953882373713787, 2.380728817313408,
        -1.25187790858465, 0.8989676648117927,
        2.52811506100202, 2.766469237110055,
        1.67529733433857, 1.400710152872251,
        0.83849898786551, 2.17736076608848,
        1.31737475618399, 1.673759501762871,
        -2.18800226695106, 0.2309359993472917,
        -1.41858518422889, 0.3353464838356616,
        1.96640032919221, 0.4211878808438319,
        0.655694432247922, 0.232716576761688,
        -0.111228302809562, 2.555406741822186,
        -2.51515789215268, 2.946472381074925,
        1.73485521775344, 1.535793421937293,
        -1.81805377827091, 0.6815467930163894,
        1.58769272036913, 2.642828156730252,
        1.45465442883418, 1.885594304814989,
        1.90624404219565, 1.398959895667404,
        -2.02447042359568, 2.580088474055014,
        2.02125360549553, 1.671459096443702,
        -2.34756693000278, 2.055841057739511,
        -0.491665734798563, 1.94681903421719,
        2.95236303437855, 0.676689896054316,
        -1.45586480800396, 2.172460678496308,
        0.512056188530763, 1.643814260318301,
        3.01585954577738, 2.765555719125496,
        1.80125283771427, 1.348067451828624,
        -2.51949606749764, 1.996248294397075,
        0.500565594587763, 2.476146707297885,
        -1.83059859488559, 0.7144811349104394,
        1.39391365729749, 1.680243796899978,
        -0.218363514742171, 2.043947070395414,
        -0.0354839190307648, 2.076476596540879,
        0.521637300264719, 0.120750968674461,
        -1.30282610339840, 2.297062581731897,
        -2.55718574980435, 1.173526882097409,
        -1.84208575500620, 2.31832641849173,
        -1.54683191462421, 1.216268314440492,
        1.84147663790138, 1.350325217473021,
        -0.084558242369231, 2.801884892241382,
        2.27983086821113, 1.002350571965236,
        -2.53102220767636, 0.7848789555185344,
        -1.99870539503319, 0.9327898268030059,
        -2.97049867801458, 1.016383402159442,
        -2.38675266390032, 1.825051614002463,
        -2.15645311981668, 2.29676290018132,
        -2.56763495217809, 2.8464568800685,
        -1.26511827935595, 2.39519630550778,
        1.19618598990083, 1.129561588786226,
        -2.63013546029202, 0.4251537876368067,
        2.75912944996943, 0.9078243893167609,
        -2.39304980777750, 1.282874757347363,
        -1.22088094983697, 1.468140421796924,
        0.947620831699994, 1.107527554232748,
        -1.69837215935075, 0.8621598868623089,
        0.238798575015320, 1.507736031538992,
        -1.09905473466623, 1.407359656494672,
        2.53490507116379, 2.030306544663355,
        -0.508930765602099, 2.241610562865227,
        2.63704205289589, 1.334974383548273,
        -1.02373750653495, 1.606928641136793,
        -0.0940965445419733, 0.7944697072273522,
        -2.0119147905687, 0.8701854306717273,
        -2.45283913335960, 2.584362412249849,
        1.0057327256092, 1.499692141366295,
        -2.57276730731529, 1.596664048365857,
        -3.09355479470457, 1.494670426306264,
        2.00644836802505, 2.288313264712745,
        0.0634522148890689, 1.385593091431601,
        -1.36634037714849, 1.762171080715788,
        -0.466878991848443, 0.8230694681137651,
        -0.435986004169530, 1.176719692809425,
        -1.35685438693314, 0.9611942541831852,
        -2.29913533437948, 2.219693543196242,
        -0.816820817820903, 2.494378338293513,
        1.52125433137214, 0.7016204674446649,
        3.08355074175465, 1.354431524558966,
        -1.74487329324237, 2.296633990185903,
        -1.33788590776051, 1.532105523177356,
        -1.70073056292086, 1.75763905477838,
        -0.316600201357780, 1.544209944735692,
        0.806831674622978, 0.8515198602184983,
        1.46742184435070, 1.217945502529442,
        -0.748341735731624, 0.7785276274782593,
        -0.58929386728907, 1.698633869377242,
        0.698185054249474, 2.017983708185278,
        2.60130651725526, 1.990299331890354,
        0.551030178438229, 1.51119858908006,
        1.51695877685580, 2.1519619581999,
        0.77357814671034, 2.481618189813056,
        1.62006582121106, 0.2194488382837221,
        1.9581473417178, 1.313624283750027,
        -1.193268178649, 1.444019090374353,
        -0.290821559368526, 2.618469665568133,
        1.90182197195592, 1.753906730284752,
        2.44779775702476, 1.748383629650031,
        0.903150020876478, 0.8634510525650623,
        0.402952188796804, 1.875466472252452,
        1.0939195008716, 1.833081791181404,
        -2.17452035448507, 1.241803408757022,
        1.57333179403679, 2.272060846762225,
        -0.058382139120973, 1.025247024177896,
        -1.71394552116792, 1.097666255879191,
        2.87322989156322, 1.929655971392255,
        1.08436545343583, 1.796419077737196,
        1.77613848521790, 1.821010533562591,
        -2.46161123956241, 1.275515813788539,
        -2.26410304426285, 1.874698530697368,
        -0.78761656040537, 1.127862824464857,
        0.772486164897702, 1.284859063546969,
        -0.231360348595589, 0.7987644603019844,
        0.666941351009422, 1.752747439690619,
        -1.04793503207074, 0.202318811079038,
        -2.6230566647034, 1.057309627439461,
        -2.69654271176710, 2.124055371482266,
        -1.02068625073049, 2.289694004777951,
        -2.85639395014100, 1.695829272577707,
        -0.694075173748232, 2.046464275053444,
        -2.89350565162832, 1.69729788225911,
        -2.77342355211613, 1.988748595463976,
        0.156346514918882, 1.016047596779226,
        -1.97456902856894, 2.306487685098344,
        -1.36945465172686, 2.101822937506326,
        -1.17882588073879, 1.346035508325076,
        -1.16971258376384, 2.619942667554236,
        -2.20260937812501, 1.566442786233293,
        1.25800393837114, 2.441700810277595,
        1.04672856470866, 0.7853772973286727,
        1.19472398241800, 2.147902182012416,
        -0.358844466439204, 1.750285789449257,
        3.04794108941372, 1.300407798719592,
        -1.7213603061605, 1.325841075640953,
        1.93702356739085, 1.866309846372372,
        -2.59862682209700, 0.3615100853749549,
        -1.64974206336889, 1.187860667662253,
        -1.13126460547102, 1.742427845432828,
        -1.20501841557727, 1.106948724608758,
        2.0404714815372, 0.614610247447961,
        -0.7774740568738, 2.468422126094985,
        0.23070700606717, 1.267296962837299,
        -1.62775453044187, 1.520444763514823,
        1.47934158843495, 2.606988361413181,
        -2.04397616318815, 0.6719247340984437,
        -0.769230282183213, 0.8808079058004427,
        2.35104948320245, 2.051057021611958,
        2.1156104806778, 1.922414054524454,
        -2.68719202550292, 0.6871149635832843,
        -2.90159277328082, 1.569966951215729,
        0.0321640004150931, 0.836947811179689,
        2.0669788555286, 0.5808139475407171,
        0.475705149287959, 2.375129869989379,
        1.22072394931322, 1.473257684929778,
        -0.837440774127566, 2.53086377976171,
        -1.8664866459410, 2.530095668100565,
        0.189867544388840, 1.110238223631583,
        1.00537156983032, 1.566961130901683,
        -0.20436973490827, 1.534028406839468,
        -0.0708261754491981, 0.7186208901566193,
        -0.564598688134041, 0.7466780717385482,
        -0.814547186508353, 1.226211768079457,
        -1.43566740041726, 1.836137531826044,
        1.70993511339978, 0.9369646785509453,
        -3.02066142865536, 2.289619516246618,
        -2.36723693111370, 0.4637699173956457,
        2.60975941244398, 2.067572521400704,
        1.57364075748835, 1.425175104211714,
        -2.33454950211439, 0.2864615184975309,
        0.505884042869438, 1.778988909431088,
        0.162096335230641, 1.573224264681142,
        -0.777043816571660, 1.7848068879905,
        -0.621813736772500, 2.478517393002936,
        0.0254244164252860, 1.388324082043847,
        2.79367017605951, 1.576251057477678,
        -1.54516279345722, 1.58277076110277,
        0.486682862551476, 0.9503092599582657,
        -0.527160821972393, 2.13964664188747,
        0.6867077543101, 1.415033680399402,
        -1.44237536917510, 1.185364165504398,
        0.404805873583791, 2.063494295544082,
        0.781961240813942, 1.620955793356045,
        -1.88771126721781, 1.443377987931025,
        1.6907581679337, 0.5702010376367915,
        -3.03395557472052, 2.254623860783526,
        -2.80276801425799, 1.599563994199681,
        -2.62695535617471, 1.133448142633239,
        -1.89996674613488, 1.772582558497238,
        -1.51357925473311, 1.67995173524786,
        -0.820097957654057, 0.4644619499490111,
        -0.836588875370817, 1.287260560785317,
        0.367873846767119, 1.967448897756342,
        -1.21094794571190, 2.922549937365657,
        1.41111723568746, 0.8840610380704342,
        -1.11789954934863, 1.64428029423316,
        -0.0519030611092695, 1.709506828063817,
        1.85936367398576, 0.8797247129174323,
        -1.52659301249595, 2.204716407786516,
        -2.06854058221611, 0.4603130350915974,
        2.31867481082295, 1.404039039684013,
        0.921457809049434, 1.850744747370123,
        -2.31135971760674, 0.6451739587897515,
        -0.55969861565859, 1.536022079380211,
        -0.0611262826295136, 0.263951427603537,
        -1.49964808492018, 0.9529641175727203,
        -0.160922356795632, 1.800287228109048,
        2.23650182439821, 1.462693371262286,
        2.07848753892344, 1.721607812994492,
        1.46391102504732, 1.752294810210177,
        -0.9174699410579, 1.779217838325674,
        0.642677829144520, 1.545946640152687,
        -0.0721565437875027, 1.360159457464704,
        -0.122409270775389, 2.518083079841672,
        -0.0930381892105516, 1.095299771326619,
        -1.10327461008305, 1.058544345313928,
        -2.579423867970, 0.9615335765660334,
        2.57211862330596, 0.9886122502522823,
        -1.25144438881282, 2.023689691849463,
        1.09367716111770, 1.65961437763618,
        2.26076466951209, 1.659732055542502,
        -0.123018211537293, 0.8996294075188614,
        0.252085163127870, 1.299059271145248,
        -1.9117539203815, 2.123245038974412,
        -2.47471996460997, 2.061602296639169,
        0.938973548144760, 1.490880322095434,
        -2.43368310761268, 0.01814316122992709,
        2.68620042010153, 0.6622702581693488,
        -2.04067767098589, 1.139442288456247,
        2.9215924852024, 2.033722484659038,
        0.190290035730525, 0.9083894461679493,
        2.38744013482229, 2.071283578093337,
        -0.369182541375926, 0.7687365676827793,
        -2.17127186921249, 2.51982073318224,
        -0.375336323499971, 2.155873313268733,
        0.00238460941976846, 0.9884976075979195,
        -0.958214344998582, 2.062717322962885,
        -3.0477628603006, 1.369899030931146,
        1.95648271196177, 0.8911615202984819,
        -1.67385510041550, 1.855546028432354,
        0.666686222532709, 0.4809859519834555,
        1.21434330100816, 1.761129902849661,
        -1.99447868418699, 2.242225001454015,
        2.12436671204979, 1.131419323718212,
        -1.6066157411738, 1.718911686526578,
        -0.942538559827946, 0.4256291862535929,
        3.006155278361, 2.043005921733656,
        -1.02649541052154, 0.06633320857528661,
        -0.0162038027393941, 0.7070362527611855,
        -0.712652645395363, 2.266191786303083,
        -1.58618290305676, 1.283381438692878,
        1.98868101608853, 1.338659296872701,
        -1.63515177928733, 1.921432905502826,
        -1.77405540714292, 0.7122355709443103,
        -1.6329674001398, 1.087637067586135,
        -1.02927252364368, 2.695423094618282,
        1.27934988047901, 2.341379631027881,
        1.85080921450419, 2.361704367461513,
        2.51773892224109, 1.589705715403807,
        0.629338713515238, 2.061636119382768,
        2.8609910261185, 1.727159025385398,
        1.1463671355955, 1.177715462795495,
        -0.797642967815484, 1.015592428770451,
        3.10800101322957, 1.146401939622219,
        -0.565194964916842, 2.774034442324692,
        2.16343785701838, 1.14411678485348,
        2.50862421545136, 2.802588074173495,
        1.32131932615010, 2.234487977443599,
        2.84187563157132, 0.9041342660601015,
        -0.345340542176556, 2.40854714268258,
        -0.619155981500074, 0.732875607982383,
        0.236478699994170, 0.2501050628543701,
        -2.70247038446525, 1.696448970612281,
        2.63117174886460, 0.4768691547386353,
        -1.57023024369199, 2.138136714874055,
        2.4325679198000, 1.020491416772224,
        1.13310457701140, 0.863746390117603,
        0.990024365478805, 1.662901771370906,
        1.93169411864159, 1.123412734108752,
        -3.05975894140931, 1.338607345471605,
        -2.87840350277900, 1.308058364298954,
        -1.00941158455269, 2.252410414697811,
        -0.850365602953248, 0.9258785519570204,
        -1.86916686363611, 1.893221113040001,
        2.80317943810972, 0.9637635112101166,
        -0.718608027104101, 1.984358749630244,
        0.921312781712405, 1.216646391295134,
        0.300812542319793, 1.478339709580244,
        -0.273321692637055, 0.9474005864175487,
        2.75691755196808, 2.263582696130143,
        -2.12038682882017, 2.679236428047803,
        0.381339195713639, 1.280069399844469,
        2.1318801071530, 1.0288546551588,
        0.140989262756793, 1.542289752118744,
        -0.220689892891070, 1.683669226497051,
        -0.487851740510412, 1.019809078040642,
        -1.85046507543229, 2.493560472419481,
        2.92888631283415, 0.8664818847918182,
        2.99744300256615, 1.095930427934597,
        -1.39552193468851, 1.572358064558005,
        -1.88127343729810, 2.096381477822258,
        -1.68234833207618, 1.322753479144819,
        0.50895429479385, 0.9170727114630239,
        -2.47833551847515, 1.42646171761562,
        1.86358289442438, 0.6038044621800526,
        -1.27722246043825, 1.991929382978579,
        2.81078228034179, 2.145961956365248,
        -1.21576725500328, 2.220888429098811,
        0.175342252008450, 2.087680822697523,
        -2.36541222680507, 1.093261052754786,
        -0.15455287549420, 0.8496025563657331,
        -1.90501543873927, 2.022235501070274,
        2.15270899338206, 1.909881620512786,
        -0.992939835237775, 0.5237999608501668,
        2.56279113721256, 1.542140860308385,
        -1.90887473673480, 1.884468306987115,
        -1.50504011683649, 2.853502098319823,
        2.51129280621778, 0.9012372534810417,
        2.45711272024521, 2.226456271925644,
        -1.60527194578273, 1.55273098332527,
        2.90923006405060, 2.672577024432734,
        -0.298031238735560, 1.283473441389273,
        2.22681719610953, 1.847291620788806,
        2.20351831513958, 2.035330630464762,
        -2.03258692752617, 1.67766944252611,
        2.63944965974506, 2.010236152340838,
        -1.8809720082295, 1.670875735553269,
        2.8286470144392, 1.82124781134049,
        1.58931710885590, 2.191613916022138,
        0.899787298403059, 1.122450918397388,
        1.64087017951899, 1.10048310899644,
        1.42674096093853, 1.982227717991952,
        3.0002885740720, 1.133212157048366,
        1.43886936913344, 1.616530608185278,
        0.372485566321661, 3.057784053269125,
        2.34640050077588, 1.842356896388952,
        -2.33089281800670, 1.54480282804122,
        -1.52650712928671, 1.248634287146245,
        -0.236134779601469, 2.523585590050279,
        -2.01408232189344, 1.065318853121499,
        2.54046726393266, 2.223281839847326,
        0.751993024216590, 1.083341176376365,
        2.40124659804414, 1.794788625524968,
        -2.84714342081119, 1.140287987266858,
        2.69155584947432, 1.711050586031556,
        -2.48176130578914, 1.139699055989533,
        3.01162536023103, 1.283387731894011,
        2.55938916183374, 1.091396554248234,
        1.70585661602723, 2.088143760238296,
        3.13913519971296, 0.3649654186779321,
        2.08014862028595, 2.207048234465326,
        2.39929465138550, 3.044120652922428,
        -0.91162301240134, 1.332505660117653,
        -1.57931910114342, 0.7530305104920253,
        0.531467708091002, 1.677674403619077,
        -0.995052162139343, 1.018497130659039,
        -0.0830211031373722, 0.7568038043130464,
        1.32909527375813, 0.7582618955968907,
        -2.28498360603669, 2.286387007972363,
        -1.57238053052389, 2.53538932634638,
        -2.70584855616181, 1.500217168561072,
        -2.8601408545770, 2.530652779263809,
        -1.94619594789735, 2.231691445399076,
        -0.107208686564336, 2.066133986600498,
        -3.09025108678486, 2.084856599359949,
        -2.47792123961258, 1.995251514475995,
        1.3863942725478, 1.579446204621702,
        -0.954174009492916, 1.767449406641712,
        1.73077954924053, 1.438762859817779,
        0.797038389641328, 0.1726272323425088,
        -1.50758942128449, 2.668110734411526,
        2.91392146415968, 1.935009657624373,
        -1.83495610718147, 0.9720072541139583,
        1.27407891040799, 0.377216133479325,
        0.682265102458840, 2.194535721983244,
        -3.09403291205058, 0.5267989269179957,
        2.65873407190143, 2.764567815435282,
        -0.974935454404655, 1.520139543973251,
        -0.826157511552890, 1.112131193618487,
        1.08160504081293, 2.885456420900767,
        -0.948789724927789, 2.024184101015652,
        -0.24018622113519, 0.5075126391629134,
        1.76780235854537, 2.051658666210635,
        1.53462992005302, 1.890330477311135,
        -0.359492123085031, 1.633782318390325,
        -2.56626560946336, 1.287820295704135,
        2.97955007575183, 2.9387729967267,
        -1.32678763087725, 1.928783024855887,
        -1.60475567243946, 1.317558743362456,
        -2.15597575372676, 2.199672532555007,
        0.419513867195767, 0.9862183181507553,
        0.387282800238036, 2.529206844905336,
        1.5033381734514, 0.5511732451989976,
        2.91799930826161, 1.420559333270508,
        -1.51494475515427, 2.516294544358535,
        1.70155526152069, 2.331051849605431,
        1.10736153855270, 1.189457692570615,
        -1.79207725475152, 0.8416847126872276,
        1.17345183802469, 2.081570310918045,
        -3.09805975677559, 1.218071178639751,
        1.1434852215088, 2.661089382252685,
        -0.930572238690932, 1.879924406280252,
        -0.422736381701062, 0.7152495518583109,
        -2.04402559557987, 0.8400396984152965,
        2.5018566941371, 1.179999280434218,
        2.96633678355451, 0.6011638612085438,
        0.117478327428039, 1.891635201594508,
        -3.09529111472221, 2.153274080785839,
        -2.34352516884345, 2.930835640833189,
        -1.37157134608044, 0.7248430822219827,
        -3.06786712346088, 1.121686912219399,
        -2.74155392513903, 2.12116535321152,
        -0.0145038192038281, 1.689663963944609,
        -3.05660723327778, 0.8898078416673072,
        0.983123161703914, 1.626183278807921,
        -2.76616118388230, 1.926104800034201,
        -2.93660076160960, 2.365777770977529,
        -2.66472203422785, 1.962783861623458,
        0.914861649706851, 2.304127923675918,
        2.66562891438421, 0.8386515466420965,
        -0.377321446072460, 1.592432612226854,
        0.951454689494039, 1.825532413648215,
        -0.472159955834299, 2.047519440677925,
        2.88551908294995, 1.44183725339257,
        -1.69935397209475, 1.357412615445276,
        2.89788246471724, 0.6940094534530905,
        -2.308117738432, 2.518996668456448,
        -2.80317884525267, 1.53560093845472,
        0.690286391544883, 1.655635511447219,
        0.367832269030693, 1.929663993880968,
        -3.03821860734777, 0.2551512085001082,
        2.49264000821967, 1.701305344133318,
        2.6039386946938, 1.315796165289091,
        0.79880142943683, 1.512536527925176,
        3.06372520370152, 1.849047577720865,
        0.136130208535732, 1.480177682113957,
        -2.51118076947688, 2.26145850577599,
        -0.0175018529936697, 1.556284746855717,
        0.434287082188117, 1.777343942812643,
        -1.92321898775476, 1.060754193578659,
        -1.1441983069259, 0.6902095216845493,
        3.11977506554302, 1.412358046499624,
        1.54087475609236, 1.357238923877391,
        2.03280463497400, 2.216731567687316,
        2.91443231464825, 2.204169349078989,
        2.43928107381151, 2.875195666918646,
        2.01950658310358, 2.867204565694056,
        0.353312109301028, 2.271140636565409,
        -1.18246207857205, 2.048072100825037,
        2.73107410730879, 1.835322865528779,
        0.946724505239289, 1.45263823087678,
        -2.84247704992586, 1.331323679871188,
        0.115414280016793, 2.184932886347728,
        -2.40591597662066, 0.5964253720577548,
        -1.46367450050208, 2.376460473872229,
        -2.75871671664838, 1.728757395803491,
        -2.3611728365082, 2.455965263712406,
        -1.93713514697768, 1.911171948743357,
        -2.60826971479808, 1.663801273980499,
        -1.84055600267558, 0.8344453437784684,
        -2.60356414697209, 1.797438699987748,
        1.92816057670233, 0.5933473399521859,
        -0.126216796252581, 2.269091475334314,
        1.21506080755366, 1.193632209754036,
        -2.89407716008644, 2.563118831551169,
        0.726504242674752, 1.95734443655826,
        -1.25112596486834, 1.670266816940945,
        -2.53872607253311, 2.095531957014858,
        -2.12658998574058, 1.194251733626457,
        1.6739947466462, 1.728729922476411,
        -2.98248650216471, 1.732645500873249,
        -2.64729415235185, 0.5904174054002097,
        0.717605812026126, 2.466454028514478,
        -0.572827258844960, 2.639669039363886,
        2.38809819089800, 1.556082339391991,
        2.99517639159938, 0.4889527662149795,
        0.323909242047950, 2.174124630969831,
        1.16868852550986, 0.1839910452373022,
        2.35558259686237, 2.843416541181932,
        -2.01937040276502, 1.507085390828971,
        0.275942436982700, 1.098959007118344,
        2.08513554677402, 1.374129560221779,
        2.08883065650020, 2.305366011465689,
        -1.8779422120606, 2.289131944608772,
        -1.72729884455120, 1.660618358255334,
        2.68214700125726, 1.609422861013626,
        0.207878040754101, 1.075250970128065,
        -1.31760240561839, 1.995986750100177,
        -0.666912017237864, 1.364776598122895,
        -1.54577199003259, 2.106751371841134,
        1.54508096745462, 1.690105852898603,
        0.214441469245655, 1.370182962103344,
        -3.03401245962041, 2.555639755644114,
        -2.14237416536172, 0.5871847971582332,
        2.67525087147573, 1.786256342429239,
        -0.860771213955802, 0.3303241556303138,
        -2.68370483304468, 1.929506647695417,
        3.11100986133651, 2.396538353142273,
        -0.105385564562937, 2.029586086038878,
        1.38109213547354, 1.812602112838768,
        -0.759535003049373, 1.858924882549888,
        0.0693575881924229, 1.022993221254447,
        -0.199117320652402, 0.6061600417841465,
        0.376112432417893, 0.8215067024365844,
        2.53011565222838, 2.544933543057507,
        0.125574033061278, 0.9505373343464631,
        -2.86213932719495, 1.632482681030234,
        -0.945335844338284, 2.165413864695751,
        2.40511350883765, 1.892444718277522,
        2.50104579465325, 1.6639318859806,
        1.98790519639339, 0.9635868324909104,
        -0.861677202867420, 1.964268271619908,
        2.34562938423725, 1.292659049370074,
        -0.355587373650398, 0.9364599273957376,
        -2.43088899240188, 1.759251160783405,
        0.437058903863074, 1.510887137106045,
        -0.686553433173483, 0.8751958658921489,
        -2.41726489685664, 1.959556418928616,
        -2.32478906006299, 1.506082359837687,
        -0.00127216260032962, 1.288161789243247,
        -1.2408064007199, 1.204869107067145,
        1.14773550589191, 1.315650525878598,
        0.764505389340871, 1.972221752203904,
        1.54376067819295, 1.522456449123908,
        0.664105865480262, 2.040089022656472,
        -1.50269319580742, 0.5820208873943044,
        -0.209275273509432, 1.336298954261925,
        -2.85917701068334, 1.97795022282755,
        -1.14819688084835, 0.3643050631326952,
        1.33359746592457, 1.165731214447166,
        2.59425809476088, 0.7103478051783304,
        0.558362464920050, 1.310728605047382,
        -0.0507159673111277, 1.092978268468249,
        -3.1197651768735, 1.589359597377643,
        -1.59031980341784, 1.518334373460013,
        -0.312109526376157, 0.5635507778893539,
        -0.938125157795689, 1.532045560174892,
        2.81155842599399, 2.958211861663813,
        -0.594387416546350, 1.385498669799239,
        0.164732031055795, 1.637899558548821,
        0.59065387655432, 2.044298832478638,
        0.891831923367049, 2.228290016295651,
        1.99742697639435, 1.302978079778562,
        0.60746668847912, 0.5063514568205835,
        -2.07815774421844, 0.5334090889308146,
        1.07872744210443, 0.9553471982495557,
        0.607186444923004, 1.61187120051359,
        1.77020986805974, 2.589132362865136,
        0.441263557174138, 2.007739238405868,
        -2.70655296160548, 0.7904757929127815,
        -0.4480525588312, 1.894006119480472,
        -1.24517559550434, 1.271271048885165,
        1.48055839920133, 0.4373982469088062,
        -0.319679061564579, 0.9590733488797337,
        1.71607491299364, 2.403915091574345,
        -1.11161938693122, 2.068300050444577,
        2.17889477767128, 1.720983822697843,
        -0.613024086930255, 2.165147920458757,
        3.12684932404034, 0.9493321799658785,
        1.27585594628501, 0.8909780872406753,
        -0.451400631003899, 2.149077983029343,
        2.46689775891066, 1.362380231257255,
        -1.1686320686867, 1.729713654092925,
        -0.996277893801899, 0.7218137202118854,
        -2.16599881441247, 1.664917989609813,
        -1.88193441542405, 2.992158526761472,
        -0.664422518938555, 0.1989986159089469,
        -0.440992539566128, 0.5279359986138694,
        0.297161033429254, 1.887821990272528,
        1.93144764191375, 1.221885898274321,
        0.0225641019664550, 1.188383028077725,
        0.103477110375441, 2.785298070696721,
        0.323083253462887, 2.530819038416873,
        0.435507249867881, 2.314200600658128,
        1.6853000271766, 0.608062562177636,
        1.03160523978593, 2.020594701651639,
        -2.0765320836482, 0.810526938516226,
        -0.925340452484188, 0.5914878493469482,
        0.588626157435068, 1.578600900435228,
        -2.87713883109843, 0.3176794207276647,
        -1.40631346227797, 1.507231385893767,
        2.73694417544142, 0.6397737885095161,
        -1.02716037433501, 1.432750005902935,
        0.365513832307728, 2.497353593476138,
        -2.06566037246260, 1.38241586707815,
        -2.03023216306707, 2.416131478397989,
        0.139111183274655, 1.377456871254012,
        1.84562285472890, 1.386214439600349,
        -3.10606987197556, 1.106687912797044,
        -0.835402420022123, 1.529078355456118,
        -0.813091914336142, 1.329475559904456,
        3.13651264633539, 2.575062121337395,
        0.348236221855589, 0.6130906387831885,
        -0.84203889219269, 2.276527333824436,
        -3.06520236995297, 2.186027571758317,
        2.79311945828380, 2.020289918568291,
        2.39231502874686, 1.99671335693178,
        0.961918590283112, 0.48506169391082,
        2.51099815397587, 1.766690225577485,
        -3.05796633017160, 2.316902983671202,
        -1.44445631393850, 1.250008346897556,
        2.24041320937317, 1.59800777026397,
        2.61580278071623, 0.4403289496923999,
        -1.8362728128672, 2.456876284943038,
        2.13680515729112, 0.5788565572147961,
        2.46973661302196, 1.499772837049721,
        -1.6177140291366, 1.818580984718536,
        -2.31867337332188, 1.04088946963373,
        -2.34421904680454, 0.1719409452315404,
        2.60309159889294, 1.950338323427687,
        1.46943733890375, 1.110663213920048,
        0.686962766352775, 2.233638180051383,
        -1.47507794209782, 1.839309518614522,
        1.9369183975910, 2.134921810904816,
        1.52356335151086, 2.512983178542427,
        -1.84943727716803, 1.139966168960923,
        0.953957915433787, 1.41467211083825,
        -1.38710728489195, 1.731953484077736,
        -1.30814792622442, 0.4457372439672937,
        -2.42341986716327, 1.510528922342624,
        -1.04422504379324, 1.668750816866906,
        0.0912612351950703, 1.21460391641285,
        -0.683204627607424, 1.741993908725523,
        -1.28374962147539, 1.480515655114431,
        -0.477331409854086, 1.456861559491316,
        -2.0075981324391, 1.608711957053256,
        0.393119518982478, 1.182418503179985,
        -1.12509910620412, 2.104997931801754,
        -0.247382599799478, 0.5458227430501751,
        -0.431970969252181, 1.506729897197401,
        -1.50625584462095, 2.817477510973229,
        -2.21735116430616, 1.465292176856459,
        -1.07831059689365, 1.343580387485884,
        -0.341812580443237, 2.255289739824021,
        -1.58279238487082, 1.584917952175907,
        -1.24065085637702, 1.531890830543453,
        -2.08582464415871, 1.319034991748132,
        -1.40284934342156, 2.51167006328828,
        -1.57263823905620, 0.6751313444475999,
        -0.850286277415288, 0.4291732262244197,
        2.67109028092269, 1.346619912302922,
        0.475791016181012, 1.951657097130911,
        0.819019484060290, 0.5532914879538068,
        -2.58296815433019, 2.095296105627936,
        -1.02834506355842, 1.043425928326896,
        -2.19571302076422, 0.615702889431732,
        -2.04237430125803, 2.35056244142689,
        -1.73789976934136, 1.360412954839672,
        0.905060708022068, 0.7557097746455395,
        -0.917515204180752, 0.8299434025956942,
        -2.81556093658883, 2.317010890062675,
        1.14512130052704, 1.466224610135177,
        -1.40668199944559, 2.237152039216288,
        -1.69589770481307, 2.78142309190621,
        -1.79844103152908, 2.211310857039408,
        3.11717527461787, 1.48742466811844,
        0.401356953243232, 2.216057591668618,
        -0.109886716442089, 1.36269955109861,
        1.1149220928719, 1.59628468320451,
        2.57337694674348, 1.642942369278505,
        -0.621924568056032, 2.202200429965529,
        0.482429791017951, 0.8856069866193735,
        -0.776993405476373, 1.23970417833425,
        1.44871095586624, 2.014843015596281,
        2.04986318195638, 1.696438259492169,
        -0.475075578844503, 0.7015241754201519,
        2.00593833593704, 1.884923420345767,
        -0.913739641452327, 0.2973535575568528,
        -2.13899244110462, 2.261563234705141,
        -0.437791548354779, 1.330510123155958,
        -0.900943644441617, 1.854997410153646,
        -2.4940159298238, 1.253755128148356,
        2.15569042168146, 1.872738790056311,
        -3.05974544719807, 2.519392480717706,
        -0.873672814682680, 2.215193848625311,
        2.19144460847341, 1.510925205823275,
        -2.33210757708195, 1.669669898233132,
        0.957931539219761, 2.416566035520244,
        -3.02297740667340, 1.795164660755007,
        -1.30219802851635, 1.9602936988055,
        -1.24655809238728, 2.474307614786986,
        -2.46563508192253, 0.5786986284016213,
        -1.17649055886144, 1.077661744667777,
        0.282218501533287, 1.702848697156964,
        2.58037698513325, 1.468217849463735,
        -2.25334923200490, 1.738569651100935,
        2.61496630927618, 0.6113752065893892,
        1.00647708423776, 2.5198223187489,
        -2.68607597097926, 1.466978284705901,
        2.42017126219289, 1.720379939070367,
        -0.761643759887392, 1.549082296574973,
        0.36462259080091, 1.379894677331529,
        1.77168415989561, 0.733914210863327,
        -1.80786227489456, 1.599688344207466,
        1.49356947560464, 1.13997557917496,
        2.46314248657145, 0.2009718440050985,
        1.26731348040369, 2.748415109449225,
        0.691350749215061, 1.347721870538732,
        -2.99155575837347, 0.8454983386274944,
        -2.98807020074059, 1.263962595505443,
        2.08443936014567, 2.487127573861743,
        0.342844014224634, 0.1509263747504384,
        -0.851345689483826, 1.211669787676845,
        2.32196895426960, 1.953895194802337,
        -1.528351951413, 0.848894239574697,
        0.288482183282138, 0.480376219438438,
        0.65336699443254, 0.913552287513244,
        0.83567905787353, 1.09037089008918,
        -0.0555678640856131, 1.748045306185567,
        2.50951404735318, 1.906537159061861,
        0.660645961011323, 1.212694092092433,
        0.925977773302763, 2.202117459544022,
        3.03760581326602, 1.15006520918807,
        0.39713264790511, 1.705831940357857,
        -2.10208829625056, 1.393302611968724,
        -0.558122039397760, 1.396270117043631,
        -2.50843825010785, 1.041546243853163,
        1.48765804577592, 2.022313653726986,
        0.969609199990981, 1.007352232275058,
        0.669559370327710, 1.579408995720946,
        0.874228255544377, 1.588422086098844,
        2.73067611679128, 1.008348152094833,
        -0.699401809735434, 1.250674781081913,
        -0.991098778417733, 1.445549970137285,
        -1.55996981565297, 2.304779440608158,
        -1.57829391537956, 0.7908884089287527,
        1.72807751648543, 1.599992464194662,
        3.01849572523590, 1.395746337660687,
        1.51150317579739, 0.1497992075776804,
        0.696156001583892, 2.312219749060667,
        -0.359511316368613, 2.636007076166011,
        -2.63107804752543, 0.7036441016523486,
        1.20975378184911, 0.6029812949976984,
        -0.977897270183991, 1.092887965780893,
        -1.36668890640418, 1.0244049413842,
        -1.00488967808620, 2.391693903023232,
        0.166817632792611, 2.332841731740957,
        -2.81354441041362, 1.043579458252428,
        1.7618743158821, 1.344137405991954,
        -1.1147933270045, 0.4936163594738254,
        0.804265219654882, 2.89371928760358,
        0.600796724555290, 1.178122558311605,
        -0.638098042951589, 1.787701602377862,
        -0.296817145484799, 1.792403095078353,
        0.471487639635761, 2.587868025835749,
        -1.97186215117597, 0.7998516826365476,
        -1.03021025620951, 0.5562858337615064,
        0.244151554351010, 1.768914139877933,
        0.337091922257875, 1.058841467410951,
        -0.786989102732508, 0.3987760647220187,
        1.23842151136218, 1.664813768908043,
        0.586223044624445, 1.64439066831456,
        1.38679402085738, 2.049800396273533,
        -1.83697915431785, 1.073011806074895,
        -1.27616713663193, 1.519308619104818,
        -2.17646916602912, 2.332044715758263,
        2.12663273812966, 2.196228838633683,
        2.15548793170316, 2.086103849965649,
        -1.69567987345885, 1.822806080386666,
        -3.00553909307854, 1.830773253590179,
        0.507347786794901, 1.856505063249765,
        -0.573413686434932, 1.131822378642475,
        0.47436630362120, 1.576893926855356,
        -0.428172326200971, 1.365744995051359,
        0.190873644563496, 1.797096429855342,
        0.107825616547974, 1.673422766624918,
        0.539313361220449, 1.210899709175118,
        -1.74886636590015, 1.628736796074895,
        -0.29477951693458, 2.466959283436525,
        0.102271252820604, 1.119600404489199,
        -2.6977421313459, 2.854890806225086,
        1.06153824758624, 2.570889497856786,
        -0.612836849174168, 1.450536711589794,
        -0.226647828860762, 2.599059326006643,
        -1.71761587811820, 0.603476173230985,
        -1.22301297851596, 2.416810485767204,
        1.5952636473704, 1.990171851522988,
        -1.17963847533760, 2.821317701564491,
        2.13972892943341, 1.985894146033296,
        -0.379606963716069, 1.09229770027234,
        -1.83811324998346, 1.336227271005599,
        1.26457325630765, 1.968222486101966,
        -2.49148019585504, 2.161389355491135,
        0.00462014226887596, 0.914052252053263,
        1.23977889118805, 0.9802738728224328,
        2.36102070708720, 0.03434528398474648,
        2.05454408356943, 2.747000868656783,
        -0.415953775586584, 2.172383165744078,
        0.197413696842195, 1.172974071055941,
        -1.30422095359159, 1.297761553419845,
        2.43859608492171, 0.9519133902881616,
        -2.76337978998172, 2.388308244969448,
        1.73009521242668, 2.120450921608769,
        0.180319152891976, 1.540155331222948,
        0.113087189302085, 1.021422694399821,
        0.568876897923634, 1.611120472226325,
        1.64049004502465, 1.034372568962251,
        -0.163617536830489, 1.837878976989209,
        -2.23898386588482, 2.520581468262443,
        0.506306675296476, 0.7898338271515826,
        2.76449654356282, 3.035221086210812,
        -2.65875742338854, 0.9615690500676601,
        0.344537878275812, 1.413215526936229,
        -1.98617187559253, 1.228789099983053,
        2.07131817407723, 2.617162645720827,
        -0.304754137619106, 0.3711911266447426,
        2.79812347131793, 0.8096780588225297,
        1.8309067119730, 0.9105369045899523,
        1.86879861696764, 2.00905778098977,
        2.96103061763556, 2.900851203922974,
        -2.72060196633921, 1.862626420204245,
        1.79097823136774, 0.4424614948324612,
        -0.978737583855882, 1.655817960430775,
        -2.16583595976174, 1.839628720929731,
        2.05392566965921, 2.279344791628439,
        0.928818624583227, 1.88803028423671,
        -2.73692323403311, 1.115955006226895,
        -1.23754151507895, 1.883152114730086,
        0.477261841585428, 1.989372299274788,
        2.11392747673244, 1.398677498604901,
        -1.48561622215773, 0.265046704494559,
        1.26539040955448, 1.146797560490802,
        -3.00196629601800, 1.075227332194445,
        -2.28498298439498, 0.887545998797683,
        0.168613171756895, 0.7462587021411013,
        -2.29604160712122, 1.530010082907524,
        2.14722095593819, 1.246992619583747,
        -0.719733267687520, 1.012547662730678,
        0.171646169500648, 2.592751890963708,
        -0.405608039098154, 1.480650964943702,
        -2.66843824776933, 1.264938629630221,
        -3.10744639920438, 0.1896208832261336,
        1.64163058276847, 2.123687726141775,
        1.98076101307227, 1.375037393046818,
        0.355557738997779, 1.023908097010795,
        1.47653201053306, 0.7608521744174721,
        -1.69678926554086, 2.568071935325289,
        -2.00696026339521, 2.645692609191445,
        1.84642470780082, 2.317684711667531,
        -1.80968290915518, 2.076662440690515,
        -2.08847440463612, 2.713873520538047,
        1.21823225146051, 2.243532528006599,
        -1.16942840810266, 1.557430407876571,
        -2.40995803765543, 1.146241971328164,
        0.580595989006046, 1.078970765538256,
        1.79082948247205, 1.245216468945927,
        1.2099179352600, 2.640405634055688,
        -2.58698716045625, 0.6055056698690267,
        1.21429800624668, 1.861823270157667,
        1.93522639407662, 1.423840803740321,
        -2.10991287496879, 0.8828049064749828,
        -0.299245498185849, 2.275786407218568,
        0.508909782768370, 1.894525729313623,
        -1.9803038724707, 1.325230918104057,
        0.0431306134429814, 0.4924800655047868,
        -2.85998137647600, 0.5128351054587011,
        0.670347118251714, 0.6967506623406772,
        3.09166238516421, 0.9235328252538282,
        2.82466712422395, 2.844491712611793,
        1.9454529045281, 2.642665094761452,
        2.8550142873143, 1.138422361291819,
        -0.504547788107373, 1.483241114778781,
        -0.445469620411701, 2.110111996082822,
        -0.63507855955118, 1.652003455061435,
        -2.16619898538255, 1.552261203788471,
        -2.2230302489417, 0.6958200250655441,
        -3.02749401357537, 2.388464684452201,
        1.16532905764987, 1.37641105084041,
        -1.28300109447193, 2.094475878449122,
        0.493467237024871, 1.080439706921434,
        2.39685186366857, 2.808371373972196,
        1.21251766216816, 1.691618886202459,
        -0.286814030281009, 0.8503506854502949,
        -0.476243224503327, 0.9039445854878537,
        -0.336426397315878, 1.289689261953697,
        2.08106734993570, 2.072746407198741,
        -1.85537793471209, 2.861603854099282,
        -0.859978186050740, 1.72677520644242,
        1.90474509836846, 2.885488734319081,
        -1.98793772916480, 1.093630265706163,
        2.41135977994031, 1.757507110206441,
        -1.00733812334426, 1.680881440333903,
        -1.57258155284036, 1.878951802642142,
        -2.58391407343098, 2.225960402425566,
        -2.24052232215007, 1.403229193366663,
        -1.04396477790863, 2.762293508665135,
        2.74062677932864, 1.338511964824064,
        0.189303891449954, 1.901412282230208,
        2.36364933938579, 1.665315176741228,
        0.722274335631204, 1.417241089944569,
        -2.46858568228581, 1.024661789676432,
        -1.48466303466604, 0.5058376877235133,
        -0.0877281125738705, 0.6162070065927133,
        -1.06305795915897, 1.206953523170953,
        1.39359459428739, 2.151760167557939,
        1.57070030038253, 0.6440642202836866,
        2.12208710926071, 1.671090386994189,
        -1.90441583082419, 1.574766492003757,
        -2.59669616096775, 1.229206173230935,
        2.9279254958102, 2.458741377792596,
        0.477275611033352, 0.6252240758396905,
        -1.99858414873273, 1.572560108028989,
        2.49828427130242, 2.243042638093927,
        2.74571093616331, 0.7161696583830433,
        0.858690511650746, 1.378616786195519,
        2.95829927124074, 2.356916961945323,
        0.763037824877756, 0.7833808933175311,
        -0.187145468691988, 1.036037224204659,
        -0.614284563728729, 2.024414911833989,
        -3.02284948580676, 1.287966928062939,
        -2.73535430289388, 0.4837316396710281,
        0.531409499583902, 0.4956172184171003,
        0.615712161743201, 2.542754446069481,
        -2.29125716337041, 2.386995619517899,
        -0.511250386857059, 2.062158332632924,
        -0.20650717753888, 2.711508771260295,
        -1.96490468821746, 2.075871828783429,
        1.6993870082853, 1.696648589499836,
        -2.31233182808316, 1.429700574856501,
        -1.42519320224332, 1.283042473810403,
        2.24638805522930, 1.027414671332862,
        1.4963982276917, 1.420313659856353,
        2.49509492817858, 1.14284793831725,
        2.65460826512239, 1.58344917594967,
        2.07219056680893, 1.272370758312943,
        1.1368173885788, 1.215213230999238,
        -1.22414508254046, 2.647774461284615,
        2.85380352437167, 0.4480947621011556,
        0.809206007166290, 2.024442868862923,
        1.28904368742801, 1.770016839696763,
        -1.82581717574900, 0.8716295128771558,
        1.03267445990094, 1.534822052222679,
        1.46357188552422, 0.8840573672942074,
        -2.9230803654887, 1.10750815586473,
        -1.22504556976576, 0.5332570964425764,
        0.973748346139817, 0.5549051950734509,
        -2.9405469300747, 1.569674157923296,
        2.8387589139893, 2.692814565766685,
        1.52174177528689, 2.739474082052641,
        2.1743882048894, 2.387981083772137,
        -0.774020503559832, 0.8429488780634912,
        1.8159268666985, 1.814345727815557,
        3.1033079316801, 0.2644267283484225,
        3.05939690046501, 1.678928878568668,
        -0.761671392169817, 0.4344184666727701,
        2.37971470159071, 0.74485994390896,
        -0.144323531071777, 0.8098985967326491,
        -0.868925398816017, 1.383548741473376,
        -2.44541788275862, 1.860774730017932,
        0.983584519612128, 1.088013285988121,
        -1.62203588979885, 2.199176743327667,
        -1.00118146359575, 0.8494200865413639,
        -3.02361044762993, 1.326802065275886,
        -0.810136218542597, 0.9038853662764578,
        -3.03621602210768, 2.721436090616582,
        -0.896930073903194, 1.71577380343999,
        2.61856363438115, 1.21840209487872,
        1.2569456524839, 0.5750960389403875,
        -2.21795175385432, 2.143763726579501,
        2.19670435660031, 2.073061490883503,
        0.666969044328595, 2.488214049700793,
        2.45513449416508, 1.132018746887899,
        2.38855822093140, 2.977919112457452,
        2.56318068223216, 0.7742902277696978,
        -1.7527377260871, 1.855935483209084,
        -1.54568161560742, 1.348235885054679,
        -2.56949799636858, 1.326177019604793,
        2.46412045298762, 2.556857336273487,
        1.33363753116697, 1.874217943100563,
        1.87851857792146, 0.9150712507625905,
        -0.485697880464300, 1.418659897686856,
        -0.925566698239379, 1.741758425522751,
        -0.595952023213654, 1.525287878912009,
        -2.87836541071918, 0.736584885771753,
        -2.08729202816846, 1.047169574875447,
        -1.9038730467426, 1.096836629973843,
        -2.23339055387409, 1.850782452714258,
        -0.147112427252354, 2.082885963890676,
        1.65393949265001, 1.761844802625816,
        2.10085615984768, 1.998531792407968,
        0.359340122871980, 1.510519402967824,
        -1.49198340882403, 1.5464007653937,
        -0.781776581570577, 2.110593708628226,
        2.34733678549273, 1.430312842185055,
        -2.61022978082446, 1.597112472389655,
        -1.65507005088291, 2.302216073053168,
        2.7450570270859, 1.80249028198587,
        -2.30223492119986, 1.862860951867051,
        -1.53078067996894, 2.271536065906802,
        -1.41686736241227, 2.037508231893466,
        -2.96267426767247, 1.700292403630214,
        3.12553366356778, 2.118045818381503,
        3.10288256362410, 1.617210158072327,
        -1.75402844057354, 1.395197455161972,
        -1.41242994707890, 1.867599086653882,
        0.603324124980666, 1.794157206964,
        -0.860626487305061, 1.134837646281779,
        2.10647333976499, 2.715729207014071,
        -1.64471459479848, 0.9139139806980429,
        -1.56694841281478, 1.24945512774298,
        0.151510792785150, 2.396454572605156,
        -2.53379404316006, 0.565172174732031,
        -1.28405596496998, 1.824927675476292,
        2.31381285217345, 0.5458724490446016,
        -0.132426343246411, 1.33013038177762,
        0.070421705261828, 0.8596677210079309,
        -2.51174548400253, 1.69658044091776,
        -3.06732361321414, 0.9276487238438532,
        -0.133892014332050, 2.689850154955178,
        -2.91997545057812, 1.537518003190873,
        3.02510614509262, 1.846361932105899,
        0.246685433548746, 0.4476556764196509,
        1.32222122710504, 2.862528490408002,
        -2.95136591313532, 2.430915064138535,
        1.20189916655177, 1.724704541100636,
        -3.08580865192249, 1.655819818762341,
        1.66244098471885, 1.067798262826844,
        1.81235658907926, 2.389396029600213,
        -1.65839659052294, 1.957466645224707,
        -0.737042241824454, 1.658477093402501,
        -1.34912156364103, 0.6506450439062985,
        -1.76534657406005, 0.244149913752986,
        1.7995105612482, 1.177409801111065,
        -1.09163340872353, 1.094785108420426,
        1.81565702843041, 1.453477630798563,
        -0.125509080515883, 1.783363749670132,
        2.87811700140622, 2.481278697167981,
        1.15864496390736, 1.502867545975639,
        -1.37111793946222, 0.4220749668721617,
        0.264055345076318, 1.736501627703396,
        -2.25188694571304, 2.318497072244985,
        -0.31437595812403, 1.057571675304948,
        2.18099850274000, 2.147502550346134,
        2.25280488236537, 1.38887418839752,
        2.82700809712019, 2.540075159592237,
        2.9750688737799, 1.266291706992856,
        -1.13816856918642, 2.85843100596252,
        3.10188950770710, 2.152467522130816,
        -2.27104236200297, 1.837874494474115,
        1.53361022005621, 2.084948473453833,
        -1.72637001063171, 0.9261540526289551,
        0.789042617842959, 3.008250801003382,
        -0.626379008044336, 1.688716053241808,
        1.37632100450403, 1.478471657066344,
        1.85021937831825, 0.9456542178756003,
        0.997779212700703, 2.59139767948805,
        -2.69949563061406, 1.095984845395211,
        2.40138802652982, 0.9724341657567127,
        1.69663635148234, 0.5323950245988882,
        0.85184282921809, 2.660657672071975,
        1.53079003118200, 2.021871646211109,
        -1.395978680902, 1.669130772244755,
        1.53121415384344, 0.3385755303455996,
        1.92942441442762, 1.02198975808423,
        2.54589137147256, 1.901172195142594,
        -0.678092046453935, 1.108868212545485,
        -0.884626677306336, 1.616682637169197,
        -0.321959639770221, 0.2216584395317667,
        -2.43851240125402, 1.085369346395655,
        -2.63088266994511, 1.209202764293758,
        1.78585720024541, 2.017050882254619,
        1.20579867850913, 0.7033154210633655,
        1.27875597824967, 2.038861681487853,
        -2.50523718455742, 2.390314320134014,
        2.68888772926993, 2.688863033961709,
        -2.63666255756957, 0.3248023544208795,
        1.00750128111313, 0.5888320247895676,
        -1.35111594470939, 2.066788591629005,
        -2.40695265982831, 1.859135339585185,
        2.98624293801086, 1.843352065581408,
        -2.15747805668022, 0.8916405513641024,
        -0.876401998132241, 1.65329574465575,
        -0.38652564598841, 1.690088952807275,
        -2.3309636833319, 2.779886099372773,
        1.32663987997570, 2.592380272018941,
        -0.370141092343862, 0.8056088106515154,
        -1.32328395130395, 0.3117791505106399,
        1.57548658839774, 2.153982720031556,
        0.358215141523384, 1.248433522127509,
        0.605824220050790, 2.23768503222734,
        1.40662573233186, 2.113950871858691,
        -1.59601134944370, 1.849996113643801,
        0.00366007674143439, 1.97733303804285,
        0.786292897677736, 1.152664050416894,
        -3.12889586282669, 1.426420165680395,
        1.60436847727012, 1.659654343978327,
        0.195356757476840, 1.337654039727077,
        -2.66937159232662, 1.302122524125118,
        0.754398997136883, 2.14874133479418,
        -1.26676730626032, 2.059070621241947,
        1.26240912336223, 2.176402252600553,
        2.84869933340839, 0.5985528340014503,
        0.169782170299547, 2.755710074808143,
        2.10144956395025, 1.05567717752441,
        2.63116773192738, 2.299270940218976,
        -2.61705594401470, 0.8248036245696371,
        -0.357883764578803, 1.530891234684195,
        1.00366110645911, 2.18561135245782,
        -1.15267622399192, 2.279183413588023,
        -0.99607699715935, 2.495330288798645,
        2.60834741230459, 1.357682301047398,
        -0.632223398180582, 1.514853699879944,
        -2.32089495906075, 2.087042590844906,
        1.41639619513905, 1.64851895549654,
        0.809494281942802, 0.3990501668915239,
        1.09664325621754, 1.966731897064101,
        1.81029249280658, 0.8756542199296047,
        1.40959321663792, 1.714806624305862,
        0.728608926537744, 1.115630266684681,
        -1.61824686567115, 1.419081103238088,
        -1.71402241823409, 1.923019009162928,
        -2.54150589590167, 0.9819013543910524,
        -0.397904747558762, 1.764948781617536,
        -0.438408992614975, 0.9282409791230215,
        1.98494869514175, 1.684254964034625,
        2.49530531214497, 1.39025384232596,
        -0.912776526457156, 2.405941501669297,
        -0.766141265055622, 1.27498337354518,
        -0.169477976548885, 1.167884697353451,
        2.8214873259476, 1.989727312789511,
        1.52691723428624, 1.256467056142178,
        -1.63969405881540, 1.786920375705537,
        -2.27519811464626, 1.627515499357706,
        -0.603515376129100, 2.268941583929748,
        1.87681489224467, 0.4304971403981573,
        -3.13273119871249, 2.084410143747068,
        -3.13549661347972, 0.5987142677852419,
        0.3005414140035, 1.128832526554082,
        0.851393897870845, 2.394607333379362,
        3.13973504198081, 1.087323540716994,
        -2.19737981255717, 1.35339509123408,
        1.51343717805034, 1.92220616664692,
        -0.84250682858686, 2.760388532596425,
        3.00568324735653, 1.208562227514895,
        2.65281124873362, 1.447750111243096,
        2.78409114130127, 1.142402902025236,
        2.24499022162336, 2.233381375484154,
        -2.60899023478729, 2.257653812100051,
        0.404691445229862, 2.101440978991803,
        -0.0745180928044862, 0.8922141458066186,
        1.95666712563790, 1.659735852056124,
        1.48670770920120, 1.074866900793293,
        -1.12261877573394, 0.8892672098786255,
        2.89465017466395, 0.7321260743498073,
        -1.48724676701596, 1.313547305283324,
        2.73719589162060, 2.787304672761376,
        -0.753999528472897, 1.309721954287111,
        -0.691714492719009, 1.705183691802425,
        1.5090661228653, 0.8766217924300926,
        0.358317240681130, 0.5477733210465723,
        -0.927228739615958, 2.088552087929583,
        -3.07119311464898, 1.083429312281912,
        1.55387262507030, 2.123505626825324,
        0.915981841911331, 0.3069039813236284,
        -0.5681739670942, 1.974484359185013,
        -2.6463855727058, 1.400052367575948,
        2.57232532792151, 1.927172783093532,
        -2.81812564971566, 1.695412773793773,
        0.0694352841871479, 2.749518857840226,
        1.80577798851450, 0.4052365729829681,
        -1.49875385250390, 1.646108931812314,
        -2.96459081978636, 2.560843110835938,
        2.98667032775392, 2.176485277478406,
        1.82422355521869, 2.427014709461186,
        0.272261043750211, 2.758199823410643,
        -1.62644559524981, 0.7743619714147179,
        -0.367343938070754, 2.710713760917868,
        -0.740130995644081, 2.75514081378033,
        -1.02850622109172, 2.048189240952128,
        2.66055527523523, 2.198589443164081,
        0.64844392402328, 0.6199425630085589,
        0.439423053942588, 0.9523120751984553,
        -2.56005065064819, 2.193835404218252,
        -1.40251125202643, 2.369823510698699,
        -1.32417527956129, 0.3492180511776038,
        1.13297253703402, 1.842651392890952,
        -1.07423066181295, 0.8986049580722149,
        -2.22729210381513, 1.888440633632256,
        2.43675100996641, 1.646534933532329,
        -1.05017395771370, 1.105647870844147,
        1.63922203593893, 1.167471171710868,
        1.53578331737231, 2.893843066619195,
        0.584311012558450, 2.984416189530978,
        2.45649264286475, 1.711044694762099,
        1.95015745161597, 1.998953549666455,
        -0.702568439018804, 1.805367851828718,
        -0.551591500877582, 1.71066982871779,
        1.32671752057534, 1.935926918193036,
        0.0401753312534120, 2.713552805892878,
        -1.51558657837710, 1.514342689573604,
        -0.86978300328764, 2.428496111901086,
        -2.68707771588567, 2.45236607453605,
        -1.7256083882895, 2.818515658856758,
        -0.830036729090656, 1.074543115154792,
        0.90258137103916, 0.557632363680025,
        -2.14095944415928, 2.486517836212098,
        2.9273959560570, 0.467539414626333,
        -2.09050077004330, 1.865128792700629,
        -0.363181719050202, 2.673376244535931,
        0.190544788736963, 1.865816681686503,
        2.64716567785007, 1.760476447016556,
        1.23630796278894, 0.5387440604208813,
        -2.98295934042689, 2.691313609454243,
        2.18318790033746, 1.547726754828197,
        3.07389645159062, 0.475250182810842,
        -1.95499199409839, 1.520179612096861,
        2.95044926341373, 1.399603063577859,
        1.8251535861748, 0.5413977108030127,
        -0.0992965470443010, 0.1264932967432895,
        -1.5653860680148, 1.942726351560996,
        -0.726062305032062, 0.896864065714072,
        0.256465122569689, 0.9661169996688971,
        1.48985379552834, 0.4755251515765022,
        0.714882297337170, 1.315150799927029,
        1.0343109015302, 2.852629513934159,
        1.68816361817667, 1.597632340569113,
        -0.46672128340058, 0.7817364475939959,
        -0.758508322088962, 2.853560962700647,
        -0.441311069346230, 1.468572665466937,
        -1.76932648287404, 2.408756680732581,
        2.14253398343125, 1.423586313808549,
        2.68579168981719, 2.896261841220284,
        -0.967198444360921, 2.527252612219355,
        2.36142468722058, 1.21163779799917,
        -2.63566672858538, 1.323542050997548,
        -2.40545383205743, 2.683843668215514,
        -2.75248533478137, 0.7759564430827297,
        -2.41314590129401, 2.259939016433685,
        -2.54217320167776, 1.897097352753102,
        2.9928897306211, 0.7364495124636372,
        -2.2944184232039, 0.9258699346855259,
        0.631320142070672, 2.946718421952385,
        -0.197774252099833, 2.749051962684763,
        1.01726451922356, 2.222344950652321,
        -1.8299181537891, 1.567694091418017,
        2.53730176875157, 1.944267341581719,
        0.063766262987213, 2.317157646553737,
        0.582574568008629, 0.7446756969061454,
        -2.16053069464538, 1.34156462143515,
        -0.625033465985255, 1.888298164502073,
        0.520308703723106, 2.122583607087182,
        -1.83916246075631, 2.105262026509248,
        -2.70648120074049, 2.487613428648347,
        3.04538150624343, 1.263092274313499,
        2.14281745642039, 0.9266628017396671,
        2.34035819025696, 0.8426291371255695,
        -0.20078801186135, 1.403069281619233,
        -0.550835724407990, 0.4002274639168746,
        2.24070715572088, 1.16925746420804,
        -2.66104577955679, 0.8067413360552464,
        -0.0608967902815056, 1.494117009303585,
        -0.746321699803121, 2.134628260865274,
        2.43826838188980, 1.785816709294157,
        -3.13105534119041, 1.490611581751891,
        -1.61878840126180, 2.840340878231558,
        -1.67499885519532, 2.455769842032834,
        -2.36708547507871, 1.344018841998631,
        -0.857311563269907, 0.5960215696761662,
        3.09770929226954, 1.982876823080559,
        1.97020385511952, 2.263419662729303,
        -1.82284955253509, 2.040270759140314,
        -2.10898583734199, 1.430428679468889,
        -2.44069349870063, 2.545351208463052,
        -1.76087737850952, 1.729246687338759,
        -0.258969270464233, 0.622198315888161,
        2.09955735092626, 1.785162226228059,
        -1.12301006062004, 1.779266350662113,
        -1.72542767290335, 1.988570443448823,
        -1.23550382096775, 0.9352248900816713,
        2.42991725549694, 1.373180162727306,
        -0.916612193964022, 0.525726187171655,
        2.04880271688388, 0.2456843996667374,
        -0.282055201881293, 1.96482389921942,
        0.969220379976881, 0.1937706222156352,
        0.589204735713611, 2.610268485898602,
        -0.605826888954859, 1.071506807677408,
        -0.432175789224887, 0.8911248048430723,
        2.35518794368920, 1.25280876194713,
        -0.882429398321281, 1.235223586612036,
        1.21546269114501, 0.8426080688987397,
        1.84137885898589, 1.011791089874809,
        -1.95540781156584, 1.835334447763865,
        0.640866366255325, 2.17742986080337,
        2.41505622976175, 1.120216245910447,
        -2.26688627360844, 2.048982299316221,
        -1.37067047488382, 1.69814191312908,
        0.715249594023882, 1.014740484357075,
        -3.08952374201389, 1.432687570758129,
        -3.02114955464545, 2.055738945033093,
        -1.43053422425547, 1.412428699715669,
        -0.934602895341796, 2.48944927506686,
        2.66193212286815, 1.410977679162198,
        -0.622613911460556, 1.271377872560402,
        -0.409512058747392, 1.029606748390963,
        -2.37875858268402, 2.529001072463072,
        -2.37804113699089, 1.419885307175062,
        1.37482314068350, 1.158534489408768,
        0.54253528733530, 1.874209549662361,
        0.379929585993205, 1.478411408281918,
        0.982770089591949, 1.438982328975998,
        2.50115045142640, 1.804714321866055,
        -2.35369117241299, 1.482001781886764,
        2.75318659517652, 0.3181209850089233,
        1.47080988970857, 0.946205956407976,
        2.67393874446921, 1.9906454030994,
        1.01083923497156, 0.5212408905601311,
        1.47637270026098, 1.61890702408769,
        -2.66816096191655, 2.027891399840441,
        0.701078395252369, 0.9142666963374037,
        -2.50588990561973, 1.36685126416809,
        -1.56153098683919, 1.781455088518419,
        2.56973690452701, 1.372139356485119,
        1.10495188936820, 0.219313703073151,
        -2.60168120773217, 2.507688773937982,
        0.950059625212201, 2.277259708027001,
        -0.5651251483105, 1.804177253533434,
        -2.61735235770834, 0.8638521214457371,
        1.6124334844857, 2.810391991643602,
        -0.241528033571241, 1.514631309354316,
        0.76075513280905, 2.187467618434628,
        -0.685288072339036, 1.87662641623369,
        2.31185579784296, 0.9409151407834809,
        2.53471404358132, 1.516054678058556,
        -1.82353591237929, 1.301411092743609,
        -2.20207323342071, 2.620615828934056,
        0.0823889900298425, 1.872817136198519,
        2.32655062105874, 1.055450015439062,
        -2.80964058451391, 1.194543716815654,
        1.18864017615213, 2.770824681369033,
        2.19540236405286, 1.336464806841329,
        -2.10622373811724, 2.290642850766033,
        2.05086567856736, 2.903498240750988,
        -1.97008075156062, 1.459496019584832,
        -2.66317761951580, 2.319952209382931,
        0.924900935375396, 1.38965344697872,
        1.51316667603341, 0.6265149816293596,
        0.365821068755066, 2.118840281445413,
        -2.43634646829437, 0.3095021320245631,
        2.33904436870892, 1.46690817348044,
        -0.906675607752815, 2.531550997278337,
        -0.609311569186187, 2.577848528083578,
        1.82536602419873, 2.28289233905413,
        -2.34590848395338, 2.223645873251822,
        -2.38133977243196, 1.891028146262221,
        -1.44885042582050, 0.6031204811261035,
        -2.6097811040455, 2.322382570396616,
        -1.26776577716850, 2.84708396272815,
        -2.57584690773086, 0.8834595386272892,
        -2.37089282735840, 2.023706110946972,
        -0.158129096317664, 2.901481080867908,
        -3.04902005823108, 1.023322402398553,
        0.889424113759320, 1.193717900882058,
        -2.07380912082229, 2.32019793414754,
        -0.299656450142111, 2.198881227811799,
        2.26928069380439, 1.315410644141105,
        0.136671147914902, 0.5505125806579481,
        -1.93509950676748, 3.05807450725935,
        -1.22439657906951, 0.7309815902953013,
        -1.36604909267724, 1.931858105513887,
        2.59246156348239, 1.848479826880484,
        -0.182333496693136, 1.628490099275593,
        0.921150297537351, 2.681528201991846,
        1.83055072668026, 1.776854850226772,
        -3.10033964167540, 1.181050615779695,
        -2.51555232963219, 2.128421012355187,
        -2.96174542629766, 1.935518590893183,
        2.19968424596851, 1.47406097433161,
        0.605836864600169, 1.676542299186568,
        0.911197411014280, 0.3442578488975415,
        -1.1433659703643, 1.942615844053776,
        0.205534263664037, 0.4813557840353909,
        -2.14845022113335, 0.5145797125053224,
        1.11979997007467, 2.828841678969372,
        -1.63960664723678, 1.386737833256227,
        1.04746665841034, 2.295034044092892,
        2.93465362085432, 2.497109236154771,
        1.32053959582217, 1.20236691800747,
        -0.473862416353338, 2.554239658931158,
        2.6640305779295, 1.54631762022778,
        -1.66088411860478, 1.354595839709267,
        1.57546297782510, 2.089490451812077,
        1.73176491180147, 0.667831749114982,
        1.80452594153366, 2.350645658103845,
        -1.97331917967609, 2.763348242615127,
        -2.49696229732877, 1.533323138070087,
        0.734077766093264, 1.048901640815595,
        -0.990831782411926, 1.755455474798264,
        -0.24837800043104, 0.8744627307212828,
        2.84748540972905, 1.060419583181488,
        -2.84779742098913, 2.078037566283446,
        -0.93227268157862, 0.6569164763632512,
        1.95445670751373, 2.300309228188809,
        2.25273338473981, 2.195400096789902,
        -2.72813494940429, 2.523738070371699,
        2.45362557627350, 1.852673567532487,
        -2.77948244848638, 1.695570543662073,
        0.167079763859544, 1.703492941239023,
        -2.25137040050527, 2.213455664549894,
        3.00236453829471, 1.572420127137064,
        0.501247202414079, 2.919405904612891,
        2.70803847151122, 1.109524339592134,
        -1.643623188002, 1.319818283769638,
        -0.758688617983053, 1.997472307008094,
        1.90391306180868, 0.2570914095153829,
        2.26465361864690, 0.640046820115167,
        -1.66931129909099, 2.41833613222386,
        1.92186110899514, 2.270502417226398,
        -0.148396958679469, 0.6297167813817938,
        -0.681774711745658, 0.9927801302162786,
        0.65148743669928, 2.295273553947095,
        0.799262026266788, 1.735912859398814,
        2.89588342307996, 2.063346786149418,
        0.411920302562128, 0.9207850878667143,
        2.27115271740181, 1.141718519575272,
        0.724512475542746, 2.504752780258563,
        -2.12280390129618, 2.226253509726046,
        -0.760047573610923, 0.994644551058008,
        -2.54016867916801, 2.497129517622534,
        0.135473142359520, 0.8169088894431997,
        1.10457730722813, 1.732694852983797,
        -1.30494130630930, 1.062532298060249,
        -2.66423214831437, 1.696830730063991,
        0.416399119055418, 1.608287314184027,
        -2.69996787096921, 1.829829409056834,
        2.88795409726722, 2.557553836912231,
        -0.56428774113126, 2.292481012326393,
        -2.89305338594032, 2.434363947353274,
        2.1996774434643, 2.246246696627664,
        2.75170655425030, 0.7928701006409963,
        -1.79345402707855, 2.310701139405108,
        -0.474333176083200, 1.832530398848369,
        -2.8555762538633, 0.5777239691920486,
        1.27370229454522, 1.734125374937366,
        -0.395175068799998, 1.51866463316233,
        -1.78382827352270, 1.297943320702002,
        0.679331497248591, 1.246652559244,
        -1.11497113062259, 2.411386234260979,
        -0.980705989128615, 0.33045590974878,
        0.644629351403121, 2.216467896628258,
        -0.121380466390431, 1.708625262422479,
        -3.10279062062578, 1.398135535592026,
        0.078768208933643, 1.94547361296324,
        -2.69882984229459, 1.058014940458748,
        -1.2466922001264, 1.101752464750284,
        0.559604914430245, 1.177824301413604,
        -3.06590467016247, 0.6883330894479013,
        0.227673510942861, 2.277112924389027,
        2.46719855369033, 2.419727299439232,
        -1.64938406431172, 0.5978457880743183,
        -0.103268990585451, 1.430122088215409,
        -2.60000983080933, 0.5646326212301058,
        -2.37733138259775, 1.790315807134502,
        2.72786849010029, 2.075514810526631,
        -0.279503338698640, 1.455671670565109,
        2.56060835097754, 1.30489062090359,
        -1.06933574138566, 2.299668021951087,
        -0.183208818162611, 2.063653719458189,
        0.00299718391388727, 0.3268551890215478,
        1.5843029123019, 2.706341007472174,
        1.29058376890311, 2.652874760541009,
        -2.87822014803897, 1.342354448330414,
        -1.04968177349933, 0.9706114241311988,
        -2.98924997390378, 1.866631467394314,
        2.29389540845966, 1.513982818695998,
        1.29395183577880, 1.703656789951139,
        -1.89927271812345, 2.700614302162405,
        -1.86944437243767, 2.134077974904246,
        -0.529847082910987, 1.960893068772975,
        -1.55529149319783, 1.845497077931342,
        2.81951940210962, 1.737879880063986,
        1.28457907782406, 0.2148940313980368,
        -0.144435628155124, 1.031987765555575,
        -2.51967198495782, 2.597675081298258,
        -2.43655663794430, 1.993698013363064,
        2.58266932546447, 2.568886882148302,
        -0.186389220424957, 1.202239869704089,
        -0.678038111132727, 1.186037379785266,
        -0.374573286406133, 0.5448512210854297,
        0.763833613238909, 0.6479997097989052,
        2.74175796826170, 0.6778778403814775,
        -2.04891713906346, 1.737950543705392,
        0.774527561038678, 2.265161339087348,
        -1.85249035732359, 1.037392939588138,
        -1.58784034275373, 2.72609204352645,
        -1.91641336750558, 0.8640042975194852,
        1.87926505308904, 1.545455623462231,
        2.90277233035330, 2.304499581737913,
        1.80084719501242, 1.915673543626856,
        -0.147157551082990, 2.939671881634354,
        2.82887448329777, 1.560110565868111,
        1.35973635619677, 0.9923931915287849,
        -1.09697570311450, 0.8233828808693776,
        1.27114638582693, 2.241223990088756,
        -0.16274398341894, 1.399894044100743,
        -2.44601162269158, 2.160795042500114,
        1.07987078052985, 0.1198509866745031,
        2.25318277479725, 0.8505190569272469,
        0.378195729797925, 1.542827035901722,
        -2.25995372501561, 1.91240453544707,
        1.01517503858981, 1.113947521502508,
        2.88291564347350, 1.039667847508942,
        0.646873462546780, 1.046411194049704,
        0.580344967777544, 1.144870935065051,
        1.65950291898484, 2.023053737553814,
        -2.1444442907262, 1.267382604998986,
        1.25420319275488, 2.007702761414827,
        2.09747075509396, 0.9161245488987821,
        2.56641097369545, 1.129521634631295,
        -0.337722951005892, 1.846364096057347,
        2.81343092700421, 1.370340247132685,
        -2.91680280659522, 1.220378501600832,
        0.244119448141481, 2.167967340068145,
        -1.71680048223897, 2.188599937551771,
        -1.33782066519812, 1.159490143259674,
        1.6523789804689, 2.313806977534739,
        -0.223107260210911, 1.370977866747516,
        0.0416267231726919, 2.380598102353668,
        2.98048724006815, 2.07416903471315,
        2.6281870952057, 2.378481450809719,
        -2.82286951522953, 1.568315643290119,
        2.33081392791649, 1.503417141204386,
        2.71582170691126, 2.2864402080667,
        -0.617464454607443, 1.72544059358212,
        -1.52068845699006, 1.447869579684755,
        1.61966220261667, 1.363507404419623,
        -1.65129277416857, 1.655584821541839,
        -0.34667100158380, 2.44684576361885,
        0.0188497811913999, 0.6312704612815642,
        2.6801970783543, 2.026826609305785,
        1.0644275117151, 2.230601839632837,
        -2.23697345449614, 1.574931825543289,
        0.087031194253191, 1.642650121084234,
        0.802177131256133, 1.256714423006209,
        1.76650420164009, 1.618515518663709,
        -0.925753890313175, 1.182585127823731,
        0.917687438182066, 1.639387894508941,
        0.0922726264445555, 0.5210426692206922,
        -0.728917687659607, 0.7126606831683038,
        -2.81709837964849, 0.3507769501849511,
        0.368075870287657, 1.85361207547019,
        1.0267036236042, 1.848471580853965,
        1.40421487128056, 2.013147794606453,
        2.12217587079370, 1.361127704344643,
        0.513723409887685, 0.6987787616600553,
        0.579862924973643, 1.21102796609362,
        0.708153544689732, 2.094618531578534,
        -2.66634239129431, 1.433261529132229,
        0.626120639470213, 1.511600844402695,
        -2.58465838862357, 0.6466346939586309,
        -2.01936533823640, 1.334717361599943,
        -2.48787199995861, 1.464699635672165,
        2.04824017614951, 2.519157008870428,
        2.29457045921234, 1.080024815183519,
        0.256817018874694, 2.017889074964969,
        -0.248308013830780, 1.341392862444612,
        -0.462049416990289, 0.4148802641707196,
        2.27371771342825, 0.9640898270400408,
        3.11996292661788, 1.334916422992876,
        -0.277565794225343, 1.926753604052197,
        1.34849754033822, 0.486396477410609,
        1.52921783460099, 1.655647707883515,
        1.90962193458893, 2.004228810272488,
        -0.260187074747185, 0.9110453583622126,
        0.946722128436669, 1.613374316646919,
        -1.19237762589428, 2.584203145601953,
        -2.19098380337034, 2.074626726826201,
        -0.929818017046147, 1.56875398498155,
        2.28996662242529, 1.37797636325766,
        2.0413552663956, 1.210512869314875,
        0.426797470950646, 0.8211383397024615,
        2.90781815805417, 1.83531722944935,
        2.1842708114251, 2.584369394962893,
        -2.32120232651039, 0.683711011057182,
        1.42880698806888, 1.28536056133856,
        -0.054524855514728, 0.5401361273223407,
        -0.917898197519806, 1.470277684067653,
        -3.0526670608598, 2.152588666123401,
        2.77923201594816, 1.10342309702193,
        -2.17192274946726, 2.23447713118468,
        -2.68599480846328, 0.4540802849640543,
        -0.841947978028568, 0.5306243939267958,
        -0.842519213598460, 0.2636247498507549,
        2.63942245045317, 2.591710168747743,
        0.808641049262631, 1.186952700798743,
        -2.079140730124, 1.626532022033927,
        -2.93562760641820, 0.9943090397856194,
        0.906845000121018, 0.6875750474908263,
        1.69431442206809, 1.827842618967595,
        1.12230590017831, 1.430244368169784,
        0.966406593034289, 0.6876044074667464,
        1.59836041134354, 1.099907738580124,
        2.61687320329860, 1.456944461349132,
        -0.0573377716661254, 0.6803248367455217,
        -0.984202298081788, 0.2655480734124551,
        2.92552396089252, 0.9043678215076718,
        -2.94393272007682, 0.6755403922690933,
        -1.29259293994204, 2.027622237955926,
        1.78295029543466, 0.9068952848536642,
        -2.59127742217575, 1.430334471106412,
        -0.298709452660751, 2.159893229554792,
        -1.03601004746968, 1.705760878519439,
        2.37768245871455, 0.7854594329875166,
        1.84556056080990, 0.3312244778845625,
        2.14756777853905, 0.787527499249403,
        2.55517623715138, 1.860222664577637,
        0.798621752732855, 0.1346534093482137,
        -0.833917176981335, 1.837241531777041,
        -1.24927460864908, 1.000838197408275,
        0.0739500697103554, 2.551969729156154,
        -0.21859283806576, 1.271322608282953,
        2.93103469475247, 1.569325545343279,
        -2.31900383955730, 1.254594238572094,
        -1.83117188435532, 2.281122672639256,
        -1.32168793680032, 1.028176196949916,
        0.203968109257392, 0.1177692757915823,
        2.17588470172405, 2.45300636452423,
        0.300414276827825, 0.3488762105213255,
        2.70883781621106, 0.490112808093278,
        -1.25661704765263, 1.633363263611649,
        2.53711705113929, 3.00877702342663,
        -1.18994496949661, 2.960222417937843,
        2.3120235323946, 0.3157956293331163,
        1.90403829507298, 2.371522945534204,
        2.44223674167917, 2.349535069053009,
        -1.00466609774201, 0.9818143895039411,
        -2.18299602465276, 2.386358358051889,
        -1.0780157050810, 0.7559115283251254,
        1.38912845195722, 1.021736160179243,
        -0.925123074751416, 0.9698824436101312,
        0.713406641381286, 2.133187497503528,
        -2.16920221436836, 0.1931449428697182,
        3.05579366115400, 1.521282426279009,
        -2.83973424712756, 1.405657992911528,
        -2.17377612158501, 1.975635604055079,
        1.51027848549292, 1.989227676979991,
        0.244456797750785, 1.701902795350639,
        0.787916287462761, 2.639854644872426,
        1.81650955449167, 1.534424330094556,
        -2.58212941111283, 1.897507627827124,
        -2.75140240233653, 2.890122606596817,
        -2.97934497101896, 0.9778396637857404,
        -1.50551463009998, 1.216164786580414,
        0.449307899234615, 0.3870675111822212,
        0.127789054428109, 1.149109778339315,
        1.347591178323, 1.96765714104642,
        1.04532121561199, 1.921391483426679,
        -1.66504639514050, 1.287818529195639,
        0.260193569059832, 1.477663626749056,
        2.52790418023370, 1.286993666808957,
        -1.80279327172839, 2.519547221320771,
        -0.108482512138055, 0.3383054796854934,
        -2.07849683237251, 2.885194006379387,
        -2.73015806820021, 2.789810782644466,
        -3.07566809913036, 1.955500848427949,
        0.910945840818673, 2.796403550256088,
        -0.372944298775469, 0.6202976397556288,
        1.67702960721414, 0.6845929179441609,
        -1.89016231818717, 0.1462859862475775,
        2.73573982744719, 1.047494757971152,
        -2.3990723871817, 1.06985430285422,
        -3.04442726484054, 2.45380672430822,
        0.559173093609085, 1.111925711022702,
        2.03285614309676, 0.9716890408357971,
        -1.61079823305797, 2.07106011306157,
        -1.63291373301993, 0.6636631062819046,
        -0.319438900344438, 0.7146945256579764,
        -0.80342189218273, 1.366799337279081,
        1.19881542373619, 1.657235836475544,
        0.304292614284893, 2.29728355877773,
        0.130763573863854, 2.140954782963877,
        1.01011118392375, 2.813851744502104,
        1.12506607114644, 2.173453133648688,
        -2.97718547858857, 2.060389214462785,
        3.10713454613107, 1.550456729228184,
        -1.2991898453492, 1.403001313498736,
        0.802883093068512, 1.986488431951789,
        1.36974613340901, 2.364890011024912,
        2.3643458503713, 1.803903197082338,
        1.40858680004604, 1.547403667228785,
        2.63869495966692, 0.6858308024782157,
        -0.391215686399689, 1.653260747363164,
        1.4298594875308, 1.11792703354786,
        2.57104200910671, 2.049657689198332,
        -1.73931900389968, 1.954041915458924,
        -2.02040623971643, 1.644506546239349,
        0.0934098692100247, 2.988587933029776,
        0.288488909206664, 2.114628429030637,
        -1.1268939319843, 2.004050815097236,
        -0.962301383315260, 1.730014943539694,
        -3.10289298447349, 2.851203309381848,
        0.460227164507062, 0.9187848609594405,
        -1.32094827939222, 1.82559885120036,
        2.78538248444728, 0.5430526252833091,
        -0.661663834553225, 0.3026962321789975,
        -2.85373924060678, 1.913469429623465,
        0.340666557325422, 1.478501938568543,
        -0.417151322067400, 2.577058908096306,
        -1.62998749965213, 2.037042341071527,
        -0.933193876643734, 0.9326259217844353,
        -1.38895450167695, 2.136528473837379,
        -1.28167516204850, 0.9300084240909072,
        -2.29755883001850, 1.685573392009969,
        2.60952543848017, 1.632014468406934,
        -1.64279730396500, 1.55491042079527,
        2.65461574822035, 2.516429870683868,
        -0.856528562218265, 0.8899504773314263,
        0.366799858033874, 2.080911700229913,
        1.46996718187048, 1.984649539550262,
        -0.355581034283309, 1.710862542953806,
        2.2487086887277, 1.561465332991236,
        0.198967916654349, 0.4157172069697703,
        -2.59412043720226, 2.746616962742036,
        -2.02754194798945, 2.126543366637411,
        -0.96167947308544, 0.6228374178153138,
        -2.67192653774669, 2.092735906823464,
        0.573689397880278, 1.411154155644287,
        0.582167712614317, 0.8820231611171111,
        -1.82168959616400, 1.109109621627622,
        0.0465891365626254, 1.218070065357254,
        0.188231658005648, 2.691117172634285,
        -0.318221012345707, 0.6771130285283493,
        -1.94370918524002, 0.831919186543926,
        0.728539860607244, 1.349796244970118,
        0.872694737445437, 0.8924522697738093,
        2.27746727425960, 0.202078158450677,
        0.130314526271845, 2.262817297255432,
        -0.901526340511905, 2.597319328024394,
        -2.86344539403805, 0.8049918282745103,
        -2.98926160785148, 1.22700760920455,
        2.14639462939421, 1.559580024882638,
        2.00646858682740, 1.746582924284728,
        -2.87718383020282, 1.943448155479147,
        -2.57736826378327, 0.9226551783025246,
        -3.09725868423520, 2.750379602016883,
        -0.822290599304049, 0.7317351270978407,
        1.8766905966052, 0.7035927270408444,
        -1.43861062012026, 2.647002841494959,
        -0.0442993684813476, 1.459746476154988,
        2.84749317220079, 1.959546447838506,
        -1.46824787951806, 1.346140086138175,
        -2.23100986897319, 1.678209463624688,
        -2.77381558159833, 1.136368296744392,
        2.55456950800766, 0.9125690900587174,
        1.87493744892024, 1.835734737016082,
        0.467386531915368, 2.415867278824942,
        0.830442480634069, 2.138999770307588,
        1.32458900718865, 0.5853021251756176,
        -2.64788033243248, 2.919725383228491,
        -2.41731152391686, 1.471747604360976,
        -2.57450988461260, 1.40025959042573,
        1.32830035366558, 0.9632918361883781,
        1.65629601967396, 2.270895494481112,
        -0.185353675201079, 1.368050995277488,
        0.0948073620681832, 0.9219353152197384,
        -1.74003377856225, 0.5401045593090599,
        1.60915588661322, 2.332873907845099,
        -2.09497026340672, 2.002837976163288,
        0.154197858811867, 2.656781857653542,
        2.67793463058513, 1.380962607383613,
        0.537617526488799, 1.795981734324559,
        -2.4042918683890, 2.392810867653048,
        1.43592466941707, 2.140209407638501,
        0.661831365865483, 0.6588357336708348,
        -2.60316100528015, 1.996647507235527,
        -2.85055235799521, 1.064807599881037,
        0.721538642692646, 1.919429586547689,
        -3.10137291994495, 2.547652186978458,
        -1.80229938014771, 2.346795231693593,
        2.74045247055464, 2.190563789916284,
        2.28956635605568, 1.685083330586864,
        1.0802774234686, 2.26610351469196,
        -2.61987389222150, 2.544631654828911,
        -1.10480558726294, 1.545146143181859,
        2.88018027449649, 1.366084187099377,
        -1.50709970953142, 1.346914672354527,
        -2.25360166626573, 0.6314452324400267,
        -0.0848096124104068, 2.457205312755066,
        1.52522321686933, 1.006262066597019,
        2.60658522532750, 0.9636302906083062,
        0.592457999567220, 1.71446787866444,
        3.11947434597394, 1.650772727544756,
        -0.560568079122487, 2.115078204698722,
        2.67126506355167, 2.400708335894616,
        2.6207937756580, 2.417478003551967,
        2.63572799009051, 1.972602749146469,
        -0.252527183454696, 2.33319659280909,
        2.6976545422007, 2.175363670021461,
        -0.284227542906820, 1.642096458219276,
        -2.41717406374578, 0.9307244964475153,
        -1.61364785024028, 0.8519517075942711,
        2.29419218046692, 1.821167902425389,
        -1.10674349632490, 1.854110596627153,
        -2.27483724658203, 1.203756241065027,
        2.68612051291410, 1.922400185761683,
        1.57393311741119, 1.957614614810958,
        1.11227683708887, 2.039953509280431,
        -2.26489533292904, 0.6699773976265316,
        0.7096046949979, 1.081383631104835,
        1.39996962097740, 2.502747364687038,
        0.0792934738996955, 2.353240441337289,
        0.404241975157767, 2.139509236096171,
        1.10428323750506, 1.869115580571372,
        -2.0861377478317, 1.726958271947938,
        0.00812742930305378, 0.7721657743289578,
        -1.10643150217539, 1.369306634020476,
        1.26515378506746, 1.801239902655855,
        -0.536279375802227, 1.99896513991336,
        2.06441458777311, 2.681740431015215,
        0.0165165821516832, 1.488520432824708,
        -1.57514267305088, 1.650990828368015,
        2.20039287315101, 1.784098405922103,
        -0.885109231668673, 0.394895981611488,
        1.07285574518602, 2.433095789649302,
        2.72126783183358, 2.389985356051268,
        -2.92468122107276, 2.465527198452853,
        0.207437983896786, 2.401501065828523,
        -2.3026027360628, 2.321075473452091,
        -0.615412340167677, 1.588780837853568,
        -0.712129560886209, 1.167857310106955,
        1.09538196039548, 2.202237934910015,
        0.374742780296121, 0.648295973091772,
        1.0530740344025, 0.7211034134366349,
        -0.2613314001410, 1.377086010823744,
        0.479572411210414, 1.378051472656485,
        -3.12238714275476, 2.266363598385903,
        0.991639178576117, 2.010328188802197,
        1.72117977799795, 1.988069400869724,
        1.65889501111993, 3.057471591652518,
        0.45452097283764, 0.8541718244528158,
        1.23759897704577, 0.7770470052348442,
        -3.13845637582421, 1.047492237652419,
        -1.58789332474060, 1.087872875883831,
        1.2122026447150, 0.5022515231201523,
        1.00174245885984, 0.367240847885309,
        -0.436308151153712, 0.5655291634083364,
        -0.81493365172635, 0.8672644064387457,
        -2.47248263736945, 1.69415870135169,
        -0.591323217457683, 2.541630105591931,
        2.69866622219642, 1.285859844374112,
        1.43589755314530, 1.449202489795588,
        3.12909170926218, 1.750987512491827,
        1.58433198984946, 2.577013796075065,
        1.61664223734299, 1.200188810165842,
        2.071808165509, 1.0826548885325,
        1.76442757494389, 0.8067189657635059,
        -1.46087218256387, 2.495389181435103,
        -0.252469169078151, 1.66268996067317,
        -1.39355700758872, 2.069819217182722,
        2.32261257061026, 1.539846269857874,
        -2.6621485874451, 1.896995242507762,
        -2.39299047029906, 2.225860217561775,
        -0.871304434378167, 0.4947213033646262,
        -0.220875292194476, 2.636593129378872,
        2.7569403180077, 1.202927288669409,
        -0.0634696183930492, 2.14007073639976,
        -2.20512714272408, 1.216411236497088,
        -3.12709800370887, 1.351855622368341,
        -0.966017736046797, 0.8213334137915924,
        0.683187821468355, 1.614482785838544,
        0.862631663486492, 2.582038092646784,
        1.89964485997812, 0.3936916697092442,
        0.0265383884841783, 1.022660462776821,
        -0.281260717938651, 1.604357546785482,
        1.29045849399056, 2.206367353689107,
        -1.73168878624619, 2.470222903490423,
        -3.03668063739429, 1.532583194483962,
        2.58341941435520, 2.241545817606061,
        -0.571390028018262, 0.5352991723470565,
        -1.86526395674354, 0.6613951634294828,
        2.03956002113609, 1.423522236204612,
        0.569696951286580, 1.68028154073725,
        1.38452843121693, 2.328346897713157,
        -1.95383909740400, 2.574388811955104,
        2.57425584649030, 1.78329204526943,
        1.77588587054119, 1.544925035789322,
        -2.23723541213524, 1.642468051107691,
        -0.0832895639734998, 1.655144473083519,
        2.94765003550276, 1.673311551274806,
        2.87246089574700, 1.650757152630692,
        -0.503426166746550, 2.83682886278821,
        -1.17696019618512, 0.5618670035455906,
        1.06649960827638, 2.130203806486514,
        -0.970462407175917, 1.130729355355934,
        1.09088835056106, 2.754678213925347,
        0.186394183638331, 2.36654929897405,
        2.41658948564463, 1.582819694164697,
        1.39317106462663, 1.911357303434762,
        -2.73827773428967, 1.228848272033533,
        1.73744878376896, 1.37458971698201,
        -0.390049850280318, 1.97710012487467,
        2.27228164653360, 2.480726114758046,
        1.79035292113505, 0.7743422061697989,
        -2.295919084498, 1.898003196030666,
        -2.78661864075666, 2.285064304427145,
        -0.739678378928251, 1.795548549929678,
        0.641922140493061, 1.178921906576992,
        -2.87175899008384, 2.210739347237141,
        1.18966769945371, 1.406131404542987,
        0.80379214237455, 1.019593317871522,
        -0.18017547267173, 2.178962539412454,
        -2.90828531504742, 1.806852085094402,
        -0.0521905300833369, 2.39541580199914,
        1.13735197877733, 1.351510046740296,
        -0.376032032467778, 0.8421955887831823,
        2.79322381161764, 0.6565318499218928,
        -2.03528057245836, 1.582057673436627,
        0.600545274424058, 1.75580790122305,
        0.14378410479357, 0.3847386678824281,
        0.805057990307579, 1.773805098545603,
        3.11334909352951, 1.716354412778118,
        1.95709616816555, 0.6580571017952653,
        -0.252792895651356, 2.023786905411224,
        -2.48190840310127, 2.35975797808298,
        -2.65872615309304, 0.8842834710189782,
        2.93003038422310, 2.788377474175223,
        1.30842353825457, 1.903990478391745,
        -1.79623884689961, 1.798157392597191,
        -2.29271971512702, 1.938637706123823,
        -0.764363511866147, 0.2305927651153474,
        -1.40968071596135, 2.170825025526049,
        -0.628207613935650, 2.379900736883112,
        2.48106486392912, 1.240715191748359,
        1.74922705389631, 0.3083807654231304,
        2.17491985201926, 1.584541947469366,
        0.0394032826441782, 2.241811172235742,
        0.938215332042825, 0.9353669385808665,
        2.14748372669858, 2.552476930963151,
        0.750455441106592, 1.385236690428407,
        1.79391456793753, 1.646203782537719,
        -0.662457090838354, 0.4846786248251045,
        -0.560924061465570, 0.9384576322174161,
        0.350227841085235, 1.186161567916235,
        1.29493185841261, 0.9296354308594196,
        2.71946535790102, 1.737005945521047,
        -2.3106685290556, 2.153748776763256,
        2.48132336556396, 2.519873911942768,
        -0.708783343891865, 1.948136504544082,
        -0.938843924106792, 2.630640875418194,
        -1.96591373579087, 1.93764410720041,
        -0.963584620635779, 1.16887095946495,
        3.06934819198202, 2.563519610997198,
        -2.31399087650562, 1.787643308311596,
        0.320201916681928, 0.217097459944032,
        1.87895735554801, 1.185530305242784,
        -0.222060720189066, 2.122054032705593,
        -2.70030535828564, 1.762990487122175,
        0.812519466138048, 0.4373274331959491,
        0.743511189334752, 1.820938409070525,
        1.36545850170361, 2.760322036100304,
        -2.22621481945741, 0.9772408064172864,
        -2.56022531692449, 1.211560814810084,
        -2.37551098179183, 1.956877794273216,
        -1.14704840093329, 1.668889336320139,
        -2.26032744816845, 1.515601141097439,
        1.59254078924398, 0.9698626515137597,
        0.18319829838506, 0.6454851161445903,
        0.298132130927577, 0.7931154491702649,
        -2.45786032483761, 2.327050359695385,
        2.30228122653706, 2.141930746651206,
        -0.273998260520953, 0.7746562662686325,
        1.76010029946469, 1.919641731845446,
        -0.340455297507832, 2.216736625627242,
        -0.450372632938172, 1.569175645947264,
        -2.05306953891899, 2.614642574268265,
        -1.66890274595855, 1.221732061199574,
        -0.0248680120003113, 0.6041744523385378,
        2.73523252932875, 1.30119014948555,
        1.05536123001348, 1.957344440689853,
        -2.12069841908213, 2.390301500409115,
        2.53922917018282, 2.185331182681907,
        0.925036181233589, 0.7900325801359217,
        1.70179945279789, 2.741138564708969,
        -1.49000706489651, 1.710666135368696,
        0.797846436816203, 2.601670928425752,
        -1.7516006865920, 2.544419713415746,
        0.316434218634556, 1.251130979900285,
        0.992328324922436, 0.7211839640403541,
        0.557494341790748, 2.102917010286352,
        0.225550236570815, 0.1841015214543539,
        -2.9192474462659, 2.205163911452267,
        -0.433632358267458, 2.326181264676767,
        -2.52127747298519, 1.929963423290398,
        0.701938395552906, 1.515568930567861,
        -0.790273786923636, 1.575610372315859,
        -0.982707862058680, 1.306151941972092,
        -2.48317637172455, 1.500183952943012,
        -0.910806858434939, 1.044683528206667,
        -1.70976634909548, 1.458543130631921,
        1.90489663873377, 2.305473385793806,
        -2.49194189869940, 1.728638514198829,
        1.92710157049788, 1.289651386693024,
        1.40536228388384, 2.395556860695651,
        1.28988367704134, 2.785796786295229,
        2.42851411044500, 2.390186772755475,
        2.83844078457458, 0.2197777394819076,
        1.81374456742160, 2.213346874760673,
        1.16597754230812, 1.102807362215849,
        -1.3474553717103, 1.724599122013595,
        -2.45051315554832, 0.4481407298702379,
        -2.13807224722659, 0.3658660692332106,
        1.42529480760381, 0.7453984584403336,
        -1.85912013551354, 0.2125651730866597,
        1.72245352929126, 1.340015067642443,
        -0.543352550442442, 2.21648184403959,
        -1.87094879963494, 0.8655365299062676,
        -2.8478181742981, 2.726904864058322,
        -0.519353033774065, 2.10120321928492,
        0.242799678517495, 0.3159717945814214,
        2.52007592963243, 1.728728974623611,
        1.33815487790026, 2.495003969424511,
        2.58778516582778, 1.241946686952705,
        -1.87787705759258, 1.50550177474279,
        2.28567160671828, 1.550456284948247,
        -2.99762173263959, 1.535149232411106,
        2.07110568945970, 1.759706809140066,
        -1.84503557584006, 1.602653876499086,
        -1.94864798110905, 0.2855275239629807,
        2.21535545556220, 1.70831300584596,
        0.45402624392276, 1.146954158219625,
        1.15299379719923, 1.000981254035334,
        -0.439543700180312, 2.071132308721847,
        -2.00257184941015, 1.166099623500121,
        -0.371259339339674, 2.116599908888804,
        -0.176150802257223, 2.216519922671714,
        -2.54998569017796, 1.696920422333298,
        -0.793765320572047, 0.5014079480251099,
        -1.04326797475941, 2.933381719297953,
        1.4522514296013, 1.483497086694918,
        -2.0308253452123, 1.004295670135295,
        0.847687379969890, 1.022479503111206,
        -0.59307965949644, 1.912522628350297,
        -1.093476725852, 2.625907371576403,
        1.6394245441581, 2.05621008639037,
        -1.22185715592212, 0.3354258218784553,
        1.95940761476730, 1.195736279622363,
        0.223707725560511, 0.7411744257721052,
        1.14288006486715, 0.5965219428257921,
        -1.93395523873716, 0.3328678681909361,
        1.8193882419697, 1.880304442410923,
        -1.00315502805176, 1.856691684276131,
        0.888556772912746, 2.050814413780877,
        2.55619638860462, 1.718200695531647,
        -0.567706929874643, 1.053296690065982,
        -1.4272587212102, 0.9235537768961404,
        -1.28461986106900, 0.4079994977184325,
        2.02916816221009, 2.813425749611447,
        -0.0334970314674526, 1.058467310463299,
        1.70945886183485, 2.154931348956164,
        3.00732189627330, 2.370959892444653,
        -2.35557526016165, 2.156760217803551,
        -1.52576396389363, 1.183704990694568,
        0.0955816528400235, 1.483104959735487,
        2.14414283002247, 0.3435630718788111,
        2.05744661972028, 1.658790568849569,
        -1.03261202388940, 1.181096441981064,
        2.61223256822800, 0.787178220274277,
        -1.16791827523889, 2.416792198195721,
        0.880852886231317, 1.440966498076327,
        1.43375587538040, 1.01579098630265,
        -0.19003230948964, 0.567855364594318,
        1.91142865054851, 0.6308037923203862,
        0.890669294172913, 2.368747784561535,
        -1.27672222679996, 0.7423193892795023,
        0.740665320819644, 1.216178816847876,
        -0.137142170339918, 2.194709293305564,
        1.57390644980699, 1.590940764848991,
        2.71381278240113, 1.148375823025419,
        -2.08745931827194, 2.041143001489944,
        2.17145335478632, 1.759075518821518,
        2.93102876341271, 1.642904307931254,
        1.35581263894305, 1.677165570928219,
        -1.22684544859053, 1.607906136023938,
        2.4129408028468, 2.284173170300459,
        1.30826039277757, 0.4132853235413313,
        -1.19775795444145, 1.754279130049186,
        1.61491250960478, 1.827295908498258,
        1.52690446140883, 2.44105651393867,
        -2.55542882736389, 2.534450342396302,
        0.707070793390299, 0.6341161424404957,
        0.517271734431382, 2.615474406229724,
        0.0105283508066829, 1.865137900225204,
        1.63504558169425, 0.4354157503527236,
        -1.91449260530716, 1.344841793466587,
        -0.693769356364007, 2.153430001336246,
        -2.95873357334937, 1.536777377424091,
        -1.9122460686651, 2.502639631493174,
        -3.12409441462885, 2.612307429024234,
        2.57473056968783, 2.868760925205635,
        -0.98745469068678, 0.3923778343349847,
        -0.973116422302635, 2.278865229310097,
        1.25154567520608, 1.765653082768849,
        1.44217202390701, 2.474070077618296,
        -2.32530905533917, 1.918939721000263,
        -0.639834181718986, 2.747491325296469,
        2.49886540418484, 2.167347884124018,
        3.05493114793326, 1.449325086810579,
        0.495320911305761, 1.477837165326352,
        -2.37241629175599, 1.381885607457507,
        0.481276538471511, 2.103295986195147,
        1.54595365869112, 0.9726502325389466,
        -0.000329584885317812, 1.522217278964929,
        -1.26837659815871, 1.557464077104288,
        -0.496716456131990, 1.657361688036947,
        1.39775300752736, 1.846887041341097,
        -2.36742643652022, 1.661918098683911,
        2.75640277059549, 0.8693998114227128,
        2.22829881833026, 1.499469998915387,
        -1.29221568920470, 1.622230399790199,
        -1.17152568138985, 1.383008142517088,
        -0.103813296756114, 1.194911431924236,
        -0.994897368276598, 0.6549091990396697,
        -1.07730197837930, 1.830395017066302,
        1.76758625866629, 0.272010113295118,
        1.80613433521987, 1.748238122980259,
        -1.86006828383832, 1.702762625042027,
        -1.32964832837558, 2.562796364296348,
        -2.26797694059822, 1.166195344864868,
        -0.666075929470467, 2.213108781518079,
        1.37476778671030, 2.662746034231946,
        2.59940694094894, 1.531283053732549,
        3.07887851401204, 0.7837476288794857,
        2.38454770771356, 2.10906084035713,
        2.23803773050840, 0.13480007703635,
        2.29681557150696, 2.445447688402156,
        -1.14102986761262, 1.532536068035616,
        2.97082524330577, 1.808509608624971,
        1.15368781136731, 2.143588494814604,
        -0.0903231481352043, 1.766254292748914,
        2.28111338199579, 1.721442901710042,
        -0.145090319262921, 1.198289355967028,
        2.97472315175848, 0.5636194223307744,
        -2.38272494898040, 1.457694341769226,
        -0.305652226484123, 1.867757449437202,
        -1.20972163514841, 0.2985571896126875,
        0.787502609294174, 1.404406967730193,
        1.25480352728367, 0.9466069220111731,
        -2.96986843029850, 1.997396563561551,
        0.793853962210099, 1.69801898988943,
        -1.71774778592995, 1.559608013075381,
        -0.178706561910312, 1.266986693132481,
        -3.13284182586417, 1.239212237379426,
        -1.92042625658720, 1.847739334935147,
        -0.677304718440014, 1.326683160257233,
        2.60097121057185, 1.669596190874145,
        -1.97729136134540, 0.9001254998190017,
        1.75648660769408, 0.5548128828720713,
        -1.91579201118344, 0.7332269160932856,
        -1.97239396307414, 2.174661845294533,
        -0.783470704052926, 2.9066637289504,
        -0.258525196610859, 1.737491738900464,
        -2.81539757814926, 1.7614937491151,
        -1.98173383648217, 1.494837179691699,
        1.62002907099189, 2.44636353071877,
        -0.404249155172500, 1.27077404617424,
        3.10544025799446, 1.106841087094994,
        1.47287370506244, 2.341379247891487
      };


      const default_type tesselation_129_data[] = {
        0.00000, 0.00000,
        1.57080, 1.57080,
        0.00000, 1.57080,
        1.57080, 0.78540,
        0.78540, 1.57080,
        0.00000, 0.78540,
        2.35619, 1.57080,
        -3.14159, 0.78540,
        -1.57080, 0.78540,
        1.57080, 0.39270,
        0.78540, 0.61548,
        0.00000, 0.39270,
        1.57080, 1.17810,
        1.10715, 1.15026,
        1.17810, 1.57080,
        0.39270, 1.57080,
        0.46365, 1.15026,
        0.00000, 1.17810,
        2.35619, 0.61548,
        -3.14159, 0.39270,
        2.03444, 1.15026,
        1.96350, 1.57080,
        2.74889, 1.57080,
        2.67795, 1.15026,
        -3.14159, 1.17810,
        -1.57080, 0.39270,
        -0.78540, 0.61548,
        -1.57080, 1.17810,
        -1.10715, 1.15026,
        -0.46365, 1.15026,
        -2.35619, 0.61548,
        -2.03444, 1.15026,
        -2.67795, 1.15026,
        1.57080, 0.19635,
        0.78540, 0.28492,
        0.00000, 0.19635,
        1.57080, 0.58905,
        1.09430, 0.47275,
        1.21992, 0.66215,
        0.35088, 0.66215,
        0.47649, 0.47275,
        0.00000, 0.58905,
        1.57080, 1.37445,
        1.36658, 1.37071,
        1.37445, 1.57080,
        1.57080, 0.98175,
        1.34039, 1.15424,
        1.30900, 0.95532,
        0.93888, 1.35787,
        1.14424, 1.36040,
        0.98175, 1.57080,
        0.19635, 1.57080,
        0.20422, 1.37071,
        0.00000, 1.37445,
        0.58905, 1.57080,
        0.42656, 1.36040,
        0.63191, 1.35787,
        0.26180, 0.95532,
        0.23041, 1.15424,
        0.00000, 0.98175,
        0.98279, 0.87682,
        0.78540, 1.13029,
        0.58800, 0.87682,
        2.35619, 0.28492,
        -3.14159, 0.19635,
        2.04729, 0.47275,
        1.92168, 0.66215,
        2.79071, 0.66215,
        2.66510, 0.47275,
        -3.14159, 0.58905,
        1.77502, 1.37071,
        1.76715, 1.57080,
        1.80121, 1.15424,
        1.83260, 0.95532,
        2.20271, 1.35787,
        1.99735, 1.36040,
        2.15984, 1.57080,
        2.94524, 1.57080,
        2.93737, 1.37071,
        -3.14159, 1.37445,
        2.55254, 1.57080,
        2.71504, 1.36040,
        2.50968, 1.35787,
        2.87979, 0.95532,
        2.91118, 1.15424,
        -3.14159, 0.98175,
        2.15880, 0.87682,
        2.35619, 1.13029,
        2.55359, 0.87682,
        -1.57080, 0.19635,
        -0.78540, 0.28492,
        -1.57080, 0.58905,
        -1.09430, 0.47275,
        -1.21992, 0.66215,
        -0.35088, 0.66215,
        -0.47649, 0.47275,
        -1.57080, 1.37445,
        -1.36658, 1.37071,
        -1.57080, 0.98175,
        -1.34039, 1.15424,
        -1.30900, 0.95532,
        -0.93888, 1.35787,
        -1.14424, 1.36040,
        -0.20422, 1.37071,
        -0.42656, 1.36040,
        -0.63191, 1.35787,
        -0.26180, 0.95532,
        -0.23041, 1.15424,
        -0.98279, 0.87682,
        -0.78540, 1.13029,
        -0.58800, 0.87682,
        -2.35619, 0.28492,
        -2.04729, 0.47275,
        -1.92168, 0.66215,
        -2.79071, 0.66215,
        -2.66510, 0.47275,
        -1.77502, 1.37071,
        -1.80121, 1.15424,
        -1.83260, 0.95532,
        -2.20271, 1.35787,
        -1.99735, 1.36040,
        -2.93737, 1.37071,
        -2.71504, 1.36040,
        -2.50968, 1.35787,
        -2.87979, 0.95532,
        -2.91118, 1.15424,
        -2.15880, 0.87682,
        -2.35619, 1.13029,
        -2.55359, 0.87682
      };






      const default_type tesselation_321_data[] = {
        0.55357, 1.57080,
        2.58802, 1.57080,
        0.00000, 0.55357,
        0.00000, 2.58802,
        1.57080, 1.01722,
        -1.57080, 1.01722,
        0.00000, 1.57080,
        -0.36486, 1.04720,
        0.36486, 1.04720,
        -0.36486, 2.09440,
        0.36486, 2.09440,
        1.01722, 0.62832,
        1.01722, 1.25664,
        1.01722, 2.51327,
        1.01722, 1.88496,
        1.57080, 1.57080,
        2.12437, 2.51327,
        2.12437, 1.88496,
        2.12437, 0.62832,
        2.12437, 1.25664,
        0.00000, 0.00000,
        0.27679, 1.57080,
        0.16919, 1.30481,
        0.46601, 1.30789,
        -0.27679, 1.57080,
        -0.16919, 1.30481,
        -0.46601, 1.30789,
        -0.22751, 0.79253,
        0.00000, 1.01722,
        0.22751, 0.79253,
        0.16919, 1.83679,
        0.46601, 1.83371,
        -0.16919, 1.83679,
        -0.46601, 1.83371,
        -0.22751, 2.34906,
        0.00000, 2.12437,
        0.22751, 2.34906,
        0.70687, 1.13147,
        0.77948, 1.40948,
        0.62639, 0.81180,
        0.53967, 0.53027,
        1.34588, 0.80407,
        1.01722, 0.94248,
        1.27818, 1.12199,
        0.70687, 2.01012,
        0.77948, 1.73212,
        0.62639, 2.32979,
        0.53967, 2.61132,
        1.34588, 2.33752,
        1.01722, 2.19911,
        1.27818, 2.01960,
        1.01722, 1.57080,
        1.30114, 1.40761,
        1.57080, 1.29401,
        1.57080, 1.84758,
        1.30114, 1.73398,
        2.43472, 2.01012,
        2.36212, 1.73212,
        2.51520, 2.32979,
        2.60192, 2.61132,
        1.79572, 2.33752,
        2.12437, 2.19911,
        1.86341, 2.01960,
        2.43472, 1.13147,
        2.36212, 1.40948,
        2.51520, 0.81180,
        2.60192, 0.53027,
        1.79572, 0.80407,
        2.12437, 0.94248,
        1.86341, 1.12199,
        2.12437, 1.57080,
        1.84046, 1.40761,
        1.84046, 1.73398,
        0.00000, 0.27679,
        1.01722, 0.31416,
        3.14159, 0.27679,
        2.12437, 0.31416,
        1.57080, 0.55357,
        -1.01722, 0.31416,
        -2.12437, 0.31416,
        -1.57080, 0.55357,
        0.41518, 1.57080,
        0.36974, 1.43876,
        0.51056, 1.43922,
        0.13839, 1.57080,
        0.22395, 1.43761,
        0.08308, 1.43733,
        0.26173, 1.17430,
        0.31766, 1.30354,
        0.41819, 1.17709,
        -0.41518, 1.57080,
        -0.36974, 1.43876,
        -0.51056, 1.43922,
        -0.13839, 1.57080,
        -0.22395, 1.43761,
        -0.08308, 1.43733,
        -0.26173, 1.17430,
        -0.31766, 1.30354,
        -0.41819, 1.17709,
        -0.13096, 0.66997,
        0.00000, 0.77948,
        0.13096, 0.66997,
        -0.30289, 0.91874,
        -0.10363, 0.90175,
        -0.18408, 1.02481,
        0.18408, 1.02481,
        0.10363, 0.90175,
        0.30289, 0.91874,
        0.00000, 1.30114,
        -0.08993, 1.15971,
        0.08993, 1.15971,
        0.36974, 1.70284,
        0.51056, 1.70238,
        0.22395, 1.70398,
        0.08308, 1.70426,
        0.26173, 1.96729,
        0.31766, 1.83805,
        0.41819, 1.96450,
        -0.36974, 1.70284,
        -0.51056, 1.70238,
        -0.22395, 1.70398,
        -0.08308, 1.70426,
        -0.26173, 1.96729,
        -0.31766, 1.83805,
        -0.41819, 1.96450,
        -0.13096, 2.47163,
        0.00000, 2.36212,
        0.13096, 2.47163,
        -0.30289, 2.22286,
        -0.10363, 2.23984,
        -0.18408, 2.11678,
        0.18408, 2.11678,
        0.10363, 2.23984,
        0.30289, 2.22286,
        0.00000, 1.84046,
        -0.08993, 1.98188,
        0.08993, 1.98188,
        0.62448, 1.35613,
        0.66578, 1.48962,
        0.58252, 1.21733,
        0.53967, 1.08328,
        0.86592, 1.18991,
        0.74475, 1.27029,
        0.89613, 1.33143,
        0.35693, 0.65565,
        0.26448, 0.52579,
        0.42884, 0.79216,
        0.48402, 0.92542,
        0.80105, 0.71065,
        0.59078, 0.67060,
        0.79670, 0.56626,
        1.46772, 0.90760,
        1.30825, 0.96277,
        1.42025, 1.06507,
        1.19833, 0.70955,
        1.17192, 0.86661,
        1.01722, 0.78540,
        1.01722, 1.09956,
        1.15476, 1.02848,
        1.14415, 1.18636,
        0.67106, 0.97127,
        0.83258, 0.86771,
        0.85328, 1.03168,
        0.62448, 1.78546,
        0.66578, 1.65197,
        0.58252, 1.92426,
        0.53967, 2.05831,
        0.86592, 1.95169,
        0.74475, 1.87130,
        0.89613, 1.81016,
        0.35693, 2.48594,
        0.26448, 2.61581,
        0.42884, 2.34943,
        0.48402, 2.21617,
        0.80105, 2.43094,
        0.59078, 2.47100,
        0.79670, 2.57533,
        1.46772, 2.23400,
        1.30825, 2.17883,
        1.42025, 2.07652,
        1.19833, 2.43204,
        1.17192, 2.27498,
        1.01722, 2.35619,
        1.01722, 2.04204,
        1.15476, 2.11311,
        1.14415, 1.95523,
        0.67106, 2.17033,
        0.83258, 2.27389,
        0.85328, 2.10991,
        0.77948, 1.57080,
        0.89913, 1.48957,
        1.01722, 1.41372,
        1.01722, 1.72788,
        0.89913, 1.65203,
        1.42931, 1.20443,
        1.57080, 1.15562,
        1.29018, 1.26478,
        1.16181, 1.32979,
        1.43687, 1.48846,
        1.43424, 1.34886,
        1.57080, 1.43240,
        1.57080, 1.98598,
        1.42931, 1.93717,
        1.57080, 1.70919,
        1.43424, 1.79273,
        1.43687, 1.65313,
        1.16181, 1.81180,
        1.29018, 1.87681,
        1.15822, 1.48838,
        1.30114, 1.57080,
        1.15822, 1.65321,
        2.51712, 1.78546,
        2.47581, 1.65197,
        2.55907, 1.92426,
        2.60192, 2.05831,
        2.27567, 1.95169,
        2.39685, 1.87130,
        2.24546, 1.81016,
        2.78466, 2.48594,
        2.87711, 2.61581,
        2.71276, 2.34943,
        2.65757, 2.21617,
        2.34054, 2.43094,
        2.55082, 2.47100,
        2.34489, 2.57533,
        1.67388, 2.23400,
        1.83334, 2.17883,
        1.72134, 2.07652,
        1.94326, 2.43204,
        1.96968, 2.27498,
        2.12437, 2.35619,
        2.12437, 2.04204,
        1.98684, 2.11311,
        1.99744, 1.95523,
        2.47053, 2.17033,
        2.30902, 2.27389,
        2.28831, 2.10991,
        2.51712, 1.35613,
        2.47581, 1.48962,
        2.55907, 1.21733,
        2.60192, 1.08328,
        2.27567, 1.18991,
        2.39685, 1.27029,
        2.24546, 1.33143,
        2.78466, 0.65565,
        2.87711, 0.52579,
        2.71276, 0.79216,
        2.65757, 0.92542,
        2.34054, 0.71065,
        2.55082, 0.67060,
        2.34489, 0.56626,
        1.67388, 0.90760,
        1.83334, 0.96277,
        1.72134, 1.06507,
        1.94326, 0.70955,
        1.96968, 0.86661,
        2.12437, 0.78540,
        2.12437, 1.09956,
        1.98684, 1.02848,
        1.99744, 1.18636,
        2.47053, 0.97127,
        2.30902, 0.86771,
        2.28831, 1.03168,
        2.36212, 1.57080,
        2.24246, 1.48957,
        2.12437, 1.41372,
        2.12437, 1.72788,
        2.24246, 1.65203,
        1.71228, 1.20443,
        1.85141, 1.26478,
        1.97978, 1.32979,
        1.70472, 1.48846,
        1.70735, 1.34886,
        1.71228, 1.93717,
        1.70735, 1.79273,
        1.70472, 1.65313,
        1.97978, 1.81180,
        1.85141, 1.87681,
        1.98337, 1.48838,
        1.84046, 1.57080,
        1.98337, 1.65321,
        0.00000, 0.41518,
        0.35219, 0.39159,
        0.00000, 0.13839,
        0.54283, 0.25999,
        1.01722, 0.15708,
        1.01722, 0.47124,
        0.71973, 0.41219,
        3.14159, 0.41518,
        2.78940, 0.39159,
        3.14159, 0.13839,
        2.59876, 0.25999,
        2.12437, 0.15708,
        2.12437, 0.47124,
        2.42186, 0.41219,
        1.57080, 0.79132,
        1.70088, 0.67580,
        1.86341, 0.57319,
        1.27818, 0.57319,
        1.44071, 0.67580,
        1.57080, 0.26966,
        1.77397, 0.42026,
        1.36763, 0.42026,
        -0.35219, 0.39159,
        -0.54283, 0.25999,
        -1.01722, 0.15708,
        -1.01722, 0.47124,
        -0.71973, 0.41219,
        -2.78940, 0.39159,
        -2.59876, 0.25999,
        -2.12437, 0.15708,
        -2.12437, 0.47124,
        -2.42186, 0.41219,
        -1.57080, 0.79132,
        -1.70088, 0.67580,
        -1.86341, 0.57319,
        -1.27818, 0.57319,
        -1.44071, 0.67580,
        -1.57080, 0.26966,
        -1.77397, 0.42026,
        -1.36763, 0.42026
      };




      const default_type tesselation_469_data[] = {
        0.78540, 0.95532,
        -2.35619, 0.95532,
        2.35619, 2.18628,
        -0.78540, 2.18628,
        0.00000, 0.00000,
        3.14159, 1.57080,
        1.57080, 1.57080,
        0.78540, 0.47766,
        1.57080, 0.78540,
        1.21992, 1.23972,
        -2.35619, 0.47766,
        3.14159, 0.78540,
        -2.79071, 1.23972,
        2.79071, 1.90187,
        2.35619, 1.57080,
        1.92168, 1.90187,
        0.00000, 0.78540,
        0.35088, 1.23972,
        -1.57080, 0.78540,
        -1.92168, 1.23972,
        -1.21992, 1.90187,
        -0.35088, 1.90187,
        0.78540, 1.57080,
        2.35619, 2.66393,
        -0.78540, 2.66393,
        0.78540, 0.71649,
        1.07884, 0.84835,
        1.01884, 1.08786,
        0.78540, 0.23883,
        1.26570, 0.59607,
        1.57080, 0.39270,
        1.57080, 1.17810,
        1.36977, 1.00574,
        1.40030, 1.40273,
        -2.35619, 0.71649,
        -2.64964, 0.84835,
        -2.58964, 1.08786,
        -2.35619, 0.23883,
        -2.83650, 0.59607,
        3.14159, 0.39270,
        3.14159, 1.17810,
        -2.94057, 1.00574,
        -2.97110, 1.40273,
        2.58964, 2.05374,
        2.35619, 1.93301,
        2.12275, 2.05374,
        2.97110, 1.73886,
        2.56729, 1.74024,
        2.74889, 1.57080,
        1.96350, 1.57080,
        2.14510, 1.74024,
        1.74129, 1.73886,
        2.35619, 0.61548,
        2.67795, 1.15026,
        2.03444, 1.15026,
        0.49195, 0.84835,
        0.55196, 1.08786,
        0.30510, 0.59607,
        0.00000, 0.39270,
        0.00000, 1.17810,
        0.20102, 1.00574,
        0.17049, 1.40273,
        -2.06275, 0.84835,
        -2.12275, 1.08786,
        -1.87589, 0.59607,
        -1.57080, 0.39270,
        -1.57080, 1.17810,
        -1.77182, 1.00574,
        -1.74129, 1.40273,
        -1.01884, 2.05374,
        -0.78540, 1.93301,
        -0.55196, 2.05374,
        -1.40030, 1.73886,
        -0.99650, 1.74024,
        -0.57430, 1.74024,
        -0.17049, 1.73886,
        -0.78540, 0.61548,
        -1.10715, 1.15026,
        -0.46365, 1.15026,
        0.78540, 1.20858,
        0.99650, 1.40135,
        1.17810, 1.57080,
        0.39270, 1.57080,
        0.57430, 1.40135,
        2.06275, 2.29325,
        2.35619, 2.42511,
        1.77182, 2.13586,
        1.87589, 2.54552,
        2.35619, 2.90276,
        -0.78540, 2.42511,
        -0.49195, 2.29325,
        -0.78540, 2.90276,
        -0.30510, 2.54552,
        -0.20102, 2.13586,
        1.10715, 1.99133,
        0.78540, 2.52611,
        0.46365, 1.99133,
        -2.35619, 1.20858,
        -2.56729, 1.40135,
        -2.14510, 1.40135,
        2.64964, 2.29325,
        2.94057, 2.13586,
        2.83650, 2.54552,
        -1.07884, 2.29325,
        -1.26570, 2.54552,
        -1.36977, 2.13586,
        -2.67795, 1.99133,
        -2.35619, 2.52611,
        -2.03444, 1.99133,
        0.78540, 0.83590,
        0.91952, 0.89892,
        0.90688, 1.01855,
        0.78540, 0.59707,
        0.94194, 0.77704,
        0.96759, 0.65807,
        1.15753, 1.04297,
        1.04636, 0.96789,
        1.12269, 1.16195,
        0.78540, 0.11941,
        1.27553, 0.29445,
        1.57080, 0.19635,
        0.78540, 0.35824,
        1.12490, 0.40856,
        1.04993, 0.52428,
        1.43591, 0.68508,
        1.38915, 0.48970,
        1.57080, 0.58905,
        1.57080, 1.37445,
        1.48277, 1.28945,
        1.48616, 1.48646,
        1.57080, 0.98175,
        1.47481, 1.08985,
        1.46135, 0.89312,
        1.29060, 1.12164,
        1.38622, 1.20419,
        1.31199, 1.32025,
        1.15879, 0.72008,
        1.32823, 0.80025,
        1.23298, 0.92195,
        -2.35619, 0.83590,
        -2.49031, 0.89892,
        -2.47768, 1.01855,
        -2.35619, 0.59707,
        -2.51273, 0.77704,
        -2.53838, 0.65807,
        -2.72832, 1.04297,
        -2.61715, 0.96789,
        -2.69348, 1.16195,
        -2.35619, 0.11941,
        -2.84632, 0.29445,
        3.14159, 0.19635,
        -2.35619, 0.35824,
        -2.69570, 0.40856,
        -2.62073, 0.52428,
        -3.00670, 0.68508,
        -2.95995, 0.48970,
        3.14159, 0.58905,
        3.14159, 1.37445,
        -3.05357, 1.28945,
        -3.05695, 1.48646,
        3.14159, 0.98175,
        -3.04560, 1.08985,
        -3.03215, 0.89312,
        -2.86140, 1.12164,
        -2.95701, 1.20419,
        -2.88279, 1.32025,
        -2.72958, 0.72008,
        -2.89902, 0.80025,
        -2.80377, 0.92195,
        2.47768, 2.12305,
        2.35619, 2.06513,
        2.23471, 2.12305,
        2.69348, 1.97964,
        2.46973, 1.99593,
        2.57470, 1.92511,
        2.13769, 1.92511,
        2.24266, 1.99593,
        2.01891, 1.97964,
        3.05695, 1.65513,
        2.85921, 1.65535,
        2.94524, 1.57080,
        2.88279, 1.82134,
        2.76922, 1.74298,
        2.67668, 1.82256,
        2.46098, 1.65599,
        2.65875, 1.65587,
        2.55254, 1.57080,
        1.76715, 1.57080,
        1.85318, 1.65535,
        1.65544, 1.65513,
        2.15984, 1.57080,
        2.05364, 1.65587,
        2.25141, 1.65599,
        2.03571, 1.82256,
        1.94317, 1.74298,
        1.82960, 1.82134,
        2.46453, 1.83804,
        2.35619, 1.74401,
        2.24786, 1.83804,
        2.35619, 0.28492,
        2.66510, 0.47275,
        2.79071, 0.66215,
        1.92168, 0.66215,
        2.04729, 0.47275,
        2.93737, 1.37071,
        2.91118, 1.15424,
        2.87979, 0.95532,
        2.50968, 1.35787,
        2.71504, 1.36040,
        1.77502, 1.37071,
        1.99735, 1.36040,
        2.20271, 1.35787,
        1.83260, 0.95532,
        1.80121, 1.15424,
        2.55359, 0.87682,
        2.35619, 1.13029,
        2.15880, 0.87682,
        0.65128, 0.89892,
        0.66391, 1.01855,
        0.62886, 0.77704,
        0.60321, 0.65807,
        0.41327, 1.04297,
        0.52444, 0.96789,
        0.44811, 1.16195,
        0.29527, 0.29445,
        0.00000, 0.19635,
        0.44589, 0.40856,
        0.52086, 0.52428,
        0.13489, 0.68508,
        0.18164, 0.48970,
        0.00000, 0.58905,
        0.00000, 1.37445,
        0.08802, 1.28945,
        0.08464, 1.48646,
        0.00000, 0.98175,
        0.09599, 1.08985,
        0.10944, 0.89312,
        0.28019, 1.12164,
        0.18458, 1.20419,
        0.25880, 1.32025,
        0.41201, 0.72008,
        0.24257, 0.80025,
        0.33782, 0.92195,
        -2.22207, 0.89892,
        -2.23471, 1.01855,
        -2.19966, 0.77704,
        -2.17400, 0.65807,
        -1.98407, 1.04297,
        -2.09524, 0.96789,
        -2.01891, 1.16195,
        -1.86607, 0.29445,
        -1.57080, 0.19635,
        -2.01669, 0.40856,
        -2.09166, 0.52428,
        -1.70569, 0.68508,
        -1.75244, 0.48970,
        -1.57080, 0.58905,
        -1.57080, 1.37445,
        -1.65882, 1.28945,
        -1.65544, 1.48646,
        -1.57080, 0.98175,
        -1.66678, 1.08985,
        -1.68024, 0.89312,
        -1.85099, 1.12164,
        -1.75537, 1.20419,
        -1.82960, 1.32025,
        -1.98281, 0.72008,
        -1.81337, 0.80025,
        -1.90861, 0.92195,
        -0.90688, 2.12305,
        -0.78540, 2.06513,
        -0.66391, 2.12305,
        -1.12269, 1.97964,
        -0.89893, 1.99593,
        -1.00390, 1.92511,
        -0.56690, 1.92511,
        -0.67186, 1.99593,
        -0.44811, 1.97964,
        -1.48616, 1.65513,
        -1.28841, 1.65535,
        -1.31199, 1.82134,
        -1.19842, 1.74298,
        -1.10588, 1.82256,
        -0.89018, 1.65599,
        -1.08795, 1.65587,
        -0.28239, 1.65535,
        -0.08464, 1.65513,
        -0.48284, 1.65587,
        -0.68061, 1.65599,
        -0.46491, 1.82256,
        -0.37237, 1.74298,
        -0.25880, 1.82134,
        -0.89374, 1.83804,
        -0.78540, 1.74401,
        -0.67706, 1.83804,
        -0.78540, 0.28492,
        -1.09430, 0.47275,
        -1.21992, 0.66215,
        -0.35088, 0.66215,
        -0.47649, 0.47275,
        -1.36658, 1.37071,
        -1.34039, 1.15424,
        -1.30900, 0.95532,
        -0.93888, 1.35787,
        -1.14424, 1.36040,
        -0.20422, 1.37071,
        -0.42656, 1.36040,
        -0.63191, 1.35787,
        -0.26180, 0.95532,
        -0.23041, 1.15424,
        -0.98279, 0.87682,
        -0.78540, 1.13029,
        -0.58800, 0.87682,
        0.78540, 1.07646,
        0.89893, 1.14566,
        1.00390, 1.21648,
        0.56690, 1.21648,
        0.67186, 1.14566,
        1.28841, 1.48624,
        1.37445, 1.57080,
        1.19842, 1.39861,
        1.10588, 1.31903,
        0.89018, 1.48560,
        1.08795, 1.48573,
        0.98175, 1.57080,
        0.19635, 1.57080,
        0.28239, 1.48624,
        0.58905, 1.57080,
        0.48284, 1.48573,
        0.68061, 1.48560,
        0.46491, 1.31903,
        0.37237, 1.39861,
        0.89374, 1.30355,
        0.78540, 1.39758,
        0.67706, 1.30355,
        2.22207, 2.24267,
        2.35619, 2.30569,
        2.09524, 2.17370,
        1.98407, 2.09863,
        2.17400, 2.48352,
        2.19966, 2.36455,
        2.35619, 2.54452,
        1.65882, 1.85215,
        1.75537, 1.93740,
        1.85099, 2.01996,
        1.68024, 2.24848,
        1.66678, 2.05174,
        1.86607, 2.84714,
        2.35619, 3.02218,
        1.75244, 2.65190,
        1.70569, 2.45651,
        2.09166, 2.61731,
        2.01669, 2.73303,
        2.35619, 2.78335,
        1.90861, 2.21964,
        1.81337, 2.34134,
        1.98281, 2.42151,
        -0.78540, 2.30569,
        -0.65128, 2.24267,
        -0.78540, 2.54452,
        -0.62886, 2.36455,
        -0.60321, 2.48352,
        -0.41327, 2.09863,
        -0.52444, 2.17370,
        -0.78540, 3.02218,
        -0.29527, 2.84714,
        -0.78540, 2.78335,
        -0.44589, 2.73303,
        -0.52086, 2.61731,
        -0.13489, 2.45651,
        -0.18164, 2.65190,
        -0.08802, 1.85215,
        -0.09599, 2.05174,
        -0.10944, 2.24848,
        -0.28019, 2.01996,
        -0.18458, 1.93740,
        -0.41201, 2.42151,
        -0.24257, 2.34134,
        -0.33782, 2.21964,
        1.36658, 1.77089,
        1.34039, 1.98735,
        1.30900, 2.18628,
        0.93888, 1.78373,
        1.14424, 1.78119,
        0.78540, 2.85667,
        1.09430, 2.66884,
        1.21992, 2.47945,
        0.35088, 2.47945,
        0.47649, 2.66884,
        0.20422, 1.77089,
        0.23041, 1.98735,
        0.26180, 2.18628,
        0.63191, 1.78373,
        0.42656, 1.78119,
        0.98279, 2.26478,
        0.58800, 2.26478,
        0.78540, 2.01131,
        -2.35619, 1.07646,
        -2.46973, 1.14566,
        -2.57470, 1.21648,
        -2.13769, 1.21648,
        -2.24266, 1.14566,
        -2.85921, 1.48624,
        -2.76922, 1.39861,
        -2.67668, 1.31903,
        -2.46098, 1.48560,
        -2.65875, 1.48573,
        -1.85318, 1.48624,
        -2.05364, 1.48573,
        -2.25141, 1.48560,
        -2.03571, 1.31903,
        -1.94317, 1.39861,
        -2.46453, 1.30355,
        -2.35619, 1.39758,
        -2.24786, 1.30355,
        2.49031, 2.24267,
        2.61715, 2.17370,
        2.72832, 2.09863,
        2.53838, 2.48352,
        2.51273, 2.36455,
        3.05357, 1.85215,
        2.95701, 1.93740,
        2.86140, 2.01996,
        3.03215, 2.24848,
        3.04560, 2.05174,
        2.84632, 2.84714,
        2.95995, 2.65190,
        3.00670, 2.45651,
        2.62073, 2.61731,
        2.69570, 2.73303,
        2.80377, 2.21964,
        2.89902, 2.34134,
        2.72958, 2.42151,
        -0.91952, 2.24267,
        -0.94194, 2.36455,
        -0.96759, 2.48352,
        -1.15753, 2.09863,
        -1.04636, 2.17370,
        -1.27553, 2.84714,
        -1.12490, 2.73303,
        -1.04993, 2.61731,
        -1.43591, 2.45651,
        -1.38915, 2.65190,
        -1.48277, 1.85215,
        -1.47481, 2.05174,
        -1.46135, 2.24848,
        -1.29060, 2.01996,
        -1.38622, 1.93740,
        -1.15879, 2.42151,
        -1.32823, 2.34134,
        -1.23298, 2.21964,
        -2.93737, 1.77089,
        -2.91118, 1.98735,
        -2.87979, 2.18628,
        -2.50968, 1.78373,
        -2.71504, 1.78119,
        -2.35619, 2.85667,
        -2.66510, 2.66884,
        -2.79071, 2.47945,
        -1.92168, 2.47945,
        -2.04729, 2.66884,
        -1.77502, 1.77089,
        -1.80121, 1.98735,
        -1.83260, 2.18628,
        -2.20271, 1.78373,
        -1.99735, 1.78119,
        -2.55359, 2.26478,
        -2.15880, 2.26478,
        -2.35619, 2.01131
      };



      const default_type tesselation_513_data[] = {
        0.00000, 0.00000,
        1.57080, 1.57080,
        0.00000, 1.57080,
        1.57080, 0.78540,
        0.78540, 1.57080,
        0.00000, 0.78540,
        2.35619, 1.57080,
        3.14159, 0.78540,
        -1.57080, 0.78540,
        1.57080, 0.39270,
        0.78540, 0.61548,
        0.00000, 0.39270,
        1.57080, 1.17810,
        1.10715, 1.15026,
        1.17810, 1.57080,
        0.39270, 1.57080,
        0.46365, 1.15026,
        0.00000, 1.17810,
        2.35619, 0.61548,
        3.14159, 0.39270,
        2.03444, 1.15026,
        1.96350, 1.57080,
        2.74889, 1.57080,
        2.67795, 1.15026,
        3.14159, 1.17810,
        -1.57080, 0.39270,
        -0.78540, 0.61548,
        -1.57080, 1.17810,
        -1.10715, 1.15026,
        -0.46365, 1.15026,
        -2.35619, 0.61548,
        -2.03444, 1.15026,
        -2.67795, 1.15026,
        1.57080, 0.19635,
        0.78540, 0.28492,
        0.00000, 0.19635,
        1.57080, 0.58905,
        1.09430, 0.47275,
        1.21992, 0.66215,
        0.35088, 0.66215,
        0.47649, 0.47275,
        0.00000, 0.58905,
        1.57080, 1.37445,
        1.36658, 1.37071,
        1.37445, 1.57080,
        1.57080, 0.98175,
        1.34039, 1.15424,
        1.30900, 0.95532,
        0.93888, 1.35787,
        1.14424, 1.36040,
        0.98175, 1.57080,
        0.19635, 1.57080,
        0.20422, 1.37071,
        0.00000, 1.37445,
        0.58905, 1.57080,
        0.42656, 1.36040,
        0.63191, 1.35787,
        0.26180, 0.95532,
        0.23041, 1.15424,
        0.00000, 0.98175,
        0.98279, 0.87682,
        0.78540, 1.13029,
        0.58800, 0.87682,
        2.35619, 0.28492,
        3.14159, 0.19635,
        2.04729, 0.47275,
        1.92168, 0.66215,
        2.79071, 0.66215,
        2.66510, 0.47275,
        3.14159, 0.58905,
        1.77502, 1.37071,
        1.76715, 1.57080,
        1.80121, 1.15424,
        1.83260, 0.95532,
        2.20271, 1.35787,
        1.99735, 1.36040,
        2.15984, 1.57080,
        2.94524, 1.57080,
        2.93737, 1.37071,
        3.14159, 1.37445,
        2.55254, 1.57080,
        2.71504, 1.36040,
        2.50968, 1.35787,
        2.87979, 0.95532,
        2.91118, 1.15424,
        3.14159, 0.98175,
        2.15880, 0.87682,
        2.35619, 1.13029,
        2.55359, 0.87682,
        -1.57080, 0.19635,
        -0.78540, 0.28492,
        -1.57080, 0.58905,
        -1.09430, 0.47275,
        -1.21992, 0.66215,
        -0.35088, 0.66215,
        -0.47649, 0.47275,
        -1.57080, 1.37445,
        -1.36658, 1.37071,
        -1.57080, 0.98175,
        -1.34039, 1.15424,
        -1.30900, 0.95532,
        -0.93888, 1.35787,
        -1.14424, 1.36040,
        -0.20422, 1.37071,
        -0.42656, 1.36040,
        -0.63191, 1.35787,
        -0.26180, 0.95532,
        -0.23041, 1.15424,
        -0.98279, 0.87682,
        -0.78540, 1.13029,
        -0.58800, 0.87682,
        -2.35619, 0.28492,
        -2.04729, 0.47275,
        -1.92168, 0.66215,
        -2.79071, 0.66215,
        -2.66510, 0.47275,
        -1.77502, 1.37071,
        -1.80121, 1.15424,
        -1.83260, 0.95532,
        -2.20271, 1.35787,
        -1.99735, 1.36040,
        -2.93737, 1.37071,
        -2.71504, 1.36040,
        -2.50968, 1.35787,
        -2.87979, 0.95532,
        -2.91118, 1.15424,
        -2.15880, 0.87682,
        -2.35619, 1.13029,
        -2.55359, 0.87682,
        1.57080, 0.09817,
        0.78540, 0.13974,
        0.00000, 0.09817,
        1.57080, 0.29452,
        1.10343, 0.22355,
        1.24141, 0.31534,
        0.32938, 0.31534,
        0.46736, 0.22355,
        0.00000, 0.29452,
        1.57080, 0.68722,
        1.38638, 0.61829,
        1.40773, 0.71614,
        1.57080, 0.49087,
        1.35663, 0.51860,
        1.31150, 0.42200,
        0.92146, 0.53890,
        1.16648, 0.56657,
        1.00959, 0.62748,
        0.16306, 0.71614,
        0.18441, 0.61829,
        0.00000, 0.68722,
        0.56120, 0.62748,
        0.40431, 0.56657,
        0.64934, 0.53890,
        0.25930, 0.42200,
        0.21417, 0.51860,
        0.00000, 0.49087,
        0.97667, 0.37497,
        0.78540, 0.45337,
        0.59412, 0.37497,
        1.57080, 1.47262,
        1.47167, 1.47215,
        1.47262, 1.57080,
        1.57080, 1.27627,
        1.46873, 1.37157,
        1.46566, 1.27294,
        1.27138, 1.47031,
        1.37055, 1.47075,
        1.27627, 1.57080,
        1.57080, 0.88357,
        1.44109, 0.96452,
        1.43044, 0.86614,
        1.57080, 1.07992,
        1.45009, 1.06519,
        1.45618, 1.16376,
        1.22387, 1.14971,
        1.32558, 1.05472,
        1.20243, 1.05060,
        0.86126, 1.46402,
        0.96056, 1.46431,
        0.88357, 1.57080,
        1.02014, 1.25302,
        1.04159, 1.35805,
        1.12633, 1.25528,
        1.16136, 1.46558,
        1.06209, 1.46525,
        1.07992, 1.57080,
        1.35394, 1.26245,
        1.23901, 1.25591,
        1.25553, 1.36432,
        0.09817, 1.57080,
        0.09913, 1.47215,
        0.00000, 1.47262,
        0.29452, 1.57080,
        0.20024, 1.47075,
        0.29941, 1.47031,
        0.10513, 1.27294,
        0.10207, 1.37157,
        0.00000, 1.27627,
        0.68722, 1.57080,
        0.61024, 1.46431,
        0.70953, 1.46402,
        0.49087, 1.57080,
        0.50871, 1.46525,
        0.40944, 1.46558,
        0.44446, 1.25528,
        0.52921, 1.35805,
        0.55066, 1.25302,
        0.14035, 0.86614,
        0.12970, 0.96452,
        0.00000, 0.88357,
        0.36837, 1.05060,
        0.24522, 1.05472,
        0.34692, 1.14971,
        0.11461, 1.16376,
        0.12071, 1.06519,
        0.00000, 1.07992,
        0.31527, 1.36432,
        0.33178, 1.25591,
        0.21686, 1.26245,
        1.27074, 0.80825,
        1.15086, 0.90961,
        1.05031, 1.01268,
        0.89817, 0.74377,
        1.08811, 0.76600,
        0.78540, 1.35541,
        0.86512, 1.24318,
        0.94702, 1.13532,
        0.62378, 1.13532,
        0.70568, 1.24318,
        0.30006, 0.80825,
        0.41994, 0.90961,
        0.52049, 1.01268,
        0.67262, 0.74377,
        0.48269, 0.76600,
        0.87606, 1.00135,
        0.69474, 1.00135,
        0.78540, 0.86716,
        2.35619, 0.13974,
        3.14159, 0.09817,
        2.03816, 0.22355,
        1.90018, 0.31534,
        2.81221, 0.31534,
        2.67423, 0.22355,
        3.14159, 0.29452,
        1.75521, 0.61829,
        1.73386, 0.71614,
        1.78497, 0.51860,
        1.83009, 0.42200,
        2.22014, 0.53890,
        1.97511, 0.56657,
        2.13200, 0.62748,
        2.97853, 0.71614,
        2.95718, 0.61829,
        3.14159, 0.68722,
        2.58039, 0.62748,
        2.73728, 0.56657,
        2.49225, 0.53890,
        2.88229, 0.42200,
        2.92742, 0.51860,
        3.14159, 0.49087,
        2.16492, 0.37497,
        2.35619, 0.45337,
        2.54747, 0.37497,
        1.66993, 1.47215,
        1.66897, 1.57080,
        1.67287, 1.37157,
        1.67593, 1.27294,
        1.87021, 1.47031,
        1.77104, 1.47075,
        1.86532, 1.57080,
        1.70050, 0.96452,
        1.71115, 0.86614,
        1.69150, 1.06519,
        1.68541, 1.16376,
        1.91772, 1.14971,
        1.81601, 1.05472,
        1.93916, 1.05060,
        2.28033, 1.46402,
        2.18103, 1.46431,
        2.25802, 1.57080,
        2.12146, 1.25302,
        2.10000, 1.35805,
        2.01526, 1.25528,
        1.98024, 1.46558,
        2.07951, 1.46525,
        2.06167, 1.57080,
        1.78766, 1.26245,
        1.90258, 1.25591,
        1.88606, 1.36432,
        3.04342, 1.57080,
        3.04246, 1.47215,
        3.14159, 1.47262,
        2.84707, 1.57080,
        2.94135, 1.47075,
        2.84218, 1.47031,
        3.03646, 1.27294,
        3.03952, 1.37157,
        3.14159, 1.27627,
        2.45437, 1.57080,
        2.53136, 1.46431,
        2.43206, 1.46402,
        2.65072, 1.57080,
        2.63288, 1.46525,
        2.73215, 1.46558,
        2.69713, 1.25528,
        2.61239, 1.35805,
        2.59093, 1.25302,
        3.00124, 0.86614,
        3.01189, 0.96452,
        3.14159, 0.88357,
        2.77323, 1.05060,
        2.89638, 1.05472,
        2.79467, 1.14971,
        3.02698, 1.16376,
        3.02089, 1.06519,
        3.14159, 1.07992,
        2.82632, 1.36432,
        2.80981, 1.25591,
        2.92473, 1.26245,
        1.87086, 0.80825,
        1.99074, 0.90961,
        2.09128, 1.01268,
        2.24342, 0.74377,
        2.05349, 0.76600,
        2.35619, 1.35541,
        2.27647, 1.24318,
        2.19457, 1.13532,
        2.51781, 1.13532,
        2.43591, 1.24318,
        2.84153, 0.80825,
        2.72165, 0.90961,
        2.62110, 1.01268,
        2.46897, 0.74377,
        2.65890, 0.76600,
        2.26553, 1.00135,
        2.44685, 1.00135,
        2.35619, 0.86716,
        -1.57080, 0.09817,
        -0.78540, 0.13974,
        -1.57080, 0.29452,
        -1.10343, 0.22355,
        -1.24141, 0.31534,
        -0.32938, 0.31534,
        -0.46736, 0.22355,
        -1.57080, 0.68722,
        -1.38638, 0.61829,
        -1.40773, 0.71614,
        -1.57080, 0.49087,
        -1.35663, 0.51860,
        -1.31150, 0.42200,
        -0.92146, 0.53890,
        -1.16648, 0.56657,
        -1.00959, 0.62748,
        -0.16306, 0.71614,
        -0.18441, 0.61829,
        -0.56120, 0.62748,
        -0.40431, 0.56657,
        -0.64934, 0.53890,
        -0.25930, 0.42200,
        -0.21417, 0.51860,
        -0.97667, 0.37497,
        -0.78540, 0.45337,
        -0.59412, 0.37497,
        -1.57080, 1.47262,
        -1.47167, 1.47215,
        -1.57080, 1.27627,
        -1.46873, 1.37157,
        -1.46566, 1.27294,
        -1.27138, 1.47031,
        -1.37055, 1.47075,
        -1.57080, 0.88357,
        -1.44109, 0.96452,
        -1.43044, 0.86614,
        -1.57080, 1.07992,
        -1.45009, 1.06519,
        -1.45618, 1.16376,
        -1.22387, 1.14971,
        -1.32558, 1.05472,
        -1.20243, 1.05060,
        -0.86126, 1.46402,
        -0.96056, 1.46431,
        -1.02014, 1.25302,
        -1.04159, 1.35805,
        -1.12633, 1.25528,
        -1.16136, 1.46558,
        -1.06209, 1.46525,
        -1.35394, 1.26245,
        -1.23901, 1.25591,
        -1.25553, 1.36432,
        -0.09913, 1.47215,
        -0.20024, 1.47075,
        -0.29941, 1.47031,
        -0.10513, 1.27294,
        -0.10207, 1.37157,
        -0.61024, 1.46431,
        -0.70953, 1.46402,
        -0.50871, 1.46525,
        -0.40944, 1.46558,
        -0.44446, 1.25528,
        -0.52921, 1.35805,
        -0.55066, 1.25302,
        -0.14035, 0.86614,
        -0.12970, 0.96452,
        -0.36837, 1.05060,
        -0.24522, 1.05472,
        -0.34692, 1.14971,
        -0.11461, 1.16376,
        -0.12071, 1.06519,
        -0.31527, 1.36432,
        -0.33178, 1.25591,
        -0.21686, 1.26245,
        -1.27074, 0.80825,
        -1.15086, 0.90961,
        -1.05031, 1.01268,
        -0.89817, 0.74377,
        -1.08811, 0.76600,
        -0.78540, 1.35541,
        -0.86512, 1.24318,
        -0.94702, 1.13532,
        -0.62378, 1.13532,
        -0.70568, 1.24318,
        -0.30006, 0.80825,
        -0.41994, 0.90961,
        -0.52049, 1.01268,
        -0.67262, 0.74377,
        -0.48269, 0.76600,
        -0.87606, 1.00135,
        -0.69474, 1.00135,
        -0.78540, 0.86716,
        -2.35619, 0.13974,
        -2.03816, 0.22355,
        -1.90018, 0.31534,
        -2.81221, 0.31534,
        -2.67423, 0.22355,
        -1.75521, 0.61829,
        -1.73386, 0.71614,
        -1.78497, 0.51860,
        -1.83009, 0.42200,
        -2.22014, 0.53890,
        -1.97511, 0.56657,
        -2.13200, 0.62748,
        -2.97853, 0.71614,
        -2.95718, 0.61829,
        -2.58039, 0.62748,
        -2.73728, 0.56657,
        -2.49225, 0.53890,
        -2.88229, 0.42200,
        -2.92742, 0.51860,
        -2.16492, 0.37497,
        -2.35619, 0.45337,
        -2.54747, 0.37497,
        -1.66993, 1.47215,
        -1.67287, 1.37157,
        -1.67593, 1.27294,
        -1.87021, 1.47031,
        -1.77104, 1.47075,
        -1.70050, 0.96452,
        -1.71115, 0.86614,
        -1.69150, 1.06519,
        -1.68541, 1.16376,
        -1.91772, 1.14971,
        -1.81601, 1.05472,
        -1.93916, 1.05060,
        -2.28033, 1.46402,
        -2.18103, 1.46431,
        -2.12146, 1.25302,
        -2.10000, 1.35805,
        -2.01526, 1.25528,
        -1.98024, 1.46558,
        -2.07951, 1.46525,
        -1.78766, 1.26245,
        -1.90258, 1.25591,
        -1.88606, 1.36432,
        -3.04246, 1.47215,
        -2.94135, 1.47075,
        -2.84218, 1.47031,
        -3.03646, 1.27294,
        -3.03952, 1.37157,
        -2.53136, 1.46431,
        -2.43206, 1.46402,
        -2.63288, 1.46525,
        -2.73215, 1.46558,
        -2.69713, 1.25528,
        -2.61239, 1.35805,
        -2.59093, 1.25302,
        -3.00124, 0.86614,
        -3.01189, 0.96452,
        -2.77323, 1.05060,
        -2.89638, 1.05472,
        -2.79467, 1.14971,
        -3.02698, 1.16376,
        -3.02089, 1.06519,
        -2.82632, 1.36432,
        -2.80981, 1.25591,
        -2.92473, 1.26245,
        -1.87086, 0.80825,
        -1.99074, 0.90961,
        -2.09128, 1.01268,
        -2.24342, 0.74377,
        -2.05349, 0.76600,
        -2.35619, 1.35541,
        -2.27647, 1.24318,
        -2.19457, 1.13532,
        -2.51781, 1.13532,
        -2.43591, 1.24318,
        -2.84153, 0.80825,
        -2.72165, 0.90961,
        -2.62110, 1.01268,
        -2.46897, 0.74377,
        -2.65890, 0.76600,
        -2.26553, 1.00135,
        -2.44685, 1.00135,
        -2.35619, 0.86716
      };




      const default_type tesselation_1281_data[] = {
        0.55357, 1.57080,
        2.58802, 1.57080,
        0.00000, 0.55357,
        0.00000, 2.58802,
        1.57080, 1.01722,
        -1.57080, 1.01722,
        0.00000, 1.57080,
        -0.36486, 1.04720,
        0.36486, 1.04720,
        -0.36486, 2.09440,
        0.36486, 2.09440,
        1.01722, 0.62832,
        1.01722, 1.25664,
        1.01722, 2.51327,
        1.01722, 1.88496,
        1.57080, 1.57080,
        2.12437, 2.51327,
        2.12437, 1.88496,
        2.12437, 0.62832,
        2.12437, 1.25664,
        0.00000, 0.00000,
        0.27679, 1.57080,
        0.16919, 1.30481,
        0.46601, 1.30789,
        -0.27679, 1.57080,
        -0.16919, 1.30481,
        -0.46601, 1.30789,
        -0.22751, 0.79253,
        0.00000, 1.01722,
        0.22751, 0.79253,
        0.16919, 1.83679,
        0.46601, 1.83371,
        -0.16919, 1.83679,
        -0.46601, 1.83371,
        -0.22751, 2.34906,
        0.00000, 2.12437,
        0.22751, 2.34906,
        0.70687, 1.13147,
        0.77948, 1.40948,
        0.62639, 0.81180,
        0.53967, 0.53027,
        1.34588, 0.80407,
        1.01722, 0.94248,
        1.27818, 1.12199,
        0.70687, 2.01012,
        0.77948, 1.73212,
        0.62639, 2.32979,
        0.53967, 2.61132,
        1.34588, 2.33752,
        1.01722, 2.19911,
        1.27818, 2.01960,
        1.01722, 1.57080,
        1.30114, 1.40761,
        1.57080, 1.29401,
        1.57080, 1.84758,
        1.30114, 1.73398,
        2.43472, 2.01012,
        2.36212, 1.73212,
        2.51520, 2.32979,
        2.60192, 2.61132,
        1.79572, 2.33752,
        2.12437, 2.19911,
        1.86341, 2.01960,
        2.43472, 1.13147,
        2.36212, 1.40948,
        2.51520, 0.81180,
        2.60192, 0.53027,
        1.79572, 0.80407,
        2.12437, 0.94248,
        1.86341, 1.12199,
        2.12437, 1.57080,
        1.84046, 1.40761,
        1.84046, 1.73398,
        0.00000, 0.27679,
        1.01722, 0.31416,
        -3.14159, 0.27679,
        2.12437, 0.31416,
        1.57080, 0.55357,
        -1.01722, 0.31416,
        -2.12437, 0.31416,
        -1.57080, 0.55357,
        0.41518, 1.57080,
        0.36974, 1.43876,
        0.51056, 1.43922,
        0.13839, 1.57080,
        0.22395, 1.43761,
        0.08308, 1.43733,
        0.26173, 1.17430,
        0.31766, 1.30354,
        0.41819, 1.17709,
        -0.41518, 1.57080,
        -0.36974, 1.43876,
        -0.51056, 1.43922,
        -0.13839, 1.57080,
        -0.22395, 1.43761,
        -0.08308, 1.43733,
        -0.26173, 1.17430,
        -0.31766, 1.30354,
        -0.41819, 1.17709,
        -0.13096, 0.66997,
        0.00000, 0.77948,
        0.13096, 0.66997,
        -0.30289, 0.91874,
        -0.10363, 0.90175,
        -0.18408, 1.02481,
        0.18408, 1.02481,
        0.10363, 0.90175,
        0.30289, 0.91874,
        0.00000, 1.30114,
        -0.08993, 1.15971,
        0.08993, 1.15971,
        0.36974, 1.70284,
        0.51056, 1.70238,
        0.22395, 1.70398,
        0.08308, 1.70426,
        0.26173, 1.96729,
        0.31766, 1.83805,
        0.41819, 1.96450,
        -0.36974, 1.70284,
        -0.51056, 1.70238,
        -0.22395, 1.70398,
        -0.08308, 1.70426,
        -0.26173, 1.96729,
        -0.31766, 1.83805,
        -0.41819, 1.96450,
        -0.13096, 2.47163,
        0.00000, 2.36212,
        0.13096, 2.47163,
        -0.30289, 2.22286,
        -0.10363, 2.23984,
        -0.18408, 2.11678,
        0.18408, 2.11678,
        0.10363, 2.23984,
        0.30289, 2.22286,
        0.00000, 1.84046,
        -0.08993, 1.98188,
        0.08993, 1.98188,
        0.62448, 1.35613,
        0.66578, 1.48962,
        0.58252, 1.21733,
        0.53967, 1.08328,
        0.86592, 1.18991,
        0.74475, 1.27029,
        0.89613, 1.33143,
        0.35693, 0.65565,
        0.26448, 0.52579,
        0.42884, 0.79216,
        0.48402, 0.92542,
        0.80105, 0.71065,
        0.59078, 0.67060,
        0.79670, 0.56626,
        1.46772, 0.90760,
        1.30825, 0.96277,
        1.42025, 1.06507,
        1.19833, 0.70955,
        1.17192, 0.86661,
        1.01722, 0.78540,
        1.01722, 1.09956,
        1.15476, 1.02848,
        1.14415, 1.18636,
        0.67106, 0.97127,
        0.83258, 0.86771,
        0.85328, 1.03168,
        0.62448, 1.78546,
        0.66578, 1.65197,
        0.58252, 1.92426,
        0.53967, 2.05831,
        0.86592, 1.95169,
        0.74475, 1.87130,
        0.89613, 1.81016,
        0.35693, 2.48594,
        0.26448, 2.61581,
        0.42884, 2.34943,
        0.48402, 2.21617,
        0.80105, 2.43094,
        0.59078, 2.47100,
        0.79670, 2.57533,
        1.46772, 2.23400,
        1.30825, 2.17883,
        1.42025, 2.07652,
        1.19833, 2.43204,
        1.17192, 2.27498,
        1.01722, 2.35619,
        1.01722, 2.04204,
        1.15476, 2.11311,
        1.14415, 1.95523,
        0.67106, 2.17033,
        0.83258, 2.27389,
        0.85328, 2.10991,
        0.77948, 1.57080,
        0.89913, 1.48957,
        1.01722, 1.41372,
        1.01722, 1.72788,
        0.89913, 1.65203,
        1.42931, 1.20443,
        1.57080, 1.15562,
        1.29018, 1.26478,
        1.16181, 1.32979,
        1.43687, 1.48846,
        1.43424, 1.34886,
        1.57080, 1.43240,
        1.57080, 1.98598,
        1.42931, 1.93717,
        1.57080, 1.70919,
        1.43424, 1.79273,
        1.43687, 1.65313,
        1.16181, 1.81180,
        1.29018, 1.87681,
        1.15822, 1.48838,
        1.30114, 1.57080,
        1.15822, 1.65321,
        2.51712, 1.78546,
        2.47581, 1.65197,
        2.55907, 1.92426,
        2.60192, 2.05831,
        2.27567, 1.95169,
        2.39685, 1.87130,
        2.24546, 1.81016,
        2.78466, 2.48594,
        2.87711, 2.61581,
        2.71276, 2.34943,
        2.65757, 2.21617,
        2.34054, 2.43094,
        2.55082, 2.47100,
        2.34489, 2.57533,
        1.67388, 2.23400,
        1.83334, 2.17883,
        1.72134, 2.07652,
        1.94326, 2.43204,
        1.96968, 2.27498,
        2.12437, 2.35619,
        2.12437, 2.04204,
        1.98684, 2.11311,
        1.99744, 1.95523,
        2.47053, 2.17033,
        2.30902, 2.27389,
        2.28831, 2.10991,
        2.51712, 1.35613,
        2.47581, 1.48962,
        2.55907, 1.21733,
        2.60192, 1.08328,
        2.27567, 1.18991,
        2.39685, 1.27029,
        2.24546, 1.33143,
        2.78466, 0.65565,
        2.87711, 0.52579,
        2.71276, 0.79216,
        2.65757, 0.92542,
        2.34054, 0.71065,
        2.55082, 0.67060,
        2.34489, 0.56626,
        1.67388, 0.90760,
        1.83334, 0.96277,
        1.72134, 1.06507,
        1.94326, 0.70955,
        1.96968, 0.86661,
        2.12437, 0.78540,
        2.12437, 1.09956,
        1.98684, 1.02848,
        1.99744, 1.18636,
        2.47053, 0.97127,
        2.30902, 0.86771,
        2.28831, 1.03168,
        2.36212, 1.57080,
        2.24246, 1.48957,
        2.12437, 1.41372,
        2.12437, 1.72788,
        2.24246, 1.65203,
        1.71228, 1.20443,
        1.85141, 1.26478,
        1.97978, 1.32979,
        1.70472, 1.48846,
        1.70735, 1.34886,
        1.71228, 1.93717,
        1.70735, 1.79273,
        1.70472, 1.65313,
        1.97978, 1.81180,
        1.85141, 1.87681,
        1.98337, 1.48838,
        1.84046, 1.57080,
        1.98337, 1.65321,
        0.00000, 0.41518,
        0.35219, 0.39159,
        0.00000, 0.13839,
        0.54283, 0.25999,
        1.01722, 0.15708,
        1.01722, 0.47124,
        0.71973, 0.41219,
        -3.14159, 0.41518,
        2.78940, 0.39159,
        -3.14159, 0.13839,
        2.59876, 0.25999,
        2.12437, 0.15708,
        2.12437, 0.47124,
        2.42186, 0.41219,
        1.57080, 0.79132,
        1.70088, 0.67580,
        1.86341, 0.57319,
        1.27818, 0.57319,
        1.44071, 0.67580,
        1.57080, 0.26966,
        1.77397, 0.42026,
        1.36763, 0.42026,
        -0.35219, 0.39159,
        -0.54283, 0.25999,
        -1.01722, 0.15708,
        -1.01722, 0.47124,
        -0.71973, 0.41219,
        -2.78940, 0.39159,
        -2.59876, 0.25999,
        -2.12437, 0.15708,
        -2.12437, 0.47124,
        -2.42186, 0.41219,
        -1.57080, 0.79132,
        -1.70088, 0.67580,
        -1.86341, 0.57319,
        -1.27818, 0.57319,
        -1.44071, 0.67580,
        -1.57080, 0.26966,
        -1.77397, 0.42026,
        -1.36763, 0.42026,
        0.48438, 1.57080,
        0.46266, 1.50493,
        0.53216, 1.50499,
        0.34598, 1.57080,
        0.39256, 1.50476,
        0.32306, 1.50471,
        0.41725, 1.37310,
        0.44015, 1.43866,
        0.48858, 1.37350,
        0.06920, 1.57080,
        0.11086, 1.50404,
        0.04135, 1.50401,
        0.20759, 1.57080,
        0.18098, 1.50414,
        0.25049, 1.50418,
        0.19694, 1.37113,
        0.15351, 1.43714,
        0.12555, 1.37089,
        0.31167, 1.11022,
        0.34001, 1.17461,
        0.39238, 1.11200,
        0.21442, 1.23922,
        0.29032, 1.23880,
        0.24341, 1.30347,
        0.39188, 1.30502,
        0.36683, 1.23993,
        0.44264, 1.24240,
        0.29685, 1.43784,
        0.27017, 1.37036,
        0.34406, 1.37108,
        -0.48438, 1.57080,
        -0.46266, 1.50493,
        -0.53216, 1.50499,
        -0.34598, 1.57080,
        -0.39256, 1.50476,
        -0.32306, 1.50471,
        -0.41725, 1.37310,
        -0.44015, 1.43866,
        -0.48858, 1.37350,
        -0.06920, 1.57080,
        -0.11086, 1.50404,
        -0.04135, 1.50401,
        -0.20759, 1.57080,
        -0.18098, 1.50414,
        -0.25049, 1.50418,
        -0.19694, 1.37113,
        -0.15351, 1.43714,
        -0.12555, 1.37089,
        -0.31167, 1.11022,
        -0.34001, 1.17461,
        -0.39238, 1.11200,
        -0.21442, 1.23922,
        -0.29032, 1.23880,
        -0.24341, 1.30347,
        -0.39188, 1.30502,
        -0.36683, 1.23993,
        -0.44264, 1.24240,
        -0.29685, 1.43784,
        -0.27017, 1.37036,
        -0.34406, 1.37108,
        -0.07092, 0.61077,
        0.00000, 0.66578,
        0.07092, 0.61077,
        -0.18254, 0.73067,
        -0.06142, 0.72366,
        -0.11450, 0.78276,
        0.11450, 0.78276,
        0.06142, 0.72366,
        0.18254, 0.73067,
        -0.33521, 0.98275,
        -0.24133, 0.97095,
        -0.27507, 1.03421,
        -0.26727, 0.85528,
        -0.20392, 0.90783,
        -0.16257, 0.84619,
        -0.04971, 0.95885,
        -0.14558, 0.96290,
        -0.09226, 1.01913,
        0.27507, 1.03421,
        0.24133, 0.97095,
        0.33521, 0.98275,
        0.09226, 1.01913,
        0.14558, 0.96290,
        0.04971, 0.95885,
        0.16257, 0.84619,
        0.20392, 0.90783,
        0.26727, 0.85528,
        -0.05466, 0.83995,
        0.00000, 0.89913,
        0.05466, 0.83995,
        0.00000, 1.43687,
        -0.04212, 1.36906,
        -0.08464, 1.30205,
        0.08464, 1.30205,
        0.04212, 1.36906,
        -0.22439, 1.09925,
        -0.17610, 1.16567,
        -0.13057, 1.23201,
        -0.04664, 1.08805,
        -0.13535, 1.09181,
        0.22439, 1.09925,
        0.13535, 1.09181,
        0.04664, 1.08805,
        0.13057, 1.23201,
        0.17610, 1.16567,
        -0.04383, 1.23010,
        0.00000, 1.15822,
        0.04383, 1.23010,
        0.46266, 1.63666,
        0.53216, 1.63660,
        0.39256, 1.63683,
        0.32306, 1.63689,
        0.41725, 1.76849,
        0.44015, 1.70293,
        0.48858, 1.76809,
        0.11086, 1.63756,
        0.04135, 1.63759,
        0.18098, 1.63745,
        0.25049, 1.63741,
        0.19694, 1.77046,
        0.15351, 1.70445,
        0.12555, 1.77071,
        0.31167, 2.03137,
        0.34001, 1.96699,
        0.39238, 2.02959,
        0.21442, 1.90237,
        0.29032, 1.90279,
        0.24341, 1.83812,
        0.39188, 1.83657,
        0.36683, 1.90166,
        0.44264, 1.89919,
        0.29685, 1.70376,
        0.27017, 1.77123,
        0.34406, 1.77051,
        -0.46266, 1.63666,
        -0.53216, 1.63660,
        -0.39256, 1.63683,
        -0.32306, 1.63689,
        -0.41725, 1.76849,
        -0.44015, 1.70293,
        -0.48858, 1.76809,
        -0.11086, 1.63756,
        -0.04135, 1.63759,
        -0.18098, 1.63745,
        -0.25049, 1.63741,
        -0.19694, 1.77046,
        -0.15351, 1.70445,
        -0.12555, 1.77071,
        -0.31167, 2.03137,
        -0.34001, 1.96699,
        -0.39238, 2.02959,
        -0.21442, 1.90237,
        -0.29032, 1.90279,
        -0.24341, 1.83812,
        -0.39188, 1.83657,
        -0.36683, 1.90166,
        -0.44264, 1.89919,
        -0.29685, 1.70376,
        -0.27017, 1.77123,
        -0.34406, 1.77051,
        -0.07092, 2.53082,
        0.00000, 2.47581,
        0.07092, 2.53082,
        -0.18254, 2.41092,
        -0.06142, 2.41793,
        -0.11450, 2.35883,
        0.11450, 2.35883,
        0.06142, 2.41793,
        0.18254, 2.41092,
        -0.33521, 2.15885,
        -0.24133, 2.17064,
        -0.27507, 2.10738,
        -0.26727, 2.28631,
        -0.20392, 2.23376,
        -0.16257, 2.29540,
        -0.04971, 2.18274,
        -0.14558, 2.17869,
        -0.09226, 2.12247,
        0.27507, 2.10738,
        0.24133, 2.17064,
        0.33521, 2.15885,
        0.09226, 2.12247,
        0.14558, 2.17869,
        0.04971, 2.18274,
        0.16257, 2.29540,
        0.20392, 2.23376,
        0.26727, 2.28631,
        -0.05466, 2.30165,
        0.00000, 2.24246,
        0.05466, 2.30165,
        0.00000, 1.70472,
        -0.04212, 1.77253,
        -0.08464, 1.83954,
        0.08464, 1.83954,
        0.04212, 1.77253,
        -0.22439, 2.04234,
        -0.17610, 1.97592,
        -0.13057, 1.90958,
        -0.04664, 2.05354,
        -0.13535, 2.04978,
        0.22439, 2.04234,
        0.13535, 2.04978,
        0.04664, 2.05354,
        0.13057, 1.90958,
        0.17610, 1.97592,
        -0.04383, 1.91149,
        0.00000, 1.98337,
        0.04383, 1.91149,
        0.58838, 1.46410,
        0.60959, 1.53014,
        0.56710, 1.39740,
        0.54571, 1.33128,
        0.70237, 1.38225,
        0.64534, 1.42284,
        0.72235, 1.44935,
        0.47759, 1.12947,
        0.45314, 1.06362,
        0.50101, 1.19606,
        0.52343, 1.26212,
        0.64358, 1.17371,
        0.56174, 1.15022,
        0.62428, 1.10598,
        0.94249, 1.22235,
        0.88137, 1.26063,
        0.95603, 1.29355,
        0.78741, 1.15953,
        0.80447, 1.22952,
        0.72632, 1.20082,
        0.76240, 1.33985,
        0.82108, 1.30012,
        0.83734, 1.37012,
        0.60392, 1.28667,
        0.66436, 1.24281,
        0.68393, 1.31276,
        0.19063, 0.59685,
        0.12916, 0.53582,
        0.24290, 0.65971,
        0.28720, 0.72306,
        0.43977, 0.59105,
        0.31519, 0.59023,
        0.40261, 0.52391,
        0.39369, 0.92010,
        0.42204, 0.98549,
        0.36239, 0.85447,
        0.32815, 0.78981,
        0.52856, 0.79954,
        0.45802, 0.85860,
        0.55178, 0.86736,
        0.90349, 0.66665,
        0.79909, 0.63846,
        0.91201, 0.59447,
        0.70907, 0.75933,
        0.69847, 0.68791,
        0.60996, 0.74112,
        0.56785, 0.60028,
        0.68616, 0.61594,
        0.67199, 0.54460,
        0.39567, 0.72359,
        0.50430, 0.72975,
        0.47498, 0.65980,
        1.52123, 0.96179,
        1.44275, 0.98620,
        1.49447, 1.03991,
        1.40954, 0.85492,
        1.38636, 0.93366,
        1.32584, 0.88333,
        1.29252, 1.04233,
        1.36604, 1.01322,
        1.34817, 1.09250,
        1.11245, 0.66695,
        1.10406, 0.74543,
        1.01722, 0.70686,
        1.27581, 0.75546,
        1.18409, 0.78804,
        1.25643, 0.83346,
        1.09226, 0.90309,
        1.09747, 0.82452,
        1.01722, 0.86394,
        1.01722, 1.17810,
        1.08195, 1.14220,
        1.07987, 1.22085,
        1.01722, 1.02102,
        1.08463, 1.06301,
        1.08795, 0.98439,
        1.21803, 1.07444,
        1.14924, 1.10741,
        1.21021, 1.15334,
        1.24261, 0.91357,
        1.16284, 0.94753,
        1.22987, 0.99428,
        0.51325, 1.00418,
        0.57909, 0.94627,
        0.65017, 0.89141,
        0.68979, 1.05130,
        0.60314, 1.02632,
        0.91351, 0.74511,
        0.81804, 0.78912,
        0.73208, 0.83711,
        0.92762, 0.90302,
        0.92139, 0.82443,
        0.94002, 1.14365,
        0.93679, 1.06419,
        0.93283, 0.98553,
        0.77813, 1.08047,
        0.85985, 1.11079,
        0.74862, 0.91791,
        0.84354, 0.94967,
        0.76394, 0.99959,
        0.58838, 1.67749,
        0.60959, 1.61145,
        0.56710, 1.74420,
        0.54571, 1.81031,
        0.70237, 1.75934,
        0.64534, 1.71875,
        0.72235, 1.69224,
        0.47759, 2.01212,
        0.45314, 2.07797,
        0.50101, 1.94553,
        0.52343, 1.87948,
        0.64358, 1.96788,
        0.56174, 1.99137,
        0.62428, 2.03561,
        0.94249, 1.91924,
        0.88137, 1.88096,
        0.95603, 1.84804,
        0.78741, 1.98206,
        0.80447, 1.91207,
        0.72632, 1.94077,
        0.76240, 1.80174,
        0.82108, 1.84147,
        0.83734, 1.77147,
        0.60392, 1.85492,
        0.66436, 1.89879,
        0.68393, 1.82883,
        0.19063, 2.54474,
        0.12916, 2.60577,
        0.24290, 2.48188,
        0.28720, 2.41853,
        0.43977, 2.55055,
        0.31519, 2.55136,
        0.40261, 2.61769,
        0.39369, 2.22149,
        0.42204, 2.15610,
        0.36239, 2.28712,
        0.32815, 2.35179,
        0.52856, 2.34205,
        0.45802, 2.28299,
        0.55178, 2.27423,
        0.90349, 2.47494,
        0.79909, 2.50313,
        0.91201, 2.54713,
        0.70907, 2.38227,
        0.69847, 2.45368,
        0.60996, 2.40047,
        0.56785, 2.54131,
        0.68616, 2.52566,
        0.67199, 2.59700,
        0.39567, 2.41800,
        0.50430, 2.41184,
        0.47498, 2.48179,
        1.52123, 2.17981,
        1.44275, 2.15539,
        1.49447, 2.10168,
        1.40954, 2.28668,
        1.38636, 2.20793,
        1.32584, 2.25826,
        1.29252, 2.09926,
        1.36604, 2.12838,
        1.34817, 2.04909,
        1.11245, 2.47465,
        1.10406, 2.39616,
        1.01722, 2.43473,
        1.27581, 2.38614,
        1.18409, 2.35355,
        1.25643, 2.30813,
        1.09226, 2.23850,
        1.09747, 2.31708,
        1.01722, 2.27765,
        1.01722, 1.96350,
        1.08195, 1.99940,
        1.07987, 1.92074,
        1.01722, 2.12057,
        1.08463, 2.07858,
        1.08795, 2.15720,
        1.21803, 2.06715,
        1.14924, 2.03418,
        1.21021, 1.98825,
        1.24261, 2.22803,
        1.16284, 2.19406,
        1.22987, 2.14732,
        0.51325, 2.13742,
        0.57909, 2.19533,
        0.65017, 2.25018,
        0.68979, 2.09029,
        0.60314, 2.11527,
        0.91351, 2.39648,
        0.81804, 2.35247,
        0.73208, 2.30448,
        0.92762, 2.23857,
        0.92139, 2.31716,
        0.94002, 1.99794,
        0.93679, 2.07740,
        0.93283, 2.15606,
        0.77813, 2.06113,
        0.85985, 2.03081,
        0.74862, 2.22368,
        0.84354, 2.19192,
        0.76394, 2.14201,
        0.66578, 1.57080,
        0.72272, 1.53014,
        0.77948, 1.49014,
        0.77948, 1.65146,
        0.72272, 1.61145,
        0.95718, 1.37222,
        1.01722, 1.33518,
        0.89765, 1.41050,
        0.83960, 1.44931,
        0.95827, 1.53011,
        0.95791, 1.45143,
        1.01722, 1.49226,
        1.01722, 1.80642,
        0.95718, 1.76937,
        1.01722, 1.64934,
        0.95791, 1.69016,
        0.95827, 1.61148,
        0.83960, 1.69229,
        0.89765, 1.73109,
        0.83920, 1.53011,
        0.89913, 1.57080,
        0.83920, 1.61148,
        1.49722, 1.10921,
        1.57080, 1.08642,
        1.42493, 1.13475,
        1.35509, 1.16217,
        1.50111, 1.24847,
        1.49934, 1.17914,
        1.57080, 1.22481,
        1.15319, 1.25806,
        1.09027, 1.29253,
        1.21820, 1.22472,
        1.28435, 1.19338,
        1.29575, 1.33620,
        1.22541, 1.29675,
        1.23203, 1.36823,
        1.50395, 1.52954,
        1.50363, 1.46019,
        1.57080, 1.50160,
        1.36934, 1.44776,
        1.43557, 1.41866,
        1.36731, 1.37782,
        1.50204, 1.32088,
        1.50304, 1.39022,
        1.57080, 1.36321,
        1.35901, 1.23385,
        1.36303, 1.30617,
        1.43183, 1.27664,
        1.57080, 2.05517,
        1.49722, 2.03238,
        1.57080, 1.91678,
        1.49934, 1.96245,
        1.50111, 1.89313,
        1.35509, 1.97942,
        1.42493, 2.00685,
        1.57080, 1.63999,
        1.50363, 1.68141,
        1.50395, 1.61206,
        1.57080, 1.77839,
        1.50304, 1.75137,
        1.50204, 1.82072,
        1.36731, 1.76377,
        1.43557, 1.72293,
        1.36934, 1.69384,
        1.09027, 1.84907,
        1.15319, 1.88353,
        1.23203, 1.77337,
        1.22541, 1.84484,
        1.29575, 1.80540,
        1.28435, 1.94821,
        1.21820, 1.91687,
        1.43183, 1.86495,
        1.36303, 1.83542,
        1.35901, 1.90774,
        1.08890, 1.37125,
        1.15999, 1.40909,
        1.22932, 1.44769,
        1.08760, 1.52949,
        1.08804, 1.45075,
        1.43687, 1.57080,
        1.36889, 1.52953,
        1.30114, 1.48920,
        1.30114, 1.65239,
        1.36889, 1.61206,
        1.08890, 1.77035,
        1.15999, 1.73251,
        1.22932, 1.69391,
        1.08760, 1.61211,
        1.08804, 1.69084,
        1.22980, 1.52948,
        1.22980, 1.61211,
        1.15822, 1.57080,
        2.55321, 1.67749,
        2.53201, 1.61145,
        2.57449, 1.74420,
        2.59588, 1.81031,
        2.43922, 1.75934,
        2.49626, 1.71875,
        2.41924, 1.69224,
        2.66401, 2.01212,
        2.68845, 2.07797,
        2.64059, 1.94553,
        2.61817, 1.87948,
        2.49802, 1.96788,
        2.57985, 1.99137,
        2.51731, 2.03561,
        2.19910, 1.91924,
        2.26022, 1.88096,
        2.18556, 1.84804,
        2.35418, 1.98206,
        2.33712, 1.91207,
        2.41527, 1.94077,
        2.37920, 1.80174,
        2.32051, 1.84147,
        2.30425, 1.77147,
        2.53767, 1.85492,
        2.47723, 1.89879,
        2.45766, 1.82883,
        2.95096, 2.54474,
        3.01244, 2.60577,
        2.89869, 2.48188,
        2.85439, 2.41853,
        2.70183, 2.55055,
        2.82640, 2.55136,
        2.73898, 2.61769,
        2.74791, 2.22149,
        2.71956, 2.15610,
        2.77920, 2.28712,
        2.81344, 2.35179,
        2.61304, 2.34205,
        2.68358, 2.28299,
        2.58982, 2.27423,
        2.23810, 2.47494,
        2.34250, 2.50313,
        2.22958, 2.54713,
        2.43252, 2.38227,
        2.44312, 2.45368,
        2.53163, 2.40047,
        2.57375, 2.54131,
        2.45544, 2.52566,
        2.46960, 2.59700,
        2.74593, 2.41800,
        2.63729, 2.41184,
        2.66661, 2.48179,
        1.62037, 2.17981,
        1.69885, 2.15539,
        1.64712, 2.10168,
        1.73205, 2.28668,
        1.75524, 2.20793,
        1.81576, 2.25826,
        1.84908, 2.09926,
        1.77555, 2.12838,
        1.79342, 2.04909,
        2.02915, 2.47465,
        2.03753, 2.39616,
        2.12437, 2.43473,
        1.86579, 2.38614,
        1.95750, 2.35355,
        1.88516, 2.30813,
        2.04934, 2.23850,
        2.04412, 2.31708,
        2.12437, 2.27765,
        2.12437, 1.96350,
        2.05965, 1.99940,
        2.06172, 1.92074,
        2.12437, 2.12057,
        2.05696, 2.07858,
        2.05364, 2.15720,
        1.92356, 2.06715,
        1.99235, 2.03418,
        1.93138, 1.98825,
        1.89898, 2.22803,
        1.97876, 2.19406,
        1.91173, 2.14732,
        2.62835, 2.13742,
        2.56251, 2.19533,
        2.49142, 2.25018,
        2.45180, 2.09029,
        2.53845, 2.11527,
        2.22808, 2.39648,
        2.32355, 2.35247,
        2.40951, 2.30448,
        2.21397, 2.23857,
        2.22020, 2.31716,
        2.20157, 1.99794,
        2.20480, 2.07740,
        2.20876, 2.15606,
        2.36347, 2.06113,
        2.28174, 2.03081,
        2.39297, 2.22368,
        2.29805, 2.19192,
        2.37765, 2.14201,
        2.55321, 1.46410,
        2.53201, 1.53014,
        2.57449, 1.39740,
        2.59588, 1.33128,
        2.43922, 1.38225,
        2.49626, 1.42284,
        2.41924, 1.44935,
        2.66401, 1.12947,
        2.68845, 1.06362,
        2.64059, 1.19606,
        2.61817, 1.26212,
        2.49802, 1.17371,
        2.57985, 1.15022,
        2.51731, 1.10598,
        2.19910, 1.22235,
        2.26022, 1.26063,
        2.18556, 1.29355,
        2.35418, 1.15953,
        2.33712, 1.22952,
        2.41527, 1.20082,
        2.37920, 1.33985,
        2.32051, 1.30012,
        2.30425, 1.37012,
        2.53767, 1.28667,
        2.47723, 1.24281,
        2.45766, 1.31276,
        2.95096, 0.59685,
        3.01244, 0.53582,
        2.89869, 0.65971,
        2.85439, 0.72306,
        2.70183, 0.59105,
        2.82640, 0.59023,
        2.73898, 0.52391,
        2.74791, 0.92010,
        2.71956, 0.98549,
        2.77920, 0.85447,
        2.81344, 0.78981,
        2.61304, 0.79954,
        2.68358, 0.85860,
        2.58982, 0.86736,
        2.23810, 0.66665,
        2.34250, 0.63846,
        2.22958, 0.59447,
        2.43252, 0.75933,
        2.44312, 0.68791,
        2.53163, 0.74112,
        2.57375, 0.60028,
        2.45544, 0.61594,
        2.46960, 0.54460,
        2.74593, 0.72359,
        2.63729, 0.72975,
        2.66661, 0.65980,
        1.62037, 0.96179,
        1.69885, 0.98620,
        1.64712, 1.03991,
        1.73205, 0.85492,
        1.75524, 0.93366,
        1.81576, 0.88333,
        1.84908, 1.04233,
        1.77555, 1.01322,
        1.79342, 1.09250,
        2.02915, 0.66695,
        2.03753, 0.74543,
        2.12437, 0.70686,
        1.86579, 0.75546,
        1.95750, 0.78804,
        1.88516, 0.83346,
        2.04934, 0.90309,
        2.04412, 0.82452,
        2.12437, 0.86394,
        2.12437, 1.17810,
        2.05965, 1.14220,
        2.06172, 1.22085,
        2.12437, 1.02102,
        2.05696, 1.06301,
        2.05364, 0.98439,
        1.92356, 1.07444,
        1.99235, 1.10741,
        1.93138, 1.15334,
        1.89898, 0.91357,
        1.97876, 0.94753,
        1.91173, 0.99428,
        2.62835, 1.00418,
        2.56251, 0.94627,
        2.49142, 0.89141,
        2.45180, 1.05130,
        2.53845, 1.02632,
        2.22808, 0.74511,
        2.32355, 0.78912,
        2.40951, 0.83711,
        2.21397, 0.90302,
        2.22020, 0.82443,
        2.20157, 1.14365,
        2.20480, 1.06419,
        2.20876, 0.98553,
        2.36347, 1.08047,
        2.28174, 1.11079,
        2.39297, 0.91791,
        2.29805, 0.94967,
        2.37765, 0.99959,
        2.47581, 1.57080,
        2.41887, 1.53014,
        2.36212, 1.49014,
        2.36212, 1.65146,
        2.41887, 1.61145,
        2.18441, 1.37222,
        2.12437, 1.33518,
        2.24394, 1.41050,
        2.30200, 1.44931,
        2.18332, 1.53011,
        2.18369, 1.45143,
        2.12437, 1.49226,
        2.12437, 1.80642,
        2.18441, 1.76937,
        2.12437, 1.64934,
        2.18369, 1.69016,
        2.18332, 1.61148,
        2.30200, 1.69229,
        2.24394, 1.73109,
        2.30239, 1.53011,
        2.24246, 1.57080,
        2.30239, 1.61148,
        1.64437, 1.10921,
        1.71666, 1.13475,
        1.78650, 1.16217,
        1.64048, 1.24847,
        1.64225, 1.17914,
        1.98841, 1.25806,
        2.05132, 1.29253,
        1.92340, 1.22472,
        1.85724, 1.19338,
        1.84584, 1.33620,
        1.91619, 1.29675,
        1.90956, 1.36823,
        1.63764, 1.52954,
        1.63797, 1.46019,
        1.77225, 1.44776,
        1.70602, 1.41866,
        1.77429, 1.37782,
        1.63955, 1.32088,
        1.63855, 1.39022,
        1.78258, 1.23385,
        1.77856, 1.30617,
        1.70976, 1.27664,
        1.64437, 2.03238,
        1.64225, 1.96245,
        1.64048, 1.89313,
        1.78650, 1.97942,
        1.71666, 2.00685,
        1.63797, 1.68141,
        1.63764, 1.61206,
        1.63855, 1.75137,
        1.63955, 1.82072,
        1.77429, 1.76377,
        1.70602, 1.72293,
        1.77225, 1.69384,
        2.05132, 1.84907,
        1.98841, 1.88353,
        1.90956, 1.77337,
        1.91619, 1.84484,
        1.84584, 1.80540,
        1.85724, 1.94821,
        1.92340, 1.91687,
        1.70976, 1.86495,
        1.77856, 1.83542,
        1.78258, 1.90774,
        2.05269, 1.37125,
        1.98160, 1.40909,
        1.91227, 1.44769,
        2.05399, 1.52949,
        2.05355, 1.45075,
        1.70472, 1.57080,
        1.77270, 1.52953,
        1.84046, 1.48920,
        1.84046, 1.65239,
        1.77270, 1.61206,
        2.05269, 1.77035,
        1.98160, 1.73251,
        1.91227, 1.69391,
        2.05399, 1.61211,
        2.05355, 1.69084,
        1.91179, 1.52948,
        1.91179, 1.61211,
        1.98337, 1.57080,
        0.00000, 0.48438,
        0.14672, 0.46699,
        0.00000, 0.34598,
        0.17118, 0.39779,
        0.20554, 0.32952,
        0.45908, 0.45921,
        0.30237, 0.45831,
        0.00000, 0.06920,
        0.54360, 0.12934,
        1.01722, 0.07854,
        0.00000, 0.20759,
        0.35513, 0.19274,
        0.26292, 0.25901,
        0.80221, 0.27952,
        0.72126, 0.20320,
        1.01722, 0.23562,
        1.01722, 0.54978,
        0.89774, 0.51615,
        1.01722, 0.39270,
        0.87784, 0.43746,
        0.84914, 0.35957,
        0.61923, 0.46962,
        0.76380, 0.48893,
        0.42887, 0.32446,
        0.65064, 0.33493,
        0.54047, 0.39582,
        -3.14159, 0.48438,
        2.99487, 0.46699,
        -3.14159, 0.34598,
        2.97041, 0.39779,
        2.93605, 0.32952,
        2.68251, 0.45921,
        2.83923, 0.45831,
        -3.14159, 0.06920,
        2.59799, 0.12934,
        2.12437, 0.07854,
        -3.14159, 0.20759,
        2.78646, 0.19274,
        2.87868, 0.25901,
        2.33939, 0.27952,
        2.42033, 0.20320,
        2.12437, 0.23562,
        2.12437, 0.54978,
        2.24385, 0.51615,
        2.12437, 0.39270,
        2.26376, 0.43746,
        2.29246, 0.35957,
        2.52236, 0.46962,
        2.37779, 0.48893,
        2.71273, 0.32446,
        2.49096, 0.33493,
        2.60112, 0.39582,
        1.57080, 0.90501,
        1.62498, 0.84880,
        1.68396, 0.79453,
        1.45763, 0.79453,
        1.51662, 0.84880,
        1.90699, 0.64099,
        1.99917, 0.59678,
        1.82455, 0.68907,
        1.75164, 0.73938,
        1.64148, 0.61370,
        1.77634, 0.62294,
        1.71939, 0.55854,
        1.14242, 0.59678,
        1.23460, 0.64099,
        1.42220, 0.55854,
        1.36525, 0.62294,
        1.50011, 0.61370,
        1.38996, 0.73938,
        1.31705, 0.68907,
        1.63166, 0.73251,
        1.57080, 0.67167,
        1.50993, 0.73251,
        1.57080, 0.13392,
        1.77384, 0.20602,
        1.86862, 0.28145,
        1.27298, 0.28145,
        1.36776, 0.20602,
        1.98226, 0.51856,
        1.95861, 0.43979,
        1.92474, 0.36217,
        1.65953, 0.48482,
        1.82501, 0.49631,
        1.15933, 0.51856,
        1.31658, 0.49631,
        1.48206, 0.48482,
        1.21686, 0.36217,
        1.18298, 0.43979,
        1.69378, 0.34339,
        1.57080, 0.41257,
        1.44781, 0.34339,
        -0.14672, 0.46699,
        -0.17118, 0.39779,
        -0.20554, 0.32952,
        -0.45908, 0.45921,
        -0.30237, 0.45831,
        -0.54360, 0.12934,
        -1.01722, 0.07854,
        -0.35513, 0.19274,
        -0.26292, 0.25901,
        -0.80221, 0.27952,
        -0.72126, 0.20320,
        -1.01722, 0.23562,
        -1.01722, 0.54978,
        -0.89774, 0.51615,
        -1.01722, 0.39270,
        -0.87784, 0.43746,
        -0.84914, 0.35957,
        -0.61923, 0.46962,
        -0.76380, 0.48893,
        -0.42887, 0.32446,
        -0.65064, 0.33493,
        -0.54047, 0.39582,
        -2.99487, 0.46699,
        -2.97041, 0.39779,
        -2.93605, 0.32952,
        -2.68251, 0.45921,
        -2.83923, 0.45831,
        -2.59799, 0.12934,
        -2.12437, 0.07854,
        -2.78646, 0.19274,
        -2.87868, 0.25901,
        -2.33939, 0.27952,
        -2.42033, 0.20320,
        -2.12437, 0.23562,
        -2.12437, 0.54978,
        -2.24385, 0.51615,
        -2.12437, 0.39270,
        -2.26376, 0.43746,
        -2.29246, 0.35957,
        -2.52236, 0.46962,
        -2.37779, 0.48893,
        -2.71273, 0.32446,
        -2.49096, 0.33493,
        -2.60112, 0.39582,
        -1.57080, 0.90501,
        -1.62498, 0.84880,
        -1.68396, 0.79453,
        -1.45763, 0.79453,
        -1.51662, 0.84880,
        -1.90699, 0.64099,
        -1.99917, 0.59678,
        -1.82455, 0.68907,
        -1.75164, 0.73938,
        -1.64148, 0.61370,
        -1.77634, 0.62294,
        -1.71939, 0.55854,
        -1.14242, 0.59678,
        -1.23460, 0.64099,
        -1.42220, 0.55854,
        -1.36525, 0.62294,
        -1.50011, 0.61370,
        -1.38996, 0.73938,
        -1.31705, 0.68907,
        -1.63166, 0.73251,
        -1.57080, 0.67167,
        -1.50993, 0.73251,
        -1.57080, 0.13392,
        -1.77384, 0.20602,
        -1.86862, 0.28145,
        -1.27298, 0.28145,
        -1.36776, 0.20602,
        -1.98226, 0.51856,
        -1.95861, 0.43979,
        -1.92474, 0.36217,
        -1.65953, 0.48482,
        -1.82501, 0.49631,
        -1.15933, 0.51856,
        -1.31658, 0.49631,
        -1.48206, 0.48482,
        -1.21686, 0.36217,
        -1.18298, 0.43979,
        -1.69378, 0.34339,
        -1.57080, 0.41257,
        -1.44781, 0.34339,
      };




    }
  }
}

