"use strict";

var helpers = require("../../helpers/helpers");

exports["US/East-Indiana"] = {

	"guess:by:offset" : helpers.makeTestGuess("US/East-Indiana", { offset: true, expect: "America/New_York" }),

	"guess:by:abbr" : helpers.makeTestGuess("US/East-Indiana", { abbr: true, expect: "America/New_York" }),

	"1883" : helpers.makeTestYear("US/East-Indiana", [
		["1883-11-18T18:00:00+00:00", "12:00:00", "CST", 360]
	]),

	"1918" : helpers.makeTestYear("US/East-Indiana", [
		["1918-03-31T07:59:59+00:00", "01:59:59", "CST", 360],
		["1918-03-31T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1918-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1918-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1919" : helpers.makeTestYear("US/East-Indiana", [
		["1919-03-30T07:59:59+00:00", "01:59:59", "CST", 360],
		["1919-03-30T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1919-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1919-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1941" : helpers.makeTestYear("US/East-Indiana", [
		["1941-06-22T07:59:59+00:00", "01:59:59", "CST", 360],
		["1941-06-22T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1941-09-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1941-09-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1942" : helpers.makeTestYear("US/East-Indiana", [
		["1942-02-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["1942-02-09T08:00:00+00:00", "03:00:00", "CWT", 300]
	]),

	"1945" : helpers.makeTestYear("US/East-Indiana", [
		["1945-08-14T22:59:59+00:00", "17:59:59", "CWT", 300],
		["1945-08-14T23:00:00+00:00", "18:00:00", "CPT", 300],
		["1945-09-30T06:59:59+00:00", "01:59:59", "CPT", 300],
		["1945-09-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1946" : helpers.makeTestYear("US/East-Indiana", [
		["1946-04-28T07:59:59+00:00", "01:59:59", "CST", 360],
		["1946-04-28T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1946-09-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1946-09-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1947" : helpers.makeTestYear("US/East-Indiana", [
		["1947-04-27T07:59:59+00:00", "01:59:59", "CST", 360],
		["1947-04-27T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1947-09-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1947-09-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1948" : helpers.makeTestYear("US/East-Indiana", [
		["1948-04-25T07:59:59+00:00", "01:59:59", "CST", 360],
		["1948-04-25T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1948-09-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1948-09-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1949" : helpers.makeTestYear("US/East-Indiana", [
		["1949-04-24T07:59:59+00:00", "01:59:59", "CST", 360],
		["1949-04-24T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1949-09-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1949-09-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1950" : helpers.makeTestYear("US/East-Indiana", [
		["1950-04-30T07:59:59+00:00", "01:59:59", "CST", 360],
		["1950-04-30T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1950-09-24T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1950-09-24T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1951" : helpers.makeTestYear("US/East-Indiana", [
		["1951-04-29T07:59:59+00:00", "01:59:59", "CST", 360],
		["1951-04-29T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1951-09-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1951-09-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1952" : helpers.makeTestYear("US/East-Indiana", [
		["1952-04-27T07:59:59+00:00", "01:59:59", "CST", 360],
		["1952-04-27T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1952-09-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1952-09-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1953" : helpers.makeTestYear("US/East-Indiana", [
		["1953-04-26T07:59:59+00:00", "01:59:59", "CST", 360],
		["1953-04-26T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1953-09-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1953-09-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1954" : helpers.makeTestYear("US/East-Indiana", [
		["1954-04-25T07:59:59+00:00", "01:59:59", "CST", 360],
		["1954-04-25T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1954-09-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1954-09-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1955" : helpers.makeTestYear("US/East-Indiana", [
		["1955-04-24T07:59:59+00:00", "01:59:59", "CST", 360],
		["1955-04-24T08:00:00+00:00", "03:00:00", "EST", 300]
	]),

	"1957" : helpers.makeTestYear("US/East-Indiana", [
		["1957-09-29T06:59:59+00:00", "01:59:59", "EST", 300],
		["1957-09-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1958" : helpers.makeTestYear("US/East-Indiana", [
		["1958-04-27T07:59:59+00:00", "01:59:59", "CST", 360],
		["1958-04-27T08:00:00+00:00", "03:00:00", "EST", 300]
	]),

	"1969" : helpers.makeTestYear("US/East-Indiana", [
		["1969-04-27T06:59:59+00:00", "01:59:59", "EST", 300],
		["1969-04-27T07:00:00+00:00", "03:00:00", "EDT", 240],
		["1969-10-26T05:59:59+00:00", "01:59:59", "EDT", 240],
		["1969-10-26T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"1970" : helpers.makeTestYear("US/East-Indiana", [
		["1970-04-26T06:59:59+00:00", "01:59:59", "EST", 300],
		["1970-04-26T07:00:00+00:00", "03:00:00", "EDT", 240],
		["1970-10-25T05:59:59+00:00", "01:59:59", "EDT", 240],
		["1970-10-25T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2006" : helpers.makeTestYear("US/East-Indiana", [
		["2006-04-02T06:59:59+00:00", "01:59:59", "EST", 300],
		["2006-04-02T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2006-10-29T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2006-10-29T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2007" : helpers.makeTestYear("US/East-Indiana", [
		["2007-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2007-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2007-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2007-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2008" : helpers.makeTestYear("US/East-Indiana", [
		["2008-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2008-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2008-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2008-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2009" : helpers.makeTestYear("US/East-Indiana", [
		["2009-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2009-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2009-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2009-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2010" : helpers.makeTestYear("US/East-Indiana", [
		["2010-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2010-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2010-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2010-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2011" : helpers.makeTestYear("US/East-Indiana", [
		["2011-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2011-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2011-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2011-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2012" : helpers.makeTestYear("US/East-Indiana", [
		["2012-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2012-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2012-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2012-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2013" : helpers.makeTestYear("US/East-Indiana", [
		["2013-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2013-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2013-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2013-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2014" : helpers.makeTestYear("US/East-Indiana", [
		["2014-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2014-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2014-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2014-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2015" : helpers.makeTestYear("US/East-Indiana", [
		["2015-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2015-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2015-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2015-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2016" : helpers.makeTestYear("US/East-Indiana", [
		["2016-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2016-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2016-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2016-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2017" : helpers.makeTestYear("US/East-Indiana", [
		["2017-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2017-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2017-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2017-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2018" : helpers.makeTestYear("US/East-Indiana", [
		["2018-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2018-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2018-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2018-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2019" : helpers.makeTestYear("US/East-Indiana", [
		["2019-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2019-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2019-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2019-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2020" : helpers.makeTestYear("US/East-Indiana", [
		["2020-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2020-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2020-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2020-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2021" : helpers.makeTestYear("US/East-Indiana", [
		["2021-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2021-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2021-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2021-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2022" : helpers.makeTestYear("US/East-Indiana", [
		["2022-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2022-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2022-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2022-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2023" : helpers.makeTestYear("US/East-Indiana", [
		["2023-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2023-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2023-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2023-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2024" : helpers.makeTestYear("US/East-Indiana", [
		["2024-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2024-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2024-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2024-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2025" : helpers.makeTestYear("US/East-Indiana", [
		["2025-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2025-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2025-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2025-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2026" : helpers.makeTestYear("US/East-Indiana", [
		["2026-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2026-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2026-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2026-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2027" : helpers.makeTestYear("US/East-Indiana", [
		["2027-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2027-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2027-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2027-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2028" : helpers.makeTestYear("US/East-Indiana", [
		["2028-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2028-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2028-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2028-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2029" : helpers.makeTestYear("US/East-Indiana", [
		["2029-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2029-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2029-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2029-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2030" : helpers.makeTestYear("US/East-Indiana", [
		["2030-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2030-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2030-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2030-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2031" : helpers.makeTestYear("US/East-Indiana", [
		["2031-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2031-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2031-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2031-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2032" : helpers.makeTestYear("US/East-Indiana", [
		["2032-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2032-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2032-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2032-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2033" : helpers.makeTestYear("US/East-Indiana", [
		["2033-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2033-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2033-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2033-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2034" : helpers.makeTestYear("US/East-Indiana", [
		["2034-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2034-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2034-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2034-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2035" : helpers.makeTestYear("US/East-Indiana", [
		["2035-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2035-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2035-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2035-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2036" : helpers.makeTestYear("US/East-Indiana", [
		["2036-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2036-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2036-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2036-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2037" : helpers.makeTestYear("US/East-Indiana", [
		["2037-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2037-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2037-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2037-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2038" : helpers.makeTestYear("US/East-Indiana", [
		["2038-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2038-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2038-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2038-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2039" : helpers.makeTestYear("US/East-Indiana", [
		["2039-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2039-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2039-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2039-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2040" : helpers.makeTestYear("US/East-Indiana", [
		["2040-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2040-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2040-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2040-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2041" : helpers.makeTestYear("US/East-Indiana", [
		["2041-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2041-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2041-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2041-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2042" : helpers.makeTestYear("US/East-Indiana", [
		["2042-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2042-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2042-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2042-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2043" : helpers.makeTestYear("US/East-Indiana", [
		["2043-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2043-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2043-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2043-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2044" : helpers.makeTestYear("US/East-Indiana", [
		["2044-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2044-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2044-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2044-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2045" : helpers.makeTestYear("US/East-Indiana", [
		["2045-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2045-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2045-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2045-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2046" : helpers.makeTestYear("US/East-Indiana", [
		["2046-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2046-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2046-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2046-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2047" : helpers.makeTestYear("US/East-Indiana", [
		["2047-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2047-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2047-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2047-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2048" : helpers.makeTestYear("US/East-Indiana", [
		["2048-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2048-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2048-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2048-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2049" : helpers.makeTestYear("US/East-Indiana", [
		["2049-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2049-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2049-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2049-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2050" : helpers.makeTestYear("US/East-Indiana", [
		["2050-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2050-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2050-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2050-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2051" : helpers.makeTestYear("US/East-Indiana", [
		["2051-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2051-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2051-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2051-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2052" : helpers.makeTestYear("US/East-Indiana", [
		["2052-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2052-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2052-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2052-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2053" : helpers.makeTestYear("US/East-Indiana", [
		["2053-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2053-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2053-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2053-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2054" : helpers.makeTestYear("US/East-Indiana", [
		["2054-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2054-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2054-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2054-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2055" : helpers.makeTestYear("US/East-Indiana", [
		["2055-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2055-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2055-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2055-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2056" : helpers.makeTestYear("US/East-Indiana", [
		["2056-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2056-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2056-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2056-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2057" : helpers.makeTestYear("US/East-Indiana", [
		["2057-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2057-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2057-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2057-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2058" : helpers.makeTestYear("US/East-Indiana", [
		["2058-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2058-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2058-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2058-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2059" : helpers.makeTestYear("US/East-Indiana", [
		["2059-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2059-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2059-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2059-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2060" : helpers.makeTestYear("US/East-Indiana", [
		["2060-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2060-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2060-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2060-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2061" : helpers.makeTestYear("US/East-Indiana", [
		["2061-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2061-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2061-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2061-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2062" : helpers.makeTestYear("US/East-Indiana", [
		["2062-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2062-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2062-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2062-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2063" : helpers.makeTestYear("US/East-Indiana", [
		["2063-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2063-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2063-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2063-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2064" : helpers.makeTestYear("US/East-Indiana", [
		["2064-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2064-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2064-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2064-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2065" : helpers.makeTestYear("US/East-Indiana", [
		["2065-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2065-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2065-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2065-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2066" : helpers.makeTestYear("US/East-Indiana", [
		["2066-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2066-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2066-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2066-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2067" : helpers.makeTestYear("US/East-Indiana", [
		["2067-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2067-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2067-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2067-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2068" : helpers.makeTestYear("US/East-Indiana", [
		["2068-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2068-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2068-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2068-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2069" : helpers.makeTestYear("US/East-Indiana", [
		["2069-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2069-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2069-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2069-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2070" : helpers.makeTestYear("US/East-Indiana", [
		["2070-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2070-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2070-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2070-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2071" : helpers.makeTestYear("US/East-Indiana", [
		["2071-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2071-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2071-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2071-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2072" : helpers.makeTestYear("US/East-Indiana", [
		["2072-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2072-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2072-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2072-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2073" : helpers.makeTestYear("US/East-Indiana", [
		["2073-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2073-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2073-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2073-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2074" : helpers.makeTestYear("US/East-Indiana", [
		["2074-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2074-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2074-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2074-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2075" : helpers.makeTestYear("US/East-Indiana", [
		["2075-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2075-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2075-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2075-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2076" : helpers.makeTestYear("US/East-Indiana", [
		["2076-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2076-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2076-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2076-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2077" : helpers.makeTestYear("US/East-Indiana", [
		["2077-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2077-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2077-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2077-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2078" : helpers.makeTestYear("US/East-Indiana", [
		["2078-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2078-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2078-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2078-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2079" : helpers.makeTestYear("US/East-Indiana", [
		["2079-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2079-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2079-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2079-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2080" : helpers.makeTestYear("US/East-Indiana", [
		["2080-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2080-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2080-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2080-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2081" : helpers.makeTestYear("US/East-Indiana", [
		["2081-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2081-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2081-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2081-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2082" : helpers.makeTestYear("US/East-Indiana", [
		["2082-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2082-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2082-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2082-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2083" : helpers.makeTestYear("US/East-Indiana", [
		["2083-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2083-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2083-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2083-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2084" : helpers.makeTestYear("US/East-Indiana", [
		["2084-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2084-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2084-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2084-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2085" : helpers.makeTestYear("US/East-Indiana", [
		["2085-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2085-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2085-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2085-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2086" : helpers.makeTestYear("US/East-Indiana", [
		["2086-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2086-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2086-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2086-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2087" : helpers.makeTestYear("US/East-Indiana", [
		["2087-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2087-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2087-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2087-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2088" : helpers.makeTestYear("US/East-Indiana", [
		["2088-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2088-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2088-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2088-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2089" : helpers.makeTestYear("US/East-Indiana", [
		["2089-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2089-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2089-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2089-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2090" : helpers.makeTestYear("US/East-Indiana", [
		["2090-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2090-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2090-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2090-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2091" : helpers.makeTestYear("US/East-Indiana", [
		["2091-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2091-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2091-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2091-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2092" : helpers.makeTestYear("US/East-Indiana", [
		["2092-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2092-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2092-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2092-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2093" : helpers.makeTestYear("US/East-Indiana", [
		["2093-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2093-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2093-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2093-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2094" : helpers.makeTestYear("US/East-Indiana", [
		["2094-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2094-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2094-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2094-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2095" : helpers.makeTestYear("US/East-Indiana", [
		["2095-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2095-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2095-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2095-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2096" : helpers.makeTestYear("US/East-Indiana", [
		["2096-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2096-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2096-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2096-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2097" : helpers.makeTestYear("US/East-Indiana", [
		["2097-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2097-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2097-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2097-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2098" : helpers.makeTestYear("US/East-Indiana", [
		["2098-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2098-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2098-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2098-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2099" : helpers.makeTestYear("US/East-Indiana", [
		["2099-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2099-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2099-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2099-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2100" : helpers.makeTestYear("US/East-Indiana", [
		["2100-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2100-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2100-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2100-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2101" : helpers.makeTestYear("US/East-Indiana", [
		["2101-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2101-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2101-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2101-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2102" : helpers.makeTestYear("US/East-Indiana", [
		["2102-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2102-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2102-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2102-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2103" : helpers.makeTestYear("US/East-Indiana", [
		["2103-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2103-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2103-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2103-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2104" : helpers.makeTestYear("US/East-Indiana", [
		["2104-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2104-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2104-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2104-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2105" : helpers.makeTestYear("US/East-Indiana", [
		["2105-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2105-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2105-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2105-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2106" : helpers.makeTestYear("US/East-Indiana", [
		["2106-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2106-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2106-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2106-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2107" : helpers.makeTestYear("US/East-Indiana", [
		["2107-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2107-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2107-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2107-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2108" : helpers.makeTestYear("US/East-Indiana", [
		["2108-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2108-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2108-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2108-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2109" : helpers.makeTestYear("US/East-Indiana", [
		["2109-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2109-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2109-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2109-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2110" : helpers.makeTestYear("US/East-Indiana", [
		["2110-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2110-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2110-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2110-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2111" : helpers.makeTestYear("US/East-Indiana", [
		["2111-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2111-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2111-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2111-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2112" : helpers.makeTestYear("US/East-Indiana", [
		["2112-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2112-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2112-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2112-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2113" : helpers.makeTestYear("US/East-Indiana", [
		["2113-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2113-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2113-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2113-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2114" : helpers.makeTestYear("US/East-Indiana", [
		["2114-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2114-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2114-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2114-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2115" : helpers.makeTestYear("US/East-Indiana", [
		["2115-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2115-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2115-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2115-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2116" : helpers.makeTestYear("US/East-Indiana", [
		["2116-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2116-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2116-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2116-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2117" : helpers.makeTestYear("US/East-Indiana", [
		["2117-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2117-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2117-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2117-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2118" : helpers.makeTestYear("US/East-Indiana", [
		["2118-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2118-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2118-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2118-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2119" : helpers.makeTestYear("US/East-Indiana", [
		["2119-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2119-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2119-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2119-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2120" : helpers.makeTestYear("US/East-Indiana", [
		["2120-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2120-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2120-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2120-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2121" : helpers.makeTestYear("US/East-Indiana", [
		["2121-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2121-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2121-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2121-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2122" : helpers.makeTestYear("US/East-Indiana", [
		["2122-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2122-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2122-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2122-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2123" : helpers.makeTestYear("US/East-Indiana", [
		["2123-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2123-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2123-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2123-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2124" : helpers.makeTestYear("US/East-Indiana", [
		["2124-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2124-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2124-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2124-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2125" : helpers.makeTestYear("US/East-Indiana", [
		["2125-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2125-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2125-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2125-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2126" : helpers.makeTestYear("US/East-Indiana", [
		["2126-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2126-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2126-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2126-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2127" : helpers.makeTestYear("US/East-Indiana", [
		["2127-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2127-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2127-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2127-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2128" : helpers.makeTestYear("US/East-Indiana", [
		["2128-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2128-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2128-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2128-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2129" : helpers.makeTestYear("US/East-Indiana", [
		["2129-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2129-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2129-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2129-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2130" : helpers.makeTestYear("US/East-Indiana", [
		["2130-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2130-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2130-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2130-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2131" : helpers.makeTestYear("US/East-Indiana", [
		["2131-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2131-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2131-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2131-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2132" : helpers.makeTestYear("US/East-Indiana", [
		["2132-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2132-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2132-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2132-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2133" : helpers.makeTestYear("US/East-Indiana", [
		["2133-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2133-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2133-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2133-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2134" : helpers.makeTestYear("US/East-Indiana", [
		["2134-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2134-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2134-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2134-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2135" : helpers.makeTestYear("US/East-Indiana", [
		["2135-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2135-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2135-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2135-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2136" : helpers.makeTestYear("US/East-Indiana", [
		["2136-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2136-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2136-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2136-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2137" : helpers.makeTestYear("US/East-Indiana", [
		["2137-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2137-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2137-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2137-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2138" : helpers.makeTestYear("US/East-Indiana", [
		["2138-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2138-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2138-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2138-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2139" : helpers.makeTestYear("US/East-Indiana", [
		["2139-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2139-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2139-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2139-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2140" : helpers.makeTestYear("US/East-Indiana", [
		["2140-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2140-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2140-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2140-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2141" : helpers.makeTestYear("US/East-Indiana", [
		["2141-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2141-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2141-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2141-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2142" : helpers.makeTestYear("US/East-Indiana", [
		["2142-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2142-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2142-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2142-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2143" : helpers.makeTestYear("US/East-Indiana", [
		["2143-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2143-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2143-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2143-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2144" : helpers.makeTestYear("US/East-Indiana", [
		["2144-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2144-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2144-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2144-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2145" : helpers.makeTestYear("US/East-Indiana", [
		["2145-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2145-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2145-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2145-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2146" : helpers.makeTestYear("US/East-Indiana", [
		["2146-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2146-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2146-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2146-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2147" : helpers.makeTestYear("US/East-Indiana", [
		["2147-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2147-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2147-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2147-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2148" : helpers.makeTestYear("US/East-Indiana", [
		["2148-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2148-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2148-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2148-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2149" : helpers.makeTestYear("US/East-Indiana", [
		["2149-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2149-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2149-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2149-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2150" : helpers.makeTestYear("US/East-Indiana", [
		["2150-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2150-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2150-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2150-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2151" : helpers.makeTestYear("US/East-Indiana", [
		["2151-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2151-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2151-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2151-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2152" : helpers.makeTestYear("US/East-Indiana", [
		["2152-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2152-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2152-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2152-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2153" : helpers.makeTestYear("US/East-Indiana", [
		["2153-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2153-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2153-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2153-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2154" : helpers.makeTestYear("US/East-Indiana", [
		["2154-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2154-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2154-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2154-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2155" : helpers.makeTestYear("US/East-Indiana", [
		["2155-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2155-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2155-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2155-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2156" : helpers.makeTestYear("US/East-Indiana", [
		["2156-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2156-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2156-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2156-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2157" : helpers.makeTestYear("US/East-Indiana", [
		["2157-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2157-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2157-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2157-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2158" : helpers.makeTestYear("US/East-Indiana", [
		["2158-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2158-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2158-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2158-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2159" : helpers.makeTestYear("US/East-Indiana", [
		["2159-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2159-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2159-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2159-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2160" : helpers.makeTestYear("US/East-Indiana", [
		["2160-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2160-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2160-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2160-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2161" : helpers.makeTestYear("US/East-Indiana", [
		["2161-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2161-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2161-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2161-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2162" : helpers.makeTestYear("US/East-Indiana", [
		["2162-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2162-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2162-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2162-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2163" : helpers.makeTestYear("US/East-Indiana", [
		["2163-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2163-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2163-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2163-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2164" : helpers.makeTestYear("US/East-Indiana", [
		["2164-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2164-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2164-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2164-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2165" : helpers.makeTestYear("US/East-Indiana", [
		["2165-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2165-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2165-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2165-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2166" : helpers.makeTestYear("US/East-Indiana", [
		["2166-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2166-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2166-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2166-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2167" : helpers.makeTestYear("US/East-Indiana", [
		["2167-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2167-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2167-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2167-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2168" : helpers.makeTestYear("US/East-Indiana", [
		["2168-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2168-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2168-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2168-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2169" : helpers.makeTestYear("US/East-Indiana", [
		["2169-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2169-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2169-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2169-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2170" : helpers.makeTestYear("US/East-Indiana", [
		["2170-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2170-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2170-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2170-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2171" : helpers.makeTestYear("US/East-Indiana", [
		["2171-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2171-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2171-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2171-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2172" : helpers.makeTestYear("US/East-Indiana", [
		["2172-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2172-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2172-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2172-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2173" : helpers.makeTestYear("US/East-Indiana", [
		["2173-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2173-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2173-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2173-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2174" : helpers.makeTestYear("US/East-Indiana", [
		["2174-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2174-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2174-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2174-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2175" : helpers.makeTestYear("US/East-Indiana", [
		["2175-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2175-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2175-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2175-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2176" : helpers.makeTestYear("US/East-Indiana", [
		["2176-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2176-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2176-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2176-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2177" : helpers.makeTestYear("US/East-Indiana", [
		["2177-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2177-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2177-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2177-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2178" : helpers.makeTestYear("US/East-Indiana", [
		["2178-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2178-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2178-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2178-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2179" : helpers.makeTestYear("US/East-Indiana", [
		["2179-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2179-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2179-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2179-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2180" : helpers.makeTestYear("US/East-Indiana", [
		["2180-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2180-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2180-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2180-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2181" : helpers.makeTestYear("US/East-Indiana", [
		["2181-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2181-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2181-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2181-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2182" : helpers.makeTestYear("US/East-Indiana", [
		["2182-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2182-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2182-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2182-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2183" : helpers.makeTestYear("US/East-Indiana", [
		["2183-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2183-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2183-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2183-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2184" : helpers.makeTestYear("US/East-Indiana", [
		["2184-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2184-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2184-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2184-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2185" : helpers.makeTestYear("US/East-Indiana", [
		["2185-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2185-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2185-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2185-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2186" : helpers.makeTestYear("US/East-Indiana", [
		["2186-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2186-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2186-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2186-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2187" : helpers.makeTestYear("US/East-Indiana", [
		["2187-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2187-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2187-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2187-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2188" : helpers.makeTestYear("US/East-Indiana", [
		["2188-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2188-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2188-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2188-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2189" : helpers.makeTestYear("US/East-Indiana", [
		["2189-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2189-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2189-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2189-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2190" : helpers.makeTestYear("US/East-Indiana", [
		["2190-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2190-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2190-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2190-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2191" : helpers.makeTestYear("US/East-Indiana", [
		["2191-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2191-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2191-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2191-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2192" : helpers.makeTestYear("US/East-Indiana", [
		["2192-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2192-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2192-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2192-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2193" : helpers.makeTestYear("US/East-Indiana", [
		["2193-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2193-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2193-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2193-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2194" : helpers.makeTestYear("US/East-Indiana", [
		["2194-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2194-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2194-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2194-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2195" : helpers.makeTestYear("US/East-Indiana", [
		["2195-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2195-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2195-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2195-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2196" : helpers.makeTestYear("US/East-Indiana", [
		["2196-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2196-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2196-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2196-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2197" : helpers.makeTestYear("US/East-Indiana", [
		["2197-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2197-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2197-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2197-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2198" : helpers.makeTestYear("US/East-Indiana", [
		["2198-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2198-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2198-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2198-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2199" : helpers.makeTestYear("US/East-Indiana", [
		["2199-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2199-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2199-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2199-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2200" : helpers.makeTestYear("US/East-Indiana", [
		["2200-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2200-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2200-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2200-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2201" : helpers.makeTestYear("US/East-Indiana", [
		["2201-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2201-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2201-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2201-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2202" : helpers.makeTestYear("US/East-Indiana", [
		["2202-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2202-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2202-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2202-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2203" : helpers.makeTestYear("US/East-Indiana", [
		["2203-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2203-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2203-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2203-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2204" : helpers.makeTestYear("US/East-Indiana", [
		["2204-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2204-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2204-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2204-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2205" : helpers.makeTestYear("US/East-Indiana", [
		["2205-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2205-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2205-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2205-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2206" : helpers.makeTestYear("US/East-Indiana", [
		["2206-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2206-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2206-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2206-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2207" : helpers.makeTestYear("US/East-Indiana", [
		["2207-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2207-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2207-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2207-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2208" : helpers.makeTestYear("US/East-Indiana", [
		["2208-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2208-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2208-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2208-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2209" : helpers.makeTestYear("US/East-Indiana", [
		["2209-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2209-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2209-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2209-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2210" : helpers.makeTestYear("US/East-Indiana", [
		["2210-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2210-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2210-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2210-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2211" : helpers.makeTestYear("US/East-Indiana", [
		["2211-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2211-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2211-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2211-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2212" : helpers.makeTestYear("US/East-Indiana", [
		["2212-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2212-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2212-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2212-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2213" : helpers.makeTestYear("US/East-Indiana", [
		["2213-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2213-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2213-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2213-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2214" : helpers.makeTestYear("US/East-Indiana", [
		["2214-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2214-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2214-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2214-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2215" : helpers.makeTestYear("US/East-Indiana", [
		["2215-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2215-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2215-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2215-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2216" : helpers.makeTestYear("US/East-Indiana", [
		["2216-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2216-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2216-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2216-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2217" : helpers.makeTestYear("US/East-Indiana", [
		["2217-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2217-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2217-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2217-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2218" : helpers.makeTestYear("US/East-Indiana", [
		["2218-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2218-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2218-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2218-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2219" : helpers.makeTestYear("US/East-Indiana", [
		["2219-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2219-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2219-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2219-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2220" : helpers.makeTestYear("US/East-Indiana", [
		["2220-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2220-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2220-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2220-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2221" : helpers.makeTestYear("US/East-Indiana", [
		["2221-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2221-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2221-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2221-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2222" : helpers.makeTestYear("US/East-Indiana", [
		["2222-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2222-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2222-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2222-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2223" : helpers.makeTestYear("US/East-Indiana", [
		["2223-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2223-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2223-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2223-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2224" : helpers.makeTestYear("US/East-Indiana", [
		["2224-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2224-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2224-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2224-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2225" : helpers.makeTestYear("US/East-Indiana", [
		["2225-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2225-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2225-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2225-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2226" : helpers.makeTestYear("US/East-Indiana", [
		["2226-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2226-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2226-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2226-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2227" : helpers.makeTestYear("US/East-Indiana", [
		["2227-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2227-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2227-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2227-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2228" : helpers.makeTestYear("US/East-Indiana", [
		["2228-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2228-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2228-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2228-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2229" : helpers.makeTestYear("US/East-Indiana", [
		["2229-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2229-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2229-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2229-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2230" : helpers.makeTestYear("US/East-Indiana", [
		["2230-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2230-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2230-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2230-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2231" : helpers.makeTestYear("US/East-Indiana", [
		["2231-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2231-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2231-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2231-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2232" : helpers.makeTestYear("US/East-Indiana", [
		["2232-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2232-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2232-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2232-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2233" : helpers.makeTestYear("US/East-Indiana", [
		["2233-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2233-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2233-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2233-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2234" : helpers.makeTestYear("US/East-Indiana", [
		["2234-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2234-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2234-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2234-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2235" : helpers.makeTestYear("US/East-Indiana", [
		["2235-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2235-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2235-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2235-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2236" : helpers.makeTestYear("US/East-Indiana", [
		["2236-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2236-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2236-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2236-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2237" : helpers.makeTestYear("US/East-Indiana", [
		["2237-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2237-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2237-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2237-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2238" : helpers.makeTestYear("US/East-Indiana", [
		["2238-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2238-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2238-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2238-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2239" : helpers.makeTestYear("US/East-Indiana", [
		["2239-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2239-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2239-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2239-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2240" : helpers.makeTestYear("US/East-Indiana", [
		["2240-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2240-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2240-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2240-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2241" : helpers.makeTestYear("US/East-Indiana", [
		["2241-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2241-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2241-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2241-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2242" : helpers.makeTestYear("US/East-Indiana", [
		["2242-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2242-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2242-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2242-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2243" : helpers.makeTestYear("US/East-Indiana", [
		["2243-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2243-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2243-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2243-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2244" : helpers.makeTestYear("US/East-Indiana", [
		["2244-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2244-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2244-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2244-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2245" : helpers.makeTestYear("US/East-Indiana", [
		["2245-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2245-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2245-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2245-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2246" : helpers.makeTestYear("US/East-Indiana", [
		["2246-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2246-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2246-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2246-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2247" : helpers.makeTestYear("US/East-Indiana", [
		["2247-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2247-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2247-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2247-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2248" : helpers.makeTestYear("US/East-Indiana", [
		["2248-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2248-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2248-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2248-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2249" : helpers.makeTestYear("US/East-Indiana", [
		["2249-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2249-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2249-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2249-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2250" : helpers.makeTestYear("US/East-Indiana", [
		["2250-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2250-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2250-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2250-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2251" : helpers.makeTestYear("US/East-Indiana", [
		["2251-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2251-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2251-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2251-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2252" : helpers.makeTestYear("US/East-Indiana", [
		["2252-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2252-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2252-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2252-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2253" : helpers.makeTestYear("US/East-Indiana", [
		["2253-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2253-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2253-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2253-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2254" : helpers.makeTestYear("US/East-Indiana", [
		["2254-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2254-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2254-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2254-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2255" : helpers.makeTestYear("US/East-Indiana", [
		["2255-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2255-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2255-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2255-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2256" : helpers.makeTestYear("US/East-Indiana", [
		["2256-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2256-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2256-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2256-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2257" : helpers.makeTestYear("US/East-Indiana", [
		["2257-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2257-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2257-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2257-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2258" : helpers.makeTestYear("US/East-Indiana", [
		["2258-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2258-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2258-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2258-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2259" : helpers.makeTestYear("US/East-Indiana", [
		["2259-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2259-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2259-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2259-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2260" : helpers.makeTestYear("US/East-Indiana", [
		["2260-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2260-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2260-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2260-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2261" : helpers.makeTestYear("US/East-Indiana", [
		["2261-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2261-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2261-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2261-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2262" : helpers.makeTestYear("US/East-Indiana", [
		["2262-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2262-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2262-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2262-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2263" : helpers.makeTestYear("US/East-Indiana", [
		["2263-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2263-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2263-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2263-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2264" : helpers.makeTestYear("US/East-Indiana", [
		["2264-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2264-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2264-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2264-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2265" : helpers.makeTestYear("US/East-Indiana", [
		["2265-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2265-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2265-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2265-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2266" : helpers.makeTestYear("US/East-Indiana", [
		["2266-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2266-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2266-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2266-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2267" : helpers.makeTestYear("US/East-Indiana", [
		["2267-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2267-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2267-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2267-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2268" : helpers.makeTestYear("US/East-Indiana", [
		["2268-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2268-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2268-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2268-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2269" : helpers.makeTestYear("US/East-Indiana", [
		["2269-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2269-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2269-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2269-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2270" : helpers.makeTestYear("US/East-Indiana", [
		["2270-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2270-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2270-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2270-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2271" : helpers.makeTestYear("US/East-Indiana", [
		["2271-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2271-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2271-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2271-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2272" : helpers.makeTestYear("US/East-Indiana", [
		["2272-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2272-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2272-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2272-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2273" : helpers.makeTestYear("US/East-Indiana", [
		["2273-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2273-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2273-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2273-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2274" : helpers.makeTestYear("US/East-Indiana", [
		["2274-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2274-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2274-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2274-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2275" : helpers.makeTestYear("US/East-Indiana", [
		["2275-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2275-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2275-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2275-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2276" : helpers.makeTestYear("US/East-Indiana", [
		["2276-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2276-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2276-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2276-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2277" : helpers.makeTestYear("US/East-Indiana", [
		["2277-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2277-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2277-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2277-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2278" : helpers.makeTestYear("US/East-Indiana", [
		["2278-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2278-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2278-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2278-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2279" : helpers.makeTestYear("US/East-Indiana", [
		["2279-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2279-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2279-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2279-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2280" : helpers.makeTestYear("US/East-Indiana", [
		["2280-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2280-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2280-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2280-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2281" : helpers.makeTestYear("US/East-Indiana", [
		["2281-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2281-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2281-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2281-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2282" : helpers.makeTestYear("US/East-Indiana", [
		["2282-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2282-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2282-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2282-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2283" : helpers.makeTestYear("US/East-Indiana", [
		["2283-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2283-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2283-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2283-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2284" : helpers.makeTestYear("US/East-Indiana", [
		["2284-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2284-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2284-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2284-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2285" : helpers.makeTestYear("US/East-Indiana", [
		["2285-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2285-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2285-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2285-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2286" : helpers.makeTestYear("US/East-Indiana", [
		["2286-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2286-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2286-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2286-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2287" : helpers.makeTestYear("US/East-Indiana", [
		["2287-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2287-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2287-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2287-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2288" : helpers.makeTestYear("US/East-Indiana", [
		["2288-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2288-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2288-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2288-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2289" : helpers.makeTestYear("US/East-Indiana", [
		["2289-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2289-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2289-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2289-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2290" : helpers.makeTestYear("US/East-Indiana", [
		["2290-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2290-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2290-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2290-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2291" : helpers.makeTestYear("US/East-Indiana", [
		["2291-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2291-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2291-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2291-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2292" : helpers.makeTestYear("US/East-Indiana", [
		["2292-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2292-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2292-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2292-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2293" : helpers.makeTestYear("US/East-Indiana", [
		["2293-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2293-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2293-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2293-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2294" : helpers.makeTestYear("US/East-Indiana", [
		["2294-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2294-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2294-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2294-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2295" : helpers.makeTestYear("US/East-Indiana", [
		["2295-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2295-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2295-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2295-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2296" : helpers.makeTestYear("US/East-Indiana", [
		["2296-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2296-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2296-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2296-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2297" : helpers.makeTestYear("US/East-Indiana", [
		["2297-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2297-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2297-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2297-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2298" : helpers.makeTestYear("US/East-Indiana", [
		["2298-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2298-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2298-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2298-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2299" : helpers.makeTestYear("US/East-Indiana", [
		["2299-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2299-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2299-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2299-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2300" : helpers.makeTestYear("US/East-Indiana", [
		["2300-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2300-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2300-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2300-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2301" : helpers.makeTestYear("US/East-Indiana", [
		["2301-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2301-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2301-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2301-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2302" : helpers.makeTestYear("US/East-Indiana", [
		["2302-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2302-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2302-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2302-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2303" : helpers.makeTestYear("US/East-Indiana", [
		["2303-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2303-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2303-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2303-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2304" : helpers.makeTestYear("US/East-Indiana", [
		["2304-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2304-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2304-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2304-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2305" : helpers.makeTestYear("US/East-Indiana", [
		["2305-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2305-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2305-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2305-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2306" : helpers.makeTestYear("US/East-Indiana", [
		["2306-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2306-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2306-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2306-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2307" : helpers.makeTestYear("US/East-Indiana", [
		["2307-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2307-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2307-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2307-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2308" : helpers.makeTestYear("US/East-Indiana", [
		["2308-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2308-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2308-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2308-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2309" : helpers.makeTestYear("US/East-Indiana", [
		["2309-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2309-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2309-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2309-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2310" : helpers.makeTestYear("US/East-Indiana", [
		["2310-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2310-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2310-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2310-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2311" : helpers.makeTestYear("US/East-Indiana", [
		["2311-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2311-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2311-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2311-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2312" : helpers.makeTestYear("US/East-Indiana", [
		["2312-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2312-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2312-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2312-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2313" : helpers.makeTestYear("US/East-Indiana", [
		["2313-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2313-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2313-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2313-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2314" : helpers.makeTestYear("US/East-Indiana", [
		["2314-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2314-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2314-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2314-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2315" : helpers.makeTestYear("US/East-Indiana", [
		["2315-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2315-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2315-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2315-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2316" : helpers.makeTestYear("US/East-Indiana", [
		["2316-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2316-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2316-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2316-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2317" : helpers.makeTestYear("US/East-Indiana", [
		["2317-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2317-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2317-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2317-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2318" : helpers.makeTestYear("US/East-Indiana", [
		["2318-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2318-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2318-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2318-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2319" : helpers.makeTestYear("US/East-Indiana", [
		["2319-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2319-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2319-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2319-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2320" : helpers.makeTestYear("US/East-Indiana", [
		["2320-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2320-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2320-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2320-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2321" : helpers.makeTestYear("US/East-Indiana", [
		["2321-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2321-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2321-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2321-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2322" : helpers.makeTestYear("US/East-Indiana", [
		["2322-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2322-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2322-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2322-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2323" : helpers.makeTestYear("US/East-Indiana", [
		["2323-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2323-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2323-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2323-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2324" : helpers.makeTestYear("US/East-Indiana", [
		["2324-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2324-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2324-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2324-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2325" : helpers.makeTestYear("US/East-Indiana", [
		["2325-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2325-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2325-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2325-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2326" : helpers.makeTestYear("US/East-Indiana", [
		["2326-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2326-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2326-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2326-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2327" : helpers.makeTestYear("US/East-Indiana", [
		["2327-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2327-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2327-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2327-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2328" : helpers.makeTestYear("US/East-Indiana", [
		["2328-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2328-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2328-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2328-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2329" : helpers.makeTestYear("US/East-Indiana", [
		["2329-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2329-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2329-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2329-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2330" : helpers.makeTestYear("US/East-Indiana", [
		["2330-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2330-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2330-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2330-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2331" : helpers.makeTestYear("US/East-Indiana", [
		["2331-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2331-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2331-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2331-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2332" : helpers.makeTestYear("US/East-Indiana", [
		["2332-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2332-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2332-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2332-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2333" : helpers.makeTestYear("US/East-Indiana", [
		["2333-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2333-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2333-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2333-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2334" : helpers.makeTestYear("US/East-Indiana", [
		["2334-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2334-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2334-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2334-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2335" : helpers.makeTestYear("US/East-Indiana", [
		["2335-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2335-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2335-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2335-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2336" : helpers.makeTestYear("US/East-Indiana", [
		["2336-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2336-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2336-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2336-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2337" : helpers.makeTestYear("US/East-Indiana", [
		["2337-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2337-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2337-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2337-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2338" : helpers.makeTestYear("US/East-Indiana", [
		["2338-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2338-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2338-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2338-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2339" : helpers.makeTestYear("US/East-Indiana", [
		["2339-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2339-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2339-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2339-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2340" : helpers.makeTestYear("US/East-Indiana", [
		["2340-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2340-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2340-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2340-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2341" : helpers.makeTestYear("US/East-Indiana", [
		["2341-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2341-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2341-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2341-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2342" : helpers.makeTestYear("US/East-Indiana", [
		["2342-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2342-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2342-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2342-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2343" : helpers.makeTestYear("US/East-Indiana", [
		["2343-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2343-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2343-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2343-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2344" : helpers.makeTestYear("US/East-Indiana", [
		["2344-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2344-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2344-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2344-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2345" : helpers.makeTestYear("US/East-Indiana", [
		["2345-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2345-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2345-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2345-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2346" : helpers.makeTestYear("US/East-Indiana", [
		["2346-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2346-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2346-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2346-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2347" : helpers.makeTestYear("US/East-Indiana", [
		["2347-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2347-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2347-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2347-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2348" : helpers.makeTestYear("US/East-Indiana", [
		["2348-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2348-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2348-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2348-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2349" : helpers.makeTestYear("US/East-Indiana", [
		["2349-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2349-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2349-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2349-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2350" : helpers.makeTestYear("US/East-Indiana", [
		["2350-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2350-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2350-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2350-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2351" : helpers.makeTestYear("US/East-Indiana", [
		["2351-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2351-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2351-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2351-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2352" : helpers.makeTestYear("US/East-Indiana", [
		["2352-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2352-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2352-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2352-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2353" : helpers.makeTestYear("US/East-Indiana", [
		["2353-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2353-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2353-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2353-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2354" : helpers.makeTestYear("US/East-Indiana", [
		["2354-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2354-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2354-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2354-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2355" : helpers.makeTestYear("US/East-Indiana", [
		["2355-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2355-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2355-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2355-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2356" : helpers.makeTestYear("US/East-Indiana", [
		["2356-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2356-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2356-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2356-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2357" : helpers.makeTestYear("US/East-Indiana", [
		["2357-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2357-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2357-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2357-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2358" : helpers.makeTestYear("US/East-Indiana", [
		["2358-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2358-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2358-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2358-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2359" : helpers.makeTestYear("US/East-Indiana", [
		["2359-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2359-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2359-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2359-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2360" : helpers.makeTestYear("US/East-Indiana", [
		["2360-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2360-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2360-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2360-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2361" : helpers.makeTestYear("US/East-Indiana", [
		["2361-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2361-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2361-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2361-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2362" : helpers.makeTestYear("US/East-Indiana", [
		["2362-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2362-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2362-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2362-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2363" : helpers.makeTestYear("US/East-Indiana", [
		["2363-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2363-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2363-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2363-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2364" : helpers.makeTestYear("US/East-Indiana", [
		["2364-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2364-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2364-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2364-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2365" : helpers.makeTestYear("US/East-Indiana", [
		["2365-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2365-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2365-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2365-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2366" : helpers.makeTestYear("US/East-Indiana", [
		["2366-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2366-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2366-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2366-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2367" : helpers.makeTestYear("US/East-Indiana", [
		["2367-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2367-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2367-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2367-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2368" : helpers.makeTestYear("US/East-Indiana", [
		["2368-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2368-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2368-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2368-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2369" : helpers.makeTestYear("US/East-Indiana", [
		["2369-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2369-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2369-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2369-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2370" : helpers.makeTestYear("US/East-Indiana", [
		["2370-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2370-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2370-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2370-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2371" : helpers.makeTestYear("US/East-Indiana", [
		["2371-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2371-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2371-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2371-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2372" : helpers.makeTestYear("US/East-Indiana", [
		["2372-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2372-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2372-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2372-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2373" : helpers.makeTestYear("US/East-Indiana", [
		["2373-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2373-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2373-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2373-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2374" : helpers.makeTestYear("US/East-Indiana", [
		["2374-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2374-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2374-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2374-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2375" : helpers.makeTestYear("US/East-Indiana", [
		["2375-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2375-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2375-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2375-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2376" : helpers.makeTestYear("US/East-Indiana", [
		["2376-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2376-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2376-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2376-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2377" : helpers.makeTestYear("US/East-Indiana", [
		["2377-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2377-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2377-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2377-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2378" : helpers.makeTestYear("US/East-Indiana", [
		["2378-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2378-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2378-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2378-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2379" : helpers.makeTestYear("US/East-Indiana", [
		["2379-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2379-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2379-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2379-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2380" : helpers.makeTestYear("US/East-Indiana", [
		["2380-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2380-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2380-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2380-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2381" : helpers.makeTestYear("US/East-Indiana", [
		["2381-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2381-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2381-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2381-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2382" : helpers.makeTestYear("US/East-Indiana", [
		["2382-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2382-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2382-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2382-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2383" : helpers.makeTestYear("US/East-Indiana", [
		["2383-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2383-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2383-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2383-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2384" : helpers.makeTestYear("US/East-Indiana", [
		["2384-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2384-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2384-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2384-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2385" : helpers.makeTestYear("US/East-Indiana", [
		["2385-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2385-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2385-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2385-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2386" : helpers.makeTestYear("US/East-Indiana", [
		["2386-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2386-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2386-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2386-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2387" : helpers.makeTestYear("US/East-Indiana", [
		["2387-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2387-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2387-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2387-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2388" : helpers.makeTestYear("US/East-Indiana", [
		["2388-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2388-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2388-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2388-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2389" : helpers.makeTestYear("US/East-Indiana", [
		["2389-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2389-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2389-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2389-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2390" : helpers.makeTestYear("US/East-Indiana", [
		["2390-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2390-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2390-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2390-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2391" : helpers.makeTestYear("US/East-Indiana", [
		["2391-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2391-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2391-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2391-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2392" : helpers.makeTestYear("US/East-Indiana", [
		["2392-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2392-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2392-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2392-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2393" : helpers.makeTestYear("US/East-Indiana", [
		["2393-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2393-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2393-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2393-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2394" : helpers.makeTestYear("US/East-Indiana", [
		["2394-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2394-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2394-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2394-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2395" : helpers.makeTestYear("US/East-Indiana", [
		["2395-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2395-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2395-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2395-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2396" : helpers.makeTestYear("US/East-Indiana", [
		["2396-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2396-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2396-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2396-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2397" : helpers.makeTestYear("US/East-Indiana", [
		["2397-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2397-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2397-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2397-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2398" : helpers.makeTestYear("US/East-Indiana", [
		["2398-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2398-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2398-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2398-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2399" : helpers.makeTestYear("US/East-Indiana", [
		["2399-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2399-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2399-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2399-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2400" : helpers.makeTestYear("US/East-Indiana", [
		["2400-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2400-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2400-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2400-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2401" : helpers.makeTestYear("US/East-Indiana", [
		["2401-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2401-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2401-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2401-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2402" : helpers.makeTestYear("US/East-Indiana", [
		["2402-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2402-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2402-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2402-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2403" : helpers.makeTestYear("US/East-Indiana", [
		["2403-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2403-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2403-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2403-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2404" : helpers.makeTestYear("US/East-Indiana", [
		["2404-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2404-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2404-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2404-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2405" : helpers.makeTestYear("US/East-Indiana", [
		["2405-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2405-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2405-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2405-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2406" : helpers.makeTestYear("US/East-Indiana", [
		["2406-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2406-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2406-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2406-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2407" : helpers.makeTestYear("US/East-Indiana", [
		["2407-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2407-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2407-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2407-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2408" : helpers.makeTestYear("US/East-Indiana", [
		["2408-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2408-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2408-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2408-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2409" : helpers.makeTestYear("US/East-Indiana", [
		["2409-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2409-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2409-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2409-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2410" : helpers.makeTestYear("US/East-Indiana", [
		["2410-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2410-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2410-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2410-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2411" : helpers.makeTestYear("US/East-Indiana", [
		["2411-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2411-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2411-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2411-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2412" : helpers.makeTestYear("US/East-Indiana", [
		["2412-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2412-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2412-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2412-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2413" : helpers.makeTestYear("US/East-Indiana", [
		["2413-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2413-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2413-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2413-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2414" : helpers.makeTestYear("US/East-Indiana", [
		["2414-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2414-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2414-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2414-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2415" : helpers.makeTestYear("US/East-Indiana", [
		["2415-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2415-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2415-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2415-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2416" : helpers.makeTestYear("US/East-Indiana", [
		["2416-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2416-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2416-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2416-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2417" : helpers.makeTestYear("US/East-Indiana", [
		["2417-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2417-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2417-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2417-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2418" : helpers.makeTestYear("US/East-Indiana", [
		["2418-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2418-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2418-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2418-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2419" : helpers.makeTestYear("US/East-Indiana", [
		["2419-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2419-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2419-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2419-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2420" : helpers.makeTestYear("US/East-Indiana", [
		["2420-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2420-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2420-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2420-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2421" : helpers.makeTestYear("US/East-Indiana", [
		["2421-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2421-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2421-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2421-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2422" : helpers.makeTestYear("US/East-Indiana", [
		["2422-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2422-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2422-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2422-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2423" : helpers.makeTestYear("US/East-Indiana", [
		["2423-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2423-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2423-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2423-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2424" : helpers.makeTestYear("US/East-Indiana", [
		["2424-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2424-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2424-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2424-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2425" : helpers.makeTestYear("US/East-Indiana", [
		["2425-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2425-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2425-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2425-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2426" : helpers.makeTestYear("US/East-Indiana", [
		["2426-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2426-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2426-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2426-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2427" : helpers.makeTestYear("US/East-Indiana", [
		["2427-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2427-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2427-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2427-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2428" : helpers.makeTestYear("US/East-Indiana", [
		["2428-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2428-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2428-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2428-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2429" : helpers.makeTestYear("US/East-Indiana", [
		["2429-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2429-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2429-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2429-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2430" : helpers.makeTestYear("US/East-Indiana", [
		["2430-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2430-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2430-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2430-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2431" : helpers.makeTestYear("US/East-Indiana", [
		["2431-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2431-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2431-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2431-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2432" : helpers.makeTestYear("US/East-Indiana", [
		["2432-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2432-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2432-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2432-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2433" : helpers.makeTestYear("US/East-Indiana", [
		["2433-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2433-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2433-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2433-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2434" : helpers.makeTestYear("US/East-Indiana", [
		["2434-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2434-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2434-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2434-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2435" : helpers.makeTestYear("US/East-Indiana", [
		["2435-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2435-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2435-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2435-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2436" : helpers.makeTestYear("US/East-Indiana", [
		["2436-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2436-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2436-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2436-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2437" : helpers.makeTestYear("US/East-Indiana", [
		["2437-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2437-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2437-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2437-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2438" : helpers.makeTestYear("US/East-Indiana", [
		["2438-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2438-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2438-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2438-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2439" : helpers.makeTestYear("US/East-Indiana", [
		["2439-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2439-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2439-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2439-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2440" : helpers.makeTestYear("US/East-Indiana", [
		["2440-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2440-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2440-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2440-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2441" : helpers.makeTestYear("US/East-Indiana", [
		["2441-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2441-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2441-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2441-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2442" : helpers.makeTestYear("US/East-Indiana", [
		["2442-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2442-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2442-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2442-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2443" : helpers.makeTestYear("US/East-Indiana", [
		["2443-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2443-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2443-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2443-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2444" : helpers.makeTestYear("US/East-Indiana", [
		["2444-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2444-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2444-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2444-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2445" : helpers.makeTestYear("US/East-Indiana", [
		["2445-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2445-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2445-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2445-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2446" : helpers.makeTestYear("US/East-Indiana", [
		["2446-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2446-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2446-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2446-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2447" : helpers.makeTestYear("US/East-Indiana", [
		["2447-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2447-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2447-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2447-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2448" : helpers.makeTestYear("US/East-Indiana", [
		["2448-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2448-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2448-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2448-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2449" : helpers.makeTestYear("US/East-Indiana", [
		["2449-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2449-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2449-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2449-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2450" : helpers.makeTestYear("US/East-Indiana", [
		["2450-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2450-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2450-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2450-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2451" : helpers.makeTestYear("US/East-Indiana", [
		["2451-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2451-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2451-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2451-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2452" : helpers.makeTestYear("US/East-Indiana", [
		["2452-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2452-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2452-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2452-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2453" : helpers.makeTestYear("US/East-Indiana", [
		["2453-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2453-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2453-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2453-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2454" : helpers.makeTestYear("US/East-Indiana", [
		["2454-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2454-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2454-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2454-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2455" : helpers.makeTestYear("US/East-Indiana", [
		["2455-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2455-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2455-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2455-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2456" : helpers.makeTestYear("US/East-Indiana", [
		["2456-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2456-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2456-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2456-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2457" : helpers.makeTestYear("US/East-Indiana", [
		["2457-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2457-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2457-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2457-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2458" : helpers.makeTestYear("US/East-Indiana", [
		["2458-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2458-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2458-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2458-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2459" : helpers.makeTestYear("US/East-Indiana", [
		["2459-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2459-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2459-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2459-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2460" : helpers.makeTestYear("US/East-Indiana", [
		["2460-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2460-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2460-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2460-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2461" : helpers.makeTestYear("US/East-Indiana", [
		["2461-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2461-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2461-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2461-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2462" : helpers.makeTestYear("US/East-Indiana", [
		["2462-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2462-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2462-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2462-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2463" : helpers.makeTestYear("US/East-Indiana", [
		["2463-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2463-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2463-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2463-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2464" : helpers.makeTestYear("US/East-Indiana", [
		["2464-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2464-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2464-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2464-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2465" : helpers.makeTestYear("US/East-Indiana", [
		["2465-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2465-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2465-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2465-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2466" : helpers.makeTestYear("US/East-Indiana", [
		["2466-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2466-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2466-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2466-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2467" : helpers.makeTestYear("US/East-Indiana", [
		["2467-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2467-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2467-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2467-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2468" : helpers.makeTestYear("US/East-Indiana", [
		["2468-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2468-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2468-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2468-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2469" : helpers.makeTestYear("US/East-Indiana", [
		["2469-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2469-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2469-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2469-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2470" : helpers.makeTestYear("US/East-Indiana", [
		["2470-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2470-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2470-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2470-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2471" : helpers.makeTestYear("US/East-Indiana", [
		["2471-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2471-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2471-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2471-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2472" : helpers.makeTestYear("US/East-Indiana", [
		["2472-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2472-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2472-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2472-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2473" : helpers.makeTestYear("US/East-Indiana", [
		["2473-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2473-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2473-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2473-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2474" : helpers.makeTestYear("US/East-Indiana", [
		["2474-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2474-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2474-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2474-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2475" : helpers.makeTestYear("US/East-Indiana", [
		["2475-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2475-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2475-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2475-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2476" : helpers.makeTestYear("US/East-Indiana", [
		["2476-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2476-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2476-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2476-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2477" : helpers.makeTestYear("US/East-Indiana", [
		["2477-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2477-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2477-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2477-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2478" : helpers.makeTestYear("US/East-Indiana", [
		["2478-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2478-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2478-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2478-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2479" : helpers.makeTestYear("US/East-Indiana", [
		["2479-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2479-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2479-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2479-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2480" : helpers.makeTestYear("US/East-Indiana", [
		["2480-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2480-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2480-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2480-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2481" : helpers.makeTestYear("US/East-Indiana", [
		["2481-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2481-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2481-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2481-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2482" : helpers.makeTestYear("US/East-Indiana", [
		["2482-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2482-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2482-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2482-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2483" : helpers.makeTestYear("US/East-Indiana", [
		["2483-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2483-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2483-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2483-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2484" : helpers.makeTestYear("US/East-Indiana", [
		["2484-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2484-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2484-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2484-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2485" : helpers.makeTestYear("US/East-Indiana", [
		["2485-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2485-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2485-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2485-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2486" : helpers.makeTestYear("US/East-Indiana", [
		["2486-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2486-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2486-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2486-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2487" : helpers.makeTestYear("US/East-Indiana", [
		["2487-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2487-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2487-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2487-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2488" : helpers.makeTestYear("US/East-Indiana", [
		["2488-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2488-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2488-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2488-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2489" : helpers.makeTestYear("US/East-Indiana", [
		["2489-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2489-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2489-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2489-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2490" : helpers.makeTestYear("US/East-Indiana", [
		["2490-03-12T06:59:59+00:00", "01:59:59", "EST", 300],
		["2490-03-12T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2490-11-05T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2490-11-05T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2491" : helpers.makeTestYear("US/East-Indiana", [
		["2491-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2491-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2491-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2491-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2492" : helpers.makeTestYear("US/East-Indiana", [
		["2492-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2492-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2492-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2492-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2493" : helpers.makeTestYear("US/East-Indiana", [
		["2493-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2493-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2493-11-01T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2493-11-01T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2494" : helpers.makeTestYear("US/East-Indiana", [
		["2494-03-14T06:59:59+00:00", "01:59:59", "EST", 300],
		["2494-03-14T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2494-11-07T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2494-11-07T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2495" : helpers.makeTestYear("US/East-Indiana", [
		["2495-03-13T06:59:59+00:00", "01:59:59", "EST", 300],
		["2495-03-13T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2495-11-06T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2495-11-06T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2496" : helpers.makeTestYear("US/East-Indiana", [
		["2496-03-11T06:59:59+00:00", "01:59:59", "EST", 300],
		["2496-03-11T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2496-11-04T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2496-11-04T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2497" : helpers.makeTestYear("US/East-Indiana", [
		["2497-03-10T06:59:59+00:00", "01:59:59", "EST", 300],
		["2497-03-10T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2497-11-03T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2497-11-03T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2498" : helpers.makeTestYear("US/East-Indiana", [
		["2498-03-09T06:59:59+00:00", "01:59:59", "EST", 300],
		["2498-03-09T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2498-11-02T05:59:59+00:00", "01:59:59", "EDT", 240],
		["2498-11-02T06:00:00+00:00", "01:00:00", "EST", 300]
	]),

	"2499" : helpers.makeTestYear("US/East-Indiana", [
		["2499-03-08T06:59:59+00:00", "01:59:59", "EST", 300],
		["2499-03-08T07:00:00+00:00", "03:00:00", "EDT", 240],
		["2499-11-01T05:59:59+00:00", "01:59:59", "EDT", 240]
	])
};