
;;; file:epsinulDisplay.scm

(define (make-numeric-term k)
  (if (integer? k)
      (cond ((= k 0) (pt "Zero"))
	     ((> k  0)(make-term-in-app-form
	               (pt "OP Zero ")
	               (make-numeric-term (- k 1 )))
             )
	     (else (myerror "make-numeric-term" "nonnegative integer expected" k))
      )
      (display "Integer ?")
  )
)


; Test
(term-to-string (make-numeric-term 0))
;     O : Zero
(term-to-string (make-numeric-term 1))
;     1 : OP Zero Zero
(term-to-string (make-numeric-term 2))
;     2 : OP Zero (OP Zero Zero)
(term-to-string (make-numeric-term 22))
; pretty long

;   n+1 : OP Zero n


(define (is-numeric-term? term)
  (or
   (and (term-in-const-form? term)
	(string=? "Zero" (const-to-name (term-in-const-form-to-const term))))
   (and (term-in-app-form? term)
	(let ((op (term-in-app-form-to-op(term-in-app-form-to-op term))))
	  (and (term-in-const-form? op)
	       (let ((name (const-to-name (term-in-const-form-to-const op))))
		 (string=? "OP" name) )
	       (and (is-numeric-term? (term-in-app-form-to-arg (term-in-app-form-to-op term)))
                         (is-numeric-term? (term-in-app-form-to-arg term))
               )
          )
        )
   )
  )
)

; Test
(is-numeric-term? (pt"Zero"))
; #t
(is-numeric-term? (pt"OP Zero"))
; #f
(is-numeric-term? (pt"OP (OP 11 22) (OP 33 44)"))
; #t



(define (is-finite-ordinal? term)
 (and (is-numeric-term? term) 
  (or
   (and (term-in-const-form? term)
	(string=? "Zero" (const-to-name (term-in-const-form-to-const term))))
   (and (term-in-app-form? term)
	(let* ((leftarg (term-in-app-form-to-arg(term-in-app-form-to-op term)))
	       (rightarg (term-in-app-form-to-arg term))
              )
              (and (equal? leftarg (pt "Zero")) (is-finite-ordinal? rightarg))
        )
   )
  )
 )
)

; Test
(is-finite-ordinal? (pt"0"))
; #t
(is-finite-ordinal? (pt"OP Zero"))
; #f
(is-finite-ordinal? (pt"1"))
; #t
(is-finite-ordinal? (pt"OP 1 0"))
; #f
(is-finite-ordinal? (pt"100"))
; #t
(is-finite-ordinal? (pt"OP (OP 11 22) (OP 33 44)"))
; #f



(define (is-infinite-ordinal? term)
 (and (is-numeric-term? term) 
      (term-in-app-form? term)
	(let* ((leftarg (term-in-app-form-to-arg(term-in-app-form-to-op term)))
	       (rightarg (term-in-app-form-to-arg term))
              )
              (or (not (equal? leftarg (pt "Zero"))) (is-infinite-ordinal? rightarg))
        )
 )
)

; Test
(is-infinite-ordinal? (pt"0"))
; #f
(is-infinite-ordinal? (pt"OP Zero"))
; #f
(is-infinite-ordinal? (pt"1"))
; #t
(is-infinite-ordinal? (pt"OP 1 0"))
; #t
(is-infinite-ordinal? (pt"100"))
; #f
(is-infinite-ordinal? (pt"OP (OP 11 22) (OP 33 44)"))
; #t



(define (term-to-token-tree term)
  (if (is-finite-ordinal? term)
      (list 'number (finite-ordinal-to-number term))
      (let ((type (term-to-type term)))
	(do ((l DISPLAY-FUNCTIONS (cdr l))
	     (res
	      #f
	      (let* ((item (car l))
		     (pattern (car item)))
		(if (type-match pattern type)
		    ((cadr item) term)
		    #f))))
	    ((or res (null? l))
	     (cond (res res)
		   ((term-in-symbolic-app-form? term)
		    (list 'appterm ""
			  (term-to-token-tree
			   (term-in-symbolic-app-form-to-op term))
			  (term-to-token-tree
			   (term-in-symbolic-app-form-to-arg term))))
		   (else (default-term-to-token-tree term)))))))
)


(define (finite-ordinal-to-number term)
  (if (equal? term (pt "Zero"))
      0
      (let* ((op (term-in-app-form-to-op term))
	     (leftarg (term-in-app-form-to-arg(term-in-app-form-to-op term)))
	     (rightarg (term-in-app-form-to-arg term))
	     (name (const-to-name (term-in-const-form-to-const op))))
	(if (term-in-const-form? leftarg)
	    (+ 1 (finite-ordinal-to-number rightarg))
	    ((term-to-string (pt term)))
        )
      )
  )
)


(define (is-inford-token-tree? token-tree)
 (and (eq? (car token-tree) 'appterm)
  (let* ((leftarg (cadr(cdr(cdr(caddr token-tree)))))
	  (rightarg (car(cdr(cdr(cdr token-tree)))))
         )
         (or (not (equal? leftarg "number 0")) (is-inford-token-tree? rightarg))
   )
 )
)


; Test
(is-inford-token-tree? (term-to-token-tree  (pt"0")))
; #f
;(is-inford-token-tree? (term-to-token-tree  (pt"OP Zero")))
; Error
(is-inford-token-tree? (term-to-token-tree  (pt"1")))
; #t
(is-inford-token-tree? (term-to-token-tree  (pt"OP 1 0")))
; #t
(is-inford-token-tree? (term-to-token-tree  (pt"100")))
; #f
(is-inford-token-tree? (term-to-token-tree  (pt"OP (OP 11 22) (OP 33 44)")))
; #t


(define (inford-token-tree-to-string token-tree)
      (let* ((leftarg (cadr(cdr(cdr(caddr token-tree)))))
	     (rightarg (car(cdr(cdr(cdr token-tree)))))
             (leftstring (token-tree-to-string leftarg))
             (rightstring (token-tree-to-string rightarg))
	    )
        (if (equal? leftstring "0")
            (string-append "1+" rightstring)
            (if (equal? leftstring "1")
                (string-append "ω+" rightstring)
                (string-append "ω^(" leftstring ")+" rightstring)
            )
        )
      )
)

	 
(define (not-inford-token-tree-to-string token-tree)
  (case (car token-tree)
    ((number) (number-to-string (cadr token-tree)))
    ((var const) (cadr token-tree))
    ((binding-op)
     (let* ((varstrings-and-kernel
	     (token-tree-to-varstrings-and-kernel token-tree))
	    (varstrings (car varstrings-and-kernel))
	    (kernel (cadr varstrings-and-kernel))
	    (comma-string (do ((l (cdr varstrings) (cdr l))
			       (res (car varstrings)
				    (string-append res "," (car l))))
			      ((null? l) res))))
       (string-append "[" comma-string "]" (not-inford-token-tree-to-string kernel))))
    ((prefix-op)
     (let* ((arg (not-inford-token-tree-to-string (caddr token-tree)))
	    (op (cadr token-tree))
	    (prec-op (token-type-to-precedence 'prefix-op))
	    (prec-arg (token-type-to-precedence (caaddr token-tree))))
       (if (<= prec-op prec-arg)
	   (string-append op (separator-string op arg) arg)
	   (string-append op "(" arg ")"))))
    ((postfix-op)
     (let* ((arg (not-inford-token-tree-to-string (caddr token-tree)))
	    (op (cadr token-tree))
	    (prec-op (token-type-to-precedence 'postfix-op))
	    (prec-arg (token-type-to-precedence (caaddr token-tree))))
       (if (<= prec-op prec-arg)
	   (string-append arg (separator-string arg op) op)
	   (string-append "(" arg ")" op))))
    ;next the infix operators:
    ((pair-op term imp-op impterm or-op orterm and-op andterm
      rel-op relterm add-op addterm mul-op multerm appterm)
     (let* ((arg1 (not-inford-token-tree-to-string (caddr token-tree)))
	    (arg2 (not-inford-token-tree-to-string (cadddr token-tree)))
	    (op (cadr token-tree))
	    (prec-op (token-type-to-precedence (car token-tree)))
	    (prec-arg1 (token-type-to-precedence (car (caddr token-tree))))
	    (prec-arg2 (token-type-to-precedence (car (cadddr token-tree))))
	    (left-string       
	     (if (or (< prec-arg1 prec-op)
		     (and (= prec-arg1 prec-op)
			  (right-assoc? (car (caddr token-tree)))))
		 (string-append "(" arg1 ")")
		 (string-append arg1 (separator-string arg1 op))))
	    (right-string
	     (if (or (< prec-arg2 prec-op)
		     (and (= prec-arg2 prec-op)
			  (left-assoc? (car (cadddr token-tree)))))
		 (string-append "(" arg2 ")")
		 (string-append (separator-string op arg2) arg2))))
       (string-append left-string
		      (if (string=? op "")
			  (separator-string left-string right-string)
			  op)
		      right-string)))
    ((if-op)
     (apply
      string-append
      (cons "[if"
	    (append
	     (map (lambda (x)
		    (if (< (token-type-to-precedence (car x))
			   (token-type-to-precedence 'atomic-term))
			(string-append " (" (not-inford-token-tree-to-string x) ")")
			(string-append " " (not-inford-token-tree-to-string x))))
		  (cddr token-tree))
	     (list "]")))))))


(define (token-tree-to-string token-tree)
  (if (is-inford-token-tree? token-tree)
      (inford-token-tree-to-string  token-tree)
      (not-inford-token-tree-to-string token-tree)
  )
)



(define (numeric-term-to-number term)
  (if (is-finite-ordinal? term)
      (finite-ordinal-to-number term)
      (myerror "Infinite ordinals cannot be transformed to numbers !")
  )
)


; od: Ordinal display

(define (od term)
  (if (is-finite-ordinal? term)
      (finite-ordinal-to-number term)
      (display (term-to-string term))
  )
)


(define (term-to-string x)
  (if (is-infinite-ordinal? x)
      (inford-token-tree-to-string (term-to-token-tree x))
      (not-inford-token-tree-to-string (term-to-token-tree x))
  )
)


; TEST
;
(od (pt" Zero"))
; 0
(od (pt "27"))
; 27
(od (pt "OP 1 0"))
; ω+0
(od (pt "OP 1 1"))
; ω+1
(term-to-string (pt "OP 0 (OP 1 1)"))
; 1+ω+1





; Abbreviations:

; pnt
(define(pnt term) (pp(nt(pt term))))

(pnt "OP a b=0")

; ont
(define(ont term) (od(nt(pt term))))

(ont "OP a b=0")

; ca
(define(ca formula string)
 (begin (cut(pf formula))
        (assume string)
))

; cas
(define(cas formula string)
 (begin (cut(pf formula))
        (assume string)
        (simp string)
))


; End





;;;;;;;;; End of displaying stuff ;;;;;


(display "\n ¹ ² ³ ⁴ ⁵ ⁶ ⁷ ⁸ ⁹ \n")

(display "\n \342\201\264 \342\201\265 \n")

(display"
End of e0display.scm
")


; EOF