/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include <string>

#include <QMainWindow>
#include <QModelIndex>

#include "MvQMainWindow.h"
#include "MvQMenuItem.h"

class QSplitter;
class QSortFilterProxyModel;

class MvGeoPoints;
class MvQArrowSpinWidget;
class MvQFileInfoLabel;
class MvQGeoPointsDataModel;
class MvQTreeView;
class MvQTreeViewSearchLine;
class MvQLogPanel;


class GeopExaminer : public MvQMainWindow
{
    Q_OBJECT

public:
    GeopExaminer(QWidget* parent = 0);
    ~GeopExaminer();
    bool initMetaData(const std::string&);
    void updateFileInfoLabel();

public slots:
    void slotShowAboutBox();
    void slotDataRowSpinChanged(int);
    void slotSelectDataRow(const QModelIndex&);

private:
    void setupEditActions();
    void setupViewActions();
    void setupHelpActions();
    void setupDataBox();
    void setupFindBox();
    void updateMetadataLabel();
    void readSettings();
    void writeSettings();

    MvGeoPoints* data_{nullptr};
    MvQGeoPointsDataModel* gpModel_;
    QSortFilterProxyModel* gpSortModel_;
    MvQMainWindow::MenuItemMap menuItems_;
    MvQFileInfoLabel* fileInfoLabel_;
    QLabel* metadataLabel_;

    QAction* actionFileInfo_;
    QSplitter* mainSplitter_;
    MvQTreeView* treeData_;
    MvQLogPanel* logPanel_;
    QAction* actionLog_;
    QLabel* statusMessageLabel_;
    bool ignoreDataRowSpinChangeSignal_;
    MvQArrowSpinWidget* dataRowSpin_;
    QWidget* dataPanel_;
};
