/*
    Copyright (C) 2016 Volker Krause <vkrause@kde.org>

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef KUSERFEEDBACK_CONSOLE_SAMPLE_H
#define KUSERFEEDBACK_CONSOLE_SAMPLE_H

#include <QMetaType>
#include <QSharedDataPointer>
#include <QVector>

class QDateTime;
class QString;

namespace KUserFeedback {
namespace Console {

class Product;
class SampleData;

/** One data sample reported by a client. */
class Sample
{
public:
    Sample();
    Sample(const Sample&);
    ~Sample();
    Sample& operator=(const Sample&);

    QDateTime timestamp() const;
    QVariant value(const QString &name) const;

    static QVector<Sample> fromJson(const QByteArray &json, const Product &product);
    static QByteArray toJson(const QVector<Sample> &samples, const Product &product);

private:
    QSharedDataPointer<SampleData> d;
};

}
}

Q_DECLARE_TYPEINFO(KUserFeedback::Console::Sample, Q_MOVABLE_TYPE);
Q_DECLARE_METATYPE(KUserFeedback::Console::Sample)

#endif // KUSERFEEDBACK_CONSOLE_SAMPLE_H
