.TH EXPECT 1 "29 December 1994"
.SH NAME
expect \- programmed dialogue with interactive programs, Version 5
.SH SYNOPSIS
.B expect
[
.B \-dDinN
]
[
.B \-c
.I cmds
]
[
[
.BR \- [ f | b ]
]
.I cmdfile
]
[
.I args
]
.SH INTRODUCTION
.B Expect
is a program that "talks" to other interactive programs according to a
script.  Following the script,
.B Expect
knows what can be expected from
a program and what the correct response should be.  An interpreted
language provides branching and high-level control structures to
direct the dialogue.  In addition, the user can take control
and interact directly when desired, afterward returning control to the
script.
.PP
.B Expectk
is a mixture of
.B Expect
and
.BR Tk .
It behaves just like
.B Expect
and
.BR Tk 's
.BR wish .
.B Expect
can also be used directly in C or C++ (that is, without Tcl).
See libexpect(3).
.PP
The name "Expect" comes from the idea of
.I send/expect
sequences popularized
by uucp, kermit and other modem control programs.
However unlike uucp,
.B Expect
is generalized so that it can be run as a user-level command
with any program and task in mind.
.B Expect
can actually talk to several programs at the same time.
.PP
For example, here are some things
.B Expect
can do:
.RS
.TP 4
\(bu
Cause your computer to dial you back,
so that you can login without paying for the call.
.TP
\(bu
Start a game (e.g., rogue) and if the optimal configuration doesn't appear,
restart it (again and again) until it does,
then hand over control to you.
.TP
\(bu
Run fsck, and in response to its questions, answer "yes", "no" or give control back to you,
based on predetermined criteria.
.TP
\(bu
Connect to another network or BBS (e.g., MCI Mail, CompuServe) and
automatically retrieve your mail so that it appears as if
it was originally sent to your local system.
.TP
\(bu
Carry environment variables, current directory,
or any kind of information across rlogin, telnet, tip, su, chgrp, etc.
.RE
.PP
There are a variety of reasons why the shell cannot perform these tasks.
(Try, you'll see.)
All are possible with
.BR Expect .
.PP
In general,
.B Expect
is useful for running any program which requires
interaction between the program and the user.
All that is necessary is that the interaction can be characterized
programmatically.
.B Expect
can also give the user back control
(without halting the program being controlled) if desired.
Similarly, the user can return control to the script at any time.
.SH USAGE
.B Expect
reads
.I cmdfile
for a list of commands to execute.
.B Expect
may also be invoked implicitly on systems which support the #! notation
by marking the script executable, and making the first line in your script:

    #!/usr/local/bin/expect \-f

Of course, the path must accurately describe where
.B Expect
lives.  /usr/local/bin is just an example.

The
.B \-c
flag prefaces a command to be executed before any in the script.
The command should be quoted to prevent being broken up by the shell.
This option may be used multiple times.
Multiple commands may be
executed with a single
.B \-c
by separating them with semicolons.
Commands are executed in the order they appear.  
(When using Expectk, this option is specified as
.BR \-command .)
.PP
The
.B \-d
flag enables some diagnostic output, which
primarily reports internal activity of commands such as 
.B expect
and
.BR interact .
This flag has the same effect as "exp_internal 1" at the beginning of an Expect
script, plus the version of
.B Expect
is printed.
(The
.B strace
command is useful for tracing statements, and the
.B trace
command is useful for tracing variable assignments.)
(When using Expectk, this option is specified as
.BR \-diag .)
.PP
The
.B \-D
flag enables an interactive debugger.  An integer value should follow.
The debugger will take control before the next Tcl procedure
if the value is non-zero
or if a ^C is pressed (or a breakpoint is hit, or other appropriate debugger
command appears in the script).  See the README file or SEE ALSO (below)
for more information on the debugger.
(When using Expectk, this option is specified as
.BR \-Debug .)
.PP
The
.B \-f
flag prefaces a file from which to read commands from.
The flag itself is optional as it is only useful when using
the #! notation (see above),
so that other arguments may be supplied on the command line.
(When using Expectk, this option is specified as
.BR \-file .)
.PP
By default, the command file is read into memory and executed in its entirety.
It is occasionally desirable to read files one line at a time.  For example,
stdin is read this way.  In order to force arbitrary files to be handled this
way, use the
.B \-b
flag.
(When using Expectk, this option is specified as
.BR \-buffer .)
Note that stdio-buffering may still take place however this shouldn't cause
problems when reading from a fifo or stdin.
.PP
If the string "\-" is supplied as a filename, standard input is read instead.
(Use "./\-" to read from a file actually named "\-".)
.PP
The
.B \-i
flag causes
.B Expect
to interactively prompt for commands instead of reading
them from a file.
Prompting is terminated via the
.B exit
command or upon EOF.
See
.B interpreter
(below) for more information.
.B \-i
is assumed if neither a command file nor
.B \-c
is used.
(When using Expectk, this option is specified as
.BR \-interactive .)
.PP
.B \-\-
may be used to delimit the end of the options.  This is useful if
you want to pass an option-like argument to your script without it being
interpreted by
.BR Expect .
This can usefully be placed in the #! line to prevent any flag-like
interpretation by Expect.  For example, the following will leave the
original arguments (including the script name) in the variable
.IR argv .

    #!/usr/local/bin/expect \-\-

Note that the usual getopt(3) and execve(2) conventions must be observed
when adding arguments to the #! line.
.PP
The file $exp_library/expect.rc is sourced automatically if present, unless
the
.B \-N
flag is used.  
(When using Expectk, this option is specified as
.BR \-NORC .)
Immediately after this,
the file ~/.expect.rc is sourced automatically, unless the
.B \-n
flag is used.  If the environment variable DOTDIR is defined,
it is treated as a directory and .expect.rc is read from there.
(When using Expectk, this option is specified as
.BR \-norc .)
This sourcing occurs only after executing any
.B \-c
flags.
.PP
.B \-v
causes Expect to print its version number and exit.  (The corresponding flag
in Expectk, which uses long flag names, is \-version.)
.PP
Optional
.I args
are constructed into a list and stored in the variable named
.IR argv .
.I argc
is initialized to the length of argv.
.PP
.I argv0
is defined to be the name of the script (or binary if no script is used).
For example,
the following prints out the name of the script and the first three arguments:
.nf

    send_user "$argv0 [lrange $argv 0 2]\\n"

.fi
.SH COMMANDS
.B Expect
uses
.I Tcl
(Tool Command Language).
Tcl provides control flow (e.g., if, for, break),
expression evaluation and several other features such as recursion,
procedure definition, etc.
Commands used here but not defined (e.g.,
.BR set ,
.BR if ,
.BR exec )
are Tcl commands (see tcl(3)).
.B Expect
supports additional commands, described below.
Unless otherwise specified, commands return the empty string.
.PP
Commands are listed alphabetically so that they can be quickly located.
However, new users may find it easier to start by reading the descriptions
of
.BR spawn ,
.BR send ,
.BR expect ,
and
.BR interact ,
in that order.

Note that the best introduction to the language (both Expect and Tcl)
is provided in the book "Exploring Expect" (see SEE ALSO below).
Examples are included in this man page but they are very limited since
this man page is meant primarily as reference material.

Note that in the text of this man page, "Expect" with an uppercase "E"
refers to the
.B Expect
program while "expect" with a lower-case "e" refers to the
.B expect
command within the
.B Expect
program.)
.I
.TP 6
.BI close " [-slave] [\-onexec 0|1] [\-i spawn_id]"
closes the connection to the current process.
Most interactive programs will detect EOF on their stdin and exit;
thus
.B close
usually suffices to kill the process as well.
The
.B \-i
flag declares the process to close corresponding to the named spawn_id.

Both
.B expect
and
.B interact
will detect when the current process exits and implicitly do a
.BR close .
But if you kill the process by, say, "exec kill $pid",
you will need to explicitly call
.BR close .

The
.BR \-onexec
flag determines whether the spawn id will be closed in any new spawned
processes or if the process is overlayed.  To leave a spawn id open,
use the value 0.  A non-zero integer value will force the spawn closed
(the default) in any new processes.

The 
.B \-slave
flag closes the slave associated with the spawn id.  (See "spawn -pty".)
When the connection is closed, the slave is automatically closed as
well if still open.

No matter whether the connection is closed implicitly or explicitly,
you should call
.B wait
to clear up the corresponding kernel process slot.
.B close
does not call
.B wait
since there is no guarantee that closing a process connection will cause
it to exit.
See
.B wait
below for more info.
.TP
.BI debug " [[-now] 0|1]"
controls a Tcl debugger allowing you to step through statements, set
breakpoints, etc.

With no arguments, a 1 is returned if the debugger is not running, otherwise
a 0 is returned.

With a 1 argument, the debugger is started.  With a 0 argument, the
debugger is stopped.  If a 1 argument is preceded by the
.B \-now
flag, the debugger is started immediately (i.e., in the middle of the
.B debug
command itself).  Otherwise, the debugger is started with the next
Tcl statement.

The
.B debug
command does not change any traps.  Compare this to starting Expect with the 
.B -D
flag (see above).

See the README file or SEE ALSO (below)
for more information on the debugger.
.TP
.B disconnect
disconnects a forked process from the terminal.  It continues running in the
background.  The process is given its own process group (if possible).
Standard I/O is redirected to /dev/null.
.IP
The following fragment uses
.B disconnect
to continue running the script in the background.  
.nf

    if {[fork]!=0} exit
    disconnect
    . . .

.fi
The following script reads a password, and then runs a program
every hour that demands a password each time it is run.  The script supplies
the password so that you only have to type it once.
(See the
.B stty
command which demonstrates how to turn off password echoing.)
.nf

    send_user "password?\\ "
    expect_user -re "(.*)\\n"
    for {} 1 {} {
        if {[fork]!=0} {sleep 3600;continue}
        disconnect
        spawn priv_prog
        expect Password:
        send "$expect_out(1,string)\\r"
        . . .
        exit
    }

.fi
An advantage to using
.B disconnect
over the shell asynchronous process feature (&) is that
.B Expect
can
save the terminal parameters prior to disconnection, and then later
apply them to new ptys.  With &,
.B Expect
does not have a chance
to read the terminal's parameters since the terminal is already
disconnected by the time
.B Expect
receives control.
.TP
.BI exit " [\-opts] [status]"
causes
.B Expect
to exit or otherwise prepare to do so.

The
.B \-onexit
flag causes the next argument to be used as an exit handler.
Without an argument, the current exit handler is returned.

The
.B \-noexit
flag causes
.B Expect
to prepare to exit but stop short of actually returning control to the
operating system.  The user-defined exit handler is run as well as Expect's
own internal handlers.
No further Expect commands should be executed.
This is useful if you are running Expect with other Tcl extensions.
The current interpreter (and main window if in the Tk environment) remain
so that other Tcl extensions can clean up.  If Expect's
.B exit
is called again (however this might occur), the handlers are not rerun.

Upon exiting, 
all connections to spawned processes are closed.  Closure will be detected
as an EOF by spawned processes.
.B exit
takes no other actions beyond what the normal _exit(2) procedure does.
Thus, spawned processes that do not check for EOF may continue to run.
(A variety of conditions are important to determining, for example, what
signals a spawned process will be sent, but these are system-dependent,
typically documented under exit(3).)
Spawned processes that continue to run will be inherited by init.

.I status
(or 0 if not specified) is returned as the exit status of
.BR Expect .
.B exit
is implicitly executed if the end of the script is reached.
.TP
\fBexp_continue\fR [-continue_timer]
The command
.B exp_continue
allows
.B expect
itself to continue
executing rather than returning as it normally would. By
default
.B exp_continue
resets the timeout timer. The
.I -continue_timer
flag prevents timer from being restarted. (See
.B expect
for more information.)
.TP
.BI exp_internal " [\-f file] value"
causes further commands to send diagnostic information internal to
.B Expect
to stderr if
.I value
is non-zero.  This output is disabled if
.I value
is 0.  The diagnostic information includes every character received,
and every attempt made to match the current output against the patterns.
.IP
If the optional
.I file
is supplied, all normal and debugging output is written to that file
(regardless of the value of
.IR value ).
Any previous diagnostic output file is closed.

The
.B \-info
flag causes exp_internal to return a description of the
most recent non-info arguments given.
.TP
.BI exp_open " [args] [\-i spawn_id]"
returns a Tcl file identifier that corresponds to the original spawn id.
The file identifier can then be used as if it were opened by Tcl's
.B open
command.  (The spawn id should no longer be used.  A
.B wait
should not be executed.

The
.B \-leaveopen
flag leaves the spawn id open for access through 
Expect commands.  A
.B wait
must be executed on the spawn id.
.TP
.BI exp_pid " [\-i spawn_id]"
returns the process id corresponding to the currently spawned process.
If the
.B \-i
flag is used, the pid returned corresponds to that of the given spawn id.
.TP
.B exp_send
is an alias for
.BR send .
.TP
.B exp_send_error
is an alias for
.BR send_error .
.TP
.B exp_send_log
is an alias for
.BR send_log .
.TP
.B exp_send_tty
is an alias for
.BR send_tty .
.TP
.B exp_send_user
is an alias for
.BR send_user .
.TP
.BI exp_version " [[\-exit] version]"
is useful for assuring that the script is compatible with the current
version of Expect.
.IP
With no arguments, the current version of
.B Expect
is returned.  This version
may then be encoded in your script.  If you actually know that you are not
using features of recent versions, you can specify an earlier version.
.IP
Versions consist of three numbers separated by dots.  First
is the major number.  Scripts written for versions of
.B Expect
with a
different major number will almost certainly not work.
.B exp_version 
returns an error if the major numbers do not match.
.IP
Second is the minor number.  Scripts written for a version with a
greater minor number than the current version
may depend upon some new feature and might not run.
.B exp_version
returns an error if the major numbers match, but the script minor number
is greater than that of the running
.BR Expect .
.IP
Third is a number that plays no part in the version comparison.
However, it is incremented when the
.B Expect
software
distribution is changed in any way, such as by additional documentation
or optimization.  It is reset to 0 upon each new minor version.
.IP
With the
.B \-exit
flag,
.B Expect
prints an error and exits if the version is out of date.
.TP
.BI expect " [[\-opts] pat1 body1] ... [\-opts] patn [bodyn]"
waits until one of the patterns matches the output of a spawned process,
a specified time period has passed, or an end-of-file is seen.
If the final body is empty, it may be omitted.
.IP
Patterns from the most recent
.B expect_before
command are implicitly used before any other patterns.
Patterns from the most recent
.B expect_after
command are implicitly used after any other patterns.
.IP
If the arguments to the entire
.B expect
statement require more than one line,
all the arguments may be "braced" into one so as to avoid terminating each
line with a backslash.  In this one case, the usual Tcl substitutions will
occur despite the braces.
.IP
If a pattern is the keyword
.BR eof ,
the corresponding body is executed upon end-of-file.
If a pattern is the keyword
.BR timeout ,
the corresponding body is executed upon timeout.  If no timeout keyword
is used, an implicit null action is executed upon timeout.
The default timeout period is 10 seconds but may be set, for example to 30,
by the command "set timeout 30".  An infinite timeout may be designated
by the value \-1.
If a pattern is the keyword
.BR default ,
the corresponding body is executed upon either timeout or end-of-file.
.IP
If a pattern matches, then the corresponding body is executed.
.B expect
returns the result of the body (or the empty string if no pattern matched).
In the event that multiple patterns match, the one appearing first is
used to select a body.
.IP
Each time new output arrives, it is compared to each pattern in the order
they are listed.  Thus, you may test for absence of a match by making
the last pattern something guaranteed to appear, such as a prompt.
In situations where there is no prompt, you must use
.B timeout
(just like you would if you were interacting manually).
.IP
Patterns are specified in three ways.  By default, 
patterns are specified as with Tcl's
.B string match
command.  (Such patterns are also similar to C-shell regular expressions
usually referred to as "glob" patterns).  The
.B \-gl
flag may may
be used to protect patterns that might otherwise match
.B expect
flags from doing so.
Any pattern beginning with a "-" should be protected this way.  (All strings
starting with "-" are reserved for future options.)

.IP
For example, the following fragment looks for a successful login.
(Note that
.B abort
is presumed to be a procedure defined elsewhere in the script.)
.nf

.ta \w'      expect 'u +\w'invalid password    'u
    expect {
        busy               {puts busy\\n ; exp_continue}
        failed             abort
        "invalid password" abort
        timeout            abort
        connected
    }

.fi
Quotes are necessary on the fourth pattern since it contains a space, which
would otherwise separate the pattern from the action.
Patterns with the same action (such as the 3rd and 4th) require listing the
actions again.  This can be avoid by using regexp-style patterns (see below).
More information on forming glob-style patterns can be found in the Tcl manual.
.IP
Regexp-style patterns follow the syntax defined by Tcl's
.B regexp
(short for "regular expression") command.
regexp patterns are introduced with the flag
.BR \-re .
The previous example can be rewritten using a regexp as:
.nf

.ta \w'      expect 'u +\w'connected    'u
    expect {
        busy       {puts busy\\n ; exp_continue}
        \-re "failed|invalid password" abort
        timeout    abort
        connected
    }

.fi
Both types of patterns are "unanchored".  This means that patterns
do not have to match the entire string, but can begin and end the
match anywhere in the string (as long as everything else matches).
Use ^ to match the beginning of a string, and $ to match the end.
Note that if you do not wait for the end of a string, your responses
can easily end up in the middle of the string as they are echoed from
the spawned process.  While still producing correct results, the output
can look unnatural.  Thus, use of $ is encouraged if you can exactly
describe the characters at the end of a string.

Note that in many editors, the ^ and $ match the beginning and end of
lines respectively. However, because expect is not line oriented,
these characters match the beginning and end of the data (as opposed
to lines) currently in the expect matching buffer.  (Also, see the
note below on "system indigestion.")

The
.B \-ex
flag causes the pattern to be matched as an "exact" string.  No
interpretation of *, ^, etc is made (although the usual Tcl
conventions must still be observed).
Exact patterns are always unanchored.

.IP
The
.B \-nocase
flag causes uppercase characters of the output to compare as if they were
lowercase characters.  The pattern is not affected.
.IP
While reading output,
more than 2000 bytes can force earlier bytes to be "forgotten".
This may be changed with the function
.BR match_max .
(Note that excessively large values can slow down the pattern matcher.)
If
.I patlist
is
.BR full_buffer ,
the corresponding body is executed if
.I match_max
bytes have been received and no other patterns have matched.
Whether or not the
.B full_buffer
keyword is used, the forgotten characters are written to
expect_out(buffer).

If
.I patlist
is the keyword
.BR null ,
and nulls are allowed (via the
.B remove_nulls
command), the corresponding body is executed if a single ASCII
0 is matched.
It is not possible to
match 0 bytes via glob or regexp patterns.

Upon matching a pattern (or eof or full_buffer),
any matching and previously unmatched output is saved in the variable
.IR expect_out(buffer) .
Up to 9 regexp substring matches are saved in the variables
.I expect_out(1,string)
through
.IR expect_out(9,string) .
If the
.B -indices
flag is used before a pattern,
the starting and ending indices (in a form suitable for
.BR lrange )
of the
10 strings are stored in the variables
.I expect_out(X,start)
and
.I expect_out(X,end)
where X is a digit, corresponds to the substring position in the buffer.
0 refers to strings which matched the entire pattern
and is generated for glob patterns as well as regexp patterns.
For example, if a process has produced output of "abcdefgh\\n", the result of:
.nf

    expect "cd"

.fi
is as if the following statements had executed:
.nf

    set expect_out(0,string) cd
    set expect_out(buffer) abcd

.fi
and "efgh\\n" is left in the output buffer.
If a process produced the output "abbbcabkkkka\\n", the result of:
.nf

    expect \-indices \-re "b(b*).*(k+)"

.fi
is as if the following statements had executed:
.nf

    set expect_out(0,start) 1
    set expect_out(0,end) 10
    set expect_out(0,string) bbbcabkkkk
    set expect_out(1,start) 2
    set expect_out(1,end) 3
    set expect_out(1,string) bb
    set expect_out(2,start) 10
    set expect_out(2,end) 10
    set expect_out(2,string) k
    set expect_out(buffer) abbbcabkkkk

.fi
and "a\\n" is left in the output buffer.  The pattern "*" (and -re ".*") will
flush the output buffer without reading any more output from the
process.
.IP
Normally, the matched output is discarded from Expect's internal buffers.
This may be prevented by prefixing a pattern with the
.B \-notransfer
flag.  This flag is especially useful in experimenting (and can be
abbreviated to "-not" for convenience while experimenting).

The spawn id associated with the matching output (or eof or
full_buffer) is stored in
.IR expect_out(spawn_id) .

The
.B \-timeout
flag causes the current expect command to use the following value
as a timeout instead of using the value of the timeout variable.

By default, 
patterns are matched against output from the current process, however the
.B \-i
flag declares the output from the named spawn_id list be matched against
any following patterns (up to the next
.BR \-i ).
The spawn_id list should either be a whitespace separated list of spawn_ids
or a variable referring to such a list of spawn_ids.

For example, the following example waits for
"connected" from the current process, or "busy", "failed" or "invalid
password" from the spawn_id named by $proc2.
.nf

    expect {
        \-i $proc2 busy {puts busy\\n ; exp_continue}
        \-re "failed|invalid password" abort
        timeout abort
        connected
    }

.fi
The value of the global variable
.I any_spawn_id
may be used to match patterns to any spawn_ids that are named
with all other
.B \-i
flags in the current
.B expect
command.
The spawn_id from a
.B \-i
flag with no associated pattern (i.e., followed immediately
by another
.BR \-i )
is made available to any other patterns
in the same
.B expect
command associated with
.I any_spawn_id.

The
.B \-i
flag may also name a global variable in which case the variable is read
for a list of spawn ids.  The variable is reread whenever it changes.
This provides a way of changing the I/O source while the command is in
execution.  Spawn ids provided this way are called "indirect" spawn ids.

Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
The command
.B exp_continue
allows
.B expect
itself to continue
executing rather than returning as it normally would.
.IP
This is useful for avoiding explicit loops or repeated expect statements.
The following example is part of a fragment to automate rlogin.  The
.B exp_continue
avoids having to write a second
.B expect
statement (to look for the prompt again) if the rlogin prompts for a password.
.nf

    expect {
        Password: {
            stty -echo
            send_user "password (for $user) on $host: "
            expect_user -re "(.*)\\n"
            send_user "\\n"
            send "$expect_out(1,string)\\r"
            stty echo
            exp_continue
        } incorrect {
            send_user "invalid password or account\\n"
            exit
        } timeout {
            send_user "connection to $host timed out\\n"
            exit
        } eof {
            send_user \\
                "connection to host failed: $expect_out(buffer)"
            exit
        } -re $prompt
    }

.fi
For example, the following fragment might help a user guide
an interaction that is already totally automated.  In this case, the terminal
is put into raw mode.  If the user presses "+", a variable is incremented.
If "p" is pressed, several returns are sent to the process,
perhaps to poke it in some way, and "i" lets the user interact with the
process, effectively stealing away control from the script.
In each case, the
.B exp_continue
allows the current
.B expect
to continue pattern matching after executing the
current action.
.nf

    stty raw \-echo
    expect_after {
        \-i $user_spawn_id
        "p" {send "\\r\\r\\r"; exp_continue}
        "+" {incr foo; exp_continue}
        "i" {interact; exp_continue}
        "quit" exit
    }

.fi
.IP
By default,
.B exp_continue
resets the timeout timer.  The timer is not restarted, if
.B exp_continue
is called with the 
.B \-continue_timer
flag.
.TP
.BI expect_after " [expect_args]"
works identically to the
.B expect_before
except that if patterns from both
.B expect
and
.B expect_after
can match, the
.B expect
pattern is used.  See the
.B expect_before
command for more information.
.TP
.BI expect_background " [expect_args]"
takes the same arguments as
.BR expect ,
however it returns immediately.
Patterns are tested whenever new input arrives.
The pattern
.B timeout
and
.B default
are meaningless to
.BR expect_background
and are silently discarded.
Otherwise, the
.B expect_background
command uses
.B expect_before
and
.B expect_after
patterns just like
.B expect
does.

When
.B expect_background
actions are being evaluated, background processing for the same
spawn id is blocked.  Background processing is unblocked when
the action completes.  While background processing is blocked,
it is possible to do a (foreground)
.B expect
on the same spawn id.

It is not possible to execute an
.B expect
while an
.B expect_background
is unblocked.
.B expect_background
for a particular spawn id is deleted by
declaring a new expect_background with the same spawn id.  Declaring
.B expect_background
with no pattern removes the given spawn id
from the ability to match patterns in the background.
.TP
.BI expect_before " [expect_args]"
takes the same arguments as
.BR expect ,
however it returns immediately.
Pattern-action pairs from the most recent
.B expect_before
with the same spawn id are implicitly added to any following
.B expect
commands.  If a pattern matches, it is treated as if it had been
specified in the
.B expect
command itself, and the associated body is executed in the context
of the
.B expect
command.
If patterns from both
.B expect_before
and
.B expect
can match, the
.B expect_before
pattern is used.

If no pattern is specified, the spawn id is not checked for any patterns.

Unless overridden by a
.B \-i
flag,
.B expect_before
patterns match against the spawn id defined at the time that the 
.B expect_before
command was executed (not when its pattern is matched).

The \-info flag causes
.B expect_before
to return the current specifications of what patterns it will match.
By default, it reports on the current spawn id.  An optional spawn id specification may be given for information on that spawn id.  For example
.nf

    expect_before -info -i $proc

.fi
At most one spawn id specification may be given.  The flag \-indirect
suppresses direct spawn ids that come only from indirect specifications.

Instead of a spawn id specification, the flag "-all" will cause
"-info" to report on all spawn ids.

The output of the \-info flag can be reused as the argument to expect_before.
.TP
.BI expect_tty " [expect_args]"
is like
.B expect
but it reads characters from /dev/tty (i.e. keystrokes from the user).
By default, reading is performed in cooked mode.
Thus, lines must end with a return in order for
.B expect
to see them.
This may be changed via
.B stty
(see the
.B stty
command below).
.TP
.BI expect_user " [expect_args]"
is like
.B expect
but it reads characters from stdin (i.e. keystrokes from the user).
By default, reading is performed in cooked mode.
Thus, lines must end with a return in order for
.B expect
to see them.
This may be changed via
.B stty
(see the
.B stty
command below).
.TP
.B fork
creates a new process.  The new process is an exact copy of the current
.B Expect
process.  On success,
.B fork
returns 0 to the new (child) process and returns the process ID of the child
process to the parent process.
On failure (invariably due to lack of resources, e.g., swap space, memory),
.B fork
returns \-1 to the parent process, and no child process is created.
.IP
Forked processes exit via the
.B exit
command, just like the original process.
Forked processes are allowed to write to the log files.  If you do not
disable debugging or logging in most of the processes, the result can be
confusing.
.IP
Some pty implementations may be confused by multiple readers and writers,
even momentarily.  Thus, it is safest to
.B fork
before spawning processes.
.TP
.BI interact " [string1 body1] ... [stringn [bodyn]]"
gives control of the current process to the user, so that
keystrokes are sent to the current process,
and the stdout and stderr of the current process are returned.
.IP
String-body pairs may be specified as arguments, in which case the
body is executed when the corresponding string is entered.  (By default, the
string is not sent to the current process.)   The
.B interpreter
command is assumed, if the final body is missing.
.IP
If the arguments to the entire
.B interact
statement require more than one line,
all the arguments may be "braced" into one so as to avoid terminating each
line with a backslash.  In this one case, the usual Tcl substitutions will
occur despite the braces.
.IP
For example, the following command runs interact with the following
string-body pairs defined:  When ^Z is pressed,
.B Expect
is suspended.
(The
.B \-reset
flag restores the terminal modes.)
When ^A is pressed, the user sees "you typed a control-A" and the
process is sent a ^A.  When $ is pressed, the user sees the date.
When ^C is pressed,
.B Expect
exits.  If "foo" is entered, the user sees "bar".
When ~~ is pressed, the
.B Expect
interpreter runs interactively.
.nf

.ta \w'    interact 'u +\w'$CTRLZ  'u +\w'{'u
    set CTRLZ \\032
    interact {
        -reset $CTRLZ {exec kill \-STOP [pid]}
        \\001   {send_user "you typed a control\-A\\n";
                send "\\001"
               }
        $      {send_user "The date is [clock format [clock seconds]]."}
        \\003   exit
        foo    {send_user "bar"}
        ~~
    }

.fi
.IP
In string-body pairs, strings are matched in the order they are listed
as arguments.  Strings that partially match are not sent to the
current process in anticipation of the remainder coming.  If
characters are then entered such that there can no longer possibly be
a match, only the part of the string will be sent to the process that cannot
possibly begin another match.  Thus, strings that are substrings of
partial matches can match later, if the original strings that was attempting
to be match ultimately fails.
.IP
By default, string matching is exact with no wild cards.  (In contrast,
the
.B expect
command uses glob-style patterns by default.)  The
.B \-ex
flag may be used to protect patterns that might otherwise match
.B interact
flags from doing so.
Any pattern beginning with a "-" should be protected this way.    (All strings
starting with "-" are reserved for future options.)

The
.B \-re
flag forces the string to be interpreted as a regexp-style pattern.  In this
case, matching substrings are stored in the variable
.I interact_out
similarly to the way
.B expect
stores its output in the variable
.BR expect_out .
The
.B \-indices
flag is similarly supported.

The pattern
.B eof
introduces an action that is 
executed upon end-of-file.  A separate
.B eof
pattern may also follow the
.B \-output
flag in which case it is matched if an eof is detected while writing output.
The default
.B eof
action is "return", so that
.B interact
simply returns upon any EOF.

The pattern
.B timeout
introduces a timeout (in seconds) and action that is executed
after no characters have been read for a given time.
The
.B timeout
pattern applies to the most recently specified process.
There is no default timeout.
The special variable "timeout" (used by the
.B expect
command) has no affect on this timeout.

For example, the following statement could be used to autologout users who have
not typed anything for an hour but who still get frequent system
messages:
.nf

    interact -input $user_spawn_id timeout 3600 return -output \\
        $spawn_id 

.fi

If the pattern is the keyword
.BR null ,
and nulls are allowed (via the
.B remove_nulls
command), the corresponding body is executed if a single ASCII
0 is matched.
It is not possible to
match 0 bytes via glob or regexp patterns.

Prefacing a pattern with the flag
.B \-iwrite
causes the variable
.I interact_out(spawn_id)
to be set to the spawn_id which matched the pattern
(or eof).

Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
However
.B return
causes interact to return to its caller, while
.B inter_return
causes
.B interact
to cause a return in its caller.  For example, if "proc foo" called
.B interact
which then executed the action
.BR inter_return ,
.B proc foo
would return.  (This means that if
.B interact
calls
.B interpreter
interactively typing
.B return
will cause the interact to continue, while
.B inter_return
will cause the interact to return to its caller.)
.IP
During
.BR interact ,
raw mode is used so that all characters may be passed to the current process.
If the current process does not catch job control signals,
it will stop if sent a stop signal (by default ^Z).
To restart it, send a continue signal (such as by "kill \-CONT <pid>").
If you really want to send a SIGSTOP to such a process (by ^Z),
consider spawning csh first and then running your program.
On the other hand, if you want to send a SIGSTOP to
.B Expect
itself, first call interpreter (perhaps by using an escape character), and then press ^Z.
.IP
String-body pairs can be used as a shorthand for avoiding having
to enter the interpreter and execute commands interactively.  The previous
terminal mode is used while the body of a string-body pair is being executed.
.IP
For speed, actions execute in raw mode by default.  The
.B \-reset
flag resets the terminal to the mode it had before
.B interact
was executed (invariably, cooked mode).
Note that characters entered when the mode is being switched may be lost
(an unfortunate feature of the terminal driver on some systems).
The only reason to use
.B \-reset
is if your action
depends on running in cooked mode.
.IP
The
.B \-echo
flag sends characters that match the following pattern back to the process
that generated them as each character is read.  This may be useful
when the user needs to see feedback from partially typed patterns.
.IP
If a pattern is being echoed but eventually fails to match,
the characters are sent to the spawned process.  If the spawned
process then echoes them, the user will see the characters twice.
.B \-echo
is probably only appropriate in situations where the user is
unlikely to not complete the pattern.  For example, the following
excerpt is from rftp, the recursive-ftp script, where the user is
prompted to enter ~g, ~p, or ~l, to get, put, or list the current
directory recursively.  These are so far away from the normal ftp
commands, that the user is unlikely to type ~ followed by anything
else, except mistakenly, in which case, they'll probably just ignore
the result anyway.
.nf

    interact {
        -echo ~g {getcurdirectory 1}
        -echo ~l {getcurdirectory 0}
        -echo ~p {putcurdirectory}
    }

.fi
The
.B \-nobuffer
flag sends characters that match the following pattern on to
the output process as characters are read.

This is useful when you wish to let a program echo back the pattern.
For example, the following might be used to monitor where a person is
dialing (a Hayes-style modem).  Each time "atd" is seen the script
logs the rest of the line.
.nf

    proc lognumber {} {
        interact -nobuffer -re "(.*)\\r" return
        puts $log "[clock format [clock seconds]]: dialed $interact_out(1,string)"
    }

    interact -nobuffer "atd" lognumber

.fi
.IP
During
.BR interact ,
previous use of
.B log_user
is ignored.  In particular,
.B interact
will force its output to be logged (sent to the standard output)
since it is presumed the user doesn't wish to interact blindly.
.IP
The
.B \-o
flag causes any following key-body pairs to be applied to the output of
the current process.
This can be useful, for example, when dealing with hosts that
send unwanted characters during a telnet session.  
.IP
By default, 
.B interact
expects the user to be writing stdin and reading stdout of the
.B Expect
process
itself.
The
.B \-u
flag (for "user") makes
.B interact
look for the user as the process named by its argument
(which must be a spawned id).  
.IP
This allows two unrelated processes to be joined
together without using an explicit loop.  To aid in debugging, Expect
diagnostics always go to stderr (or stdout for certain logging and
debugging information).  For the same reason, the
.B interpreter
command will read interactively from stdin.
.IP
For example, the following fragment creates a login process.
Then it dials the user (not shown), and finally connects the two together.
Of course, any process may be substituted for login.
A shell, for example, would allow the user to work without supplying an
account and password.
.nf

    spawn login
    set login $spawn_id
    spawn tip modem
    # dial back out to user
    # connect user to login
    interact \-u $login

.fi
To send output to multiple processes, list each spawn id list prefaced by a
.B \-output
flag.  Input for a group of output spawn ids may be determined
by a spawn id list prefaced by a
.B \-input
flag.  (Both
.B \-input
and
.B \-output
may take lists in the same form as the
.B \-i
flag in the
.B expect
command, except that any_spawn_id is not meaningful in
.BR interact .)
All following flags and
strings (or patterns) apply to this input until another -input flag appears.
If no
.B \-input
appears,
.B \-output
implies "\-input $user_spawn_id \-output".
(Similarly, with patterns that do not have
.BR \-input .)
If one
.B \-input
is specified, it overrides $user_spawn_id.  If a second
.B \-input
is specified,
it overrides $spawn_id.  Additional
.B \-input
flags may be specified.

The two implied input processes default to having their outputs specified as
$spawn_id and $user_spawn_id (in reverse).  
If a
.B \-input
flag appears
with no
.B \-output
flag, characters from that process are discarded.

The
.B \-i
flag introduces a replacement for the current spawn_id when no
other
.B \-input
or
.B \-output
flags are used.  A \-i flag implies a \-o flag.

It is possible to change the processes that are being interacted with
by using indirect spawn ids.  (Indirect spawn ids are described in the
section on the expect command.)  Indirect spawn ids may be specified
with the -i, -u, -input, or -output flags.
.TP
.B interpreter " [args]"
causes the user to be interactively prompted for
.B Expect
and Tcl commands.
The result of each command is printed.
.IP
Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
However
.B return
causes interpreter to return to its caller, while
.B inter_return
causes
.B interpreter
to cause a return in its caller.  For example, if "proc foo" called
.B interpreter
which then executed the action
.BR inter_return ,
.B proc foo
would return.
Any other command causes
.B interpreter
to continue prompting for new commands.
.IP
By default, the prompt contains two integers.
The first integer describes the depth of
the evaluation stack (i.e., how many times Tcl_Eval has been called).  The
second integer is the Tcl history identifier.  The prompt can be set by
defining a procedure called "prompt1" whose return value becomes the next
prompt.  If a statement has open quotes, parens, braces, or brackets, a
secondary prompt (by default "+> ") is issued upon newline.  The secondary
prompt may be set by defining a procedure called "prompt2".
.IP
During
.BR interpreter ,
cooked mode is used, even if the its caller was using raw mode.
.IP
If stdin is closed,
.B interpreter
will return unless the
.B \-eof
flag is used, in which case the subsequent argument is invoked.
.TP
.BI log_file " [args] [[\-a] file]"
If a filename is provided,
.B log_file
will record a transcript of the session (beginning at that point) in the file.
.B log_file
will stop recording if no argument is given.  Any previous log file is closed.

Instead of a filename, a Tcl file identifier may be provided by using the
.B \-open
or
.B \-leaveopen
flags.  This is similar to the
.B spawn
command.  (See
.B spawn
for more info.)

The
.B \-a
flag forces output to be logged that was suppressed by the
.B log_user
command.

By default, the
.B log_file
command
.I appends
to old files rather than truncating them,
for the convenience of being able to turn logging off and on multiple
times in one session.
To truncate files, use the
.B \-noappend
flag.

The
.B -info
flag causes log_file to return a description of the
most recent non-info arguments given.
.TP
.BI log_user " -info|0|1"
By default, the send/expect dialogue is logged to stdout
(and a logfile if open).
The logging to stdout is disabled by the command "log_user 0"
and reenabled by "log_user 1".  Logging to the logfile is unchanged.

The
.B -info
flag causes log_user to return a description of the
most recent non-info arguments given.
.TP
.BI match_max " [\-d] [\-i spawn_id] [size]"
defines the size of the buffer (in bytes) used internally by
.BR expect .
With no
.I size
argument, the current size is returned.
.IP
With the
.B \-d
flag, the default size is set.  (The initial default is 2000.)
With the
.B \-i
flag, the size is set for the named spawn id, otherwise it is set for
the current process.
.TP
.BI overlay " [\-# spawn_id] [\-# spawn_id] [...] program [args]"
executes
.IR "program args"
in place of the current
.B Expect
program, which terminates.
A bare hyphen argument forces a hyphen in front of the command name as if
it was a login shell.
All spawn_ids are closed except for those named as arguments.  These
are mapped onto the named file identifiers.
.IP
Spawn_ids are mapped to file identifiers for the new program to inherit.
For example, the following line runs chess and allows it to be
controlled by the current process \- say, a chess master.
.nf

    overlay \-0 $spawn_id \-1 $spawn_id \-2 $spawn_id chess

.fi
This is more efficient than
"interact \-u", however, it sacrifices the ability to do programmed
interaction since the
.B Expect
process is no longer in control.
.IP
Note that no controlling terminal is provided.  Thus, if you
disconnect or remap standard input, programs that do
job control (shells, login, etc) will not function properly.
.TP
.BI parity " [\-d] [\-i spawn_id] [value]"
defines whether parity should be retained or stripped from the output of
spawned processes.  If
.I value
is zero, parity is stripped, otherwise it is not stripped.
With no
.I value
argument, the current value is returned.
.IP
With the
.B \-d
flag, the default parity value is set.  (The initial default is 1, i.e., 
parity is not stripped.)
With the
.B \-i
flag, the parity value is set for the named spawn id, otherwise it is set for
the current process.
.TP
.BI remove_nulls " [\-d] [\-i spawn_id] [value]"
defines whether nulls are retained or removed from the output of
spawned processes before pattern matching
or storing in the variable
.I expect_out 
or
.IR interact_out .
If
.I value
is 1, nulls are removed.  If
.I value
is 0, nulls are not removed.
With no
.I value
argument, the current value is returned.
.IP
With the
.B \-d
flag, the default value is set.  (The initial default is 1, i.e., 
nulls are removed.)
With the
.B \-i
flag, the value is set for the named spawn id, otherwise it is set for
the current process.

Whether or not nulls are removed,
.B Expect
will record null bytes to the log and stdout.
.TP
.BI send " [\-flags] string"
Sends
.IR string
to the current process.
For example, the command
.nf

    send "hello world\\r"

.fi
sends the characters, h e l l o <blank> w o r l d <return> to the 
current process.  
(Tcl includes a printf-like command (called
.BR format )
which can build arbitrarily complex strings.)
.IP
Characters are sent immediately although programs with line-buffered input
will not read the characters until a return character is sent.  A return
character is denoted "\\r".

The
.B \-\-
flag forces the next argument to be interpreted as a string rather than a flag.
Any string can be preceded by "\-\-" whether or not it actually looks
like a flag.  This provides a reliable mechanism to specify variable strings
without being tripped up by those that accidentally look like flags.
(All strings starting with "-" are reserved for future options.)

The
.B \-i
flag declares that the string be sent to the named spawn_id.
If the spawn_id is
.IR user_spawn_id ,
and the terminal is in raw mode, newlines in the string are translated
to return-newline
sequences so that they appear as if the terminal was in cooked mode.
The
.B \-raw
flag disables this translation.

The
.BR \-null
flag sends null characters (0 bytes).  By default, one null is sent.
An integer may follow the
.BR \-null
to indicate how many nulls to send.

The
.B \-break
flag generates a break condition.  This only makes sense if the spawn
id refers to a tty device opened via "spawn -open".  If you have
spawned a process such as tip, you should use tip's convention for
generating a break.

The
.B \-s
flag forces output to be sent "slowly", thus avoid the common situation
where a computer outtypes an input buffer that was designed for a
human who would never outtype the same buffer.  This output is
controlled by the value of the variable "send_slow" which takes a two
element list.  The first element is an integer that describes the
number of bytes to send atomically.  The second element is a real
number that describes the number of seconds by which the atomic sends
must be separated.  For example, "set send_slow {10 .001}" would force
"send \-s" to send strings with 1 millisecond in between each 10
characters sent.

The
.B \-h
flag forces output to be sent (somewhat) like a human actually typing.
Human-like delays appear between the characters.  (The algorithm is
based upon a Weibull distribution, with modifications to suit this
particular application.)  This output is controlled by the value of
the variable "send_human" which takes a five element list.  The first
two elements are average interarrival time of characters in seconds.
The first is used by default.  The second is used at word endings, to
simulate the subtle pauses that occasionally occur at such
transitions.  The third parameter is a measure of variability where .1
is quite variable, 1 is reasonably variable, and 10 is quite
invariable.  The extremes are 0 to infinity.  The last two parameters
are, respectively, a minimum and maximum interarrival time.
The minimum and maximum are used last and "clip" the final time.
The ultimate average can be quite different from the given average
if the minimum and maximum clip enough values.

As an
example, the following command emulates a fast and
consistent typist:
.nf

    set send_human {.1 .3 1 .05 2}
    send \-h "I'm hungry.  Let's do lunch."

.fi
while the following might be more suitable after a hangover:
.nf

    set send_human {.4 .4 .2 .5 100}
    send \-h "Goodd party lash night!"

.fi
Note that errors are not simulated, although you can set up error
correction situations yourself by embedding mistakes and corrections
in a send argument.

The flags for sending null characters, for sending breaks, for forcing slow
output and for human-style output are mutually exclusive. Only the one
specified last will be used. Furthermore, no
.I string
argument can be specified with the flags for sending null characters or breaks.

It is a good idea to precede the first
.B send
to a process by an
.BR expect .
.B expect
will wait for the process to start, while
.B send
cannot.
In particular, if the first
.B send
completes before the process starts running,
you run the risk of having your data ignored.
In situations where interactive programs offer no initial prompt,
you can precede
.B send
by a delay as in:
.nf

    # To avoid giving hackers hints on how to break in,
    # this system does not prompt for an external password.
    # Wait for 5 seconds for exec to complete
    spawn telnet very.secure.gov
    sleep 5
    send password\\r

.fi
.B exp_send
is an alias for
.BI send .
If you are using Expectk or some other variant of Expect in the Tk environment,
.B send
is defined by Tk for an entirely different purpose.
.B exp_send
is provided for compatibility between environments.
Similar aliases are provided for other Expect's other send commands.
.TP
.BI send_error " [\-flags] string"
is like
.BR send ,
except that the output is sent to stderr rather than the current
process.
.TP
.BI send_log " [\--] string"
is like
.BR send ,
except that the string is only sent to the log file (see
.BR log_file .)
The arguments are ignored if no log file is open.
.TP
.BI send_tty " [\-flags] string"
is like
.BR send ,
except that the output is sent to /dev/tty rather than the current
process.
.TP
.BI send_user " [\-flags] string"
is like
.BR send ,
except that the output is sent to stdout rather than the current
process.
.TP
.BI sleep " seconds"
causes the script to sleep for the given number of seconds.
Seconds may be a decimal number.  Interrupts (and Tk events if you
are using Expectk) are processed while Expect sleeps.
.TP
.BI spawn " [args] program [args]"
creates a new process running
.IR "program args" .
Its stdin, stdout and stderr are connected to Expect,
so that they may be read and written by other
.B Expect
commands.
The connection is broken by
.B close
or if the process itself closes any of the file identifiers.
.IP
When a process is started by
.BR spawn ,
the variable
.I spawn_id
is set to a descriptor referring to that process.
The process described by
.I spawn_id
is considered the
.IR "current process" .
.I spawn_id
may be read or written, in effect providing job control.
.IP
.I user_spawn_id
is a global variable containing a descriptor which refers to the user.
For example, when
.I spawn_id
is set to this value,
.B expect
behaves like
.BR expect_user .

.I
.I error_spawn_id
is a global variable containing a descriptor which refers to the standard
error.
For example, when
.I spawn_id
is set to this value,
.B send
behaves like
.BR send_error .
.IP
.I tty_spawn_id
is a global variable containing a descriptor which refers to /dev/tty.
If /dev/tty does not exist (such as in a cron, at, or batch script), then
.I tty_spawn_id
is not defined.  This may be tested as:
.nf

    if {[info vars tty_spawn_id]} {
        # /dev/tty exists
    } else {
        # /dev/tty doesn't exist
        # probably in cron, batch, or at script
    }

.fi
.IP
.B spawn
returns the UNIX process id.  If no process is spawned, 0 is returned.
The variable
.I spawn_out(slave,name)
is set to the name of the pty slave device.
.IP
By default,
.B spawn
echoes the command name and arguments.  The
.B \-noecho
flag stops
.B spawn
from doing this.
.IP
The
.B \-console
flag causes console output to be redirected to the spawned process.
This is not supported on all systems.

Internally,
.B spawn
uses a pty, initialized the same way as the user's tty.  This is further
initialized so that all settings are "sane" (according to stty(1)).
If the variable
.I stty_init
is defined, it is interpreted in the style of stty arguments
as further configuration.
For example, "set stty_init raw" will cause further spawned processes's
terminals to start in raw mode.
.B \-nottycopy
skips the initialization based on the user's tty.
.B \-nottyinit
skips the "sane" initialization.
.IP
Normally,
.B spawn
takes little time to execute.  If you notice spawn taking a
significant amount of time, it is probably encountering ptys that are
wedged.  A number of tests are run on ptys to avoid entanglements with
errant processes.  (These take 10 seconds per wedged pty.)  Running
Expect with the
.B \-d
option will show if
.B Expect
is encountering many ptys in odd states.  If you cannot kill
the processes to which these ptys are attached, your only recourse may
be to reboot.

If
.I program
cannot be spawned successfully because exec(2) fails (e.g. when
.I program
doesn't exist), an error message will be returned by the next
.B interact
or
.B expect
command as if
.I program
had run and produced the error message as output.
This behavior is a natural consequence of the implementation of
.BR spawn .
Internally, spawn forks, after which the spawned process has no
way to communicate with the original
.B Expect
process except by communication
via the spawn_id.

The
.B \-open
flag causes the next argument to be interpreted as a Tcl file identifier
(i.e., returned by
.BR open .)
The spawn id can then be used as if it were a spawned process.  (The file
identifier should no longer be used.)
This lets you treat raw devices, files, and
pipelines as spawned processes without using a pty.  0 is returned to
indicate there is no associated process.  When the connection to
the spawned process is closed, so is the Tcl file identifier.
The
.B \-leaveopen
flag is similar to
.B \-open
except that
.B \-leaveopen
causes the file identifier to be left open even after the spawn id is closed.

The
.B \-pty
flag causes a pty to be opened but no process spawned.  0 is returned
to indicate there is no associated process.  Spawn_id is set as usual.

The variable
.I spawn_out(slave,fd)
is set to a file identifier corresponding to the pty slave.
It can be closed using "close -slave".

The
.B \-ignore
flag names a signal to be ignored in the spawned process.
Otherwise, signals get the default behavior.
Signals are named as in the
.B trap
command, except that each signal requires a separate flag.
.TP
.BI strace " level"
causes following statements to be printed before being executed.
(Tcl's trace command traces variables.)
.I level
indicates how far down in the call stack to trace.
For example,
the following command runs
.B Expect
while tracing the first 4 levels of calls,
but none below that.
.nf

    expect \-c "strace 4" script.exp

.fi

The
.B -info
flag causes strace to return a description of the
most recent non-info arguments given.
.TP
.BI stty " args"
changes terminal modes similarly to the external stty command.

By default, the controlling terminal is accessed.  Other terminals can
be accessed by appending "< /dev/tty..." to the command.  (Note that
the arguments should not be grouped into a single argument.)

Requests for status return it as the result of the command.  If no status
is requested and the controlling terminal is accessed, the previous
status of the raw and echo attributes are returned in a form which can
later be used by the command.

For example, the arguments
.B raw
or
.B \-cooked
put the terminal into raw mode.
The arguments
.B \-raw
or
.B cooked
put the terminal into cooked mode.
The arguments
.B echo
and
.B \-echo
put the terminal into echo and noecho mode respectively.
.IP
The following example illustrates how to temporarily disable echoing.
This could be used in otherwise-automatic
scripts to avoid embedding passwords in them.
(See more discussion on this under EXPECT HINTS below.)
.nf

    stty \-echo
    send_user "Password: "
    expect_user -re "(.*)\\n"
    set password $expect_out(1,string)
    stty echo

.fi
.TP
.BI system " args"
gives
.I args
to sh(1) as input,
just as if it had been typed as a command from a terminal.
.B Expect
waits until the shell terminates.
The return status from sh is handled the same way that
.B exec
handles its return status.
.IP
In contrast to
.B exec
which redirects stdin and stdout to the script,
.B system
performs no redirection
(other than that indicated by the string itself).
Thus, it is possible to use programs which must talk directly to /dev/tty.
For the same reason, the results of
.B system
are not recorded in the log.
.TP
.BI timestamp " [args]"
returns a timestamp.
With no arguments, the number of
seconds since the epoch is returned.

The
.B \-format
flag introduces a string which is returned but with 
substitutions made according to the
POSIX rules for strftime.  For example %a is replaced by an abbreviated
weekday name (i.e., Sat).  Others are:
.nf
    %a      abbreviated weekday name
    %A      full weekday name
    %b      abbreviated month name
    %B      full month name
    %c      date-time as in: Wed Oct  6 11:45:56 1993
    %d      day of the month (01-31)
    %H      hour (00-23)
    %I      hour (01-12)
    %j      day (001-366)
    %m      month (01-12)
    %M      minute (00-59)
    %p      am or pm
    %S      second (00-61)
    %u      day (1-7, Monday is first day of week)
    %U      week (00-53, first Sunday is first day of week one)
    %V      week (01-53, ISO 8601 style)
    %w      day (0-6)
    %W      week (00-53, first Monday is first day of week one)
    %x      date-time as in: Wed Oct  6 1993
    %X      time as in: 23:59:59
    %y      year (00-99)
    %Y      year as in: 1993
    %Z      timezone (or nothing if not determinable)
    %%      a bare percent sign

.fi
Other % specifications are undefined.  Other characters will be passed
through untouched.  Only the C locale is supported.

The
.B \-seconds
flag introduces a number of seconds since the epoch to be used as a source
from which to format.  Otherwise, the current time is used.

The
.B \-gmt
flag forces timestamp output to use the GMT timezone.  With no flag,
the local timezone is used.
.TP
.BI trap " [[command] signals]"
causes the given 
.I command
to be executed upon future receipt of any of the given signals.
The command is executed in the global scope.
If
.I command
is absent, the signal action is returned.
If
.I command 
is the string SIG_IGN, the signals are ignored.
If
.I command
is the string SIG_DFL, the signals are result to the system default.
.I signals
is either a single signal or a list of signals.  Signals may be specified
numerically or symbolically as per signal(3).  The "SIG" prefix may be omitted.

With no arguments (or the argument \-number),
.B trap
returns the signal number of the trap command currently being executed.

The
.B \-code
flag uses the return code of the command in place of whatever code Tcl
was about to return when the command originally started running.

The
.B \-interp
flag causes the command to be evaluated using the interpreter
active at the time the command started running
rather than when the trap was declared.

The
.B \-name
flag causes the
.B trap
command to return the signal name of the trap command currently being executed.

The
.B \-max
flag causes the
.B trap
command to return the largest signal number that can be set.

For example, the command "trap {send_user "Ouch!"} SIGINT" will print "Ouch!"
each time the user presses ^C.

By default, SIGINT (which can usually be generated by pressing ^C) and 
SIGTERM cause Expect to exit.  This is due to the following trap, created
by default when Expect starts.
.nf

    trap exit {SIGINT SIGTERM}

.fi
If you use the -D flag to start the debugger, SIGINT is redefined
to start the interactive debugger.  This is due to the following trap:
.nf

    trap {exp_debug 1} SIGINT

.fi
The debugger trap can be changed by setting the environment variable
EXPECT_DEBUG_INIT to a new trap command.  

You can, of course, override both of these just by adding trap
commands to your script.  In particular, if you have your own "trap
exit SIGINT", this will override the debugger trap.  This is useful
if you want to prevent users from getting to the debugger at all.

If you want to define your own trap on SIGINT but still trap to the
debugger when it is running, use:
.nf

    if {![exp_debug]} {trap mystuff SIGINT}

.fi
Alternatively, you can trap to the debugger using some other signal.

.B trap
will not let you override the action for SIGALRM as this is used internally
to
.BR Expect .
The disconnect command sets SIGALRM to SIG_IGN (ignore).  You can reenable
this as long as you disable it during subsequent spawn commands.

See signal(3) for more info.
.TP
.BI wait " [args]"
delays until a spawned process (or
the current process if none is named) terminates.
.IP
.B wait
normally returns a list of four integers.
The first integer is the pid of the process that was waited upon.
The second integer is the corresponding spawn id.
The third integer is -1 if an operating system error occurred, or 0 otherwise.
If the third integer was 0, the fourth integer is the status returned by
the spawned process.  If the third integer was -1, the fourth integer is
the value of errno set by the operating system.  The global variable
errorCode is also set.

Additional elements may appear at the end of the return value from
.BR wait .
An optional fifth element identifies a class of information.
Currently, the only possible value for this element is CHILDKILLED in
which case the next two values are the C-style signal name and a short
textual description.
.IP
The
.B \-i
flag declares the process to wait corresponding to the named spawn_id
(NOT the process id).
Inside a SIGCHLD handler,
it is possible to wait for any spawned process by using the spawn id -1.

The
.B \-nowait
flag causes the wait to return immediately with the indication of a
successful wait.  When the process exits (later), it will automatically
disappear without the need for an explicit wait.

The
.B wait
command may also be used wait for a forked process using the arguments
"-i -1".  Unlike its use with spawned processes, this command can be
executed at any time.  There is no control over which process is
reaped.  However, the return value can be checked for the process id.

.SH LIBRARIES
Expect automatically knows about two built-in libraries for Expect scripts.
These are defined by the directories named in the variables
exp_library and exp_exec_library.  Both are meant to contain utility
files that can be used by other scripts.

exp_library contains architecture-independent files.  exp_exec_library
contains architecture-dependent files.  Depending on your system, both
directories may be totally empty.  The existence of the file
$exp_exec_library/cat-buffers describes whether your /bin/cat buffers
by default.
.SH PRETTY-PRINTING
A vgrind definition is available for pretty-printing
.B Expect
scripts.
Assuming the vgrind definition supplied with the
.B Expect
distribution is
correctly installed, you can use it as:
.nf

    vgrind \-lexpect file

.fi
.SH EXAMPLES
It many not be apparent how to put everything together that the man page
describes.  I encourage you to read and try out the examples in
the example directory of the
.B Expect
distribution.
Some of them are real programs.  Others are simply illustrative
of certain techniques, and of course, a couple are just quick hacks.
The INSTALL file has a quick overview of these programs.
.PP
The
.B Expect
papers (see SEE ALSO) are also useful.  While some papers
use syntax corresponding to earlier versions of Expect, the accompanying
rationales are still valid and go into a lot more detail than this
man page.
.SH CAVEATS
Extensions may collide with Expect's command names.  For example, 
.B send
is defined by Tk for an entirely different purpose.
For this reason, most of the
.B Expect
commands are also available as "exp_XXXX".
Commands and variables beginning with "exp", "inter", "spawn",
and "timeout" do not have aliases.
Use the extended command names if you need this compatibility between environments.

.B Expect
takes a rather liberal view of scoping.
In particular, variables read by commands specific to the
.B Expect
program will be sought first from the local scope, and if not found, in the
global scope.  For example, this
obviates the need to place "global timeout" in every
procedure you write that uses
.BR expect .
On the other hand, variables written are always in the local scope (unless
a "global" command has been issued).  The most common problem this causes
is when spawn is executed in a procedure.  Outside the procedure, 
.I spawn_id
no longer exists, so the spawned process is no longer accessible
simply because of scoping.  Add a "global spawn_id" to such a procedure.

If you cannot enable the multispawning capability
(i.e., your system supports neither select (BSD *.*), poll (SVR>2),
nor something equivalent),
.B Expect
will only be able to control a single process at a time.
In this case, do not attempt to set
.IR spawn_id ,
nor should you execute processes via exec while a spawned process
is running.  Furthermore, you will not be able to
.B expect
from multiple processes (including the user as one) at the same time.

Terminal parameters can have a big effect on scripts.  For example, if
a script is written to look for echoing, it will misbehave if echoing
is turned off.  For this reason, Expect forces sane terminal
parameters by default.  Unfortunately, this can make things unpleasant
for other programs.  As an example, the emacs shell wants to change
the "usual" mappings: newlines get mapped to newlines instead of
carriage-return newlines, and echoing is disabled.  This allows one to
use emacs to edit the input line.  Unfortunately, Expect cannot
possibly guess this.

You can request that Expect not override its default setting of
terminal parameters, but you must then be very careful when writing
scripts for such environments.  In the case of emacs, avoid depending
upon things like echoing and end-of-line mappings.

The commands that accepted arguments braced into a single list (the
.B expect
variants and
.BR interact )
use a heuristic to decide if the list is actually one argument or
many.  The heuristic can fail only in the case when the list actually
does represent a single argument which has multiple embedded \\n's
with non-whitespace characters between them.  This seems sufficiently
improbable, however the argument "\-nobrace" can be used to force a
single argument to be handled as a single argument.  This could
conceivably be used with machine-generated Expect code.  Similarly,
-brace forces a single argument to be handle as multiple patterns/actions.

.SH BUGS
It was really tempting to name the program "sex" (for either "Smart EXec"
or "Send-EXpect"), but good sense (or perhaps just Puritanism) prevailed.

On some systems, when a shell is spawned, it complains about not being
able to access the tty but runs anyway.  This means your system has a
mechanism for gaining the controlling tty that
.B Expect
doesn't know about.  Please find out what it is, and send this information
back to me.

Ultrix 4.1 (at least the latest versions around here) considers
timeouts of above 1000000 to be equivalent to 0.

Digital UNIX 4.0A (and probably other versions) refuses to allocate
ptys if you define a SIGCHLD handler.  See grantpt page for more info.

IRIX 6.0 does not handle pty permissions correctly so that if Expect
attempts to allocate a pty previously used by someone else, it fails.
Upgrade to IRIX 6.1.

Telnet (verified only under SunOS 4.1.2) hangs if TERM is not set.
This is a problem under cron, at and in cgi scripts, which do not
define TERM.  Thus, you must set it explicitly - to what type is
usually irrelevant.  It just has to be set to something!  The
following probably suffices for most cases.
.nf

    set env(TERM) vt100

.fi

Tip (verified only under BSDI BSD/OS 3.1 i386) hangs if SHELL and HOME
are not set.  This is a problem under cron, at and in cgi scripts,
which do not define these environment variables.  Thus, you must set
them explicitly - to what type is usually irrelevant.  It just has to
be set to something!  The following probably suffices for most cases.
.nf

    set env(SHELL) /bin/sh
    set env(HOME) /usr/local/bin

.fi


Some implementations of ptys are designed so that the kernel throws
away any unread output after 10 to 15 seconds (actual number is
implementation-dependent) after the process has closed the file
descriptor.  Thus
.B Expect
programs such as
.nf

    spawn date
    sleep 20
    expect

.fi
will fail.  To avoid this, invoke non-interactive programs with
.B exec
rather than
.BR spawn .
While such situations are conceivable, in practice I have never
encountered a situation in which the final output of a truly
interactive program would be lost due to this behavior.

On the other hand, Cray UNICOS ptys throw away any unread output
immediately after the process has closed the file descriptor.  I have
reported this to Cray and they are working on a fix.

Sometimes a delay is required between a prompt and a response, such as
when a tty interface is changing UART settings or matching baud rates
by looking for start/stop bits.  Usually, all this is require is to
sleep for a second or two.  A more robust technique is to retry until
the hardware is ready to receive input.  The following example uses
both strategies:
.nf

    send "speed 9600\\r";
    sleep 1
    expect {
        timeout {send "\\r"; exp_continue}
        $prompt
    }

.fi

trap \-code will not work with any command that sits in Tcl's event
loop, such as sleep.  The problem is that in the event loop, Tcl
discards the return codes from async event handlers.  A workaround is
to set a flag in the trap code.  Then check the flag immediately after
the command (i.e., sleep).

The expect_background command ignores -timeout arguments and has no
concept of timeouts in general.

.SH "EXPECT HINTS"
There are a couple of things about
.B Expect
that may be non-intuitive.
This section attempts to address some of these things with a couple of
suggestions.

A common expect problem is how to recognize shell prompts.  Since
these are customized differently by differently people and different
shells, portably automating rlogin can be difficult without knowing
the prompt.  A reasonable convention is to have users store a regular
expression describing their prompt (in particular, the end of it) in
the environment variable EXPECT_PROMPT.  Code like the following
can be used.  If EXPECT_PROMPT doesn't exist, the code still has a good chance of functioning correctly.
.nf

    set prompt "(%|#|\\\\$) $"          ;# default prompt
    catch {set prompt $env(EXPECT_PROMPT)}

    expect -re $prompt

.fi
I encourage you to write
.B expect
patterns that include the end of whatever
you expect to see.  This avoids the possibility of answering a question
before seeing the entire thing.  In addition, while you may well be
able to answer questions before seeing them entirely, if you answer
early,  your answer may appear echoed back in the middle of the question.
In other words, the resulting dialogue will be correct but look scrambled.

Most prompts include a space character at the end.
For example, the prompt from ftp is 'f', 't', 'p', '>' and <blank>.
To match this prompt, you must account for each of these characters.
It is a common mistake not to include the blank.
Put the blank in explicitly.

If you use a pattern of the form X*, the * will match all the output
received from the end of X to the last thing received.
This sounds intuitive but can be somewhat confusing because the phrase
"last thing received" can vary depending upon the speed of the computer
and the processing of I/O both by the kernel and the device driver.
.PP
In particular, humans tend to see program output arriving in huge chunks
(atomically) when in reality most programs produce output one
line at a time.  Assuming this is the case, the * in the pattern of the
previous paragraph may only match the end of the current line even though
there seems to be more, because at the time of the match that was all
the output that had been received.
.PP
.B expect
has no way of knowing that further output is coming unless your
pattern specifically accounts for it.
.PP
Even depending on line-oriented buffering is unwise.  Not only do programs
rarely make promises about the type of buffering they do, but system
indigestion can break output lines up so that lines break at seemingly
random places.  Thus, if you can express the last few characters
of a prompt when writing patterns, it is wise to do so.

If you are waiting for a pattern in the last output of a program
and the program emits something else instead, you will not be able to
detect that with the
.B timeout
keyword.  The reason is that
.B expect
will not timeout \- instead it will get an
.B eof
indication.
Use that instead.  Even better, use both.  That way if that line
is ever moved around, you won't have to edit the line itself.

Newlines are usually converted to carriage return, linefeed sequences
when output by the terminal driver.  Thus, if you want a pattern that
explicitly matches the two lines, from, say, printf("foo\\nbar"),
you should use the pattern "foo\\r\\nbar".
.PP
A similar translation occurs when reading from the user, via
.BR expect_user .
In this case, when you press return, it will be
translated to a newline.  If
.B Expect
then passes that to a program
which sets its terminal to raw mode (like telnet), there is going to
be a problem, as the program expects a true return.  (Some programs
are actually forgiving in that they will automatically translate
newlines to returns, but most don't.)  Unfortunately, there is no way to find
out that a program put its terminal into raw mode.
.PP
Rather than manually replacing newlines with returns, the solution is to
use the command "stty raw", which will stop the translation.
Note, however, that this means that you will no longer get the cooked
line-editing features.
.PP
.B interact
implicitly sets your terminal to raw mode so this problem will not arise then.

It is often useful to store passwords (or other private information)
in
.B Expect
scripts.  This is not recommended since anything that is
stored on a computer is susceptible to being accessed by anyone.
Thus, interactively prompting for passwords from a script is a smarter
idea than embedding them literally.  Nonetheless, sometimes such embedding
is the only possibility.
.PP
Unfortunately, the UNIX file system has no direct way of creating
scripts which are executable but unreadable.  Systems which support
setgid shell scripts may indirectly simulate this as follows:
.PP
Create the
.B Expect
script (that contains the secret data) as usual.
Make its permissions be 750 (\-rwxr\-x\-\-\-) and owned by a trusted group,
i.e., a group which is allowed to read it.  If necessary, create a new
group for this purpose.  Next, create a /bin/sh script with
permissions 2751 (\-rwxr\-s\-\-x) owned by the same group as before.
.PP
The result is a script which may be executed (and read) by anyone.
When invoked, it runs the
.B Expect
script.
.SH "SEE ALSO"
.BR Tcl (3),
.BR libexpect (3)
.br
.I
"Exploring Expect: A Tcl-Based Toolkit for Automating Interactive Programs"
\fRby Don Libes, pp. 602, ISBN 1-56592-090-2, O'Reilly and Associates, 1995.
.br
.I
"expect: Curing Those Uncontrollable Fits of Interactivity" \fRby Don Libes,
Proceedings of the Summer 1990 USENIX Conference,
Anaheim, California, June 11-15, 1990.
.br
.I
"Using
.B expect
to Automate System Administration Tasks" \fRby Don Libes,
Proceedings of the 1990 USENIX Large Installation Systems Administration
Conference, Colorado Springs, Colorado, October 17-19, 1990.
.br
.I
"Tcl: An Embeddable Command Language" \fRby John Ousterhout,
Proceedings of the Winter 1990 USENIX Conference,
Washington, D.C., January 22-26, 1990.
.br
.I
"expect: Scripts for Controlling Interactive Programs" \fRby Don Libes,
Computing Systems, Vol. 4, No. 2, University of California Press Journals,
November 1991.
.br
.I
"Regression Testing and Conformance Testing Interactive Programs", \fRby Don
Libes, Proceedings of the Summer 1992 USENIX Conference, pp. 135-144,
San Antonio, TX, June 12-15, 1992.
.br
.I
"Kibitz \- Connecting Multiple Interactive Programs Together", \fRby Don Libes,
Software \- Practice & Experience, John Wiley & Sons, West Sussex, England,
Vol. 23, No. 5, May, 1993.
.br
.I
"A Debugger for Tcl Applications", \fRby Don Libes,
Proceedings of the 1993 Tcl/Tk Workshop, Berkeley, CA, June 10-11, 1993.
.SH AUTHOR
Don Libes, National Institute of Standards and Technology
.SH ACKNOWLEDGMENTS
Thanks to John Ousterhout for Tcl, and Scott Paisley for inspiration.
Thanks to Rob Savoye for Expect's autoconfiguration code.
.PP
The HISTORY file documents much of the evolution of
.BR expect .
It makes interesting reading and might give you further insight to this
software.  Thanks to the people mentioned in it who sent me bug fixes
and gave other assistance.
.PP
Design and implementation of
.B Expect
was paid for in part by the U.S. government and is therefore in the public
domain.
However the author and NIST would like credit
if this program and documentation or portions of them are used.
