/*
* This file was automatically generated by ./src/scripts/dev_tools/gen_oids.py on 2025-06-04
*
* All manual edits to this file will be lost. Edit the script then regenerate this source file.
*
* Botan is released under the Simplified BSD License (see license.txt)
*/

#include <botan/internal/oid_map.h>

#include <initializer_list>
#include <unordered_map>

namespace Botan {

namespace {

// The hash can collide so we must verify the actual value matches before returning
std::optional<std::string_view> if_match(const OID& oid, std::initializer_list<uint32_t> val, std::string_view name) {
   if(oid.matches(val)) {
      return name;
   } else {
      return {};
   }
}

std::optional<OID> if_match(std::string_view req, std::string_view actual, std::initializer_list<uint32_t> oid) {
   if(req == actual) {
      return OID(oid);
   } else {
      return {};
   }
}

uint32_t hash_oid_name(std::string_view s) {
   uint64_t hash = 0x8188B31879A4879A;

   for(char c : s) {
      hash *= 251;
      hash += c;
   }

   return static_cast<uint32_t>(hash % 805289);
}

}  // namespace

//static
std::optional<std::string_view> OID_Map::lookup_static_oid(const OID& oid) {
   const uint32_t hc = static_cast<uint32_t>(oid.hash_code() % 858701);

   switch(hc) {
      case 0x01506:
         return if_match(oid, {1, 2, 840, 10045, 4, 3, 1}, "ECDSA/SHA-224");
      case 0x01507:
         return if_match(oid, {1, 2, 840, 10045, 4, 3, 2}, "ECDSA/SHA-256");
      case 0x01508:
         return if_match(oid, {1, 2, 840, 10045, 4, 3, 3}, "ECDSA/SHA-384");
      case 0x01509:
         return if_match(oid, {1, 2, 840, 10045, 4, 3, 4}, "ECDSA/SHA-512");
      case 0x04C1E:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 3029, 1, 2, 1}, "ElGamal");
      case 0x04E61:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 3029, 1, 5, 1}, "OpenPGP.Curve25519");
      case 0x0779B:
         return if_match(oid, {1, 2, 840, 113549, 2, 5}, "MD5");
      case 0x0779D:
         return if_match(oid, {1, 2, 840, 113549, 2, 7}, "HMAC(SHA-1)");
      case 0x0779E:
         return if_match(oid, {1, 2, 840, 113549, 2, 8}, "HMAC(SHA-224)");
      case 0x0779F:
         return if_match(oid, {1, 2, 840, 113549, 2, 9}, "HMAC(SHA-256)");
      case 0x077A0:
         return if_match(oid, {1, 2, 840, 113549, 2, 10}, "HMAC(SHA-384)");
      case 0x077A1:
         return if_match(oid, {1, 2, 840, 113549, 2, 11}, "HMAC(SHA-512)");
      case 0x077A3:
         return if_match(oid, {1, 2, 840, 113549, 2, 13}, "HMAC(SHA-512-256)");
      case 0x0785E:
         return if_match(oid, {1, 2, 840, 113549, 3, 7}, "TripleDES/CBC");
      case 0x0C904:
         return if_match(oid, {1, 0, 14888, 3, 0, 5}, "ECKCDSA");
      case 0x11547:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 1}, "SphincsPlus-shake-128s-r3.1");
      case 0x11548:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 2}, "SphincsPlus-shake-128f-r3.1");
      case 0x11549:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 3}, "SphincsPlus-shake-192s-r3.1");
      case 0x1154A:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 4}, "SphincsPlus-shake-192f-r3.1");
      case 0x1154B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 5}, "SphincsPlus-shake-256s-r3.1");
      case 0x1154C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 6}, "SphincsPlus-shake-256f-r3.1");
      case 0x11608:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 1}, "SphincsPlus-sha2-128s-r3.1");
      case 0x11609:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 2}, "SphincsPlus-sha2-128f-r3.1");
      case 0x1160A:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 3}, "SphincsPlus-sha2-192s-r3.1");
      case 0x1160B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 4}, "SphincsPlus-sha2-192f-r3.1");
      case 0x1160C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 5}, "SphincsPlus-sha2-256s-r3.1");
      case 0x1160D:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 6}, "SphincsPlus-sha2-256f-r3.1");
      case 0x116C9:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 1}, "SphincsPlus-haraka-128s-r3.1");
      case 0x116CA:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 2}, "SphincsPlus-haraka-128f-r3.1");
      case 0x116CB:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 3}, "SphincsPlus-haraka-192s-r3.1");
      case 0x116CC:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 4}, "SphincsPlus-haraka-192f-r3.1");
      case 0x116CD:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 5}, "SphincsPlus-haraka-256s-r3.1");
      case 0x116CE:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 6}, "SphincsPlus-haraka-256f-r3.1");
      case 0x1533B:
         return if_match(oid, {1, 2, 156, 10197, 1, 104, 2}, "SM4/CBC");
      case 0x15341:
         return if_match(oid, {1, 2, 156, 10197, 1, 104, 8}, "SM4/GCM");
      case 0x1539D:
         return if_match(oid, {1, 2, 156, 10197, 1, 104, 100}, "SM4/OCB");
      case 0x187D7:
         return if_match(oid, {1, 3, 14, 3, 2, 7}, "DES/CBC");
      case 0x187EA:
         return if_match(oid, {1, 3, 14, 3, 2, 26}, "SHA-1");
      case 0x19933:
         return if_match(oid, {1, 3, 132, 0, 8}, "secp160r1");
      case 0x19934:
         return if_match(oid, {1, 3, 132, 0, 9}, "secp160k1");
      case 0x19935:
         return if_match(oid, {1, 3, 132, 0, 10}, "secp256k1");
      case 0x19949:
         return if_match(oid, {1, 3, 132, 0, 30}, "secp160r2");
      case 0x1994A:
         return if_match(oid, {1, 3, 132, 0, 31}, "secp192k1");
      case 0x1994B:
         return if_match(oid, {1, 3, 132, 0, 32}, "secp224k1");
      case 0x1994C:
         return if_match(oid, {1, 3, 132, 0, 33}, "secp224r1");
      case 0x1994D:
         return if_match(oid, {1, 3, 132, 0, 34}, "secp384r1");
      case 0x1994E:
         return if_match(oid, {1, 3, 132, 0, 35}, "secp521r1");
      case 0x199F8:
         return if_match(oid, {1, 3, 132, 1, 12}, "ECDH");
      case 0x1E7BF:
         return if_match(oid, {1, 2, 156, 10197, 1, 301, 1}, "SM2");
      case 0x1E7C0:
         return if_match(oid, {1, 2, 156, 10197, 1, 301, 2}, "SM2_Kex");
      case 0x1E7C1:
         return if_match(oid, {1, 2, 156, 10197, 1, 301, 3}, "SM2_Enc");
      case 0x21960:
         return if_match(oid, {1, 3, 36, 3, 3, 1, 2}, "RSA/PKCS1v15(RIPEMD-160)");
      case 0x2198A:
         return if_match(oid, {1, 2, 840, 113533, 7, 66, 10}, "CAST-128/CBC");
      case 0x2198F:
         return if_match(oid, {1, 2, 840, 113533, 7, 66, 15}, "KeyWrap.CAST-128");
      case 0x227C0:
         return if_match(oid, {1, 3, 101, 110}, "X25519");
      case 0x227C1:
         return if_match(oid, {1, 3, 101, 111}, "X448");
      case 0x227C2:
         return if_match(oid, {1, 3, 101, 112}, "Ed25519");
      case 0x227C3:
         return if_match(oid, {1, 3, 101, 113}, "Ed448");
      case 0x27565:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 48, 1, 1}, "PKIX.OCSP.BasicResponse");
      case 0x27569:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 48, 1, 5}, "PKIX.OCSP.NoCheck");
      case 0x29F7C:
         return if_match(oid, {1, 2, 410, 200004, 1, 100, 4, 3}, "ECKCDSA/SHA-1");
      case 0x29F7D:
         return if_match(oid, {1, 2, 410, 200004, 1, 100, 4, 4}, "ECKCDSA/SHA-224");
      case 0x29F7E:
         return if_match(oid, {1, 2, 410, 200004, 1, 100, 4, 5}, "ECKCDSA/SHA-256");
      case 0x2AC3B:
         return if_match(oid, {2, 5, 29, 32, 0}, "X509v3.AnyPolicy");
      case 0x2B5C9:
         return if_match(oid, {1, 2, 840, 10045, 2, 1}, "ECDSA");
      case 0x2B74B:
         return if_match(oid, {1, 2, 840, 10045, 4, 1}, "ECDSA/SHA-1");
      case 0x3474A:
         return if_match(oid, {1, 2, 840, 10046, 2, 1}, "DH");
      case 0x38D6D:
         return if_match(oid, {1, 2, 643, 7, 1, 2, 1, 1, 1}, "gost_256A");
      case 0x38D6E:
         return if_match(oid, {1, 2, 643, 7, 1, 2, 1, 1, 2}, "gost_256B");
      case 0x38E2E:
         return if_match(oid, {1, 2, 643, 7, 1, 2, 1, 2, 1}, "gost_512A");
      case 0x38E2F:
         return if_match(oid, {1, 2, 643, 7, 1, 2, 1, 2, 2}, "gost_512B");
      case 0x38F2C:
         return if_match(oid, {1, 2, 643, 2, 2, 3}, "GOST-34.10/GOST-R-34.11-94");
      case 0x38F3C:
         return if_match(oid, {1, 2, 643, 2, 2, 19}, "GOST-34.10");
      case 0x3D7B8:
         return if_match(oid, {0, 3, 4401, 5, 3, 1, 9, 6}, "Camellia-128/GCM");
      case 0x3D7CC:
         return if_match(oid, {0, 3, 4401, 5, 3, 1, 9, 26}, "Camellia-192/GCM");
      case 0x3D7E0:
         return if_match(oid, {0, 3, 4401, 5, 3, 1, 9, 46}, "Camellia-256/GCM");
      case 0x3F20F:
         return if_match(oid, {1, 3, 36, 3, 2, 1}, "RIPEMD-160");
      case 0x4266E:
         return if_match(oid, {0, 4, 0, 127, 0, 15, 1, 1, 13, 0}, "XMSS");
      case 0x478C4:
         return if_match(oid, {1, 2, 410, 200004, 1, 4}, "SEED/CBC");
      case 0x47D98:
         return if_match(oid, {1, 2, 156, 10197, 1, 301}, "sm2p256v1");
      case 0x47DFC:
         return if_match(oid, {1, 2, 156, 10197, 1, 401}, "SM3");
      case 0x47E60:
         return if_match(oid, {1, 2, 156, 10197, 1, 501}, "SM2_Sig/SM3");
      case 0x47E63:
         return if_match(oid, {1, 2, 156, 10197, 1, 504}, "RSA/PKCS1v15(SM3)");
      case 0x52B13:
         return if_match(oid, {1, 2, 643, 3, 131, 1, 1}, "GOST.INN");
      case 0x635AE:
         return if_match(oid, {1, 2, 250, 1, 223, 101, 256, 1}, "frp256v1");
      case 0x6EB86:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 6, 1}, "GOST-34.10-2012-256/SHA-256");
      case 0x6EC47:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 7, 1}, "Kyber-512-r3");
      case 0x6EC48:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 7, 2}, "Kyber-768-r3");
      case 0x6EC49:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 7, 3}, "Kyber-1024-r3");
      case 0x6EDC9:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 9, 1}, "Dilithium-4x4-r3");
      case 0x6EDCA:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 9, 2}, "Dilithium-6x5-r3");
      case 0x6EDCB:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 9, 3}, "Dilithium-8x7-r3");
      case 0x6EE8A:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 10, 1}, "Dilithium-4x4-AES-r3");
      case 0x6EE8B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 10, 2}, "Dilithium-6x5-AES-r3");
      case 0x6EE8C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 10, 3}, "Dilithium-8x7-AES-r3");
      case 0x6EF4B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 11, 1}, "Kyber-512-90s-r3");
      case 0x6EF4C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 11, 2}, "Kyber-768-90s-r3");
      case 0x6EF4D:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 11, 3}, "Kyber-1024-90s-r3");
      case 0x6F18E:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 14, 1}, "FrodoKEM-640-SHAKE");
      case 0x6F18F:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 14, 2}, "FrodoKEM-976-SHAKE");
      case 0x6F190:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 14, 3}, "FrodoKEM-1344-SHAKE");
      case 0x6F24F:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 15, 1}, "FrodoKEM-640-AES");
      case 0x6F250:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 15, 2}, "FrodoKEM-976-AES");
      case 0x6F251:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 15, 3}, "FrodoKEM-1344-AES");
      case 0x6F310:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 16, 1}, "eFrodoKEM-640-SHAKE");
      case 0x6F311:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 16, 2}, "eFrodoKEM-976-SHAKE");
      case 0x6F312:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 16, 3}, "eFrodoKEM-1344-SHAKE");
      case 0x6F3D1:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 17, 1}, "eFrodoKEM-640-AES");
      case 0x6F3D2:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 17, 2}, "eFrodoKEM-976-AES");
      case 0x6F3D3:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 17, 3}, "eFrodoKEM-1344-AES");
      case 0x6F492:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 1}, "ClassicMcEliece_6688128pc");
      case 0x6F493:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 2}, "ClassicMcEliece_6688128pcf");
      case 0x6F494:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 3}, "ClassicMcEliece_6960119pc");
      case 0x6F495:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 4}, "ClassicMcEliece_6960119pcf");
      case 0x6F496:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 5}, "ClassicMcEliece_8192128pc");
      case 0x6F497:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 18, 6}, "ClassicMcEliece_8192128pcf");
      case 0x6F79D:
         return if_match(oid, {2, 16, 840, 1, 113730, 1, 13}, "Certificate Comment");
      case 0x701A0:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 2, 1}, "ECGDSA");
      case 0x70322:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 1}, "ECGDSA/RIPEMD-160");
      case 0x70323:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 2}, "ECGDSA/SHA-1");
      case 0x70324:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 3}, "ECGDSA/SHA-224");
      case 0x70325:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 4}, "ECGDSA/SHA-256");
      case 0x70326:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 5}, "ECGDSA/SHA-384");
      case 0x70327:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 5, 4, 6}, "ECGDSA/SHA-512");
      case 0x72B21:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 1, 1}, "GOST-34.10-2012-256");
      case 0x72B22:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 1, 2}, "GOST-34.10-2012-512");
      case 0x72BE3:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 2, 2}, "Streebog-256");
      case 0x72BE4:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 2, 3}, "Streebog-512");
      case 0x72CA4:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 3, 2}, "GOST-34.10-2012-256/Streebog-256");
      case 0x72CA5:
         return if_match(oid, {1, 2, 643, 7, 1, 1, 3, 3}, "GOST-34.10-2012-512/Streebog-512");
      case 0x7E10F:
         return if_match(oid, {2, 5, 4, 3}, "X520.CommonName");
      case 0x7E110:
         return if_match(oid, {2, 5, 4, 4}, "X520.Surname");
      case 0x7E111:
         return if_match(oid, {2, 5, 4, 5}, "X520.SerialNumber");
      case 0x7E112:
         return if_match(oid, {2, 5, 4, 6}, "X520.Country");
      case 0x7E113:
         return if_match(oid, {2, 5, 4, 7}, "X520.Locality");
      case 0x7E114:
         return if_match(oid, {2, 5, 4, 8}, "X520.State");
      case 0x7E115:
         return if_match(oid, {2, 5, 4, 9}, "X520.StreetAddress");
      case 0x7E116:
         return if_match(oid, {2, 5, 4, 10}, "X520.Organization");
      case 0x7E117:
         return if_match(oid, {2, 5, 4, 11}, "X520.OrganizationalUnit");
      case 0x7E118:
         return if_match(oid, {2, 5, 4, 12}, "X520.Title");
      case 0x7E136:
         return if_match(oid, {2, 5, 4, 42}, "X520.GivenName");
      case 0x7E137:
         return if_match(oid, {2, 5, 4, 43}, "X520.Initials");
      case 0x7E138:
         return if_match(oid, {2, 5, 4, 44}, "X520.GenerationalQualifier");
      case 0x7E13A:
         return if_match(oid, {2, 5, 4, 46}, "X520.DNQualifier");
      case 0x7E14D:
         return if_match(oid, {2, 5, 4, 65}, "X520.Pseudonym");
      case 0x7F3F3:
         return if_match(oid, {2, 5, 29, 14}, "X509v3.SubjectKeyIdentifier");
      case 0x7F3F4:
         return if_match(oid, {2, 5, 29, 15}, "X509v3.KeyUsage");
      case 0x7F3F5:
         return if_match(oid, {2, 5, 29, 16}, "X509v3.PrivateKeyUsagePeriod");
      case 0x7F3F6:
         return if_match(oid, {2, 5, 29, 17}, "X509v3.SubjectAlternativeName");
      case 0x7F3F7:
         return if_match(oid, {2, 5, 29, 18}, "X509v3.IssuerAlternativeName");
      case 0x7F3F8:
         return if_match(oid, {2, 5, 29, 19}, "X509v3.BasicConstraints");
      case 0x7F3F9:
         return if_match(oid, {2, 5, 29, 20}, "X509v3.CRLNumber");
      case 0x7F3FA:
         return if_match(oid, {2, 5, 29, 21}, "X509v3.ReasonCode");
      case 0x7F3FC:
         return if_match(oid, {2, 5, 29, 23}, "X509v3.HoldInstructionCode");
      case 0x7F3FD:
         return if_match(oid, {2, 5, 29, 24}, "X509v3.InvalidityDate");
      case 0x7F401:
         return if_match(oid, {2, 5, 29, 28}, "X509v3.CRLIssuingDistributionPoint");
      case 0x7F403:
         return if_match(oid, {2, 5, 29, 30}, "X509v3.NameConstraints");
      case 0x7F404:
         return if_match(oid, {2, 5, 29, 31}, "X509v3.CRLDistributionPoints");
      case 0x7F405:
         return if_match(oid, {2, 5, 29, 32}, "X509v3.CertificatePolicies");
      case 0x7F408:
         return if_match(oid, {2, 5, 29, 35}, "X509v3.AuthorityKeyIdentifier");
      case 0x7F409:
         return if_match(oid, {2, 5, 29, 36}, "X509v3.PolicyConstraints");
      case 0x7F40A:
         return if_match(oid, {2, 5, 29, 37}, "X509v3.ExtendedKeyUsage");
      case 0x80B84:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 1}, "AES-128/OCB");
      case 0x80B85:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 2}, "AES-192/OCB");
      case 0x80B86:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 3}, "AES-256/OCB");
      case 0x80B87:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 4}, "Serpent/OCB");
      case 0x80B88:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 5}, "Twofish/OCB");
      case 0x80B89:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 6}, "Camellia-128/OCB");
      case 0x80B8A:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 7}, "Camellia-192/OCB");
      case 0x80B8B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2, 8}, "Camellia-256/OCB");
      case 0x80D06:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 1}, "AES-128/SIV");
      case 0x80D07:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 2}, "AES-192/SIV");
      case 0x80D08:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 3}, "AES-256/SIV");
      case 0x80D09:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 4}, "Serpent/SIV");
      case 0x80D0A:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 5}, "Twofish/SIV");
      case 0x80D0B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 6}, "Camellia-128/SIV");
      case 0x80D0C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 7}, "Camellia-192/SIV");
      case 0x80D0D:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 8}, "Camellia-256/SIV");
      case 0x80D0E:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 4, 9}, "SM4/SIV");
      case 0x84C6A:
         return if_match(oid, {1, 2, 392, 200011, 61, 1, 1, 1, 2}, "Camellia-128/CBC");
      case 0x84C6B:
         return if_match(oid, {1, 2, 392, 200011, 61, 1, 1, 1, 3}, "Camellia-192/CBC");
      case 0x84C6C:
         return if_match(oid, {1, 2, 392, 200011, 61, 1, 1, 1, 4}, "Camellia-256/CBC");
      case 0x88CD3:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 16, 3, 6}, "KeyWrap.TripleDES");
      case 0x88CD5:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 16, 3, 8}, "Compression.Zlib");
      case 0x88CDE:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 16, 3, 17}, "HSS-LMS");
      case 0x88CDF:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 16, 3, 18}, "ChaCha20Poly1305");
      case 0x92296:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 2}, "AES-128/CBC");
      case 0x92299:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 5}, "KeyWrap.AES-128");
      case 0x9229A:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 6}, "AES-128/GCM");
      case 0x9229B:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 7}, "AES-128/CCM");
      case 0x922AA:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 22}, "AES-192/CBC");
      case 0x922AD:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 25}, "KeyWrap.AES-192");
      case 0x922AE:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 26}, "AES-192/GCM");
      case 0x922AF:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 27}, "AES-192/CCM");
      case 0x922BE:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 42}, "AES-256/CBC");
      case 0x922C1:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 45}, "KeyWrap.AES-256");
      case 0x922C2:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 46}, "AES-256/GCM");
      case 0x922C3:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 1, 47}, "AES-256/CCM");
      case 0x92356:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 1}, "SHA-256");
      case 0x92357:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 2}, "SHA-384");
      case 0x92358:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 3}, "SHA-512");
      case 0x92359:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 4}, "SHA-224");
      case 0x9235B:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 6}, "SHA-512-256");
      case 0x9235C:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 7}, "SHA-3(224)");
      case 0x9235D:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 8}, "SHA-3(256)");
      case 0x9235E:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 9}, "SHA-3(384)");
      case 0x9235F:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 10}, "SHA-3(512)");
      case 0x92360:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 11}, "SHAKE-128");
      case 0x92361:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 2, 12}, "SHAKE-256");
      case 0x92417:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 1}, "DSA/SHA-224");
      case 0x92418:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 2}, "DSA/SHA-256");
      case 0x92419:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 3}, "DSA/SHA-384");
      case 0x9241A:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 4}, "DSA/SHA-512");
      case 0x9241B:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 5}, "DSA/SHA-3(224)");
      case 0x9241C:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 6}, "DSA/SHA-3(256)");
      case 0x9241D:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 7}, "DSA/SHA-3(384)");
      case 0x9241E:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 8}, "DSA/SHA-3(512)");
      case 0x9241F:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 9}, "ECDSA/SHA-3(224)");
      case 0x92420:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 10}, "ECDSA/SHA-3(256)");
      case 0x92421:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 11}, "ECDSA/SHA-3(384)");
      case 0x92422:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 12}, "ECDSA/SHA-3(512)");
      case 0x92423:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 13}, "RSA/PKCS1v15(SHA-3(224))");
      case 0x92424:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 14}, "RSA/PKCS1v15(SHA-3(256))");
      case 0x92425:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 15}, "RSA/PKCS1v15(SHA-3(384))");
      case 0x92426:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 16}, "RSA/PKCS1v15(SHA-3(512))");
      case 0x92427:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 17}, "ML-DSA-4x4");
      case 0x92428:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 18}, "ML-DSA-6x5");
      case 0x92429:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 19}, "ML-DSA-8x7");
      case 0x9242A:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 20}, "SLH-DSA-SHA2-128s");
      case 0x9242B:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 21}, "SLH-DSA-SHA2-128f");
      case 0x9242C:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 22}, "SLH-DSA-SHA2-192s");
      case 0x9242D:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 23}, "SLH-DSA-SHA2-192f");
      case 0x9242E:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 24}, "SLH-DSA-SHA2-256s");
      case 0x9242F:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 25}, "SLH-DSA-SHA2-256f");
      case 0x92430:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 26}, "SLH-DSA-SHAKE-128s");
      case 0x92431:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 27}, "SLH-DSA-SHAKE-128f");
      case 0x92432:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 28}, "SLH-DSA-SHAKE-192s");
      case 0x92433:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 29}, "SLH-DSA-SHAKE-192f");
      case 0x92434:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 30}, "SLH-DSA-SHAKE-256s");
      case 0x92435:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 3, 31}, "SLH-DSA-SHAKE-256f");
      case 0x924D8:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 4, 1}, "ML-KEM-512");
      case 0x924D9:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 4, 2}, "ML-KEM-768");
      case 0x924DA:
         return if_match(oid, {2, 16, 840, 1, 101, 3, 4, 4, 3}, "ML-KEM-1024");
      case 0x9479F:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 1, 1}, "PKIX.AuthorityInformationAccess");
      case 0x947A5:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 1, 7}, "PKIX.IpAddrBlocks");
      case 0x947A6:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 1, 8}, "PKIX.AutonomousSysIds");
      case 0x947B8:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 1, 26}, "PKIX.TNAuthList");
      case 0x94921:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 1}, "PKIX.ServerAuth");
      case 0x94922:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 2}, "PKIX.ClientAuth");
      case 0x94923:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 3}, "PKIX.CodeSigning");
      case 0x94924:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 4}, "PKIX.EmailProtection");
      case 0x94925:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 5}, "PKIX.IPsecEndSystem");
      case 0x94926:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 6}, "PKIX.IPsecTunnel");
      case 0x94927:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 7}, "PKIX.IPsecUser");
      case 0x94928:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 8}, "PKIX.TimeStamping");
      case 0x94929:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 3, 9}, "PKIX.OCSPSigning");
      case 0x94CEA:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 8, 5}, "PKIX.XMPPAddr");
      case 0x954DB:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 311, 20, 2, 2}, "Microsoft SmartcardLogon");
      case 0x954DC:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 311, 20, 2, 3}, "Microsoft UPN");
      case 0x96B0E:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 48, 1}, "PKIX.OCSP");
      case 0x96B0F:
         return if_match(oid, {1, 3, 6, 1, 5, 5, 7, 48, 2}, "PKIX.CertificateAuthorityIssuers");
      case 0x9A008:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 1}, "brainpool160r1");
      case 0x9A00A:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 3}, "brainpool192r1");
      case 0x9A00C:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 5}, "brainpool224r1");
      case 0x9A00E:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 7}, "brainpool256r1");
      case 0x9A010:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 9}, "brainpool320r1");
      case 0x9A012:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 11}, "brainpool384r1");
      case 0x9A014:
         return if_match(oid, {1, 3, 36, 3, 3, 2, 8, 1, 1, 13}, "brainpool512r1");
      case 0xA0D61:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 3}, "McEliece");
      case 0xA0D63:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 5}, "XMSS-draft6");
      case 0xA0D66:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 8}, "XMSS-draft12");
      case 0xA0D6B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 1, 13}, "HSS-LMS-Private-Key");
      case 0xA0EE1:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 1}, "Serpent/CBC");
      case 0xA0EE2:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 2}, "Threefish-512/CBC");
      case 0xA0EE3:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 3}, "Twofish/CBC");
      case 0xA0F45:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 101}, "Serpent/GCM");
      case 0xA0F46:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 3, 102}, "Twofish/GCM");
      case 0xA0FA2:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 4, 1}, "numsp256d1");
      case 0xA0FA3:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 4, 2}, "numsp384d1");
      case 0xA0FA4:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 25258, 4, 3}, "numsp512d1");
      case 0xA244B:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 1}, "ClassicMcEliece_348864");
      case 0xA244C:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 2}, "ClassicMcEliece_348864f");
      case 0xA244D:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 3}, "ClassicMcEliece_460896");
      case 0xA244E:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 4}, "ClassicMcEliece_460896f");
      case 0xA244F:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 5}, "ClassicMcEliece_6688128");
      case 0xA2450:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 6}, "ClassicMcEliece_6688128f");
      case 0xA2451:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 7}, "ClassicMcEliece_6960119");
      case 0xA2452:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 8}, "ClassicMcEliece_6960119f");
      case 0xA2453:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 9}, "ClassicMcEliece_8192128");
      case 0xA2454:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 22554, 5, 1, 10}, "ClassicMcEliece_8192128f");
      case 0xAF989:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 1}, "RSA");
      case 0xAF98A:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 2}, "RSA/PKCS1v15(MD2)");
      case 0xAF98C:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 4}, "RSA/PKCS1v15(MD5)");
      case 0xAF98D:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 5}, "RSA/PKCS1v15(SHA-1)");
      case 0xAF98F:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 7}, "RSA/OAEP");
      case 0xAF990:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 8}, "MGF1");
      case 0xAF992:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 10}, "RSA/PSS");
      case 0xAF993:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 11}, "RSA/PKCS1v15(SHA-256)");
      case 0xAF994:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 12}, "RSA/PKCS1v15(SHA-384)");
      case 0xAF995:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 13}, "RSA/PKCS1v15(SHA-512)");
      case 0xAF996:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 14}, "RSA/PKCS1v15(SHA-224)");
      case 0xAF998:
         return if_match(oid, {1, 2, 840, 113549, 1, 1, 16}, "RSA/PKCS1v15(SHA-512-256)");
      case 0xAFC98:
         return if_match(oid, {1, 2, 840, 113549, 1, 5, 12}, "PKCS5.PBKDF2");
      case 0xAFC99:
         return if_match(oid, {1, 2, 840, 113549, 1, 5, 13}, "PBE-PKCS5v20");
      case 0xAFF91:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 1}, "PKCS9.EmailAddress");
      case 0xAFF92:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 2}, "PKCS9.UnstructuredName");
      case 0xAFF93:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 3}, "PKCS9.ContentType");
      case 0xAFF94:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 4}, "PKCS9.MessageDigest");
      case 0xAFF97:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 7}, "PKCS9.ChallengePassword");
      case 0xAFF9E:
         return if_match(oid, {1, 2, 840, 113549, 1, 9, 14}, "PKCS9.ExtensionRequest");
      case 0xC0226:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 11591, 4, 11}, "Scrypt");
      case 0xC0A67:
         return if_match(oid, {1, 3, 6, 1, 4, 1, 11591, 15, 1}, "OpenPGP.Ed25519");
      case 0xC4CE5:
         return if_match(oid, {1, 2, 643, 100, 1}, "GOST.OGRN");
      case 0xC4D53:
         return if_match(oid, {1, 2, 643, 100, 111}, "GOST.SubjectSigningTool");
      case 0xC4D54:
         return if_match(oid, {1, 2, 643, 100, 112}, "GOST.IssuerSigningTool");
      case 0xC9C50:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 1}, "secp192r1");
      case 0xC9C51:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 2}, "x962_p192v2");
      case 0xC9C52:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 3}, "x962_p192v3");
      case 0xC9C53:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 4}, "x962_p239v1");
      case 0xC9C54:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 5}, "x962_p239v2");
      case 0xC9C55:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 6}, "x962_p239v3");
      case 0xC9C56:
         return if_match(oid, {1, 2, 840, 10045, 3, 1, 7}, "secp256r1");
      case 0xCFA13:
         return if_match(oid, {1, 2, 840, 10040, 4, 1}, "DSA");
      case 0xCFA15:
         return if_match(oid, {1, 2, 840, 10040, 4, 3}, "DSA/SHA-1");
      default:
         return {};
   }
}

//static
std::optional<OID> OID_Map::lookup_static_oid_name(std::string_view req) {
   const uint32_t hc = hash_oid_name(req);

   switch(hc) {
      case 0x00545:
         return if_match(req, "Twofish/GCM", {1, 3, 6, 1, 4, 1, 25258, 3, 102});
      case 0x00CF3:
         return if_match(req, "SphincsPlus-sha2-192f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 4});
      case 0x015FE:
         return if_match(req, "FrodoKEM-640-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 14, 1});
      case 0x01F9E:
         return if_match(req, "MD5", {1, 2, 840, 113549, 2, 5});
      case 0x02293:
         return if_match(req, "SphincsPlus-shake-192f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 4});
      case 0x02B93:
         return if_match(req, "Microsoft SmartcardLogon", {1, 3, 6, 1, 4, 1, 311, 20, 2, 2});
      case 0x041D5:
         return if_match(req, "secp160k1", {1, 3, 132, 0, 9});
      case 0x044B3:
         return if_match(req, "Camellia-256/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 8});
      case 0x048B2:
         return if_match(req, "secp160r1", {1, 3, 132, 0, 8});
      case 0x048B3:
         return if_match(req, "secp160r2", {1, 3, 132, 0, 30});
      case 0x05CDA:
         return if_match(req, "X520.Country", {2, 5, 4, 6});
      case 0x07783:
         return if_match(req, "PKIX.ServerAuth", {1, 3, 6, 1, 5, 5, 7, 3, 1});
      case 0x086C7:
         return if_match(req, "numsp384d1", {1, 3, 6, 1, 4, 1, 25258, 4, 2});
      case 0x08A92:
         return if_match(req, "RSA/PKCS1v15(SHA-1)", {1, 2, 840, 113549, 1, 1, 5});
      case 0x09EA0:
         return if_match(req, "DES/CBC", {1, 3, 14, 3, 2, 7});
      case 0x0B2D6:
         return if_match(req, "ECDSA/SHA-3(512)", {2, 16, 840, 1, 101, 3, 4, 3, 12});
      case 0x0BA72:
         return if_match(req, "SphincsPlus-sha2-128s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 1});
      case 0x0BE23:
         return if_match(req, "ECGDSA", {1, 3, 36, 3, 3, 2, 5, 2, 1});
      case 0x0D012:
         return if_match(req, "SphincsPlus-shake-128s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 1});
      case 0x0DCE9:
         return if_match(req, "ClassicMcEliece_8192128f", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 10});
      case 0x0E52A:
         return if_match(req, "numsp512d1", {1, 3, 6, 1, 4, 1, 25258, 4, 3});
      case 0x0F9CC:
         return if_match(req, "PKCS9.UnstructuredName", {1, 2, 840, 113549, 1, 9, 2});
      case 0x0FF45:
         return if_match(req, "Camellia-256/GCM", {0, 3, 4401, 5, 3, 1, 9, 46});
      case 0x1033D:
         return if_match(req, "DSA/SHA-3(384)", {2, 16, 840, 1, 101, 3, 4, 3, 7});
      case 0x1139D:
         return if_match(req, "secp192k1", {1, 3, 132, 0, 31});
      case 0x113D6:
         return if_match(req, "X520.DNQualifier", {2, 5, 4, 46});
      case 0x11A7A:
         return if_match(req, "secp192r1", {1, 2, 840, 10045, 3, 1, 1});
      case 0x12096:
         return if_match(req, "SM2_Kex", {1, 2, 156, 10197, 1, 301, 2});
      case 0x13FC1:
         return if_match(req, "X520.GenerationalQualifier", {2, 5, 4, 44});
      case 0x1445B:
         return if_match(req, "PKCS5.PBKDF2", {1, 2, 840, 113549, 1, 5, 12});
      case 0x1495D:
         return if_match(req, "eFrodoKEM-1344-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 17, 3});
      case 0x14E30:
         return if_match(req, "ClassicMcEliece_460896", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 3});
      case 0x14FB1:
         return if_match(req, "XMSS-draft12", {1, 3, 6, 1, 4, 1, 25258, 1, 8});
      case 0x156E3:
         return if_match(req, "Compression.Zlib", {1, 2, 840, 113549, 1, 9, 16, 3, 8});
      case 0x1579E:
         return if_match(req, "Streebog-512", {1, 2, 643, 7, 1, 1, 2, 3});
      case 0x175EF:
         return if_match(req, "Kyber-1024-90s-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 11, 3});
      case 0x17709:
         return if_match(req, "X520.GivenName", {2, 5, 4, 42});
      case 0x17AD9:
         return if_match(req, "RSA/PKCS1v15(SM3)", {1, 2, 156, 10197, 1, 504});
      case 0x17CE2:
         return if_match(req, "SLH-DSA-SHA2-256f", {2, 16, 840, 1, 101, 3, 4, 3, 25});
      case 0x17CEF:
         return if_match(req, "SLH-DSA-SHA2-256s", {2, 16, 840, 1, 101, 3, 4, 3, 24});
      case 0x18618:
         return if_match(req, "FrodoKEM-976-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 15, 2});
      case 0x19480:
         return if_match(req, "eFrodoKEM-1344-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 16, 3});
      case 0x1958A:
         return if_match(req, "X509v3.InvalidityDate", {2, 5, 29, 24});
      case 0x19851:
         return if_match(req, "DSA/SHA-1", {1, 2, 840, 10040, 4, 3});
      case 0x1B2E7:
         return if_match(req, "KeyWrap.AES-128", {2, 16, 840, 1, 101, 3, 4, 1, 5});
      case 0x1B9BE:
         return if_match(req, "KeyWrap.AES-192", {2, 16, 840, 1, 101, 3, 4, 1, 25});
      case 0x1D439:
         return if_match(req, "SphincsPlus-haraka-192f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 4});
      case 0x2065B:
         return if_match(req, "KeyWrap.CAST-128", {1, 2, 840, 113533, 7, 66, 15});
      case 0x216A0:
         return if_match(req, "ML-KEM-512", {2, 16, 840, 1, 101, 3, 4, 4, 1});
      case 0x2216B:
         return if_match(req, "GOST-34.10-2012-512", {1, 2, 643, 7, 1, 1, 1, 2});
      case 0x22C2C:
         return if_match(req, "ElGamal", {1, 3, 6, 1, 4, 1, 3029, 1, 2, 1});
      case 0x2559A:
         return if_match(req, "X520.Initials", {2, 5, 4, 43});
      case 0x271AC:
         return if_match(req, "PKIX.AutonomousSysIds", {1, 3, 6, 1, 5, 5, 7, 1, 8});
      case 0x281B8:
         return if_match(req, "SphincsPlus-haraka-128s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 1});
      case 0x29999:
         return if_match(req, "DSA/SHA-3(256)", {2, 16, 840, 1, 101, 3, 4, 3, 6});
      case 0x2A83D:
         return if_match(req, "SHA-224", {2, 16, 840, 1, 101, 3, 4, 2, 4});
      case 0x2AB30:
         return if_match(req, "SHA-256", {2, 16, 840, 1, 101, 3, 4, 2, 1});
      case 0x2ABEF:
         return if_match(req, "KeyWrap.AES-256", {2, 16, 840, 1, 101, 3, 4, 1, 45});
      case 0x2BAEF:
         return if_match(req, "SM2_Sig/SM3", {1, 2, 156, 10197, 1, 501});
      case 0x2C39A:
         return if_match(req, "ECGDSA/RIPEMD-160", {1, 3, 36, 3, 3, 2, 5, 4, 1});
      case 0x2C54F:
         return if_match(req, "ECDSA/SHA-3(224)", {2, 16, 840, 1, 101, 3, 4, 3, 9});
      case 0x2EEA6:
         return if_match(req, "RSA/PKCS1v15(RIPEMD-160)", {1, 3, 36, 3, 3, 1, 2});
      case 0x2EFBA:
         return if_match(req, "Kyber-512-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 7, 1});
      case 0x3133E:
         return if_match(req, "SLH-DSA-SHA2-128f", {2, 16, 840, 1, 101, 3, 4, 3, 21});
      case 0x3134B:
         return if_match(req, "SLH-DSA-SHA2-128s", {2, 16, 840, 1, 101, 3, 4, 3, 20});
      case 0x3160D:
         return if_match(req, "RSA/PKCS1v15(SHA-3(224))", {2, 16, 840, 1, 101, 3, 4, 3, 13});
      case 0x319E0:
         return if_match(req, "GOST-34.10-2012-256/Streebog-256", {1, 2, 643, 7, 1, 1, 3, 2});
      case 0x31B3D:
         return if_match(req, "HMAC(SHA-512)", {1, 2, 840, 113549, 2, 11});
      case 0x31C6D:
         return if_match(req, "secp384r1", {1, 3, 132, 0, 34});
      case 0x32899:
         return if_match(req, "TripleDES/CBC", {1, 2, 840, 113549, 3, 7});
      case 0x3615D:
         return if_match(req, "FrodoKEM-976-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 14, 2});
      case 0x361B8:
         return if_match(req, "Ed25519", {1, 3, 101, 112});
      case 0x3649D:
         return if_match(req, "SHAKE-128", {2, 16, 840, 1, 101, 3, 4, 2, 11});
      case 0x36693:
         return if_match(req, "ClassicMcEliece_348864", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 1});
      case 0x373C7:
         return if_match(req, "ML-DSA-4x4", {2, 16, 840, 1, 101, 3, 4, 3, 17});
      case 0x3750B:
         return if_match(req, "ClassicMcEliece_8192128", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 9});
      case 0x39890:
         return if_match(req, "Ed448", {1, 3, 101, 113});
      case 0x3A438:
         return if_match(req, "SHA-384", {2, 16, 840, 1, 101, 3, 4, 2, 2});
      case 0x3A963:
         return if_match(req, "DH", {1, 2, 840, 10046, 2, 1});
      case 0x3AC83:
         return if_match(req, "MGF1", {1, 2, 840, 113549, 1, 1, 8});
      case 0x3ACBA:
         return if_match(req, "X509v3.IssuerAlternativeName", {2, 5, 29, 18});
      case 0x3B273:
         return if_match(req, "KeyWrap.TripleDES", {1, 2, 840, 113549, 1, 9, 16, 3, 6});
      case 0x3B91E:
         return if_match(req, "X509v3.PrivateKeyUsagePeriod", {2, 5, 29, 16});
      case 0x3BC8A:
         return if_match(req, "SLH-DSA-SHAKE-192f", {2, 16, 840, 1, 101, 3, 4, 3, 29});
      case 0x3BC97:
         return if_match(req, "SLH-DSA-SHAKE-192s", {2, 16, 840, 1, 101, 3, 4, 3, 28});
      case 0x3D127:
         return if_match(req, "DSA", {1, 2, 840, 10040, 4, 1});
      case 0x3E249:
         return if_match(req, "HSS-LMS", {1, 2, 840, 113549, 1, 9, 16, 3, 17});
      case 0x3E7D5:
         return if_match(req, "RSA/PKCS1v15(SHA-3(256))", {2, 16, 840, 1, 101, 3, 4, 3, 14});
      case 0x3F748:
         return if_match(req, "GOST.OGRN", {1, 2, 643, 100, 1});
      case 0x3F99F:
         return if_match(req, "X509v3.BasicConstraints", {2, 5, 29, 19});
      case 0x40726:
         return if_match(req, "SHA-3(512)", {2, 16, 840, 1, 101, 3, 4, 2, 10});
      case 0x407BF:
         return if_match(req, "ML-KEM-768", {2, 16, 840, 1, 101, 3, 4, 4, 2});
      case 0x41334:
         return if_match(req, "ECDSA/SHA-3(384)", {2, 16, 840, 1, 101, 3, 4, 3, 11});
      case 0x42DF3:
         return if_match(req, "X509v3.CRLDistributionPoints", {2, 5, 29, 31});
      case 0x437FB:
         return if_match(req, "brainpool160r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 1});
      case 0x441F5:
         return if_match(req, "gost_256A", {1, 2, 643, 7, 1, 2, 1, 1, 1});
      case 0x441F6:
         return if_match(req, "gost_256B", {1, 2, 643, 7, 1, 2, 1, 1, 2});
      case 0x44221:
         return if_match(req, "GOST-34.10-2012-512/Streebog-512", {1, 2, 643, 7, 1, 1, 3, 3});
      case 0x44322:
         return if_match(req, "ClassicMcEliece_6960119pc", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 3});
      case 0x44973:
         return if_match(req, "Kyber-512-90s-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 11, 1});
      case 0x45C27:
         return if_match(req, "RSA/PKCS1v15(SHA-512-256)", {1, 2, 840, 113549, 1, 1, 16});
      case 0x45C85:
         return if_match(req, "X509v3.ReasonCode", {2, 5, 29, 21});
      case 0x45DA5:
         return if_match(req, "SHAKE-256", {2, 16, 840, 1, 101, 3, 4, 2, 12});
      case 0x4663C:
         return if_match(req, "X509v3.PolicyConstraints", {2, 5, 29, 36});
      case 0x480F7:
         return if_match(req, "Serpent/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 4});
      case 0x48627:
         return if_match(req, "Dilithium-4x4-AES-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 10, 1});
      case 0x48861:
         return if_match(req, "ChaCha20Poly1305", {1, 2, 840, 113549, 1, 9, 16, 3, 18});
      case 0x4A292:
         return if_match(req, "frp256v1", {1, 2, 250, 1, 223, 101, 256, 1});
      case 0x4A9EE:
         return if_match(req, "ClassicMcEliece_6960119f", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 8});
      case 0x4BF87:
         return if_match(req, "PKIX.TNAuthList", {1, 3, 6, 1, 5, 5, 7, 1, 26});
      case 0x4C088:
         return if_match(req, "eFrodoKEM-976-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 17, 2});
      case 0x4C513:
         return if_match(req, "DSA/SHA-224", {2, 16, 840, 1, 101, 3, 4, 3, 1});
      case 0x4C806:
         return if_match(req, "DSA/SHA-256", {2, 16, 840, 1, 101, 3, 4, 3, 2});
      case 0x4D740:
         return if_match(req, "X509v3.AnyPolicy", {2, 5, 29, 32, 0});
      case 0x4DE49:
         return if_match(req, "RSA/PKCS1v15(SHA-512)", {1, 2, 840, 113549, 1, 1, 13});
      case 0x4ED5D:
         return if_match(req, "CAST-128/CBC", {1, 2, 840, 113533, 7, 66, 10});
      case 0x4FCDC:
         return if_match(req, "RSA", {1, 2, 840, 113549, 1, 1, 1});
      case 0x501CB:
         return if_match(req, "ECDSA/SHA-224", {1, 2, 840, 10045, 4, 3, 1});
      case 0x50395:
         return if_match(req, "GOST-34.10/GOST-R-34.11-94", {1, 2, 643, 2, 2, 3});
      case 0x504BE:
         return if_match(req, "ECDSA/SHA-256", {1, 2, 840, 10045, 4, 3, 2});
      case 0x509C3:
         return if_match(req, "brainpool192r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 3});
      case 0x509F9:
         return if_match(req, "PKCS9.ContentType", {1, 2, 840, 113549, 1, 9, 3});
      case 0x50B26:
         return if_match(req, "FrodoKEM-640-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 15, 1});
      case 0x50D78:
         return if_match(req, "x962_p192v2", {1, 2, 840, 10045, 3, 1, 2});
      case 0x50D79:
         return if_match(req, "x962_p192v3", {1, 2, 840, 10045, 3, 1, 3});
      case 0x51DC6:
         return if_match(req, "AES-128/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 1});
      case 0x52DB6:
         return if_match(req, "HMAC(SHA-224)", {1, 2, 840, 113549, 2, 8});
      case 0x53E11:
         return if_match(req, "FrodoKEM-1344-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 14, 3});
      case 0x54012:
         return if_match(req, "PKIX.TimeStamping", {1, 3, 6, 1, 5, 5, 7, 3, 8});
      case 0x5407A:
         return if_match(req, "Serpent/CBC", {1, 3, 6, 1, 4, 1, 25258, 3, 1});
      case 0x5576D:
         return if_match(req, "SphincsPlus-sha2-128f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 2});
      case 0x55EF6:
         return if_match(req, "AES-192/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 2});
      case 0x55FFA:
         return if_match(req, "ML-DSA-6x5", {2, 16, 840, 1, 101, 3, 4, 3, 18});
      case 0x56826:
         return if_match(req, "brainpool320r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 9});
      case 0x56D0D:
         return if_match(req, "SphincsPlus-shake-128f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 2});
      case 0x57077:
         return if_match(req, "XMSS-draft6", {1, 3, 6, 1, 4, 1, 25258, 1, 5});
      case 0x5818B:
         return if_match(req, "ECGDSA/SHA-224", {1, 3, 36, 3, 3, 2, 5, 4, 3});
      case 0x5847E:
         return if_match(req, "ECGDSA/SHA-256", {1, 3, 36, 3, 3, 2, 5, 4, 4});
      case 0x5898B:
         return if_match(req, "SHA-512", {2, 16, 840, 1, 101, 3, 4, 2, 3});
      case 0x58991:
         return if_match(req, "PKIX.OCSP.NoCheck", {1, 3, 6, 1, 5, 5, 7, 48, 1, 5});
      case 0x59717:
         return if_match(req, "X509v3.SubjectKeyIdentifier", {2, 5, 29, 14});
      case 0x5A570:
         return if_match(req, "X520.CommonName", {2, 5, 4, 3});
      case 0x5A990:
         return if_match(req, "ECDSA/SHA-3(256)", {2, 16, 840, 1, 101, 3, 4, 3, 10});
      case 0x5AB0E:
         return if_match(req, "SphincsPlus-sha2-256s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 5});
      case 0x5AC4A:
         return if_match(req, "X520.Surname", {2, 5, 4, 4});
      case 0x5AF2C:
         return if_match(req, "ClassicMcEliece_8192128pc", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 5});
      case 0x5BC39:
         return if_match(req, "X509v3.KeyUsage", {2, 5, 29, 15});
      case 0x5BDDB:
         return if_match(req, "numsp256d1", {1, 3, 6, 1, 4, 1, 25258, 4, 1});
      case 0x5C0AE:
         return if_match(req, "SphincsPlus-shake-256s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 5});
      case 0x5C10E:
         return if_match(req, "DSA/SHA-384", {2, 16, 840, 1, 101, 3, 4, 3, 3});
      case 0x5D1CF:
         return if_match(req, "X520.SerialNumber", {2, 5, 4, 5});
      case 0x5D375:
         return if_match(req, "SM4/OCB", {1, 2, 156, 10197, 1, 104, 100});
      case 0x5DD49:
         return if_match(req, "AES-128/CBC", {2, 16, 840, 1, 101, 3, 4, 1, 2});
      case 0x5DE4E:
         return if_match(req, "AES-128/CCM", {2, 16, 840, 1, 101, 3, 4, 1, 7});
      case 0x5DF23:
         return if_match(req, "HMAC(SHA-512-256)", {1, 2, 840, 113549, 2, 13});
      case 0x5ED04:
         return if_match(req, "SM2", {1, 2, 156, 10197, 1, 301, 1});
      case 0x5ED05:
         return if_match(req, "SM3", {1, 2, 156, 10197, 1, 401});
      case 0x5FDC6:
         return if_match(req, "ECDSA/SHA-384", {1, 2, 840, 10045, 4, 3, 3});
      case 0x6199F:
         return if_match(req, "SHA-3(224)", {2, 16, 840, 1, 101, 3, 4, 2, 7});
      case 0x61E79:
         return if_match(req, "AES-192/CBC", {2, 16, 840, 1, 101, 3, 4, 1, 22});
      case 0x61F7E:
         return if_match(req, "AES-192/CCM", {2, 16, 840, 1, 101, 3, 4, 1, 27});
      case 0x64947:
         return if_match(req, "OpenPGP.Ed25519", {1, 3, 6, 1, 4, 1, 11591, 15, 1});
      case 0x652E7:
         return if_match(req, "sm2p256v1", {1, 2, 156, 10197, 1, 301});
      case 0x6697B:
         return if_match(req, "FrodoKEM-1344-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 15, 3});
      case 0x67B2C:
         return if_match(req, "X520.State", {2, 5, 4, 8});
      case 0x67B9B:
         return if_match(req, "HMAC(SHA-384)", {1, 2, 840, 113549, 2, 10});
      case 0x67D86:
         return if_match(req, "ECGDSA/SHA-384", {1, 3, 36, 3, 3, 2, 5, 4, 5});
      case 0x68A0B:
         return if_match(req, "Camellia-128/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 6});
      case 0x68E33:
         return if_match(req, "PKCS9.ExtensionRequest", {1, 2, 840, 113549, 1, 9, 14});
      case 0x69126:
         return if_match(req, "X509v3.SubjectAlternativeName", {2, 5, 29, 17});
      case 0x692F8:
         return if_match(req, "SM4/CBC", {1, 2, 156, 10197, 1, 104, 2});
      case 0x695E1:
         return if_match(req, "Dilithium-4x4-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 9, 1});
      case 0x696DC:
         return if_match(req, "PKIX.IpAddrBlocks", {1, 3, 6, 1, 5, 5, 7, 1, 7});
      case 0x6A7CA:
         return if_match(req, "ECDSA", {1, 2, 840, 10045, 2, 1});
      case 0x6BD26:
         return if_match(req, "GOST.INN", {1, 2, 643, 3, 131, 1, 1});
      case 0x6CB3B:
         return if_match(req, "Camellia-192/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 7});
      case 0x6E602:
         return if_match(req, "Dilithium-8x7-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 9, 3});
      case 0x6F0C2:
         return if_match(req, "RSA/PKCS1v15(SHA-224)", {1, 2, 840, 113549, 1, 1, 14});
      case 0x6FB26:
         return if_match(req, "PKIX.AuthorityInformationAccess", {1, 3, 6, 1, 5, 5, 7, 1, 1});
      case 0x70BB6:
         return if_match(req, "brainpool384r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 11});
      case 0x71EB3:
         return if_match(req, "SphincsPlus-haraka-128f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 2});
      case 0x7382C:
         return if_match(req, "ML-KEM-1024", {2, 16, 840, 1, 101, 3, 4, 4, 3});
      case 0x743BD:
         return if_match(req, "AES-256/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 3});
      case 0x7498E:
         return if_match(req, "Camellia-128/CBC", {1, 2, 392, 200011, 61, 1, 1, 1, 2});
      case 0x74C2E:
         return if_match(req, "ML-DSA-8x7", {2, 16, 840, 1, 101, 3, 4, 3, 19});
      case 0x7505F:
         return if_match(req, "PKIX.XMPPAddr", {1, 3, 6, 1, 5, 5, 7, 8, 5});
      case 0x7517A:
         return if_match(req, "RSA/PKCS1v15(MD2)", {1, 2, 840, 113549, 1, 1, 2});
      case 0x7546B:
         return if_match(req, "RSA/PKCS1v15(MD5)", {1, 2, 840, 113549, 1, 1, 4});
      case 0x75921:
         return if_match(req, "ClassicMcEliece_348864f", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 2});
      case 0x76784:
         return if_match(req, "SHA-3(384)", {2, 16, 840, 1, 101, 3, 4, 2, 9});
      case 0x76A19:
         return if_match(req, "brainpool512r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 13});
      case 0x77254:
         return if_match(req, "SphincsPlus-haraka-256s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 5});
      case 0x77ADC:
         return if_match(req, "secp224k1", {1, 3, 132, 0, 32});
      case 0x781B9:
         return if_match(req, "secp224r1", {1, 3, 132, 0, 33});
      case 0x78ABE:
         return if_match(req, "Camellia-192/CBC", {1, 2, 392, 200011, 61, 1, 1, 1, 3});
      case 0x792F2:
         return if_match(req, "ClassicMcEliece_6688128pc", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 1});
      case 0x7A661:
         return if_match(req, "DSA/SHA-512", {2, 16, 840, 1, 101, 3, 4, 3, 4});
      case 0x7A977:
         return if_match(req, "X509v3.ExtendedKeyUsage", {2, 5, 29, 37});
      case 0x7AE67:
         return if_match(req, "SM2_Enc", {1, 2, 156, 10197, 1, 301, 3});
      case 0x7B602:
         return if_match(req, "Twofish/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 5});
      case 0x7B9A1:
         return if_match(req, "SphincsPlus-sha2-192s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 3});
      case 0x7BB0A:
         return if_match(req, "SLH-DSA-SHAKE-256f", {2, 16, 840, 1, 101, 3, 4, 3, 31});
      case 0x7BB17:
         return if_match(req, "SLH-DSA-SHAKE-256s", {2, 16, 840, 1, 101, 3, 4, 3, 30});
      case 0x7BCF3:
         return if_match(req, "PKIX.EmailProtection", {1, 3, 6, 1, 5, 5, 7, 3, 4});
      case 0x7CC2C:
         return if_match(req, "SHA-512-256", {2, 16, 840, 1, 101, 3, 4, 2, 6});
      case 0x7CF41:
         return if_match(req, "SphincsPlus-shake-192s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 3});
      case 0x7DB91:
         return if_match(req, "GOST-34.10", {1, 2, 643, 2, 2, 19});
      case 0x7E319:
         return if_match(req, "ECDSA/SHA-512", {1, 2, 840, 10045, 4, 3, 4});
      case 0x7E874:
         return if_match(req, "ClassicMcEliece_6688128f", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 6});
      case 0x7EAAF:
         return if_match(req, "eFrodoKEM-640-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 16, 1});
      case 0x7F51F:
         return if_match(req, "PKIX.IPsecTunnel", {1, 3, 6, 1, 5, 5, 7, 3, 6});
      case 0x80272:
         return if_match(req, "X520.Organization", {2, 5, 4, 10});
      case 0x80340:
         return if_match(req, "AES-256/CBC", {2, 16, 840, 1, 101, 3, 4, 1, 42});
      case 0x80445:
         return if_match(req, "AES-256/CCM", {2, 16, 840, 1, 101, 3, 4, 1, 47});
      case 0x811F7:
         return if_match(req, "HMAC(SHA-256)", {1, 2, 840, 113549, 2, 9});
      case 0x82B47:
         return if_match(req, "Threefish-512/CBC", {1, 3, 6, 1, 4, 1, 25258, 3, 2});
      case 0x83EA7:
         return if_match(req, "RSA/PKCS1v15(SHA-384)", {1, 2, 840, 113549, 1, 1, 12});
      case 0x84596:
         return if_match(req, "eFrodoKEM-640-AES", {1, 3, 6, 1, 4, 1, 25258, 1, 17, 1});
      case 0x8469F:
         return if_match(req, "ClassicMcEliece_6960119pcf", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 4});
      case 0x84CA4:
         return if_match(req, "secp256k1", {1, 3, 132, 0, 10});
      case 0x85381:
         return if_match(req, "secp256r1", {1, 2, 840, 10045, 3, 1, 7});
      case 0x854FC:
         return if_match(req, "PKIX.IPsecUser", {1, 3, 6, 1, 5, 5, 7, 3, 7});
      case 0x85F51:
         return if_match(req, "Serpent/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 4});
      case 0x862D9:
         return if_match(req, "ECGDSA/SHA-512", {1, 3, 36, 3, 3, 2, 5, 4, 6});
      case 0x87585:
         return if_match(req, "Twofish/CBC", {1, 3, 6, 1, 4, 1, 25258, 3, 3});
      case 0x877D1:
         return if_match(req, "PKCS9.EmailAddress", {1, 2, 840, 113549, 1, 9, 1});
      case 0x87D27:
         return if_match(req, "PKIX.CertificateAuthorityIssuers", {1, 3, 6, 1, 5, 5, 7, 48, 2});
      case 0x87E42:
         return if_match(req, "X509v3.AuthorityKeyIdentifier", {2, 5, 29, 35});
      case 0x889B1:
         return if_match(req, "ECDSA/SHA-1", {1, 2, 840, 10045, 4, 1});
      case 0x89658:
         return if_match(req, "PBE-PKCS5v20", {1, 2, 840, 113549, 1, 5, 13});
      case 0x8976D:
         return if_match(req, "PKCS9.MessageDigest", {1, 2, 840, 113549, 1, 9, 4});
      case 0x8B002:
         return if_match(req, "Camellia-256/OCB", {1, 3, 6, 1, 4, 1, 25258, 3, 2, 8});
      case 0x8B935:
         return if_match(req, "ClassicMcEliece_6688128", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 5});
      case 0x8CE3D:
         return if_match(req, "PKCS9.ChallengePassword", {1, 2, 840, 113549, 1, 9, 7});
      case 0x8D45C:
         return if_match(req, "ECKCDSA", {1, 0, 14888, 3, 0, 5});
      case 0x8E0C1:
         return if_match(req, "X509v3.CertificatePolicies", {2, 5, 29, 32});
      case 0x8E39A:
         return if_match(req, "HSS-LMS-Private-Key", {1, 3, 6, 1, 4, 1, 25258, 1, 13});
      case 0x8EC51:
         return if_match(req, "Kyber-768-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 7, 2});
      case 0x8F94A:
         return if_match(req, "Dilithium-6x5-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 9, 2});
      case 0x8FC20:
         return if_match(req, "AES-128/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 1});
      case 0x8FDE0:
         return if_match(req, "SHA-3(256)", {2, 16, 840, 1, 101, 3, 4, 2, 8});
      case 0x919E3:
         return if_match(req, "Serpent/GCM", {1, 3, 6, 1, 4, 1, 25258, 3, 101});
      case 0x91C1A:
         return if_match(req, "X25519", {1, 3, 101, 110});
      case 0x91DC4:
         return if_match(req, "McEliece", {1, 3, 6, 1, 4, 1, 25258, 1, 3});
      case 0x93467:
         return if_match(req, "Dilithium-6x5-AES-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 10, 2});
      case 0x93D50:
         return if_match(req, "AES-192/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 2});
      case 0x95166:
         return if_match(req, "SLH-DSA-SHAKE-128f", {2, 16, 840, 1, 101, 3, 4, 3, 27});
      case 0x95173:
         return if_match(req, "SLH-DSA-SHAKE-128s", {2, 16, 840, 1, 101, 3, 4, 3, 26});
      case 0x952D6:
         return if_match(req, "PKIX.OCSP", {1, 3, 6, 1, 5, 5, 7, 48, 1});
      case 0x959B9:
         return if_match(req, "PKIX.IPsecEndSystem", {1, 3, 6, 1, 5, 5, 7, 3, 5});
      case 0x96F85:
         return if_match(req, "Camellia-256/CBC", {1, 2, 392, 200011, 61, 1, 1, 1, 4});
      case 0x97D5E:
         return if_match(req, "HMAC(SHA-1)", {1, 2, 840, 113549, 2, 7});
      case 0x9805C:
         return if_match(req, "SEED/CBC", {1, 2, 410, 200004, 1, 4});
      case 0x980E7:
         return if_match(req, "SphincsPlus-haraka-192s-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 3});
      case 0x980F5:
         return if_match(req, "GOST.SubjectSigningTool", {1, 2, 643, 100, 111});
      case 0x98B03:
         return if_match(req, "XMSS", {0, 4, 0, 127, 0, 15, 1, 1, 13, 0});
      case 0x9A6B2:
         return if_match(req, "ECKCDSA/SHA-1", {1, 2, 410, 200004, 1, 100, 4, 3});
      case 0x9B1CF:
         return if_match(req, "SM4/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 9});
      case 0x9B6B2:
         return if_match(req, "AES-128/GCM", {2, 16, 840, 1, 101, 3, 4, 1, 6});
      case 0x9B6BB:
         return if_match(req, "X520.OrganizationalUnit", {2, 5, 4, 11});
      case 0x9B851:
         return if_match(req, "OpenPGP.Curve25519", {1, 3, 6, 1, 4, 1, 3029, 1, 5, 1});
      case 0x9C80B:
         return if_match(req, "SLH-DSA-SHA2-192f", {2, 16, 840, 1, 101, 3, 4, 3, 23});
      case 0x9C818:
         return if_match(req, "SLH-DSA-SHA2-192s", {2, 16, 840, 1, 101, 3, 4, 3, 22});
      case 0x9CD2B:
         return if_match(req, "Scrypt", {1, 3, 6, 1, 4, 1, 11591, 4, 11});
      case 0x9CDE1:
         return if_match(req, "GOST-34.10-2012-256/SHA-256", {1, 3, 6, 1, 4, 1, 25258, 1, 6, 1});
      case 0x9CF73:
         return if_match(req, "ClassicMcEliece_460896f", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 4});
      case 0x9D354:
         return if_match(req, "RIPEMD-160", {1, 3, 36, 3, 2, 1});
      case 0x9D503:
         return if_match(req, "RSA/PKCS1v15(SHA-256)", {1, 2, 840, 113549, 1, 1, 11});
      case 0x9EC88:
         return if_match(req, "DSA/SHA-3(512)", {2, 16, 840, 1, 101, 3, 4, 3, 8});
      case 0x9EF36:
         return if_match(req, "ClassicMcEliece_6960119", {1, 3, 6, 1, 4, 1, 22554, 5, 1, 7});
      case 0x9F764:
         return if_match(req, "X448", {1, 3, 101, 111});
      case 0x9F7E2:
         return if_match(req, "AES-192/GCM", {2, 16, 840, 1, 101, 3, 4, 1, 26});
      case 0x9F9C5:
         return if_match(req, "ClassicMcEliece_6688128pcf", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 2});
      case 0xA2B5B:
         return if_match(req, "X509v3.CRLNumber", {2, 5, 29, 20});
      case 0xA3005:
         return if_match(req, "X520.Title", {2, 5, 4, 12});
      case 0xA323F:
         return if_match(req, "X509v3.NameConstraints", {2, 5, 29, 30});
      case 0xA3C55:
         return if_match(req, "X520.Pseudonym", {2, 5, 4, 65});
      case 0xA4809:
         return if_match(req, "SphincsPlus-sha2-256f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 2, 6});
      case 0xA57AF:
         return if_match(req, "secp521r1", {1, 3, 132, 0, 35});
      case 0xA5DA9:
         return if_match(req, "SphincsPlus-shake-256f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 1, 6});
      case 0xA6865:
         return if_match(req, "Camellia-128/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 6});
      case 0xA6C61:
         return if_match(req, "SM4/GCM", {1, 2, 156, 10197, 1, 104, 8});
      case 0xA9061:
         return if_match(req, "Kyber-768-90s-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 11, 2});
      case 0xAA995:
         return if_match(req, "Camellia-192/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 7});
      case 0xAAE2B:
         return if_match(req, "Dilithium-8x7-AES-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 10, 3});
      case 0xABCED:
         return if_match(req, "GOST.IssuerSigningTool", {1, 2, 643, 100, 112});
      case 0xABD24:
         return if_match(req, "RSA/OAEP", {1, 2, 840, 113549, 1, 1, 7});
      case 0xAC2EC:
         return if_match(req, "Streebog-256", {1, 2, 643, 7, 1, 1, 2, 2});
      case 0xAC3DD:
         return if_match(req, "Certificate Comment", {2, 16, 840, 1, 113730, 1, 13});
      case 0xAE6FE:
         return if_match(req, "PKIX.ClientAuth", {1, 3, 6, 1, 5, 5, 7, 3, 2});
      case 0xAE8D3:
         return if_match(req, "ClassicMcEliece_8192128pcf", {1, 3, 6, 1, 4, 1, 25258, 1, 18, 6});
      case 0xAF476:
         return if_match(req, "ECDH", {1, 3, 132, 1, 12});
      case 0xAFA6A:
         return if_match(req, "RSA/PKCS1v15(SHA-3(384))", {2, 16, 840, 1, 101, 3, 4, 3, 15});
      case 0xB2217:
         return if_match(req, "AES-256/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 3});
      case 0xB22F7:
         return if_match(req, "Camellia-128/GCM", {0, 3, 4401, 5, 3, 1, 9, 6});
      case 0xB23DE:
         return if_match(req, "X520.Locality", {2, 5, 4, 7});
      case 0xB2FBD:
         return if_match(req, "ECKCDSA/SHA-224", {1, 2, 410, 200004, 1, 100, 4, 4});
      case 0xB32B0:
         return if_match(req, "ECKCDSA/SHA-256", {1, 2, 410, 200004, 1, 100, 4, 5});
      case 0xB360E:
         return if_match(req, "eFrodoKEM-976-SHAKE", {1, 3, 6, 1, 4, 1, 25258, 1, 16, 2});
      case 0xB4368:
         return if_match(req, "ECGDSA/SHA-1", {1, 3, 36, 3, 3, 2, 5, 4, 2});
      case 0xB58CD:
         return if_match(req, "RSA/PKCS1v15(SHA-3(512))", {2, 16, 840, 1, 101, 3, 4, 3, 16});
      case 0xB6427:
         return if_match(req, "Camellia-192/GCM", {0, 3, 4401, 5, 3, 1, 9, 26});
      case 0xB7102:
         return if_match(req, "brainpool224r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 5});
      case 0xB710D:
         return if_match(req, "X509v3.CRLIssuingDistributionPoint", {2, 5, 29, 28});
      case 0xB72D4:
         return if_match(req, "Microsoft UPN", {1, 3, 6, 1, 4, 1, 311, 20, 2, 3});
      case 0xB73A5:
         return if_match(req, "RSA/PSS", {1, 2, 840, 113549, 1, 1, 10});
      case 0xB84B3:
         return if_match(req, "PKIX.CodeSigning", {1, 3, 6, 1, 5, 5, 7, 3, 3});
      case 0xB8CB9:
         return if_match(req, "GOST-34.10-2012-256", {1, 2, 643, 7, 1, 1, 1, 1});
      case 0xB945C:
         return if_match(req, "Twofish/SIV", {1, 3, 6, 1, 4, 1, 25258, 3, 4, 5});
      case 0xB94E4:
         return if_match(req, "gost_512A", {1, 2, 643, 7, 1, 2, 1, 2, 1});
      case 0xB94E5:
         return if_match(req, "gost_512B", {1, 2, 643, 7, 1, 2, 1, 2, 2});
      case 0xBA1D8:
         return if_match(req, "X520.StreetAddress", {2, 5, 4, 9});
      case 0xBCC82:
         return if_match(req, "x962_p239v1", {1, 2, 840, 10045, 3, 1, 4});
      case 0xBCC83:
         return if_match(req, "x962_p239v2", {1, 2, 840, 10045, 3, 1, 5});
      case 0xBCC84:
         return if_match(req, "x962_p239v3", {1, 2, 840, 10045, 3, 1, 6});
      case 0xBD92B:
         return if_match(req, "X509v3.HoldInstructionCode", {2, 5, 29, 23});
      case 0xBDCA9:
         return if_match(req, "AES-256/GCM", {2, 16, 840, 1, 101, 3, 4, 1, 46});
      case 0xBE48D:
         return if_match(req, "PKIX.OCSP.BasicResponse", {1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
      case 0xBF71E:
         return if_match(req, "Kyber-1024-r3", {1, 3, 6, 1, 4, 1, 25258, 1, 7, 3});
      case 0xBFF01:
         return if_match(req, "DSA/SHA-3(224)", {2, 16, 840, 1, 101, 3, 4, 3, 5});
      case 0xC0F4F:
         return if_match(req, "SphincsPlus-haraka-256f-r3.1", {1, 3, 6, 1, 4, 1, 25258, 1, 12, 3, 6});
      case 0xC1875:
         return if_match(req, "SHA-1", {1, 3, 14, 3, 2, 26});
      case 0xC28D1:
         return if_match(req, "PKIX.OCSPSigning", {1, 3, 6, 1, 5, 5, 7, 3, 9});
      case 0xC42CA:
         return if_match(req, "brainpool256r1", {1, 3, 36, 3, 3, 2, 8, 1, 1, 7});
      default:
         return {};
   }
}

std::unordered_map<OID, std::string> OID_Map::load_oid2str_map() {
   return {
      {OID{2, 5, 8, 1, 1}, "RSA"},
      {OID{1, 3, 6, 1, 4, 1, 8301, 3, 1, 2, 9, 0, 38}, "secp521r1"},
      {OID{1, 2, 643, 2, 2, 35, 1}, "gost_256A"},
      {OID{1, 2, 643, 2, 2, 36, 0}, "gost_256A"},
   };
}

std::unordered_map<std::string, OID> OID_Map::load_str2oid_map() {
   return {
      {"Curve25519", OID{1, 3, 101, 110}},
      {"SM2_Sig", OID{1, 2, 156, 10197, 1, 301, 1}},
      {"RSA/EMSA3(MD2)", OID{1, 2, 840, 113549, 1, 1, 2}},
      {"RSA/EMSA3(MD5)", OID{1, 2, 840, 113549, 1, 1, 4}},
      {"RSA/EMSA3(SHA-1)", OID{1, 2, 840, 113549, 1, 1, 5}},
      {"RSA/EMSA3(SHA-256)", OID{1, 2, 840, 113549, 1, 1, 11}},
      {"RSA/EMSA3(SHA-384)", OID{1, 2, 840, 113549, 1, 1, 12}},
      {"RSA/EMSA3(SHA-512)", OID{1, 2, 840, 113549, 1, 1, 13}},
      {"RSA/EMSA3(SHA-224)", OID{1, 2, 840, 113549, 1, 1, 14}},
      {"RSA/EMSA3(SHA-512-256)", OID{1, 2, 840, 113549, 1, 1, 16}},
      {"RSA/EMSA3(SHA-3(224))", OID{2, 16, 840, 1, 101, 3, 4, 3, 13}},
      {"RSA/EMSA3(SHA-3(256))", OID{2, 16, 840, 1, 101, 3, 4, 3, 14}},
      {"RSA/EMSA3(SHA-3(384))", OID{2, 16, 840, 1, 101, 3, 4, 3, 15}},
      {"RSA/EMSA3(SHA-3(512))", OID{2, 16, 840, 1, 101, 3, 4, 3, 16}},
      {"RSA/EMSA3(SM3)", OID{1, 2, 156, 10197, 1, 504}},
      {"RSA/EMSA3(RIPEMD-160)", OID{1, 3, 36, 3, 3, 1, 2}},
      {"RSA/EMSA4", OID{1, 2, 840, 113549, 1, 1, 10}},
      {"PBES2", OID{1, 2, 840, 113549, 1, 5, 13}},
   };
}

}  // namespace Botan
