/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.pict.PICTUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class IconResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1229147982;
    public static final int RESOURCE_TYPE_THUMBNAIL_BW = 1768125475;
    public static final int RESOURCE_TYPE_THUMBNAIL_4BIT = 1768125492;
    public static final int RESOURCE_TYPE_THUMBNAIL_8BIT = 1768125496;
    public static final int RESOURCE_TYPE_THUMBNAIL_32BIT = 1769222962;
    public static final int RESOURCE_TYPE_THUMBNAIL_MASK = 1949855083;
    public static final int RESOURCE_TYPE_HUGE_BW = 1768122403;
    public static final int RESOURCE_TYPE_HUGE_4BIT = 1768122420;
    public static final int RESOURCE_TYPE_HUGE_8BIT = 1768122424;
    public static final int RESOURCE_TYPE_HUGE_32BIT = 1768436530;
    public static final int RESOURCE_TYPE_HUGE_MASK = 1748528491;
    public static final int RESOURCE_TYPE_LARGE_BW = 1229147683;
    public static final int RESOURCE_TYPE_LARGE_4BIT = 1768123444;
    public static final int RESOURCE_TYPE_LARGE_8BIT = 1768123448;
    public static final int RESOURCE_TYPE_LARGE_32BIT = 1768698674;
    public static final int RESOURCE_TYPE_LARGE_MASK = 1815637355;
    public static final int RESOURCE_TYPE_SMALL_BW = 1768125219;
    public static final int RESOURCE_TYPE_SMALL_4BIT = 1768125236;
    public static final int RESOURCE_TYPE_SMALL_8BIT = 1768125240;
    public static final int RESOURCE_TYPE_SMALL_32BIT = 1769157426;
    public static final int RESOURCE_TYPE_SMALL_MASK = 1933077867;
    public static final int RESOURCE_TYPE_MINI_BW = 1768123683;
    public static final int RESOURCE_TYPE_MINI_4BIT = 1768123700;
    public static final int RESOURCE_TYPE_MINI_8BIT = 1768123704;
    public static final int RESOURCE_TYPE_MINI_32BIT = 1768764210;
    public static final int RESOURCE_TYPE_MINI_MASK = 1832414571;
    public static final int RESOURCE_TYPE_JPEG2000_512 = 1768108089;
    public static final int RESOURCE_TYPE_JPEG2000_256 = 1768108088;
    public static final int RESOURCE_TYPE_JPEG2000_128 = 1768108087;
    public static final int RESOURCE_TYPE_JPEG2000_64 = 1768108086;
    public static final int RESOURCE_TYPE_JPEG2000_32 = 1768108085;
    public static final int RESOURCE_TYPE_JPEG2000_16 = 1768108084;
    public static final int RESOURCE_TYPE_KEYBOARD_BW = 1801679651;
    public static final int RESOURCE_TYPE_KEYBOARD_4BIT = 1801679668;
    public static final int RESOURCE_TYPE_KEYBOARD_8BIT = 1801679672;
    public int width = 0;
    public int height = 0;
    public int depth = 0;
    public int maskdepth = 0;

    public static boolean isMyType(int type) {
        return type == 1229147982 || type == 1768125475 || type == 1768125492 || type == 1768125496 || type == 1769222962 || type == 1949855083 || type == 1768122403 || type == 1768122420 || type == 1768122424 || type == 1768436530 || type == 1748528491 || type == 1229147683 || type == 1768123444 || type == 1768123448 || type == 1768698674 || type == 1815637355 || type == 1768125219 || type == 1768125236 || type == 1768125240 || type == 1769157426 || type == 1933077867 || type == 1768123683 || type == 1768123700 || type == 1768123704 || type == 1768764210 || type == 1832414571 || type == 1801679651 || type == 1801679668 || type == 1801679672;
    }

    public static int getTypeFor(int width, int height, int depth, int maskdepth) {
        if (width != height && (width != 16 || height != 12)) {
            return 0;
        }
        if (depth == 0 && maskdepth == 0) {
            switch (height) {
                case 16: {
                    return 1768108084;
                }
                case 32: {
                    return 1768108085;
                }
                case 64: {
                    return 1768108086;
                }
                case 128: {
                    return 1768108087;
                }
                case 256: {
                    return 1768108088;
                }
                case 512: {
                    return 1768108089;
                }
            }
        } else if (depth == 1 && maskdepth == 1) {
            switch (height) {
                case 12: {
                    return 1768123683;
                }
                case 16: {
                    return 1768125219;
                }
                case 32: {
                    return 1229147683;
                }
                case 48: {
                    return 1768122403;
                }
                case 128: {
                    return 1768125475;
                }
            }
        } else if (depth == 0 && maskdepth == 8) {
            switch (height) {
                case 12: {
                    return 1832414571;
                }
                case 16: {
                    return 1933077867;
                }
                case 32: {
                    return 1815637355;
                }
                case 48: {
                    return 1748528491;
                }
                case 128: {
                    return 1949855083;
                }
            }
        } else if (maskdepth == 0) {
            switch (depth) {
                case 1: {
                    switch (height) {
                        case 32: {
                            return 1229147982;
                        }
                    }
                }
                case 4: {
                    switch (height) {
                        case 12: {
                            return 1768123700;
                        }
                        case 16: {
                            return 1768125236;
                        }
                        case 32: {
                            return 1768123444;
                        }
                        case 48: {
                            return 1768122420;
                        }
                        case 128: {
                            return 1768125492;
                        }
                    }
                }
                case 8: {
                    switch (height) {
                        case 12: {
                            return 1768123704;
                        }
                        case 16: {
                            return 1768125240;
                        }
                        case 32: {
                            return 1768123448;
                        }
                        case 48: {
                            return 1768122424;
                        }
                        case 128: {
                            return 1768125496;
                        }
                    }
                }
                case 32: {
                    switch (height) {
                        case 12: {
                            return 1768764210;
                        }
                        case 16: {
                            return 1769157426;
                        }
                        case 32: {
                            return 1768698674;
                        }
                        case 48: {
                            return 1768436530;
                        }
                        case 128: {
                            return 1769222962;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public IconResource(short id, byte[] data) {
        super(1229147982, id, data);
        this.autoSize();
    }

    public IconResource(short id, String name, byte[] data) {
        super(1229147982, id, name, data);
        this.autoSize();
    }

    public IconResource(short id, byte attr, byte[] data) {
        super(1229147982, id, attr, data);
        this.autoSize();
    }

    public IconResource(short id, byte attr, String name, byte[] data) {
        super(1229147982, id, attr, name, data);
        this.autoSize();
    }

    public IconResource(int type, short id, byte[] data) {
        super(type, id, data);
        this.autoSize();
    }

    public IconResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
        this.autoSize();
    }

    public IconResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
        this.autoSize();
    }

    public IconResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
        this.autoSize();
    }

    public void autoSize() {
        switch (this.type) {
            case 1229147982: {
                this.height = 32;
                this.width = 32;
                this.depth = 1;
                this.maskdepth = 0;
                break;
            }
            case 1768125475: {
                this.height = 128;
                this.width = 128;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1768125492: {
                this.height = 128;
                this.width = 128;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1768125496: {
                this.height = 128;
                this.width = 128;
                this.depth = 8;
                this.maskdepth = 0;
                break;
            }
            case 1769222962: {
                this.height = 128;
                this.width = 128;
                this.depth = 32;
                this.maskdepth = 0;
                break;
            }
            case 1949855083: {
                this.height = 128;
                this.width = 128;
                this.depth = 0;
                this.maskdepth = 8;
                break;
            }
            case 1768122403: {
                this.height = 48;
                this.width = 48;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1768122420: {
                this.height = 48;
                this.width = 48;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1768122424: {
                this.height = 48;
                this.width = 48;
                this.depth = 8;
                this.maskdepth = 0;
                break;
            }
            case 1768436530: {
                this.height = 48;
                this.width = 48;
                this.depth = 32;
                this.maskdepth = 0;
                break;
            }
            case 1748528491: {
                this.height = 48;
                this.width = 48;
                this.depth = 0;
                this.maskdepth = 8;
                break;
            }
            case 1229147683: {
                this.height = 32;
                this.width = 32;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1768123444: {
                this.height = 32;
                this.width = 32;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1768123448: {
                this.height = 32;
                this.width = 32;
                this.depth = 8;
                this.maskdepth = 0;
                break;
            }
            case 1768698674: {
                this.height = 32;
                this.width = 32;
                this.depth = 32;
                this.maskdepth = 0;
                break;
            }
            case 1815637355: {
                this.height = 32;
                this.width = 32;
                this.depth = 0;
                this.maskdepth = 8;
                break;
            }
            case 1768125219: {
                this.height = 16;
                this.width = 16;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1768125236: {
                this.height = 16;
                this.width = 16;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1768125240: {
                this.height = 16;
                this.width = 16;
                this.depth = 8;
                this.maskdepth = 0;
                break;
            }
            case 1769157426: {
                this.height = 16;
                this.width = 16;
                this.depth = 32;
                this.maskdepth = 0;
                break;
            }
            case 1933077867: {
                this.height = 16;
                this.width = 16;
                this.depth = 0;
                this.maskdepth = 8;
                break;
            }
            case 1768123683: {
                this.width = 16;
                this.height = 12;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1768123700: {
                this.width = 16;
                this.height = 12;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1768123704: {
                this.width = 16;
                this.height = 12;
                this.depth = 8;
                this.maskdepth = 0;
                break;
            }
            case 1768764210: {
                this.width = 16;
                this.height = 12;
                this.depth = 32;
                this.maskdepth = 0;
                break;
            }
            case 1832414571: {
                this.width = 16;
                this.height = 12;
                this.depth = 0;
                this.maskdepth = 8;
                break;
            }
            case 1768108089: {
                this.height = 512;
                this.width = 512;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1768108088: {
                this.height = 256;
                this.width = 256;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1768108087: {
                this.height = 128;
                this.width = 128;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1768108086: {
                this.height = 64;
                this.width = 64;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1768108085: {
                this.height = 32;
                this.width = 32;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1768108084: {
                this.height = 16;
                this.width = 16;
                this.depth = 0;
                this.maskdepth = 0;
                break;
            }
            case 1801679651: {
                this.height = 16;
                this.width = 16;
                this.depth = 1;
                this.maskdepth = 1;
                break;
            }
            case 1801679668: {
                this.height = 16;
                this.width = 16;
                this.depth = 4;
                this.maskdepth = 0;
                break;
            }
            case 1801679672: {
                this.height = 16;
                this.width = 16;
                this.depth = 8;
                this.maskdepth = 0;
            }
        }
    }

    public int getImageSize() {
        switch (this.depth) {
            case 1: {
                return this.width * this.height / 8;
            }
            case 2: {
                return this.width * this.height / 4;
            }
            case 4: {
                return this.width * this.height / 2;
            }
            case 8: {
                return this.width * this.height;
            }
            case 32: {
                int i = 0;
                int j = 0;
                while (i < this.data.length && j < this.width * this.height * 3) {
                    int run = this.data[i] & 0xFF;
                    if (run < 128) {
                        i += run + 1;
                        j += run + 1;
                    } else {
                        ++i;
                        j += run - 125;
                    }
                    ++i;
                }
                return i;
            }
        }
        return 0;
    }

    public int getMaskSize() {
        switch (this.maskdepth) {
            case 1: {
                return this.width * this.height / 8;
            }
            case 2: {
                return this.width * this.height / 4;
            }
            case 4: {
                return this.width * this.height / 2;
            }
            case 8: {
                return this.width * this.height;
            }
        }
        return 0;
    }

    public Image getImage() {
        if (this.depth == 32) {
            int k;
            byte[] stuff = new byte[this.width * this.height * 3];
            int[] pixels = new int[this.width * this.height];
            int i = 0;
            int j = 0;
            while (i < this.data.length && j < stuff.length) {
                int run = this.data[i] & 0xFF;
                if (run < 128) {
                    k = 0;
                    while (k <= run && j < stuff.length) {
                        stuff[j++] = this.data[++i];
                        ++k;
                    }
                } else {
                    ++i;
                    k = 0;
                    while (k < run - 125 && j < stuff.length) {
                        stuff[j++] = this.data[i];
                        ++k;
                    }
                }
                ++i;
            }
            i = 0;
            j = this.width * this.height;
            k = this.width * this.height * 2;
            while (i < pixels.length) {
                int r = stuff[i] & 0xFF;
                int g = stuff[j] & 0xFF;
                int b = stuff[k] & 0xFF;
                pixels[i] = 0xFF000000 | r << 16 | g << 8 | b;
                ++i;
                ++j;
                ++k;
            }
            BufferedImage img = new BufferedImage(this.width, this.height, 2);
            img.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            return img;
        }
        int[] pixels = new int[this.width * this.height];
        switch (this.depth) {
            case 1: {
                int i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
                    pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
                    pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
                    pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
                    pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
                    pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
                    pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
                    pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
                    ++i;
                    j += 8;
                }
                break;
            }
            case 2: {
                int i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0xC0) >> 6];
                    pixels[j + 1] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0x30) >> 4];
                    pixels[j + 2] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0xC) >> 2];
                    pixels[j + 3] = PICTUtilities.COLORS_2BIT[(this.data[i] & 3) >> 0];
                    ++i;
                    j += 4;
                }
                break;
            }
            case 4: {
                int i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_4BIT[(this.data[i] & 0xF0) >> 4];
                    pixels[j + 1] = PICTUtilities.COLORS_4BIT[(this.data[i] & 0xF) >> 0];
                    ++i;
                    j += 2;
                }
                break;
            }
            case 8: {
                int i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j] = PICTUtilities.COLORS_8BIT[this.data[i] & 0xFF];
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                return null;
            }
        }
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        img.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        return img;
    }

    public Image getImageWithMask(IconResource mask) {
        int i;
        if (this.width != mask.width && this.height != mask.height) {
            return null;
        }
        int[] alphas = mask.getMaskAlphaValues();
        if (alphas == null || alphas.length < this.width * this.height) {
            return null;
        }
        if (this.depth == 32) {
            int k;
            byte[] stuff = new byte[this.width * this.height * 3];
            int[] pixels = new int[this.width * this.height];
            int i2 = 0;
            int j = 0;
            while (i2 < this.data.length && j < stuff.length) {
                int run = this.data[i2] & 0xFF;
                if (run < 128) {
                    k = 0;
                    while (k <= run && j < stuff.length) {
                        stuff[j++] = this.data[++i2];
                        ++k;
                    }
                } else {
                    ++i2;
                    k = 0;
                    while (k < run - 125 && j < stuff.length) {
                        stuff[j++] = this.data[i2];
                        ++k;
                    }
                }
                ++i2;
            }
            i2 = 0;
            j = this.width * this.height;
            k = this.width * this.height * 2;
            while (i2 < pixels.length) {
                int r = stuff[i2] & 0xFF;
                int g = stuff[j] & 0xFF;
                int b = stuff[k] & 0xFF;
                pixels[i2] = alphas[i2] << 24 | r << 16 | g << 8 | b;
                ++i2;
                ++j;
                ++k;
            }
            BufferedImage img = new BufferedImage(this.width, this.height, 2);
            img.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            return img;
        }
        int[] pixels = new int[this.width * this.height];
        switch (this.depth) {
            case 1: {
                i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x80) >> 7];
                    pixels[j + 1] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x40) >> 6];
                    pixels[j + 2] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x20) >> 5];
                    pixels[j + 3] = PICTUtilities.COLORS_1BIT[(this.data[i] & 0x10) >> 4];
                    pixels[j + 4] = PICTUtilities.COLORS_1BIT[(this.data[i] & 8) >> 3];
                    pixels[j + 5] = PICTUtilities.COLORS_1BIT[(this.data[i] & 4) >> 2];
                    pixels[j + 6] = PICTUtilities.COLORS_1BIT[(this.data[i] & 2) >> 1];
                    pixels[j + 7] = PICTUtilities.COLORS_1BIT[(this.data[i] & 1) >> 0];
                    ++i;
                    j += 8;
                }
                break;
            }
            case 2: {
                i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0xC0) >> 6];
                    pixels[j + 1] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0x30) >> 4];
                    pixels[j + 2] = PICTUtilities.COLORS_2BIT[(this.data[i] & 0xC) >> 2];
                    pixels[j + 3] = PICTUtilities.COLORS_2BIT[(this.data[i] & 3) >> 0];
                    ++i;
                    j += 4;
                }
                break;
            }
            case 4: {
                i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = PICTUtilities.COLORS_4BIT[(this.data[i] & 0xF0) >> 4];
                    pixels[j + 1] = PICTUtilities.COLORS_4BIT[(this.data[i] & 0xF) >> 0];
                    ++i;
                    j += 2;
                }
                break;
            }
            case 8: {
                i = 0;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j] = PICTUtilities.COLORS_8BIT[this.data[i] & 0xFF];
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                return null;
            }
        }
        i = 0;
        while (i < pixels.length) {
            pixels[i] = alphas[i] << 24 | pixels[i] & 0xFFFFFF;
            ++i;
        }
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        img.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        return img;
    }

    public int[] getMaskAlphaValues() {
        int[] alphas = new int[this.width * this.height];
        int o = this.getImageSize();
        switch (this.maskdepth) {
            case 1: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < alphas.length) {
                    alphas[j + 0] = ((this.data[i] & 0x80) >> 7) * 255;
                    alphas[j + 1] = ((this.data[i] & 0x40) >> 6) * 255;
                    alphas[j + 2] = ((this.data[i] & 0x20) >> 5) * 255;
                    alphas[j + 3] = ((this.data[i] & 0x10) >> 4) * 255;
                    alphas[j + 4] = ((this.data[i] & 8) >> 3) * 255;
                    alphas[j + 5] = ((this.data[i] & 4) >> 2) * 255;
                    alphas[j + 6] = ((this.data[i] & 2) >> 1) * 255;
                    alphas[j + 7] = ((this.data[i] & 1) >> 0) * 255;
                    ++i;
                    j += 8;
                }
                break;
            }
            case 2: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < alphas.length) {
                    alphas[j + 0] = ((this.data[i] & 0xC0) >> 6) * 85;
                    alphas[j + 1] = ((this.data[i] & 0x30) >> 4) * 85;
                    alphas[j + 2] = ((this.data[i] & 0xC) >> 2) * 85;
                    alphas[j + 3] = ((this.data[i] & 3) >> 0) * 85;
                    ++i;
                    j += 4;
                }
                break;
            }
            case 4: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < alphas.length) {
                    alphas[j + 0] = ((this.data[i] & 0xF0) >> 4) * 17;
                    alphas[j + 1] = ((this.data[i] & 0xF) >> 0) * 17;
                    ++i;
                    j += 2;
                }
                break;
            }
            case 8: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < alphas.length) {
                    alphas[j] = this.data[i] & 0xFF;
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return alphas;
    }

    public Image getMask() {
        int[] pixels = new int[this.width * this.height];
        int o = this.getImageSize();
        switch (this.maskdepth) {
            case 1: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = ((this.data[i] & 0x80) >> 7) * 255 << 24;
                    pixels[j + 1] = ((this.data[i] & 0x40) >> 6) * 255 << 24;
                    pixels[j + 2] = ((this.data[i] & 0x20) >> 5) * 255 << 24;
                    pixels[j + 3] = ((this.data[i] & 0x10) >> 4) * 255 << 24;
                    pixels[j + 4] = ((this.data[i] & 8) >> 3) * 255 << 24;
                    pixels[j + 5] = ((this.data[i] & 4) >> 2) * 255 << 24;
                    pixels[j + 6] = ((this.data[i] & 2) >> 1) * 255 << 24;
                    pixels[j + 7] = ((this.data[i] & 1) >> 0) * 255 << 24;
                    ++i;
                    j += 8;
                }
                break;
            }
            case 2: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = ((this.data[i] & 0xC0) >> 6) * 85 << 24;
                    pixels[j + 1] = ((this.data[i] & 0x30) >> 4) * 85 << 24;
                    pixels[j + 2] = ((this.data[i] & 0xC) >> 2) * 85 << 24;
                    pixels[j + 3] = ((this.data[i] & 3) >> 0) * 85 << 24;
                    ++i;
                    j += 4;
                }
                break;
            }
            case 4: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j + 0] = ((this.data[i] & 0xF0) >> 4) * 17 << 24;
                    pixels[j + 1] = ((this.data[i] & 0xF) >> 0) * 17 << 24;
                    ++i;
                    j += 2;
                }
                break;
            }
            case 8: {
                int i = o;
                int j = 0;
                while (i < this.data.length && j < pixels.length) {
                    pixels[j] = (this.data[i] & 0xFF) << 24;
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                return null;
            }
        }
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        img.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        return img;
    }
}

