/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class FPUtilities {
    private FPUtilities() {
    }

    public static int optimalSignWidth(int floatWidth) {
        return floatWidth > 0 ? 1 : 0;
    }

    public static int optimalExponentWidth(int floatWidth) {
        if (floatWidth < 2) {
            return 0;
        }
        if (floatWidth < 4) {
            return 1;
        }
        if (floatWidth < 6) {
            return 2;
        }
        if (floatWidth < 8) {
            return 3;
        }
        if (floatWidth < 12) {
            return 4;
        }
        if (floatWidth < 20) {
            return 5;
        }
        if (floatWidth < 24) {
            return 6;
        }
        if (floatWidth < 32) {
            return 7;
        }
        if (floatWidth < 48) {
            return 8;
        }
        if (floatWidth < 56) {
            return 9;
        }
        if (floatWidth < 64) {
            return 10;
        }
        if (floatWidth < 80) {
            return 11;
        }
        if (floatWidth < 96) {
            return 12;
        }
        if (floatWidth < 112) {
            return 13;
        }
        if (floatWidth < 128) {
            return 14;
        }
        if (floatWidth < 160) {
            return 15;
        }
        if (floatWidth < 192) {
            return 16;
        }
        if (floatWidth < 224) {
            return 17;
        }
        if (floatWidth < 256) {
            return 18;
        }
        if (floatWidth < 320) {
            return 19;
        }
        if (floatWidth < 384) {
            return 20;
        }
        if (floatWidth < 448) {
            return 21;
        }
        if (floatWidth < 512) {
            return 22;
        }
        return 23;
    }

    public static int optimalMantissaWidth(int floatWidth) {
        return floatWidth > 2 ? floatWidth - FPUtilities.optimalExponentWidth(floatWidth) - 1 : 0;
    }

    public static int optimalBias(int exponentWidth) {
        return (1 << exponentWidth - 1) - 1;
    }

    public static BigInteger[] splitFloat(BigInteger rawFloat, int signWidth, int exponentWidth, int mantissaWidth) {
        BigInteger rawSign = rawFloat.shiftRight(exponentWidth + mantissaWidth).and(BigInteger.ONE.shiftLeft(signWidth).subtract(BigInteger.ONE));
        BigInteger rawExponent = rawFloat.shiftRight(mantissaWidth).and(BigInteger.ONE.shiftLeft(exponentWidth).subtract(BigInteger.ONE));
        BigInteger rawMantissa = rawFloat.and(BigInteger.ONE.shiftLeft(mantissaWidth).subtract(BigInteger.ONE));
        return new BigInteger[]{rawSign, rawExponent, rawMantissa};
    }

    public static BigInteger joinFloat(BigInteger rawSign, BigInteger rawExponent, BigInteger rawMantissa, int signWidth, int exponentWidth, int mantissaWidth) {
        return rawSign.and(BigInteger.ONE.shiftLeft(signWidth).subtract(BigInteger.ONE)).shiftLeft(exponentWidth + mantissaWidth).or(rawExponent.and(BigInteger.ONE.shiftLeft(exponentWidth).subtract(BigInteger.ONE)).shiftLeft(mantissaWidth)).or(rawMantissa.and(BigInteger.ONE.shiftLeft(mantissaWidth).subtract(BigInteger.ONE)));
    }

    public static Number decodeFloat(BigInteger rawSign, BigInteger rawExponent, BigInteger rawMantissa, int signWidth, int exponentWidth, int mantissaWidth, int bias, MathContext mc) {
        if (signWidth < 0 || signWidth > 1 || exponentWidth < 0 || mantissaWidth < 0) {
            throw new IllegalArgumentException();
        }
        if (rawExponent.compareTo(BigInteger.ZERO) == 0) {
            if (rawMantissa.compareTo(BigInteger.ZERO) == 0) {
                boolean isNegative = rawSign.compareTo(BigInteger.ZERO) != 0;
                return isNegative ? -0.0 : 0.0;
            }
            boolean isNegative = rawSign.compareTo(BigInteger.ZERO) != 0;
            int negativeExponent = bias + mantissaWidth - 1;
            BigDecimal mantissa = new BigDecimal(rawMantissa);
            if (negativeExponent < 0) {
                BigDecimal multiplier = BigDecimal.valueOf(2L).pow(-negativeExponent);
                return isNegative ? mantissa.multiply(multiplier, mc).negate() : mantissa.multiply(multiplier, mc);
            }
            BigDecimal multiplier = BigDecimal.valueOf(2L).pow(negativeExponent);
            return isNegative ? mantissa.divide(multiplier, mc).negate() : mantissa.divide(multiplier, mc);
        }
        if (rawExponent.compareTo(BigInteger.ONE.shiftLeft(exponentWidth).subtract(BigInteger.ONE)) == 0) {
            if (rawMantissa.compareTo(BigInteger.ZERO) == 0) {
                boolean isNegative = rawSign.compareTo(BigInteger.ZERO) != 0;
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            boolean isNegative = rawSign.compareTo(BigInteger.ZERO) != 0;
            boolean isQuietNaN = rawMantissa.testBit(mantissaWidth - 1);
            BigInteger mantissa = rawMantissa.clearBit(mantissaWidth - 1);
            long rawDouble = 0x7FF0000000000000L;
            if (isNegative) {
                rawDouble |= Long.MIN_VALUE;
            }
            if (isQuietNaN) {
                rawDouble |= 0x8000000000000L;
            }
            return Double.longBitsToDouble(rawDouble |= mantissa.longValue() & 0x7FFFFFFFFFFFFL);
        }
        boolean isNegative = rawSign.compareTo(BigInteger.ZERO) != 0;
        int negativeExponent = bias + mantissaWidth - rawExponent.intValue();
        BigDecimal mantissa = new BigDecimal(rawMantissa.setBit(mantissaWidth));
        if (negativeExponent < 0) {
            BigDecimal multiplier = BigDecimal.valueOf(2L).pow(-negativeExponent);
            return isNegative ? mantissa.multiply(multiplier, mc).negate() : mantissa.multiply(multiplier, mc);
        }
        BigDecimal multiplier = BigDecimal.valueOf(2L).pow(negativeExponent);
        return isNegative ? mantissa.divide(multiplier, mc).negate() : mantissa.divide(multiplier, mc);
    }

    public static BigInteger[] encodeFloat(Number v, int signWidth, int exponentWidth, int mantissaWidth, int bias, MathContext mc) {
        if (signWidth < 0 || signWidth > 1 || exponentWidth < 0 || mantissaWidth < 0) {
            throw new IllegalArgumentException();
        }
        if (v instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)v;
            if (d.compareTo(BigDecimal.ZERO) == 0) {
                return FPUtilities.encodeZero(false, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(d, signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        if (v instanceof BigInteger) {
            BigInteger i = (BigInteger)v;
            if (i.compareTo(BigInteger.ZERO) == 0) {
                return FPUtilities.encodeZero(false, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(new BigDecimal(i), signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        if (v instanceof Double) {
            double d = v.doubleValue();
            if (Double.isNaN(d)) {
                long rawDouble = Double.doubleToRawLongBits(d);
                boolean isNegative = (rawDouble & Long.MIN_VALUE) != 0L;
                boolean isQuietNaN = (rawDouble & 0x8000000000000L) != 0L;
                long diagnosticCode = rawDouble & 0x7FFFFFFFFFFFFL;
                return FPUtilities.encodeNaN(isNegative, isQuietNaN, diagnosticCode, signWidth, exponentWidth, mantissaWidth);
            }
            if (Double.isInfinite(d)) {
                return FPUtilities.encodeInfinity(d < 0.0, signWidth, exponentWidth, mantissaWidth);
            }
            if (d == 0.0) {
                long rawDouble = Double.doubleToRawLongBits(d);
                boolean isNegative = (rawDouble & Long.MIN_VALUE) != 0L;
                return FPUtilities.encodeZero(isNegative, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(d), signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        if (v instanceof Float) {
            float f = v.floatValue();
            if (Float.isNaN(f)) {
                int rawFloat = Float.floatToRawIntBits(f);
                boolean isNegative = (rawFloat & Integer.MIN_VALUE) != 0;
                boolean isQuietNaN = (rawFloat & 0x400000) != 0;
                int diagnosticCode = rawFloat & 0x3FFFFF;
                return FPUtilities.encodeNaN(isNegative, isQuietNaN, diagnosticCode, signWidth, exponentWidth, mantissaWidth);
            }
            if (Float.isInfinite(f)) {
                return FPUtilities.encodeInfinity(f < 0.0f, signWidth, exponentWidth, mantissaWidth);
            }
            if (f == 0.0f) {
                int rawFloat = Float.floatToRawIntBits(f);
                boolean isNegative = (rawFloat & Integer.MIN_VALUE) != 0;
                return FPUtilities.encodeZero(isNegative, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(new BigDecimal(Float.toString(f)), signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        if (v instanceof Long) {
            long l = v.longValue();
            if (l == 0L) {
                return FPUtilities.encodeZero(false, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(l), signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        if (v instanceof Integer || v instanceof Short || v instanceof Byte) {
            int i = v.intValue();
            if (i == 0) {
                return FPUtilities.encodeZero(false, signWidth, exponentWidth, mantissaWidth);
            }
            return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(i), signWidth, exponentWidth, mantissaWidth, bias, mc);
        }
        double d = v.doubleValue();
        if (Double.isNaN(d)) {
            long rawDouble = Double.doubleToRawLongBits(d);
            boolean isNegative = (rawDouble & Long.MIN_VALUE) != 0L;
            boolean isQuietNaN = (rawDouble & 0x8000000000000L) != 0L;
            long diagnosticCode = rawDouble & 0x7FFFFFFFFFFFFL;
            return FPUtilities.encodeNaN(isNegative, isQuietNaN, diagnosticCode, signWidth, exponentWidth, mantissaWidth);
        }
        if (Double.isInfinite(d)) {
            return FPUtilities.encodeInfinity(d < 0.0, signWidth, exponentWidth, mantissaWidth);
        }
        if (d == 0.0) {
            long rawDouble = Double.doubleToRawLongBits(d);
            boolean isNegative = (rawDouble & Long.MIN_VALUE) != 0L;
            return FPUtilities.encodeZero(isNegative, signWidth, exponentWidth, mantissaWidth);
        }
        return FPUtilities.encodeFiniteNonZero(BigDecimal.valueOf(d), signWidth, exponentWidth, mantissaWidth, bias, mc);
    }

    private static BigInteger[] encodeNaN(boolean isNegative, boolean isQuietNaN, long diagnosticCode, int signWidth, int exponentWidth, int mantissaWidth) {
        BigInteger mantissa = BigInteger.valueOf(diagnosticCode);
        mantissa = isQuietNaN ? mantissa.setBit(mantissaWidth - 1) : mantissa.clearBit(mantissaWidth - 1);
        return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), mantissa};
    }

    private static BigInteger[] encodeInfinity(boolean isNegative, int signWidth, int exponentWidth, int mantissaWidth) {
        return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), BigInteger.ZERO};
    }

    private static BigInteger[] encodeZero(boolean isNegative, int signWidth, int exponentWidth, int mantissaWidth) {
        return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
    }

    private static BigInteger[] encodeFiniteNonZero(BigDecimal v, int signWidth, int exponentWidth, int mantissaWidth, int bias, MathContext mc) {
        BigInteger mantissa;
        boolean isNegative = v.compareTo(BigDecimal.ZERO) < 0;
        v = v.abs();
        int exponent = FPUtilities.ilog2(v, mc) + bias;
        while (true) {
            BigDecimal multiplier;
            int negativeExponent;
            if (exponent >= (1 << exponentWidth) - 1) {
                return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ONE.negate(), BigInteger.ZERO};
            }
            if (exponent <= 0) {
                negativeExponent = bias + mantissaWidth - 1;
                if (negativeExponent < 0) {
                    multiplier = BigDecimal.valueOf(2L).pow(-negativeExponent);
                    mantissa = v.divide(multiplier, mc).setScale(0, mc.getRoundingMode()).toBigIntegerExact();
                } else {
                    multiplier = BigDecimal.valueOf(2L).pow(negativeExponent);
                    mantissa = v.multiply(multiplier, mc).setScale(0, mc.getRoundingMode()).toBigIntegerExact();
                }
                if (mantissa.testBit(mantissaWidth)) {
                    ++exponent;
                    continue;
                }
                return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.ZERO, mantissa};
            }
            negativeExponent = bias + mantissaWidth - exponent;
            if (negativeExponent < 0) {
                multiplier = BigDecimal.valueOf(2L).pow(-negativeExponent);
                mantissa = v.divide(multiplier, mc).setScale(0, mc.getRoundingMode()).toBigIntegerExact();
            } else {
                multiplier = BigDecimal.valueOf(2L).pow(negativeExponent);
                mantissa = v.multiply(multiplier, mc).setScale(0, mc.getRoundingMode()).toBigIntegerExact();
            }
            if (mantissa.testBit(mantissaWidth)) break;
            if (mantissa.testBit(mantissaWidth + 1)) {
                ++exponent;
                continue;
            }
            --exponent;
        }
        return new BigInteger[]{isNegative ? BigInteger.ONE.negate() : BigInteger.ZERO, BigInteger.valueOf(exponent), mantissa};
    }

    private static int ilog2(BigDecimal v, MathContext mc) {
        int approximation = (int)((((long)v.precision() - (long)v.scale() - 1L) * 100000L + (long)(v.unscaledValue().toString().charAt(0) - 48) * 10000L) / 30103L);
        approximation += 3;
        while (true) {
            BigDecimal power = BigDecimal.valueOf(2L).pow(Math.abs(approximation));
            if (approximation < 0) {
                power = BigDecimal.ONE.divide(power, mc);
            }
            if (power.compareTo(v) <= 0) {
                return approximation;
            }
            --approximation;
        }
    }
}

